goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__42832){
var map__42833 = p__42832;
var map__42833__$1 = (((((!((map__42833 == null))))?(((((map__42833.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42833.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42833):map__42833);
var m = map__42833__$1;
var n = cljs.core.get.call(null,map__42833__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__42833__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4185__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return [(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__42838_43053 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__42839_43054 = null;
var count__42840_43055 = (0);
var i__42841_43056 = (0);
while(true){
if((i__42841_43056 < count__42840_43055)){
var f_43059 = cljs.core._nth.call(null,chunk__42839_43054,i__42841_43056);
cljs.core.println.call(null,"  ",f_43059);


var G__43063 = seq__42838_43053;
var G__43064 = chunk__42839_43054;
var G__43065 = count__42840_43055;
var G__43066 = (i__42841_43056 + (1));
seq__42838_43053 = G__43063;
chunk__42839_43054 = G__43064;
count__42840_43055 = G__43065;
i__42841_43056 = G__43066;
continue;
} else {
var temp__5735__auto___43068 = cljs.core.seq.call(null,seq__42838_43053);
if(temp__5735__auto___43068){
var seq__42838_43069__$1 = temp__5735__auto___43068;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42838_43069__$1)){
var c__4609__auto___43071 = cljs.core.chunk_first.call(null,seq__42838_43069__$1);
var G__43072 = cljs.core.chunk_rest.call(null,seq__42838_43069__$1);
var G__43073 = c__4609__auto___43071;
var G__43074 = cljs.core.count.call(null,c__4609__auto___43071);
var G__43075 = (0);
seq__42838_43053 = G__43072;
chunk__42839_43054 = G__43073;
count__42840_43055 = G__43074;
i__42841_43056 = G__43075;
continue;
} else {
var f_43076 = cljs.core.first.call(null,seq__42838_43069__$1);
cljs.core.println.call(null,"  ",f_43076);


var G__43077 = cljs.core.next.call(null,seq__42838_43069__$1);
var G__43078 = null;
var G__43079 = (0);
var G__43080 = (0);
seq__42838_43053 = G__43077;
chunk__42839_43054 = G__43078;
count__42840_43055 = G__43079;
i__42841_43056 = G__43080;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_43082 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_43082);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_43082)))?cljs.core.second.call(null,arglists_43082):arglists_43082));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__42847_43092 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__42848_43093 = null;
var count__42849_43094 = (0);
var i__42850_43095 = (0);
while(true){
if((i__42850_43095 < count__42849_43094)){
var vec__42871_43096 = cljs.core._nth.call(null,chunk__42848_43093,i__42850_43095);
var name_43097 = cljs.core.nth.call(null,vec__42871_43096,(0),null);
var map__42874_43098 = cljs.core.nth.call(null,vec__42871_43096,(1),null);
var map__42874_43099__$1 = (((((!((map__42874_43098 == null))))?(((((map__42874_43098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42874_43098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42874_43098):map__42874_43098);
var doc_43100 = cljs.core.get.call(null,map__42874_43099__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_43101 = cljs.core.get.call(null,map__42874_43099__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_43097);

cljs.core.println.call(null," ",arglists_43101);

if(cljs.core.truth_(doc_43100)){
cljs.core.println.call(null," ",doc_43100);
} else {
}


var G__43112 = seq__42847_43092;
var G__43113 = chunk__42848_43093;
var G__43114 = count__42849_43094;
var G__43115 = (i__42850_43095 + (1));
seq__42847_43092 = G__43112;
chunk__42848_43093 = G__43113;
count__42849_43094 = G__43114;
i__42850_43095 = G__43115;
continue;
} else {
var temp__5735__auto___43116 = cljs.core.seq.call(null,seq__42847_43092);
if(temp__5735__auto___43116){
var seq__42847_43124__$1 = temp__5735__auto___43116;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42847_43124__$1)){
var c__4609__auto___43125 = cljs.core.chunk_first.call(null,seq__42847_43124__$1);
var G__43126 = cljs.core.chunk_rest.call(null,seq__42847_43124__$1);
var G__43127 = c__4609__auto___43125;
var G__43128 = cljs.core.count.call(null,c__4609__auto___43125);
var G__43129 = (0);
seq__42847_43092 = G__43126;
chunk__42848_43093 = G__43127;
count__42849_43094 = G__43128;
i__42850_43095 = G__43129;
continue;
} else {
var vec__42880_43130 = cljs.core.first.call(null,seq__42847_43124__$1);
var name_43131 = cljs.core.nth.call(null,vec__42880_43130,(0),null);
var map__42883_43132 = cljs.core.nth.call(null,vec__42880_43130,(1),null);
var map__42883_43133__$1 = (((((!((map__42883_43132 == null))))?(((((map__42883_43132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42883_43132.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42883_43132):map__42883_43132);
var doc_43134 = cljs.core.get.call(null,map__42883_43133__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_43135 = cljs.core.get.call(null,map__42883_43133__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_43131);

cljs.core.println.call(null," ",arglists_43135);

if(cljs.core.truth_(doc_43134)){
cljs.core.println.call(null," ",doc_43134);
} else {
}


var G__43142 = cljs.core.next.call(null,seq__42847_43124__$1);
var G__43143 = null;
var G__43144 = (0);
var G__43145 = (0);
seq__42847_43092 = G__43142;
chunk__42848_43093 = G__43143;
count__42849_43094 = G__43144;
i__42850_43095 = G__43145;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5735__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5735__auto__)){
var fnspec = temp__5735__auto__;
cljs.core.print.call(null,"Spec");

var seq__42886 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__42887 = null;
var count__42888 = (0);
var i__42889 = (0);
while(true){
if((i__42889 < count__42888)){
var role = cljs.core._nth.call(null,chunk__42887,i__42889);
var temp__5735__auto___43168__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___43168__$1)){
var spec_43169 = temp__5735__auto___43168__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_43169));
} else {
}


var G__43170 = seq__42886;
var G__43171 = chunk__42887;
var G__43172 = count__42888;
var G__43173 = (i__42889 + (1));
seq__42886 = G__43170;
chunk__42887 = G__43171;
count__42888 = G__43172;
i__42889 = G__43173;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__42886);
if(temp__5735__auto____$1){
var seq__42886__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42886__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__42886__$1);
var G__43190 = cljs.core.chunk_rest.call(null,seq__42886__$1);
var G__43191 = c__4609__auto__;
var G__43192 = cljs.core.count.call(null,c__4609__auto__);
var G__43193 = (0);
seq__42886 = G__43190;
chunk__42887 = G__43191;
count__42888 = G__43192;
i__42889 = G__43193;
continue;
} else {
var role = cljs.core.first.call(null,seq__42886__$1);
var temp__5735__auto___43196__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___43196__$2)){
var spec_43200 = temp__5735__auto___43196__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_43200));
} else {
}


var G__43205 = cljs.core.next.call(null,seq__42886__$1);
var G__43206 = null;
var G__43207 = (0);
var G__43208 = (0);
seq__42886 = G__43205;
chunk__42887 = G__43206;
count__42888 = G__43207;
i__42889 = G__43208;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof Error))?cljs.core.symbol.call(null,"js",t.name):null
))], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var ed = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__43217 = cljs.core.conj.call(null,via,t);
var G__43218 = cljs.core.ex_cause.call(null,t);
via = G__43217;
t = G__43218;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var root_msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var data = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5735__auto__)){
var phase = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__42919 = datafied_throwable;
var map__42919__$1 = (((((!((map__42919 == null))))?(((((map__42919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42919.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42919):map__42919);
var via = cljs.core.get.call(null,map__42919__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__42919__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__42919__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__42920 = cljs.core.last.call(null,via);
var map__42920__$1 = (((((!((map__42920 == null))))?(((((map__42920.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42920.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42920):map__42920);
var type = cljs.core.get.call(null,map__42920__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__42920__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__42920__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__42921 = data;
var map__42921__$1 = (((((!((map__42921 == null))))?(((((map__42921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42921):map__42921);
var problems = cljs.core.get.call(null,map__42921__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__42921__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__42921__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__42922 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__42922__$1 = (((((!((map__42922 == null))))?(((((map__42922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42922.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42922):map__42922);
var top_data = map__42922__$1;
var source = cljs.core.get.call(null,map__42922__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__42947 = phase;
var G__42947__$1 = (((G__42947 instanceof cljs.core.Keyword))?G__42947.fqn:null);
switch (G__42947__$1) {
case "read-source":
var map__42948 = data;
var map__42948__$1 = (((((!((map__42948 == null))))?(((((map__42948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42948.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42948):map__42948);
var line = cljs.core.get.call(null,map__42948__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__42948__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__42951 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__42951__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__42951,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__42951);
var G__42951__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__42951__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__42951__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__42951__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__42951__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__42955 = top_data;
var G__42955__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__42955,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__42955);
var G__42955__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__42955__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__42955__$1);
var G__42955__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__42955__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__42955__$2);
var G__42955__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__42955__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__42955__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__42955__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__42955__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__42961 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__42961,(0),null);
var method = cljs.core.nth.call(null,vec__42961,(1),null);
var file = cljs.core.nth.call(null,vec__42961,(2),null);
var line = cljs.core.nth.call(null,vec__42961,(3),null);
var G__42966 = top_data;
var G__42966__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__42966,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__42966);
var G__42966__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__42966__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__42966__$1);
var G__42966__$3 = (cljs.core.truth_((function (){var and__4174__auto__ = source__$1;
if(cljs.core.truth_(and__4174__auto__)){
return method;
} else {
return and__4174__auto__;
}
})())?cljs.core.assoc.call(null,G__42966__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__42966__$2);
var G__42966__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__42966__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__42966__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__42966__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__42966__$4;
}

break;
case "execution":
var vec__42971 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__42971,(0),null);
var method = cljs.core.nth.call(null,vec__42971,(1),null);
var file = cljs.core.nth.call(null,vec__42971,(2),null);
var line = cljs.core.nth.call(null,vec__42971,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,(function (p1__42917_SHARP_){
var or__4185__auto__ = (p1__42917_SHARP_ == null);
if(or__4185__auto__){
return or__4185__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__42917_SHARP_);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4185__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return line;
}
})();
var G__42981 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__42981__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__42981,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__42981);
var G__42981__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__42981__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__42981__$1);
var G__42981__$3 = (cljs.core.truth_((function (){var or__4185__auto__ = fn;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto__ = source__$1;
if(cljs.core.truth_(and__4174__auto__)){
return method;
} else {
return and__4174__auto__;
}
}
})())?cljs.core.assoc.call(null,G__42981__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4185__auto__ = fn;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__42981__$2);
var G__42981__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__42981__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__42981__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__42981__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__42981__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42947__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__43001){
var map__43002 = p__43001;
var map__43002__$1 = (((((!((map__43002 == null))))?(((((map__43002.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43002.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43002):map__43002);
var triage_data = map__43002__$1;
var phase = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__43002__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4185__auto__ = class$;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__43017 = phase;
var G__43017__$1 = (((G__43017 instanceof cljs.core.Keyword))?G__43017.fqn:null);
switch (G__43017__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43026_43303 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43027_43304 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43028_43305 = true;
var _STAR_print_fn_STAR__temp_val__43029_43306 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43028_43305);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43029_43306);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__42995_SHARP_){
return cljs.core.dissoc.call(null,p1__42995_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43027_43304);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43026_43303);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43035_43313 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43036_43314 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43037_43315 = true;
var _STAR_print_fn_STAR__temp_val__43038_43316 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43037_43315);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43038_43316);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__42997_SHARP_){
return cljs.core.dissoc.call(null,p1__42997_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43036_43314);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43035_43313);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43017__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=cljs.repl.js.map
