goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__42200 = arguments.length;
switch (G__42200) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42208 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42208 = (function (f,blockable,meta42209){
this.f = f;
this.blockable = blockable;
this.meta42209 = meta42209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42210,meta42209__$1){
var self__ = this;
var _42210__$1 = this;
return (new cljs.core.async.t_cljs$core$async42208(self__.f,self__.blockable,meta42209__$1));
}));

(cljs.core.async.t_cljs$core$async42208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42210){
var self__ = this;
var _42210__$1 = this;
return self__.meta42209;
}));

(cljs.core.async.t_cljs$core$async42208.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42208.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42208.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async42208.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async42208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42209","meta42209",-793289505,null)], null);
}));

(cljs.core.async.t_cljs$core$async42208.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42208.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42208");

(cljs.core.async.t_cljs$core$async42208.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async42208");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42208.
 */
cljs.core.async.__GT_t_cljs$core$async42208 = (function cljs$core$async$__GT_t_cljs$core$async42208(f__$1,blockable__$1,meta42209){
return (new cljs.core.async.t_cljs$core$async42208(f__$1,blockable__$1,meta42209));
});

}

return (new cljs.core.async.t_cljs$core$async42208(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__42245 = arguments.length;
switch (G__42245) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__42260 = arguments.length;
switch (G__42260) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__42277 = arguments.length;
switch (G__42277) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_45775 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_45775);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_45775);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__42291 = arguments.length;
switch (G__42291) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___45783 = n;
var x_45784 = (0);
while(true){
if((x_45784 < n__4613__auto___45783)){
(a[x_45784] = x_45784);

var G__45788 = (x_45784 + (1));
x_45784 = G__45788;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42314 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42314 = (function (flag,meta42315){
this.flag = flag;
this.meta42315 = meta42315;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42314.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42316,meta42315__$1){
var self__ = this;
var _42316__$1 = this;
return (new cljs.core.async.t_cljs$core$async42314(self__.flag,meta42315__$1));
}));

(cljs.core.async.t_cljs$core$async42314.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42316){
var self__ = this;
var _42316__$1 = this;
return self__.meta42315;
}));

(cljs.core.async.t_cljs$core$async42314.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42314.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async42314.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42314.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async42314.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta42315","meta42315",858155282,null)], null);
}));

(cljs.core.async.t_cljs$core$async42314.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42314.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42314");

(cljs.core.async.t_cljs$core$async42314.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async42314");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42314.
 */
cljs.core.async.__GT_t_cljs$core$async42314 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async42314(flag__$1,meta42315){
return (new cljs.core.async.t_cljs$core$async42314(flag__$1,meta42315));
});

}

return (new cljs.core.async.t_cljs$core$async42314(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42332 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42332 = (function (flag,cb,meta42333){
this.flag = flag;
this.cb = cb;
this.meta42333 = meta42333;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42332.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42334,meta42333__$1){
var self__ = this;
var _42334__$1 = this;
return (new cljs.core.async.t_cljs$core$async42332(self__.flag,self__.cb,meta42333__$1));
}));

(cljs.core.async.t_cljs$core$async42332.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42334){
var self__ = this;
var _42334__$1 = this;
return self__.meta42333;
}));

(cljs.core.async.t_cljs$core$async42332.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42332.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async42332.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42332.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async42332.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta42333","meta42333",1313942822,null)], null);
}));

(cljs.core.async.t_cljs$core$async42332.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42332.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42332");

(cljs.core.async.t_cljs$core$async42332.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async42332");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42332.
 */
cljs.core.async.__GT_t_cljs$core$async42332 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async42332(flag__$1,cb__$1,meta42333){
return (new cljs.core.async.t_cljs$core$async42332(flag__$1,cb__$1,meta42333));
});

}

return (new cljs.core.async.t_cljs$core$async42332(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42355_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42355_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42356_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42356_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__45808 = (i + (1));
i = G__45808;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___45814 = arguments.length;
var i__4737__auto___45815 = (0);
while(true){
if((i__4737__auto___45815 < len__4736__auto___45814)){
args__4742__auto__.push((arguments[i__4737__auto___45815]));

var G__45817 = (i__4737__auto___45815 + (1));
i__4737__auto___45815 = G__45817;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__42376){
var map__42377 = p__42376;
var map__42377__$1 = (((((!((map__42377 == null))))?(((((map__42377.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42377.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42377):map__42377);
var opts = map__42377__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq42370){
var G__42371 = cljs.core.first.call(null,seq42370);
var seq42370__$1 = cljs.core.next.call(null,seq42370);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42371,seq42370__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__42410 = arguments.length;
switch (G__42410) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42092__auto___45840 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_42513){
var state_val_42515 = (state_42513[(1)]);
if((state_val_42515 === (7))){
var inst_42506 = (state_42513[(2)]);
var state_42513__$1 = state_42513;
var statearr_42523_45848 = state_42513__$1;
(statearr_42523_45848[(2)] = inst_42506);

(statearr_42523_45848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (1))){
var state_42513__$1 = state_42513;
var statearr_42524_45849 = state_42513__$1;
(statearr_42524_45849[(2)] = null);

(statearr_42524_45849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (4))){
var inst_42444 = (state_42513[(7)]);
var inst_42444__$1 = (state_42513[(2)]);
var inst_42467 = (inst_42444__$1 == null);
var state_42513__$1 = (function (){var statearr_42525 = state_42513;
(statearr_42525[(7)] = inst_42444__$1);

return statearr_42525;
})();
if(cljs.core.truth_(inst_42467)){
var statearr_42527_45853 = state_42513__$1;
(statearr_42527_45853[(1)] = (5));

} else {
var statearr_42529_45854 = state_42513__$1;
(statearr_42529_45854[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (13))){
var state_42513__$1 = state_42513;
var statearr_42531_45855 = state_42513__$1;
(statearr_42531_45855[(2)] = null);

(statearr_42531_45855[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (6))){
var inst_42444 = (state_42513[(7)]);
var state_42513__$1 = state_42513;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42513__$1,(11),to,inst_42444);
} else {
if((state_val_42515 === (3))){
var inst_42508 = (state_42513[(2)]);
var state_42513__$1 = state_42513;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42513__$1,inst_42508);
} else {
if((state_val_42515 === (12))){
var state_42513__$1 = state_42513;
var statearr_42543_45858 = state_42513__$1;
(statearr_42543_45858[(2)] = null);

(statearr_42543_45858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (2))){
var state_42513__$1 = state_42513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42513__$1,(4),from);
} else {
if((state_val_42515 === (11))){
var inst_42493 = (state_42513[(2)]);
var state_42513__$1 = state_42513;
if(cljs.core.truth_(inst_42493)){
var statearr_42550_45859 = state_42513__$1;
(statearr_42550_45859[(1)] = (12));

} else {
var statearr_42551_45863 = state_42513__$1;
(statearr_42551_45863[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (9))){
var state_42513__$1 = state_42513;
var statearr_42553_45864 = state_42513__$1;
(statearr_42553_45864[(2)] = null);

(statearr_42553_45864[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (5))){
var state_42513__$1 = state_42513;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42554_45866 = state_42513__$1;
(statearr_42554_45866[(1)] = (8));

} else {
var statearr_42558_45868 = state_42513__$1;
(statearr_42558_45868[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (14))){
var inst_42504 = (state_42513[(2)]);
var state_42513__$1 = state_42513;
var statearr_42559_45869 = state_42513__$1;
(statearr_42559_45869[(2)] = inst_42504);

(statearr_42559_45869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (10))){
var inst_42490 = (state_42513[(2)]);
var state_42513__$1 = state_42513;
var statearr_42565_45870 = state_42513__$1;
(statearr_42565_45870[(2)] = inst_42490);

(statearr_42565_45870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42515 === (8))){
var inst_42479 = cljs.core.async.close_BANG_.call(null,to);
var state_42513__$1 = state_42513;
var statearr_42567_45872 = state_42513__$1;
(statearr_42567_45872[(2)] = inst_42479);

(statearr_42567_45872[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_42569 = [null,null,null,null,null,null,null,null];
(statearr_42569[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_42569[(1)] = (1));

return statearr_42569;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_42513){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_42513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e42570){var ex__41858__auto__ = e42570;
var statearr_42571_45874 = state_42513;
(statearr_42571_45874[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_42513[(4)]))){
var statearr_42572_45876 = state_42513;
(statearr_42572_45876[(1)] = cljs.core.first.call(null,(state_42513[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45877 = state_42513;
state_42513 = G__45877;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_42513){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_42513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_42582 = f__42093__auto__();
(statearr_42582[(6)] = c__42092__auto___45840);

return statearr_42582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__42584){
var vec__42585 = p__42584;
var v = cljs.core.nth.call(null,vec__42585,(0),null);
var p = cljs.core.nth.call(null,vec__42585,(1),null);
var job = vec__42585;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__42092__auto___45883 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_42595){
var state_val_42597 = (state_42595[(1)]);
if((state_val_42597 === (1))){
var state_42595__$1 = state_42595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42595__$1,(2),res,v);
} else {
if((state_val_42597 === (2))){
var inst_42592 = (state_42595[(2)]);
var inst_42593 = cljs.core.async.close_BANG_.call(null,res);
var state_42595__$1 = (function (){var statearr_42601 = state_42595;
(statearr_42601[(7)] = inst_42592);

return statearr_42601;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42595__$1,inst_42593);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0 = (function (){
var statearr_42602 = [null,null,null,null,null,null,null,null];
(statearr_42602[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__);

(statearr_42602[(1)] = (1));

return statearr_42602;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1 = (function (state_42595){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_42595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e42603){var ex__41858__auto__ = e42603;
var statearr_42604_45890 = state_42595;
(statearr_42604_45890[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_42595[(4)]))){
var statearr_42605_45891 = state_42595;
(statearr_42605_45891[(1)] = cljs.core.first.call(null,(state_42595[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45892 = state_42595;
state_42595 = G__45892;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = function(state_42595){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1.call(this,state_42595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_42608 = f__42093__auto__();
(statearr_42608[(6)] = c__42092__auto___45883);

return statearr_42608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__42632){
var vec__42633 = p__42632;
var v = cljs.core.nth.call(null,vec__42633,(0),null);
var p = cljs.core.nth.call(null,vec__42633,(1),null);
var job = vec__42633;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___45898 = n;
var __45899 = (0);
while(true){
if((__45899 < n__4613__auto___45898)){
var G__42646_45901 = type;
var G__42646_45902__$1 = (((G__42646_45901 instanceof cljs.core.Keyword))?G__42646_45901.fqn:null);
switch (G__42646_45902__$1) {
case "compute":
var c__42092__auto___45905 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__45899,c__42092__auto___45905,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async){
return (function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = ((function (__45899,c__42092__auto___45905,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async){
return (function (state_42662){
var state_val_42663 = (state_42662[(1)]);
if((state_val_42663 === (1))){
var state_42662__$1 = state_42662;
var statearr_42669_45907 = state_42662__$1;
(statearr_42669_45907[(2)] = null);

(statearr_42669_45907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42663 === (2))){
var state_42662__$1 = state_42662;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42662__$1,(4),jobs);
} else {
if((state_val_42663 === (3))){
var inst_42660 = (state_42662[(2)]);
var state_42662__$1 = state_42662;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42662__$1,inst_42660);
} else {
if((state_val_42663 === (4))){
var inst_42652 = (state_42662[(2)]);
var inst_42653 = process(inst_42652);
var state_42662__$1 = state_42662;
if(cljs.core.truth_(inst_42653)){
var statearr_42670_45915 = state_42662__$1;
(statearr_42670_45915[(1)] = (5));

} else {
var statearr_42671_45916 = state_42662__$1;
(statearr_42671_45916[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42663 === (5))){
var state_42662__$1 = state_42662;
var statearr_42673_45920 = state_42662__$1;
(statearr_42673_45920[(2)] = null);

(statearr_42673_45920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42663 === (6))){
var state_42662__$1 = state_42662;
var statearr_42674_45922 = state_42662__$1;
(statearr_42674_45922[(2)] = null);

(statearr_42674_45922[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42663 === (7))){
var inst_42658 = (state_42662[(2)]);
var state_42662__$1 = state_42662;
var statearr_42675_45924 = state_42662__$1;
(statearr_42675_45924[(2)] = inst_42658);

(statearr_42675_45924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__45899,c__42092__auto___45905,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async))
;
return ((function (__45899,switch__41854__auto__,c__42092__auto___45905,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0 = (function (){
var statearr_42676 = [null,null,null,null,null,null,null];
(statearr_42676[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__);

(statearr_42676[(1)] = (1));

return statearr_42676;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1 = (function (state_42662){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_42662);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e42678){var ex__41858__auto__ = e42678;
var statearr_42680_45929 = state_42662;
(statearr_42680_45929[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_42662[(4)]))){
var statearr_42681_45930 = state_42662;
(statearr_42681_45930[(1)] = cljs.core.first.call(null,(state_42662[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45931 = state_42662;
state_42662 = G__45931;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = function(state_42662){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1.call(this,state_42662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__;
})()
;})(__45899,switch__41854__auto__,c__42092__auto___45905,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async))
})();
var state__42094__auto__ = (function (){var statearr_42685 = f__42093__auto__();
(statearr_42685[(6)] = c__42092__auto___45905);

return statearr_42685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
});})(__45899,c__42092__auto___45905,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async))
);


break;
case "async":
var c__42092__auto___45937 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__45899,c__42092__auto___45937,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async){
return (function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = ((function (__45899,c__42092__auto___45937,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async){
return (function (state_42705){
var state_val_42706 = (state_42705[(1)]);
if((state_val_42706 === (1))){
var state_42705__$1 = state_42705;
var statearr_42707_45941 = state_42705__$1;
(statearr_42707_45941[(2)] = null);

(statearr_42707_45941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (2))){
var state_42705__$1 = state_42705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42705__$1,(4),jobs);
} else {
if((state_val_42706 === (3))){
var inst_42703 = (state_42705[(2)]);
var state_42705__$1 = state_42705;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42705__$1,inst_42703);
} else {
if((state_val_42706 === (4))){
var inst_42692 = (state_42705[(2)]);
var inst_42693 = async(inst_42692);
var state_42705__$1 = state_42705;
if(cljs.core.truth_(inst_42693)){
var statearr_42713_45957 = state_42705__$1;
(statearr_42713_45957[(1)] = (5));

} else {
var statearr_42714_45958 = state_42705__$1;
(statearr_42714_45958[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (5))){
var state_42705__$1 = state_42705;
var statearr_42717_45961 = state_42705__$1;
(statearr_42717_45961[(2)] = null);

(statearr_42717_45961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (6))){
var state_42705__$1 = state_42705;
var statearr_42723_45967 = state_42705__$1;
(statearr_42723_45967[(2)] = null);

(statearr_42723_45967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (7))){
var inst_42701 = (state_42705[(2)]);
var state_42705__$1 = state_42705;
var statearr_42725_45968 = state_42705__$1;
(statearr_42725_45968[(2)] = inst_42701);

(statearr_42725_45968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__45899,c__42092__auto___45937,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async))
;
return ((function (__45899,switch__41854__auto__,c__42092__auto___45937,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0 = (function (){
var statearr_42733 = [null,null,null,null,null,null,null];
(statearr_42733[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__);

(statearr_42733[(1)] = (1));

return statearr_42733;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1 = (function (state_42705){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_42705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e42736){var ex__41858__auto__ = e42736;
var statearr_42737_45971 = state_42705;
(statearr_42737_45971[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_42705[(4)]))){
var statearr_42739_45976 = state_42705;
(statearr_42739_45976[(1)] = cljs.core.first.call(null,(state_42705[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45979 = state_42705;
state_42705 = G__45979;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = function(state_42705){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1.call(this,state_42705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__;
})()
;})(__45899,switch__41854__auto__,c__42092__auto___45937,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async))
})();
var state__42094__auto__ = (function (){var statearr_42747 = f__42093__auto__();
(statearr_42747[(6)] = c__42092__auto___45937);

return statearr_42747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
});})(__45899,c__42092__auto___45937,G__42646_45901,G__42646_45902__$1,n__4613__auto___45898,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42646_45902__$1)].join('')));

}

var G__45980 = (__45899 + (1));
__45899 = G__45980;
continue;
} else {
}
break;
}

var c__42092__auto___45981 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_42781){
var state_val_42782 = (state_42781[(1)]);
if((state_val_42782 === (7))){
var inst_42777 = (state_42781[(2)]);
var state_42781__$1 = state_42781;
var statearr_42807_45982 = state_42781__$1;
(statearr_42807_45982[(2)] = inst_42777);

(statearr_42807_45982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42782 === (1))){
var state_42781__$1 = state_42781;
var statearr_42821_45985 = state_42781__$1;
(statearr_42821_45985[(2)] = null);

(statearr_42821_45985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42782 === (4))){
var inst_42758 = (state_42781[(7)]);
var inst_42758__$1 = (state_42781[(2)]);
var inst_42759 = (inst_42758__$1 == null);
var state_42781__$1 = (function (){var statearr_42827 = state_42781;
(statearr_42827[(7)] = inst_42758__$1);

return statearr_42827;
})();
if(cljs.core.truth_(inst_42759)){
var statearr_42828_45992 = state_42781__$1;
(statearr_42828_45992[(1)] = (5));

} else {
var statearr_42832_45993 = state_42781__$1;
(statearr_42832_45993[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42782 === (6))){
var inst_42763 = (state_42781[(8)]);
var inst_42758 = (state_42781[(7)]);
var inst_42763__$1 = cljs.core.async.chan.call(null,(1));
var inst_42766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42769 = [inst_42758,inst_42763__$1];
var inst_42770 = (new cljs.core.PersistentVector(null,2,(5),inst_42766,inst_42769,null));
var state_42781__$1 = (function (){var statearr_42835 = state_42781;
(statearr_42835[(8)] = inst_42763__$1);

return statearr_42835;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42781__$1,(8),jobs,inst_42770);
} else {
if((state_val_42782 === (3))){
var inst_42779 = (state_42781[(2)]);
var state_42781__$1 = state_42781;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42781__$1,inst_42779);
} else {
if((state_val_42782 === (2))){
var state_42781__$1 = state_42781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42781__$1,(4),from);
} else {
if((state_val_42782 === (9))){
var inst_42774 = (state_42781[(2)]);
var state_42781__$1 = (function (){var statearr_42837 = state_42781;
(statearr_42837[(9)] = inst_42774);

return statearr_42837;
})();
var statearr_42840_46015 = state_42781__$1;
(statearr_42840_46015[(2)] = null);

(statearr_42840_46015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42782 === (5))){
var inst_42761 = cljs.core.async.close_BANG_.call(null,jobs);
var state_42781__$1 = state_42781;
var statearr_42853_46019 = state_42781__$1;
(statearr_42853_46019[(2)] = inst_42761);

(statearr_42853_46019[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42782 === (8))){
var inst_42763 = (state_42781[(8)]);
var inst_42772 = (state_42781[(2)]);
var state_42781__$1 = (function (){var statearr_42854 = state_42781;
(statearr_42854[(10)] = inst_42772);

return statearr_42854;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42781__$1,(9),results,inst_42763);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0 = (function (){
var statearr_42855 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42855[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__);

(statearr_42855[(1)] = (1));

return statearr_42855;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1 = (function (state_42781){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_42781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e42856){var ex__41858__auto__ = e42856;
var statearr_42857_46031 = state_42781;
(statearr_42857_46031[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_42781[(4)]))){
var statearr_42858_46032 = state_42781;
(statearr_42858_46032[(1)] = cljs.core.first.call(null,(state_42781[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46052 = state_42781;
state_42781 = G__46052;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = function(state_42781){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1.call(this,state_42781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_42859 = f__42093__auto__();
(statearr_42859[(6)] = c__42092__auto___45981);

return statearr_42859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


var c__42092__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_42900){
var state_val_42901 = (state_42900[(1)]);
if((state_val_42901 === (7))){
var inst_42896 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
var statearr_42903_46060 = state_42900__$1;
(statearr_42903_46060[(2)] = inst_42896);

(statearr_42903_46060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (20))){
var state_42900__$1 = state_42900;
var statearr_42905_46063 = state_42900__$1;
(statearr_42905_46063[(2)] = null);

(statearr_42905_46063[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (1))){
var state_42900__$1 = state_42900;
var statearr_42906_46064 = state_42900__$1;
(statearr_42906_46064[(2)] = null);

(statearr_42906_46064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (4))){
var inst_42862 = (state_42900[(7)]);
var inst_42862__$1 = (state_42900[(2)]);
var inst_42863 = (inst_42862__$1 == null);
var state_42900__$1 = (function (){var statearr_42907 = state_42900;
(statearr_42907[(7)] = inst_42862__$1);

return statearr_42907;
})();
if(cljs.core.truth_(inst_42863)){
var statearr_42908_46072 = state_42900__$1;
(statearr_42908_46072[(1)] = (5));

} else {
var statearr_42909_46074 = state_42900__$1;
(statearr_42909_46074[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (15))){
var inst_42877 = (state_42900[(8)]);
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42900__$1,(18),to,inst_42877);
} else {
if((state_val_42901 === (21))){
var inst_42891 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
var statearr_42910_46076 = state_42900__$1;
(statearr_42910_46076[(2)] = inst_42891);

(statearr_42910_46076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (13))){
var inst_42893 = (state_42900[(2)]);
var state_42900__$1 = (function (){var statearr_42911 = state_42900;
(statearr_42911[(9)] = inst_42893);

return statearr_42911;
})();
var statearr_42912_46079 = state_42900__$1;
(statearr_42912_46079[(2)] = null);

(statearr_42912_46079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (6))){
var inst_42862 = (state_42900[(7)]);
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42900__$1,(11),inst_42862);
} else {
if((state_val_42901 === (17))){
var inst_42886 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
if(cljs.core.truth_(inst_42886)){
var statearr_42916_46080 = state_42900__$1;
(statearr_42916_46080[(1)] = (19));

} else {
var statearr_42917_46081 = state_42900__$1;
(statearr_42917_46081[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (3))){
var inst_42898 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42900__$1,inst_42898);
} else {
if((state_val_42901 === (12))){
var inst_42872 = (state_42900[(10)]);
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42900__$1,(14),inst_42872);
} else {
if((state_val_42901 === (2))){
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42900__$1,(4),results);
} else {
if((state_val_42901 === (19))){
var state_42900__$1 = state_42900;
var statearr_42918_46094 = state_42900__$1;
(statearr_42918_46094[(2)] = null);

(statearr_42918_46094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (11))){
var inst_42872 = (state_42900[(2)]);
var state_42900__$1 = (function (){var statearr_42919 = state_42900;
(statearr_42919[(10)] = inst_42872);

return statearr_42919;
})();
var statearr_42922_46095 = state_42900__$1;
(statearr_42922_46095[(2)] = null);

(statearr_42922_46095[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (9))){
var state_42900__$1 = state_42900;
var statearr_42927_46097 = state_42900__$1;
(statearr_42927_46097[(2)] = null);

(statearr_42927_46097[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (5))){
var state_42900__$1 = state_42900;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42928_46099 = state_42900__$1;
(statearr_42928_46099[(1)] = (8));

} else {
var statearr_42929_46100 = state_42900__$1;
(statearr_42929_46100[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (14))){
var inst_42877 = (state_42900[(8)]);
var inst_42877__$1 = (state_42900[(2)]);
var inst_42879 = (inst_42877__$1 == null);
var inst_42880 = cljs.core.not(inst_42879);
var state_42900__$1 = (function (){var statearr_42934 = state_42900;
(statearr_42934[(8)] = inst_42877__$1);

return statearr_42934;
})();
if(inst_42880){
var statearr_42935_46103 = state_42900__$1;
(statearr_42935_46103[(1)] = (15));

} else {
var statearr_42936_46104 = state_42900__$1;
(statearr_42936_46104[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (16))){
var state_42900__$1 = state_42900;
var statearr_42937_46105 = state_42900__$1;
(statearr_42937_46105[(2)] = false);

(statearr_42937_46105[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (10))){
var inst_42869 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
var statearr_42939_46111 = state_42900__$1;
(statearr_42939_46111[(2)] = inst_42869);

(statearr_42939_46111[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (18))){
var inst_42883 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
var statearr_42940_46114 = state_42900__$1;
(statearr_42940_46114[(2)] = inst_42883);

(statearr_42940_46114[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (8))){
var inst_42866 = cljs.core.async.close_BANG_.call(null,to);
var state_42900__$1 = state_42900;
var statearr_42945_46118 = state_42900__$1;
(statearr_42945_46118[(2)] = inst_42866);

(statearr_42945_46118[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0 = (function (){
var statearr_42946 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42946[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__);

(statearr_42946[(1)] = (1));

return statearr_42946;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1 = (function (state_42900){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_42900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e42947){var ex__41858__auto__ = e42947;
var statearr_42948_46121 = state_42900;
(statearr_42948_46121[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_42900[(4)]))){
var statearr_42949_46123 = state_42900;
(statearr_42949_46123[(1)] = cljs.core.first.call(null,(state_42900[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46126 = state_42900;
state_42900 = G__46126;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__ = function(state_42900){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1.call(this,state_42900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41855__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_42951 = f__42093__auto__();
(statearr_42951[(6)] = c__42092__auto__);

return statearr_42951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));

return c__42092__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__42956 = arguments.length;
switch (G__42956) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__42958 = arguments.length;
switch (G__42958) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__42968 = arguments.length;
switch (G__42968) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__42092__auto___46206 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_43016){
var state_val_43017 = (state_43016[(1)]);
if((state_val_43017 === (7))){
var inst_43012 = (state_43016[(2)]);
var state_43016__$1 = state_43016;
var statearr_43018_46212 = state_43016__$1;
(statearr_43018_46212[(2)] = inst_43012);

(statearr_43018_46212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (1))){
var state_43016__$1 = state_43016;
var statearr_43022_46213 = state_43016__$1;
(statearr_43022_46213[(2)] = null);

(statearr_43022_46213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (4))){
var inst_42993 = (state_43016[(7)]);
var inst_42993__$1 = (state_43016[(2)]);
var inst_42994 = (inst_42993__$1 == null);
var state_43016__$1 = (function (){var statearr_43023 = state_43016;
(statearr_43023[(7)] = inst_42993__$1);

return statearr_43023;
})();
if(cljs.core.truth_(inst_42994)){
var statearr_43024_46215 = state_43016__$1;
(statearr_43024_46215[(1)] = (5));

} else {
var statearr_43025_46216 = state_43016__$1;
(statearr_43025_46216[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (13))){
var state_43016__$1 = state_43016;
var statearr_43027_46217 = state_43016__$1;
(statearr_43027_46217[(2)] = null);

(statearr_43027_46217[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (6))){
var inst_42993 = (state_43016[(7)]);
var inst_42999 = p.call(null,inst_42993);
var state_43016__$1 = state_43016;
if(cljs.core.truth_(inst_42999)){
var statearr_43028_46223 = state_43016__$1;
(statearr_43028_46223[(1)] = (9));

} else {
var statearr_43029_46224 = state_43016__$1;
(statearr_43029_46224[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (3))){
var inst_43014 = (state_43016[(2)]);
var state_43016__$1 = state_43016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43016__$1,inst_43014);
} else {
if((state_val_43017 === (12))){
var state_43016__$1 = state_43016;
var statearr_43031_46235 = state_43016__$1;
(statearr_43031_46235[(2)] = null);

(statearr_43031_46235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (2))){
var state_43016__$1 = state_43016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43016__$1,(4),ch);
} else {
if((state_val_43017 === (11))){
var inst_42993 = (state_43016[(7)]);
var inst_43003 = (state_43016[(2)]);
var state_43016__$1 = state_43016;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43016__$1,(8),inst_43003,inst_42993);
} else {
if((state_val_43017 === (9))){
var state_43016__$1 = state_43016;
var statearr_43035_46239 = state_43016__$1;
(statearr_43035_46239[(2)] = tc);

(statearr_43035_46239[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (5))){
var inst_42996 = cljs.core.async.close_BANG_.call(null,tc);
var inst_42997 = cljs.core.async.close_BANG_.call(null,fc);
var state_43016__$1 = (function (){var statearr_43036 = state_43016;
(statearr_43036[(8)] = inst_42996);

return statearr_43036;
})();
var statearr_43037_46241 = state_43016__$1;
(statearr_43037_46241[(2)] = inst_42997);

(statearr_43037_46241[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (14))){
var inst_43010 = (state_43016[(2)]);
var state_43016__$1 = state_43016;
var statearr_43041_46242 = state_43016__$1;
(statearr_43041_46242[(2)] = inst_43010);

(statearr_43041_46242[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (10))){
var state_43016__$1 = state_43016;
var statearr_43042_46244 = state_43016__$1;
(statearr_43042_46244[(2)] = fc);

(statearr_43042_46244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43017 === (8))){
var inst_43005 = (state_43016[(2)]);
var state_43016__$1 = state_43016;
if(cljs.core.truth_(inst_43005)){
var statearr_43043_46245 = state_43016__$1;
(statearr_43043_46245[(1)] = (12));

} else {
var statearr_43044_46246 = state_43016__$1;
(statearr_43044_46246[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_43045 = [null,null,null,null,null,null,null,null,null];
(statearr_43045[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_43045[(1)] = (1));

return statearr_43045;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_43016){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_43016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e43049){var ex__41858__auto__ = e43049;
var statearr_43053_46250 = state_43016;
(statearr_43053_46250[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_43016[(4)]))){
var statearr_43054_46251 = state_43016;
(statearr_43054_46251[(1)] = cljs.core.first.call(null,(state_43016[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46253 = state_43016;
state_43016 = G__46253;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_43016){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_43016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_43066 = f__42093__auto__();
(statearr_43066[(6)] = c__42092__auto___46206);

return statearr_43066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42092__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_43106){
var state_val_43107 = (state_43106[(1)]);
if((state_val_43107 === (7))){
var inst_43100 = (state_43106[(2)]);
var state_43106__$1 = state_43106;
var statearr_43125_46263 = state_43106__$1;
(statearr_43125_46263[(2)] = inst_43100);

(statearr_43125_46263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43107 === (1))){
var inst_43078 = init;
var inst_43079 = inst_43078;
var state_43106__$1 = (function (){var statearr_43126 = state_43106;
(statearr_43126[(7)] = inst_43079);

return statearr_43126;
})();
var statearr_43129_46275 = state_43106__$1;
(statearr_43129_46275[(2)] = null);

(statearr_43129_46275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43107 === (4))){
var inst_43082 = (state_43106[(8)]);
var inst_43082__$1 = (state_43106[(2)]);
var inst_43084 = (inst_43082__$1 == null);
var state_43106__$1 = (function (){var statearr_43139 = state_43106;
(statearr_43139[(8)] = inst_43082__$1);

return statearr_43139;
})();
if(cljs.core.truth_(inst_43084)){
var statearr_43142_46280 = state_43106__$1;
(statearr_43142_46280[(1)] = (5));

} else {
var statearr_43144_46281 = state_43106__$1;
(statearr_43144_46281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43107 === (6))){
var inst_43079 = (state_43106[(7)]);
var inst_43082 = (state_43106[(8)]);
var inst_43087 = (state_43106[(9)]);
var inst_43087__$1 = f.call(null,inst_43079,inst_43082);
var inst_43088 = cljs.core.reduced_QMARK_.call(null,inst_43087__$1);
var state_43106__$1 = (function (){var statearr_43151 = state_43106;
(statearr_43151[(9)] = inst_43087__$1);

return statearr_43151;
})();
if(inst_43088){
var statearr_43152_46300 = state_43106__$1;
(statearr_43152_46300[(1)] = (8));

} else {
var statearr_43157_46301 = state_43106__$1;
(statearr_43157_46301[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43107 === (3))){
var inst_43102 = (state_43106[(2)]);
var state_43106__$1 = state_43106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43106__$1,inst_43102);
} else {
if((state_val_43107 === (2))){
var state_43106__$1 = state_43106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43106__$1,(4),ch);
} else {
if((state_val_43107 === (9))){
var inst_43087 = (state_43106[(9)]);
var inst_43079 = inst_43087;
var state_43106__$1 = (function (){var statearr_43160 = state_43106;
(statearr_43160[(7)] = inst_43079);

return statearr_43160;
})();
var statearr_43161_46320 = state_43106__$1;
(statearr_43161_46320[(2)] = null);

(statearr_43161_46320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43107 === (5))){
var inst_43079 = (state_43106[(7)]);
var state_43106__$1 = state_43106;
var statearr_43162_46323 = state_43106__$1;
(statearr_43162_46323[(2)] = inst_43079);

(statearr_43162_46323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43107 === (10))){
var inst_43098 = (state_43106[(2)]);
var state_43106__$1 = state_43106;
var statearr_43163_46326 = state_43106__$1;
(statearr_43163_46326[(2)] = inst_43098);

(statearr_43163_46326[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43107 === (8))){
var inst_43087 = (state_43106[(9)]);
var inst_43090 = cljs.core.deref.call(null,inst_43087);
var state_43106__$1 = state_43106;
var statearr_43164_46329 = state_43106__$1;
(statearr_43164_46329[(2)] = inst_43090);

(statearr_43164_46329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__41855__auto__ = null;
var cljs$core$async$reduce_$_state_machine__41855__auto____0 = (function (){
var statearr_43166 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43166[(0)] = cljs$core$async$reduce_$_state_machine__41855__auto__);

(statearr_43166[(1)] = (1));

return statearr_43166;
});
var cljs$core$async$reduce_$_state_machine__41855__auto____1 = (function (state_43106){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_43106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e43167){var ex__41858__auto__ = e43167;
var statearr_43168_46337 = state_43106;
(statearr_43168_46337[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_43106[(4)]))){
var statearr_43169_46339 = state_43106;
(statearr_43169_46339[(1)] = cljs.core.first.call(null,(state_43106[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46350 = state_43106;
state_43106 = G__46350;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__41855__auto__ = function(state_43106){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__41855__auto____1.call(this,state_43106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__41855__auto____0;
cljs$core$async$reduce_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__41855__auto____1;
return cljs$core$async$reduce_$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_43171 = f__42093__auto__();
(statearr_43171[(6)] = c__42092__auto__);

return statearr_43171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));

return c__42092__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__42092__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_43182){
var state_val_43183 = (state_43182[(1)]);
if((state_val_43183 === (1))){
var inst_43177 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_43182__$1 = state_43182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43182__$1,(2),inst_43177);
} else {
if((state_val_43183 === (2))){
var inst_43179 = (state_43182[(2)]);
var inst_43180 = f__$1.call(null,inst_43179);
var state_43182__$1 = state_43182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43182__$1,inst_43180);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__41855__auto__ = null;
var cljs$core$async$transduce_$_state_machine__41855__auto____0 = (function (){
var statearr_43192 = [null,null,null,null,null,null,null];
(statearr_43192[(0)] = cljs$core$async$transduce_$_state_machine__41855__auto__);

(statearr_43192[(1)] = (1));

return statearr_43192;
});
var cljs$core$async$transduce_$_state_machine__41855__auto____1 = (function (state_43182){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_43182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e43197){var ex__41858__auto__ = e43197;
var statearr_43198_46378 = state_43182;
(statearr_43198_46378[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_43182[(4)]))){
var statearr_43199_46383 = state_43182;
(statearr_43199_46383[(1)] = cljs.core.first.call(null,(state_43182[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46385 = state_43182;
state_43182 = G__46385;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__41855__auto__ = function(state_43182){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__41855__auto____1.call(this,state_43182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__41855__auto____0;
cljs$core$async$transduce_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__41855__auto____1;
return cljs$core$async$transduce_$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_43204 = f__42093__auto__();
(statearr_43204[(6)] = c__42092__auto__);

return statearr_43204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));

return c__42092__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__43232 = arguments.length;
switch (G__43232) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42092__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_43283){
var state_val_43284 = (state_43283[(1)]);
if((state_val_43284 === (7))){
var inst_43265 = (state_43283[(2)]);
var state_43283__$1 = state_43283;
var statearr_43292_46399 = state_43283__$1;
(statearr_43292_46399[(2)] = inst_43265);

(statearr_43292_46399[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (1))){
var inst_43253 = cljs.core.seq.call(null,coll);
var inst_43254 = inst_43253;
var state_43283__$1 = (function (){var statearr_43294 = state_43283;
(statearr_43294[(7)] = inst_43254);

return statearr_43294;
})();
var statearr_43295_46401 = state_43283__$1;
(statearr_43295_46401[(2)] = null);

(statearr_43295_46401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (4))){
var inst_43254 = (state_43283[(7)]);
var inst_43263 = cljs.core.first.call(null,inst_43254);
var state_43283__$1 = state_43283;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43283__$1,(7),ch,inst_43263);
} else {
if((state_val_43284 === (13))){
var inst_43277 = (state_43283[(2)]);
var state_43283__$1 = state_43283;
var statearr_43299_46402 = state_43283__$1;
(statearr_43299_46402[(2)] = inst_43277);

(statearr_43299_46402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (6))){
var inst_43268 = (state_43283[(2)]);
var state_43283__$1 = state_43283;
if(cljs.core.truth_(inst_43268)){
var statearr_43302_46407 = state_43283__$1;
(statearr_43302_46407[(1)] = (8));

} else {
var statearr_43305_46409 = state_43283__$1;
(statearr_43305_46409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (3))){
var inst_43281 = (state_43283[(2)]);
var state_43283__$1 = state_43283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43283__$1,inst_43281);
} else {
if((state_val_43284 === (12))){
var state_43283__$1 = state_43283;
var statearr_43308_46411 = state_43283__$1;
(statearr_43308_46411[(2)] = null);

(statearr_43308_46411[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (2))){
var inst_43254 = (state_43283[(7)]);
var state_43283__$1 = state_43283;
if(cljs.core.truth_(inst_43254)){
var statearr_43310_46412 = state_43283__$1;
(statearr_43310_46412[(1)] = (4));

} else {
var statearr_43313_46413 = state_43283__$1;
(statearr_43313_46413[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (11))){
var inst_43274 = cljs.core.async.close_BANG_.call(null,ch);
var state_43283__$1 = state_43283;
var statearr_43318_46414 = state_43283__$1;
(statearr_43318_46414[(2)] = inst_43274);

(statearr_43318_46414[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (9))){
var state_43283__$1 = state_43283;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43320_46416 = state_43283__$1;
(statearr_43320_46416[(1)] = (11));

} else {
var statearr_43321_46418 = state_43283__$1;
(statearr_43321_46418[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (5))){
var inst_43254 = (state_43283[(7)]);
var state_43283__$1 = state_43283;
var statearr_43322_46420 = state_43283__$1;
(statearr_43322_46420[(2)] = inst_43254);

(statearr_43322_46420[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (10))){
var inst_43279 = (state_43283[(2)]);
var state_43283__$1 = state_43283;
var statearr_43325_46421 = state_43283__$1;
(statearr_43325_46421[(2)] = inst_43279);

(statearr_43325_46421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43284 === (8))){
var inst_43254 = (state_43283[(7)]);
var inst_43270 = cljs.core.next.call(null,inst_43254);
var inst_43254__$1 = inst_43270;
var state_43283__$1 = (function (){var statearr_43329 = state_43283;
(statearr_43329[(7)] = inst_43254__$1);

return statearr_43329;
})();
var statearr_43331_46423 = state_43283__$1;
(statearr_43331_46423[(2)] = null);

(statearr_43331_46423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_43335 = [null,null,null,null,null,null,null,null];
(statearr_43335[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_43335[(1)] = (1));

return statearr_43335;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_43283){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_43283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e43340){var ex__41858__auto__ = e43340;
var statearr_43343_46428 = state_43283;
(statearr_43343_46428[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_43283[(4)]))){
var statearr_43345_46433 = state_43283;
(statearr_43345_46433[(1)] = cljs.core.first.call(null,(state_43283[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46451 = state_43283;
state_43283 = G__46451;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_43283){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_43283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_43346 = f__42093__auto__();
(statearr_43346[(6)] = c__42092__auto__);

return statearr_43346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));

return c__42092__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__43350 = arguments.length;
switch (G__43350) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46458 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46458(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46460 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46460(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46462 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46462(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46465 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46465(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43400 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43400 = (function (ch,cs,meta43401){
this.ch = ch;
this.cs = cs;
this.meta43401 = meta43401;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43402,meta43401__$1){
var self__ = this;
var _43402__$1 = this;
return (new cljs.core.async.t_cljs$core$async43400(self__.ch,self__.cs,meta43401__$1));
}));

(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43402){
var self__ = this;
var _43402__$1 = this;
return self__.meta43401;
}));

(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async43400.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async43400.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta43401","meta43401",108907329,null)], null);
}));

(cljs.core.async.t_cljs$core$async43400.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43400.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43400");

(cljs.core.async.t_cljs$core$async43400.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43400");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43400.
 */
cljs.core.async.__GT_t_cljs$core$async43400 = (function cljs$core$async$mult_$___GT_t_cljs$core$async43400(ch__$1,cs__$1,meta43401){
return (new cljs.core.async.t_cljs$core$async43400(ch__$1,cs__$1,meta43401));
});

}

return (new cljs.core.async.t_cljs$core$async43400(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__42092__auto___46480 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_43561){
var state_val_43562 = (state_43561[(1)]);
if((state_val_43562 === (7))){
var inst_43552 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43567_46482 = state_43561__$1;
(statearr_43567_46482[(2)] = inst_43552);

(statearr_43567_46482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (20))){
var inst_43443 = (state_43561[(7)]);
var inst_43461 = cljs.core.first.call(null,inst_43443);
var inst_43462 = cljs.core.nth.call(null,inst_43461,(0),null);
var inst_43463 = cljs.core.nth.call(null,inst_43461,(1),null);
var state_43561__$1 = (function (){var statearr_43571 = state_43561;
(statearr_43571[(8)] = inst_43462);

return statearr_43571;
})();
if(cljs.core.truth_(inst_43463)){
var statearr_43572_46487 = state_43561__$1;
(statearr_43572_46487[(1)] = (22));

} else {
var statearr_43573_46488 = state_43561__$1;
(statearr_43573_46488[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (27))){
var inst_43499 = (state_43561[(9)]);
var inst_43412 = (state_43561[(10)]);
var inst_43492 = (state_43561[(11)]);
var inst_43494 = (state_43561[(12)]);
var inst_43499__$1 = cljs.core._nth(inst_43492,inst_43494);
var inst_43500 = cljs.core.async.put_BANG_.call(null,inst_43499__$1,inst_43412,done);
var state_43561__$1 = (function (){var statearr_43575 = state_43561;
(statearr_43575[(9)] = inst_43499__$1);

return statearr_43575;
})();
if(cljs.core.truth_(inst_43500)){
var statearr_43576_46490 = state_43561__$1;
(statearr_43576_46490[(1)] = (30));

} else {
var statearr_43578_46491 = state_43561__$1;
(statearr_43578_46491[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (1))){
var state_43561__$1 = state_43561;
var statearr_43579_46492 = state_43561__$1;
(statearr_43579_46492[(2)] = null);

(statearr_43579_46492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (24))){
var inst_43443 = (state_43561[(7)]);
var inst_43468 = (state_43561[(2)]);
var inst_43469 = cljs.core.next.call(null,inst_43443);
var inst_43421 = inst_43469;
var inst_43422 = null;
var inst_43423 = (0);
var inst_43424 = (0);
var state_43561__$1 = (function (){var statearr_43581 = state_43561;
(statearr_43581[(13)] = inst_43422);

(statearr_43581[(14)] = inst_43424);

(statearr_43581[(15)] = inst_43468);

(statearr_43581[(16)] = inst_43423);

(statearr_43581[(17)] = inst_43421);

return statearr_43581;
})();
var statearr_43585_46493 = state_43561__$1;
(statearr_43585_46493[(2)] = null);

(statearr_43585_46493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (39))){
var state_43561__$1 = state_43561;
var statearr_43589_46495 = state_43561__$1;
(statearr_43589_46495[(2)] = null);

(statearr_43589_46495[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (4))){
var inst_43412 = (state_43561[(10)]);
var inst_43412__$1 = (state_43561[(2)]);
var inst_43413 = (inst_43412__$1 == null);
var state_43561__$1 = (function (){var statearr_43590 = state_43561;
(statearr_43590[(10)] = inst_43412__$1);

return statearr_43590;
})();
if(cljs.core.truth_(inst_43413)){
var statearr_43594_46552 = state_43561__$1;
(statearr_43594_46552[(1)] = (5));

} else {
var statearr_43595_46553 = state_43561__$1;
(statearr_43595_46553[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (15))){
var inst_43422 = (state_43561[(13)]);
var inst_43424 = (state_43561[(14)]);
var inst_43423 = (state_43561[(16)]);
var inst_43421 = (state_43561[(17)]);
var inst_43439 = (state_43561[(2)]);
var inst_43440 = (inst_43424 + (1));
var tmp43586 = inst_43422;
var tmp43587 = inst_43423;
var tmp43588 = inst_43421;
var inst_43421__$1 = tmp43588;
var inst_43422__$1 = tmp43586;
var inst_43423__$1 = tmp43587;
var inst_43424__$1 = inst_43440;
var state_43561__$1 = (function (){var statearr_43596 = state_43561;
(statearr_43596[(18)] = inst_43439);

(statearr_43596[(13)] = inst_43422__$1);

(statearr_43596[(14)] = inst_43424__$1);

(statearr_43596[(16)] = inst_43423__$1);

(statearr_43596[(17)] = inst_43421__$1);

return statearr_43596;
})();
var statearr_43597_46556 = state_43561__$1;
(statearr_43597_46556[(2)] = null);

(statearr_43597_46556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (21))){
var inst_43472 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43602_46557 = state_43561__$1;
(statearr_43602_46557[(2)] = inst_43472);

(statearr_43602_46557[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (31))){
var inst_43499 = (state_43561[(9)]);
var inst_43503 = cljs.core.async.untap_STAR_(m,inst_43499);
var state_43561__$1 = state_43561;
var statearr_43608_46558 = state_43561__$1;
(statearr_43608_46558[(2)] = inst_43503);

(statearr_43608_46558[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (32))){
var inst_43491 = (state_43561[(19)]);
var inst_43492 = (state_43561[(11)]);
var inst_43494 = (state_43561[(12)]);
var inst_43493 = (state_43561[(20)]);
var inst_43505 = (state_43561[(2)]);
var inst_43506 = (inst_43494 + (1));
var tmp43598 = inst_43491;
var tmp43599 = inst_43492;
var tmp43600 = inst_43493;
var inst_43491__$1 = tmp43598;
var inst_43492__$1 = tmp43599;
var inst_43493__$1 = tmp43600;
var inst_43494__$1 = inst_43506;
var state_43561__$1 = (function (){var statearr_43609 = state_43561;
(statearr_43609[(19)] = inst_43491__$1);

(statearr_43609[(11)] = inst_43492__$1);

(statearr_43609[(12)] = inst_43494__$1);

(statearr_43609[(21)] = inst_43505);

(statearr_43609[(20)] = inst_43493__$1);

return statearr_43609;
})();
var statearr_43610_46585 = state_43561__$1;
(statearr_43610_46585[(2)] = null);

(statearr_43610_46585[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (40))){
var inst_43525 = (state_43561[(22)]);
var inst_43529 = cljs.core.async.untap_STAR_(m,inst_43525);
var state_43561__$1 = state_43561;
var statearr_43614_46594 = state_43561__$1;
(statearr_43614_46594[(2)] = inst_43529);

(statearr_43614_46594[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (33))){
var inst_43510 = (state_43561[(23)]);
var inst_43517 = cljs.core.chunked_seq_QMARK_.call(null,inst_43510);
var state_43561__$1 = state_43561;
if(inst_43517){
var statearr_43620_46599 = state_43561__$1;
(statearr_43620_46599[(1)] = (36));

} else {
var statearr_43621_46600 = state_43561__$1;
(statearr_43621_46600[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (13))){
var inst_43433 = (state_43561[(24)]);
var inst_43436 = cljs.core.async.close_BANG_.call(null,inst_43433);
var state_43561__$1 = state_43561;
var statearr_43623_46601 = state_43561__$1;
(statearr_43623_46601[(2)] = inst_43436);

(statearr_43623_46601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (22))){
var inst_43462 = (state_43561[(8)]);
var inst_43465 = cljs.core.async.close_BANG_.call(null,inst_43462);
var state_43561__$1 = state_43561;
var statearr_43627_46605 = state_43561__$1;
(statearr_43627_46605[(2)] = inst_43465);

(statearr_43627_46605[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (36))){
var inst_43510 = (state_43561[(23)]);
var inst_43520 = cljs.core.chunk_first.call(null,inst_43510);
var inst_43521 = cljs.core.chunk_rest.call(null,inst_43510);
var inst_43522 = cljs.core.count.call(null,inst_43520);
var inst_43491 = inst_43521;
var inst_43492 = inst_43520;
var inst_43493 = inst_43522;
var inst_43494 = (0);
var state_43561__$1 = (function (){var statearr_43634 = state_43561;
(statearr_43634[(19)] = inst_43491);

(statearr_43634[(11)] = inst_43492);

(statearr_43634[(12)] = inst_43494);

(statearr_43634[(20)] = inst_43493);

return statearr_43634;
})();
var statearr_43641_46609 = state_43561__$1;
(statearr_43641_46609[(2)] = null);

(statearr_43641_46609[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (41))){
var inst_43510 = (state_43561[(23)]);
var inst_43531 = (state_43561[(2)]);
var inst_43532 = cljs.core.next.call(null,inst_43510);
var inst_43491 = inst_43532;
var inst_43492 = null;
var inst_43493 = (0);
var inst_43494 = (0);
var state_43561__$1 = (function (){var statearr_43644 = state_43561;
(statearr_43644[(19)] = inst_43491);

(statearr_43644[(11)] = inst_43492);

(statearr_43644[(12)] = inst_43494);

(statearr_43644[(25)] = inst_43531);

(statearr_43644[(20)] = inst_43493);

return statearr_43644;
})();
var statearr_43646_46633 = state_43561__$1;
(statearr_43646_46633[(2)] = null);

(statearr_43646_46633[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (43))){
var state_43561__$1 = state_43561;
var statearr_43647_46637 = state_43561__$1;
(statearr_43647_46637[(2)] = null);

(statearr_43647_46637[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (29))){
var inst_43540 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43648_46639 = state_43561__$1;
(statearr_43648_46639[(2)] = inst_43540);

(statearr_43648_46639[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (44))){
var inst_43549 = (state_43561[(2)]);
var state_43561__$1 = (function (){var statearr_43662 = state_43561;
(statearr_43662[(26)] = inst_43549);

return statearr_43662;
})();
var statearr_43663_46641 = state_43561__$1;
(statearr_43663_46641[(2)] = null);

(statearr_43663_46641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (6))){
var inst_43482 = (state_43561[(27)]);
var inst_43481 = cljs.core.deref.call(null,cs);
var inst_43482__$1 = cljs.core.keys.call(null,inst_43481);
var inst_43483 = cljs.core.count.call(null,inst_43482__$1);
var inst_43484 = cljs.core.reset_BANG_.call(null,dctr,inst_43483);
var inst_43490 = cljs.core.seq.call(null,inst_43482__$1);
var inst_43491 = inst_43490;
var inst_43492 = null;
var inst_43493 = (0);
var inst_43494 = (0);
var state_43561__$1 = (function (){var statearr_43664 = state_43561;
(statearr_43664[(19)] = inst_43491);

(statearr_43664[(11)] = inst_43492);

(statearr_43664[(28)] = inst_43484);

(statearr_43664[(12)] = inst_43494);

(statearr_43664[(27)] = inst_43482__$1);

(statearr_43664[(20)] = inst_43493);

return statearr_43664;
})();
var statearr_43665_46643 = state_43561__$1;
(statearr_43665_46643[(2)] = null);

(statearr_43665_46643[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (28))){
var inst_43491 = (state_43561[(19)]);
var inst_43510 = (state_43561[(23)]);
var inst_43510__$1 = cljs.core.seq.call(null,inst_43491);
var state_43561__$1 = (function (){var statearr_43666 = state_43561;
(statearr_43666[(23)] = inst_43510__$1);

return statearr_43666;
})();
if(inst_43510__$1){
var statearr_43667_46646 = state_43561__$1;
(statearr_43667_46646[(1)] = (33));

} else {
var statearr_43668_46647 = state_43561__$1;
(statearr_43668_46647[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (25))){
var inst_43494 = (state_43561[(12)]);
var inst_43493 = (state_43561[(20)]);
var inst_43496 = (inst_43494 < inst_43493);
var inst_43497 = inst_43496;
var state_43561__$1 = state_43561;
if(cljs.core.truth_(inst_43497)){
var statearr_43670_46648 = state_43561__$1;
(statearr_43670_46648[(1)] = (27));

} else {
var statearr_43671_46649 = state_43561__$1;
(statearr_43671_46649[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (34))){
var state_43561__$1 = state_43561;
var statearr_43674_46653 = state_43561__$1;
(statearr_43674_46653[(2)] = null);

(statearr_43674_46653[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (17))){
var state_43561__$1 = state_43561;
var statearr_43678_46657 = state_43561__$1;
(statearr_43678_46657[(2)] = null);

(statearr_43678_46657[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (3))){
var inst_43554 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43561__$1,inst_43554);
} else {
if((state_val_43562 === (12))){
var inst_43477 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43681_46659 = state_43561__$1;
(statearr_43681_46659[(2)] = inst_43477);

(statearr_43681_46659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (2))){
var state_43561__$1 = state_43561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43561__$1,(4),ch);
} else {
if((state_val_43562 === (23))){
var state_43561__$1 = state_43561;
var statearr_43682_46670 = state_43561__$1;
(statearr_43682_46670[(2)] = null);

(statearr_43682_46670[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (35))){
var inst_43538 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43683_46675 = state_43561__$1;
(statearr_43683_46675[(2)] = inst_43538);

(statearr_43683_46675[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (19))){
var inst_43443 = (state_43561[(7)]);
var inst_43450 = cljs.core.chunk_first.call(null,inst_43443);
var inst_43451 = cljs.core.chunk_rest.call(null,inst_43443);
var inst_43452 = cljs.core.count.call(null,inst_43450);
var inst_43421 = inst_43451;
var inst_43422 = inst_43450;
var inst_43423 = inst_43452;
var inst_43424 = (0);
var state_43561__$1 = (function (){var statearr_43685 = state_43561;
(statearr_43685[(13)] = inst_43422);

(statearr_43685[(14)] = inst_43424);

(statearr_43685[(16)] = inst_43423);

(statearr_43685[(17)] = inst_43421);

return statearr_43685;
})();
var statearr_43689_46679 = state_43561__$1;
(statearr_43689_46679[(2)] = null);

(statearr_43689_46679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (11))){
var inst_43421 = (state_43561[(17)]);
var inst_43443 = (state_43561[(7)]);
var inst_43443__$1 = cljs.core.seq.call(null,inst_43421);
var state_43561__$1 = (function (){var statearr_43690 = state_43561;
(statearr_43690[(7)] = inst_43443__$1);

return statearr_43690;
})();
if(inst_43443__$1){
var statearr_43692_46686 = state_43561__$1;
(statearr_43692_46686[(1)] = (16));

} else {
var statearr_43693_46687 = state_43561__$1;
(statearr_43693_46687[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (9))){
var inst_43479 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43698_46688 = state_43561__$1;
(statearr_43698_46688[(2)] = inst_43479);

(statearr_43698_46688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (5))){
var inst_43419 = cljs.core.deref.call(null,cs);
var inst_43420 = cljs.core.seq.call(null,inst_43419);
var inst_43421 = inst_43420;
var inst_43422 = null;
var inst_43423 = (0);
var inst_43424 = (0);
var state_43561__$1 = (function (){var statearr_43699 = state_43561;
(statearr_43699[(13)] = inst_43422);

(statearr_43699[(14)] = inst_43424);

(statearr_43699[(16)] = inst_43423);

(statearr_43699[(17)] = inst_43421);

return statearr_43699;
})();
var statearr_43700_46691 = state_43561__$1;
(statearr_43700_46691[(2)] = null);

(statearr_43700_46691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (14))){
var state_43561__$1 = state_43561;
var statearr_43702_46693 = state_43561__$1;
(statearr_43702_46693[(2)] = null);

(statearr_43702_46693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (45))){
var inst_43546 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43705_46697 = state_43561__$1;
(statearr_43705_46697[(2)] = inst_43546);

(statearr_43705_46697[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (26))){
var inst_43482 = (state_43561[(27)]);
var inst_43542 = (state_43561[(2)]);
var inst_43543 = cljs.core.seq.call(null,inst_43482);
var state_43561__$1 = (function (){var statearr_43706 = state_43561;
(statearr_43706[(29)] = inst_43542);

return statearr_43706;
})();
if(inst_43543){
var statearr_43707_46703 = state_43561__$1;
(statearr_43707_46703[(1)] = (42));

} else {
var statearr_43708_46704 = state_43561__$1;
(statearr_43708_46704[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (16))){
var inst_43443 = (state_43561[(7)]);
var inst_43448 = cljs.core.chunked_seq_QMARK_.call(null,inst_43443);
var state_43561__$1 = state_43561;
if(inst_43448){
var statearr_43710_46709 = state_43561__$1;
(statearr_43710_46709[(1)] = (19));

} else {
var statearr_43714_46710 = state_43561__$1;
(statearr_43714_46710[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (38))){
var inst_43535 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43722_46714 = state_43561__$1;
(statearr_43722_46714[(2)] = inst_43535);

(statearr_43722_46714[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (30))){
var state_43561__$1 = state_43561;
var statearr_43723_46715 = state_43561__$1;
(statearr_43723_46715[(2)] = null);

(statearr_43723_46715[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (10))){
var inst_43422 = (state_43561[(13)]);
var inst_43424 = (state_43561[(14)]);
var inst_43432 = cljs.core._nth(inst_43422,inst_43424);
var inst_43433 = cljs.core.nth.call(null,inst_43432,(0),null);
var inst_43434 = cljs.core.nth.call(null,inst_43432,(1),null);
var state_43561__$1 = (function (){var statearr_43724 = state_43561;
(statearr_43724[(24)] = inst_43433);

return statearr_43724;
})();
if(cljs.core.truth_(inst_43434)){
var statearr_43726_46731 = state_43561__$1;
(statearr_43726_46731[(1)] = (13));

} else {
var statearr_43727_46734 = state_43561__$1;
(statearr_43727_46734[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (18))){
var inst_43475 = (state_43561[(2)]);
var state_43561__$1 = state_43561;
var statearr_43728_46735 = state_43561__$1;
(statearr_43728_46735[(2)] = inst_43475);

(statearr_43728_46735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (42))){
var state_43561__$1 = state_43561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43561__$1,(45),dchan);
} else {
if((state_val_43562 === (37))){
var inst_43525 = (state_43561[(22)]);
var inst_43412 = (state_43561[(10)]);
var inst_43510 = (state_43561[(23)]);
var inst_43525__$1 = cljs.core.first.call(null,inst_43510);
var inst_43526 = cljs.core.async.put_BANG_.call(null,inst_43525__$1,inst_43412,done);
var state_43561__$1 = (function (){var statearr_43730 = state_43561;
(statearr_43730[(22)] = inst_43525__$1);

return statearr_43730;
})();
if(cljs.core.truth_(inst_43526)){
var statearr_43731_46739 = state_43561__$1;
(statearr_43731_46739[(1)] = (39));

} else {
var statearr_43732_46743 = state_43561__$1;
(statearr_43732_46743[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43562 === (8))){
var inst_43424 = (state_43561[(14)]);
var inst_43423 = (state_43561[(16)]);
var inst_43426 = (inst_43424 < inst_43423);
var inst_43427 = inst_43426;
var state_43561__$1 = state_43561;
if(cljs.core.truth_(inst_43427)){
var statearr_43733_46747 = state_43561__$1;
(statearr_43733_46747[(1)] = (10));

} else {
var statearr_43734_46748 = state_43561__$1;
(statearr_43734_46748[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__41855__auto__ = null;
var cljs$core$async$mult_$_state_machine__41855__auto____0 = (function (){
var statearr_43737 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43737[(0)] = cljs$core$async$mult_$_state_machine__41855__auto__);

(statearr_43737[(1)] = (1));

return statearr_43737;
});
var cljs$core$async$mult_$_state_machine__41855__auto____1 = (function (state_43561){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_43561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e43742){var ex__41858__auto__ = e43742;
var statearr_43743_46754 = state_43561;
(statearr_43743_46754[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_43561[(4)]))){
var statearr_43744_46755 = state_43561;
(statearr_43744_46755[(1)] = cljs.core.first.call(null,(state_43561[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46761 = state_43561;
state_43561 = G__46761;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__41855__auto__ = function(state_43561){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__41855__auto____1.call(this,state_43561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__41855__auto____0;
cljs$core$async$mult_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__41855__auto____1;
return cljs$core$async$mult_$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_43750 = f__42093__auto__();
(statearr_43750[(6)] = c__42092__auto___46480);

return statearr_43750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__43753 = arguments.length;
switch (G__43753) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_46766 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_46766(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_46771 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_46771(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_46773 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_46773(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_46788 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_46788(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_46791 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_46791(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46797 = arguments.length;
var i__4737__auto___46798 = (0);
while(true){
if((i__4737__auto___46798 < len__4736__auto___46797)){
args__4742__auto__.push((arguments[i__4737__auto___46798]));

var G__46801 = (i__4737__auto___46798 + (1));
i__4737__auto___46798 = G__46801;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__43816){
var map__43817 = p__43816;
var map__43817__$1 = (((((!((map__43817 == null))))?(((((map__43817.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43817.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43817):map__43817);
var opts = map__43817__$1;
var statearr_43820_46802 = state;
(statearr_43820_46802[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_43823_46805 = state;
(statearr_43823_46805[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_43828_46806 = state;
(statearr_43828_46806[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq43803){
var G__43804 = cljs.core.first.call(null,seq43803);
var seq43803__$1 = cljs.core.next.call(null,seq43803);
var G__43805 = cljs.core.first.call(null,seq43803__$1);
var seq43803__$2 = cljs.core.next.call(null,seq43803__$1);
var G__43806 = cljs.core.first.call(null,seq43803__$2);
var seq43803__$3 = cljs.core.next.call(null,seq43803__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43804,G__43805,G__43806,seq43803__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43855 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43855 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta43856){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta43856 = meta43856;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43857,meta43856__$1){
var self__ = this;
var _43857__$1 = this;
return (new cljs.core.async.t_cljs$core$async43855(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta43856__$1));
}));

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43857){
var self__ = this;
var _43857__$1 = this;
return self__.meta43856;
}));

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43855.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43855.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta43856","meta43856",2091303156,null)], null);
}));

(cljs.core.async.t_cljs$core$async43855.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43855.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43855");

(cljs.core.async.t_cljs$core$async43855.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43855");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43855.
 */
cljs.core.async.__GT_t_cljs$core$async43855 = (function cljs$core$async$mix_$___GT_t_cljs$core$async43855(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta43856){
return (new cljs.core.async.t_cljs$core$async43855(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta43856));
});

}

return (new cljs.core.async.t_cljs$core$async43855(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42092__auto___46858 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_44025){
var state_val_44027 = (state_44025[(1)]);
if((state_val_44027 === (7))){
var inst_43914 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
var statearr_44030_46866 = state_44025__$1;
(statearr_44030_46866[(2)] = inst_43914);

(statearr_44030_46866[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (20))){
var inst_43929 = (state_44025[(7)]);
var state_44025__$1 = state_44025;
var statearr_44032_46867 = state_44025__$1;
(statearr_44032_46867[(2)] = inst_43929);

(statearr_44032_46867[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (27))){
var state_44025__$1 = state_44025;
var statearr_44034_46868 = state_44025__$1;
(statearr_44034_46868[(2)] = null);

(statearr_44034_46868[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (1))){
var inst_43897 = (state_44025[(8)]);
var inst_43897__$1 = calc_state();
var inst_43901 = (inst_43897__$1 == null);
var inst_43902 = cljs.core.not(inst_43901);
var state_44025__$1 = (function (){var statearr_44047 = state_44025;
(statearr_44047[(8)] = inst_43897__$1);

return statearr_44047;
})();
if(inst_43902){
var statearr_44049_46870 = state_44025__$1;
(statearr_44049_46870[(1)] = (2));

} else {
var statearr_44050_46871 = state_44025__$1;
(statearr_44050_46871[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (24))){
var inst_43987 = (state_44025[(9)]);
var inst_43955 = (state_44025[(10)]);
var inst_43970 = (state_44025[(11)]);
var inst_43987__$1 = inst_43955.call(null,inst_43970);
var state_44025__$1 = (function (){var statearr_44056 = state_44025;
(statearr_44056[(9)] = inst_43987__$1);

return statearr_44056;
})();
if(cljs.core.truth_(inst_43987__$1)){
var statearr_44058_46876 = state_44025__$1;
(statearr_44058_46876[(1)] = (29));

} else {
var statearr_44059_46878 = state_44025__$1;
(statearr_44059_46878[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (4))){
var inst_43917 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
if(cljs.core.truth_(inst_43917)){
var statearr_44063_46880 = state_44025__$1;
(statearr_44063_46880[(1)] = (8));

} else {
var statearr_44066_46881 = state_44025__$1;
(statearr_44066_46881[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (15))){
var inst_43948 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
if(cljs.core.truth_(inst_43948)){
var statearr_44068_46894 = state_44025__$1;
(statearr_44068_46894[(1)] = (19));

} else {
var statearr_44073_46899 = state_44025__$1;
(statearr_44073_46899[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (21))){
var inst_43953 = (state_44025[(12)]);
var inst_43953__$1 = (state_44025[(2)]);
var inst_43955 = cljs.core.get.call(null,inst_43953__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43957 = cljs.core.get.call(null,inst_43953__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43958 = cljs.core.get.call(null,inst_43953__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_44025__$1 = (function (){var statearr_44075 = state_44025;
(statearr_44075[(13)] = inst_43957);

(statearr_44075[(10)] = inst_43955);

(statearr_44075[(12)] = inst_43953__$1);

return statearr_44075;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_44025__$1,(22),inst_43958);
} else {
if((state_val_44027 === (31))){
var inst_43996 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
if(cljs.core.truth_(inst_43996)){
var statearr_44077_46904 = state_44025__$1;
(statearr_44077_46904[(1)] = (32));

} else {
var statearr_44078_46905 = state_44025__$1;
(statearr_44078_46905[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (32))){
var inst_43969 = (state_44025[(14)]);
var state_44025__$1 = state_44025;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44025__$1,(35),out,inst_43969);
} else {
if((state_val_44027 === (33))){
var inst_43953 = (state_44025[(12)]);
var inst_43929 = inst_43953;
var state_44025__$1 = (function (){var statearr_44081 = state_44025;
(statearr_44081[(7)] = inst_43929);

return statearr_44081;
})();
var statearr_44083_46906 = state_44025__$1;
(statearr_44083_46906[(2)] = null);

(statearr_44083_46906[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (13))){
var inst_43929 = (state_44025[(7)]);
var inst_43937 = inst_43929.cljs$lang$protocol_mask$partition0$;
var inst_43938 = (inst_43937 & (64));
var inst_43939 = inst_43929.cljs$core$ISeq$;
var inst_43940 = (cljs.core.PROTOCOL_SENTINEL === inst_43939);
var inst_43941 = ((inst_43938) || (inst_43940));
var state_44025__$1 = state_44025;
if(cljs.core.truth_(inst_43941)){
var statearr_44087_46907 = state_44025__$1;
(statearr_44087_46907[(1)] = (16));

} else {
var statearr_44089_46908 = state_44025__$1;
(statearr_44089_46908[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (22))){
var inst_43969 = (state_44025[(14)]);
var inst_43970 = (state_44025[(11)]);
var inst_43964 = (state_44025[(2)]);
var inst_43969__$1 = cljs.core.nth.call(null,inst_43964,(0),null);
var inst_43970__$1 = cljs.core.nth.call(null,inst_43964,(1),null);
var inst_43971 = (inst_43969__$1 == null);
var inst_43972 = cljs.core._EQ_.call(null,inst_43970__$1,change);
var inst_43973 = ((inst_43971) || (inst_43972));
var state_44025__$1 = (function (){var statearr_44101 = state_44025;
(statearr_44101[(14)] = inst_43969__$1);

(statearr_44101[(11)] = inst_43970__$1);

return statearr_44101;
})();
if(cljs.core.truth_(inst_43973)){
var statearr_44107_46914 = state_44025__$1;
(statearr_44107_46914[(1)] = (23));

} else {
var statearr_44108_46915 = state_44025__$1;
(statearr_44108_46915[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (36))){
var inst_43953 = (state_44025[(12)]);
var inst_43929 = inst_43953;
var state_44025__$1 = (function (){var statearr_44110 = state_44025;
(statearr_44110[(7)] = inst_43929);

return statearr_44110;
})();
var statearr_44112_46921 = state_44025__$1;
(statearr_44112_46921[(2)] = null);

(statearr_44112_46921[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (29))){
var inst_43987 = (state_44025[(9)]);
var state_44025__$1 = state_44025;
var statearr_44116_46927 = state_44025__$1;
(statearr_44116_46927[(2)] = inst_43987);

(statearr_44116_46927[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (6))){
var state_44025__$1 = state_44025;
var statearr_44118_46931 = state_44025__$1;
(statearr_44118_46931[(2)] = false);

(statearr_44118_46931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (28))){
var inst_43981 = (state_44025[(2)]);
var inst_43982 = calc_state();
var inst_43929 = inst_43982;
var state_44025__$1 = (function (){var statearr_44120 = state_44025;
(statearr_44120[(7)] = inst_43929);

(statearr_44120[(15)] = inst_43981);

return statearr_44120;
})();
var statearr_44124_46933 = state_44025__$1;
(statearr_44124_46933[(2)] = null);

(statearr_44124_46933[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (25))){
var inst_44013 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
var statearr_44131_46937 = state_44025__$1;
(statearr_44131_46937[(2)] = inst_44013);

(statearr_44131_46937[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (34))){
var inst_44011 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
var statearr_44133_46963 = state_44025__$1;
(statearr_44133_46963[(2)] = inst_44011);

(statearr_44133_46963[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (17))){
var state_44025__$1 = state_44025;
var statearr_44135_46972 = state_44025__$1;
(statearr_44135_46972[(2)] = false);

(statearr_44135_46972[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (3))){
var state_44025__$1 = state_44025;
var statearr_44141_46974 = state_44025__$1;
(statearr_44141_46974[(2)] = false);

(statearr_44141_46974[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (12))){
var inst_44015 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44025__$1,inst_44015);
} else {
if((state_val_44027 === (2))){
var inst_43897 = (state_44025[(8)]);
var inst_43905 = inst_43897.cljs$lang$protocol_mask$partition0$;
var inst_43907 = (inst_43905 & (64));
var inst_43908 = inst_43897.cljs$core$ISeq$;
var inst_43909 = (cljs.core.PROTOCOL_SENTINEL === inst_43908);
var inst_43910 = ((inst_43907) || (inst_43909));
var state_44025__$1 = state_44025;
if(cljs.core.truth_(inst_43910)){
var statearr_44144_46982 = state_44025__$1;
(statearr_44144_46982[(1)] = (5));

} else {
var statearr_44145_46983 = state_44025__$1;
(statearr_44145_46983[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (23))){
var inst_43969 = (state_44025[(14)]);
var inst_43975 = (inst_43969 == null);
var state_44025__$1 = state_44025;
if(cljs.core.truth_(inst_43975)){
var statearr_44146_46984 = state_44025__$1;
(statearr_44146_46984[(1)] = (26));

} else {
var statearr_44147_46990 = state_44025__$1;
(statearr_44147_46990[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (35))){
var inst_44000 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
if(cljs.core.truth_(inst_44000)){
var statearr_44148_46994 = state_44025__$1;
(statearr_44148_46994[(1)] = (36));

} else {
var statearr_44149_46995 = state_44025__$1;
(statearr_44149_46995[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (19))){
var inst_43929 = (state_44025[(7)]);
var inst_43950 = cljs.core.apply.call(null,cljs.core.hash_map,inst_43929);
var state_44025__$1 = state_44025;
var statearr_44150_46999 = state_44025__$1;
(statearr_44150_46999[(2)] = inst_43950);

(statearr_44150_46999[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (11))){
var inst_43929 = (state_44025[(7)]);
var inst_43933 = (inst_43929 == null);
var inst_43934 = cljs.core.not(inst_43933);
var state_44025__$1 = state_44025;
if(inst_43934){
var statearr_44154_47003 = state_44025__$1;
(statearr_44154_47003[(1)] = (13));

} else {
var statearr_44155_47039 = state_44025__$1;
(statearr_44155_47039[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (9))){
var inst_43897 = (state_44025[(8)]);
var state_44025__$1 = state_44025;
var statearr_44156_47043 = state_44025__$1;
(statearr_44156_47043[(2)] = inst_43897);

(statearr_44156_47043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (5))){
var state_44025__$1 = state_44025;
var statearr_44159_47051 = state_44025__$1;
(statearr_44159_47051[(2)] = true);

(statearr_44159_47051[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (14))){
var state_44025__$1 = state_44025;
var statearr_44161_47052 = state_44025__$1;
(statearr_44161_47052[(2)] = false);

(statearr_44161_47052[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (26))){
var inst_43970 = (state_44025[(11)]);
var inst_43978 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_43970);
var state_44025__$1 = state_44025;
var statearr_44162_47053 = state_44025__$1;
(statearr_44162_47053[(2)] = inst_43978);

(statearr_44162_47053[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (16))){
var state_44025__$1 = state_44025;
var statearr_44163_47054 = state_44025__$1;
(statearr_44163_47054[(2)] = true);

(statearr_44163_47054[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (38))){
var inst_44007 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
var statearr_44164_47055 = state_44025__$1;
(statearr_44164_47055[(2)] = inst_44007);

(statearr_44164_47055[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (30))){
var inst_43957 = (state_44025[(13)]);
var inst_43955 = (state_44025[(10)]);
var inst_43970 = (state_44025[(11)]);
var inst_43991 = cljs.core.empty_QMARK_.call(null,inst_43955);
var inst_43992 = inst_43957.call(null,inst_43970);
var inst_43993 = cljs.core.not(inst_43992);
var inst_43994 = ((inst_43991) && (inst_43993));
var state_44025__$1 = state_44025;
var statearr_44178_47056 = state_44025__$1;
(statearr_44178_47056[(2)] = inst_43994);

(statearr_44178_47056[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (10))){
var inst_43897 = (state_44025[(8)]);
var inst_43922 = (state_44025[(2)]);
var inst_43923 = cljs.core.get.call(null,inst_43922,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43924 = cljs.core.get.call(null,inst_43922,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43925 = cljs.core.get.call(null,inst_43922,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_43929 = inst_43897;
var state_44025__$1 = (function (){var statearr_44179 = state_44025;
(statearr_44179[(16)] = inst_43924);

(statearr_44179[(7)] = inst_43929);

(statearr_44179[(17)] = inst_43925);

(statearr_44179[(18)] = inst_43923);

return statearr_44179;
})();
var statearr_44180_47066 = state_44025__$1;
(statearr_44180_47066[(2)] = null);

(statearr_44180_47066[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (18))){
var inst_43945 = (state_44025[(2)]);
var state_44025__$1 = state_44025;
var statearr_44185_47071 = state_44025__$1;
(statearr_44185_47071[(2)] = inst_43945);

(statearr_44185_47071[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (37))){
var state_44025__$1 = state_44025;
var statearr_44186_47072 = state_44025__$1;
(statearr_44186_47072[(2)] = null);

(statearr_44186_47072[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44027 === (8))){
var inst_43897 = (state_44025[(8)]);
var inst_43919 = cljs.core.apply.call(null,cljs.core.hash_map,inst_43897);
var state_44025__$1 = state_44025;
var statearr_44191_47074 = state_44025__$1;
(statearr_44191_47074[(2)] = inst_43919);

(statearr_44191_47074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__41855__auto__ = null;
var cljs$core$async$mix_$_state_machine__41855__auto____0 = (function (){
var statearr_44196 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44196[(0)] = cljs$core$async$mix_$_state_machine__41855__auto__);

(statearr_44196[(1)] = (1));

return statearr_44196;
});
var cljs$core$async$mix_$_state_machine__41855__auto____1 = (function (state_44025){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_44025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e44201){var ex__41858__auto__ = e44201;
var statearr_44202_47081 = state_44025;
(statearr_44202_47081[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_44025[(4)]))){
var statearr_44203_47083 = state_44025;
(statearr_44203_47083[(1)] = cljs.core.first.call(null,(state_44025[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47084 = state_44025;
state_44025 = G__47084;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__41855__auto__ = function(state_44025){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__41855__auto____1.call(this,state_44025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__41855__auto____0;
cljs$core$async$mix_$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__41855__auto____1;
return cljs$core$async$mix_$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_44204 = f__42093__auto__();
(statearr_44204[(6)] = c__42092__auto___46858);

return statearr_44204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_47087 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_47087(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_47092 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_47092(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_47101 = (function() {
var G__47102 = null;
var G__47102__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__47102__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__47102 = function(p,v){
switch(arguments.length){
case 1:
return G__47102__1.call(this,p);
case 2:
return G__47102__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47102.cljs$core$IFn$_invoke$arity$1 = G__47102__1;
G__47102.cljs$core$IFn$_invoke$arity$2 = G__47102__2;
return G__47102;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__44279 = arguments.length;
switch (G__44279) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47101(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47101(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__44291 = arguments.length;
switch (G__44291) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__44284_SHARP_){
if(cljs.core.truth_(p1__44284_SHARP_.call(null,topic))){
return p1__44284_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__44284_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44294 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44294 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta44295){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta44295 = meta44295;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44296,meta44295__$1){
var self__ = this;
var _44296__$1 = this;
return (new cljs.core.async.t_cljs$core$async44294(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta44295__$1));
}));

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44296){
var self__ = this;
var _44296__$1 = this;
return self__.meta44295;
}));

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async44294.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async44294.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta44295","meta44295",750723317,null)], null);
}));

(cljs.core.async.t_cljs$core$async44294.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44294.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44294");

(cljs.core.async.t_cljs$core$async44294.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44294");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44294.
 */
cljs.core.async.__GT_t_cljs$core$async44294 = (function cljs$core$async$__GT_t_cljs$core$async44294(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44295){
return (new cljs.core.async.t_cljs$core$async44294(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44295));
});

}

return (new cljs.core.async.t_cljs$core$async44294(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42092__auto___47129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_44408){
var state_val_44409 = (state_44408[(1)]);
if((state_val_44409 === (7))){
var inst_44400 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
var statearr_44411_47134 = state_44408__$1;
(statearr_44411_47134[(2)] = inst_44400);

(statearr_44411_47134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (20))){
var state_44408__$1 = state_44408;
var statearr_44412_47138 = state_44408__$1;
(statearr_44412_47138[(2)] = null);

(statearr_44412_47138[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (1))){
var state_44408__$1 = state_44408;
var statearr_44414_47139 = state_44408__$1;
(statearr_44414_47139[(2)] = null);

(statearr_44414_47139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (24))){
var inst_44383 = (state_44408[(7)]);
var inst_44392 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_44383);
var state_44408__$1 = state_44408;
var statearr_44416_47140 = state_44408__$1;
(statearr_44416_47140[(2)] = inst_44392);

(statearr_44416_47140[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (4))){
var inst_44320 = (state_44408[(8)]);
var inst_44320__$1 = (state_44408[(2)]);
var inst_44321 = (inst_44320__$1 == null);
var state_44408__$1 = (function (){var statearr_44419 = state_44408;
(statearr_44419[(8)] = inst_44320__$1);

return statearr_44419;
})();
if(cljs.core.truth_(inst_44321)){
var statearr_44422_47144 = state_44408__$1;
(statearr_44422_47144[(1)] = (5));

} else {
var statearr_44423_47145 = state_44408__$1;
(statearr_44423_47145[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (15))){
var inst_44376 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
var statearr_44424_47155 = state_44408__$1;
(statearr_44424_47155[(2)] = inst_44376);

(statearr_44424_47155[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (21))){
var inst_44397 = (state_44408[(2)]);
var state_44408__$1 = (function (){var statearr_44428 = state_44408;
(statearr_44428[(9)] = inst_44397);

return statearr_44428;
})();
var statearr_44429_47159 = state_44408__$1;
(statearr_44429_47159[(2)] = null);

(statearr_44429_47159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (13))){
var inst_44358 = (state_44408[(10)]);
var inst_44360 = cljs.core.chunked_seq_QMARK_.call(null,inst_44358);
var state_44408__$1 = state_44408;
if(inst_44360){
var statearr_44432_47166 = state_44408__$1;
(statearr_44432_47166[(1)] = (16));

} else {
var statearr_44433_47167 = state_44408__$1;
(statearr_44433_47167[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (22))){
var inst_44389 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
if(cljs.core.truth_(inst_44389)){
var statearr_44436_47169 = state_44408__$1;
(statearr_44436_47169[(1)] = (23));

} else {
var statearr_44437_47170 = state_44408__$1;
(statearr_44437_47170[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (6))){
var inst_44320 = (state_44408[(8)]);
var inst_44383 = (state_44408[(7)]);
var inst_44385 = (state_44408[(11)]);
var inst_44383__$1 = topic_fn.call(null,inst_44320);
var inst_44384 = cljs.core.deref.call(null,mults);
var inst_44385__$1 = cljs.core.get.call(null,inst_44384,inst_44383__$1);
var state_44408__$1 = (function (){var statearr_44438 = state_44408;
(statearr_44438[(7)] = inst_44383__$1);

(statearr_44438[(11)] = inst_44385__$1);

return statearr_44438;
})();
if(cljs.core.truth_(inst_44385__$1)){
var statearr_44440_47182 = state_44408__$1;
(statearr_44440_47182[(1)] = (19));

} else {
var statearr_44445_47183 = state_44408__$1;
(statearr_44445_47183[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (25))){
var inst_44394 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
var statearr_44448_47184 = state_44408__$1;
(statearr_44448_47184[(2)] = inst_44394);

(statearr_44448_47184[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (17))){
var inst_44358 = (state_44408[(10)]);
var inst_44367 = cljs.core.first.call(null,inst_44358);
var inst_44368 = cljs.core.async.muxch_STAR_(inst_44367);
var inst_44369 = cljs.core.async.close_BANG_.call(null,inst_44368);
var inst_44370 = cljs.core.next.call(null,inst_44358);
var inst_44331 = inst_44370;
var inst_44332 = null;
var inst_44333 = (0);
var inst_44334 = (0);
var state_44408__$1 = (function (){var statearr_44451 = state_44408;
(statearr_44451[(12)] = inst_44332);

(statearr_44451[(13)] = inst_44334);

(statearr_44451[(14)] = inst_44331);

(statearr_44451[(15)] = inst_44369);

(statearr_44451[(16)] = inst_44333);

return statearr_44451;
})();
var statearr_44452_47187 = state_44408__$1;
(statearr_44452_47187[(2)] = null);

(statearr_44452_47187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (3))){
var inst_44402 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44408__$1,inst_44402);
} else {
if((state_val_44409 === (12))){
var inst_44378 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
var statearr_44454_47188 = state_44408__$1;
(statearr_44454_47188[(2)] = inst_44378);

(statearr_44454_47188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (2))){
var state_44408__$1 = state_44408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44408__$1,(4),ch);
} else {
if((state_val_44409 === (23))){
var state_44408__$1 = state_44408;
var statearr_44461_47189 = state_44408__$1;
(statearr_44461_47189[(2)] = null);

(statearr_44461_47189[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (19))){
var inst_44320 = (state_44408[(8)]);
var inst_44385 = (state_44408[(11)]);
var inst_44387 = cljs.core.async.muxch_STAR_(inst_44385);
var state_44408__$1 = state_44408;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44408__$1,(22),inst_44387,inst_44320);
} else {
if((state_val_44409 === (11))){
var inst_44358 = (state_44408[(10)]);
var inst_44331 = (state_44408[(14)]);
var inst_44358__$1 = cljs.core.seq.call(null,inst_44331);
var state_44408__$1 = (function (){var statearr_44464 = state_44408;
(statearr_44464[(10)] = inst_44358__$1);

return statearr_44464;
})();
if(inst_44358__$1){
var statearr_44465_47194 = state_44408__$1;
(statearr_44465_47194[(1)] = (13));

} else {
var statearr_44466_47195 = state_44408__$1;
(statearr_44466_47195[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (9))){
var inst_44380 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
var statearr_44467_47196 = state_44408__$1;
(statearr_44467_47196[(2)] = inst_44380);

(statearr_44467_47196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (5))){
var inst_44327 = cljs.core.deref.call(null,mults);
var inst_44328 = cljs.core.vals.call(null,inst_44327);
var inst_44329 = cljs.core.seq.call(null,inst_44328);
var inst_44331 = inst_44329;
var inst_44332 = null;
var inst_44333 = (0);
var inst_44334 = (0);
var state_44408__$1 = (function (){var statearr_44470 = state_44408;
(statearr_44470[(12)] = inst_44332);

(statearr_44470[(13)] = inst_44334);

(statearr_44470[(14)] = inst_44331);

(statearr_44470[(16)] = inst_44333);

return statearr_44470;
})();
var statearr_44471_47197 = state_44408__$1;
(statearr_44471_47197[(2)] = null);

(statearr_44471_47197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (14))){
var state_44408__$1 = state_44408;
var statearr_44477_47199 = state_44408__$1;
(statearr_44477_47199[(2)] = null);

(statearr_44477_47199[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (16))){
var inst_44358 = (state_44408[(10)]);
var inst_44362 = cljs.core.chunk_first.call(null,inst_44358);
var inst_44363 = cljs.core.chunk_rest.call(null,inst_44358);
var inst_44364 = cljs.core.count.call(null,inst_44362);
var inst_44331 = inst_44363;
var inst_44332 = inst_44362;
var inst_44333 = inst_44364;
var inst_44334 = (0);
var state_44408__$1 = (function (){var statearr_44483 = state_44408;
(statearr_44483[(12)] = inst_44332);

(statearr_44483[(13)] = inst_44334);

(statearr_44483[(14)] = inst_44331);

(statearr_44483[(16)] = inst_44333);

return statearr_44483;
})();
var statearr_44484_47202 = state_44408__$1;
(statearr_44484_47202[(2)] = null);

(statearr_44484_47202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (10))){
var inst_44332 = (state_44408[(12)]);
var inst_44334 = (state_44408[(13)]);
var inst_44331 = (state_44408[(14)]);
var inst_44333 = (state_44408[(16)]);
var inst_44348 = cljs.core._nth(inst_44332,inst_44334);
var inst_44349 = cljs.core.async.muxch_STAR_(inst_44348);
var inst_44350 = cljs.core.async.close_BANG_.call(null,inst_44349);
var inst_44351 = (inst_44334 + (1));
var tmp44473 = inst_44332;
var tmp44474 = inst_44331;
var tmp44475 = inst_44333;
var inst_44331__$1 = tmp44474;
var inst_44332__$1 = tmp44473;
var inst_44333__$1 = tmp44475;
var inst_44334__$1 = inst_44351;
var state_44408__$1 = (function (){var statearr_44485 = state_44408;
(statearr_44485[(12)] = inst_44332__$1);

(statearr_44485[(13)] = inst_44334__$1);

(statearr_44485[(14)] = inst_44331__$1);

(statearr_44485[(17)] = inst_44350);

(statearr_44485[(16)] = inst_44333__$1);

return statearr_44485;
})();
var statearr_44486_47204 = state_44408__$1;
(statearr_44486_47204[(2)] = null);

(statearr_44486_47204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (18))){
var inst_44373 = (state_44408[(2)]);
var state_44408__$1 = state_44408;
var statearr_44487_47205 = state_44408__$1;
(statearr_44487_47205[(2)] = inst_44373);

(statearr_44487_47205[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44409 === (8))){
var inst_44334 = (state_44408[(13)]);
var inst_44333 = (state_44408[(16)]);
var inst_44340 = (inst_44334 < inst_44333);
var inst_44341 = inst_44340;
var state_44408__$1 = state_44408;
if(cljs.core.truth_(inst_44341)){
var statearr_44488_47206 = state_44408__$1;
(statearr_44488_47206[(1)] = (10));

} else {
var statearr_44489_47207 = state_44408__$1;
(statearr_44489_47207[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_44491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44491[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_44491[(1)] = (1));

return statearr_44491;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_44408){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_44408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e44492){var ex__41858__auto__ = e44492;
var statearr_44493_47215 = state_44408;
(statearr_44493_47215[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_44408[(4)]))){
var statearr_44494_47222 = state_44408;
(statearr_44494_47222[(1)] = cljs.core.first.call(null,(state_44408[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47224 = state_44408;
state_44408 = G__47224;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_44408){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_44408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_44497 = f__42093__auto__();
(statearr_44497[(6)] = c__42092__auto___47129);

return statearr_44497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__44501 = arguments.length;
switch (G__44501) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__44508 = arguments.length;
switch (G__44508) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__44521 = arguments.length;
switch (G__44521) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__42092__auto___47247 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_44586){
var state_val_44587 = (state_44586[(1)]);
if((state_val_44587 === (7))){
var state_44586__$1 = state_44586;
var statearr_44595_47248 = state_44586__$1;
(statearr_44595_47248[(2)] = null);

(statearr_44595_47248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (1))){
var state_44586__$1 = state_44586;
var statearr_44596_47249 = state_44586__$1;
(statearr_44596_47249[(2)] = null);

(statearr_44596_47249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (4))){
var inst_44535 = (state_44586[(7)]);
var inst_44536 = (state_44586[(8)]);
var inst_44538 = (inst_44536 < inst_44535);
var state_44586__$1 = state_44586;
if(cljs.core.truth_(inst_44538)){
var statearr_44598_47251 = state_44586__$1;
(statearr_44598_47251[(1)] = (6));

} else {
var statearr_44602_47252 = state_44586__$1;
(statearr_44602_47252[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (15))){
var inst_44571 = (state_44586[(9)]);
var inst_44576 = cljs.core.apply.call(null,f,inst_44571);
var state_44586__$1 = state_44586;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44586__$1,(17),out,inst_44576);
} else {
if((state_val_44587 === (13))){
var inst_44571 = (state_44586[(9)]);
var inst_44571__$1 = (state_44586[(2)]);
var inst_44572 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_44571__$1);
var state_44586__$1 = (function (){var statearr_44604 = state_44586;
(statearr_44604[(9)] = inst_44571__$1);

return statearr_44604;
})();
if(cljs.core.truth_(inst_44572)){
var statearr_44605_47254 = state_44586__$1;
(statearr_44605_47254[(1)] = (14));

} else {
var statearr_44606_47256 = state_44586__$1;
(statearr_44606_47256[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (6))){
var state_44586__$1 = state_44586;
var statearr_44608_47257 = state_44586__$1;
(statearr_44608_47257[(2)] = null);

(statearr_44608_47257[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (17))){
var inst_44578 = (state_44586[(2)]);
var state_44586__$1 = (function (){var statearr_44610 = state_44586;
(statearr_44610[(10)] = inst_44578);

return statearr_44610;
})();
var statearr_44611_47259 = state_44586__$1;
(statearr_44611_47259[(2)] = null);

(statearr_44611_47259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (3))){
var inst_44583 = (state_44586[(2)]);
var state_44586__$1 = state_44586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44586__$1,inst_44583);
} else {
if((state_val_44587 === (12))){
var _ = (function (){var statearr_44615 = state_44586;
(statearr_44615[(4)] = cljs.core.rest.call(null,(state_44586[(4)])));

return statearr_44615;
})();
var state_44586__$1 = state_44586;
var ex44609 = (state_44586__$1[(2)]);
var statearr_44616_47260 = state_44586__$1;
(statearr_44616_47260[(5)] = ex44609);


if((ex44609 instanceof Object)){
var statearr_44619_47262 = state_44586__$1;
(statearr_44619_47262[(1)] = (11));

(statearr_44619_47262[(5)] = null);

} else {
throw ex44609;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (2))){
var inst_44534 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_44535 = cnt;
var inst_44536 = (0);
var state_44586__$1 = (function (){var statearr_44622 = state_44586;
(statearr_44622[(7)] = inst_44535);

(statearr_44622[(11)] = inst_44534);

(statearr_44622[(8)] = inst_44536);

return statearr_44622;
})();
var statearr_44623_47266 = state_44586__$1;
(statearr_44623_47266[(2)] = null);

(statearr_44623_47266[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (11))){
var inst_44546 = (state_44586[(2)]);
var inst_44547 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_44586__$1 = (function (){var statearr_44626 = state_44586;
(statearr_44626[(12)] = inst_44546);

return statearr_44626;
})();
var statearr_44627_47267 = state_44586__$1;
(statearr_44627_47267[(2)] = inst_44547);

(statearr_44627_47267[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (9))){
var inst_44536 = (state_44586[(8)]);
var _ = (function (){var statearr_44628 = state_44586;
(statearr_44628[(4)] = cljs.core.cons.call(null,(12),(state_44586[(4)])));

return statearr_44628;
})();
var inst_44553 = chs__$1.call(null,inst_44536);
var inst_44554 = done.call(null,inst_44536);
var inst_44555 = cljs.core.async.take_BANG_.call(null,inst_44553,inst_44554);
var ___$1 = (function (){var statearr_44633 = state_44586;
(statearr_44633[(4)] = cljs.core.rest.call(null,(state_44586[(4)])));

return statearr_44633;
})();
var state_44586__$1 = state_44586;
var statearr_44635_47284 = state_44586__$1;
(statearr_44635_47284[(2)] = inst_44555);

(statearr_44635_47284[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (5))){
var inst_44569 = (state_44586[(2)]);
var state_44586__$1 = (function (){var statearr_44637 = state_44586;
(statearr_44637[(13)] = inst_44569);

return statearr_44637;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44586__$1,(13),dchan);
} else {
if((state_val_44587 === (14))){
var inst_44574 = cljs.core.async.close_BANG_.call(null,out);
var state_44586__$1 = state_44586;
var statearr_44638_47290 = state_44586__$1;
(statearr_44638_47290[(2)] = inst_44574);

(statearr_44638_47290[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (16))){
var inst_44581 = (state_44586[(2)]);
var state_44586__$1 = state_44586;
var statearr_44640_47291 = state_44586__$1;
(statearr_44640_47291[(2)] = inst_44581);

(statearr_44640_47291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (10))){
var inst_44536 = (state_44586[(8)]);
var inst_44558 = (state_44586[(2)]);
var inst_44559 = (inst_44536 + (1));
var inst_44536__$1 = inst_44559;
var state_44586__$1 = (function (){var statearr_44644 = state_44586;
(statearr_44644[(8)] = inst_44536__$1);

(statearr_44644[(14)] = inst_44558);

return statearr_44644;
})();
var statearr_44645_47295 = state_44586__$1;
(statearr_44645_47295[(2)] = null);

(statearr_44645_47295[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44587 === (8))){
var inst_44563 = (state_44586[(2)]);
var state_44586__$1 = state_44586;
var statearr_44650_47296 = state_44586__$1;
(statearr_44650_47296[(2)] = inst_44563);

(statearr_44650_47296[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_44652 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44652[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_44652[(1)] = (1));

return statearr_44652;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_44586){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_44586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e44658){var ex__41858__auto__ = e44658;
var statearr_44660_47309 = state_44586;
(statearr_44660_47309[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_44586[(4)]))){
var statearr_44661_47310 = state_44586;
(statearr_44661_47310[(1)] = cljs.core.first.call(null,(state_44586[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47315 = state_44586;
state_44586 = G__47315;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_44586){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_44586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_44662 = f__42093__auto__();
(statearr_44662[(6)] = c__42092__auto___47247);

return statearr_44662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__44671 = arguments.length;
switch (G__44671) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42092__auto___47321 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_44719){
var state_val_44720 = (state_44719[(1)]);
if((state_val_44720 === (7))){
var inst_44699 = (state_44719[(7)]);
var inst_44698 = (state_44719[(8)]);
var inst_44698__$1 = (state_44719[(2)]);
var inst_44699__$1 = cljs.core.nth.call(null,inst_44698__$1,(0),null);
var inst_44700 = cljs.core.nth.call(null,inst_44698__$1,(1),null);
var inst_44701 = (inst_44699__$1 == null);
var state_44719__$1 = (function (){var statearr_44724 = state_44719;
(statearr_44724[(9)] = inst_44700);

(statearr_44724[(7)] = inst_44699__$1);

(statearr_44724[(8)] = inst_44698__$1);

return statearr_44724;
})();
if(cljs.core.truth_(inst_44701)){
var statearr_44726_47343 = state_44719__$1;
(statearr_44726_47343[(1)] = (8));

} else {
var statearr_44729_47347 = state_44719__$1;
(statearr_44729_47347[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44720 === (1))){
var inst_44679 = cljs.core.vec.call(null,chs);
var inst_44683 = inst_44679;
var state_44719__$1 = (function (){var statearr_44732 = state_44719;
(statearr_44732[(10)] = inst_44683);

return statearr_44732;
})();
var statearr_44733_47348 = state_44719__$1;
(statearr_44733_47348[(2)] = null);

(statearr_44733_47348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44720 === (4))){
var inst_44683 = (state_44719[(10)]);
var state_44719__$1 = state_44719;
return cljs.core.async.ioc_alts_BANG_.call(null,state_44719__$1,(7),inst_44683);
} else {
if((state_val_44720 === (6))){
var inst_44715 = (state_44719[(2)]);
var state_44719__$1 = state_44719;
var statearr_44739_47349 = state_44719__$1;
(statearr_44739_47349[(2)] = inst_44715);

(statearr_44739_47349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44720 === (3))){
var inst_44717 = (state_44719[(2)]);
var state_44719__$1 = state_44719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44719__$1,inst_44717);
} else {
if((state_val_44720 === (2))){
var inst_44683 = (state_44719[(10)]);
var inst_44691 = cljs.core.count.call(null,inst_44683);
var inst_44692 = (inst_44691 > (0));
var state_44719__$1 = state_44719;
if(cljs.core.truth_(inst_44692)){
var statearr_44747_47350 = state_44719__$1;
(statearr_44747_47350[(1)] = (4));

} else {
var statearr_44751_47353 = state_44719__$1;
(statearr_44751_47353[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44720 === (11))){
var inst_44683 = (state_44719[(10)]);
var inst_44708 = (state_44719[(2)]);
var tmp44740 = inst_44683;
var inst_44683__$1 = tmp44740;
var state_44719__$1 = (function (){var statearr_44752 = state_44719;
(statearr_44752[(11)] = inst_44708);

(statearr_44752[(10)] = inst_44683__$1);

return statearr_44752;
})();
var statearr_44753_47359 = state_44719__$1;
(statearr_44753_47359[(2)] = null);

(statearr_44753_47359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44720 === (9))){
var inst_44699 = (state_44719[(7)]);
var state_44719__$1 = state_44719;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44719__$1,(11),out,inst_44699);
} else {
if((state_val_44720 === (5))){
var inst_44713 = cljs.core.async.close_BANG_.call(null,out);
var state_44719__$1 = state_44719;
var statearr_44767_47362 = state_44719__$1;
(statearr_44767_47362[(2)] = inst_44713);

(statearr_44767_47362[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44720 === (10))){
var inst_44711 = (state_44719[(2)]);
var state_44719__$1 = state_44719;
var statearr_44768_47363 = state_44719__$1;
(statearr_44768_47363[(2)] = inst_44711);

(statearr_44768_47363[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44720 === (8))){
var inst_44700 = (state_44719[(9)]);
var inst_44699 = (state_44719[(7)]);
var inst_44683 = (state_44719[(10)]);
var inst_44698 = (state_44719[(8)]);
var inst_44703 = (function (){var cs = inst_44683;
var vec__44694 = inst_44698;
var v = inst_44699;
var c = inst_44700;
return (function (p1__44666_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__44666_SHARP_);
});
})();
var inst_44704 = cljs.core.filterv.call(null,inst_44703,inst_44683);
var inst_44683__$1 = inst_44704;
var state_44719__$1 = (function (){var statearr_44769 = state_44719;
(statearr_44769[(10)] = inst_44683__$1);

return statearr_44769;
})();
var statearr_44770_47368 = state_44719__$1;
(statearr_44770_47368[(2)] = null);

(statearr_44770_47368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_44776 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44776[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_44776[(1)] = (1));

return statearr_44776;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_44719){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_44719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e44777){var ex__41858__auto__ = e44777;
var statearr_44778_47370 = state_44719;
(statearr_44778_47370[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_44719[(4)]))){
var statearr_44779_47373 = state_44719;
(statearr_44779_47373[(1)] = cljs.core.first.call(null,(state_44719[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47374 = state_44719;
state_44719 = G__47374;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_44719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_44719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_44780 = f__42093__auto__();
(statearr_44780[(6)] = c__42092__auto___47321);

return statearr_44780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__44789 = arguments.length;
switch (G__44789) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42092__auto___47406 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_44823){
var state_val_44824 = (state_44823[(1)]);
if((state_val_44824 === (7))){
var inst_44800 = (state_44823[(7)]);
var inst_44800__$1 = (state_44823[(2)]);
var inst_44803 = (inst_44800__$1 == null);
var inst_44804 = cljs.core.not(inst_44803);
var state_44823__$1 = (function (){var statearr_44833 = state_44823;
(statearr_44833[(7)] = inst_44800__$1);

return statearr_44833;
})();
if(inst_44804){
var statearr_44836_47428 = state_44823__$1;
(statearr_44836_47428[(1)] = (8));

} else {
var statearr_44840_47430 = state_44823__$1;
(statearr_44840_47430[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (1))){
var inst_44795 = (0);
var state_44823__$1 = (function (){var statearr_44841 = state_44823;
(statearr_44841[(8)] = inst_44795);

return statearr_44841;
})();
var statearr_44842_47441 = state_44823__$1;
(statearr_44842_47441[(2)] = null);

(statearr_44842_47441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (4))){
var state_44823__$1 = state_44823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44823__$1,(7),ch);
} else {
if((state_val_44824 === (6))){
var inst_44817 = (state_44823[(2)]);
var state_44823__$1 = state_44823;
var statearr_44846_47454 = state_44823__$1;
(statearr_44846_47454[(2)] = inst_44817);

(statearr_44846_47454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (3))){
var inst_44819 = (state_44823[(2)]);
var inst_44820 = cljs.core.async.close_BANG_.call(null,out);
var state_44823__$1 = (function (){var statearr_44847 = state_44823;
(statearr_44847[(9)] = inst_44819);

return statearr_44847;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44823__$1,inst_44820);
} else {
if((state_val_44824 === (2))){
var inst_44795 = (state_44823[(8)]);
var inst_44797 = (inst_44795 < n);
var state_44823__$1 = state_44823;
if(cljs.core.truth_(inst_44797)){
var statearr_44857_47470 = state_44823__$1;
(statearr_44857_47470[(1)] = (4));

} else {
var statearr_44860_47471 = state_44823__$1;
(statearr_44860_47471[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (11))){
var inst_44795 = (state_44823[(8)]);
var inst_44807 = (state_44823[(2)]);
var inst_44809 = (inst_44795 + (1));
var inst_44795__$1 = inst_44809;
var state_44823__$1 = (function (){var statearr_44862 = state_44823;
(statearr_44862[(10)] = inst_44807);

(statearr_44862[(8)] = inst_44795__$1);

return statearr_44862;
})();
var statearr_44865_47480 = state_44823__$1;
(statearr_44865_47480[(2)] = null);

(statearr_44865_47480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (9))){
var state_44823__$1 = state_44823;
var statearr_44866_47481 = state_44823__$1;
(statearr_44866_47481[(2)] = null);

(statearr_44866_47481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (5))){
var state_44823__$1 = state_44823;
var statearr_44869_47482 = state_44823__$1;
(statearr_44869_47482[(2)] = null);

(statearr_44869_47482[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (10))){
var inst_44814 = (state_44823[(2)]);
var state_44823__$1 = state_44823;
var statearr_44870_47486 = state_44823__$1;
(statearr_44870_47486[(2)] = inst_44814);

(statearr_44870_47486[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44824 === (8))){
var inst_44800 = (state_44823[(7)]);
var state_44823__$1 = state_44823;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44823__$1,(11),out,inst_44800);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_44878 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44878[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_44878[(1)] = (1));

return statearr_44878;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_44823){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_44823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e44879){var ex__41858__auto__ = e44879;
var statearr_44880_47493 = state_44823;
(statearr_44880_47493[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_44823[(4)]))){
var statearr_44881_47494 = state_44823;
(statearr_44881_47494[(1)] = cljs.core.first.call(null,(state_44823[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47499 = state_44823;
state_44823 = G__47499;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_44823){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_44823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_44886 = f__42093__auto__();
(statearr_44886[(6)] = c__42092__auto___47406);

return statearr_44886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44901 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44901 = (function (f,ch,meta44902){
this.f = f;
this.ch = ch;
this.meta44902 = meta44902;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44903,meta44902__$1){
var self__ = this;
var _44903__$1 = this;
return (new cljs.core.async.t_cljs$core$async44901(self__.f,self__.ch,meta44902__$1));
}));

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44903){
var self__ = this;
var _44903__$1 = this;
return self__.meta44902;
}));

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44919 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44919 = (function (f,ch,meta44902,_,fn1,meta44920){
this.f = f;
this.ch = ch;
this.meta44902 = meta44902;
this._ = _;
this.fn1 = fn1;
this.meta44920 = meta44920;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44919.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44921,meta44920__$1){
var self__ = this;
var _44921__$1 = this;
return (new cljs.core.async.t_cljs$core$async44919(self__.f,self__.ch,self__.meta44902,self__._,self__.fn1,meta44920__$1));
}));

(cljs.core.async.t_cljs$core$async44919.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44921){
var self__ = this;
var _44921__$1 = this;
return self__.meta44920;
}));

(cljs.core.async.t_cljs$core$async44919.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44919.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async44919.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44919.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__44892_SHARP_){
return f1.call(null,(((p1__44892_SHARP_ == null))?null:self__.f.call(null,p1__44892_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async44919.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44902","meta44902",886071841,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async44901","cljs.core.async/t_cljs$core$async44901",-1981601460,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta44920","meta44920",-422561578,null)], null);
}));

(cljs.core.async.t_cljs$core$async44919.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44919.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44919");

(cljs.core.async.t_cljs$core$async44919.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44919");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44919.
 */
cljs.core.async.__GT_t_cljs$core$async44919 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44919(f__$1,ch__$1,meta44902__$1,___$2,fn1__$1,meta44920){
return (new cljs.core.async.t_cljs$core$async44919(f__$1,ch__$1,meta44902__$1,___$2,fn1__$1,meta44920));
});

}

return (new cljs.core.async.t_cljs$core$async44919(self__.f,self__.ch,self__.meta44902,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44901.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async44901.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44902","meta44902",886071841,null)], null);
}));

(cljs.core.async.t_cljs$core$async44901.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44901.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44901");

(cljs.core.async.t_cljs$core$async44901.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44901");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44901.
 */
cljs.core.async.__GT_t_cljs$core$async44901 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44901(f__$1,ch__$1,meta44902){
return (new cljs.core.async.t_cljs$core$async44901(f__$1,ch__$1,meta44902));
});

}

return (new cljs.core.async.t_cljs$core$async44901(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44952 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44952 = (function (f,ch,meta44953){
this.f = f;
this.ch = ch;
this.meta44953 = meta44953;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44954,meta44953__$1){
var self__ = this;
var _44954__$1 = this;
return (new cljs.core.async.t_cljs$core$async44952(self__.f,self__.ch,meta44953__$1));
}));

(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44954){
var self__ = this;
var _44954__$1 = this;
return self__.meta44953;
}));

(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44952.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async44952.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44953","meta44953",-56836766,null)], null);
}));

(cljs.core.async.t_cljs$core$async44952.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44952.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44952");

(cljs.core.async.t_cljs$core$async44952.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44952");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44952.
 */
cljs.core.async.__GT_t_cljs$core$async44952 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async44952(f__$1,ch__$1,meta44953){
return (new cljs.core.async.t_cljs$core$async44952(f__$1,ch__$1,meta44953));
});

}

return (new cljs.core.async.t_cljs$core$async44952(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45009 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45009 = (function (p,ch,meta45010){
this.p = p;
this.ch = ch;
this.meta45010 = meta45010;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45011,meta45010__$1){
var self__ = this;
var _45011__$1 = this;
return (new cljs.core.async.t_cljs$core$async45009(self__.p,self__.ch,meta45010__$1));
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45011){
var self__ = this;
var _45011__$1 = this;
return self__.meta45010;
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45009.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45010","meta45010",-1815810801,null)], null);
}));

(cljs.core.async.t_cljs$core$async45009.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45009.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45009");

(cljs.core.async.t_cljs$core$async45009.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45009");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45009.
 */
cljs.core.async.__GT_t_cljs$core$async45009 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45009(p__$1,ch__$1,meta45010){
return (new cljs.core.async.t_cljs$core$async45009(p__$1,ch__$1,meta45010));
});

}

return (new cljs.core.async.t_cljs$core$async45009(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45025 = arguments.length;
switch (G__45025) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42092__auto___47646 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_45051){
var state_val_45052 = (state_45051[(1)]);
if((state_val_45052 === (7))){
var inst_45045 = (state_45051[(2)]);
var state_45051__$1 = state_45051;
var statearr_45053_47650 = state_45051__$1;
(statearr_45053_47650[(2)] = inst_45045);

(statearr_45053_47650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (1))){
var state_45051__$1 = state_45051;
var statearr_45054_47652 = state_45051__$1;
(statearr_45054_47652[(2)] = null);

(statearr_45054_47652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (4))){
var inst_45028 = (state_45051[(7)]);
var inst_45028__$1 = (state_45051[(2)]);
var inst_45029 = (inst_45028__$1 == null);
var state_45051__$1 = (function (){var statearr_45055 = state_45051;
(statearr_45055[(7)] = inst_45028__$1);

return statearr_45055;
})();
if(cljs.core.truth_(inst_45029)){
var statearr_45056_47654 = state_45051__$1;
(statearr_45056_47654[(1)] = (5));

} else {
var statearr_45057_47656 = state_45051__$1;
(statearr_45057_47656[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (6))){
var inst_45028 = (state_45051[(7)]);
var inst_45034 = p.call(null,inst_45028);
var state_45051__$1 = state_45051;
if(cljs.core.truth_(inst_45034)){
var statearr_45058_47657 = state_45051__$1;
(statearr_45058_47657[(1)] = (8));

} else {
var statearr_45059_47658 = state_45051__$1;
(statearr_45059_47658[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (3))){
var inst_45048 = (state_45051[(2)]);
var state_45051__$1 = state_45051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45051__$1,inst_45048);
} else {
if((state_val_45052 === (2))){
var state_45051__$1 = state_45051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45051__$1,(4),ch);
} else {
if((state_val_45052 === (11))){
var inst_45038 = (state_45051[(2)]);
var state_45051__$1 = state_45051;
var statearr_45061_47672 = state_45051__$1;
(statearr_45061_47672[(2)] = inst_45038);

(statearr_45061_47672[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (9))){
var state_45051__$1 = state_45051;
var statearr_45070_47679 = state_45051__$1;
(statearr_45070_47679[(2)] = null);

(statearr_45070_47679[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (5))){
var inst_45032 = cljs.core.async.close_BANG_.call(null,out);
var state_45051__$1 = state_45051;
var statearr_45075_47686 = state_45051__$1;
(statearr_45075_47686[(2)] = inst_45032);

(statearr_45075_47686[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (10))){
var inst_45041 = (state_45051[(2)]);
var state_45051__$1 = (function (){var statearr_45076 = state_45051;
(statearr_45076[(8)] = inst_45041);

return statearr_45076;
})();
var statearr_45077_47689 = state_45051__$1;
(statearr_45077_47689[(2)] = null);

(statearr_45077_47689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45052 === (8))){
var inst_45028 = (state_45051[(7)]);
var state_45051__$1 = state_45051;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45051__$1,(11),out,inst_45028);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_45090 = [null,null,null,null,null,null,null,null,null];
(statearr_45090[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_45090[(1)] = (1));

return statearr_45090;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_45051){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_45051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e45092){var ex__41858__auto__ = e45092;
var statearr_45093_47699 = state_45051;
(statearr_45093_47699[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_45051[(4)]))){
var statearr_45094_47702 = state_45051;
(statearr_45094_47702[(1)] = cljs.core.first.call(null,(state_45051[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47708 = state_45051;
state_45051 = G__47708;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_45051){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_45051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_45097 = f__42093__auto__();
(statearr_45097[(6)] = c__42092__auto___47646);

return statearr_45097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45105 = arguments.length;
switch (G__45105) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42092__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_45181){
var state_val_45182 = (state_45181[(1)]);
if((state_val_45182 === (7))){
var inst_45175 = (state_45181[(2)]);
var state_45181__$1 = state_45181;
var statearr_45209_47717 = state_45181__$1;
(statearr_45209_47717[(2)] = inst_45175);

(statearr_45209_47717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (20))){
var inst_45142 = (state_45181[(7)]);
var inst_45155 = (state_45181[(2)]);
var inst_45156 = cljs.core.next.call(null,inst_45142);
var inst_45127 = inst_45156;
var inst_45128 = null;
var inst_45129 = (0);
var inst_45130 = (0);
var state_45181__$1 = (function (){var statearr_45210 = state_45181;
(statearr_45210[(8)] = inst_45130);

(statearr_45210[(9)] = inst_45129);

(statearr_45210[(10)] = inst_45127);

(statearr_45210[(11)] = inst_45155);

(statearr_45210[(12)] = inst_45128);

return statearr_45210;
})();
var statearr_45214_47721 = state_45181__$1;
(statearr_45214_47721[(2)] = null);

(statearr_45214_47721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (1))){
var state_45181__$1 = state_45181;
var statearr_45215_47725 = state_45181__$1;
(statearr_45215_47725[(2)] = null);

(statearr_45215_47725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (4))){
var inst_45116 = (state_45181[(13)]);
var inst_45116__$1 = (state_45181[(2)]);
var inst_45117 = (inst_45116__$1 == null);
var state_45181__$1 = (function (){var statearr_45221 = state_45181;
(statearr_45221[(13)] = inst_45116__$1);

return statearr_45221;
})();
if(cljs.core.truth_(inst_45117)){
var statearr_45224_47735 = state_45181__$1;
(statearr_45224_47735[(1)] = (5));

} else {
var statearr_45225_47736 = state_45181__$1;
(statearr_45225_47736[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (15))){
var state_45181__$1 = state_45181;
var statearr_45232_47737 = state_45181__$1;
(statearr_45232_47737[(2)] = null);

(statearr_45232_47737[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (21))){
var state_45181__$1 = state_45181;
var statearr_45233_47739 = state_45181__$1;
(statearr_45233_47739[(2)] = null);

(statearr_45233_47739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (13))){
var inst_45130 = (state_45181[(8)]);
var inst_45129 = (state_45181[(9)]);
var inst_45127 = (state_45181[(10)]);
var inst_45128 = (state_45181[(12)]);
var inst_45138 = (state_45181[(2)]);
var inst_45139 = (inst_45130 + (1));
var tmp45226 = inst_45129;
var tmp45227 = inst_45127;
var tmp45228 = inst_45128;
var inst_45127__$1 = tmp45227;
var inst_45128__$1 = tmp45228;
var inst_45129__$1 = tmp45226;
var inst_45130__$1 = inst_45139;
var state_45181__$1 = (function (){var statearr_45234 = state_45181;
(statearr_45234[(14)] = inst_45138);

(statearr_45234[(8)] = inst_45130__$1);

(statearr_45234[(9)] = inst_45129__$1);

(statearr_45234[(10)] = inst_45127__$1);

(statearr_45234[(12)] = inst_45128__$1);

return statearr_45234;
})();
var statearr_45235_47744 = state_45181__$1;
(statearr_45235_47744[(2)] = null);

(statearr_45235_47744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (22))){
var state_45181__$1 = state_45181;
var statearr_45237_47747 = state_45181__$1;
(statearr_45237_47747[(2)] = null);

(statearr_45237_47747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (6))){
var inst_45116 = (state_45181[(13)]);
var inst_45125 = f.call(null,inst_45116);
var inst_45126 = cljs.core.seq.call(null,inst_45125);
var inst_45127 = inst_45126;
var inst_45128 = null;
var inst_45129 = (0);
var inst_45130 = (0);
var state_45181__$1 = (function (){var statearr_45240 = state_45181;
(statearr_45240[(8)] = inst_45130);

(statearr_45240[(9)] = inst_45129);

(statearr_45240[(10)] = inst_45127);

(statearr_45240[(12)] = inst_45128);

return statearr_45240;
})();
var statearr_45241_47754 = state_45181__$1;
(statearr_45241_47754[(2)] = null);

(statearr_45241_47754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (17))){
var inst_45142 = (state_45181[(7)]);
var inst_45147 = cljs.core.chunk_first.call(null,inst_45142);
var inst_45149 = cljs.core.chunk_rest.call(null,inst_45142);
var inst_45150 = cljs.core.count.call(null,inst_45147);
var inst_45127 = inst_45149;
var inst_45128 = inst_45147;
var inst_45129 = inst_45150;
var inst_45130 = (0);
var state_45181__$1 = (function (){var statearr_45245 = state_45181;
(statearr_45245[(8)] = inst_45130);

(statearr_45245[(9)] = inst_45129);

(statearr_45245[(10)] = inst_45127);

(statearr_45245[(12)] = inst_45128);

return statearr_45245;
})();
var statearr_45246_47757 = state_45181__$1;
(statearr_45246_47757[(2)] = null);

(statearr_45246_47757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (3))){
var inst_45177 = (state_45181[(2)]);
var state_45181__$1 = state_45181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45181__$1,inst_45177);
} else {
if((state_val_45182 === (12))){
var inst_45164 = (state_45181[(2)]);
var state_45181__$1 = state_45181;
var statearr_45256_47763 = state_45181__$1;
(statearr_45256_47763[(2)] = inst_45164);

(statearr_45256_47763[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (2))){
var state_45181__$1 = state_45181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45181__$1,(4),in$);
} else {
if((state_val_45182 === (23))){
var inst_45173 = (state_45181[(2)]);
var state_45181__$1 = state_45181;
var statearr_45257_47768 = state_45181__$1;
(statearr_45257_47768[(2)] = inst_45173);

(statearr_45257_47768[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (19))){
var inst_45159 = (state_45181[(2)]);
var state_45181__$1 = state_45181;
var statearr_45258_47771 = state_45181__$1;
(statearr_45258_47771[(2)] = inst_45159);

(statearr_45258_47771[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (11))){
var inst_45142 = (state_45181[(7)]);
var inst_45127 = (state_45181[(10)]);
var inst_45142__$1 = cljs.core.seq.call(null,inst_45127);
var state_45181__$1 = (function (){var statearr_45263 = state_45181;
(statearr_45263[(7)] = inst_45142__$1);

return statearr_45263;
})();
if(inst_45142__$1){
var statearr_45264_47776 = state_45181__$1;
(statearr_45264_47776[(1)] = (14));

} else {
var statearr_45265_47777 = state_45181__$1;
(statearr_45265_47777[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (9))){
var inst_45166 = (state_45181[(2)]);
var inst_45167 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_45181__$1 = (function (){var statearr_45269 = state_45181;
(statearr_45269[(15)] = inst_45166);

return statearr_45269;
})();
if(cljs.core.truth_(inst_45167)){
var statearr_45272_47780 = state_45181__$1;
(statearr_45272_47780[(1)] = (21));

} else {
var statearr_45275_47781 = state_45181__$1;
(statearr_45275_47781[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (5))){
var inst_45119 = cljs.core.async.close_BANG_.call(null,out);
var state_45181__$1 = state_45181;
var statearr_45276_47788 = state_45181__$1;
(statearr_45276_47788[(2)] = inst_45119);

(statearr_45276_47788[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (14))){
var inst_45142 = (state_45181[(7)]);
var inst_45145 = cljs.core.chunked_seq_QMARK_.call(null,inst_45142);
var state_45181__$1 = state_45181;
if(inst_45145){
var statearr_45279_47792 = state_45181__$1;
(statearr_45279_47792[(1)] = (17));

} else {
var statearr_45281_47795 = state_45181__$1;
(statearr_45281_47795[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (16))){
var inst_45162 = (state_45181[(2)]);
var state_45181__$1 = state_45181;
var statearr_45282_47796 = state_45181__$1;
(statearr_45282_47796[(2)] = inst_45162);

(statearr_45282_47796[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45182 === (10))){
var inst_45130 = (state_45181[(8)]);
var inst_45128 = (state_45181[(12)]);
var inst_45136 = cljs.core._nth(inst_45128,inst_45130);
var state_45181__$1 = state_45181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45181__$1,(13),out,inst_45136);
} else {
if((state_val_45182 === (18))){
var inst_45142 = (state_45181[(7)]);
var inst_45153 = cljs.core.first.call(null,inst_45142);
var state_45181__$1 = state_45181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45181__$1,(20),out,inst_45153);
} else {
if((state_val_45182 === (8))){
var inst_45130 = (state_45181[(8)]);
var inst_45129 = (state_45181[(9)]);
var inst_45132 = (inst_45130 < inst_45129);
var inst_45133 = inst_45132;
var state_45181__$1 = state_45181;
if(cljs.core.truth_(inst_45133)){
var statearr_45291_47811 = state_45181__$1;
(statearr_45291_47811[(1)] = (10));

} else {
var statearr_45292_47813 = state_45181__$1;
(statearr_45292_47813[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__41855__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__41855__auto____0 = (function (){
var statearr_45293 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45293[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__41855__auto__);

(statearr_45293[(1)] = (1));

return statearr_45293;
});
var cljs$core$async$mapcat_STAR__$_state_machine__41855__auto____1 = (function (state_45181){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_45181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e45294){var ex__41858__auto__ = e45294;
var statearr_45295_47821 = state_45181;
(statearr_45295_47821[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_45181[(4)]))){
var statearr_45296_47825 = state_45181;
(statearr_45296_47825[(1)] = cljs.core.first.call(null,(state_45181[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47827 = state_45181;
state_45181 = G__47827;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__41855__auto__ = function(state_45181){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__41855__auto____1.call(this,state_45181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__41855__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__41855__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_45298 = f__42093__auto__();
(statearr_45298[(6)] = c__42092__auto__);

return statearr_45298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));

return c__42092__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__45303 = arguments.length;
switch (G__45303) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__45307 = arguments.length;
switch (G__45307) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__45312 = arguments.length;
switch (G__45312) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42092__auto___47855 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_45346){
var state_val_45347 = (state_45346[(1)]);
if((state_val_45347 === (7))){
var inst_45338 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45357_47858 = state_45346__$1;
(statearr_45357_47858[(2)] = inst_45338);

(statearr_45357_47858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (1))){
var inst_45314 = null;
var state_45346__$1 = (function (){var statearr_45359 = state_45346;
(statearr_45359[(7)] = inst_45314);

return statearr_45359;
})();
var statearr_45360_47863 = state_45346__$1;
(statearr_45360_47863[(2)] = null);

(statearr_45360_47863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (4))){
var inst_45321 = (state_45346[(8)]);
var inst_45321__$1 = (state_45346[(2)]);
var inst_45324 = (inst_45321__$1 == null);
var inst_45325 = cljs.core.not(inst_45324);
var state_45346__$1 = (function (){var statearr_45362 = state_45346;
(statearr_45362[(8)] = inst_45321__$1);

return statearr_45362;
})();
if(inst_45325){
var statearr_45363_47864 = state_45346__$1;
(statearr_45363_47864[(1)] = (5));

} else {
var statearr_45364_47869 = state_45346__$1;
(statearr_45364_47869[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (6))){
var state_45346__$1 = state_45346;
var statearr_45368_47870 = state_45346__$1;
(statearr_45368_47870[(2)] = null);

(statearr_45368_47870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (3))){
var inst_45341 = (state_45346[(2)]);
var inst_45342 = cljs.core.async.close_BANG_.call(null,out);
var state_45346__$1 = (function (){var statearr_45373 = state_45346;
(statearr_45373[(9)] = inst_45341);

return statearr_45373;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45346__$1,inst_45342);
} else {
if((state_val_45347 === (2))){
var state_45346__$1 = state_45346;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45346__$1,(4),ch);
} else {
if((state_val_45347 === (11))){
var inst_45321 = (state_45346[(8)]);
var inst_45332 = (state_45346[(2)]);
var inst_45314 = inst_45321;
var state_45346__$1 = (function (){var statearr_45383 = state_45346;
(statearr_45383[(10)] = inst_45332);

(statearr_45383[(7)] = inst_45314);

return statearr_45383;
})();
var statearr_45386_47880 = state_45346__$1;
(statearr_45386_47880[(2)] = null);

(statearr_45386_47880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (9))){
var inst_45321 = (state_45346[(8)]);
var state_45346__$1 = state_45346;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45346__$1,(11),out,inst_45321);
} else {
if((state_val_45347 === (5))){
var inst_45321 = (state_45346[(8)]);
var inst_45314 = (state_45346[(7)]);
var inst_45327 = cljs.core._EQ_.call(null,inst_45321,inst_45314);
var state_45346__$1 = state_45346;
if(inst_45327){
var statearr_45395_47884 = state_45346__$1;
(statearr_45395_47884[(1)] = (8));

} else {
var statearr_45398_47885 = state_45346__$1;
(statearr_45398_47885[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (10))){
var inst_45335 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45401_47891 = state_45346__$1;
(statearr_45401_47891[(2)] = inst_45335);

(statearr_45401_47891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (8))){
var inst_45314 = (state_45346[(7)]);
var tmp45391 = inst_45314;
var inst_45314__$1 = tmp45391;
var state_45346__$1 = (function (){var statearr_45402 = state_45346;
(statearr_45402[(7)] = inst_45314__$1);

return statearr_45402;
})();
var statearr_45403_47898 = state_45346__$1;
(statearr_45403_47898[(2)] = null);

(statearr_45403_47898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_45406 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45406[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_45406[(1)] = (1));

return statearr_45406;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_45346){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_45346);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e45408){var ex__41858__auto__ = e45408;
var statearr_45409_47921 = state_45346;
(statearr_45409_47921[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_45346[(4)]))){
var statearr_45410_47925 = state_45346;
(statearr_45410_47925[(1)] = cljs.core.first.call(null,(state_45346[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47928 = state_45346;
state_45346 = G__47928;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_45346){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_45346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_45412 = f__42093__auto__();
(statearr_45412[(6)] = c__42092__auto___47855);

return statearr_45412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__45430 = arguments.length;
switch (G__45430) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42092__auto___47950 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_45477){
var state_val_45478 = (state_45477[(1)]);
if((state_val_45478 === (7))){
var inst_45473 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45483_47958 = state_45477__$1;
(statearr_45483_47958[(2)] = inst_45473);

(statearr_45483_47958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (1))){
var inst_45434 = (new Array(n));
var inst_45437 = inst_45434;
var inst_45438 = (0);
var state_45477__$1 = (function (){var statearr_45489 = state_45477;
(statearr_45489[(7)] = inst_45438);

(statearr_45489[(8)] = inst_45437);

return statearr_45489;
})();
var statearr_45491_47968 = state_45477__$1;
(statearr_45491_47968[(2)] = null);

(statearr_45491_47968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (4))){
var inst_45443 = (state_45477[(9)]);
var inst_45443__$1 = (state_45477[(2)]);
var inst_45445 = (inst_45443__$1 == null);
var inst_45446 = cljs.core.not(inst_45445);
var state_45477__$1 = (function (){var statearr_45493 = state_45477;
(statearr_45493[(9)] = inst_45443__$1);

return statearr_45493;
})();
if(inst_45446){
var statearr_45494_47996 = state_45477__$1;
(statearr_45494_47996[(1)] = (5));

} else {
var statearr_45497_47997 = state_45477__$1;
(statearr_45497_47997[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (15))){
var inst_45467 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45500_48006 = state_45477__$1;
(statearr_45500_48006[(2)] = inst_45467);

(statearr_45500_48006[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (13))){
var state_45477__$1 = state_45477;
var statearr_45504_48009 = state_45477__$1;
(statearr_45504_48009[(2)] = null);

(statearr_45504_48009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (6))){
var inst_45438 = (state_45477[(7)]);
var inst_45463 = (inst_45438 > (0));
var state_45477__$1 = state_45477;
if(cljs.core.truth_(inst_45463)){
var statearr_45507_48016 = state_45477__$1;
(statearr_45507_48016[(1)] = (12));

} else {
var statearr_45508_48018 = state_45477__$1;
(statearr_45508_48018[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (3))){
var inst_45475 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45477__$1,inst_45475);
} else {
if((state_val_45478 === (12))){
var inst_45437 = (state_45477[(8)]);
var inst_45465 = cljs.core.vec.call(null,inst_45437);
var state_45477__$1 = state_45477;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45477__$1,(15),out,inst_45465);
} else {
if((state_val_45478 === (2))){
var state_45477__$1 = state_45477;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45477__$1,(4),ch);
} else {
if((state_val_45478 === (11))){
var inst_45457 = (state_45477[(2)]);
var inst_45458 = (new Array(n));
var inst_45437 = inst_45458;
var inst_45438 = (0);
var state_45477__$1 = (function (){var statearr_45512 = state_45477;
(statearr_45512[(7)] = inst_45438);

(statearr_45512[(8)] = inst_45437);

(statearr_45512[(10)] = inst_45457);

return statearr_45512;
})();
var statearr_45515_48045 = state_45477__$1;
(statearr_45515_48045[(2)] = null);

(statearr_45515_48045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (9))){
var inst_45437 = (state_45477[(8)]);
var inst_45454 = cljs.core.vec.call(null,inst_45437);
var state_45477__$1 = state_45477;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45477__$1,(11),out,inst_45454);
} else {
if((state_val_45478 === (5))){
var inst_45438 = (state_45477[(7)]);
var inst_45437 = (state_45477[(8)]);
var inst_45443 = (state_45477[(9)]);
var inst_45449 = (state_45477[(11)]);
var inst_45448 = (inst_45437[inst_45438] = inst_45443);
var inst_45449__$1 = (inst_45438 + (1));
var inst_45450 = (inst_45449__$1 < n);
var state_45477__$1 = (function (){var statearr_45521 = state_45477;
(statearr_45521[(12)] = inst_45448);

(statearr_45521[(11)] = inst_45449__$1);

return statearr_45521;
})();
if(cljs.core.truth_(inst_45450)){
var statearr_45522_48080 = state_45477__$1;
(statearr_45522_48080[(1)] = (8));

} else {
var statearr_45523_48081 = state_45477__$1;
(statearr_45523_48081[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (14))){
var inst_45470 = (state_45477[(2)]);
var inst_45471 = cljs.core.async.close_BANG_.call(null,out);
var state_45477__$1 = (function (){var statearr_45529 = state_45477;
(statearr_45529[(13)] = inst_45470);

return statearr_45529;
})();
var statearr_45530_48086 = state_45477__$1;
(statearr_45530_48086[(2)] = inst_45471);

(statearr_45530_48086[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (10))){
var inst_45461 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45538_48087 = state_45477__$1;
(statearr_45538_48087[(2)] = inst_45461);

(statearr_45538_48087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (8))){
var inst_45437 = (state_45477[(8)]);
var inst_45449 = (state_45477[(11)]);
var tmp45524 = inst_45437;
var inst_45437__$1 = tmp45524;
var inst_45438 = inst_45449;
var state_45477__$1 = (function (){var statearr_45541 = state_45477;
(statearr_45541[(7)] = inst_45438);

(statearr_45541[(8)] = inst_45437__$1);

return statearr_45541;
})();
var statearr_45547_48094 = state_45477__$1;
(statearr_45547_48094[(2)] = null);

(statearr_45547_48094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_45549 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45549[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_45549[(1)] = (1));

return statearr_45549;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_45477){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_45477);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e45551){var ex__41858__auto__ = e45551;
var statearr_45553_48103 = state_45477;
(statearr_45553_48103[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_45477[(4)]))){
var statearr_45555_48105 = state_45477;
(statearr_45555_48105[(1)] = cljs.core.first.call(null,(state_45477[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48108 = state_45477;
state_45477 = G__48108;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_45477){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_45477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_45560 = f__42093__auto__();
(statearr_45560[(6)] = c__42092__auto___47950);

return statearr_45560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__45567 = arguments.length;
switch (G__45567) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42092__auto___48126 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_45617){
var state_val_45618 = (state_45617[(1)]);
if((state_val_45618 === (7))){
var inst_45613 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
var statearr_45619_48133 = state_45617__$1;
(statearr_45619_48133[(2)] = inst_45613);

(statearr_45619_48133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (1))){
var inst_45571 = [];
var inst_45572 = inst_45571;
var inst_45573 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_45617__$1 = (function (){var statearr_45620 = state_45617;
(statearr_45620[(7)] = inst_45573);

(statearr_45620[(8)] = inst_45572);

return statearr_45620;
})();
var statearr_45621_48139 = state_45617__$1;
(statearr_45621_48139[(2)] = null);

(statearr_45621_48139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (4))){
var inst_45576 = (state_45617[(9)]);
var inst_45576__$1 = (state_45617[(2)]);
var inst_45577 = (inst_45576__$1 == null);
var inst_45579 = cljs.core.not(inst_45577);
var state_45617__$1 = (function (){var statearr_45622 = state_45617;
(statearr_45622[(9)] = inst_45576__$1);

return statearr_45622;
})();
if(inst_45579){
var statearr_45623_48142 = state_45617__$1;
(statearr_45623_48142[(1)] = (5));

} else {
var statearr_45624_48143 = state_45617__$1;
(statearr_45624_48143[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (15))){
var inst_45607 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
var statearr_45627_48148 = state_45617__$1;
(statearr_45627_48148[(2)] = inst_45607);

(statearr_45627_48148[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (13))){
var state_45617__$1 = state_45617;
var statearr_45628_48150 = state_45617__$1;
(statearr_45628_48150[(2)] = null);

(statearr_45628_48150[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (6))){
var inst_45572 = (state_45617[(8)]);
var inst_45602 = inst_45572.length;
var inst_45603 = (inst_45602 > (0));
var state_45617__$1 = state_45617;
if(cljs.core.truth_(inst_45603)){
var statearr_45630_48153 = state_45617__$1;
(statearr_45630_48153[(1)] = (12));

} else {
var statearr_45631_48154 = state_45617__$1;
(statearr_45631_48154[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (3))){
var inst_45615 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45617__$1,inst_45615);
} else {
if((state_val_45618 === (12))){
var inst_45572 = (state_45617[(8)]);
var inst_45605 = cljs.core.vec.call(null,inst_45572);
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45617__$1,(15),out,inst_45605);
} else {
if((state_val_45618 === (2))){
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45617__$1,(4),ch);
} else {
if((state_val_45618 === (11))){
var inst_45582 = (state_45617[(10)]);
var inst_45576 = (state_45617[(9)]);
var inst_45595 = (state_45617[(2)]);
var inst_45596 = [];
var inst_45597 = inst_45596.push(inst_45576);
var inst_45572 = inst_45596;
var inst_45573 = inst_45582;
var state_45617__$1 = (function (){var statearr_45637 = state_45617;
(statearr_45637[(7)] = inst_45573);

(statearr_45637[(8)] = inst_45572);

(statearr_45637[(11)] = inst_45595);

(statearr_45637[(12)] = inst_45597);

return statearr_45637;
})();
var statearr_45640_48158 = state_45617__$1;
(statearr_45640_48158[(2)] = null);

(statearr_45640_48158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (9))){
var inst_45572 = (state_45617[(8)]);
var inst_45593 = cljs.core.vec.call(null,inst_45572);
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45617__$1,(11),out,inst_45593);
} else {
if((state_val_45618 === (5))){
var inst_45582 = (state_45617[(10)]);
var inst_45573 = (state_45617[(7)]);
var inst_45576 = (state_45617[(9)]);
var inst_45582__$1 = f.call(null,inst_45576);
var inst_45584 = cljs.core._EQ_.call(null,inst_45582__$1,inst_45573);
var inst_45585 = cljs.core.keyword_identical_QMARK_.call(null,inst_45573,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_45586 = ((inst_45584) || (inst_45585));
var state_45617__$1 = (function (){var statearr_45651 = state_45617;
(statearr_45651[(10)] = inst_45582__$1);

return statearr_45651;
})();
if(cljs.core.truth_(inst_45586)){
var statearr_45652_48161 = state_45617__$1;
(statearr_45652_48161[(1)] = (8));

} else {
var statearr_45653_48162 = state_45617__$1;
(statearr_45653_48162[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (14))){
var inst_45610 = (state_45617[(2)]);
var inst_45611 = cljs.core.async.close_BANG_.call(null,out);
var state_45617__$1 = (function (){var statearr_45660 = state_45617;
(statearr_45660[(13)] = inst_45610);

return statearr_45660;
})();
var statearr_45661_48163 = state_45617__$1;
(statearr_45661_48163[(2)] = inst_45611);

(statearr_45661_48163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (10))){
var inst_45600 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
var statearr_45662_48164 = state_45617__$1;
(statearr_45662_48164[(2)] = inst_45600);

(statearr_45662_48164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (8))){
var inst_45582 = (state_45617[(10)]);
var inst_45572 = (state_45617[(8)]);
var inst_45576 = (state_45617[(9)]);
var inst_45588 = inst_45572.push(inst_45576);
var tmp45655 = inst_45572;
var inst_45572__$1 = tmp45655;
var inst_45573 = inst_45582;
var state_45617__$1 = (function (){var statearr_45666 = state_45617;
(statearr_45666[(7)] = inst_45573);

(statearr_45666[(8)] = inst_45572__$1);

(statearr_45666[(14)] = inst_45588);

return statearr_45666;
})();
var statearr_45667_48171 = state_45617__$1;
(statearr_45667_48171[(2)] = null);

(statearr_45667_48171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41855__auto__ = null;
var cljs$core$async$state_machine__41855__auto____0 = (function (){
var statearr_45674 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45674[(0)] = cljs$core$async$state_machine__41855__auto__);

(statearr_45674[(1)] = (1));

return statearr_45674;
});
var cljs$core$async$state_machine__41855__auto____1 = (function (state_45617){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_45617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e45678){var ex__41858__auto__ = e45678;
var statearr_45679_48176 = state_45617;
(statearr_45679_48176[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_45617[(4)]))){
var statearr_45682_48181 = state_45617;
(statearr_45682_48181[(1)] = cljs.core.first.call(null,(state_45617[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48183 = state_45617;
state_45617 = G__48183;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
cljs$core$async$state_machine__41855__auto__ = function(state_45617){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41855__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41855__auto____1.call(this,state_45617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41855__auto____0;
cljs$core$async$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41855__auto____1;
return cljs$core$async$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_45685 = f__42093__auto__();
(statearr_45685[(6)] = c__42092__auto___48126);

return statearr_45685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
