goog.provide('com.wsscode.misc.coll');
/**
 * Returns a lazy sequence of the elements of coll, removing any elements that
 *   return duplicate values when passed to a function f.
 */
com.wsscode.misc.coll.distinct_by = (function com$wsscode$misc$coll$distinct_by(var_args){
var G__45818 = arguments.length;
switch (G__45818) {
case 1:
return com.wsscode.misc.coll.distinct_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.misc.coll.distinct_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.coll.distinct_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return (function() {
var G__46341 = null;
var G__46341__0 = (function (){
return rf.call(null);
});
var G__46341__1 = (function (result){
return rf.call(null,result);
});
var G__46341__2 = (function (result,x){
var fx = f.call(null,x);
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,seen),fx)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.call(null,cljs.core._deref(seen),fx));

return rf.call(null,result,x);
}
});
G__46341 = function(result,x){
switch(arguments.length){
case 0:
return G__46341__0.call(this);
case 1:
return G__46341__1.call(this,result);
case 2:
return G__46341__2.call(this,result,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46341.cljs$core$IFn$_invoke$arity$0 = G__46341__0;
G__46341.cljs$core$IFn$_invoke$arity$1 = G__46341__1;
G__46341.cljs$core$IFn$_invoke$arity$2 = G__46341__2;
return G__46341;
})()
});
}));

(com.wsscode.misc.coll.distinct_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var step = (function com$wsscode$misc$coll$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__45834,seen__$1){
while(true){
var vec__45837 = p__45834;
var x = cljs.core.nth.call(null,vec__45837,(0),null);
var xs__$1 = vec__45837;
var temp__5720__auto__ = cljs.core.seq.call(null,xs__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var fx = f.call(null,x);
if(cljs.core.contains_QMARK_.call(null,seen__$1,fx)){
var G__46361 = cljs.core.rest.call(null,s);
var G__46362 = seen__$1;
p__45834 = G__46361;
seen__$1 = G__46362;
continue;
} else {
return cljs.core.cons.call(null,x,com$wsscode$misc$coll$step.call(null,cljs.core.rest.call(null,s),cljs.core.conj.call(null,seen__$1,fx)));
}
} else {
return null;
}
break;
}
})(xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
}));

(com.wsscode.misc.coll.distinct_by.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence removing consecutive duplicates in coll when passed to a function f.
 *   Returns a transducer when no collection is provided.
 */
com.wsscode.misc.coll.dedupe_by = (function com$wsscode$misc$coll$dedupe_by(var_args){
var G__45856 = arguments.length;
switch (G__45856) {
case 1:
return com.wsscode.misc.coll.dedupe_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.misc.coll.dedupe_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.coll.dedupe_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var pv = cljs.core.volatile_BANG_.call(null,new cljs.core.Keyword("com.wsscode.misc.coll","none","com.wsscode.misc.coll/none",1151350699));
return (function() {
var G__46370 = null;
var G__46370__0 = (function (){
return rf.call(null);
});
var G__46370__1 = (function (result){
return rf.call(null,result);
});
var G__46370__2 = (function (result,x){
var prior = cljs.core.deref.call(null,pv);
var fx = f.call(null,x);
cljs.core.vreset_BANG_.call(null,pv,fx);

if(cljs.core._EQ_.call(null,prior,fx)){
return result;
} else {
return rf.call(null,result,x);
}
});
G__46370 = function(result,x){
switch(arguments.length){
case 0:
return G__46370__0.call(this);
case 1:
return G__46370__1.call(this,result);
case 2:
return G__46370__2.call(this,result,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46370.cljs$core$IFn$_invoke$arity$0 = G__46370__0;
G__46370.cljs$core$IFn$_invoke$arity$1 = G__46370__1;
G__46370.cljs$core$IFn$_invoke$arity$2 = G__46370__2;
return G__46370;
})()
});
}));

(com.wsscode.misc.coll.dedupe_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.sequence.call(null,com.wsscode.misc.coll.dedupe_by.call(null,f),coll);
}));

(com.wsscode.misc.coll.dedupe_by.cljs$lang$maxFixedArity = 2);

/**
 * Like group by, but will keep only the last result.
 */
com.wsscode.misc.coll.index_by = (function com$wsscode$misc$coll$index_by(f,coll){
return cljs.core.reduce.call(null,(function (m,x){
return cljs.core.assoc.call(null,m,f.call(null,x),x);
}),cljs.core.PersistentArrayMap.EMPTY,coll);
});
/**
 * Return the first element in coll that returns true for f.
 */
com.wsscode.misc.coll.find_first = (function com$wsscode$misc$coll$find_first(f,coll){
return cljs.core.first.call(null,cljs.core.filter.call(null,f,coll));
});
com.wsscode.misc.coll.sconj = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY);
com.wsscode.misc.coll.vconj = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY);
/**
 * Add element to a vector at some specific index. Only works with vectors!
 */
com.wsscode.misc.coll.conj_at_index = (function com$wsscode$misc$coll$conj_at_index(v,idx,x){
var before = cljs.core.subvec.call(null,v,(0),idx);
var after = cljs.core.subvec.call(null,v,idx,cljs.core.count.call(null,v));
return cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.meta.call(null,v)),cljs.core.concat.call(null,before,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null),after));
});
/**
 * Find the index of element x in coll. Return nil if element is not found.
 */
com.wsscode.misc.coll.index_of = (function com$wsscode$misc$coll$index_of(coll,x){
return cljs.core.reduce.call(null,(function (_,p__45884){
var vec__45885 = p__45884;
var i = cljs.core.nth.call(null,vec__45885,(0),null);
var x_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__45885,(1),null);
if(cljs.core._EQ_.call(null,x,x_SINGLEQUOTE_)){
return cljs.core.reduced.call(null,i);
} else {
return null;
}
}),null,cljs.core.map_indexed.call(null,cljs.core.vector,coll));
});
/**
 * Return a blank immutable queue or create one from coll.
 */
com.wsscode.misc.coll.queue = (function com$wsscode$misc$coll$queue(var_args){
var G__45896 = arguments.length;
switch (G__45896) {
case 0:
return com.wsscode.misc.coll.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return com.wsscode.misc.coll.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.coll.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
}));

(com.wsscode.misc.coll.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.call(null,com.wsscode.misc.coll.queue.call(null),coll);
}));

(com.wsscode.misc.coll.queue.cljs$lang$maxFixedArity = 1);

/**
 * CLJC helper to create MapEntry.
 */
com.wsscode.misc.coll.make_map_entry = (function com$wsscode$misc$coll$make_map_entry(k,v){
return (new cljs.core.MapEntry(k,v,null));
});
/**
 * Map over the given hash-map keys.
 * 
 *   Example:
 *  (map-keys #(str/replace (name %) "_" "-") {"foo_bar" 1}) => {"foo-bar" 1}
 *   
 */
com.wsscode.misc.coll.map_keys = (function com$wsscode$misc$coll$map_keys(f,m){
return cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),cljs.core.map.call(null,(function (x){
return com.wsscode.misc.coll.make_map_entry.call(null,f.call(null,cljs.core.key.call(null,x)),cljs.core.val.call(null,x));
})),m);
});
/**
 * Map over the given hash-map vals.
 * 
 *   Example:
 *  (map-vals inc {:a 1 :b 2})
 *   
 */
com.wsscode.misc.coll.map_vals = (function com$wsscode$misc$coll$map_vals(f,m){
return cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),cljs.core.map.call(null,(function (x){
return com.wsscode.misc.coll.make_map_entry.call(null,cljs.core.key.call(null,x),f.call(null,cljs.core.val.call(null,x)));
})),m);
});
com.wsscode.misc.coll.filter_keys = (function com$wsscode$misc$coll$filter_keys(f,m){
return cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),cljs.core.filter.call(null,cljs.core.comp.call(null,f,cljs.core.key)),m);
});
com.wsscode.misc.coll.filter_vals = (function com$wsscode$misc$coll$filter_vals(f,m){
return cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),cljs.core.filter.call(null,cljs.core.comp.call(null,f,cljs.core.val)),m);
});
com.wsscode.misc.coll.remove_keys = (function com$wsscode$misc$coll$remove_keys(f,m){
return cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),cljs.core.remove.call(null,cljs.core.comp.call(null,f,cljs.core.key)),m);
});
com.wsscode.misc.coll.remove_vals = (function com$wsscode$misc$coll$remove_vals(f,m){
return cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),cljs.core.remove.call(null,cljs.core.comp.call(null,f,cljs.core.val)),m);
});
/**
 * Return the map keys, as a set. This also checks if the entry is a map, otherwise
 *   returns nil (instead of throw).
 */
com.wsscode.misc.coll.keys_set = (function com$wsscode$misc$coll$keys_set(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.keys.call(null,m));
} else {
return null;
}
});
/**
 * Additive merging.
 * 
 *   When merging maps, it does a deep merge.
 *   When merging sets, makes a union of them.
 * 
 *   When value of the right side is nil, the left side will be kept.
 * 
 *   For the rest works as standard merge.
 */
com.wsscode.misc.coll.merge_grow = (function com$wsscode$misc$coll$merge_grow(var_args){
var G__45945 = arguments.length;
switch (G__45945) {
case 0:
return com.wsscode.misc.coll.merge_grow.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return com.wsscode.misc.coll.merge_grow.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.misc.coll.merge_grow.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.coll.merge_grow.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentArrayMap.EMPTY;
}));

(com.wsscode.misc.coll.merge_grow.cljs$core$IFn$_invoke$arity$1 = (function (a){
return a;
}));

(com.wsscode.misc.coll.merge_grow.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
if(((cljs.core.set_QMARK_.call(null,a)) && (cljs.core.set_QMARK_.call(null,b)))){
return clojure.set.union.call(null,a,b);
} else {
if(((cljs.core.map_QMARK_.call(null,a)) && (cljs.core.map_QMARK_.call(null,b)))){
return cljs.core.merge_with.call(null,com.wsscode.misc.coll.merge_grow,a,b);
} else {
if((b == null)){
return a;
} else {
return b;

}
}
}
}));

(com.wsscode.misc.coll.merge_grow.cljs$lang$maxFixedArity = 2);

/**
 * Like merge, but only add keys that are not present in the original map.
 */
com.wsscode.misc.coll.merge_defaults = (function com$wsscode$misc$coll$merge_defaults(m,defaults){
return cljs.core.reduce_kv.call(null,(function (m__$1,k,v){
if(cljs.core.contains_QMARK_.call(null,m__$1,k)){
return m__$1;
} else {
return cljs.core.assoc.call(null,m__$1,k,v);
}
}),m,defaults);
});
com.wsscode.misc.coll._STAR_deep_merge_handlers_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
com.wsscode.misc.coll.value_merger = (function com$wsscode$misc$coll$value_merger(x){
var G__45956 = x;
var G__45956__$1 = (((G__45956 == null))?null:cljs.core.meta.call(null,G__45956));
if((G__45956__$1 == null)){
return null;
} else {
return new cljs.core.Keyword("com.wsscode.misc.coll","merge-with","com.wsscode.misc.coll/merge-with",-764343606).cljs$core$IFn$_invoke$arity$1(G__45956__$1);
}
});
/**
 * Merge util to keep the value from the left side.
 */
com.wsscode.misc.coll.keep_current = (function com$wsscode$misc$coll$keep_current(a,_){
return a;
});
/**
 * Merge util to keep the value from the right side.
 */
com.wsscode.misc.coll.keep_new = (function com$wsscode$misc$coll$keep_new(_,b){
return b;
});
/**
 * Recursively merges maps together. If all the maps supplied have nested maps
 *   under the same keys, these nested maps are merged.
 * 
 *   A custom merge strategy may be configured for specific keys, to do so you need to
 *   bind the value of *deep-merge-handlers*, the keys are the keywords and the values
 *   are functions to handle the merge of that key.
 * 
 *    (binding [*deep-merge-handlers* {:foo +}]
 *      (deep-merge {:foo 1} {:foo 2}))
 *    ; => {:foo 3}
 * 
 *   Another way to control the merge of values is to set some metadata to control the
 *   merge process (notice it only applies for types that support meta like maps and vectors,
 *   but not for keywords or numbers for example).
 * 
 *    (deep-merge {:list [1 2 3]} ^{::merge-with into} {:list [:a :b]})
 *    ; => {:list [1 2 3 :a :b]}
 * 
 *   The meta may go in the left or side of the merge, the right side has higher priority.
 * 
 *   Note that meta mergers have higher priority than merge handlers.
 * 
 *   Here is the merger pick order for clarity:
 * 
 *   1. Value merger from meta at new value
 *   2. Value merger from meta at current value
 *   3. Merge key handler
 *   4. Deep merge (in case both values are maps)
 *   5. Keep the new value (as in `clojure.core/merge`)
 * 
 *   Forked from Medley library.
 */
com.wsscode.misc.coll.deep_merge = (function com$wsscode$misc$coll$deep_merge(var_args){
var G__45977 = arguments.length;
switch (G__45977) {
case 0:
return com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___46476 = arguments.length;
var i__4737__auto___46477 = (0);
while(true){
if((i__4737__auto___46477 < len__4736__auto___46476)){
args_arr__4757__auto__.push((arguments[i__4737__auto___46477]));

var G__46479 = (i__4737__auto___46477 + (1));
i__4737__auto___46477 = G__46479;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((2)),(0),null));
return com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4758__auto__);

}
});

(com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$1 = (function (a){
return a;
}));

(com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
if(cljs.core.truth_((function (){var or__4126__auto__ = a;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return b;
}
})())){
var merge_entry = (function com$wsscode$misc$coll$merge_entry(m,e){
var k = cljs.core.key.call(null,e);
var v_SINGLEQUOTE_ = cljs.core.val.call(null,e);
if(cljs.core.contains_QMARK_.call(null,m,k)){
var v = cljs.core.get.call(null,m,k);
var merger = (function (){var or__4126__auto__ = com.wsscode.misc.coll.value_merger.call(null,v_SINGLEQUOTE_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = com.wsscode.misc.coll.value_merger.call(null,v);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = cljs.core.get.call(null,com.wsscode.misc.coll._STAR_deep_merge_handlers_STAR_,k);
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
var or__4126__auto____$3 = ((((cljs.core.map_QMARK_.call(null,v)) && (cljs.core.map_QMARK_.call(null,v_SINGLEQUOTE_))))?com.wsscode.misc.coll.deep_merge:null);
if(cljs.core.truth_(or__4126__auto____$3)){
return or__4126__auto____$3;
} else {
return com.wsscode.misc.coll.keep_new;
}
}
}
}
})();
return cljs.core.assoc.call(null,m,k,merger.call(null,cljs.core.get.call(null,m,k),v_SINGLEQUOTE_));
} else {
return cljs.core.assoc.call(null,m,k,v_SINGLEQUOTE_);
}
});
return cljs.core.reduce.call(null,merge_entry,(function (){var or__4126__auto__ = a;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq.call(null,b));
} else {
return null;
}
}));

(com.wsscode.misc.coll.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,more){
return cljs.core.reduce.call(null,com.wsscode.misc.coll.deep_merge,(function (){var or__4126__auto__ = a;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cons.call(null,b,more));
}));

/** @this {Function} */
(com.wsscode.misc.coll.deep_merge.cljs$lang$applyTo = (function (seq45973){
var G__45974 = cljs.core.first.call(null,seq45973);
var seq45973__$1 = cljs.core.next.call(null,seq45973);
var G__45975 = cljs.core.first.call(null,seq45973__$1);
var seq45973__$2 = cljs.core.next.call(null,seq45973__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45974,G__45975,seq45973__$2);
}));

(com.wsscode.misc.coll.deep_merge.cljs$lang$maxFixedArity = (2));

/**
 * Like assoc, but noop if v is falsy.
 */
com.wsscode.misc.coll.assoc_if = (function com$wsscode$misc$coll$assoc_if(var_args){
var G__46047 = arguments.length;
switch (G__46047) {
case 3:
return com.wsscode.misc.coll.assoc_if.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___46496 = arguments.length;
var i__4737__auto___46497 = (0);
while(true){
if((i__4737__auto___46497 < len__4736__auto___46496)){
args_arr__4757__auto__.push((arguments[i__4737__auto___46497]));

var G__46498 = (i__4737__auto___46497 + (1));
i__4737__auto___46497 = G__46498;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((3)),(0),null));
return com.wsscode.misc.coll.assoc_if.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4758__auto__);

}
});

(com.wsscode.misc.coll.assoc_if.cljs$core$IFn$_invoke$arity$3 = (function (m,k,v){
if(cljs.core.truth_(v)){
return cljs.core.assoc.call(null,m,k,v);
} else {
return m;
}
}));

(com.wsscode.misc.coll.assoc_if.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,v,kvs){
while(true){
var ret = com.wsscode.misc.coll.assoc_if.call(null,m,k,v);
if(cljs.core.truth_(kvs)){
var G__46500 = ret;
var G__46501 = cljs.core.first.call(null,kvs);
var G__46502 = cljs.core.second.call(null,kvs);
var G__46503 = cljs.core.nnext.call(null,kvs);
m = G__46500;
k = G__46501;
v = G__46502;
kvs = G__46503;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(com.wsscode.misc.coll.assoc_if.cljs$lang$applyTo = (function (seq46043){
var G__46044 = cljs.core.first.call(null,seq46043);
var seq46043__$1 = cljs.core.next.call(null,seq46043);
var G__46045 = cljs.core.first.call(null,seq46043__$1);
var seq46043__$2 = cljs.core.next.call(null,seq46043__$1);
var G__46046 = cljs.core.first.call(null,seq46043__$2);
var seq46043__$3 = cljs.core.next.call(null,seq46043__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46044,G__46045,G__46046,seq46043__$3);
}));

(com.wsscode.misc.coll.assoc_if.cljs$lang$maxFixedArity = (3));

/**
 * Update some key when that key is present in the map.
 */
com.wsscode.misc.coll.update_contained = (function com$wsscode$misc$coll$update_contained(var_args){
var G__46093 = arguments.length;
switch (G__46093) {
case 3:
return com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___46521 = arguments.length;
var i__4737__auto___46522 = (0);
while(true){
if((i__4737__auto___46522 < len__4736__auto___46521)){
args_arr__4757__auto__.push((arguments[i__4737__auto___46522]));

var G__46523 = (i__4737__auto___46522 + (1));
i__4737__auto___46522 = G__46523;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((6)),(0),null));
return com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4758__auto__);

}
});

(com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return cljs.core.update.call(null,m,k,f);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,a1){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return cljs.core.update.call(null,m,k,f,a1);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,a1,a2){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return cljs.core.update.call(null,m,k,f,a1,a2);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,a1,a2,a3){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return cljs.core.update.call(null,m,k,f,a1,a2,a3);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_contained.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,a1,a2,a3,args){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return cljs.core.apply.call(null,cljs.core.update,m,k,f,a1,a2,a3,args);
} else {
return m;
}
}));

/** @this {Function} */
(com.wsscode.misc.coll.update_contained.cljs$lang$applyTo = (function (seq46085){
var G__46086 = cljs.core.first.call(null,seq46085);
var seq46085__$1 = cljs.core.next.call(null,seq46085);
var G__46087 = cljs.core.first.call(null,seq46085__$1);
var seq46085__$2 = cljs.core.next.call(null,seq46085__$1);
var G__46088 = cljs.core.first.call(null,seq46085__$2);
var seq46085__$3 = cljs.core.next.call(null,seq46085__$2);
var G__46089 = cljs.core.first.call(null,seq46085__$3);
var seq46085__$4 = cljs.core.next.call(null,seq46085__$3);
var G__46090 = cljs.core.first.call(null,seq46085__$4);
var seq46085__$5 = cljs.core.next.call(null,seq46085__$4);
var G__46091 = cljs.core.first.call(null,seq46085__$5);
var seq46085__$6 = cljs.core.next.call(null,seq46085__$5);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46086,G__46087,G__46088,G__46089,G__46090,G__46091,seq46085__$6);
}));

(com.wsscode.misc.coll.update_contained.cljs$lang$maxFixedArity = (6));

/**
 * Update some key if that key is present in the map and value is truthy.
 */
com.wsscode.misc.coll.update_if = (function com$wsscode$misc$coll$update_if(var_args){
var G__46161 = arguments.length;
switch (G__46161) {
case 3:
return com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___46535 = arguments.length;
var i__4737__auto___46536 = (0);
while(true){
if((i__4737__auto___46536 < len__4736__auto___46535)){
args_arr__4757__auto__.push((arguments[i__4737__auto___46536]));

var G__46540 = (i__4737__auto___46536 + (1));
i__4737__auto___46536 = G__46540;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((6)),(0),null));
return com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4758__auto__);

}
});

(com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
if(cljs.core.truth_(cljs.core.get.call(null,m,k))){
return cljs.core.update.call(null,m,k,f);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,a1){
if(cljs.core.truth_(cljs.core.get.call(null,m,k))){
return cljs.core.update.call(null,m,k,f,a1);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,a1,a2){
if(cljs.core.truth_(cljs.core.get.call(null,m,k))){
return cljs.core.update.call(null,m,k,f,a1,a2);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,a1,a2,a3){
if(cljs.core.truth_(cljs.core.get.call(null,m,k))){
return cljs.core.update.call(null,m,k,f,a1,a2,a3);
} else {
return m;
}
}));

(com.wsscode.misc.coll.update_if.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,a1,a2,a3,args){
if(cljs.core.truth_(cljs.core.get.call(null,m,k))){
return cljs.core.apply.call(null,cljs.core.update,m,k,f,a1,a2,a3,args);
} else {
return m;
}
}));

/** @this {Function} */
(com.wsscode.misc.coll.update_if.cljs$lang$applyTo = (function (seq46154){
var G__46155 = cljs.core.first.call(null,seq46154);
var seq46154__$1 = cljs.core.next.call(null,seq46154);
var G__46156 = cljs.core.first.call(null,seq46154__$1);
var seq46154__$2 = cljs.core.next.call(null,seq46154__$1);
var G__46157 = cljs.core.first.call(null,seq46154__$2);
var seq46154__$3 = cljs.core.next.call(null,seq46154__$2);
var G__46158 = cljs.core.first.call(null,seq46154__$3);
var seq46154__$4 = cljs.core.next.call(null,seq46154__$3);
var G__46159 = cljs.core.first.call(null,seq46154__$4);
var seq46154__$5 = cljs.core.next.call(null,seq46154__$4);
var G__46160 = cljs.core.first.call(null,seq46154__$5);
var seq46154__$6 = cljs.core.next.call(null,seq46154__$5);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46155,G__46156,G__46157,G__46158,G__46159,G__46160,seq46154__$6);
}));

(com.wsscode.misc.coll.update_if.cljs$lang$maxFixedArity = (6));

com.wsscode.misc.coll.native_map_QMARK_ = (function com$wsscode$misc$coll$native_map_QMARK_(x){
return (((x instanceof cljs.core.PersistentArrayMap)) || ((x instanceof cljs.core.PersistentHashMap)));
});
/**
 * Sorts output list to match input list order.
 * 
 *    (coll/restore-order
 *      [{:id 1} {:id 2} {:id 3}]
 *      :id
 *      [{:id 4 :x "a"}
 *       {:id 1 :x "b"}
 *       {:id 3 :x "c"}
 *       {:id 2 :x "d"}])
 * 
 *    => [{:id 1 :x "b"}
 *        {:id 2 :x "d"}
 *        {:id 3 :x "c"}]
 * 
 *    (coll/restore-order
 *      [{:id 1, :id2 1} {:id 2, :id2 0} {:id 3, :id2 1}]
 *      #(select-keys % [:id :id2])
 *      [{:id 4 :id2 0 :x "a"}
 *       {:id 1 :id2 1 :x "b"}
 *       {:id 3 :id2 1 :x "c"}
 *       {:id 2 :id2 0 :x "d"}])
 * 
 *    => [{:id 1 :id2 1 :x "b"}
 *        {:id 2 :id2 0 :x "d"}
 *        {:id 3 :id2 1 :x "c"}]
 * 
 * Note it will also remove items that don't match anything in the original items
 * list.
 * 
 * In case the items contains a matching key more than once, the last one will be taken.
 */
com.wsscode.misc.coll.restore_order = (function com$wsscode$misc$coll$restore_order(var_args){
var G__46211 = arguments.length;
switch (G__46211) {
case 3:
return com.wsscode.misc.coll.restore_order.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return com.wsscode.misc.coll.restore_order.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.coll.restore_order.cljs$core$IFn$_invoke$arity$3 = (function (inputs,key,items){
return com.wsscode.misc.coll.restore_order.call(null,inputs,key,items,((cljs.core.ident_QMARK_.call(null,key))?(function (p1__46198_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([key],[cljs.core.get.call(null,p1__46198_SHARP_,key)]);
}):key));
}));

(com.wsscode.misc.coll.restore_order.cljs$core$IFn$_invoke$arity$4 = (function (inputs,key,items,default_fn){
var index = com.wsscode.misc.coll.index_by.call(null,key,items);
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,(function (input){
var or__4126__auto__ = cljs.core.get.call(null,index,key.call(null,input));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default_fn.call(null,input);
}
})),inputs);
}));

(com.wsscode.misc.coll.restore_order.cljs$lang$maxFixedArity = 4);

/**
 * Same functionality as restore-order, but fixes the arguments order to make
 *   it easier to thread with a default-fn.
 * 
 *   Also, it returns nil for not found items instead of a map with the key.
 */
com.wsscode.misc.coll.restore_order2 = (function com$wsscode$misc$coll$restore_order2(var_args){
var G__46227 = arguments.length;
switch (G__46227) {
case 3:
return com.wsscode.misc.coll.restore_order2.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return com.wsscode.misc.coll.restore_order2.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.coll.restore_order2.cljs$core$IFn$_invoke$arity$3 = (function (inputs,key,items){
return com.wsscode.misc.coll.restore_order.call(null,inputs,key,items,cljs.core.constantly.call(null,null));
}));

(com.wsscode.misc.coll.restore_order2.cljs$core$IFn$_invoke$arity$4 = (function (inputs,key,default_fn,items){
return com.wsscode.misc.coll.restore_order.call(null,inputs,key,items,default_fn);
}));

(com.wsscode.misc.coll.restore_order2.cljs$lang$maxFixedArity = 4);

/**
 * CLJC utility to get an iterator from the collection.
 */
com.wsscode.misc.coll.iterator = (function com$wsscode$misc$coll$iterator(coll){
return cljs.core.iter.call(null,coll);
});
/**
 * Like iterate, but stops when it sees a `nil` value.
 */
com.wsscode.misc.coll.iterate_while = (function com$wsscode$misc$coll$iterate_while(f,x){
return cljs.core.take_while.call(null,cljs.core.some_QMARK_,cljs.core.iterate.call(null,f,x));
});
/**
 * Return true if column add items at head with conj.
 */
com.wsscode.misc.coll.coll_append_at_head_QMARK_ = (function com$wsscode$misc$coll$coll_append_at_head_QMARK_(s){
return (!(((cljs.core.vector_QMARK_.call(null,s)) || (cljs.core.set_QMARK_.call(null,s)))));
});
/**
 * Returns true for sequential collections and sets, false for maps.
 */
com.wsscode.misc.coll.collection_QMARK_ = (function com$wsscode$misc$coll$collection_QMARK_(x){
return ((cljs.core.sequential_QMARK_.call(null,x)) || (cljs.core.set_QMARK_.call(null,x)));
});
/**
 * Compare two vectors, this expects the vectors to be ordered.
 */
com.wsscode.misc.coll.vector_compare = (function com$wsscode$misc$coll$vector_compare(p__46304,p__46305){
while(true){
var vec__46313 = p__46304;
var seq__46314 = cljs.core.seq.call(null,vec__46313);
var first__46315 = cljs.core.first.call(null,seq__46314);
var seq__46314__$1 = cljs.core.next.call(null,seq__46314);
var value1 = first__46315;
var rest1 = seq__46314__$1;
var vec__46317 = p__46305;
var seq__46318 = cljs.core.seq.call(null,vec__46317);
var first__46319 = cljs.core.first.call(null,seq__46318);
var seq__46318__$1 = cljs.core.next.call(null,seq__46318);
var value2 = first__46319;
var rest2 = seq__46318__$1;
var result = cljs.core.compare.call(null,value1,value2);
if((!((result === (0))))){
return result;
} else {
if((value1 == null)){
return (0);
} else {
var G__46634 = rest1;
var G__46635 = rest2;
p__46304 = G__46634;
p__46305 = G__46635;
continue;

}
}
break;
}
});

//# sourceMappingURL=com.wsscode.misc.coll.js.map
