goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.call(null,null);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_.call(null,null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48634 = arguments.length;
var i__4790__auto___48635 = (0);
while(true){
if((i__4790__auto___48635 < len__4789__auto___48634)){
args__4795__auto__.push((arguments[i__4790__auto___48635]));

var G__48636 = (i__4790__auto___48635 + (1));
i__4790__auto___48635 = G__48636;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%c\uD83E\uDC36 shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
}));

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq48485){
var G__48486 = cljs.core.first.call(null,seq48485);
var seq48485__$1 = cljs.core.next.call(null,seq48485);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48486,seq48485__$1);
}));

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5733__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return s.send(cljs.core.pr_str.call(null,msg));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.call(null,msg));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__48492){
var map__48493 = p__48492;
var map__48493__$1 = (((((!((map__48493 == null))))?(((((map__48493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48493.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48493):map__48493);
var src = map__48493__$1;
var resource_id = cljs.core.get.call(null,map__48493__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__48493__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__4185__auto__ = cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__4185__auto__){
return or__4185__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_.call(null,output_name);
}
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__48495 = cljs.core.seq.call(null,sources);
var chunk__48496 = null;
var count__48497 = (0);
var i__48498 = (0);
while(true){
if((i__48498 < count__48497)){
var map__48507 = cljs.core._nth.call(null,chunk__48496,i__48498);
var map__48507__$1 = (((((!((map__48507 == null))))?(((((map__48507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48507.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48507):map__48507);
var src = map__48507__$1;
var resource_id = cljs.core.get.call(null,map__48507__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__48507__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__48507__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__48507__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

try{shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e48509){var e_48637 = e48509;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_48637);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_48637.message)].join('')));
}

var G__48638 = seq__48495;
var G__48639 = chunk__48496;
var G__48640 = count__48497;
var G__48641 = (i__48498 + (1));
seq__48495 = G__48638;
chunk__48496 = G__48639;
count__48497 = G__48640;
i__48498 = G__48641;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__48495);
if(temp__5735__auto__){
var seq__48495__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48495__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__48495__$1);
var G__48642 = cljs.core.chunk_rest.call(null,seq__48495__$1);
var G__48643 = c__4609__auto__;
var G__48644 = cljs.core.count.call(null,c__4609__auto__);
var G__48645 = (0);
seq__48495 = G__48642;
chunk__48496 = G__48643;
count__48497 = G__48644;
i__48498 = G__48645;
continue;
} else {
var map__48510 = cljs.core.first.call(null,seq__48495__$1);
var map__48510__$1 = (((((!((map__48510 == null))))?(((((map__48510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48510.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48510):map__48510);
var src = map__48510__$1;
var resource_id = cljs.core.get.call(null,map__48510__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__48510__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__48510__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__48510__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

try{shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e48513){var e_48646 = e48513;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_48646);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_48646.message)].join('')));
}

var G__48647 = cljs.core.next.call(null,seq__48495__$1);
var G__48648 = null;
var G__48649 = (0);
var G__48650 = (0);
seq__48495 = G__48647;
chunk__48496 = G__48648;
count__48497 = G__48649;
i__48498 = G__48650;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,cljs.core.assoc.call(null,msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})),(function (){
return shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__48515 = cljs.core.seq.call(null,js_requires);
var chunk__48516 = null;
var count__48517 = (0);
var i__48518 = (0);
while(true){
if((i__48518 < count__48517)){
var js_ns = cljs.core._nth.call(null,chunk__48516,i__48518);
var require_str_48651 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_48651);


var G__48652 = seq__48515;
var G__48653 = chunk__48516;
var G__48654 = count__48517;
var G__48655 = (i__48518 + (1));
seq__48515 = G__48652;
chunk__48516 = G__48653;
count__48517 = G__48654;
i__48518 = G__48655;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__48515);
if(temp__5735__auto__){
var seq__48515__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48515__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__48515__$1);
var G__48656 = cljs.core.chunk_rest.call(null,seq__48515__$1);
var G__48657 = c__4609__auto__;
var G__48658 = cljs.core.count.call(null,c__4609__auto__);
var G__48659 = (0);
seq__48515 = G__48656;
chunk__48516 = G__48657;
count__48517 = G__48658;
i__48518 = G__48659;
continue;
} else {
var js_ns = cljs.core.first.call(null,seq__48515__$1);
var require_str_48660 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_48660);


var G__48661 = cljs.core.next.call(null,seq__48515__$1);
var G__48662 = null;
var G__48663 = (0);
var G__48664 = (0);
seq__48515 = G__48661;
chunk__48516 = G__48662;
count__48517 = G__48663;
i__48518 = G__48664;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_.call(null,sources)){
return callback.call(null,cljs.core.PersistentVector.EMPTY);
} else {
return goog.net.XhrIo.send(shadow.cljs.devtools.client.env.files_url.call(null),(function (res){
var req = this;
var content = cljs.reader.read_string.call(null,req.getResponseText());
return callback.call(null,content);
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)),({"content-type": "application/edn; charset=utf-8"}));
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__48520){
var map__48521 = p__48520;
var map__48521__$1 = (((((!((map__48521 == null))))?(((((map__48521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48521):map__48521);
var msg = map__48521__$1;
var info = cljs.core.get.call(null,map__48521__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.call(null,map__48521__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__48523 = info;
var map__48523__$1 = (((((!((map__48523 == null))))?(((((map__48523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48523):map__48523);
var sources = cljs.core.get.call(null,map__48523__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__48523__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.distinct.call(null,(function (){var iter__4582__auto__ = (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48525(s__48526){
return (new cljs.core.LazySeq(null,(function (){
var s__48526__$1 = s__48526;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__48526__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var map__48531 = cljs.core.first.call(null,xs__6292__auto__);
var map__48531__$1 = (((((!((map__48531 == null))))?(((((map__48531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48531):map__48531);
var src = map__48531__$1;
var resource_name = cljs.core.get.call(null,map__48531__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.call(null,map__48531__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4578__auto__ = ((function (s__48526__$1,map__48531,map__48531__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__48523,map__48523__$1,sources,compiled,map__48521,map__48521__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48525_$_iter__48527(s__48528){
return (new cljs.core.LazySeq(null,((function (s__48526__$1,map__48531,map__48531__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__48523,map__48523__$1,sources,compiled,map__48521,map__48521__$1,msg,info,reload_info){
return (function (){
var s__48528__$1 = s__48528;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__48528__$1);
if(temp__5735__auto____$1){
var s__48528__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__48528__$2)){
var c__4580__auto__ = cljs.core.chunk_first.call(null,s__48528__$2);
var size__4581__auto__ = cljs.core.count.call(null,c__4580__auto__);
var b__48530 = cljs.core.chunk_buffer.call(null,size__4581__auto__);
if((function (){var i__48529 = (0);
while(true){
if((i__48529 < size__4581__auto__)){
var warning = cljs.core._nth.call(null,c__4580__auto__,i__48529);
cljs.core.chunk_append.call(null,b__48530,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__48665 = (i__48529 + (1));
i__48529 = G__48665;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__48530),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48525_$_iter__48527.call(null,cljs.core.chunk_rest.call(null,s__48528__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__48530),null);
}
} else {
var warning = cljs.core.first.call(null,s__48528__$2);
return cljs.core.cons.call(null,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48525_$_iter__48527.call(null,cljs.core.rest.call(null,s__48528__$2)));
}
} else {
return null;
}
break;
}
});})(s__48526__$1,map__48531,map__48531__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__48523,map__48523__$1,sources,compiled,map__48521,map__48521__$1,msg,info,reload_info))
,null,null));
});})(s__48526__$1,map__48531,map__48531__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__48523,map__48523__$1,sources,compiled,map__48521,map__48521__$1,msg,info,reload_info))
;
var fs__4579__auto__ = cljs.core.seq.call(null,iterys__4578__auto__.call(null,warnings));
if(fs__4579__auto__){
return cljs.core.concat.call(null,fs__4579__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48525.call(null,cljs.core.rest.call(null,s__48526__$1)));
} else {
var G__48666 = cljs.core.rest.call(null,s__48526__$1);
s__48526__$1 = G__48666;
continue;
}
} else {
var G__48667 = cljs.core.rest.call(null,s__48526__$1);
s__48526__$1 = G__48667;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__.call(null,sources);
})()));
var seq__48535_48668 = cljs.core.seq.call(null,warnings);
var chunk__48536_48669 = null;
var count__48537_48670 = (0);
var i__48538_48671 = (0);
while(true){
if((i__48538_48671 < count__48537_48670)){
var map__48543_48672 = cljs.core._nth.call(null,chunk__48536_48669,i__48538_48671);
var map__48543_48673__$1 = (((((!((map__48543_48672 == null))))?(((((map__48543_48672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48543_48672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48543_48672):map__48543_48672);
var w_48674 = map__48543_48673__$1;
var msg_48675__$1 = cljs.core.get.call(null,map__48543_48673__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_48676 = cljs.core.get.call(null,map__48543_48673__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_48677 = cljs.core.get.call(null,map__48543_48673__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_48678 = cljs.core.get.call(null,map__48543_48673__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_48678)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_48676),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_48677),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_48675__$1)].join(''));


var G__48679 = seq__48535_48668;
var G__48680 = chunk__48536_48669;
var G__48681 = count__48537_48670;
var G__48682 = (i__48538_48671 + (1));
seq__48535_48668 = G__48679;
chunk__48536_48669 = G__48680;
count__48537_48670 = G__48681;
i__48538_48671 = G__48682;
continue;
} else {
var temp__5735__auto___48683 = cljs.core.seq.call(null,seq__48535_48668);
if(temp__5735__auto___48683){
var seq__48535_48684__$1 = temp__5735__auto___48683;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48535_48684__$1)){
var c__4609__auto___48685 = cljs.core.chunk_first.call(null,seq__48535_48684__$1);
var G__48686 = cljs.core.chunk_rest.call(null,seq__48535_48684__$1);
var G__48687 = c__4609__auto___48685;
var G__48688 = cljs.core.count.call(null,c__4609__auto___48685);
var G__48689 = (0);
seq__48535_48668 = G__48686;
chunk__48536_48669 = G__48687;
count__48537_48670 = G__48688;
i__48538_48671 = G__48689;
continue;
} else {
var map__48545_48690 = cljs.core.first.call(null,seq__48535_48684__$1);
var map__48545_48691__$1 = (((((!((map__48545_48690 == null))))?(((((map__48545_48690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48545_48690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48545_48690):map__48545_48690);
var w_48692 = map__48545_48691__$1;
var msg_48693__$1 = cljs.core.get.call(null,map__48545_48691__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_48694 = cljs.core.get.call(null,map__48545_48691__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_48695 = cljs.core.get.call(null,map__48545_48691__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_48696 = cljs.core.get.call(null,map__48545_48691__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_48696)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_48694),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_48695),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_48693__$1)].join(''));


var G__48697 = cljs.core.next.call(null,seq__48535_48684__$1);
var G__48698 = null;
var G__48699 = (0);
var G__48700 = (0);
seq__48535_48668 = G__48697;
chunk__48536_48669 = G__48698;
count__48537_48670 = G__48699;
i__48538_48671 = G__48700;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(((cljs.core.empty_QMARK_.call(null,warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,(function (p__48547){
var map__48548 = p__48547;
var map__48548__$1 = (((((!((map__48548 == null))))?(((((map__48548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48548.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48548):map__48548);
var src = map__48548__$1;
var ns = cljs.core.get.call(null,map__48548__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__48548__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src))) || (((cljs.core.contains_QMARK_.call(null,compiled,resource_id)) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
}),cljs.core.remove.call(null,(function (p__48550){
var map__48551 = p__48550;
var map__48551__$1 = (((((!((map__48551 == null))))?(((((map__48551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48551.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48551):map__48551);
var ns = cljs.core.get.call(null,map__48551__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
}),cljs.core.filter.call(null,(function (p__48553){
var map__48554 = p__48553;
var map__48554__$1 = (((((!((map__48554 == null))))?(((((map__48554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48554):map__48554);
var rc = map__48554__$1;
var module = cljs.core.get.call(null,map__48554__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.call(null,"js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.env.module_is_active_QMARK_.call(null,module)));
}),sources))));
if(cljs.core.not.call(null,cljs.core.seq.call(null,sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(cljs.core.seq.call(null,cljs.core.get_in.call(null,msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"reloading code but no :after-load hooks are configured!","https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks");
}

return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_get,(function (p1__48519_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload.call(null,msg,p1__48519_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
}));
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.call(null,"file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.call(null,new$,(1));
if(((cljs.core._EQ_.call(null,old,rel_new)) || (clojure.string.starts_with_QMARK_.call(null,old,[rel_new,"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
if(((cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not.call(null,node_uri.hasDomain())))){
if(cljs.core._EQ_.call(null,node_abs,new$)){
return new$;
} else {
return false;
}
} else {
return false;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__48556){
var map__48557 = p__48556;
var map__48557__$1 = (((((!((map__48557 == null))))?(((((map__48557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48557.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48557):map__48557);
var msg = map__48557__$1;
var updates = cljs.core.get.call(null,map__48557__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__48559 = cljs.core.seq.call(null,updates);
var chunk__48561 = null;
var count__48562 = (0);
var i__48563 = (0);
while(true){
if((i__48563 < count__48562)){
var path = cljs.core._nth.call(null,chunk__48561,i__48563);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__48589_48701 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__48592_48702 = null;
var count__48593_48703 = (0);
var i__48594_48704 = (0);
while(true){
if((i__48594_48704 < count__48593_48703)){
var node_48705 = cljs.core._nth.call(null,chunk__48592_48702,i__48594_48704);
var path_match_48706 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_48705.getAttribute("href"),path);
if(cljs.core.truth_(path_match_48706)){
var new_link_48707 = (function (){var G__48599 = node_48705.cloneNode(true);
G__48599.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_48706),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48599;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_48706);

goog.dom.insertSiblingAfter(new_link_48707,node_48705);

goog.dom.removeNode(node_48705);


var G__48708 = seq__48589_48701;
var G__48709 = chunk__48592_48702;
var G__48710 = count__48593_48703;
var G__48711 = (i__48594_48704 + (1));
seq__48589_48701 = G__48708;
chunk__48592_48702 = G__48709;
count__48593_48703 = G__48710;
i__48594_48704 = G__48711;
continue;
} else {
var G__48712 = seq__48589_48701;
var G__48713 = chunk__48592_48702;
var G__48714 = count__48593_48703;
var G__48715 = (i__48594_48704 + (1));
seq__48589_48701 = G__48712;
chunk__48592_48702 = G__48713;
count__48593_48703 = G__48714;
i__48594_48704 = G__48715;
continue;
}
} else {
var temp__5735__auto___48716 = cljs.core.seq.call(null,seq__48589_48701);
if(temp__5735__auto___48716){
var seq__48589_48717__$1 = temp__5735__auto___48716;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48589_48717__$1)){
var c__4609__auto___48718 = cljs.core.chunk_first.call(null,seq__48589_48717__$1);
var G__48719 = cljs.core.chunk_rest.call(null,seq__48589_48717__$1);
var G__48720 = c__4609__auto___48718;
var G__48721 = cljs.core.count.call(null,c__4609__auto___48718);
var G__48722 = (0);
seq__48589_48701 = G__48719;
chunk__48592_48702 = G__48720;
count__48593_48703 = G__48721;
i__48594_48704 = G__48722;
continue;
} else {
var node_48723 = cljs.core.first.call(null,seq__48589_48717__$1);
var path_match_48724 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_48723.getAttribute("href"),path);
if(cljs.core.truth_(path_match_48724)){
var new_link_48725 = (function (){var G__48600 = node_48723.cloneNode(true);
G__48600.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_48724),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48600;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_48724);

goog.dom.insertSiblingAfter(new_link_48725,node_48723);

goog.dom.removeNode(node_48723);


var G__48726 = cljs.core.next.call(null,seq__48589_48717__$1);
var G__48727 = null;
var G__48728 = (0);
var G__48729 = (0);
seq__48589_48701 = G__48726;
chunk__48592_48702 = G__48727;
count__48593_48703 = G__48728;
i__48594_48704 = G__48729;
continue;
} else {
var G__48730 = cljs.core.next.call(null,seq__48589_48717__$1);
var G__48731 = null;
var G__48732 = (0);
var G__48733 = (0);
seq__48589_48701 = G__48730;
chunk__48592_48702 = G__48731;
count__48593_48703 = G__48732;
i__48594_48704 = G__48733;
continue;
}
}
} else {
}
}
break;
}


var G__48734 = seq__48559;
var G__48735 = chunk__48561;
var G__48736 = count__48562;
var G__48737 = (i__48563 + (1));
seq__48559 = G__48734;
chunk__48561 = G__48735;
count__48562 = G__48736;
i__48563 = G__48737;
continue;
} else {
var G__48738 = seq__48559;
var G__48739 = chunk__48561;
var G__48740 = count__48562;
var G__48741 = (i__48563 + (1));
seq__48559 = G__48738;
chunk__48561 = G__48739;
count__48562 = G__48740;
i__48563 = G__48741;
continue;
}
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__48559);
if(temp__5735__auto__){
var seq__48559__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48559__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__48559__$1);
var G__48742 = cljs.core.chunk_rest.call(null,seq__48559__$1);
var G__48743 = c__4609__auto__;
var G__48744 = cljs.core.count.call(null,c__4609__auto__);
var G__48745 = (0);
seq__48559 = G__48742;
chunk__48561 = G__48743;
count__48562 = G__48744;
i__48563 = G__48745;
continue;
} else {
var path = cljs.core.first.call(null,seq__48559__$1);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__48601_48746 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__48604_48747 = null;
var count__48605_48748 = (0);
var i__48606_48749 = (0);
while(true){
if((i__48606_48749 < count__48605_48748)){
var node_48750 = cljs.core._nth.call(null,chunk__48604_48747,i__48606_48749);
var path_match_48751 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_48750.getAttribute("href"),path);
if(cljs.core.truth_(path_match_48751)){
var new_link_48752 = (function (){var G__48611 = node_48750.cloneNode(true);
G__48611.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_48751),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48611;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_48751);

goog.dom.insertSiblingAfter(new_link_48752,node_48750);

goog.dom.removeNode(node_48750);


var G__48753 = seq__48601_48746;
var G__48754 = chunk__48604_48747;
var G__48755 = count__48605_48748;
var G__48756 = (i__48606_48749 + (1));
seq__48601_48746 = G__48753;
chunk__48604_48747 = G__48754;
count__48605_48748 = G__48755;
i__48606_48749 = G__48756;
continue;
} else {
var G__48757 = seq__48601_48746;
var G__48758 = chunk__48604_48747;
var G__48759 = count__48605_48748;
var G__48760 = (i__48606_48749 + (1));
seq__48601_48746 = G__48757;
chunk__48604_48747 = G__48758;
count__48605_48748 = G__48759;
i__48606_48749 = G__48760;
continue;
}
} else {
var temp__5735__auto___48761__$1 = cljs.core.seq.call(null,seq__48601_48746);
if(temp__5735__auto___48761__$1){
var seq__48601_48762__$1 = temp__5735__auto___48761__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48601_48762__$1)){
var c__4609__auto___48763 = cljs.core.chunk_first.call(null,seq__48601_48762__$1);
var G__48764 = cljs.core.chunk_rest.call(null,seq__48601_48762__$1);
var G__48765 = c__4609__auto___48763;
var G__48766 = cljs.core.count.call(null,c__4609__auto___48763);
var G__48767 = (0);
seq__48601_48746 = G__48764;
chunk__48604_48747 = G__48765;
count__48605_48748 = G__48766;
i__48606_48749 = G__48767;
continue;
} else {
var node_48768 = cljs.core.first.call(null,seq__48601_48762__$1);
var path_match_48769 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_48768.getAttribute("href"),path);
if(cljs.core.truth_(path_match_48769)){
var new_link_48770 = (function (){var G__48612 = node_48768.cloneNode(true);
G__48612.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_48769),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48612;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_48769);

goog.dom.insertSiblingAfter(new_link_48770,node_48768);

goog.dom.removeNode(node_48768);


var G__48771 = cljs.core.next.call(null,seq__48601_48762__$1);
var G__48772 = null;
var G__48773 = (0);
var G__48774 = (0);
seq__48601_48746 = G__48771;
chunk__48604_48747 = G__48772;
count__48605_48748 = G__48773;
i__48606_48749 = G__48774;
continue;
} else {
var G__48775 = cljs.core.next.call(null,seq__48601_48762__$1);
var G__48776 = null;
var G__48777 = (0);
var G__48778 = (0);
seq__48601_48746 = G__48775;
chunk__48604_48747 = G__48776;
count__48605_48748 = G__48777;
i__48606_48749 = G__48778;
continue;
}
}
} else {
}
}
break;
}


var G__48779 = cljs.core.next.call(null,seq__48559__$1);
var G__48780 = null;
var G__48781 = (0);
var G__48782 = (0);
seq__48559 = G__48779;
chunk__48561 = G__48780;
count__48562 = G__48781;
i__48563 = G__48782;
continue;
} else {
var G__48783 = cljs.core.next.call(null,seq__48559__$1);
var G__48784 = null;
var G__48785 = (0);
var G__48786 = (0);
seq__48559 = G__48783;
chunk__48561 = G__48784;
count__48562 = G__48785;
i__48563 = G__48786;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace.call(null,s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.call(null,shadow.cljs.devtools.client.env.repl_error.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product.call(null),new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root.call(null));
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.call(null,"undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__48613){
var map__48614 = p__48613;
var map__48614__$1 = (((((!((map__48614 == null))))?(((((map__48614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48614):map__48614);
var id = cljs.core.get.call(null,map__48614__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.call(null,map__48614__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call.call(null,(function (){
return shadow.cljs.devtools.client.browser.global_eval.call(null,js);
}),shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg.call(null,cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__48616,done){
var map__48617 = p__48616;
var map__48617__$1 = (((((!((map__48617 == null))))?(((((map__48617.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48617.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48617):map__48617);
var msg = map__48617__$1;
var id = cljs.core.get.call(null,map__48617__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.call(null,map__48617__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.call(null,map__48617__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.call(null,map__48617__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,(function (p__48619){
var map__48620 = p__48619;
var map__48620__$1 = (((((!((map__48620 == null))))?(((((map__48620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48620.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48620):map__48620);
var src = map__48620__$1;
var provides = cljs.core.get.call(null,map__48620__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4174__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not.call(null,cljs.core.some.call(null,reload_namespaces,provides));
} else {
return and__4174__auto__;
}
}),sources));
return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_load,(function (sources__$1){
try{shadow.cljs.devtools.client.browser.do_js_load.call(null,sources__$1);

if(cljs.core.seq.call(null,js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires.call(null,js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}catch (e48622){var e = e48622;
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-error","repl/require-error",1689310021),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"error","error",-978969032),e.message], null));
}finally {done.call(null);
}}));
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__48623,done){
var map__48624 = p__48623;
var map__48624__$1 = (((((!((map__48624 == null))))?(((((map__48624.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48624.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48624):map__48624);
var repl_state = cljs.core.get.call(null,map__48624__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.call(null,map__48624__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);

shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"REPL session start successful");

return done.call(null);
}));
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__48626){
var map__48627 = p__48626;
var map__48627__$1 = (((((!((map__48627 == null))))?(((((map__48627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48627):map__48627);
var id = cljs.core.get.call(null,map__48627__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.call(null,map__48627__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_.call(null,null);
shadow.cljs.devtools.client.browser.stale_client_detected = cljs.core.volatile_BANG_.call(null,false);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__48629,done){
var map__48630 = p__48629;
var map__48630__$1 = (((((!((map__48630 == null))))?(((((map__48630.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48630.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48630):map__48630);
var msg = map__48630__$1;
var type = cljs.core.get.call(null,map__48630__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

var G__48632_48787 = type;
var G__48632_48788__$1 = (((G__48632_48787 instanceof cljs.core.Keyword))?G__48632_48787.fqn:null);
switch (G__48632_48788__$1) {
case "asset-watch":
shadow.cljs.devtools.client.browser.handle_asset_watch.call(null,msg);

break;
case "repl/invoke":
shadow.cljs.devtools.client.browser.repl_invoke.call(null,msg);

break;
case "repl/require":
shadow.cljs.devtools.client.browser.repl_require.call(null,msg,done);

break;
case "repl/set-ns":
shadow.cljs.devtools.client.browser.repl_set_ns.call(null,msg);

break;
case "repl/init":
shadow.cljs.devtools.client.browser.repl_init.call(null,msg,done);

break;
case "repl/session-start":
shadow.cljs.devtools.client.browser.repl_init.call(null,msg,done);

break;
case "repl/ping":
shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","pong","repl/pong",-166610159),new cljs.core.Keyword(null,"time-server","time-server",786726561),new cljs.core.Keyword(null,"time-server","time-server",786726561).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"time-runtime","time-runtime",-40294923),Date.now()], null));

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

shadow.cljs.devtools.client.browser.handle_build_complete.call(null,msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end.call(null);

shadow.cljs.devtools.client.hud.hud_error.call(null,msg);

break;
case "build-init":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide.call(null);

shadow.cljs.devtools.client.hud.load_start.call(null);

break;
case "pong":

break;
case "client/stale":
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
shadow.cljs.devtools.client.env.publish_BANG_.call(null,new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:

}

if(cljs.core.contains_QMARK_.call(null,shadow.cljs.devtools.client.env.async_ops,type)){
return null;
} else {
return done.call(null);
}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
return goog.net.XhrIo.send(["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join(''),(function (res){
var req = this;
var actions = cljs.reader.read_string.call(null,req.getResponseText());
if(cljs.core.truth_(callback)){
return callback.call(null,actions);
} else {
return null;
}
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)),({"content-type": "application/edn; charset=utf-8"}));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.ws_status !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.ws_status = cljs.core.volatile_BANG_.call(null,new cljs.core.Keyword(null,"init","init",-1875481434));
}
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.ws_status).call(null,new cljs.core.Keyword(null,"init","init",-1875481434)))){
return shadow.cljs.devtools.client.browser.ws_connect_impl.call(null);
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.maybe_reconnect = (function shadow$cljs$devtools$client$browser$maybe_reconnect(){
if(((cljs.core.not.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.stale_client_detected))) && (cljs.core.not_EQ_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.ws_status),new cljs.core.Keyword(null,"init","init",-1875481434))))){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"init","init",-1875481434));

return setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(3000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect_impl = (function shadow$cljs$devtools$client$browser$ws_connect_impl(){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connecting","connecting",-1347943866));

try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url.call(null,new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,socket);

(socket.onmessage = (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg.call(null,e.data,shadow.cljs.devtools.client.browser.handle_message);
}));

(socket.onopen = (function (e){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connected","connected",-169833045));

shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.call(null,"goog",shadow.cljs.devtools.client.env.module_format)){
(goog.provide = goog.constructNamespace_);
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket connected!");
}));

(socket.onclose = (function (e){
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error.call(null,(function (){var or__4185__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);

shadow.cljs.devtools.client.env.reset_print_fns_BANG_.call(null);

return shadow.cljs.devtools.client.browser.maybe_reconnect.call(null);
}));

return (socket.onerror = (function (e){
shadow.cljs.devtools.client.hud.connection_error.call(null,"Connection failed!");

shadow.cljs.devtools.client.browser.maybe_reconnect.call(null);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"websocket error",e);
}));
}catch (e48633){var e = e48633;
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket setup failed",e);
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5735__auto___48790 = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto___48790)){
var s_48791 = temp__5735__auto___48790;
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"connection reset!");

(s_48791.onclose = (function (e){
return null;
}));

s_48791.close();

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5735__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto__)){
var s = temp__5735__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__4174__auto__ = document;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.call(null,"loading",document.readyState);
} else {
return and__4174__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
