goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__43260 = arguments.length;
switch (G__43260) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43267 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43267 = (function (f,blockable,meta43268){
this.f = f;
this.blockable = blockable;
this.meta43268 = meta43268;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43269,meta43268__$1){
var self__ = this;
var _43269__$1 = this;
return (new cljs.core.async.t_cljs$core$async43267(self__.f,self__.blockable,meta43268__$1));
}));

(cljs.core.async.t_cljs$core$async43267.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43269){
var self__ = this;
var _43269__$1 = this;
return self__.meta43268;
}));

(cljs.core.async.t_cljs$core$async43267.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43267.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43267.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async43267.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async43267.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta43268","meta43268",-347813703,null)], null);
}));

(cljs.core.async.t_cljs$core$async43267.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43267.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43267");

(cljs.core.async.t_cljs$core$async43267.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async43267");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43267.
 */
cljs.core.async.__GT_t_cljs$core$async43267 = (function cljs$core$async$__GT_t_cljs$core$async43267(f__$1,blockable__$1,meta43268){
return (new cljs.core.async.t_cljs$core$async43267(f__$1,blockable__$1,meta43268));
});

}

return (new cljs.core.async.t_cljs$core$async43267(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__43328 = arguments.length;
switch (G__43328) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__43356 = arguments.length;
switch (G__43356) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__43377 = arguments.length;
switch (G__43377) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_46039 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_46039);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_46039);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__43439 = arguments.length;
switch (G__43439) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4666__auto___46053 = n;
var x_46054 = (0);
while(true){
if((x_46054 < n__4666__auto___46053)){
(a[x_46054] = x_46054);

var G__46059 = (x_46054 + (1));
x_46054 = G__46059;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43474 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43474 = (function (flag,meta43475){
this.flag = flag;
this.meta43475 = meta43475;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43474.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43476,meta43475__$1){
var self__ = this;
var _43476__$1 = this;
return (new cljs.core.async.t_cljs$core$async43474(self__.flag,meta43475__$1));
}));

(cljs.core.async.t_cljs$core$async43474.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43476){
var self__ = this;
var _43476__$1 = this;
return self__.meta43475;
}));

(cljs.core.async.t_cljs$core$async43474.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43474.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async43474.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43474.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async43474.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta43475","meta43475",1305176453,null)], null);
}));

(cljs.core.async.t_cljs$core$async43474.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43474.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43474");

(cljs.core.async.t_cljs$core$async43474.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async43474");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43474.
 */
cljs.core.async.__GT_t_cljs$core$async43474 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async43474(flag__$1,meta43475){
return (new cljs.core.async.t_cljs$core$async43474(flag__$1,meta43475));
});

}

return (new cljs.core.async.t_cljs$core$async43474(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43507 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43507 = (function (flag,cb,meta43508){
this.flag = flag;
this.cb = cb;
this.meta43508 = meta43508;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43507.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43509,meta43508__$1){
var self__ = this;
var _43509__$1 = this;
return (new cljs.core.async.t_cljs$core$async43507(self__.flag,self__.cb,meta43508__$1));
}));

(cljs.core.async.t_cljs$core$async43507.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43509){
var self__ = this;
var _43509__$1 = this;
return self__.meta43508;
}));

(cljs.core.async.t_cljs$core$async43507.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43507.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async43507.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43507.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async43507.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta43508","meta43508",172676563,null)], null);
}));

(cljs.core.async.t_cljs$core$async43507.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43507.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43507");

(cljs.core.async.t_cljs$core$async43507.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async43507");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43507.
 */
cljs.core.async.__GT_t_cljs$core$async43507 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async43507(flag__$1,cb__$1,meta43508){
return (new cljs.core.async.t_cljs$core$async43507(flag__$1,cb__$1,meta43508));
});

}

return (new cljs.core.async.t_cljs$core$async43507(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43541_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43541_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43542_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43542_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4185__auto__ = wport;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46085 = (i + (1));
i = G__46085;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4185__auto__ = ret;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4174__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___46090 = arguments.length;
var i__4790__auto___46091 = (0);
while(true){
if((i__4790__auto___46091 < len__4789__auto___46090)){
args__4795__auto__.push((arguments[i__4790__auto___46091]));

var G__46092 = (i__4790__auto___46091 + (1));
i__4790__auto___46091 = G__46092;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__43579){
var map__43581 = p__43579;
var map__43581__$1 = (((((!((map__43581 == null))))?(((((map__43581.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43581.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43581):map__43581);
var opts = map__43581__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq43559){
var G__43563 = cljs.core.first.call(null,seq43559);
var seq43559__$1 = cljs.core.next.call(null,seq43559);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43563,seq43559__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__43624 = arguments.length;
switch (G__43624) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43103__auto___46113 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_43719){
var state_val_43721 = (state_43719[(1)]);
if((state_val_43721 === (7))){
var inst_43714 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
var statearr_43725_46114 = state_43719__$1;
(statearr_43725_46114[(2)] = inst_43714);

(statearr_43725_46114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (1))){
var state_43719__$1 = state_43719;
var statearr_43726_46115 = state_43719__$1;
(statearr_43726_46115[(2)] = null);

(statearr_43726_46115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (4))){
var inst_43682 = (state_43719[(7)]);
var inst_43682__$1 = (state_43719[(2)]);
var inst_43687 = (inst_43682__$1 == null);
var state_43719__$1 = (function (){var statearr_43727 = state_43719;
(statearr_43727[(7)] = inst_43682__$1);

return statearr_43727;
})();
if(cljs.core.truth_(inst_43687)){
var statearr_43728_46116 = state_43719__$1;
(statearr_43728_46116[(1)] = (5));

} else {
var statearr_43729_46117 = state_43719__$1;
(statearr_43729_46117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (13))){
var state_43719__$1 = state_43719;
var statearr_43730_46118 = state_43719__$1;
(statearr_43730_46118[(2)] = null);

(statearr_43730_46118[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (6))){
var inst_43682 = (state_43719[(7)]);
var state_43719__$1 = state_43719;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43719__$1,(11),to,inst_43682);
} else {
if((state_val_43721 === (3))){
var inst_43717 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43719__$1,inst_43717);
} else {
if((state_val_43721 === (12))){
var state_43719__$1 = state_43719;
var statearr_43742_46119 = state_43719__$1;
(statearr_43742_46119[(2)] = null);

(statearr_43742_46119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (2))){
var state_43719__$1 = state_43719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43719__$1,(4),from);
} else {
if((state_val_43721 === (11))){
var inst_43705 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
if(cljs.core.truth_(inst_43705)){
var statearr_43744_46120 = state_43719__$1;
(statearr_43744_46120[(1)] = (12));

} else {
var statearr_43749_46121 = state_43719__$1;
(statearr_43749_46121[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (9))){
var state_43719__$1 = state_43719;
var statearr_43751_46122 = state_43719__$1;
(statearr_43751_46122[(2)] = null);

(statearr_43751_46122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (5))){
var state_43719__$1 = state_43719;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43754_46123 = state_43719__$1;
(statearr_43754_46123[(1)] = (8));

} else {
var statearr_43756_46124 = state_43719__$1;
(statearr_43756_46124[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (14))){
var inst_43712 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
var statearr_43757_46125 = state_43719__$1;
(statearr_43757_46125[(2)] = inst_43712);

(statearr_43757_46125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (10))){
var inst_43702 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
var statearr_43758_46126 = state_43719__$1;
(statearr_43758_46126[(2)] = inst_43702);

(statearr_43758_46126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43721 === (8))){
var inst_43693 = cljs.core.async.close_BANG_.call(null,to);
var state_43719__$1 = state_43719;
var statearr_43759_46127 = state_43719__$1;
(statearr_43759_46127[(2)] = inst_43693);

(statearr_43759_46127[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_43762 = [null,null,null,null,null,null,null,null];
(statearr_43762[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_43762[(1)] = (1));

return statearr_43762;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_43719){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_43719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e43765){if((e43765 instanceof Object)){
var ex__42763__auto__ = e43765;
var statearr_43766_46129 = state_43719;
(statearr_43766_46129[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43719);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43765;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46133 = state_43719;
state_43719 = G__46133;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_43719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_43719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_43767 = f__43110__auto__.call(null);
(statearr_43767[(6)] = c__43103__auto___46113);

return statearr_43767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__43782){
var vec__43783 = p__43782;
var v = cljs.core.nth.call(null,vec__43783,(0),null);
var p = cljs.core.nth.call(null,vec__43783,(1),null);
var job = vec__43783;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__43103__auto___46138 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_43791){
var state_val_43792 = (state_43791[(1)]);
if((state_val_43792 === (1))){
var state_43791__$1 = state_43791;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43791__$1,(2),res,v);
} else {
if((state_val_43792 === (2))){
var inst_43788 = (state_43791[(2)]);
var inst_43789 = cljs.core.async.close_BANG_.call(null,res);
var state_43791__$1 = (function (){var statearr_43798 = state_43791;
(statearr_43798[(7)] = inst_43788);

return statearr_43798;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43791__$1,inst_43789);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0 = (function (){
var statearr_43800 = [null,null,null,null,null,null,null,null];
(statearr_43800[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__);

(statearr_43800[(1)] = (1));

return statearr_43800;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1 = (function (state_43791){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_43791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e43802){if((e43802 instanceof Object)){
var ex__42763__auto__ = e43802;
var statearr_43803_46141 = state_43791;
(statearr_43803_46141[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43802;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46142 = state_43791;
state_43791 = G__46142;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = function(state_43791){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1.call(this,state_43791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_43806 = f__43110__auto__.call(null);
(statearr_43806[(6)] = c__43103__auto___46138);

return statearr_43806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__43807){
var vec__43808 = p__43807;
var v = cljs.core.nth.call(null,vec__43808,(0),null);
var p = cljs.core.nth.call(null,vec__43808,(1),null);
var job = vec__43808;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4666__auto___46146 = n;
var __46147 = (0);
while(true){
if((__46147 < n__4666__auto___46146)){
var G__43819_46148 = type;
var G__43819_46149__$1 = (((G__43819_46148 instanceof cljs.core.Keyword))?G__43819_46148.fqn:null);
switch (G__43819_46149__$1) {
case "compute":
var c__43103__auto___46152 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46147,c__43103__auto___46152,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async){
return (function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = ((function (__46147,c__43103__auto___46152,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async){
return (function (state_43837){
var state_val_43838 = (state_43837[(1)]);
if((state_val_43838 === (1))){
var state_43837__$1 = state_43837;
var statearr_43840_46155 = state_43837__$1;
(statearr_43840_46155[(2)] = null);

(statearr_43840_46155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43838 === (2))){
var state_43837__$1 = state_43837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43837__$1,(4),jobs);
} else {
if((state_val_43838 === (3))){
var inst_43835 = (state_43837[(2)]);
var state_43837__$1 = state_43837;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43837__$1,inst_43835);
} else {
if((state_val_43838 === (4))){
var inst_43827 = (state_43837[(2)]);
var inst_43828 = process.call(null,inst_43827);
var state_43837__$1 = state_43837;
if(cljs.core.truth_(inst_43828)){
var statearr_43843_46158 = state_43837__$1;
(statearr_43843_46158[(1)] = (5));

} else {
var statearr_43844_46159 = state_43837__$1;
(statearr_43844_46159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43838 === (5))){
var state_43837__$1 = state_43837;
var statearr_43850_46161 = state_43837__$1;
(statearr_43850_46161[(2)] = null);

(statearr_43850_46161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43838 === (6))){
var state_43837__$1 = state_43837;
var statearr_43852_46163 = state_43837__$1;
(statearr_43852_46163[(2)] = null);

(statearr_43852_46163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43838 === (7))){
var inst_43833 = (state_43837[(2)]);
var state_43837__$1 = state_43837;
var statearr_43853_46164 = state_43837__$1;
(statearr_43853_46164[(2)] = inst_43833);

(statearr_43853_46164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46147,c__43103__auto___46152,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async))
;
return ((function (__46147,switch__42759__auto__,c__43103__auto___46152,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0 = (function (){
var statearr_43855 = [null,null,null,null,null,null,null];
(statearr_43855[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__);

(statearr_43855[(1)] = (1));

return statearr_43855;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1 = (function (state_43837){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_43837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e43860){if((e43860 instanceof Object)){
var ex__42763__auto__ = e43860;
var statearr_43861_46166 = state_43837;
(statearr_43861_46166[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43837);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46168 = state_43837;
state_43837 = G__46168;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = function(state_43837){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1.call(this,state_43837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__;
})()
;})(__46147,switch__42759__auto__,c__43103__auto___46152,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async))
})();
var state__43111__auto__ = (function (){var statearr_43863 = f__43110__auto__.call(null);
(statearr_43863[(6)] = c__43103__auto___46152);

return statearr_43863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
});})(__46147,c__43103__auto___46152,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async))
);


break;
case "async":
var c__43103__auto___46169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46147,c__43103__auto___46169,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async){
return (function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = ((function (__46147,c__43103__auto___46169,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async){
return (function (state_43880){
var state_val_43881 = (state_43880[(1)]);
if((state_val_43881 === (1))){
var state_43880__$1 = state_43880;
var statearr_43884_46172 = state_43880__$1;
(statearr_43884_46172[(2)] = null);

(statearr_43884_46172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43881 === (2))){
var state_43880__$1 = state_43880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43880__$1,(4),jobs);
} else {
if((state_val_43881 === (3))){
var inst_43878 = (state_43880[(2)]);
var state_43880__$1 = state_43880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43880__$1,inst_43878);
} else {
if((state_val_43881 === (4))){
var inst_43868 = (state_43880[(2)]);
var inst_43869 = async.call(null,inst_43868);
var state_43880__$1 = state_43880;
if(cljs.core.truth_(inst_43869)){
var statearr_43888_46176 = state_43880__$1;
(statearr_43888_46176[(1)] = (5));

} else {
var statearr_43891_46177 = state_43880__$1;
(statearr_43891_46177[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43881 === (5))){
var state_43880__$1 = state_43880;
var statearr_43893_46178 = state_43880__$1;
(statearr_43893_46178[(2)] = null);

(statearr_43893_46178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43881 === (6))){
var state_43880__$1 = state_43880;
var statearr_43894_46179 = state_43880__$1;
(statearr_43894_46179[(2)] = null);

(statearr_43894_46179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43881 === (7))){
var inst_43875 = (state_43880[(2)]);
var state_43880__$1 = state_43880;
var statearr_43895_46180 = state_43880__$1;
(statearr_43895_46180[(2)] = inst_43875);

(statearr_43895_46180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46147,c__43103__auto___46169,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async))
;
return ((function (__46147,switch__42759__auto__,c__43103__auto___46169,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0 = (function (){
var statearr_43896 = [null,null,null,null,null,null,null];
(statearr_43896[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__);

(statearr_43896[(1)] = (1));

return statearr_43896;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1 = (function (state_43880){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_43880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e43898){if((e43898 instanceof Object)){
var ex__42763__auto__ = e43898;
var statearr_43899_46183 = state_43880;
(statearr_43899_46183[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43880);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46185 = state_43880;
state_43880 = G__46185;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = function(state_43880){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1.call(this,state_43880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__;
})()
;})(__46147,switch__42759__auto__,c__43103__auto___46169,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async))
})();
var state__43111__auto__ = (function (){var statearr_43906 = f__43110__auto__.call(null);
(statearr_43906[(6)] = c__43103__auto___46169);

return statearr_43906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
});})(__46147,c__43103__auto___46169,G__43819_46148,G__43819_46149__$1,n__4666__auto___46146,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43819_46149__$1)].join('')));

}

var G__46187 = (__46147 + (1));
__46147 = G__46187;
continue;
} else {
}
break;
}

var c__43103__auto___46188 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_43935){
var state_val_43937 = (state_43935[(1)]);
if((state_val_43937 === (7))){
var inst_43931 = (state_43935[(2)]);
var state_43935__$1 = state_43935;
var statearr_43943_46190 = state_43935__$1;
(statearr_43943_46190[(2)] = inst_43931);

(statearr_43943_46190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43937 === (1))){
var state_43935__$1 = state_43935;
var statearr_43944_46191 = state_43935__$1;
(statearr_43944_46191[(2)] = null);

(statearr_43944_46191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43937 === (4))){
var inst_43912 = (state_43935[(7)]);
var inst_43912__$1 = (state_43935[(2)]);
var inst_43913 = (inst_43912__$1 == null);
var state_43935__$1 = (function (){var statearr_43948 = state_43935;
(statearr_43948[(7)] = inst_43912__$1);

return statearr_43948;
})();
if(cljs.core.truth_(inst_43913)){
var statearr_43949_46196 = state_43935__$1;
(statearr_43949_46196[(1)] = (5));

} else {
var statearr_43950_46197 = state_43935__$1;
(statearr_43950_46197[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43937 === (6))){
var inst_43912 = (state_43935[(7)]);
var inst_43917 = (state_43935[(8)]);
var inst_43917__$1 = cljs.core.async.chan.call(null,(1));
var inst_43918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43923 = [inst_43912,inst_43917__$1];
var inst_43924 = (new cljs.core.PersistentVector(null,2,(5),inst_43918,inst_43923,null));
var state_43935__$1 = (function (){var statearr_43951 = state_43935;
(statearr_43951[(8)] = inst_43917__$1);

return statearr_43951;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43935__$1,(8),jobs,inst_43924);
} else {
if((state_val_43937 === (3))){
var inst_43933 = (state_43935[(2)]);
var state_43935__$1 = state_43935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43935__$1,inst_43933);
} else {
if((state_val_43937 === (2))){
var state_43935__$1 = state_43935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43935__$1,(4),from);
} else {
if((state_val_43937 === (9))){
var inst_43928 = (state_43935[(2)]);
var state_43935__$1 = (function (){var statearr_43952 = state_43935;
(statearr_43952[(9)] = inst_43928);

return statearr_43952;
})();
var statearr_43953_46208 = state_43935__$1;
(statearr_43953_46208[(2)] = null);

(statearr_43953_46208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43937 === (5))){
var inst_43915 = cljs.core.async.close_BANG_.call(null,jobs);
var state_43935__$1 = state_43935;
var statearr_43954_46211 = state_43935__$1;
(statearr_43954_46211[(2)] = inst_43915);

(statearr_43954_46211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43937 === (8))){
var inst_43917 = (state_43935[(8)]);
var inst_43926 = (state_43935[(2)]);
var state_43935__$1 = (function (){var statearr_43955 = state_43935;
(statearr_43955[(10)] = inst_43926);

return statearr_43955;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43935__$1,(9),results,inst_43917);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0 = (function (){
var statearr_43957 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43957[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__);

(statearr_43957[(1)] = (1));

return statearr_43957;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1 = (function (state_43935){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_43935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e43958){if((e43958 instanceof Object)){
var ex__42763__auto__ = e43958;
var statearr_43959_46219 = state_43935;
(statearr_43959_46219[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43935);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43958;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46220 = state_43935;
state_43935 = G__46220;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = function(state_43935){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1.call(this,state_43935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_43962 = f__43110__auto__.call(null);
(statearr_43962[(6)] = c__43103__auto___46188);

return statearr_43962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


var c__43103__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_44002){
var state_val_44003 = (state_44002[(1)]);
if((state_val_44003 === (7))){
var inst_43998 = (state_44002[(2)]);
var state_44002__$1 = state_44002;
var statearr_44005_46225 = state_44002__$1;
(statearr_44005_46225[(2)] = inst_43998);

(statearr_44005_46225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (20))){
var state_44002__$1 = state_44002;
var statearr_44008_46226 = state_44002__$1;
(statearr_44008_46226[(2)] = null);

(statearr_44008_46226[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (1))){
var state_44002__$1 = state_44002;
var statearr_44009_46230 = state_44002__$1;
(statearr_44009_46230[(2)] = null);

(statearr_44009_46230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (4))){
var inst_43967 = (state_44002[(7)]);
var inst_43967__$1 = (state_44002[(2)]);
var inst_43968 = (inst_43967__$1 == null);
var state_44002__$1 = (function (){var statearr_44012 = state_44002;
(statearr_44012[(7)] = inst_43967__$1);

return statearr_44012;
})();
if(cljs.core.truth_(inst_43968)){
var statearr_44013_46235 = state_44002__$1;
(statearr_44013_46235[(1)] = (5));

} else {
var statearr_44017_46236 = state_44002__$1;
(statearr_44017_46236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (15))){
var inst_43980 = (state_44002[(8)]);
var state_44002__$1 = state_44002;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44002__$1,(18),to,inst_43980);
} else {
if((state_val_44003 === (21))){
var inst_43993 = (state_44002[(2)]);
var state_44002__$1 = state_44002;
var statearr_44020_46239 = state_44002__$1;
(statearr_44020_46239[(2)] = inst_43993);

(statearr_44020_46239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (13))){
var inst_43995 = (state_44002[(2)]);
var state_44002__$1 = (function (){var statearr_44022 = state_44002;
(statearr_44022[(9)] = inst_43995);

return statearr_44022;
})();
var statearr_44023_46241 = state_44002__$1;
(statearr_44023_46241[(2)] = null);

(statearr_44023_46241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (6))){
var inst_43967 = (state_44002[(7)]);
var state_44002__$1 = state_44002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44002__$1,(11),inst_43967);
} else {
if((state_val_44003 === (17))){
var inst_43988 = (state_44002[(2)]);
var state_44002__$1 = state_44002;
if(cljs.core.truth_(inst_43988)){
var statearr_44031_46248 = state_44002__$1;
(statearr_44031_46248[(1)] = (19));

} else {
var statearr_44033_46250 = state_44002__$1;
(statearr_44033_46250[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (3))){
var inst_44000 = (state_44002[(2)]);
var state_44002__$1 = state_44002;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44002__$1,inst_44000);
} else {
if((state_val_44003 === (12))){
var inst_43977 = (state_44002[(10)]);
var state_44002__$1 = state_44002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44002__$1,(14),inst_43977);
} else {
if((state_val_44003 === (2))){
var state_44002__$1 = state_44002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44002__$1,(4),results);
} else {
if((state_val_44003 === (19))){
var state_44002__$1 = state_44002;
var statearr_44042_46251 = state_44002__$1;
(statearr_44042_46251[(2)] = null);

(statearr_44042_46251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (11))){
var inst_43977 = (state_44002[(2)]);
var state_44002__$1 = (function (){var statearr_44046 = state_44002;
(statearr_44046[(10)] = inst_43977);

return statearr_44046;
})();
var statearr_44048_46256 = state_44002__$1;
(statearr_44048_46256[(2)] = null);

(statearr_44048_46256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (9))){
var state_44002__$1 = state_44002;
var statearr_44055_46257 = state_44002__$1;
(statearr_44055_46257[(2)] = null);

(statearr_44055_46257[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (5))){
var state_44002__$1 = state_44002;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44056_46259 = state_44002__$1;
(statearr_44056_46259[(1)] = (8));

} else {
var statearr_44057_46260 = state_44002__$1;
(statearr_44057_46260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (14))){
var inst_43980 = (state_44002[(8)]);
var inst_43980__$1 = (state_44002[(2)]);
var inst_43981 = (inst_43980__$1 == null);
var inst_43982 = cljs.core.not.call(null,inst_43981);
var state_44002__$1 = (function (){var statearr_44061 = state_44002;
(statearr_44061[(8)] = inst_43980__$1);

return statearr_44061;
})();
if(inst_43982){
var statearr_44062_46263 = state_44002__$1;
(statearr_44062_46263[(1)] = (15));

} else {
var statearr_44063_46264 = state_44002__$1;
(statearr_44063_46264[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (16))){
var state_44002__$1 = state_44002;
var statearr_44067_46265 = state_44002__$1;
(statearr_44067_46265[(2)] = false);

(statearr_44067_46265[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (10))){
var inst_43974 = (state_44002[(2)]);
var state_44002__$1 = state_44002;
var statearr_44068_46267 = state_44002__$1;
(statearr_44068_46267[(2)] = inst_43974);

(statearr_44068_46267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (18))){
var inst_43985 = (state_44002[(2)]);
var state_44002__$1 = state_44002;
var statearr_44069_46269 = state_44002__$1;
(statearr_44069_46269[(2)] = inst_43985);

(statearr_44069_46269[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44003 === (8))){
var inst_43971 = cljs.core.async.close_BANG_.call(null,to);
var state_44002__$1 = state_44002;
var statearr_44070_46270 = state_44002__$1;
(statearr_44070_46270[(2)] = inst_43971);

(statearr_44070_46270[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0 = (function (){
var statearr_44075 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44075[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__);

(statearr_44075[(1)] = (1));

return statearr_44075;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1 = (function (state_44002){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_44002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e44076){if((e44076 instanceof Object)){
var ex__42763__auto__ = e44076;
var statearr_44077_46271 = state_44002;
(statearr_44077_46271[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44076;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46276 = state_44002;
state_44002 = G__46276;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__ = function(state_44002){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1.call(this,state_44002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42760__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_44078 = f__43110__auto__.call(null);
(statearr_44078[(6)] = c__43103__auto__);

return statearr_44078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));

return c__43103__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44081 = arguments.length;
switch (G__44081) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44091 = arguments.length;
switch (G__44091) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44100 = arguments.length;
switch (G__44100) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__43103__auto___46340 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_44133){
var state_val_44134 = (state_44133[(1)]);
if((state_val_44134 === (7))){
var inst_44129 = (state_44133[(2)]);
var state_44133__$1 = state_44133;
var statearr_44137_46341 = state_44133__$1;
(statearr_44137_46341[(2)] = inst_44129);

(statearr_44137_46341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (1))){
var state_44133__$1 = state_44133;
var statearr_44141_46346 = state_44133__$1;
(statearr_44141_46346[(2)] = null);

(statearr_44141_46346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (4))){
var inst_44110 = (state_44133[(7)]);
var inst_44110__$1 = (state_44133[(2)]);
var inst_44111 = (inst_44110__$1 == null);
var state_44133__$1 = (function (){var statearr_44143 = state_44133;
(statearr_44143[(7)] = inst_44110__$1);

return statearr_44143;
})();
if(cljs.core.truth_(inst_44111)){
var statearr_44146_46352 = state_44133__$1;
(statearr_44146_46352[(1)] = (5));

} else {
var statearr_44148_46353 = state_44133__$1;
(statearr_44148_46353[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (13))){
var state_44133__$1 = state_44133;
var statearr_44149_46355 = state_44133__$1;
(statearr_44149_46355[(2)] = null);

(statearr_44149_46355[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (6))){
var inst_44110 = (state_44133[(7)]);
var inst_44116 = p.call(null,inst_44110);
var state_44133__$1 = state_44133;
if(cljs.core.truth_(inst_44116)){
var statearr_44150_46362 = state_44133__$1;
(statearr_44150_46362[(1)] = (9));

} else {
var statearr_44153_46364 = state_44133__$1;
(statearr_44153_46364[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (3))){
var inst_44131 = (state_44133[(2)]);
var state_44133__$1 = state_44133;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44133__$1,inst_44131);
} else {
if((state_val_44134 === (12))){
var state_44133__$1 = state_44133;
var statearr_44154_46365 = state_44133__$1;
(statearr_44154_46365[(2)] = null);

(statearr_44154_46365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (2))){
var state_44133__$1 = state_44133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44133__$1,(4),ch);
} else {
if((state_val_44134 === (11))){
var inst_44110 = (state_44133[(7)]);
var inst_44120 = (state_44133[(2)]);
var state_44133__$1 = state_44133;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44133__$1,(8),inst_44120,inst_44110);
} else {
if((state_val_44134 === (9))){
var state_44133__$1 = state_44133;
var statearr_44159_46371 = state_44133__$1;
(statearr_44159_46371[(2)] = tc);

(statearr_44159_46371[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (5))){
var inst_44113 = cljs.core.async.close_BANG_.call(null,tc);
var inst_44114 = cljs.core.async.close_BANG_.call(null,fc);
var state_44133__$1 = (function (){var statearr_44161 = state_44133;
(statearr_44161[(8)] = inst_44113);

return statearr_44161;
})();
var statearr_44162_46372 = state_44133__$1;
(statearr_44162_46372[(2)] = inst_44114);

(statearr_44162_46372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (14))){
var inst_44127 = (state_44133[(2)]);
var state_44133__$1 = state_44133;
var statearr_44163_46373 = state_44133__$1;
(statearr_44163_46373[(2)] = inst_44127);

(statearr_44163_46373[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (10))){
var state_44133__$1 = state_44133;
var statearr_44164_46378 = state_44133__$1;
(statearr_44164_46378[(2)] = fc);

(statearr_44164_46378[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44134 === (8))){
var inst_44122 = (state_44133[(2)]);
var state_44133__$1 = state_44133;
if(cljs.core.truth_(inst_44122)){
var statearr_44169_46380 = state_44133__$1;
(statearr_44169_46380[(1)] = (12));

} else {
var statearr_44170_46381 = state_44133__$1;
(statearr_44170_46381[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_44171 = [null,null,null,null,null,null,null,null,null];
(statearr_44171[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_44171[(1)] = (1));

return statearr_44171;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_44133){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_44133);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e44173){if((e44173 instanceof Object)){
var ex__42763__auto__ = e44173;
var statearr_44174_46387 = state_44133;
(statearr_44174_46387[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44133);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44173;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46388 = state_44133;
state_44133 = G__46388;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_44133){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_44133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_44176 = f__43110__auto__.call(null);
(statearr_44176[(6)] = c__43103__auto___46340);

return statearr_44176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43103__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_44202){
var state_val_44203 = (state_44202[(1)]);
if((state_val_44203 === (7))){
var inst_44198 = (state_44202[(2)]);
var state_44202__$1 = state_44202;
var statearr_44204_46396 = state_44202__$1;
(statearr_44204_46396[(2)] = inst_44198);

(statearr_44204_46396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44203 === (1))){
var inst_44180 = init;
var state_44202__$1 = (function (){var statearr_44205 = state_44202;
(statearr_44205[(7)] = inst_44180);

return statearr_44205;
})();
var statearr_44206_46402 = state_44202__$1;
(statearr_44206_46402[(2)] = null);

(statearr_44206_46402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44203 === (4))){
var inst_44184 = (state_44202[(8)]);
var inst_44184__$1 = (state_44202[(2)]);
var inst_44185 = (inst_44184__$1 == null);
var state_44202__$1 = (function (){var statearr_44207 = state_44202;
(statearr_44207[(8)] = inst_44184__$1);

return statearr_44207;
})();
if(cljs.core.truth_(inst_44185)){
var statearr_44210_46409 = state_44202__$1;
(statearr_44210_46409[(1)] = (5));

} else {
var statearr_44211_46414 = state_44202__$1;
(statearr_44211_46414[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44203 === (6))){
var inst_44188 = (state_44202[(9)]);
var inst_44184 = (state_44202[(8)]);
var inst_44180 = (state_44202[(7)]);
var inst_44188__$1 = f.call(null,inst_44180,inst_44184);
var inst_44189 = cljs.core.reduced_QMARK_.call(null,inst_44188__$1);
var state_44202__$1 = (function (){var statearr_44214 = state_44202;
(statearr_44214[(9)] = inst_44188__$1);

return statearr_44214;
})();
if(inst_44189){
var statearr_44215_46421 = state_44202__$1;
(statearr_44215_46421[(1)] = (8));

} else {
var statearr_44217_46424 = state_44202__$1;
(statearr_44217_46424[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44203 === (3))){
var inst_44200 = (state_44202[(2)]);
var state_44202__$1 = state_44202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44202__$1,inst_44200);
} else {
if((state_val_44203 === (2))){
var state_44202__$1 = state_44202;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44202__$1,(4),ch);
} else {
if((state_val_44203 === (9))){
var inst_44188 = (state_44202[(9)]);
var inst_44180 = inst_44188;
var state_44202__$1 = (function (){var statearr_44222 = state_44202;
(statearr_44222[(7)] = inst_44180);

return statearr_44222;
})();
var statearr_44223_46436 = state_44202__$1;
(statearr_44223_46436[(2)] = null);

(statearr_44223_46436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44203 === (5))){
var inst_44180 = (state_44202[(7)]);
var state_44202__$1 = state_44202;
var statearr_44224_46438 = state_44202__$1;
(statearr_44224_46438[(2)] = inst_44180);

(statearr_44224_46438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44203 === (10))){
var inst_44196 = (state_44202[(2)]);
var state_44202__$1 = state_44202;
var statearr_44225_46439 = state_44202__$1;
(statearr_44225_46439[(2)] = inst_44196);

(statearr_44225_46439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44203 === (8))){
var inst_44188 = (state_44202[(9)]);
var inst_44192 = cljs.core.deref.call(null,inst_44188);
var state_44202__$1 = state_44202;
var statearr_44229_46440 = state_44202__$1;
(statearr_44229_46440[(2)] = inst_44192);

(statearr_44229_46440[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__42760__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42760__auto____0 = (function (){
var statearr_44231 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44231[(0)] = cljs$core$async$reduce_$_state_machine__42760__auto__);

(statearr_44231[(1)] = (1));

return statearr_44231;
});
var cljs$core$async$reduce_$_state_machine__42760__auto____1 = (function (state_44202){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_44202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e44232){if((e44232 instanceof Object)){
var ex__42763__auto__ = e44232;
var statearr_44235_46452 = state_44202;
(statearr_44235_46452[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44202);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44232;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46456 = state_44202;
state_44202 = G__46456;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42760__auto__ = function(state_44202){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42760__auto____1.call(this,state_44202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42760__auto____0;
cljs$core$async$reduce_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42760__auto____1;
return cljs$core$async$reduce_$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_44240 = f__43110__auto__.call(null);
(statearr_44240[(6)] = c__43103__auto__);

return statearr_44240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));

return c__43103__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__43103__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_44249){
var state_val_44250 = (state_44249[(1)]);
if((state_val_44250 === (1))){
var inst_44244 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_44249__$1 = state_44249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44249__$1,(2),inst_44244);
} else {
if((state_val_44250 === (2))){
var inst_44246 = (state_44249[(2)]);
var inst_44247 = f__$1.call(null,inst_44246);
var state_44249__$1 = state_44249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44249__$1,inst_44247);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__42760__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42760__auto____0 = (function (){
var statearr_44260 = [null,null,null,null,null,null,null];
(statearr_44260[(0)] = cljs$core$async$transduce_$_state_machine__42760__auto__);

(statearr_44260[(1)] = (1));

return statearr_44260;
});
var cljs$core$async$transduce_$_state_machine__42760__auto____1 = (function (state_44249){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_44249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e44261){if((e44261 instanceof Object)){
var ex__42763__auto__ = e44261;
var statearr_44263_46484 = state_44249;
(statearr_44263_46484[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44249);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44261;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46485 = state_44249;
state_44249 = G__46485;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42760__auto__ = function(state_44249){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42760__auto____1.call(this,state_44249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42760__auto____0;
cljs$core$async$transduce_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42760__auto____1;
return cljs$core$async$transduce_$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_44267 = f__43110__auto__.call(null);
(statearr_44267[(6)] = c__43103__auto__);

return statearr_44267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));

return c__43103__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__44269 = arguments.length;
switch (G__44269) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43103__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_44299){
var state_val_44300 = (state_44299[(1)]);
if((state_val_44300 === (7))){
var inst_44280 = (state_44299[(2)]);
var state_44299__$1 = state_44299;
var statearr_44306_46509 = state_44299__$1;
(statearr_44306_46509[(2)] = inst_44280);

(statearr_44306_46509[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (1))){
var inst_44274 = cljs.core.seq.call(null,coll);
var inst_44275 = inst_44274;
var state_44299__$1 = (function (){var statearr_44308 = state_44299;
(statearr_44308[(7)] = inst_44275);

return statearr_44308;
})();
var statearr_44309_46513 = state_44299__$1;
(statearr_44309_46513[(2)] = null);

(statearr_44309_46513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (4))){
var inst_44275 = (state_44299[(7)]);
var inst_44278 = cljs.core.first.call(null,inst_44275);
var state_44299__$1 = state_44299;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44299__$1,(7),ch,inst_44278);
} else {
if((state_val_44300 === (13))){
var inst_44293 = (state_44299[(2)]);
var state_44299__$1 = state_44299;
var statearr_44314_46520 = state_44299__$1;
(statearr_44314_46520[(2)] = inst_44293);

(statearr_44314_46520[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (6))){
var inst_44283 = (state_44299[(2)]);
var state_44299__$1 = state_44299;
if(cljs.core.truth_(inst_44283)){
var statearr_44315_46521 = state_44299__$1;
(statearr_44315_46521[(1)] = (8));

} else {
var statearr_44316_46523 = state_44299__$1;
(statearr_44316_46523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (3))){
var inst_44297 = (state_44299[(2)]);
var state_44299__$1 = state_44299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44299__$1,inst_44297);
} else {
if((state_val_44300 === (12))){
var state_44299__$1 = state_44299;
var statearr_44318_46526 = state_44299__$1;
(statearr_44318_46526[(2)] = null);

(statearr_44318_46526[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (2))){
var inst_44275 = (state_44299[(7)]);
var state_44299__$1 = state_44299;
if(cljs.core.truth_(inst_44275)){
var statearr_44320_46531 = state_44299__$1;
(statearr_44320_46531[(1)] = (4));

} else {
var statearr_44321_46536 = state_44299__$1;
(statearr_44321_46536[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (11))){
var inst_44290 = cljs.core.async.close_BANG_.call(null,ch);
var state_44299__$1 = state_44299;
var statearr_44322_46537 = state_44299__$1;
(statearr_44322_46537[(2)] = inst_44290);

(statearr_44322_46537[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (9))){
var state_44299__$1 = state_44299;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44323_46539 = state_44299__$1;
(statearr_44323_46539[(1)] = (11));

} else {
var statearr_44324_46541 = state_44299__$1;
(statearr_44324_46541[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (5))){
var inst_44275 = (state_44299[(7)]);
var state_44299__$1 = state_44299;
var statearr_44328_46544 = state_44299__$1;
(statearr_44328_46544[(2)] = inst_44275);

(statearr_44328_46544[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (10))){
var inst_44295 = (state_44299[(2)]);
var state_44299__$1 = state_44299;
var statearr_44334_46545 = state_44299__$1;
(statearr_44334_46545[(2)] = inst_44295);

(statearr_44334_46545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (8))){
var inst_44275 = (state_44299[(7)]);
var inst_44285 = cljs.core.next.call(null,inst_44275);
var inst_44275__$1 = inst_44285;
var state_44299__$1 = (function (){var statearr_44339 = state_44299;
(statearr_44339[(7)] = inst_44275__$1);

return statearr_44339;
})();
var statearr_44340_46548 = state_44299__$1;
(statearr_44340_46548[(2)] = null);

(statearr_44340_46548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_44341 = [null,null,null,null,null,null,null,null];
(statearr_44341[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_44341[(1)] = (1));

return statearr_44341;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_44299){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_44299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e44342){if((e44342 instanceof Object)){
var ex__42763__auto__ = e44342;
var statearr_44346_46555 = state_44299;
(statearr_44346_46555[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44299);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44342;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46556 = state_44299;
state_44299 = G__46556;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_44299){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_44299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_44349 = f__43110__auto__.call(null);
(statearr_44349[(6)] = c__43103__auto__);

return statearr_44349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));

return c__43103__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4487__auto__ = (((_ == null))?null:_);
var m__4488__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,_);
} else {
var m__4485__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4485__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch);
} else {
var m__4485__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m);
} else {
var m__4485__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44376 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44376 = (function (ch,cs,meta44377){
this.ch = ch;
this.cs = cs;
this.meta44377 = meta44377;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44378,meta44377__$1){
var self__ = this;
var _44378__$1 = this;
return (new cljs.core.async.t_cljs$core$async44376(self__.ch,self__.cs,meta44377__$1));
}));

(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44378){
var self__ = this;
var _44378__$1 = this;
return self__.meta44377;
}));

(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async44376.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async44376.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta44377","meta44377",189152843,null)], null);
}));

(cljs.core.async.t_cljs$core$async44376.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44376.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44376");

(cljs.core.async.t_cljs$core$async44376.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async44376");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44376.
 */
cljs.core.async.__GT_t_cljs$core$async44376 = (function cljs$core$async$mult_$___GT_t_cljs$core$async44376(ch__$1,cs__$1,meta44377){
return (new cljs.core.async.t_cljs$core$async44376(ch__$1,cs__$1,meta44377));
});

}

return (new cljs.core.async.t_cljs$core$async44376(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__43103__auto___46602 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_44538){
var state_val_44539 = (state_44538[(1)]);
if((state_val_44539 === (7))){
var inst_44530 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44541_46605 = state_44538__$1;
(statearr_44541_46605[(2)] = inst_44530);

(statearr_44541_46605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (20))){
var inst_44421 = (state_44538[(7)]);
var inst_44433 = cljs.core.first.call(null,inst_44421);
var inst_44434 = cljs.core.nth.call(null,inst_44433,(0),null);
var inst_44435 = cljs.core.nth.call(null,inst_44433,(1),null);
var state_44538__$1 = (function (){var statearr_44547 = state_44538;
(statearr_44547[(8)] = inst_44434);

return statearr_44547;
})();
if(cljs.core.truth_(inst_44435)){
var statearr_44548_46606 = state_44538__$1;
(statearr_44548_46606[(1)] = (22));

} else {
var statearr_44549_46607 = state_44538__$1;
(statearr_44549_46607[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (27))){
var inst_44466 = (state_44538[(9)]);
var inst_44464 = (state_44538[(10)]);
var inst_44386 = (state_44538[(11)]);
var inst_44471 = (state_44538[(12)]);
var inst_44471__$1 = cljs.core._nth.call(null,inst_44464,inst_44466);
var inst_44472 = cljs.core.async.put_BANG_.call(null,inst_44471__$1,inst_44386,done);
var state_44538__$1 = (function (){var statearr_44555 = state_44538;
(statearr_44555[(12)] = inst_44471__$1);

return statearr_44555;
})();
if(cljs.core.truth_(inst_44472)){
var statearr_44560_46611 = state_44538__$1;
(statearr_44560_46611[(1)] = (30));

} else {
var statearr_44561_46612 = state_44538__$1;
(statearr_44561_46612[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (1))){
var state_44538__$1 = state_44538;
var statearr_44562_46613 = state_44538__$1;
(statearr_44562_46613[(2)] = null);

(statearr_44562_46613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (24))){
var inst_44421 = (state_44538[(7)]);
var inst_44440 = (state_44538[(2)]);
var inst_44442 = cljs.core.next.call(null,inst_44421);
var inst_44396 = inst_44442;
var inst_44397 = null;
var inst_44398 = (0);
var inst_44399 = (0);
var state_44538__$1 = (function (){var statearr_44563 = state_44538;
(statearr_44563[(13)] = inst_44397);

(statearr_44563[(14)] = inst_44440);

(statearr_44563[(15)] = inst_44399);

(statearr_44563[(16)] = inst_44398);

(statearr_44563[(17)] = inst_44396);

return statearr_44563;
})();
var statearr_44564_46615 = state_44538__$1;
(statearr_44564_46615[(2)] = null);

(statearr_44564_46615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (39))){
var state_44538__$1 = state_44538;
var statearr_44569_46618 = state_44538__$1;
(statearr_44569_46618[(2)] = null);

(statearr_44569_46618[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (4))){
var inst_44386 = (state_44538[(11)]);
var inst_44386__$1 = (state_44538[(2)]);
var inst_44388 = (inst_44386__$1 == null);
var state_44538__$1 = (function (){var statearr_44570 = state_44538;
(statearr_44570[(11)] = inst_44386__$1);

return statearr_44570;
})();
if(cljs.core.truth_(inst_44388)){
var statearr_44573_46621 = state_44538__$1;
(statearr_44573_46621[(1)] = (5));

} else {
var statearr_44575_46622 = state_44538__$1;
(statearr_44575_46622[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (15))){
var inst_44397 = (state_44538[(13)]);
var inst_44399 = (state_44538[(15)]);
var inst_44398 = (state_44538[(16)]);
var inst_44396 = (state_44538[(17)]);
var inst_44414 = (state_44538[(2)]);
var inst_44415 = (inst_44399 + (1));
var tmp44565 = inst_44397;
var tmp44566 = inst_44398;
var tmp44567 = inst_44396;
var inst_44396__$1 = tmp44567;
var inst_44397__$1 = tmp44565;
var inst_44398__$1 = tmp44566;
var inst_44399__$1 = inst_44415;
var state_44538__$1 = (function (){var statearr_44576 = state_44538;
(statearr_44576[(13)] = inst_44397__$1);

(statearr_44576[(18)] = inst_44414);

(statearr_44576[(15)] = inst_44399__$1);

(statearr_44576[(16)] = inst_44398__$1);

(statearr_44576[(17)] = inst_44396__$1);

return statearr_44576;
})();
var statearr_44577_46623 = state_44538__$1;
(statearr_44577_46623[(2)] = null);

(statearr_44577_46623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (21))){
var inst_44445 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44581_46627 = state_44538__$1;
(statearr_44581_46627[(2)] = inst_44445);

(statearr_44581_46627[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (31))){
var inst_44471 = (state_44538[(12)]);
var inst_44475 = done.call(null,null);
var inst_44476 = cljs.core.async.untap_STAR_.call(null,m,inst_44471);
var state_44538__$1 = (function (){var statearr_44582 = state_44538;
(statearr_44582[(19)] = inst_44475);

return statearr_44582;
})();
var statearr_44583_46628 = state_44538__$1;
(statearr_44583_46628[(2)] = inst_44476);

(statearr_44583_46628[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (32))){
var inst_44466 = (state_44538[(9)]);
var inst_44463 = (state_44538[(20)]);
var inst_44464 = (state_44538[(10)]);
var inst_44465 = (state_44538[(21)]);
var inst_44478 = (state_44538[(2)]);
var inst_44479 = (inst_44466 + (1));
var tmp44578 = inst_44463;
var tmp44579 = inst_44464;
var tmp44580 = inst_44465;
var inst_44463__$1 = tmp44578;
var inst_44464__$1 = tmp44579;
var inst_44465__$1 = tmp44580;
var inst_44466__$1 = inst_44479;
var state_44538__$1 = (function (){var statearr_44584 = state_44538;
(statearr_44584[(9)] = inst_44466__$1);

(statearr_44584[(20)] = inst_44463__$1);

(statearr_44584[(22)] = inst_44478);

(statearr_44584[(10)] = inst_44464__$1);

(statearr_44584[(21)] = inst_44465__$1);

return statearr_44584;
})();
var statearr_44585_46629 = state_44538__$1;
(statearr_44585_46629[(2)] = null);

(statearr_44585_46629[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (40))){
var inst_44498 = (state_44538[(23)]);
var inst_44502 = done.call(null,null);
var inst_44503 = cljs.core.async.untap_STAR_.call(null,m,inst_44498);
var state_44538__$1 = (function (){var statearr_44586 = state_44538;
(statearr_44586[(24)] = inst_44502);

return statearr_44586;
})();
var statearr_44587_46632 = state_44538__$1;
(statearr_44587_46632[(2)] = inst_44503);

(statearr_44587_46632[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (33))){
var inst_44484 = (state_44538[(25)]);
var inst_44487 = cljs.core.chunked_seq_QMARK_.call(null,inst_44484);
var state_44538__$1 = state_44538;
if(inst_44487){
var statearr_44588_46635 = state_44538__$1;
(statearr_44588_46635[(1)] = (36));

} else {
var statearr_44589_46636 = state_44538__$1;
(statearr_44589_46636[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (13))){
var inst_44408 = (state_44538[(26)]);
var inst_44411 = cljs.core.async.close_BANG_.call(null,inst_44408);
var state_44538__$1 = state_44538;
var statearr_44590_46637 = state_44538__$1;
(statearr_44590_46637[(2)] = inst_44411);

(statearr_44590_46637[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (22))){
var inst_44434 = (state_44538[(8)]);
var inst_44437 = cljs.core.async.close_BANG_.call(null,inst_44434);
var state_44538__$1 = state_44538;
var statearr_44591_46639 = state_44538__$1;
(statearr_44591_46639[(2)] = inst_44437);

(statearr_44591_46639[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (36))){
var inst_44484 = (state_44538[(25)]);
var inst_44489 = cljs.core.chunk_first.call(null,inst_44484);
var inst_44490 = cljs.core.chunk_rest.call(null,inst_44484);
var inst_44491 = cljs.core.count.call(null,inst_44489);
var inst_44463 = inst_44490;
var inst_44464 = inst_44489;
var inst_44465 = inst_44491;
var inst_44466 = (0);
var state_44538__$1 = (function (){var statearr_44594 = state_44538;
(statearr_44594[(9)] = inst_44466);

(statearr_44594[(20)] = inst_44463);

(statearr_44594[(10)] = inst_44464);

(statearr_44594[(21)] = inst_44465);

return statearr_44594;
})();
var statearr_44595_46640 = state_44538__$1;
(statearr_44595_46640[(2)] = null);

(statearr_44595_46640[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (41))){
var inst_44484 = (state_44538[(25)]);
var inst_44505 = (state_44538[(2)]);
var inst_44506 = cljs.core.next.call(null,inst_44484);
var inst_44463 = inst_44506;
var inst_44464 = null;
var inst_44465 = (0);
var inst_44466 = (0);
var state_44538__$1 = (function (){var statearr_44597 = state_44538;
(statearr_44597[(9)] = inst_44466);

(statearr_44597[(20)] = inst_44463);

(statearr_44597[(10)] = inst_44464);

(statearr_44597[(27)] = inst_44505);

(statearr_44597[(21)] = inst_44465);

return statearr_44597;
})();
var statearr_44598_46641 = state_44538__$1;
(statearr_44598_46641[(2)] = null);

(statearr_44598_46641[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (43))){
var state_44538__$1 = state_44538;
var statearr_44599_46642 = state_44538__$1;
(statearr_44599_46642[(2)] = null);

(statearr_44599_46642[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (29))){
var inst_44514 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44602_46644 = state_44538__$1;
(statearr_44602_46644[(2)] = inst_44514);

(statearr_44602_46644[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (44))){
var inst_44523 = (state_44538[(2)]);
var state_44538__$1 = (function (){var statearr_44605 = state_44538;
(statearr_44605[(28)] = inst_44523);

return statearr_44605;
})();
var statearr_44606_46645 = state_44538__$1;
(statearr_44606_46645[(2)] = null);

(statearr_44606_46645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (6))){
var inst_44455 = (state_44538[(29)]);
var inst_44454 = cljs.core.deref.call(null,cs);
var inst_44455__$1 = cljs.core.keys.call(null,inst_44454);
var inst_44456 = cljs.core.count.call(null,inst_44455__$1);
var inst_44457 = cljs.core.reset_BANG_.call(null,dctr,inst_44456);
var inst_44462 = cljs.core.seq.call(null,inst_44455__$1);
var inst_44463 = inst_44462;
var inst_44464 = null;
var inst_44465 = (0);
var inst_44466 = (0);
var state_44538__$1 = (function (){var statearr_44607 = state_44538;
(statearr_44607[(9)] = inst_44466);

(statearr_44607[(20)] = inst_44463);

(statearr_44607[(10)] = inst_44464);

(statearr_44607[(29)] = inst_44455__$1);

(statearr_44607[(30)] = inst_44457);

(statearr_44607[(21)] = inst_44465);

return statearr_44607;
})();
var statearr_44608_46651 = state_44538__$1;
(statearr_44608_46651[(2)] = null);

(statearr_44608_46651[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (28))){
var inst_44463 = (state_44538[(20)]);
var inst_44484 = (state_44538[(25)]);
var inst_44484__$1 = cljs.core.seq.call(null,inst_44463);
var state_44538__$1 = (function (){var statearr_44609 = state_44538;
(statearr_44609[(25)] = inst_44484__$1);

return statearr_44609;
})();
if(inst_44484__$1){
var statearr_44610_46664 = state_44538__$1;
(statearr_44610_46664[(1)] = (33));

} else {
var statearr_44611_46666 = state_44538__$1;
(statearr_44611_46666[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (25))){
var inst_44466 = (state_44538[(9)]);
var inst_44465 = (state_44538[(21)]);
var inst_44468 = (inst_44466 < inst_44465);
var inst_44469 = inst_44468;
var state_44538__$1 = state_44538;
if(cljs.core.truth_(inst_44469)){
var statearr_44612_46678 = state_44538__$1;
(statearr_44612_46678[(1)] = (27));

} else {
var statearr_44613_46679 = state_44538__$1;
(statearr_44613_46679[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (34))){
var state_44538__$1 = state_44538;
var statearr_44614_46680 = state_44538__$1;
(statearr_44614_46680[(2)] = null);

(statearr_44614_46680[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (17))){
var state_44538__$1 = state_44538;
var statearr_44615_46681 = state_44538__$1;
(statearr_44615_46681[(2)] = null);

(statearr_44615_46681[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (3))){
var inst_44532 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44538__$1,inst_44532);
} else {
if((state_val_44539 === (12))){
var inst_44450 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44616_46682 = state_44538__$1;
(statearr_44616_46682[(2)] = inst_44450);

(statearr_44616_46682[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (2))){
var state_44538__$1 = state_44538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44538__$1,(4),ch);
} else {
if((state_val_44539 === (23))){
var state_44538__$1 = state_44538;
var statearr_44617_46683 = state_44538__$1;
(statearr_44617_46683[(2)] = null);

(statearr_44617_46683[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (35))){
var inst_44512 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44618_46684 = state_44538__$1;
(statearr_44618_46684[(2)] = inst_44512);

(statearr_44618_46684[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (19))){
var inst_44421 = (state_44538[(7)]);
var inst_44425 = cljs.core.chunk_first.call(null,inst_44421);
var inst_44426 = cljs.core.chunk_rest.call(null,inst_44421);
var inst_44427 = cljs.core.count.call(null,inst_44425);
var inst_44396 = inst_44426;
var inst_44397 = inst_44425;
var inst_44398 = inst_44427;
var inst_44399 = (0);
var state_44538__$1 = (function (){var statearr_44619 = state_44538;
(statearr_44619[(13)] = inst_44397);

(statearr_44619[(15)] = inst_44399);

(statearr_44619[(16)] = inst_44398);

(statearr_44619[(17)] = inst_44396);

return statearr_44619;
})();
var statearr_44621_46685 = state_44538__$1;
(statearr_44621_46685[(2)] = null);

(statearr_44621_46685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (11))){
var inst_44421 = (state_44538[(7)]);
var inst_44396 = (state_44538[(17)]);
var inst_44421__$1 = cljs.core.seq.call(null,inst_44396);
var state_44538__$1 = (function (){var statearr_44622 = state_44538;
(statearr_44622[(7)] = inst_44421__$1);

return statearr_44622;
})();
if(inst_44421__$1){
var statearr_44623_46693 = state_44538__$1;
(statearr_44623_46693[(1)] = (16));

} else {
var statearr_44624_46695 = state_44538__$1;
(statearr_44624_46695[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (9))){
var inst_44452 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44625_46696 = state_44538__$1;
(statearr_44625_46696[(2)] = inst_44452);

(statearr_44625_46696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (5))){
var inst_44394 = cljs.core.deref.call(null,cs);
var inst_44395 = cljs.core.seq.call(null,inst_44394);
var inst_44396 = inst_44395;
var inst_44397 = null;
var inst_44398 = (0);
var inst_44399 = (0);
var state_44538__$1 = (function (){var statearr_44626 = state_44538;
(statearr_44626[(13)] = inst_44397);

(statearr_44626[(15)] = inst_44399);

(statearr_44626[(16)] = inst_44398);

(statearr_44626[(17)] = inst_44396);

return statearr_44626;
})();
var statearr_44630_46703 = state_44538__$1;
(statearr_44630_46703[(2)] = null);

(statearr_44630_46703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (14))){
var state_44538__$1 = state_44538;
var statearr_44631_46704 = state_44538__$1;
(statearr_44631_46704[(2)] = null);

(statearr_44631_46704[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (45))){
var inst_44520 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44632_46708 = state_44538__$1;
(statearr_44632_46708[(2)] = inst_44520);

(statearr_44632_46708[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (26))){
var inst_44455 = (state_44538[(29)]);
var inst_44516 = (state_44538[(2)]);
var inst_44517 = cljs.core.seq.call(null,inst_44455);
var state_44538__$1 = (function (){var statearr_44633 = state_44538;
(statearr_44633[(31)] = inst_44516);

return statearr_44633;
})();
if(inst_44517){
var statearr_44634_46710 = state_44538__$1;
(statearr_44634_46710[(1)] = (42));

} else {
var statearr_44635_46714 = state_44538__$1;
(statearr_44635_46714[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (16))){
var inst_44421 = (state_44538[(7)]);
var inst_44423 = cljs.core.chunked_seq_QMARK_.call(null,inst_44421);
var state_44538__$1 = state_44538;
if(inst_44423){
var statearr_44637_46717 = state_44538__$1;
(statearr_44637_46717[(1)] = (19));

} else {
var statearr_44638_46718 = state_44538__$1;
(statearr_44638_46718[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (38))){
var inst_44509 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44639_46721 = state_44538__$1;
(statearr_44639_46721[(2)] = inst_44509);

(statearr_44639_46721[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (30))){
var state_44538__$1 = state_44538;
var statearr_44642_46724 = state_44538__$1;
(statearr_44642_46724[(2)] = null);

(statearr_44642_46724[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (10))){
var inst_44397 = (state_44538[(13)]);
var inst_44399 = (state_44538[(15)]);
var inst_44407 = cljs.core._nth.call(null,inst_44397,inst_44399);
var inst_44408 = cljs.core.nth.call(null,inst_44407,(0),null);
var inst_44409 = cljs.core.nth.call(null,inst_44407,(1),null);
var state_44538__$1 = (function (){var statearr_44643 = state_44538;
(statearr_44643[(26)] = inst_44408);

return statearr_44643;
})();
if(cljs.core.truth_(inst_44409)){
var statearr_44644_46729 = state_44538__$1;
(statearr_44644_46729[(1)] = (13));

} else {
var statearr_44645_46730 = state_44538__$1;
(statearr_44645_46730[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (18))){
var inst_44448 = (state_44538[(2)]);
var state_44538__$1 = state_44538;
var statearr_44646_46732 = state_44538__$1;
(statearr_44646_46732[(2)] = inst_44448);

(statearr_44646_46732[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (42))){
var state_44538__$1 = state_44538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44538__$1,(45),dchan);
} else {
if((state_val_44539 === (37))){
var inst_44498 = (state_44538[(23)]);
var inst_44484 = (state_44538[(25)]);
var inst_44386 = (state_44538[(11)]);
var inst_44498__$1 = cljs.core.first.call(null,inst_44484);
var inst_44499 = cljs.core.async.put_BANG_.call(null,inst_44498__$1,inst_44386,done);
var state_44538__$1 = (function (){var statearr_44651 = state_44538;
(statearr_44651[(23)] = inst_44498__$1);

return statearr_44651;
})();
if(cljs.core.truth_(inst_44499)){
var statearr_44652_46734 = state_44538__$1;
(statearr_44652_46734[(1)] = (39));

} else {
var statearr_44653_46735 = state_44538__$1;
(statearr_44653_46735[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44539 === (8))){
var inst_44399 = (state_44538[(15)]);
var inst_44398 = (state_44538[(16)]);
var inst_44401 = (inst_44399 < inst_44398);
var inst_44402 = inst_44401;
var state_44538__$1 = state_44538;
if(cljs.core.truth_(inst_44402)){
var statearr_44654_46737 = state_44538__$1;
(statearr_44654_46737[(1)] = (10));

} else {
var statearr_44655_46738 = state_44538__$1;
(statearr_44655_46738[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__42760__auto__ = null;
var cljs$core$async$mult_$_state_machine__42760__auto____0 = (function (){
var statearr_44656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44656[(0)] = cljs$core$async$mult_$_state_machine__42760__auto__);

(statearr_44656[(1)] = (1));

return statearr_44656;
});
var cljs$core$async$mult_$_state_machine__42760__auto____1 = (function (state_44538){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_44538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e44657){if((e44657 instanceof Object)){
var ex__42763__auto__ = e44657;
var statearr_44658_46739 = state_44538;
(statearr_44658_46739[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44538);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44657;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46740 = state_44538;
state_44538 = G__46740;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42760__auto__ = function(state_44538){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42760__auto____1.call(this,state_44538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42760__auto____0;
cljs$core$async$mult_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42760__auto____1;
return cljs$core$async$mult_$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_44659 = f__43110__auto__.call(null);
(statearr_44659[(6)] = c__43103__auto___46602);

return statearr_44659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__44661 = arguments.length;
switch (G__44661) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch);
} else {
var m__4485__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch);
} else {
var m__4485__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m);
} else {
var m__4485__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,state_map);
} else {
var m__4485__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,mode);
} else {
var m__4485__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___46763 = arguments.length;
var i__4790__auto___46764 = (0);
while(true){
if((i__4790__auto___46764 < len__4789__auto___46763)){
args__4795__auto__.push((arguments[i__4790__auto___46764]));

var G__46766 = (i__4790__auto___46764 + (1));
i__4790__auto___46764 = G__46766;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((3) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4796__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__44706){
var map__44707 = p__44706;
var map__44707__$1 = (((((!((map__44707 == null))))?(((((map__44707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44707.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44707):map__44707);
var opts = map__44707__$1;
var statearr_44710_46767 = state;
(statearr_44710_46767[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_44713_46773 = state;
(statearr_44713_46773[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_44716_46774 = state;
(statearr_44716_46774[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq44699){
var G__44700 = cljs.core.first.call(null,seq44699);
var seq44699__$1 = cljs.core.next.call(null,seq44699);
var G__44701 = cljs.core.first.call(null,seq44699__$1);
var seq44699__$2 = cljs.core.next.call(null,seq44699__$1);
var G__44702 = cljs.core.first.call(null,seq44699__$2);
var seq44699__$3 = cljs.core.next.call(null,seq44699__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44700,G__44701,G__44702,seq44699__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44735 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44735 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta44736){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta44736 = meta44736;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44737,meta44736__$1){
var self__ = this;
var _44737__$1 = this;
return (new cljs.core.async.t_cljs$core$async44735(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta44736__$1));
}));

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44737){
var self__ = this;
var _44737__$1 = this;
return self__.meta44736;
}));

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44735.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44735.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta44736","meta44736",-1248577225,null)], null);
}));

(cljs.core.async.t_cljs$core$async44735.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44735.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44735");

(cljs.core.async.t_cljs$core$async44735.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async44735");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44735.
 */
cljs.core.async.__GT_t_cljs$core$async44735 = (function cljs$core$async$mix_$___GT_t_cljs$core$async44735(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44736){
return (new cljs.core.async.t_cljs$core$async44735(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44736));
});

}

return (new cljs.core.async.t_cljs$core$async44735(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43103__auto___46792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_44870){
var state_val_44871 = (state_44870[(1)]);
if((state_val_44871 === (7))){
var inst_44776 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
var statearr_44872_46793 = state_44870__$1;
(statearr_44872_46793[(2)] = inst_44776);

(statearr_44872_46793[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (20))){
var inst_44792 = (state_44870[(7)]);
var state_44870__$1 = state_44870;
var statearr_44873_46794 = state_44870__$1;
(statearr_44873_46794[(2)] = inst_44792);

(statearr_44873_46794[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (27))){
var state_44870__$1 = state_44870;
var statearr_44874_46796 = state_44870__$1;
(statearr_44874_46796[(2)] = null);

(statearr_44874_46796[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (1))){
var inst_44762 = (state_44870[(8)]);
var inst_44762__$1 = calc_state.call(null);
var inst_44765 = (inst_44762__$1 == null);
var inst_44766 = cljs.core.not.call(null,inst_44765);
var state_44870__$1 = (function (){var statearr_44875 = state_44870;
(statearr_44875[(8)] = inst_44762__$1);

return statearr_44875;
})();
if(inst_44766){
var statearr_44876_46797 = state_44870__$1;
(statearr_44876_46797[(1)] = (2));

} else {
var statearr_44877_46799 = state_44870__$1;
(statearr_44877_46799[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (24))){
var inst_44841 = (state_44870[(9)]);
var inst_44826 = (state_44870[(10)]);
var inst_44817 = (state_44870[(11)]);
var inst_44841__$1 = inst_44817.call(null,inst_44826);
var state_44870__$1 = (function (){var statearr_44878 = state_44870;
(statearr_44878[(9)] = inst_44841__$1);

return statearr_44878;
})();
if(cljs.core.truth_(inst_44841__$1)){
var statearr_44879_46800 = state_44870__$1;
(statearr_44879_46800[(1)] = (29));

} else {
var statearr_44880_46801 = state_44870__$1;
(statearr_44880_46801[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (4))){
var inst_44779 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
if(cljs.core.truth_(inst_44779)){
var statearr_44883_46802 = state_44870__$1;
(statearr_44883_46802[(1)] = (8));

} else {
var statearr_44884_46803 = state_44870__$1;
(statearr_44884_46803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (15))){
var inst_44810 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
if(cljs.core.truth_(inst_44810)){
var statearr_44885_46805 = state_44870__$1;
(statearr_44885_46805[(1)] = (19));

} else {
var statearr_44887_46806 = state_44870__$1;
(statearr_44887_46806[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (21))){
var inst_44816 = (state_44870[(12)]);
var inst_44816__$1 = (state_44870[(2)]);
var inst_44817 = cljs.core.get.call(null,inst_44816__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44818 = cljs.core.get.call(null,inst_44816__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44819 = cljs.core.get.call(null,inst_44816__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_44870__$1 = (function (){var statearr_44888 = state_44870;
(statearr_44888[(13)] = inst_44818);

(statearr_44888[(12)] = inst_44816__$1);

(statearr_44888[(11)] = inst_44817);

return statearr_44888;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_44870__$1,(22),inst_44819);
} else {
if((state_val_44871 === (31))){
var inst_44849 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
if(cljs.core.truth_(inst_44849)){
var statearr_44889_46812 = state_44870__$1;
(statearr_44889_46812[(1)] = (32));

} else {
var statearr_44890_46813 = state_44870__$1;
(statearr_44890_46813[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (32))){
var inst_44825 = (state_44870[(14)]);
var state_44870__$1 = state_44870;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44870__$1,(35),out,inst_44825);
} else {
if((state_val_44871 === (33))){
var inst_44816 = (state_44870[(12)]);
var inst_44792 = inst_44816;
var state_44870__$1 = (function (){var statearr_44892 = state_44870;
(statearr_44892[(7)] = inst_44792);

return statearr_44892;
})();
var statearr_44893_46815 = state_44870__$1;
(statearr_44893_46815[(2)] = null);

(statearr_44893_46815[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (13))){
var inst_44792 = (state_44870[(7)]);
var inst_44799 = inst_44792.cljs$lang$protocol_mask$partition0$;
var inst_44800 = (inst_44799 & (64));
var inst_44801 = inst_44792.cljs$core$ISeq$;
var inst_44802 = (cljs.core.PROTOCOL_SENTINEL === inst_44801);
var inst_44803 = ((inst_44800) || (inst_44802));
var state_44870__$1 = state_44870;
if(cljs.core.truth_(inst_44803)){
var statearr_44895_46818 = state_44870__$1;
(statearr_44895_46818[(1)] = (16));

} else {
var statearr_44896_46819 = state_44870__$1;
(statearr_44896_46819[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (22))){
var inst_44826 = (state_44870[(10)]);
var inst_44825 = (state_44870[(14)]);
var inst_44824 = (state_44870[(2)]);
var inst_44825__$1 = cljs.core.nth.call(null,inst_44824,(0),null);
var inst_44826__$1 = cljs.core.nth.call(null,inst_44824,(1),null);
var inst_44828 = (inst_44825__$1 == null);
var inst_44829 = cljs.core._EQ_.call(null,inst_44826__$1,change);
var inst_44830 = ((inst_44828) || (inst_44829));
var state_44870__$1 = (function (){var statearr_44904 = state_44870;
(statearr_44904[(10)] = inst_44826__$1);

(statearr_44904[(14)] = inst_44825__$1);

return statearr_44904;
})();
if(cljs.core.truth_(inst_44830)){
var statearr_44905_46822 = state_44870__$1;
(statearr_44905_46822[(1)] = (23));

} else {
var statearr_44906_46823 = state_44870__$1;
(statearr_44906_46823[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (36))){
var inst_44816 = (state_44870[(12)]);
var inst_44792 = inst_44816;
var state_44870__$1 = (function (){var statearr_44908 = state_44870;
(statearr_44908[(7)] = inst_44792);

return statearr_44908;
})();
var statearr_44909_46825 = state_44870__$1;
(statearr_44909_46825[(2)] = null);

(statearr_44909_46825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (29))){
var inst_44841 = (state_44870[(9)]);
var state_44870__$1 = state_44870;
var statearr_44910_46826 = state_44870__$1;
(statearr_44910_46826[(2)] = inst_44841);

(statearr_44910_46826[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (6))){
var state_44870__$1 = state_44870;
var statearr_44912_46830 = state_44870__$1;
(statearr_44912_46830[(2)] = false);

(statearr_44912_46830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (28))){
var inst_44837 = (state_44870[(2)]);
var inst_44838 = calc_state.call(null);
var inst_44792 = inst_44838;
var state_44870__$1 = (function (){var statearr_44913 = state_44870;
(statearr_44913[(7)] = inst_44792);

(statearr_44913[(15)] = inst_44837);

return statearr_44913;
})();
var statearr_44914_46832 = state_44870__$1;
(statearr_44914_46832[(2)] = null);

(statearr_44914_46832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (25))){
var inst_44866 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
var statearr_44915_46837 = state_44870__$1;
(statearr_44915_46837[(2)] = inst_44866);

(statearr_44915_46837[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (34))){
var inst_44864 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
var statearr_44916_46840 = state_44870__$1;
(statearr_44916_46840[(2)] = inst_44864);

(statearr_44916_46840[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (17))){
var state_44870__$1 = state_44870;
var statearr_44922_46842 = state_44870__$1;
(statearr_44922_46842[(2)] = false);

(statearr_44922_46842[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (3))){
var state_44870__$1 = state_44870;
var statearr_44924_46843 = state_44870__$1;
(statearr_44924_46843[(2)] = false);

(statearr_44924_46843[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (12))){
var inst_44868 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44870__$1,inst_44868);
} else {
if((state_val_44871 === (2))){
var inst_44762 = (state_44870[(8)]);
var inst_44768 = inst_44762.cljs$lang$protocol_mask$partition0$;
var inst_44769 = (inst_44768 & (64));
var inst_44770 = inst_44762.cljs$core$ISeq$;
var inst_44771 = (cljs.core.PROTOCOL_SENTINEL === inst_44770);
var inst_44772 = ((inst_44769) || (inst_44771));
var state_44870__$1 = state_44870;
if(cljs.core.truth_(inst_44772)){
var statearr_44928_46844 = state_44870__$1;
(statearr_44928_46844[(1)] = (5));

} else {
var statearr_44929_46845 = state_44870__$1;
(statearr_44929_46845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (23))){
var inst_44825 = (state_44870[(14)]);
var inst_44832 = (inst_44825 == null);
var state_44870__$1 = state_44870;
if(cljs.core.truth_(inst_44832)){
var statearr_44935_46846 = state_44870__$1;
(statearr_44935_46846[(1)] = (26));

} else {
var statearr_44937_46848 = state_44870__$1;
(statearr_44937_46848[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (35))){
var inst_44852 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
if(cljs.core.truth_(inst_44852)){
var statearr_44944_46849 = state_44870__$1;
(statearr_44944_46849[(1)] = (36));

} else {
var statearr_44946_46852 = state_44870__$1;
(statearr_44946_46852[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (19))){
var inst_44792 = (state_44870[(7)]);
var inst_44813 = cljs.core.apply.call(null,cljs.core.hash_map,inst_44792);
var state_44870__$1 = state_44870;
var statearr_44953_46854 = state_44870__$1;
(statearr_44953_46854[(2)] = inst_44813);

(statearr_44953_46854[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (11))){
var inst_44792 = (state_44870[(7)]);
var inst_44796 = (inst_44792 == null);
var inst_44797 = cljs.core.not.call(null,inst_44796);
var state_44870__$1 = state_44870;
if(inst_44797){
var statearr_44954_46855 = state_44870__$1;
(statearr_44954_46855[(1)] = (13));

} else {
var statearr_44959_46856 = state_44870__$1;
(statearr_44959_46856[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (9))){
var inst_44762 = (state_44870[(8)]);
var state_44870__$1 = state_44870;
var statearr_44960_46857 = state_44870__$1;
(statearr_44960_46857[(2)] = inst_44762);

(statearr_44960_46857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (5))){
var state_44870__$1 = state_44870;
var statearr_44961_46858 = state_44870__$1;
(statearr_44961_46858[(2)] = true);

(statearr_44961_46858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (14))){
var state_44870__$1 = state_44870;
var statearr_44962_46859 = state_44870__$1;
(statearr_44962_46859[(2)] = false);

(statearr_44962_46859[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (26))){
var inst_44826 = (state_44870[(10)]);
var inst_44834 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_44826);
var state_44870__$1 = state_44870;
var statearr_44967_46863 = state_44870__$1;
(statearr_44967_46863[(2)] = inst_44834);

(statearr_44967_46863[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (16))){
var state_44870__$1 = state_44870;
var statearr_44968_46864 = state_44870__$1;
(statearr_44968_46864[(2)] = true);

(statearr_44968_46864[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (38))){
var inst_44857 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
var statearr_44969_46865 = state_44870__$1;
(statearr_44969_46865[(2)] = inst_44857);

(statearr_44969_46865[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (30))){
var inst_44818 = (state_44870[(13)]);
var inst_44826 = (state_44870[(10)]);
var inst_44817 = (state_44870[(11)]);
var inst_44844 = cljs.core.empty_QMARK_.call(null,inst_44817);
var inst_44845 = inst_44818.call(null,inst_44826);
var inst_44846 = cljs.core.not.call(null,inst_44845);
var inst_44847 = ((inst_44844) && (inst_44846));
var state_44870__$1 = state_44870;
var statearr_44970_46867 = state_44870__$1;
(statearr_44970_46867[(2)] = inst_44847);

(statearr_44970_46867[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (10))){
var inst_44762 = (state_44870[(8)]);
var inst_44788 = (state_44870[(2)]);
var inst_44789 = cljs.core.get.call(null,inst_44788,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44790 = cljs.core.get.call(null,inst_44788,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44791 = cljs.core.get.call(null,inst_44788,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_44792 = inst_44762;
var state_44870__$1 = (function (){var statearr_44971 = state_44870;
(statearr_44971[(16)] = inst_44791);

(statearr_44971[(7)] = inst_44792);

(statearr_44971[(17)] = inst_44790);

(statearr_44971[(18)] = inst_44789);

return statearr_44971;
})();
var statearr_44972_46869 = state_44870__$1;
(statearr_44972_46869[(2)] = null);

(statearr_44972_46869[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (18))){
var inst_44807 = (state_44870[(2)]);
var state_44870__$1 = state_44870;
var statearr_44973_46871 = state_44870__$1;
(statearr_44973_46871[(2)] = inst_44807);

(statearr_44973_46871[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (37))){
var state_44870__$1 = state_44870;
var statearr_44974_46872 = state_44870__$1;
(statearr_44974_46872[(2)] = null);

(statearr_44974_46872[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44871 === (8))){
var inst_44762 = (state_44870[(8)]);
var inst_44785 = cljs.core.apply.call(null,cljs.core.hash_map,inst_44762);
var state_44870__$1 = state_44870;
var statearr_44975_46874 = state_44870__$1;
(statearr_44975_46874[(2)] = inst_44785);

(statearr_44975_46874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__42760__auto__ = null;
var cljs$core$async$mix_$_state_machine__42760__auto____0 = (function (){
var statearr_44976 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44976[(0)] = cljs$core$async$mix_$_state_machine__42760__auto__);

(statearr_44976[(1)] = (1));

return statearr_44976;
});
var cljs$core$async$mix_$_state_machine__42760__auto____1 = (function (state_44870){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_44870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e44977){if((e44977 instanceof Object)){
var ex__42763__auto__ = e44977;
var statearr_44978_46876 = state_44870;
(statearr_44978_46876[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44870);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44977;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46877 = state_44870;
state_44870 = G__46877;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42760__auto__ = function(state_44870){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42760__auto____1.call(this,state_44870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42760__auto____0;
cljs$core$async$mix_$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42760__auto____1;
return cljs$core$async$mix_$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_44979 = f__43110__auto__.call(null);
(statearr_44979[(6)] = c__43103__auto___46792);

return statearr_44979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4485__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p,v,ch);
} else {
var m__4485__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__45002 = arguments.length;
switch (G__45002) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p);
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p,v);
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__45005 = arguments.length;
switch (G__45005) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4185__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__45003_SHARP_){
if(cljs.core.truth_(p1__45003_SHARP_.call(null,topic))){
return p1__45003_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__45003_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45009 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45009 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta45010){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta45010 = meta45010;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45011,meta45010__$1){
var self__ = this;
var _45011__$1 = this;
return (new cljs.core.async.t_cljs$core$async45009(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta45010__$1));
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45011){
var self__ = this;
var _45011__$1 = this;
return self__.meta45010;
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async45009.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async45009.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta45010","meta45010",-1815810801,null)], null);
}));

(cljs.core.async.t_cljs$core$async45009.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45009.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45009");

(cljs.core.async.t_cljs$core$async45009.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45009");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45009.
 */
cljs.core.async.__GT_t_cljs$core$async45009 = (function cljs$core$async$__GT_t_cljs$core$async45009(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45010){
return (new cljs.core.async.t_cljs$core$async45009(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45010));
});

}

return (new cljs.core.async.t_cljs$core$async45009(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43103__auto___46894 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45103){
var state_val_45106 = (state_45103[(1)]);
if((state_val_45106 === (7))){
var inst_45097 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
var statearr_45109_46895 = state_45103__$1;
(statearr_45109_46895[(2)] = inst_45097);

(statearr_45109_46895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (20))){
var state_45103__$1 = state_45103;
var statearr_45110_46896 = state_45103__$1;
(statearr_45110_46896[(2)] = null);

(statearr_45110_46896[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (1))){
var state_45103__$1 = state_45103;
var statearr_45111_46897 = state_45103__$1;
(statearr_45111_46897[(2)] = null);

(statearr_45111_46897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (24))){
var inst_45078 = (state_45103[(7)]);
var inst_45089 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_45078);
var state_45103__$1 = state_45103;
var statearr_45114_46898 = state_45103__$1;
(statearr_45114_46898[(2)] = inst_45089);

(statearr_45114_46898[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (4))){
var inst_45028 = (state_45103[(8)]);
var inst_45028__$1 = (state_45103[(2)]);
var inst_45029 = (inst_45028__$1 == null);
var state_45103__$1 = (function (){var statearr_45116 = state_45103;
(statearr_45116[(8)] = inst_45028__$1);

return statearr_45116;
})();
if(cljs.core.truth_(inst_45029)){
var statearr_45120_46899 = state_45103__$1;
(statearr_45120_46899[(1)] = (5));

} else {
var statearr_45122_46900 = state_45103__$1;
(statearr_45122_46900[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (15))){
var inst_45071 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
var statearr_45124_46901 = state_45103__$1;
(statearr_45124_46901[(2)] = inst_45071);

(statearr_45124_46901[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (21))){
var inst_45094 = (state_45103[(2)]);
var state_45103__$1 = (function (){var statearr_45125 = state_45103;
(statearr_45125[(9)] = inst_45094);

return statearr_45125;
})();
var statearr_45126_46902 = state_45103__$1;
(statearr_45126_46902[(2)] = null);

(statearr_45126_46902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (13))){
var inst_45052 = (state_45103[(10)]);
var inst_45054 = cljs.core.chunked_seq_QMARK_.call(null,inst_45052);
var state_45103__$1 = state_45103;
if(inst_45054){
var statearr_45129_46906 = state_45103__$1;
(statearr_45129_46906[(1)] = (16));

} else {
var statearr_45131_46907 = state_45103__$1;
(statearr_45131_46907[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (22))){
var inst_45084 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
if(cljs.core.truth_(inst_45084)){
var statearr_45132_46912 = state_45103__$1;
(statearr_45132_46912[(1)] = (23));

} else {
var statearr_45133_46913 = state_45103__$1;
(statearr_45133_46913[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (6))){
var inst_45028 = (state_45103[(8)]);
var inst_45078 = (state_45103[(7)]);
var inst_45080 = (state_45103[(11)]);
var inst_45078__$1 = topic_fn.call(null,inst_45028);
var inst_45079 = cljs.core.deref.call(null,mults);
var inst_45080__$1 = cljs.core.get.call(null,inst_45079,inst_45078__$1);
var state_45103__$1 = (function (){var statearr_45134 = state_45103;
(statearr_45134[(7)] = inst_45078__$1);

(statearr_45134[(11)] = inst_45080__$1);

return statearr_45134;
})();
if(cljs.core.truth_(inst_45080__$1)){
var statearr_45135_46917 = state_45103__$1;
(statearr_45135_46917[(1)] = (19));

} else {
var statearr_45136_46918 = state_45103__$1;
(statearr_45136_46918[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (25))){
var inst_45091 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
var statearr_45137_46921 = state_45103__$1;
(statearr_45137_46921[(2)] = inst_45091);

(statearr_45137_46921[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (17))){
var inst_45052 = (state_45103[(10)]);
var inst_45061 = cljs.core.first.call(null,inst_45052);
var inst_45063 = cljs.core.async.muxch_STAR_.call(null,inst_45061);
var inst_45064 = cljs.core.async.close_BANG_.call(null,inst_45063);
var inst_45065 = cljs.core.next.call(null,inst_45052);
var inst_45038 = inst_45065;
var inst_45039 = null;
var inst_45040 = (0);
var inst_45041 = (0);
var state_45103__$1 = (function (){var statearr_45140 = state_45103;
(statearr_45140[(12)] = inst_45040);

(statearr_45140[(13)] = inst_45041);

(statearr_45140[(14)] = inst_45039);

(statearr_45140[(15)] = inst_45038);

(statearr_45140[(16)] = inst_45064);

return statearr_45140;
})();
var statearr_45142_46925 = state_45103__$1;
(statearr_45142_46925[(2)] = null);

(statearr_45142_46925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (3))){
var inst_45100 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45103__$1,inst_45100);
} else {
if((state_val_45106 === (12))){
var inst_45073 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
var statearr_45145_46926 = state_45103__$1;
(statearr_45145_46926[(2)] = inst_45073);

(statearr_45145_46926[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (2))){
var state_45103__$1 = state_45103;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45103__$1,(4),ch);
} else {
if((state_val_45106 === (23))){
var state_45103__$1 = state_45103;
var statearr_45146_46930 = state_45103__$1;
(statearr_45146_46930[(2)] = null);

(statearr_45146_46930[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (19))){
var inst_45028 = (state_45103[(8)]);
var inst_45080 = (state_45103[(11)]);
var inst_45082 = cljs.core.async.muxch_STAR_.call(null,inst_45080);
var state_45103__$1 = state_45103;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45103__$1,(22),inst_45082,inst_45028);
} else {
if((state_val_45106 === (11))){
var inst_45052 = (state_45103[(10)]);
var inst_45038 = (state_45103[(15)]);
var inst_45052__$1 = cljs.core.seq.call(null,inst_45038);
var state_45103__$1 = (function (){var statearr_45147 = state_45103;
(statearr_45147[(10)] = inst_45052__$1);

return statearr_45147;
})();
if(inst_45052__$1){
var statearr_45149_46931 = state_45103__$1;
(statearr_45149_46931[(1)] = (13));

} else {
var statearr_45150_46932 = state_45103__$1;
(statearr_45150_46932[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (9))){
var inst_45075 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
var statearr_45151_46936 = state_45103__$1;
(statearr_45151_46936[(2)] = inst_45075);

(statearr_45151_46936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (5))){
var inst_45035 = cljs.core.deref.call(null,mults);
var inst_45036 = cljs.core.vals.call(null,inst_45035);
var inst_45037 = cljs.core.seq.call(null,inst_45036);
var inst_45038 = inst_45037;
var inst_45039 = null;
var inst_45040 = (0);
var inst_45041 = (0);
var state_45103__$1 = (function (){var statearr_45153 = state_45103;
(statearr_45153[(12)] = inst_45040);

(statearr_45153[(13)] = inst_45041);

(statearr_45153[(14)] = inst_45039);

(statearr_45153[(15)] = inst_45038);

return statearr_45153;
})();
var statearr_45154_46937 = state_45103__$1;
(statearr_45154_46937[(2)] = null);

(statearr_45154_46937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (14))){
var state_45103__$1 = state_45103;
var statearr_45158_46940 = state_45103__$1;
(statearr_45158_46940[(2)] = null);

(statearr_45158_46940[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (16))){
var inst_45052 = (state_45103[(10)]);
var inst_45056 = cljs.core.chunk_first.call(null,inst_45052);
var inst_45057 = cljs.core.chunk_rest.call(null,inst_45052);
var inst_45058 = cljs.core.count.call(null,inst_45056);
var inst_45038 = inst_45057;
var inst_45039 = inst_45056;
var inst_45040 = inst_45058;
var inst_45041 = (0);
var state_45103__$1 = (function (){var statearr_45161 = state_45103;
(statearr_45161[(12)] = inst_45040);

(statearr_45161[(13)] = inst_45041);

(statearr_45161[(14)] = inst_45039);

(statearr_45161[(15)] = inst_45038);

return statearr_45161;
})();
var statearr_45162_46950 = state_45103__$1;
(statearr_45162_46950[(2)] = null);

(statearr_45162_46950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (10))){
var inst_45040 = (state_45103[(12)]);
var inst_45041 = (state_45103[(13)]);
var inst_45039 = (state_45103[(14)]);
var inst_45038 = (state_45103[(15)]);
var inst_45046 = cljs.core._nth.call(null,inst_45039,inst_45041);
var inst_45047 = cljs.core.async.muxch_STAR_.call(null,inst_45046);
var inst_45048 = cljs.core.async.close_BANG_.call(null,inst_45047);
var inst_45049 = (inst_45041 + (1));
var tmp45155 = inst_45040;
var tmp45156 = inst_45039;
var tmp45157 = inst_45038;
var inst_45038__$1 = tmp45157;
var inst_45039__$1 = tmp45156;
var inst_45040__$1 = tmp45155;
var inst_45041__$1 = inst_45049;
var state_45103__$1 = (function (){var statearr_45164 = state_45103;
(statearr_45164[(12)] = inst_45040__$1);

(statearr_45164[(13)] = inst_45041__$1);

(statearr_45164[(17)] = inst_45048);

(statearr_45164[(14)] = inst_45039__$1);

(statearr_45164[(15)] = inst_45038__$1);

return statearr_45164;
})();
var statearr_45165_46959 = state_45103__$1;
(statearr_45165_46959[(2)] = null);

(statearr_45165_46959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (18))){
var inst_45068 = (state_45103[(2)]);
var state_45103__$1 = state_45103;
var statearr_45166_46960 = state_45103__$1;
(statearr_45166_46960[(2)] = inst_45068);

(statearr_45166_46960[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45106 === (8))){
var inst_45040 = (state_45103[(12)]);
var inst_45041 = (state_45103[(13)]);
var inst_45043 = (inst_45041 < inst_45040);
var inst_45044 = inst_45043;
var state_45103__$1 = state_45103;
if(cljs.core.truth_(inst_45044)){
var statearr_45167_46961 = state_45103__$1;
(statearr_45167_46961[(1)] = (10));

} else {
var statearr_45169_46962 = state_45103__$1;
(statearr_45169_46962[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45172[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45172[(1)] = (1));

return statearr_45172;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45103){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45173){if((e45173 instanceof Object)){
var ex__42763__auto__ = e45173;
var statearr_45174_46964 = state_45103;
(statearr_45174_46964[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45103);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45173;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46966 = state_45103;
state_45103 = G__46966;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45103){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45175 = f__43110__auto__.call(null);
(statearr_45175[(6)] = c__43103__auto___46894);

return statearr_45175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__45177 = arguments.length;
switch (G__45177) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__45181 = arguments.length;
switch (G__45181) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__45198 = arguments.length;
switch (G__45198) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__43103__auto___46977 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45249){
var state_val_45250 = (state_45249[(1)]);
if((state_val_45250 === (7))){
var state_45249__$1 = state_45249;
var statearr_45251_46978 = state_45249__$1;
(statearr_45251_46978[(2)] = null);

(statearr_45251_46978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (1))){
var state_45249__$1 = state_45249;
var statearr_45252_46979 = state_45249__$1;
(statearr_45252_46979[(2)] = null);

(statearr_45252_46979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (4))){
var inst_45209 = (state_45249[(7)]);
var inst_45212 = (inst_45209 < cnt);
var state_45249__$1 = state_45249;
if(cljs.core.truth_(inst_45212)){
var statearr_45253_46986 = state_45249__$1;
(statearr_45253_46986[(1)] = (6));

} else {
var statearr_45254_46987 = state_45249__$1;
(statearr_45254_46987[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (15))){
var inst_45244 = (state_45249[(2)]);
var state_45249__$1 = state_45249;
var statearr_45255_46988 = state_45249__$1;
(statearr_45255_46988[(2)] = inst_45244);

(statearr_45255_46988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (13))){
var inst_45237 = cljs.core.async.close_BANG_.call(null,out);
var state_45249__$1 = state_45249;
var statearr_45256_46990 = state_45249__$1;
(statearr_45256_46990[(2)] = inst_45237);

(statearr_45256_46990[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (6))){
var state_45249__$1 = state_45249;
var statearr_45257_46991 = state_45249__$1;
(statearr_45257_46991[(2)] = null);

(statearr_45257_46991[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (3))){
var inst_45246 = (state_45249[(2)]);
var state_45249__$1 = state_45249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45249__$1,inst_45246);
} else {
if((state_val_45250 === (12))){
var inst_45234 = (state_45249[(8)]);
var inst_45234__$1 = (state_45249[(2)]);
var inst_45235 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_45234__$1);
var state_45249__$1 = (function (){var statearr_45258 = state_45249;
(statearr_45258[(8)] = inst_45234__$1);

return statearr_45258;
})();
if(cljs.core.truth_(inst_45235)){
var statearr_45259_46995 = state_45249__$1;
(statearr_45259_46995[(1)] = (13));

} else {
var statearr_45260_46996 = state_45249__$1;
(statearr_45260_46996[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (2))){
var inst_45208 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_45209 = (0);
var state_45249__$1 = (function (){var statearr_45261 = state_45249;
(statearr_45261[(7)] = inst_45209);

(statearr_45261[(9)] = inst_45208);

return statearr_45261;
})();
var statearr_45262_46998 = state_45249__$1;
(statearr_45262_46998[(2)] = null);

(statearr_45262_46998[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (11))){
var inst_45209 = (state_45249[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_45249,(10),Object,null,(9));
var inst_45220 = chs__$1.call(null,inst_45209);
var inst_45221 = done.call(null,inst_45209);
var inst_45222 = cljs.core.async.take_BANG_.call(null,inst_45220,inst_45221);
var state_45249__$1 = state_45249;
var statearr_45263_47000 = state_45249__$1;
(statearr_45263_47000[(2)] = inst_45222);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45249__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (9))){
var inst_45209 = (state_45249[(7)]);
var inst_45224 = (state_45249[(2)]);
var inst_45226 = (inst_45209 + (1));
var inst_45209__$1 = inst_45226;
var state_45249__$1 = (function (){var statearr_45264 = state_45249;
(statearr_45264[(7)] = inst_45209__$1);

(statearr_45264[(10)] = inst_45224);

return statearr_45264;
})();
var statearr_45265_47009 = state_45249__$1;
(statearr_45265_47009[(2)] = null);

(statearr_45265_47009[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (5))){
var inst_45232 = (state_45249[(2)]);
var state_45249__$1 = (function (){var statearr_45268 = state_45249;
(statearr_45268[(11)] = inst_45232);

return statearr_45268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45249__$1,(12),dchan);
} else {
if((state_val_45250 === (14))){
var inst_45234 = (state_45249[(8)]);
var inst_45239 = cljs.core.apply.call(null,f,inst_45234);
var state_45249__$1 = state_45249;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45249__$1,(16),out,inst_45239);
} else {
if((state_val_45250 === (16))){
var inst_45241 = (state_45249[(2)]);
var state_45249__$1 = (function (){var statearr_45270 = state_45249;
(statearr_45270[(12)] = inst_45241);

return statearr_45270;
})();
var statearr_45271_47012 = state_45249__$1;
(statearr_45271_47012[(2)] = null);

(statearr_45271_47012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (10))){
var inst_45214 = (state_45249[(2)]);
var inst_45215 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_45249__$1 = (function (){var statearr_45272 = state_45249;
(statearr_45272[(13)] = inst_45214);

return statearr_45272;
})();
var statearr_45273_47014 = state_45249__$1;
(statearr_45273_47014[(2)] = inst_45215);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45249__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45250 === (8))){
var inst_45230 = (state_45249[(2)]);
var state_45249__$1 = state_45249;
var statearr_45274_47015 = state_45249__$1;
(statearr_45274_47015[(2)] = inst_45230);

(statearr_45274_47015[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45275 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45275[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45275[(1)] = (1));

return statearr_45275;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45249){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45277){if((e45277 instanceof Object)){
var ex__42763__auto__ = e45277;
var statearr_45278_47018 = state_45249;
(statearr_45278_47018[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45249);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45277;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47020 = state_45249;
state_45249 = G__47020;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45249){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45280 = f__43110__auto__.call(null);
(statearr_45280[(6)] = c__43103__auto___46977);

return statearr_45280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__45289 = arguments.length;
switch (G__45289) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__43103__auto___47025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45321){
var state_val_45322 = (state_45321[(1)]);
if((state_val_45322 === (7))){
var inst_45301 = (state_45321[(7)]);
var inst_45300 = (state_45321[(8)]);
var inst_45300__$1 = (state_45321[(2)]);
var inst_45301__$1 = cljs.core.nth.call(null,inst_45300__$1,(0),null);
var inst_45302 = cljs.core.nth.call(null,inst_45300__$1,(1),null);
var inst_45303 = (inst_45301__$1 == null);
var state_45321__$1 = (function (){var statearr_45324 = state_45321;
(statearr_45324[(7)] = inst_45301__$1);

(statearr_45324[(8)] = inst_45300__$1);

(statearr_45324[(9)] = inst_45302);

return statearr_45324;
})();
if(cljs.core.truth_(inst_45303)){
var statearr_45325_47027 = state_45321__$1;
(statearr_45325_47027[(1)] = (8));

} else {
var statearr_45326_47028 = state_45321__$1;
(statearr_45326_47028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45322 === (1))){
var inst_45290 = cljs.core.vec.call(null,chs);
var inst_45291 = inst_45290;
var state_45321__$1 = (function (){var statearr_45327 = state_45321;
(statearr_45327[(10)] = inst_45291);

return statearr_45327;
})();
var statearr_45328_47032 = state_45321__$1;
(statearr_45328_47032[(2)] = null);

(statearr_45328_47032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45322 === (4))){
var inst_45291 = (state_45321[(10)]);
var state_45321__$1 = state_45321;
return cljs.core.async.ioc_alts_BANG_.call(null,state_45321__$1,(7),inst_45291);
} else {
if((state_val_45322 === (6))){
var inst_45317 = (state_45321[(2)]);
var state_45321__$1 = state_45321;
var statearr_45329_47034 = state_45321__$1;
(statearr_45329_47034[(2)] = inst_45317);

(statearr_45329_47034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45322 === (3))){
var inst_45319 = (state_45321[(2)]);
var state_45321__$1 = state_45321;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45321__$1,inst_45319);
} else {
if((state_val_45322 === (2))){
var inst_45291 = (state_45321[(10)]);
var inst_45293 = cljs.core.count.call(null,inst_45291);
var inst_45294 = (inst_45293 > (0));
var state_45321__$1 = state_45321;
if(cljs.core.truth_(inst_45294)){
var statearr_45335_47038 = state_45321__$1;
(statearr_45335_47038[(1)] = (4));

} else {
var statearr_45336_47039 = state_45321__$1;
(statearr_45336_47039[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45322 === (11))){
var inst_45291 = (state_45321[(10)]);
var inst_45310 = (state_45321[(2)]);
var tmp45330 = inst_45291;
var inst_45291__$1 = tmp45330;
var state_45321__$1 = (function (){var statearr_45339 = state_45321;
(statearr_45339[(11)] = inst_45310);

(statearr_45339[(10)] = inst_45291__$1);

return statearr_45339;
})();
var statearr_45342_47040 = state_45321__$1;
(statearr_45342_47040[(2)] = null);

(statearr_45342_47040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45322 === (9))){
var inst_45301 = (state_45321[(7)]);
var state_45321__$1 = state_45321;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45321__$1,(11),out,inst_45301);
} else {
if((state_val_45322 === (5))){
var inst_45315 = cljs.core.async.close_BANG_.call(null,out);
var state_45321__$1 = state_45321;
var statearr_45343_47042 = state_45321__$1;
(statearr_45343_47042[(2)] = inst_45315);

(statearr_45343_47042[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45322 === (10))){
var inst_45313 = (state_45321[(2)]);
var state_45321__$1 = state_45321;
var statearr_45348_47044 = state_45321__$1;
(statearr_45348_47044[(2)] = inst_45313);

(statearr_45348_47044[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45322 === (8))){
var inst_45301 = (state_45321[(7)]);
var inst_45300 = (state_45321[(8)]);
var inst_45291 = (state_45321[(10)]);
var inst_45302 = (state_45321[(9)]);
var inst_45305 = (function (){var cs = inst_45291;
var vec__45296 = inst_45300;
var v = inst_45301;
var c = inst_45302;
return (function (p1__45281_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__45281_SHARP_);
});
})();
var inst_45306 = cljs.core.filterv.call(null,inst_45305,inst_45291);
var inst_45291__$1 = inst_45306;
var state_45321__$1 = (function (){var statearr_45357 = state_45321;
(statearr_45357[(10)] = inst_45291__$1);

return statearr_45357;
})();
var statearr_45358_47049 = state_45321__$1;
(statearr_45358_47049[(2)] = null);

(statearr_45358_47049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45359 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45359[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45359[(1)] = (1));

return statearr_45359;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45321){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45321);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45360){if((e45360 instanceof Object)){
var ex__42763__auto__ = e45360;
var statearr_45363_47052 = state_45321;
(statearr_45363_47052[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45321);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45360;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47053 = state_45321;
state_45321 = G__47053;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45321){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45369 = f__43110__auto__.call(null);
(statearr_45369[(6)] = c__43103__auto___47025);

return statearr_45369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45375 = arguments.length;
switch (G__45375) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__43103__auto___47059 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45411){
var state_val_45412 = (state_45411[(1)]);
if((state_val_45412 === (7))){
var inst_45386 = (state_45411[(7)]);
var inst_45386__$1 = (state_45411[(2)]);
var inst_45390 = (inst_45386__$1 == null);
var inst_45391 = cljs.core.not.call(null,inst_45390);
var state_45411__$1 = (function (){var statearr_45413 = state_45411;
(statearr_45413[(7)] = inst_45386__$1);

return statearr_45413;
})();
if(inst_45391){
var statearr_45414_47060 = state_45411__$1;
(statearr_45414_47060[(1)] = (8));

} else {
var statearr_45415_47061 = state_45411__$1;
(statearr_45415_47061[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (1))){
var inst_45378 = (0);
var state_45411__$1 = (function (){var statearr_45416 = state_45411;
(statearr_45416[(8)] = inst_45378);

return statearr_45416;
})();
var statearr_45417_47062 = state_45411__$1;
(statearr_45417_47062[(2)] = null);

(statearr_45417_47062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (4))){
var state_45411__$1 = state_45411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45411__$1,(7),ch);
} else {
if((state_val_45412 === (6))){
var inst_45402 = (state_45411[(2)]);
var state_45411__$1 = state_45411;
var statearr_45420_47069 = state_45411__$1;
(statearr_45420_47069[(2)] = inst_45402);

(statearr_45420_47069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (3))){
var inst_45404 = (state_45411[(2)]);
var inst_45405 = cljs.core.async.close_BANG_.call(null,out);
var state_45411__$1 = (function (){var statearr_45424 = state_45411;
(statearr_45424[(9)] = inst_45404);

return statearr_45424;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45411__$1,inst_45405);
} else {
if((state_val_45412 === (2))){
var inst_45378 = (state_45411[(8)]);
var inst_45382 = (inst_45378 < n);
var state_45411__$1 = state_45411;
if(cljs.core.truth_(inst_45382)){
var statearr_45425_47070 = state_45411__$1;
(statearr_45425_47070[(1)] = (4));

} else {
var statearr_45426_47071 = state_45411__$1;
(statearr_45426_47071[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (11))){
var inst_45378 = (state_45411[(8)]);
var inst_45394 = (state_45411[(2)]);
var inst_45395 = (inst_45378 + (1));
var inst_45378__$1 = inst_45395;
var state_45411__$1 = (function (){var statearr_45427 = state_45411;
(statearr_45427[(8)] = inst_45378__$1);

(statearr_45427[(10)] = inst_45394);

return statearr_45427;
})();
var statearr_45428_47072 = state_45411__$1;
(statearr_45428_47072[(2)] = null);

(statearr_45428_47072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (9))){
var state_45411__$1 = state_45411;
var statearr_45429_47074 = state_45411__$1;
(statearr_45429_47074[(2)] = null);

(statearr_45429_47074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (5))){
var state_45411__$1 = state_45411;
var statearr_45430_47075 = state_45411__$1;
(statearr_45430_47075[(2)] = null);

(statearr_45430_47075[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (10))){
var inst_45399 = (state_45411[(2)]);
var state_45411__$1 = state_45411;
var statearr_45436_47076 = state_45411__$1;
(statearr_45436_47076[(2)] = inst_45399);

(statearr_45436_47076[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45412 === (8))){
var inst_45386 = (state_45411[(7)]);
var state_45411__$1 = state_45411;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45411__$1,(11),out,inst_45386);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45441 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45441[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45441[(1)] = (1));

return statearr_45441;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45411){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45445){if((e45445 instanceof Object)){
var ex__42763__auto__ = e45445;
var statearr_45447_47080 = state_45411;
(statearr_45447_47080[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45411);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45445;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47081 = state_45411;
state_45411 = G__47081;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45411){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45453 = f__43110__auto__.call(null);
(statearr_45453[(6)] = c__43103__auto___47059);

return statearr_45453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45457 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45457 = (function (f,ch,meta45458){
this.f = f;
this.ch = ch;
this.meta45458 = meta45458;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45459,meta45458__$1){
var self__ = this;
var _45459__$1 = this;
return (new cljs.core.async.t_cljs$core$async45457(self__.f,self__.ch,meta45458__$1));
}));

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45459){
var self__ = this;
var _45459__$1 = this;
return self__.meta45458;
}));

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45463 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45463 = (function (f,ch,meta45458,_,fn1,meta45464){
this.f = f;
this.ch = ch;
this.meta45458 = meta45458;
this._ = _;
this.fn1 = fn1;
this.meta45464 = meta45464;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45463.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45465,meta45464__$1){
var self__ = this;
var _45465__$1 = this;
return (new cljs.core.async.t_cljs$core$async45463(self__.f,self__.ch,self__.meta45458,self__._,self__.fn1,meta45464__$1));
}));

(cljs.core.async.t_cljs$core$async45463.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45465){
var self__ = this;
var _45465__$1 = this;
return self__.meta45464;
}));

(cljs.core.async.t_cljs$core$async45463.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45463.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45463.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45463.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__45456_SHARP_){
return f1.call(null,(((p1__45456_SHARP_ == null))?null:self__.f.call(null,p1__45456_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async45463.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45458","meta45458",2024159320,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45457","cljs.core.async/t_cljs$core$async45457",-1246587962,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45464","meta45464",-1044473421,null)], null);
}));

(cljs.core.async.t_cljs$core$async45463.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45463.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45463");

(cljs.core.async.t_cljs$core$async45463.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45463");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45463.
 */
cljs.core.async.__GT_t_cljs$core$async45463 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45463(f__$1,ch__$1,meta45458__$1,___$2,fn1__$1,meta45464){
return (new cljs.core.async.t_cljs$core$async45463(f__$1,ch__$1,meta45458__$1,___$2,fn1__$1,meta45464));
});

}

return (new cljs.core.async.t_cljs$core$async45463(self__.f,self__.ch,self__.meta45458,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4174__auto__ = ret;
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45457.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45457.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45458","meta45458",2024159320,null)], null);
}));

(cljs.core.async.t_cljs$core$async45457.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45457.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45457");

(cljs.core.async.t_cljs$core$async45457.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45457");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45457.
 */
cljs.core.async.__GT_t_cljs$core$async45457 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45457(f__$1,ch__$1,meta45458){
return (new cljs.core.async.t_cljs$core$async45457(f__$1,ch__$1,meta45458));
});

}

return (new cljs.core.async.t_cljs$core$async45457(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45496 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45496 = (function (f,ch,meta45497){
this.f = f;
this.ch = ch;
this.meta45497 = meta45497;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45498,meta45497__$1){
var self__ = this;
var _45498__$1 = this;
return (new cljs.core.async.t_cljs$core$async45496(self__.f,self__.ch,meta45497__$1));
}));

(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45498){
var self__ = this;
var _45498__$1 = this;
return self__.meta45497;
}));

(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45496.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async45496.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45497","meta45497",-462563971,null)], null);
}));

(cljs.core.async.t_cljs$core$async45496.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45496.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45496");

(cljs.core.async.t_cljs$core$async45496.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45496");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45496.
 */
cljs.core.async.__GT_t_cljs$core$async45496 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45496(f__$1,ch__$1,meta45497){
return (new cljs.core.async.t_cljs$core$async45496(f__$1,ch__$1,meta45497));
});

}

return (new cljs.core.async.t_cljs$core$async45496(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45530 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45530 = (function (p,ch,meta45531){
this.p = p;
this.ch = ch;
this.meta45531 = meta45531;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45532,meta45531__$1){
var self__ = this;
var _45532__$1 = this;
return (new cljs.core.async.t_cljs$core$async45530(self__.p,self__.ch,meta45531__$1));
}));

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45532){
var self__ = this;
var _45532__$1 = this;
return self__.meta45531;
}));

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45530.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45530.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45531","meta45531",-1412150977,null)], null);
}));

(cljs.core.async.t_cljs$core$async45530.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45530.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45530");

(cljs.core.async.t_cljs$core$async45530.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45530");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45530.
 */
cljs.core.async.__GT_t_cljs$core$async45530 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45530(p__$1,ch__$1,meta45531){
return (new cljs.core.async.t_cljs$core$async45530(p__$1,ch__$1,meta45531));
});

}

return (new cljs.core.async.t_cljs$core$async45530(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45538 = arguments.length;
switch (G__45538) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__43103__auto___47118 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45566){
var state_val_45567 = (state_45566[(1)]);
if((state_val_45567 === (7))){
var inst_45562 = (state_45566[(2)]);
var state_45566__$1 = state_45566;
var statearr_45570_47123 = state_45566__$1;
(statearr_45570_47123[(2)] = inst_45562);

(statearr_45570_47123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (1))){
var state_45566__$1 = state_45566;
var statearr_45571_47124 = state_45566__$1;
(statearr_45571_47124[(2)] = null);

(statearr_45571_47124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (4))){
var inst_45548 = (state_45566[(7)]);
var inst_45548__$1 = (state_45566[(2)]);
var inst_45549 = (inst_45548__$1 == null);
var state_45566__$1 = (function (){var statearr_45572 = state_45566;
(statearr_45572[(7)] = inst_45548__$1);

return statearr_45572;
})();
if(cljs.core.truth_(inst_45549)){
var statearr_45573_47126 = state_45566__$1;
(statearr_45573_47126[(1)] = (5));

} else {
var statearr_45574_47127 = state_45566__$1;
(statearr_45574_47127[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (6))){
var inst_45548 = (state_45566[(7)]);
var inst_45553 = p.call(null,inst_45548);
var state_45566__$1 = state_45566;
if(cljs.core.truth_(inst_45553)){
var statearr_45575_47132 = state_45566__$1;
(statearr_45575_47132[(1)] = (8));

} else {
var statearr_45576_47138 = state_45566__$1;
(statearr_45576_47138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (3))){
var inst_45564 = (state_45566[(2)]);
var state_45566__$1 = state_45566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45566__$1,inst_45564);
} else {
if((state_val_45567 === (2))){
var state_45566__$1 = state_45566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45566__$1,(4),ch);
} else {
if((state_val_45567 === (11))){
var inst_45556 = (state_45566[(2)]);
var state_45566__$1 = state_45566;
var statearr_45580_47147 = state_45566__$1;
(statearr_45580_47147[(2)] = inst_45556);

(statearr_45580_47147[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (9))){
var state_45566__$1 = state_45566;
var statearr_45581_47149 = state_45566__$1;
(statearr_45581_47149[(2)] = null);

(statearr_45581_47149[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (5))){
var inst_45551 = cljs.core.async.close_BANG_.call(null,out);
var state_45566__$1 = state_45566;
var statearr_45582_47150 = state_45566__$1;
(statearr_45582_47150[(2)] = inst_45551);

(statearr_45582_47150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (10))){
var inst_45559 = (state_45566[(2)]);
var state_45566__$1 = (function (){var statearr_45585 = state_45566;
(statearr_45585[(8)] = inst_45559);

return statearr_45585;
})();
var statearr_45586_47151 = state_45566__$1;
(statearr_45586_47151[(2)] = null);

(statearr_45586_47151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45567 === (8))){
var inst_45548 = (state_45566[(7)]);
var state_45566__$1 = state_45566;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45566__$1,(11),out,inst_45548);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45589 = [null,null,null,null,null,null,null,null,null];
(statearr_45589[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45589[(1)] = (1));

return statearr_45589;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45566){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45592){if((e45592 instanceof Object)){
var ex__42763__auto__ = e45592;
var statearr_45593_47157 = state_45566;
(statearr_45593_47157[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45566);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45592;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47162 = state_45566;
state_45566 = G__47162;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45566){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45597 = f__43110__auto__.call(null);
(statearr_45597[(6)] = c__43103__auto___47118);

return statearr_45597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45599 = arguments.length;
switch (G__45599) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43103__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45678){
var state_val_45679 = (state_45678[(1)]);
if((state_val_45679 === (7))){
var inst_45672 = (state_45678[(2)]);
var state_45678__$1 = state_45678;
var statearr_45680_47179 = state_45678__$1;
(statearr_45680_47179[(2)] = inst_45672);

(statearr_45680_47179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (20))){
var inst_45636 = (state_45678[(7)]);
var inst_45652 = (state_45678[(2)]);
var inst_45653 = cljs.core.next.call(null,inst_45636);
var inst_45622 = inst_45653;
var inst_45623 = null;
var inst_45624 = (0);
var inst_45625 = (0);
var state_45678__$1 = (function (){var statearr_45681 = state_45678;
(statearr_45681[(8)] = inst_45623);

(statearr_45681[(9)] = inst_45622);

(statearr_45681[(10)] = inst_45652);

(statearr_45681[(11)] = inst_45625);

(statearr_45681[(12)] = inst_45624);

return statearr_45681;
})();
var statearr_45682_47186 = state_45678__$1;
(statearr_45682_47186[(2)] = null);

(statearr_45682_47186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (1))){
var state_45678__$1 = state_45678;
var statearr_45683_47191 = state_45678__$1;
(statearr_45683_47191[(2)] = null);

(statearr_45683_47191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (4))){
var inst_45609 = (state_45678[(13)]);
var inst_45609__$1 = (state_45678[(2)]);
var inst_45610 = (inst_45609__$1 == null);
var state_45678__$1 = (function (){var statearr_45686 = state_45678;
(statearr_45686[(13)] = inst_45609__$1);

return statearr_45686;
})();
if(cljs.core.truth_(inst_45610)){
var statearr_45687_47198 = state_45678__$1;
(statearr_45687_47198[(1)] = (5));

} else {
var statearr_45688_47199 = state_45678__$1;
(statearr_45688_47199[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (15))){
var state_45678__$1 = state_45678;
var statearr_45692_47200 = state_45678__$1;
(statearr_45692_47200[(2)] = null);

(statearr_45692_47200[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (21))){
var state_45678__$1 = state_45678;
var statearr_45694_47201 = state_45678__$1;
(statearr_45694_47201[(2)] = null);

(statearr_45694_47201[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (13))){
var inst_45623 = (state_45678[(8)]);
var inst_45622 = (state_45678[(9)]);
var inst_45625 = (state_45678[(11)]);
var inst_45624 = (state_45678[(12)]);
var inst_45632 = (state_45678[(2)]);
var inst_45633 = (inst_45625 + (1));
var tmp45689 = inst_45623;
var tmp45690 = inst_45622;
var tmp45691 = inst_45624;
var inst_45622__$1 = tmp45690;
var inst_45623__$1 = tmp45689;
var inst_45624__$1 = tmp45691;
var inst_45625__$1 = inst_45633;
var state_45678__$1 = (function (){var statearr_45698 = state_45678;
(statearr_45698[(8)] = inst_45623__$1);

(statearr_45698[(9)] = inst_45622__$1);

(statearr_45698[(14)] = inst_45632);

(statearr_45698[(11)] = inst_45625__$1);

(statearr_45698[(12)] = inst_45624__$1);

return statearr_45698;
})();
var statearr_45699_47207 = state_45678__$1;
(statearr_45699_47207[(2)] = null);

(statearr_45699_47207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (22))){
var state_45678__$1 = state_45678;
var statearr_45701_47209 = state_45678__$1;
(statearr_45701_47209[(2)] = null);

(statearr_45701_47209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (6))){
var inst_45609 = (state_45678[(13)]);
var inst_45620 = f.call(null,inst_45609);
var inst_45621 = cljs.core.seq.call(null,inst_45620);
var inst_45622 = inst_45621;
var inst_45623 = null;
var inst_45624 = (0);
var inst_45625 = (0);
var state_45678__$1 = (function (){var statearr_45704 = state_45678;
(statearr_45704[(8)] = inst_45623);

(statearr_45704[(9)] = inst_45622);

(statearr_45704[(11)] = inst_45625);

(statearr_45704[(12)] = inst_45624);

return statearr_45704;
})();
var statearr_45705_47212 = state_45678__$1;
(statearr_45705_47212[(2)] = null);

(statearr_45705_47212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (17))){
var inst_45636 = (state_45678[(7)]);
var inst_45642 = cljs.core.chunk_first.call(null,inst_45636);
var inst_45643 = cljs.core.chunk_rest.call(null,inst_45636);
var inst_45644 = cljs.core.count.call(null,inst_45642);
var inst_45622 = inst_45643;
var inst_45623 = inst_45642;
var inst_45624 = inst_45644;
var inst_45625 = (0);
var state_45678__$1 = (function (){var statearr_45706 = state_45678;
(statearr_45706[(8)] = inst_45623);

(statearr_45706[(9)] = inst_45622);

(statearr_45706[(11)] = inst_45625);

(statearr_45706[(12)] = inst_45624);

return statearr_45706;
})();
var statearr_45707_47215 = state_45678__$1;
(statearr_45707_47215[(2)] = null);

(statearr_45707_47215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (3))){
var inst_45675 = (state_45678[(2)]);
var state_45678__$1 = state_45678;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45678__$1,inst_45675);
} else {
if((state_val_45679 === (12))){
var inst_45661 = (state_45678[(2)]);
var state_45678__$1 = state_45678;
var statearr_45711_47219 = state_45678__$1;
(statearr_45711_47219[(2)] = inst_45661);

(statearr_45711_47219[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (2))){
var state_45678__$1 = state_45678;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45678__$1,(4),in$);
} else {
if((state_val_45679 === (23))){
var inst_45670 = (state_45678[(2)]);
var state_45678__$1 = state_45678;
var statearr_45715_47221 = state_45678__$1;
(statearr_45715_47221[(2)] = inst_45670);

(statearr_45715_47221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (19))){
var inst_45656 = (state_45678[(2)]);
var state_45678__$1 = state_45678;
var statearr_45719_47222 = state_45678__$1;
(statearr_45719_47222[(2)] = inst_45656);

(statearr_45719_47222[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (11))){
var inst_45636 = (state_45678[(7)]);
var inst_45622 = (state_45678[(9)]);
var inst_45636__$1 = cljs.core.seq.call(null,inst_45622);
var state_45678__$1 = (function (){var statearr_45724 = state_45678;
(statearr_45724[(7)] = inst_45636__$1);

return statearr_45724;
})();
if(inst_45636__$1){
var statearr_45725_47223 = state_45678__$1;
(statearr_45725_47223[(1)] = (14));

} else {
var statearr_45726_47225 = state_45678__$1;
(statearr_45726_47225[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (9))){
var inst_45663 = (state_45678[(2)]);
var inst_45665 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_45678__$1 = (function (){var statearr_45727 = state_45678;
(statearr_45727[(15)] = inst_45663);

return statearr_45727;
})();
if(cljs.core.truth_(inst_45665)){
var statearr_45728_47226 = state_45678__$1;
(statearr_45728_47226[(1)] = (21));

} else {
var statearr_45729_47227 = state_45678__$1;
(statearr_45729_47227[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (5))){
var inst_45612 = cljs.core.async.close_BANG_.call(null,out);
var state_45678__$1 = state_45678;
var statearr_45730_47228 = state_45678__$1;
(statearr_45730_47228[(2)] = inst_45612);

(statearr_45730_47228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (14))){
var inst_45636 = (state_45678[(7)]);
var inst_45640 = cljs.core.chunked_seq_QMARK_.call(null,inst_45636);
var state_45678__$1 = state_45678;
if(inst_45640){
var statearr_45735_47229 = state_45678__$1;
(statearr_45735_47229[(1)] = (17));

} else {
var statearr_45736_47233 = state_45678__$1;
(statearr_45736_47233[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (16))){
var inst_45659 = (state_45678[(2)]);
var state_45678__$1 = state_45678;
var statearr_45737_47234 = state_45678__$1;
(statearr_45737_47234[(2)] = inst_45659);

(statearr_45737_47234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45679 === (10))){
var inst_45623 = (state_45678[(8)]);
var inst_45625 = (state_45678[(11)]);
var inst_45630 = cljs.core._nth.call(null,inst_45623,inst_45625);
var state_45678__$1 = state_45678;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45678__$1,(13),out,inst_45630);
} else {
if((state_val_45679 === (18))){
var inst_45636 = (state_45678[(7)]);
var inst_45650 = cljs.core.first.call(null,inst_45636);
var state_45678__$1 = state_45678;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45678__$1,(20),out,inst_45650);
} else {
if((state_val_45679 === (8))){
var inst_45625 = (state_45678[(11)]);
var inst_45624 = (state_45678[(12)]);
var inst_45627 = (inst_45625 < inst_45624);
var inst_45628 = inst_45627;
var state_45678__$1 = state_45678;
if(cljs.core.truth_(inst_45628)){
var statearr_45738_47239 = state_45678__$1;
(statearr_45738_47239[(1)] = (10));

} else {
var statearr_45739_47244 = state_45678__$1;
(statearr_45739_47244[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42760__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42760__auto____0 = (function (){
var statearr_45740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45740[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42760__auto__);

(statearr_45740[(1)] = (1));

return statearr_45740;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42760__auto____1 = (function (state_45678){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45678);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45741){if((e45741 instanceof Object)){
var ex__42763__auto__ = e45741;
var statearr_45744_47256 = state_45678;
(statearr_45744_47256[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45678);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47262 = state_45678;
state_45678 = G__47262;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42760__auto__ = function(state_45678){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42760__auto____1.call(this,state_45678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42760__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42760__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45747 = f__43110__auto__.call(null);
(statearr_45747[(6)] = c__43103__auto__);

return statearr_45747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));

return c__43103__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__45749 = arguments.length;
switch (G__45749) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__45751 = arguments.length;
switch (G__45751) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__45755 = arguments.length;
switch (G__45755) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__43103__auto___47319 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45781){
var state_val_45782 = (state_45781[(1)]);
if((state_val_45782 === (7))){
var inst_45775 = (state_45781[(2)]);
var state_45781__$1 = state_45781;
var statearr_45785_47330 = state_45781__$1;
(statearr_45785_47330[(2)] = inst_45775);

(statearr_45785_47330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45782 === (1))){
var inst_45757 = null;
var state_45781__$1 = (function (){var statearr_45787 = state_45781;
(statearr_45787[(7)] = inst_45757);

return statearr_45787;
})();
var statearr_45788_47336 = state_45781__$1;
(statearr_45788_47336[(2)] = null);

(statearr_45788_47336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45782 === (4))){
var inst_45760 = (state_45781[(8)]);
var inst_45760__$1 = (state_45781[(2)]);
var inst_45761 = (inst_45760__$1 == null);
var inst_45762 = cljs.core.not.call(null,inst_45761);
var state_45781__$1 = (function (){var statearr_45789 = state_45781;
(statearr_45789[(8)] = inst_45760__$1);

return statearr_45789;
})();
if(inst_45762){
var statearr_45790_47339 = state_45781__$1;
(statearr_45790_47339[(1)] = (5));

} else {
var statearr_45791_47340 = state_45781__$1;
(statearr_45791_47340[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45782 === (6))){
var state_45781__$1 = state_45781;
var statearr_45792_47341 = state_45781__$1;
(statearr_45792_47341[(2)] = null);

(statearr_45792_47341[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45782 === (3))){
var inst_45777 = (state_45781[(2)]);
var inst_45778 = cljs.core.async.close_BANG_.call(null,out);
var state_45781__$1 = (function (){var statearr_45793 = state_45781;
(statearr_45793[(9)] = inst_45777);

return statearr_45793;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45781__$1,inst_45778);
} else {
if((state_val_45782 === (2))){
var state_45781__$1 = state_45781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45781__$1,(4),ch);
} else {
if((state_val_45782 === (11))){
var inst_45760 = (state_45781[(8)]);
var inst_45769 = (state_45781[(2)]);
var inst_45757 = inst_45760;
var state_45781__$1 = (function (){var statearr_45795 = state_45781;
(statearr_45795[(10)] = inst_45769);

(statearr_45795[(7)] = inst_45757);

return statearr_45795;
})();
var statearr_45797_47355 = state_45781__$1;
(statearr_45797_47355[(2)] = null);

(statearr_45797_47355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45782 === (9))){
var inst_45760 = (state_45781[(8)]);
var state_45781__$1 = state_45781;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45781__$1,(11),out,inst_45760);
} else {
if((state_val_45782 === (5))){
var inst_45757 = (state_45781[(7)]);
var inst_45760 = (state_45781[(8)]);
var inst_45764 = cljs.core._EQ_.call(null,inst_45760,inst_45757);
var state_45781__$1 = state_45781;
if(inst_45764){
var statearr_45805_47357 = state_45781__$1;
(statearr_45805_47357[(1)] = (8));

} else {
var statearr_45806_47358 = state_45781__$1;
(statearr_45806_47358[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45782 === (10))){
var inst_45772 = (state_45781[(2)]);
var state_45781__$1 = state_45781;
var statearr_45807_47359 = state_45781__$1;
(statearr_45807_47359[(2)] = inst_45772);

(statearr_45807_47359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45782 === (8))){
var inst_45757 = (state_45781[(7)]);
var tmp45800 = inst_45757;
var inst_45757__$1 = tmp45800;
var state_45781__$1 = (function (){var statearr_45809 = state_45781;
(statearr_45809[(7)] = inst_45757__$1);

return statearr_45809;
})();
var statearr_45815_47360 = state_45781__$1;
(statearr_45815_47360[(2)] = null);

(statearr_45815_47360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45816 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45816[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45816[(1)] = (1));

return statearr_45816;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45781){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45817){if((e45817 instanceof Object)){
var ex__42763__auto__ = e45817;
var statearr_45818_47365 = state_45781;
(statearr_45818_47365[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45781);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45817;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47366 = state_45781;
state_45781 = G__47366;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45781){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45819 = f__43110__auto__.call(null);
(statearr_45819[(6)] = c__43103__auto___47319);

return statearr_45819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__45827 = arguments.length;
switch (G__45827) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__43103__auto___47386 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45865){
var state_val_45866 = (state_45865[(1)]);
if((state_val_45866 === (7))){
var inst_45861 = (state_45865[(2)]);
var state_45865__$1 = state_45865;
var statearr_45867_47397 = state_45865__$1;
(statearr_45867_47397[(2)] = inst_45861);

(statearr_45867_47397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (1))){
var inst_45828 = (new Array(n));
var inst_45829 = inst_45828;
var inst_45830 = (0);
var state_45865__$1 = (function (){var statearr_45869 = state_45865;
(statearr_45869[(7)] = inst_45830);

(statearr_45869[(8)] = inst_45829);

return statearr_45869;
})();
var statearr_45870_47405 = state_45865__$1;
(statearr_45870_47405[(2)] = null);

(statearr_45870_47405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (4))){
var inst_45833 = (state_45865[(9)]);
var inst_45833__$1 = (state_45865[(2)]);
var inst_45834 = (inst_45833__$1 == null);
var inst_45835 = cljs.core.not.call(null,inst_45834);
var state_45865__$1 = (function (){var statearr_45871 = state_45865;
(statearr_45871[(9)] = inst_45833__$1);

return statearr_45871;
})();
if(inst_45835){
var statearr_45872_47417 = state_45865__$1;
(statearr_45872_47417[(1)] = (5));

} else {
var statearr_45873_47421 = state_45865__$1;
(statearr_45873_47421[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (15))){
var inst_45855 = (state_45865[(2)]);
var state_45865__$1 = state_45865;
var statearr_45874_47426 = state_45865__$1;
(statearr_45874_47426[(2)] = inst_45855);

(statearr_45874_47426[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (13))){
var state_45865__$1 = state_45865;
var statearr_45877_47427 = state_45865__$1;
(statearr_45877_47427[(2)] = null);

(statearr_45877_47427[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (6))){
var inst_45830 = (state_45865[(7)]);
var inst_45851 = (inst_45830 > (0));
var state_45865__$1 = state_45865;
if(cljs.core.truth_(inst_45851)){
var statearr_45878_47429 = state_45865__$1;
(statearr_45878_47429[(1)] = (12));

} else {
var statearr_45879_47430 = state_45865__$1;
(statearr_45879_47430[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (3))){
var inst_45863 = (state_45865[(2)]);
var state_45865__$1 = state_45865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45865__$1,inst_45863);
} else {
if((state_val_45866 === (12))){
var inst_45829 = (state_45865[(8)]);
var inst_45853 = cljs.core.vec.call(null,inst_45829);
var state_45865__$1 = state_45865;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45865__$1,(15),out,inst_45853);
} else {
if((state_val_45866 === (2))){
var state_45865__$1 = state_45865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45865__$1,(4),ch);
} else {
if((state_val_45866 === (11))){
var inst_45845 = (state_45865[(2)]);
var inst_45846 = (new Array(n));
var inst_45829 = inst_45846;
var inst_45830 = (0);
var state_45865__$1 = (function (){var statearr_45882 = state_45865;
(statearr_45882[(7)] = inst_45830);

(statearr_45882[(8)] = inst_45829);

(statearr_45882[(10)] = inst_45845);

return statearr_45882;
})();
var statearr_45883_47435 = state_45865__$1;
(statearr_45883_47435[(2)] = null);

(statearr_45883_47435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (9))){
var inst_45829 = (state_45865[(8)]);
var inst_45843 = cljs.core.vec.call(null,inst_45829);
var state_45865__$1 = state_45865;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45865__$1,(11),out,inst_45843);
} else {
if((state_val_45866 === (5))){
var inst_45830 = (state_45865[(7)]);
var inst_45838 = (state_45865[(11)]);
var inst_45833 = (state_45865[(9)]);
var inst_45829 = (state_45865[(8)]);
var inst_45837 = (inst_45829[inst_45830] = inst_45833);
var inst_45838__$1 = (inst_45830 + (1));
var inst_45839 = (inst_45838__$1 < n);
var state_45865__$1 = (function (){var statearr_45884 = state_45865;
(statearr_45884[(11)] = inst_45838__$1);

(statearr_45884[(12)] = inst_45837);

return statearr_45884;
})();
if(cljs.core.truth_(inst_45839)){
var statearr_45885_47443 = state_45865__$1;
(statearr_45885_47443[(1)] = (8));

} else {
var statearr_45886_47444 = state_45865__$1;
(statearr_45886_47444[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (14))){
var inst_45858 = (state_45865[(2)]);
var inst_45859 = cljs.core.async.close_BANG_.call(null,out);
var state_45865__$1 = (function (){var statearr_45888 = state_45865;
(statearr_45888[(13)] = inst_45858);

return statearr_45888;
})();
var statearr_45889_47456 = state_45865__$1;
(statearr_45889_47456[(2)] = inst_45859);

(statearr_45889_47456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (10))){
var inst_45849 = (state_45865[(2)]);
var state_45865__$1 = state_45865;
var statearr_45892_47457 = state_45865__$1;
(statearr_45892_47457[(2)] = inst_45849);

(statearr_45892_47457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45866 === (8))){
var inst_45838 = (state_45865[(11)]);
var inst_45829 = (state_45865[(8)]);
var tmp45887 = inst_45829;
var inst_45829__$1 = tmp45887;
var inst_45830 = inst_45838;
var state_45865__$1 = (function (){var statearr_45893 = state_45865;
(statearr_45893[(7)] = inst_45830);

(statearr_45893[(8)] = inst_45829__$1);

return statearr_45893;
})();
var statearr_45894_47458 = state_45865__$1;
(statearr_45894_47458[(2)] = null);

(statearr_45894_47458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45897[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45897[(1)] = (1));

return statearr_45897;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45865){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45898){if((e45898 instanceof Object)){
var ex__42763__auto__ = e45898;
var statearr_45899_47464 = state_45865;
(statearr_45899_47464[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45865);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47465 = state_45865;
state_45865 = G__47465;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45865){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45900 = f__43110__auto__.call(null);
(statearr_45900[(6)] = c__43103__auto___47386);

return statearr_45900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__45904 = arguments.length;
switch (G__45904) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__43103__auto___47470 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_45948){
var state_val_45949 = (state_45948[(1)]);
if((state_val_45949 === (7))){
var inst_45944 = (state_45948[(2)]);
var state_45948__$1 = state_45948;
var statearr_45950_47471 = state_45948__$1;
(statearr_45950_47471[(2)] = inst_45944);

(statearr_45950_47471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (1))){
var inst_45907 = [];
var inst_45908 = inst_45907;
var inst_45909 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_45948__$1 = (function (){var statearr_45951 = state_45948;
(statearr_45951[(7)] = inst_45908);

(statearr_45951[(8)] = inst_45909);

return statearr_45951;
})();
var statearr_45952_47473 = state_45948__$1;
(statearr_45952_47473[(2)] = null);

(statearr_45952_47473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (4))){
var inst_45912 = (state_45948[(9)]);
var inst_45912__$1 = (state_45948[(2)]);
var inst_45913 = (inst_45912__$1 == null);
var inst_45914 = cljs.core.not.call(null,inst_45913);
var state_45948__$1 = (function (){var statearr_45960 = state_45948;
(statearr_45960[(9)] = inst_45912__$1);

return statearr_45960;
})();
if(inst_45914){
var statearr_45965_47474 = state_45948__$1;
(statearr_45965_47474[(1)] = (5));

} else {
var statearr_45966_47475 = state_45948__$1;
(statearr_45966_47475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (15))){
var inst_45938 = (state_45948[(2)]);
var state_45948__$1 = state_45948;
var statearr_45972_47477 = state_45948__$1;
(statearr_45972_47477[(2)] = inst_45938);

(statearr_45972_47477[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (13))){
var state_45948__$1 = state_45948;
var statearr_45976_47478 = state_45948__$1;
(statearr_45976_47478[(2)] = null);

(statearr_45976_47478[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (6))){
var inst_45908 = (state_45948[(7)]);
var inst_45933 = inst_45908.length;
var inst_45934 = (inst_45933 > (0));
var state_45948__$1 = state_45948;
if(cljs.core.truth_(inst_45934)){
var statearr_45977_47480 = state_45948__$1;
(statearr_45977_47480[(1)] = (12));

} else {
var statearr_45980_47481 = state_45948__$1;
(statearr_45980_47481[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (3))){
var inst_45946 = (state_45948[(2)]);
var state_45948__$1 = state_45948;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45948__$1,inst_45946);
} else {
if((state_val_45949 === (12))){
var inst_45908 = (state_45948[(7)]);
var inst_45936 = cljs.core.vec.call(null,inst_45908);
var state_45948__$1 = state_45948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45948__$1,(15),out,inst_45936);
} else {
if((state_val_45949 === (2))){
var state_45948__$1 = state_45948;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45948__$1,(4),ch);
} else {
if((state_val_45949 === (11))){
var inst_45916 = (state_45948[(10)]);
var inst_45912 = (state_45948[(9)]);
var inst_45926 = (state_45948[(2)]);
var inst_45927 = [];
var inst_45928 = inst_45927.push(inst_45912);
var inst_45908 = inst_45927;
var inst_45909 = inst_45916;
var state_45948__$1 = (function (){var statearr_45982 = state_45948;
(statearr_45982[(7)] = inst_45908);

(statearr_45982[(11)] = inst_45926);

(statearr_45982[(8)] = inst_45909);

(statearr_45982[(12)] = inst_45928);

return statearr_45982;
})();
var statearr_45983_47483 = state_45948__$1;
(statearr_45983_47483[(2)] = null);

(statearr_45983_47483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (9))){
var inst_45908 = (state_45948[(7)]);
var inst_45924 = cljs.core.vec.call(null,inst_45908);
var state_45948__$1 = state_45948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45948__$1,(11),out,inst_45924);
} else {
if((state_val_45949 === (5))){
var inst_45916 = (state_45948[(10)]);
var inst_45909 = (state_45948[(8)]);
var inst_45912 = (state_45948[(9)]);
var inst_45916__$1 = f.call(null,inst_45912);
var inst_45917 = cljs.core._EQ_.call(null,inst_45916__$1,inst_45909);
var inst_45918 = cljs.core.keyword_identical_QMARK_.call(null,inst_45909,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_45919 = ((inst_45917) || (inst_45918));
var state_45948__$1 = (function (){var statearr_45984 = state_45948;
(statearr_45984[(10)] = inst_45916__$1);

return statearr_45984;
})();
if(cljs.core.truth_(inst_45919)){
var statearr_45985_47486 = state_45948__$1;
(statearr_45985_47486[(1)] = (8));

} else {
var statearr_45986_47487 = state_45948__$1;
(statearr_45986_47487[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (14))){
var inst_45941 = (state_45948[(2)]);
var inst_45942 = cljs.core.async.close_BANG_.call(null,out);
var state_45948__$1 = (function (){var statearr_45988 = state_45948;
(statearr_45988[(13)] = inst_45941);

return statearr_45988;
})();
var statearr_45989_47490 = state_45948__$1;
(statearr_45989_47490[(2)] = inst_45942);

(statearr_45989_47490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (10))){
var inst_45931 = (state_45948[(2)]);
var state_45948__$1 = state_45948;
var statearr_45990_47492 = state_45948__$1;
(statearr_45990_47492[(2)] = inst_45931);

(statearr_45990_47492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45949 === (8))){
var inst_45908 = (state_45948[(7)]);
var inst_45916 = (state_45948[(10)]);
var inst_45912 = (state_45948[(9)]);
var inst_45921 = inst_45908.push(inst_45912);
var tmp45987 = inst_45908;
var inst_45908__$1 = tmp45987;
var inst_45909 = inst_45916;
var state_45948__$1 = (function (){var statearr_45991 = state_45948;
(statearr_45991[(7)] = inst_45908__$1);

(statearr_45991[(8)] = inst_45909);

(statearr_45991[(14)] = inst_45921);

return statearr_45991;
})();
var statearr_45992_47494 = state_45948__$1;
(statearr_45992_47494[(2)] = null);

(statearr_45992_47494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42760__auto__ = null;
var cljs$core$async$state_machine__42760__auto____0 = (function (){
var statearr_45993 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45993[(0)] = cljs$core$async$state_machine__42760__auto__);

(statearr_45993[(1)] = (1));

return statearr_45993;
});
var cljs$core$async$state_machine__42760__auto____1 = (function (state_45948){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_45948);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e45994){if((e45994 instanceof Object)){
var ex__42763__auto__ = e45994;
var statearr_45995_47502 = state_45948;
(statearr_45995_47502[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45948);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45994;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47505 = state_45948;
state_45948 = G__47505;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
cljs$core$async$state_machine__42760__auto__ = function(state_45948){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42760__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42760__auto____1.call(this,state_45948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42760__auto____0;
cljs$core$async$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42760__auto____1;
return cljs$core$async$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_45996 = f__43110__auto__.call(null);
(statearr_45996[(6)] = c__43103__auto___47470);

return statearr_45996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
