goog.provide('com.wsscode.pathom3.connect.built_in.resolvers');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom3.connect.built-in.resolvers","entity-table","com.wsscode.pathom3.connect.built-in.resolvers/entity-table",-882305838),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"any?","any?",-318999933,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.any_QMARK_,cljs.core.map_QMARK_], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__56253){
return cljs.core.map_QMARK_.call(null,G__56253);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13273__auto__,v__13274__auto__){
return cljs.core.nth.call(null,v__13274__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))], null),null));
com.wsscode.pathom3.connect.built_in.resolvers.attr_munge = (function com$wsscode$pathom3$connect$built_in$resolvers$attr_munge(attr){
return cljs.core.munge.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(attr),(1)));
});
com.wsscode.pathom3.connect.built_in.resolvers.attr_alias_resolver_name = (function com$wsscode$pathom3$connect$built_in$resolvers$attr_alias_resolver_name(from,to){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.connect.built_in.resolvers.attr_munge.call(null,from)),"->",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.connect.built_in.resolvers.attr_munge.call(null,to))].join(''));
});
/**
 * Create a resolver that will convert property `from` to a property `to` with
 *   the same value. This only creates the alias in one direction.
 */
com.wsscode.pathom3.connect.built_in.resolvers.alias_resolver = (function com$wsscode$pathom3$connect$built_in$resolvers$alias_resolver(from,to){
return com.wsscode.pathom3.connect.operation.resolver.call(null,com.wsscode.pathom3.connect.built_in.resolvers.attr_alias_resolver_name.call(null,from,to),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","input","com.wsscode.pathom3.connect.operation/input",-1553849497),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [from], null),new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","output","com.wsscode.pathom3.connect.operation/output",801488703),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [to], null)], null),(function (_,input){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([to,cljs.core.get.call(null,input,from)]);
}));
});
/**
 * Like alias-resolver, but returns a vector containing the alias in both directions.
 */
com.wsscode.pathom3.connect.built_in.resolvers.alias_resolver2 = (function com$wsscode$pathom3$connect$built_in$resolvers$alias_resolver2(attribute_a,attribute_b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.pathom3.connect.built_in.resolvers.alias_resolver.call(null,attribute_a,attribute_b),com.wsscode.pathom3.connect.built_in.resolvers.alias_resolver.call(null,attribute_b,attribute_a)], null);
});
/**
 * Create a simple resolver that always return `value` for `attribute`.
 */
com.wsscode.pathom3.connect.built_in.resolvers.constantly_resolver = (function com$wsscode$pathom3$connect$built_in$resolvers$constantly_resolver(var_args){
var G__56262 = arguments.length;
switch (G__56262) {
case 2:
return com.wsscode.pathom3.connect.built_in.resolvers.constantly_resolver.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return com.wsscode.pathom3.connect.built_in.resolvers.constantly_resolver.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.pathom3.connect.built_in.resolvers.constantly_resolver.cljs$core$IFn$_invoke$arity$2 = (function (attribute,value){
return com.wsscode.pathom3.connect.built_in.resolvers.constantly_resolver.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.connect.built-in.resolvers","attribute","com.wsscode.pathom3.connect.built-in.resolvers/attribute",1675511837),attribute,new cljs.core.Keyword(null,"value","value",305978217),value], null));
}));

(com.wsscode.pathom3.connect.built_in.resolvers.constantly_resolver.cljs$core$IFn$_invoke$arity$1 = (function (p__56263){
var map__56264 = p__56263;
var map__56264__$1 = (((((!((map__56264 == null))))?(((((map__56264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56264):map__56264);
var attribute = cljs.core.get.call(null,map__56264__$1,new cljs.core.Keyword("com.wsscode.pathom3.connect.built-in.resolvers","attribute","com.wsscode.pathom3.connect.built-in.resolvers/attribute",1675511837));
var sym = cljs.core.get.call(null,map__56264__$1,new cljs.core.Keyword("com.wsscode.pathom3.connect.built-in.resolvers","sym","com.wsscode.pathom3.connect.built-in.resolvers/sym",156996179));
var value = cljs.core.get.call(null,map__56264__$1,new cljs.core.Keyword(null,"value","value",305978217));
var resolver_name = (function (){var or__4126__auto__ = sym;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(attribute),(1)))),"-constant"].join(''));
}
})();
return com.wsscode.pathom3.connect.operation.resolver.call(null,resolver_name,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","output","com.wsscode.pathom3.connect.operation/output",801488703),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attribute], null)], null),(function (_,___$1){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([attribute,value]);
}));
}));

(com.wsscode.pathom3.connect.built_in.resolvers.constantly_resolver.cljs$lang$maxFixedArity = 2);

/**
 * Apply fn `f` to input `from` and spits the result with the name `to`.
 * 
 *   `f` receives a single argument, which is the input value from `from`.
 */
com.wsscode.pathom3.connect.built_in.resolvers.single_attr_resolver = (function com$wsscode$pathom3$connect$built_in$resolvers$single_attr_resolver(from,to,f){
var resolver_name = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.connect.built_in.resolvers.attr_alias_resolver_name.call(null,from,to)),"-single-attr-transform"].join(''));
return com.wsscode.pathom3.connect.operation.resolver.call(null,resolver_name,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","input","com.wsscode.pathom3.connect.operation/input",-1553849497),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [from], null),new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","output","com.wsscode.pathom3.connect.operation/output",801488703),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [to], null)], null),(function (_,input){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([to,f.call(null,cljs.core.get.call(null,input,from))]);
}));
});
/**
 * Similar single-attr-resolver, but `f` receives two arguments, `env` and the input.
 */
com.wsscode.pathom3.connect.built_in.resolvers.single_attr_resolver2 = (function com$wsscode$pathom3$connect$built_in$resolvers$single_attr_resolver2(from,to,f){
var resolver_name = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.connect.built_in.resolvers.attr_alias_resolver_name.call(null,from,to)),"-single-attr-transform"].join(''));
return com.wsscode.pathom3.connect.operation.resolver.call(null,resolver_name,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","input","com.wsscode.pathom3.connect.operation/input",-1553849497),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [from], null),new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","output","com.wsscode.pathom3.connect.operation/output",801488703),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [to], null)], null),(function (env,input){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([to,f.call(null,env,cljs.core.get.call(null,input,from))]);
}));
});
/**
 * For a given static table, compute the accumulated output query of the entity values.
 */
com.wsscode.pathom3.connect.built_in.resolvers.table_output = (function com$wsscode$pathom3$connect$built_in$resolvers$table_output(table){
var vec__56275 = com.wsscode.pathom3.format.eql.data__GT_query.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"output","output",-1105869043),cljs.core.vec.call(null,cljs.core.vals.call(null,table))], null));
var map__56278 = cljs.core.nth.call(null,vec__56275,(0),null);
var map__56278__$1 = (((((!((map__56278 == null))))?(((((map__56278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56278.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56278):map__56278);
var output = cljs.core.get.call(null,map__56278__$1,new cljs.core.Keyword(null,"output","output",-1105869043));
return output;
});
/**
 * Exposes data for entities, indexes by attr-key. This is a simple way to extend/provide
 *   data for entities using simple Clojure maps. Example:
 * 
 *    (def registry
 *      [(pbir/static-table-resolver `song-names :song/id
 *         {1 {:song/name "Marchinha Psicotica de Dr. Soup"}
 *          2 {:song/name "There's Enough"}})
 * 
 *       (pbir/static-table-resolver `song-analysis :song/id
 *         {1 {:song/duration 280 :song/tempo 98}
 *          2 {:song/duration 150 :song/tempo 130}})])
 * 
 *    (let [sm (psm/smart-map (pci/register registry)
 *               {:song/id 1})]
 *      (select-keys sm [:song/id :song/name :song/duration]))
 *    ; => #:song{:id 1, :name "Marchinha Psicotica de Dr. Soup", :duration 280}
 * 
 *   In this example, we create two different tables that provides data about songs, the
 *   entities are related by the keys on the table, the `attr-key` says what's the property
 *   name to be used to related the data, in this case we use `:song/id` on both, so they
 *   get connected by it.
 *   
 */
com.wsscode.pathom3.connect.built_in.resolvers.static_table_resolver = (function com$wsscode$pathom3$connect$built_in$resolvers$static_table_resolver(resolver_name,attr_key,table){
var output = com.wsscode.pathom3.connect.built_in.resolvers.table_output.call(null,table);
return com.wsscode.pathom3.connect.operation.resolver.call(null,resolver_name,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","input","com.wsscode.pathom3.connect.operation/input",-1553849497),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr_key], null),new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","output","com.wsscode.pathom3.connect.operation/output",801488703),output], null),(function (_,input){
var id = cljs.core.get.call(null,input,attr_key);
return cljs.core.get.call(null,table,id);
}));
});
/**
 * Similar to static-table-resolver, but instead of a static map, this will pull the
 *   table from another attribute in the system. Given in this case the values can be dynamic,
 *   this helper requires a pre-defined output, so the attributes on this output get
 *   delegated to the created resolver.
 * 
 *    (def registry
 *      [(pbir/static-table-resolver `song-names :song/id
 *         {1 {:song/name "Marchinha Psicotica de Dr. Soup"}
 *          2 {:song/name "There's Enough"}})
 * 
 *       (pbir/constantly-resolver ::song-analysis
 *         {1 {:song/duration 280 :song/tempo 98}
 *          2 {:song/duration 150 :song/tempo 130}})
 * 
 *       (pbir/attribute-table-resolver ::song-analysis :song/id
 *         [:song/duration :song/tempo])])
 * 
 *    (let [sm (psm/smart-map (pci/register registry)
 *               {:song/id 2})]
 *      (select-keys sm [:song/id :song/name :song/duration]))
 *    ; => #:song{:id 2, :name "There's Enough", :duration 150}
 *   
 */
com.wsscode.pathom3.connect.built_in.resolvers.attribute_table_resolver = (function com$wsscode$pathom3$connect$built_in$resolvers$attribute_table_resolver(table_name,attr_key,output){
var resolver_name = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.connect.built_in.resolvers.attr_munge.call(null,attr_key)),"-table-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.connect.built_in.resolvers.attr_munge.call(null,table_name))].join(''));
return com.wsscode.pathom3.connect.operation.resolver.call(null,resolver_name,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","input","com.wsscode.pathom3.connect.operation/input",-1553849497),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr_key,table_name], null),new cljs.core.Keyword("com.wsscode.pathom3.connect.operation","output","com.wsscode.pathom3.connect.operation/output",801488703),output], null),(function (_,input){
var table = cljs.core.get.call(null,input,table_name);
var id = cljs.core.get.call(null,input,attr_key);
return cljs.core.get.call(null,table,id);
}));
});

//# sourceMappingURL=com.wsscode.pathom3.connect.built_in.resolvers.js.map
