(ns com.wsscode.demos.perf
  (:require [com.wsscode.pathom.connect :as pc]
            [criterium.core :as c]
            [com.wsscode.pathom.core :as p]))

(pc/defresolver long-list [env _]
  {::pc/output [{:items
                 [:id]}]}
  {:items (mapv #(hash-map :id %) (range 10000))})

(pc/defresolver short-list [env _]
  {::pc/output [{:short-items
                 [:id]}]}
  {:short-items (mapv #(hash-map :id %) (range 100))})

(pc/defresolver x [env {:keys [id]}]
  {::pc/input  #{:id}
   ::pc/output [:x]}
  {:x (* 10 id)})

(pc/defresolver y [env {:keys [id]}]
  {::pc/input  #{:id}
   ::pc/output [:y]}
  {:y (* 10 id)})

(def registry [long-list short-list x y])

(def parser
  (p/parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/reader2
                                            pc/open-ident-reader
                                            p/env-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}}
     ::p/mutate  pc/mutate
     ::p/plugins [(pc/connect-plugin {::pc/register registry})
                  p/error-handler-plugin
                  p/trace-plugin]}))

(comment
  ((parser {} [{:items [:x]}]))

  (c/with-progress-reporting
    (c/quick-bench
      (time
       (do (parser {} [{:items
                        [:x
                         {:short-items
                          [:y]}]}])
           nil)))))

; results
{[{:items [:x]}]
 {"2.2" 1.188888
  "2.3" 1.189224}

 [{:items
   [:x
    {:shot-items
     [:x]}]}]
 {"2.2" 1.590171
  "2.3" nil}

 [{:short-items
   [:x
    {:items
     [:x]}]}]
 {"2.2" nil
  "2.3" nil}}
