goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__54155 = arguments.length;
switch (G__54155) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54160 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54160 = (function (f,blockable,meta54161){
this.f = f;
this.blockable = blockable;
this.meta54161 = meta54161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54162,meta54161__$1){
var self__ = this;
var _54162__$1 = this;
return (new cljs.core.async.t_cljs$core$async54160(self__.f,self__.blockable,meta54161__$1));
});

cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54162){
var self__ = this;
var _54162__$1 = this;
return self__.meta54161;
});

cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async54160.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta54161","meta54161",1718604197,null)], null);
});

cljs.core.async.t_cljs$core$async54160.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54160";

cljs.core.async.t_cljs$core$async54160.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async54160");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54160.
 */
cljs.core.async.__GT_t_cljs$core$async54160 = (function cljs$core$async$__GT_t_cljs$core$async54160(f__$1,blockable__$1,meta54161){
return (new cljs.core.async.t_cljs$core$async54160(f__$1,blockable__$1,meta54161));
});

}

return (new cljs.core.async.t_cljs$core$async54160(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__54186 = arguments.length;
switch (G__54186) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__54195 = arguments.length;
switch (G__54195) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__54207 = arguments.length;
switch (G__54207) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_56432 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_56432);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_56432,ret){
return (function (){
return fn1.call(null,val_56432);
});})(val_56432,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__54261 = arguments.length;
switch (G__54261) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5718__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5718__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___56436 = n;
var x_56437 = (0);
while(true){
if((x_56437 < n__4607__auto___56436)){
(a[x_56437] = (0));

var G__56440 = (x_56437 + (1));
x_56437 = G__56440;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__56441 = (i + (1));
i = G__56441;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54266 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54266 = (function (flag,meta54267){
this.flag = flag;
this.meta54267 = meta54267;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54266.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_54268,meta54267__$1){
var self__ = this;
var _54268__$1 = this;
return (new cljs.core.async.t_cljs$core$async54266(self__.flag,meta54267__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async54266.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_54268){
var self__ = this;
var _54268__$1 = this;
return self__.meta54267;
});})(flag))
;

cljs.core.async.t_cljs$core$async54266.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54266.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async54266.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async54266.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async54266.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta54267","meta54267",674296105,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async54266.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54266.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54266";

cljs.core.async.t_cljs$core$async54266.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async54266");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54266.
 */
cljs.core.async.__GT_t_cljs$core$async54266 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async54266(flag__$1,meta54267){
return (new cljs.core.async.t_cljs$core$async54266(flag__$1,meta54267));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async54266(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54269 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54269 = (function (flag,cb,meta54270){
this.flag = flag;
this.cb = cb;
this.meta54270 = meta54270;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54269.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54271,meta54270__$1){
var self__ = this;
var _54271__$1 = this;
return (new cljs.core.async.t_cljs$core$async54269(self__.flag,self__.cb,meta54270__$1));
});

cljs.core.async.t_cljs$core$async54269.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54271){
var self__ = this;
var _54271__$1 = this;
return self__.meta54270;
});

cljs.core.async.t_cljs$core$async54269.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54269.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async54269.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async54269.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async54269.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta54270","meta54270",211521905,null)], null);
});

cljs.core.async.t_cljs$core$async54269.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54269.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54269";

cljs.core.async.t_cljs$core$async54269.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async54269");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54269.
 */
cljs.core.async.__GT_t_cljs$core$async54269 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async54269(flag__$1,cb__$1,meta54270){
return (new cljs.core.async.t_cljs$core$async54269(flag__$1,cb__$1,meta54270));
});

}

return (new cljs.core.async.t_cljs$core$async54269(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54272_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54272_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54273_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54273_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__56450 = (i + (1));
i = G__56450;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___56455 = arguments.length;
var i__4731__auto___56456 = (0);
while(true){
if((i__4731__auto___56456 < len__4730__auto___56455)){
args__4736__auto__.push((arguments[i__4731__auto___56456]));

var G__56457 = (i__4731__auto___56456 + (1));
i__4731__auto___56456 = G__56457;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__54276){
var map__54277 = p__54276;
var map__54277__$1 = (((((!((map__54277 == null))))?(((((map__54277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54277):map__54277);
var opts = map__54277__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq54274){
var G__54275 = cljs.core.first.call(null,seq54274);
var seq54274__$1 = cljs.core.next.call(null,seq54274);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54275,seq54274__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__54280 = arguments.length;
switch (G__54280) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__54028__auto___56472 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___56472){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___56472){
return (function (state_54308){
var state_val_54309 = (state_54308[(1)]);
if((state_val_54309 === (7))){
var inst_54303 = (state_54308[(2)]);
var state_54308__$1 = state_54308;
var statearr_54318_56476 = state_54308__$1;
(statearr_54318_56476[(2)] = inst_54303);

(statearr_54318_56476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (1))){
var state_54308__$1 = state_54308;
var statearr_54319_56477 = state_54308__$1;
(statearr_54319_56477[(2)] = null);

(statearr_54319_56477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (4))){
var inst_54286 = (state_54308[(7)]);
var inst_54286__$1 = (state_54308[(2)]);
var inst_54287 = (inst_54286__$1 == null);
var state_54308__$1 = (function (){var statearr_54320 = state_54308;
(statearr_54320[(7)] = inst_54286__$1);

return statearr_54320;
})();
if(cljs.core.truth_(inst_54287)){
var statearr_54321_56480 = state_54308__$1;
(statearr_54321_56480[(1)] = (5));

} else {
var statearr_54322_56482 = state_54308__$1;
(statearr_54322_56482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (13))){
var state_54308__$1 = state_54308;
var statearr_54323_56484 = state_54308__$1;
(statearr_54323_56484[(2)] = null);

(statearr_54323_56484[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (6))){
var inst_54286 = (state_54308[(7)]);
var state_54308__$1 = state_54308;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54308__$1,(11),to,inst_54286);
} else {
if((state_val_54309 === (3))){
var inst_54305 = (state_54308[(2)]);
var state_54308__$1 = state_54308;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54308__$1,inst_54305);
} else {
if((state_val_54309 === (12))){
var state_54308__$1 = state_54308;
var statearr_54325_56488 = state_54308__$1;
(statearr_54325_56488[(2)] = null);

(statearr_54325_56488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (2))){
var state_54308__$1 = state_54308;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54308__$1,(4),from);
} else {
if((state_val_54309 === (11))){
var inst_54296 = (state_54308[(2)]);
var state_54308__$1 = state_54308;
if(cljs.core.truth_(inst_54296)){
var statearr_54326_56496 = state_54308__$1;
(statearr_54326_56496[(1)] = (12));

} else {
var statearr_54328_56498 = state_54308__$1;
(statearr_54328_56498[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (9))){
var state_54308__$1 = state_54308;
var statearr_54329_56503 = state_54308__$1;
(statearr_54329_56503[(2)] = null);

(statearr_54329_56503[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (5))){
var state_54308__$1 = state_54308;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54330_56508 = state_54308__$1;
(statearr_54330_56508[(1)] = (8));

} else {
var statearr_54332_56510 = state_54308__$1;
(statearr_54332_56510[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (14))){
var inst_54301 = (state_54308[(2)]);
var state_54308__$1 = state_54308;
var statearr_54333_56513 = state_54308__$1;
(statearr_54333_56513[(2)] = inst_54301);

(statearr_54333_56513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (10))){
var inst_54293 = (state_54308[(2)]);
var state_54308__$1 = state_54308;
var statearr_54334_56515 = state_54308__$1;
(statearr_54334_56515[(2)] = inst_54293);

(statearr_54334_56515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54309 === (8))){
var inst_54290 = cljs.core.async.close_BANG_.call(null,to);
var state_54308__$1 = state_54308;
var statearr_54335_56518 = state_54308__$1;
(statearr_54335_56518[(2)] = inst_54290);

(statearr_54335_56518[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___56472))
;
return ((function (switch__53637__auto__,c__54028__auto___56472){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_54336 = [null,null,null,null,null,null,null,null];
(statearr_54336[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_54336[(1)] = (1));

return statearr_54336;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_54308){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54308);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54339){if((e54339 instanceof Object)){
var ex__53641__auto__ = e54339;
var statearr_54340_56526 = state_54308;
(statearr_54340_56526[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54308);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54339;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56529 = state_54308;
state_54308 = G__56529;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_54308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_54308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___56472))
})();
var state__54030__auto__ = (function (){var statearr_54341 = f__54029__auto__();
(statearr_54341[(6)] = c__54028__auto___56472);

return statearr_54341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___56472))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__54342){
var vec__54343 = p__54342;
var v = cljs.core.nth.call(null,vec__54343,(0),null);
var p = cljs.core.nth.call(null,vec__54343,(1),null);
var job = vec__54343;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__54028__auto___56541 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___56541,res,vec__54343,v,p,job,jobs,results){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___56541,res,vec__54343,v,p,job,jobs,results){
return (function (state_54350){
var state_val_54351 = (state_54350[(1)]);
if((state_val_54351 === (1))){
var state_54350__$1 = state_54350;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54350__$1,(2),res,v);
} else {
if((state_val_54351 === (2))){
var inst_54347 = (state_54350[(2)]);
var inst_54348 = cljs.core.async.close_BANG_.call(null,res);
var state_54350__$1 = (function (){var statearr_54352 = state_54350;
(statearr_54352[(7)] = inst_54347);

return statearr_54352;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54350__$1,inst_54348);
} else {
return null;
}
}
});})(c__54028__auto___56541,res,vec__54343,v,p,job,jobs,results))
;
return ((function (switch__53637__auto__,c__54028__auto___56541,res,vec__54343,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0 = (function (){
var statearr_54353 = [null,null,null,null,null,null,null,null];
(statearr_54353[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__);

(statearr_54353[(1)] = (1));

return statearr_54353;
});
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1 = (function (state_54350){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54350);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54354){if((e54354 instanceof Object)){
var ex__53641__auto__ = e54354;
var statearr_54355_56554 = state_54350;
(statearr_54355_56554[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54350);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54354;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56556 = state_54350;
state_54350 = G__56556;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = function(state_54350){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1.call(this,state_54350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___56541,res,vec__54343,v,p,job,jobs,results))
})();
var state__54030__auto__ = (function (){var statearr_54356 = f__54029__auto__();
(statearr_54356[(6)] = c__54028__auto___56541);

return statearr_54356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___56541,res,vec__54343,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__54360){
var vec__54361 = p__54360;
var v = cljs.core.nth.call(null,vec__54361,(0),null);
var p = cljs.core.nth.call(null,vec__54361,(1),null);
var job = vec__54361;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___56557 = n;
var __56558 = (0);
while(true){
if((__56558 < n__4607__auto___56557)){
var G__54364_56560 = type;
var G__54364_56561__$1 = (((G__54364_56560 instanceof cljs.core.Keyword))?G__54364_56560.fqn:null);
switch (G__54364_56561__$1) {
case "compute":
var c__54028__auto___56564 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__56558,c__54028__auto___56564,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (__56558,c__54028__auto___56564,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async){
return (function (state_54377){
var state_val_54378 = (state_54377[(1)]);
if((state_val_54378 === (1))){
var state_54377__$1 = state_54377;
var statearr_54383_56569 = state_54377__$1;
(statearr_54383_56569[(2)] = null);

(statearr_54383_56569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (2))){
var state_54377__$1 = state_54377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54377__$1,(4),jobs);
} else {
if((state_val_54378 === (3))){
var inst_54375 = (state_54377[(2)]);
var state_54377__$1 = state_54377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54377__$1,inst_54375);
} else {
if((state_val_54378 === (4))){
var inst_54367 = (state_54377[(2)]);
var inst_54368 = process(inst_54367);
var state_54377__$1 = state_54377;
if(cljs.core.truth_(inst_54368)){
var statearr_54385_56574 = state_54377__$1;
(statearr_54385_56574[(1)] = (5));

} else {
var statearr_54386_56576 = state_54377__$1;
(statearr_54386_56576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (5))){
var state_54377__$1 = state_54377;
var statearr_54387_56577 = state_54377__$1;
(statearr_54387_56577[(2)] = null);

(statearr_54387_56577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (6))){
var state_54377__$1 = state_54377;
var statearr_54388_56578 = state_54377__$1;
(statearr_54388_56578[(2)] = null);

(statearr_54388_56578[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (7))){
var inst_54373 = (state_54377[(2)]);
var state_54377__$1 = state_54377;
var statearr_54389_56579 = state_54377__$1;
(statearr_54389_56579[(2)] = inst_54373);

(statearr_54389_56579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__56558,c__54028__auto___56564,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async))
;
return ((function (__56558,switch__53637__auto__,c__54028__auto___56564,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0 = (function (){
var statearr_54390 = [null,null,null,null,null,null,null];
(statearr_54390[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__);

(statearr_54390[(1)] = (1));

return statearr_54390;
});
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1 = (function (state_54377){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54391){if((e54391 instanceof Object)){
var ex__53641__auto__ = e54391;
var statearr_54392_56581 = state_54377;
(statearr_54392_56581[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54377);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54391;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56582 = state_54377;
state_54377 = G__56582;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = function(state_54377){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1.call(this,state_54377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__;
})()
;})(__56558,switch__53637__auto__,c__54028__auto___56564,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async))
})();
var state__54030__auto__ = (function (){var statearr_54397 = f__54029__auto__();
(statearr_54397[(6)] = c__54028__auto___56564);

return statearr_54397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(__56558,c__54028__auto___56564,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async))
);


break;
case "async":
var c__54028__auto___56585 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__56558,c__54028__auto___56585,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (__56558,c__54028__auto___56585,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async){
return (function (state_54413){
var state_val_54415 = (state_54413[(1)]);
if((state_val_54415 === (1))){
var state_54413__$1 = state_54413;
var statearr_54418_56592 = state_54413__$1;
(statearr_54418_56592[(2)] = null);

(statearr_54418_56592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (2))){
var state_54413__$1 = state_54413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54413__$1,(4),jobs);
} else {
if((state_val_54415 === (3))){
var inst_54411 = (state_54413[(2)]);
var state_54413__$1 = state_54413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54413__$1,inst_54411);
} else {
if((state_val_54415 === (4))){
var inst_54402 = (state_54413[(2)]);
var inst_54403 = async(inst_54402);
var state_54413__$1 = state_54413;
if(cljs.core.truth_(inst_54403)){
var statearr_54421_56596 = state_54413__$1;
(statearr_54421_56596[(1)] = (5));

} else {
var statearr_54422_56598 = state_54413__$1;
(statearr_54422_56598[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (5))){
var state_54413__$1 = state_54413;
var statearr_54428_56599 = state_54413__$1;
(statearr_54428_56599[(2)] = null);

(statearr_54428_56599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (6))){
var state_54413__$1 = state_54413;
var statearr_54430_56600 = state_54413__$1;
(statearr_54430_56600[(2)] = null);

(statearr_54430_56600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (7))){
var inst_54409 = (state_54413[(2)]);
var state_54413__$1 = state_54413;
var statearr_54431_56601 = state_54413__$1;
(statearr_54431_56601[(2)] = inst_54409);

(statearr_54431_56601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__56558,c__54028__auto___56585,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async))
;
return ((function (__56558,switch__53637__auto__,c__54028__auto___56585,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0 = (function (){
var statearr_54432 = [null,null,null,null,null,null,null];
(statearr_54432[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__);

(statearr_54432[(1)] = (1));

return statearr_54432;
});
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1 = (function (state_54413){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54435){if((e54435 instanceof Object)){
var ex__53641__auto__ = e54435;
var statearr_54436_56606 = state_54413;
(statearr_54436_56606[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54413);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54435;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56610 = state_54413;
state_54413 = G__56610;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = function(state_54413){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1.call(this,state_54413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__;
})()
;})(__56558,switch__53637__auto__,c__54028__auto___56585,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async))
})();
var state__54030__auto__ = (function (){var statearr_54442 = f__54029__auto__();
(statearr_54442[(6)] = c__54028__auto___56585);

return statearr_54442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(__56558,c__54028__auto___56585,G__54364_56560,G__54364_56561__$1,n__4607__auto___56557,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54364_56561__$1)].join('')));

}

var G__56617 = (__56558 + (1));
__56558 = G__56617;
continue;
} else {
}
break;
}

var c__54028__auto___56618 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___56618,jobs,results,process,async){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___56618,jobs,results,process,async){
return (function (state_54482){
var state_val_54483 = (state_54482[(1)]);
if((state_val_54483 === (7))){
var inst_54477 = (state_54482[(2)]);
var state_54482__$1 = state_54482;
var statearr_54491_56619 = state_54482__$1;
(statearr_54491_56619[(2)] = inst_54477);

(statearr_54491_56619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (1))){
var state_54482__$1 = state_54482;
var statearr_54494_56622 = state_54482__$1;
(statearr_54494_56622[(2)] = null);

(statearr_54494_56622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (4))){
var inst_54453 = (state_54482[(7)]);
var inst_54453__$1 = (state_54482[(2)]);
var inst_54456 = (inst_54453__$1 == null);
var state_54482__$1 = (function (){var statearr_54496 = state_54482;
(statearr_54496[(7)] = inst_54453__$1);

return statearr_54496;
})();
if(cljs.core.truth_(inst_54456)){
var statearr_54497_56624 = state_54482__$1;
(statearr_54497_56624[(1)] = (5));

} else {
var statearr_54498_56626 = state_54482__$1;
(statearr_54498_56626[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (6))){
var inst_54460 = (state_54482[(8)]);
var inst_54453 = (state_54482[(7)]);
var inst_54460__$1 = cljs.core.async.chan.call(null,(1));
var inst_54463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54464 = [inst_54453,inst_54460__$1];
var inst_54465 = (new cljs.core.PersistentVector(null,2,(5),inst_54463,inst_54464,null));
var state_54482__$1 = (function (){var statearr_54501 = state_54482;
(statearr_54501[(8)] = inst_54460__$1);

return statearr_54501;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54482__$1,(8),jobs,inst_54465);
} else {
if((state_val_54483 === (3))){
var inst_54480 = (state_54482[(2)]);
var state_54482__$1 = state_54482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54482__$1,inst_54480);
} else {
if((state_val_54483 === (2))){
var state_54482__$1 = state_54482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54482__$1,(4),from);
} else {
if((state_val_54483 === (9))){
var inst_54470 = (state_54482[(2)]);
var state_54482__$1 = (function (){var statearr_54504 = state_54482;
(statearr_54504[(9)] = inst_54470);

return statearr_54504;
})();
var statearr_54505_56648 = state_54482__$1;
(statearr_54505_56648[(2)] = null);

(statearr_54505_56648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (5))){
var inst_54458 = cljs.core.async.close_BANG_.call(null,jobs);
var state_54482__$1 = state_54482;
var statearr_54508_56651 = state_54482__$1;
(statearr_54508_56651[(2)] = inst_54458);

(statearr_54508_56651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (8))){
var inst_54460 = (state_54482[(8)]);
var inst_54468 = (state_54482[(2)]);
var state_54482__$1 = (function (){var statearr_54511 = state_54482;
(statearr_54511[(10)] = inst_54468);

return statearr_54511;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54482__$1,(9),results,inst_54460);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___56618,jobs,results,process,async))
;
return ((function (switch__53637__auto__,c__54028__auto___56618,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0 = (function (){
var statearr_54518 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54518[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__);

(statearr_54518[(1)] = (1));

return statearr_54518;
});
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1 = (function (state_54482){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54521){if((e54521 instanceof Object)){
var ex__53641__auto__ = e54521;
var statearr_54522_56663 = state_54482;
(statearr_54522_56663[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54521;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56665 = state_54482;
state_54482 = G__56665;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = function(state_54482){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1.call(this,state_54482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___56618,jobs,results,process,async))
})();
var state__54030__auto__ = (function (){var statearr_54526 = f__54029__auto__();
(statearr_54526[(6)] = c__54028__auto___56618);

return statearr_54526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___56618,jobs,results,process,async))
);


var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__,jobs,results,process,async){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__,jobs,results,process,async){
return (function (state_54571){
var state_val_54572 = (state_54571[(1)]);
if((state_val_54572 === (7))){
var inst_54567 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
var statearr_54580_56669 = state_54571__$1;
(statearr_54580_56669[(2)] = inst_54567);

(statearr_54580_56669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (20))){
var state_54571__$1 = state_54571;
var statearr_54581_56672 = state_54571__$1;
(statearr_54581_56672[(2)] = null);

(statearr_54581_56672[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (1))){
var state_54571__$1 = state_54571;
var statearr_54583_56677 = state_54571__$1;
(statearr_54583_56677[(2)] = null);

(statearr_54583_56677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (4))){
var inst_54531 = (state_54571[(7)]);
var inst_54531__$1 = (state_54571[(2)]);
var inst_54532 = (inst_54531__$1 == null);
var state_54571__$1 = (function (){var statearr_54585 = state_54571;
(statearr_54585[(7)] = inst_54531__$1);

return statearr_54585;
})();
if(cljs.core.truth_(inst_54532)){
var statearr_54587_56684 = state_54571__$1;
(statearr_54587_56684[(1)] = (5));

} else {
var statearr_54590_56686 = state_54571__$1;
(statearr_54590_56686[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (15))){
var inst_54545 = (state_54571[(8)]);
var state_54571__$1 = state_54571;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54571__$1,(18),to,inst_54545);
} else {
if((state_val_54572 === (21))){
var inst_54562 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
var statearr_54592_56691 = state_54571__$1;
(statearr_54592_56691[(2)] = inst_54562);

(statearr_54592_56691[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (13))){
var inst_54564 = (state_54571[(2)]);
var state_54571__$1 = (function (){var statearr_54594 = state_54571;
(statearr_54594[(9)] = inst_54564);

return statearr_54594;
})();
var statearr_54597_56692 = state_54571__$1;
(statearr_54597_56692[(2)] = null);

(statearr_54597_56692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (6))){
var inst_54531 = (state_54571[(7)]);
var state_54571__$1 = state_54571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54571__$1,(11),inst_54531);
} else {
if((state_val_54572 === (17))){
var inst_54556 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
if(cljs.core.truth_(inst_54556)){
var statearr_54601_56696 = state_54571__$1;
(statearr_54601_56696[(1)] = (19));

} else {
var statearr_54603_56698 = state_54571__$1;
(statearr_54603_56698[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (3))){
var inst_54569 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54571__$1,inst_54569);
} else {
if((state_val_54572 === (12))){
var inst_54542 = (state_54571[(10)]);
var state_54571__$1 = state_54571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54571__$1,(14),inst_54542);
} else {
if((state_val_54572 === (2))){
var state_54571__$1 = state_54571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54571__$1,(4),results);
} else {
if((state_val_54572 === (19))){
var state_54571__$1 = state_54571;
var statearr_54608_56703 = state_54571__$1;
(statearr_54608_56703[(2)] = null);

(statearr_54608_56703[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (11))){
var inst_54542 = (state_54571[(2)]);
var state_54571__$1 = (function (){var statearr_54613 = state_54571;
(statearr_54613[(10)] = inst_54542);

return statearr_54613;
})();
var statearr_54617_56707 = state_54571__$1;
(statearr_54617_56707[(2)] = null);

(statearr_54617_56707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (9))){
var state_54571__$1 = state_54571;
var statearr_54618_56708 = state_54571__$1;
(statearr_54618_56708[(2)] = null);

(statearr_54618_56708[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (5))){
var state_54571__$1 = state_54571;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54620_56709 = state_54571__$1;
(statearr_54620_56709[(1)] = (8));

} else {
var statearr_54622_56710 = state_54571__$1;
(statearr_54622_56710[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (14))){
var inst_54545 = (state_54571[(8)]);
var inst_54549 = (state_54571[(11)]);
var inst_54545__$1 = (state_54571[(2)]);
var inst_54548 = (inst_54545__$1 == null);
var inst_54549__$1 = cljs.core.not(inst_54548);
var state_54571__$1 = (function (){var statearr_54626 = state_54571;
(statearr_54626[(8)] = inst_54545__$1);

(statearr_54626[(11)] = inst_54549__$1);

return statearr_54626;
})();
if(inst_54549__$1){
var statearr_54629_56714 = state_54571__$1;
(statearr_54629_56714[(1)] = (15));

} else {
var statearr_54630_56715 = state_54571__$1;
(statearr_54630_56715[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (16))){
var inst_54549 = (state_54571[(11)]);
var state_54571__$1 = state_54571;
var statearr_54631_56716 = state_54571__$1;
(statearr_54631_56716[(2)] = inst_54549);

(statearr_54631_56716[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (10))){
var inst_54538 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
var statearr_54632_56717 = state_54571__$1;
(statearr_54632_56717[(2)] = inst_54538);

(statearr_54632_56717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (18))){
var inst_54553 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
var statearr_54633_56718 = state_54571__$1;
(statearr_54633_56718[(2)] = inst_54553);

(statearr_54633_56718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (8))){
var inst_54535 = cljs.core.async.close_BANG_.call(null,to);
var state_54571__$1 = state_54571;
var statearr_54634_56722 = state_54571__$1;
(statearr_54634_56722[(2)] = inst_54535);

(statearr_54634_56722[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__,jobs,results,process,async))
;
return ((function (switch__53637__auto__,c__54028__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0 = (function (){
var statearr_54636 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54636[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__);

(statearr_54636[(1)] = (1));

return statearr_54636;
});
var cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1 = (function (state_54571){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54637){if((e54637 instanceof Object)){
var ex__53641__auto__ = e54637;
var statearr_54638_56724 = state_54571;
(statearr_54638_56724[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54637;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56725 = state_54571;
state_54571 = G__56725;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__ = function(state_54571){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1.call(this,state_54571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__53638__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__,jobs,results,process,async))
})();
var state__54030__auto__ = (function (){var statearr_54640 = f__54029__auto__();
(statearr_54640[(6)] = c__54028__auto__);

return statearr_54640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__,jobs,results,process,async))
);

return c__54028__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__54645 = arguments.length;
switch (G__54645) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__54651 = arguments.length;
switch (G__54651) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__54659 = arguments.length;
switch (G__54659) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__54028__auto___56733 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___56733,tc,fc){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___56733,tc,fc){
return (function (state_54687){
var state_val_54688 = (state_54687[(1)]);
if((state_val_54688 === (7))){
var inst_54683 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
var statearr_54689_56737 = state_54687__$1;
(statearr_54689_56737[(2)] = inst_54683);

(statearr_54689_56737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (1))){
var state_54687__$1 = state_54687;
var statearr_54690_56738 = state_54687__$1;
(statearr_54690_56738[(2)] = null);

(statearr_54690_56738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (4))){
var inst_54664 = (state_54687[(7)]);
var inst_54664__$1 = (state_54687[(2)]);
var inst_54665 = (inst_54664__$1 == null);
var state_54687__$1 = (function (){var statearr_54691 = state_54687;
(statearr_54691[(7)] = inst_54664__$1);

return statearr_54691;
})();
if(cljs.core.truth_(inst_54665)){
var statearr_54692_56747 = state_54687__$1;
(statearr_54692_56747[(1)] = (5));

} else {
var statearr_54693_56748 = state_54687__$1;
(statearr_54693_56748[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (13))){
var state_54687__$1 = state_54687;
var statearr_54694_56749 = state_54687__$1;
(statearr_54694_56749[(2)] = null);

(statearr_54694_56749[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (6))){
var inst_54664 = (state_54687[(7)]);
var inst_54670 = p.call(null,inst_54664);
var state_54687__$1 = state_54687;
if(cljs.core.truth_(inst_54670)){
var statearr_54701_56750 = state_54687__$1;
(statearr_54701_56750[(1)] = (9));

} else {
var statearr_54703_56751 = state_54687__$1;
(statearr_54703_56751[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (3))){
var inst_54685 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54687__$1,inst_54685);
} else {
if((state_val_54688 === (12))){
var state_54687__$1 = state_54687;
var statearr_54707_56754 = state_54687__$1;
(statearr_54707_56754[(2)] = null);

(statearr_54707_56754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (2))){
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54687__$1,(4),ch);
} else {
if((state_val_54688 === (11))){
var inst_54664 = (state_54687[(7)]);
var inst_54674 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54687__$1,(8),inst_54674,inst_54664);
} else {
if((state_val_54688 === (9))){
var state_54687__$1 = state_54687;
var statearr_54712_56755 = state_54687__$1;
(statearr_54712_56755[(2)] = tc);

(statearr_54712_56755[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (5))){
var inst_54667 = cljs.core.async.close_BANG_.call(null,tc);
var inst_54668 = cljs.core.async.close_BANG_.call(null,fc);
var state_54687__$1 = (function (){var statearr_54717 = state_54687;
(statearr_54717[(8)] = inst_54667);

return statearr_54717;
})();
var statearr_54718_56757 = state_54687__$1;
(statearr_54718_56757[(2)] = inst_54668);

(statearr_54718_56757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (14))){
var inst_54681 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
var statearr_54720_56758 = state_54687__$1;
(statearr_54720_56758[(2)] = inst_54681);

(statearr_54720_56758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (10))){
var state_54687__$1 = state_54687;
var statearr_54722_56760 = state_54687__$1;
(statearr_54722_56760[(2)] = fc);

(statearr_54722_56760[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (8))){
var inst_54676 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
if(cljs.core.truth_(inst_54676)){
var statearr_54726_56763 = state_54687__$1;
(statearr_54726_56763[(1)] = (12));

} else {
var statearr_54727_56764 = state_54687__$1;
(statearr_54727_56764[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___56733,tc,fc))
;
return ((function (switch__53637__auto__,c__54028__auto___56733,tc,fc){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_54733 = [null,null,null,null,null,null,null,null,null];
(statearr_54733[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_54733[(1)] = (1));

return statearr_54733;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_54687){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54735){if((e54735 instanceof Object)){
var ex__53641__auto__ = e54735;
var statearr_54736_56765 = state_54687;
(statearr_54736_56765[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54735;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56766 = state_54687;
state_54687 = G__56766;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_54687){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_54687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___56733,tc,fc))
})();
var state__54030__auto__ = (function (){var statearr_54737 = f__54029__auto__();
(statearr_54737[(6)] = c__54028__auto___56733);

return statearr_54737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___56733,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__){
return (function (state_54758){
var state_val_54759 = (state_54758[(1)]);
if((state_val_54759 === (7))){
var inst_54754 = (state_54758[(2)]);
var state_54758__$1 = state_54758;
var statearr_54761_56772 = state_54758__$1;
(statearr_54761_56772[(2)] = inst_54754);

(statearr_54761_56772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54759 === (1))){
var inst_54738 = init;
var state_54758__$1 = (function (){var statearr_54763 = state_54758;
(statearr_54763[(7)] = inst_54738);

return statearr_54763;
})();
var statearr_54764_56773 = state_54758__$1;
(statearr_54764_56773[(2)] = null);

(statearr_54764_56773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54759 === (4))){
var inst_54741 = (state_54758[(8)]);
var inst_54741__$1 = (state_54758[(2)]);
var inst_54742 = (inst_54741__$1 == null);
var state_54758__$1 = (function (){var statearr_54765 = state_54758;
(statearr_54765[(8)] = inst_54741__$1);

return statearr_54765;
})();
if(cljs.core.truth_(inst_54742)){
var statearr_54766_56775 = state_54758__$1;
(statearr_54766_56775[(1)] = (5));

} else {
var statearr_54767_56776 = state_54758__$1;
(statearr_54767_56776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54759 === (6))){
var inst_54738 = (state_54758[(7)]);
var inst_54745 = (state_54758[(9)]);
var inst_54741 = (state_54758[(8)]);
var inst_54745__$1 = f.call(null,inst_54738,inst_54741);
var inst_54746 = cljs.core.reduced_QMARK_.call(null,inst_54745__$1);
var state_54758__$1 = (function (){var statearr_54768 = state_54758;
(statearr_54768[(9)] = inst_54745__$1);

return statearr_54768;
})();
if(inst_54746){
var statearr_54769_56783 = state_54758__$1;
(statearr_54769_56783[(1)] = (8));

} else {
var statearr_54770_56784 = state_54758__$1;
(statearr_54770_56784[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54759 === (3))){
var inst_54756 = (state_54758[(2)]);
var state_54758__$1 = state_54758;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54758__$1,inst_54756);
} else {
if((state_val_54759 === (2))){
var state_54758__$1 = state_54758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54758__$1,(4),ch);
} else {
if((state_val_54759 === (9))){
var inst_54745 = (state_54758[(9)]);
var inst_54738 = inst_54745;
var state_54758__$1 = (function (){var statearr_54772 = state_54758;
(statearr_54772[(7)] = inst_54738);

return statearr_54772;
})();
var statearr_54773_56791 = state_54758__$1;
(statearr_54773_56791[(2)] = null);

(statearr_54773_56791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54759 === (5))){
var inst_54738 = (state_54758[(7)]);
var state_54758__$1 = state_54758;
var statearr_54774_56798 = state_54758__$1;
(statearr_54774_56798[(2)] = inst_54738);

(statearr_54774_56798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54759 === (10))){
var inst_54752 = (state_54758[(2)]);
var state_54758__$1 = state_54758;
var statearr_54775_56807 = state_54758__$1;
(statearr_54775_56807[(2)] = inst_54752);

(statearr_54775_56807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54759 === (8))){
var inst_54745 = (state_54758[(9)]);
var inst_54748 = cljs.core.deref.call(null,inst_54745);
var state_54758__$1 = state_54758;
var statearr_54780_56809 = state_54758__$1;
(statearr_54780_56809[(2)] = inst_54748);

(statearr_54780_56809[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__))
;
return ((function (switch__53637__auto__,c__54028__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__53638__auto__ = null;
var cljs$core$async$reduce_$_state_machine__53638__auto____0 = (function (){
var statearr_54781 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54781[(0)] = cljs$core$async$reduce_$_state_machine__53638__auto__);

(statearr_54781[(1)] = (1));

return statearr_54781;
});
var cljs$core$async$reduce_$_state_machine__53638__auto____1 = (function (state_54758){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54758);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54782){if((e54782 instanceof Object)){
var ex__53641__auto__ = e54782;
var statearr_54784_56819 = state_54758;
(statearr_54784_56819[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54758);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54782;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56820 = state_54758;
state_54758 = G__56820;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__53638__auto__ = function(state_54758){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__53638__auto____1.call(this,state_54758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__53638__auto____0;
cljs$core$async$reduce_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__53638__auto____1;
return cljs$core$async$reduce_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__))
})();
var state__54030__auto__ = (function (){var statearr_54792 = f__54029__auto__();
(statearr_54792[(6)] = c__54028__auto__);

return statearr_54792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__))
);

return c__54028__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__,f__$1){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__,f__$1){
return (function (state_54809){
var state_val_54810 = (state_54809[(1)]);
if((state_val_54810 === (1))){
var inst_54803 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_54809__$1 = state_54809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54809__$1,(2),inst_54803);
} else {
if((state_val_54810 === (2))){
var inst_54805 = (state_54809[(2)]);
var inst_54806 = f__$1.call(null,inst_54805);
var state_54809__$1 = state_54809;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54809__$1,inst_54806);
} else {
return null;
}
}
});})(c__54028__auto__,f__$1))
;
return ((function (switch__53637__auto__,c__54028__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__53638__auto__ = null;
var cljs$core$async$transduce_$_state_machine__53638__auto____0 = (function (){
var statearr_54815 = [null,null,null,null,null,null,null];
(statearr_54815[(0)] = cljs$core$async$transduce_$_state_machine__53638__auto__);

(statearr_54815[(1)] = (1));

return statearr_54815;
});
var cljs$core$async$transduce_$_state_machine__53638__auto____1 = (function (state_54809){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54817){if((e54817 instanceof Object)){
var ex__53641__auto__ = e54817;
var statearr_54818_56835 = state_54809;
(statearr_54818_56835[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54809);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54817;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56838 = state_54809;
state_54809 = G__56838;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__53638__auto__ = function(state_54809){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__53638__auto____1.call(this,state_54809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__53638__auto____0;
cljs$core$async$transduce_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__53638__auto____1;
return cljs$core$async$transduce_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__,f__$1))
})();
var state__54030__auto__ = (function (){var statearr_54826 = f__54029__auto__();
(statearr_54826[(6)] = c__54028__auto__);

return statearr_54826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__,f__$1))
);

return c__54028__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__54833 = arguments.length;
switch (G__54833) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__){
return (function (state_54868){
var state_val_54869 = (state_54868[(1)]);
if((state_val_54869 === (7))){
var inst_54850 = (state_54868[(2)]);
var state_54868__$1 = state_54868;
var statearr_54880_56854 = state_54868__$1;
(statearr_54880_56854[(2)] = inst_54850);

(statearr_54880_56854[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (1))){
var inst_54839 = cljs.core.seq.call(null,coll);
var inst_54840 = inst_54839;
var state_54868__$1 = (function (){var statearr_54881 = state_54868;
(statearr_54881[(7)] = inst_54840);

return statearr_54881;
})();
var statearr_54882_56861 = state_54868__$1;
(statearr_54882_56861[(2)] = null);

(statearr_54882_56861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (4))){
var inst_54840 = (state_54868[(7)]);
var inst_54848 = cljs.core.first.call(null,inst_54840);
var state_54868__$1 = state_54868;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54868__$1,(7),ch,inst_54848);
} else {
if((state_val_54869 === (13))){
var inst_54862 = (state_54868[(2)]);
var state_54868__$1 = state_54868;
var statearr_54887_56867 = state_54868__$1;
(statearr_54887_56867[(2)] = inst_54862);

(statearr_54887_56867[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (6))){
var inst_54853 = (state_54868[(2)]);
var state_54868__$1 = state_54868;
if(cljs.core.truth_(inst_54853)){
var statearr_54892_56868 = state_54868__$1;
(statearr_54892_56868[(1)] = (8));

} else {
var statearr_54893_56869 = state_54868__$1;
(statearr_54893_56869[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (3))){
var inst_54866 = (state_54868[(2)]);
var state_54868__$1 = state_54868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54868__$1,inst_54866);
} else {
if((state_val_54869 === (12))){
var state_54868__$1 = state_54868;
var statearr_54896_56870 = state_54868__$1;
(statearr_54896_56870[(2)] = null);

(statearr_54896_56870[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (2))){
var inst_54840 = (state_54868[(7)]);
var state_54868__$1 = state_54868;
if(cljs.core.truth_(inst_54840)){
var statearr_54905_56877 = state_54868__$1;
(statearr_54905_56877[(1)] = (4));

} else {
var statearr_54906_56878 = state_54868__$1;
(statearr_54906_56878[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (11))){
var inst_54859 = cljs.core.async.close_BANG_.call(null,ch);
var state_54868__$1 = state_54868;
var statearr_54907_56879 = state_54868__$1;
(statearr_54907_56879[(2)] = inst_54859);

(statearr_54907_56879[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (9))){
var state_54868__$1 = state_54868;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54908_56880 = state_54868__$1;
(statearr_54908_56880[(1)] = (11));

} else {
var statearr_54912_56881 = state_54868__$1;
(statearr_54912_56881[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (5))){
var inst_54840 = (state_54868[(7)]);
var state_54868__$1 = state_54868;
var statearr_54914_56882 = state_54868__$1;
(statearr_54914_56882[(2)] = inst_54840);

(statearr_54914_56882[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (10))){
var inst_54864 = (state_54868[(2)]);
var state_54868__$1 = state_54868;
var statearr_54919_56883 = state_54868__$1;
(statearr_54919_56883[(2)] = inst_54864);

(statearr_54919_56883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54869 === (8))){
var inst_54840 = (state_54868[(7)]);
var inst_54855 = cljs.core.next.call(null,inst_54840);
var inst_54840__$1 = inst_54855;
var state_54868__$1 = (function (){var statearr_54921 = state_54868;
(statearr_54921[(7)] = inst_54840__$1);

return statearr_54921;
})();
var statearr_54922_56884 = state_54868__$1;
(statearr_54922_56884[(2)] = null);

(statearr_54922_56884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__))
;
return ((function (switch__53637__auto__,c__54028__auto__){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_54926 = [null,null,null,null,null,null,null,null];
(statearr_54926[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_54926[(1)] = (1));

return statearr_54926;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_54868){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_54868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e54927){if((e54927 instanceof Object)){
var ex__53641__auto__ = e54927;
var statearr_54928_56885 = state_54868;
(statearr_54928_56885[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54868);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56886 = state_54868;
state_54868 = G__56886;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_54868){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_54868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__))
})();
var state__54030__auto__ = (function (){var statearr_54929 = f__54029__auto__();
(statearr_54929[(6)] = c__54028__auto__);

return statearr_54929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__))
);

return c__54028__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54966 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54966 = (function (ch,cs,meta54967){
this.ch = ch;
this.cs = cs;
this.meta54967 = meta54967;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_54968,meta54967__$1){
var self__ = this;
var _54968__$1 = this;
return (new cljs.core.async.t_cljs$core$async54966(self__.ch,self__.cs,meta54967__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_54968){
var self__ = this;
var _54968__$1 = this;
return self__.meta54967;
});})(cs))
;

cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async54966.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async54966.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta54967","meta54967",-1944149462,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async54966.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54966.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54966";

cljs.core.async.t_cljs$core$async54966.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async54966");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54966.
 */
cljs.core.async.__GT_t_cljs$core$async54966 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async54966(ch__$1,cs__$1,meta54967){
return (new cljs.core.async.t_cljs$core$async54966(ch__$1,cs__$1,meta54967));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async54966(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__54028__auto___56919 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___56919,cs,m,dchan,dctr,done){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___56919,cs,m,dchan,dctr,done){
return (function (state_55122){
var state_val_55123 = (state_55122[(1)]);
if((state_val_55123 === (7))){
var inst_55117 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55124_56925 = state_55122__$1;
(statearr_55124_56925[(2)] = inst_55117);

(statearr_55124_56925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (20))){
var inst_55015 = (state_55122[(7)]);
var inst_55029 = cljs.core.first.call(null,inst_55015);
var inst_55031 = cljs.core.nth.call(null,inst_55029,(0),null);
var inst_55032 = cljs.core.nth.call(null,inst_55029,(1),null);
var state_55122__$1 = (function (){var statearr_55125 = state_55122;
(statearr_55125[(8)] = inst_55031);

return statearr_55125;
})();
if(cljs.core.truth_(inst_55032)){
var statearr_55126_56928 = state_55122__$1;
(statearr_55126_56928[(1)] = (22));

} else {
var statearr_55127_56929 = state_55122__$1;
(statearr_55127_56929[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (27))){
var inst_54979 = (state_55122[(9)]);
var inst_55069 = (state_55122[(10)]);
var inst_55061 = (state_55122[(11)]);
var inst_55063 = (state_55122[(12)]);
var inst_55069__$1 = cljs.core._nth(inst_55061,inst_55063);
var inst_55070 = cljs.core.async.put_BANG_.call(null,inst_55069__$1,inst_54979,done);
var state_55122__$1 = (function (){var statearr_55129 = state_55122;
(statearr_55129[(10)] = inst_55069__$1);

return statearr_55129;
})();
if(cljs.core.truth_(inst_55070)){
var statearr_55130_56934 = state_55122__$1;
(statearr_55130_56934[(1)] = (30));

} else {
var statearr_55132_56935 = state_55122__$1;
(statearr_55132_56935[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (1))){
var state_55122__$1 = state_55122;
var statearr_55133_56936 = state_55122__$1;
(statearr_55133_56936[(2)] = null);

(statearr_55133_56936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (24))){
var inst_55015 = (state_55122[(7)]);
var inst_55037 = (state_55122[(2)]);
var inst_55038 = cljs.core.next.call(null,inst_55015);
var inst_54991 = inst_55038;
var inst_54992 = null;
var inst_54993 = (0);
var inst_54994 = (0);
var state_55122__$1 = (function (){var statearr_55137 = state_55122;
(statearr_55137[(13)] = inst_54991);

(statearr_55137[(14)] = inst_55037);

(statearr_55137[(15)] = inst_54994);

(statearr_55137[(16)] = inst_54993);

(statearr_55137[(17)] = inst_54992);

return statearr_55137;
})();
var statearr_55138_56942 = state_55122__$1;
(statearr_55138_56942[(2)] = null);

(statearr_55138_56942[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (39))){
var state_55122__$1 = state_55122;
var statearr_55146_56943 = state_55122__$1;
(statearr_55146_56943[(2)] = null);

(statearr_55146_56943[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (4))){
var inst_54979 = (state_55122[(9)]);
var inst_54979__$1 = (state_55122[(2)]);
var inst_54980 = (inst_54979__$1 == null);
var state_55122__$1 = (function (){var statearr_55147 = state_55122;
(statearr_55147[(9)] = inst_54979__$1);

return statearr_55147;
})();
if(cljs.core.truth_(inst_54980)){
var statearr_55148_56949 = state_55122__$1;
(statearr_55148_56949[(1)] = (5));

} else {
var statearr_55149_56950 = state_55122__$1;
(statearr_55149_56950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (15))){
var inst_54991 = (state_55122[(13)]);
var inst_54994 = (state_55122[(15)]);
var inst_54993 = (state_55122[(16)]);
var inst_54992 = (state_55122[(17)]);
var inst_55009 = (state_55122[(2)]);
var inst_55010 = (inst_54994 + (1));
var tmp55143 = inst_54991;
var tmp55144 = inst_54993;
var tmp55145 = inst_54992;
var inst_54991__$1 = tmp55143;
var inst_54992__$1 = tmp55145;
var inst_54993__$1 = tmp55144;
var inst_54994__$1 = inst_55010;
var state_55122__$1 = (function (){var statearr_55156 = state_55122;
(statearr_55156[(13)] = inst_54991__$1);

(statearr_55156[(18)] = inst_55009);

(statearr_55156[(15)] = inst_54994__$1);

(statearr_55156[(16)] = inst_54993__$1);

(statearr_55156[(17)] = inst_54992__$1);

return statearr_55156;
})();
var statearr_55159_56955 = state_55122__$1;
(statearr_55159_56955[(2)] = null);

(statearr_55159_56955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (21))){
var inst_55041 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55165_56959 = state_55122__$1;
(statearr_55165_56959[(2)] = inst_55041);

(statearr_55165_56959[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (31))){
var inst_55069 = (state_55122[(10)]);
var inst_55073 = done(null);
var inst_55074 = cljs.core.async.untap_STAR_(m,inst_55069);
var state_55122__$1 = (function (){var statearr_55167 = state_55122;
(statearr_55167[(19)] = inst_55073);

return statearr_55167;
})();
var statearr_55168_56962 = state_55122__$1;
(statearr_55168_56962[(2)] = inst_55074);

(statearr_55168_56962[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (32))){
var inst_55060 = (state_55122[(20)]);
var inst_55061 = (state_55122[(11)]);
var inst_55063 = (state_55122[(12)]);
var inst_55062 = (state_55122[(21)]);
var inst_55076 = (state_55122[(2)]);
var inst_55077 = (inst_55063 + (1));
var tmp55161 = inst_55060;
var tmp55162 = inst_55061;
var tmp55163 = inst_55062;
var inst_55060__$1 = tmp55161;
var inst_55061__$1 = tmp55162;
var inst_55062__$1 = tmp55163;
var inst_55063__$1 = inst_55077;
var state_55122__$1 = (function (){var statearr_55183 = state_55122;
(statearr_55183[(20)] = inst_55060__$1);

(statearr_55183[(22)] = inst_55076);

(statearr_55183[(11)] = inst_55061__$1);

(statearr_55183[(12)] = inst_55063__$1);

(statearr_55183[(21)] = inst_55062__$1);

return statearr_55183;
})();
var statearr_55191_56966 = state_55122__$1;
(statearr_55191_56966[(2)] = null);

(statearr_55191_56966[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (40))){
var inst_55089 = (state_55122[(23)]);
var inst_55093 = done(null);
var inst_55094 = cljs.core.async.untap_STAR_(m,inst_55089);
var state_55122__$1 = (function (){var statearr_55198 = state_55122;
(statearr_55198[(24)] = inst_55093);

return statearr_55198;
})();
var statearr_55199_56968 = state_55122__$1;
(statearr_55199_56968[(2)] = inst_55094);

(statearr_55199_56968[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (33))){
var inst_55080 = (state_55122[(25)]);
var inst_55082 = cljs.core.chunked_seq_QMARK_.call(null,inst_55080);
var state_55122__$1 = state_55122;
if(inst_55082){
var statearr_55201_56970 = state_55122__$1;
(statearr_55201_56970[(1)] = (36));

} else {
var statearr_55203_56971 = state_55122__$1;
(statearr_55203_56971[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (13))){
var inst_55003 = (state_55122[(26)]);
var inst_55006 = cljs.core.async.close_BANG_.call(null,inst_55003);
var state_55122__$1 = state_55122;
var statearr_55211_56974 = state_55122__$1;
(statearr_55211_56974[(2)] = inst_55006);

(statearr_55211_56974[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (22))){
var inst_55031 = (state_55122[(8)]);
var inst_55034 = cljs.core.async.close_BANG_.call(null,inst_55031);
var state_55122__$1 = state_55122;
var statearr_55213_56975 = state_55122__$1;
(statearr_55213_56975[(2)] = inst_55034);

(statearr_55213_56975[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (36))){
var inst_55080 = (state_55122[(25)]);
var inst_55084 = cljs.core.chunk_first.call(null,inst_55080);
var inst_55085 = cljs.core.chunk_rest.call(null,inst_55080);
var inst_55086 = cljs.core.count.call(null,inst_55084);
var inst_55060 = inst_55085;
var inst_55061 = inst_55084;
var inst_55062 = inst_55086;
var inst_55063 = (0);
var state_55122__$1 = (function (){var statearr_55216 = state_55122;
(statearr_55216[(20)] = inst_55060);

(statearr_55216[(11)] = inst_55061);

(statearr_55216[(12)] = inst_55063);

(statearr_55216[(21)] = inst_55062);

return statearr_55216;
})();
var statearr_55220_56982 = state_55122__$1;
(statearr_55220_56982[(2)] = null);

(statearr_55220_56982[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (41))){
var inst_55080 = (state_55122[(25)]);
var inst_55096 = (state_55122[(2)]);
var inst_55097 = cljs.core.next.call(null,inst_55080);
var inst_55060 = inst_55097;
var inst_55061 = null;
var inst_55062 = (0);
var inst_55063 = (0);
var state_55122__$1 = (function (){var statearr_55222 = state_55122;
(statearr_55222[(27)] = inst_55096);

(statearr_55222[(20)] = inst_55060);

(statearr_55222[(11)] = inst_55061);

(statearr_55222[(12)] = inst_55063);

(statearr_55222[(21)] = inst_55062);

return statearr_55222;
})();
var statearr_55225_56985 = state_55122__$1;
(statearr_55225_56985[(2)] = null);

(statearr_55225_56985[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (43))){
var state_55122__$1 = state_55122;
var statearr_55226_56986 = state_55122__$1;
(statearr_55226_56986[(2)] = null);

(statearr_55226_56986[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (29))){
var inst_55105 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55229_56987 = state_55122__$1;
(statearr_55229_56987[(2)] = inst_55105);

(statearr_55229_56987[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (44))){
var inst_55114 = (state_55122[(2)]);
var state_55122__$1 = (function (){var statearr_55232 = state_55122;
(statearr_55232[(28)] = inst_55114);

return statearr_55232;
})();
var statearr_55233_56989 = state_55122__$1;
(statearr_55233_56989[(2)] = null);

(statearr_55233_56989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (6))){
var inst_55051 = (state_55122[(29)]);
var inst_55050 = cljs.core.deref.call(null,cs);
var inst_55051__$1 = cljs.core.keys.call(null,inst_55050);
var inst_55052 = cljs.core.count.call(null,inst_55051__$1);
var inst_55053 = cljs.core.reset_BANG_.call(null,dctr,inst_55052);
var inst_55059 = cljs.core.seq.call(null,inst_55051__$1);
var inst_55060 = inst_55059;
var inst_55061 = null;
var inst_55062 = (0);
var inst_55063 = (0);
var state_55122__$1 = (function (){var statearr_55236 = state_55122;
(statearr_55236[(20)] = inst_55060);

(statearr_55236[(29)] = inst_55051__$1);

(statearr_55236[(30)] = inst_55053);

(statearr_55236[(11)] = inst_55061);

(statearr_55236[(12)] = inst_55063);

(statearr_55236[(21)] = inst_55062);

return statearr_55236;
})();
var statearr_55238_56991 = state_55122__$1;
(statearr_55238_56991[(2)] = null);

(statearr_55238_56991[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (28))){
var inst_55060 = (state_55122[(20)]);
var inst_55080 = (state_55122[(25)]);
var inst_55080__$1 = cljs.core.seq.call(null,inst_55060);
var state_55122__$1 = (function (){var statearr_55242 = state_55122;
(statearr_55242[(25)] = inst_55080__$1);

return statearr_55242;
})();
if(inst_55080__$1){
var statearr_55243_56997 = state_55122__$1;
(statearr_55243_56997[(1)] = (33));

} else {
var statearr_55248_57001 = state_55122__$1;
(statearr_55248_57001[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (25))){
var inst_55063 = (state_55122[(12)]);
var inst_55062 = (state_55122[(21)]);
var inst_55066 = (inst_55063 < inst_55062);
var inst_55067 = inst_55066;
var state_55122__$1 = state_55122;
if(cljs.core.truth_(inst_55067)){
var statearr_55256_57002 = state_55122__$1;
(statearr_55256_57002[(1)] = (27));

} else {
var statearr_55258_57003 = state_55122__$1;
(statearr_55258_57003[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (34))){
var state_55122__$1 = state_55122;
var statearr_55267_57004 = state_55122__$1;
(statearr_55267_57004[(2)] = null);

(statearr_55267_57004[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (17))){
var state_55122__$1 = state_55122;
var statearr_55274_57008 = state_55122__$1;
(statearr_55274_57008[(2)] = null);

(statearr_55274_57008[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (3))){
var inst_55119 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55122__$1,inst_55119);
} else {
if((state_val_55123 === (12))){
var inst_55046 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55277_57013 = state_55122__$1;
(statearr_55277_57013[(2)] = inst_55046);

(statearr_55277_57013[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (2))){
var state_55122__$1 = state_55122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55122__$1,(4),ch);
} else {
if((state_val_55123 === (23))){
var state_55122__$1 = state_55122;
var statearr_55299_57014 = state_55122__$1;
(statearr_55299_57014[(2)] = null);

(statearr_55299_57014[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (35))){
var inst_55103 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55320_57018 = state_55122__$1;
(statearr_55320_57018[(2)] = inst_55103);

(statearr_55320_57018[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (19))){
var inst_55015 = (state_55122[(7)]);
var inst_55019 = cljs.core.chunk_first.call(null,inst_55015);
var inst_55020 = cljs.core.chunk_rest.call(null,inst_55015);
var inst_55021 = cljs.core.count.call(null,inst_55019);
var inst_54991 = inst_55020;
var inst_54992 = inst_55019;
var inst_54993 = inst_55021;
var inst_54994 = (0);
var state_55122__$1 = (function (){var statearr_55338 = state_55122;
(statearr_55338[(13)] = inst_54991);

(statearr_55338[(15)] = inst_54994);

(statearr_55338[(16)] = inst_54993);

(statearr_55338[(17)] = inst_54992);

return statearr_55338;
})();
var statearr_55342_57030 = state_55122__$1;
(statearr_55342_57030[(2)] = null);

(statearr_55342_57030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (11))){
var inst_54991 = (state_55122[(13)]);
var inst_55015 = (state_55122[(7)]);
var inst_55015__$1 = cljs.core.seq.call(null,inst_54991);
var state_55122__$1 = (function (){var statearr_55343 = state_55122;
(statearr_55343[(7)] = inst_55015__$1);

return statearr_55343;
})();
if(inst_55015__$1){
var statearr_55344_57032 = state_55122__$1;
(statearr_55344_57032[(1)] = (16));

} else {
var statearr_55346_57033 = state_55122__$1;
(statearr_55346_57033[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (9))){
var inst_55048 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55348_57034 = state_55122__$1;
(statearr_55348_57034[(2)] = inst_55048);

(statearr_55348_57034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (5))){
var inst_54988 = cljs.core.deref.call(null,cs);
var inst_54989 = cljs.core.seq.call(null,inst_54988);
var inst_54991 = inst_54989;
var inst_54992 = null;
var inst_54993 = (0);
var inst_54994 = (0);
var state_55122__$1 = (function (){var statearr_55351 = state_55122;
(statearr_55351[(13)] = inst_54991);

(statearr_55351[(15)] = inst_54994);

(statearr_55351[(16)] = inst_54993);

(statearr_55351[(17)] = inst_54992);

return statearr_55351;
})();
var statearr_55352_57038 = state_55122__$1;
(statearr_55352_57038[(2)] = null);

(statearr_55352_57038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (14))){
var state_55122__$1 = state_55122;
var statearr_55354_57042 = state_55122__$1;
(statearr_55354_57042[(2)] = null);

(statearr_55354_57042[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (45))){
var inst_55111 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55355_57045 = state_55122__$1;
(statearr_55355_57045[(2)] = inst_55111);

(statearr_55355_57045[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (26))){
var inst_55051 = (state_55122[(29)]);
var inst_55107 = (state_55122[(2)]);
var inst_55108 = cljs.core.seq.call(null,inst_55051);
var state_55122__$1 = (function (){var statearr_55356 = state_55122;
(statearr_55356[(31)] = inst_55107);

return statearr_55356;
})();
if(inst_55108){
var statearr_55357_57049 = state_55122__$1;
(statearr_55357_57049[(1)] = (42));

} else {
var statearr_55358_57050 = state_55122__$1;
(statearr_55358_57050[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (16))){
var inst_55015 = (state_55122[(7)]);
var inst_55017 = cljs.core.chunked_seq_QMARK_.call(null,inst_55015);
var state_55122__$1 = state_55122;
if(inst_55017){
var statearr_55364_57051 = state_55122__$1;
(statearr_55364_57051[(1)] = (19));

} else {
var statearr_55365_57052 = state_55122__$1;
(statearr_55365_57052[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (38))){
var inst_55100 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55368_57054 = state_55122__$1;
(statearr_55368_57054[(2)] = inst_55100);

(statearr_55368_57054[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (30))){
var state_55122__$1 = state_55122;
var statearr_55371_57056 = state_55122__$1;
(statearr_55371_57056[(2)] = null);

(statearr_55371_57056[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (10))){
var inst_54994 = (state_55122[(15)]);
var inst_54992 = (state_55122[(17)]);
var inst_55002 = cljs.core._nth(inst_54992,inst_54994);
var inst_55003 = cljs.core.nth.call(null,inst_55002,(0),null);
var inst_55004 = cljs.core.nth.call(null,inst_55002,(1),null);
var state_55122__$1 = (function (){var statearr_55373 = state_55122;
(statearr_55373[(26)] = inst_55003);

return statearr_55373;
})();
if(cljs.core.truth_(inst_55004)){
var statearr_55378_57058 = state_55122__$1;
(statearr_55378_57058[(1)] = (13));

} else {
var statearr_55379_57059 = state_55122__$1;
(statearr_55379_57059[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (18))){
var inst_55044 = (state_55122[(2)]);
var state_55122__$1 = state_55122;
var statearr_55384_57062 = state_55122__$1;
(statearr_55384_57062[(2)] = inst_55044);

(statearr_55384_57062[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (42))){
var state_55122__$1 = state_55122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55122__$1,(45),dchan);
} else {
if((state_val_55123 === (37))){
var inst_54979 = (state_55122[(9)]);
var inst_55080 = (state_55122[(25)]);
var inst_55089 = (state_55122[(23)]);
var inst_55089__$1 = cljs.core.first.call(null,inst_55080);
var inst_55090 = cljs.core.async.put_BANG_.call(null,inst_55089__$1,inst_54979,done);
var state_55122__$1 = (function (){var statearr_55389 = state_55122;
(statearr_55389[(23)] = inst_55089__$1);

return statearr_55389;
})();
if(cljs.core.truth_(inst_55090)){
var statearr_55390_57064 = state_55122__$1;
(statearr_55390_57064[(1)] = (39));

} else {
var statearr_55391_57065 = state_55122__$1;
(statearr_55391_57065[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55123 === (8))){
var inst_54994 = (state_55122[(15)]);
var inst_54993 = (state_55122[(16)]);
var inst_54996 = (inst_54994 < inst_54993);
var inst_54997 = inst_54996;
var state_55122__$1 = state_55122;
if(cljs.core.truth_(inst_54997)){
var statearr_55393_57067 = state_55122__$1;
(statearr_55393_57067[(1)] = (10));

} else {
var statearr_55394_57068 = state_55122__$1;
(statearr_55394_57068[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___56919,cs,m,dchan,dctr,done))
;
return ((function (switch__53637__auto__,c__54028__auto___56919,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__53638__auto__ = null;
var cljs$core$async$mult_$_state_machine__53638__auto____0 = (function (){
var statearr_55398 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55398[(0)] = cljs$core$async$mult_$_state_machine__53638__auto__);

(statearr_55398[(1)] = (1));

return statearr_55398;
});
var cljs$core$async$mult_$_state_machine__53638__auto____1 = (function (state_55122){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_55122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e55400){if((e55400 instanceof Object)){
var ex__53641__auto__ = e55400;
var statearr_55403_57075 = state_55122;
(statearr_55403_57075[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55122);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55400;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57076 = state_55122;
state_55122 = G__57076;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__53638__auto__ = function(state_55122){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__53638__auto____1.call(this,state_55122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__53638__auto____0;
cljs$core$async$mult_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__53638__auto____1;
return cljs$core$async$mult_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___56919,cs,m,dchan,dctr,done))
})();
var state__54030__auto__ = (function (){var statearr_55409 = f__54029__auto__();
(statearr_55409[(6)] = c__54028__auto___56919);

return statearr_55409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___56919,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__55421 = arguments.length;
switch (G__55421) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___57102 = arguments.length;
var i__4731__auto___57103 = (0);
while(true){
if((i__4731__auto___57103 < len__4730__auto___57102)){
args__4736__auto__.push((arguments[i__4731__auto___57103]));

var G__57105 = (i__4731__auto___57103 + (1));
i__4731__auto___57103 = G__57105;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__55465){
var map__55466 = p__55465;
var map__55466__$1 = (((((!((map__55466 == null))))?(((((map__55466.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55466.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55466):map__55466);
var opts = map__55466__$1;
var statearr_55470_57109 = state;
(statearr_55470_57109[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts.call(null,((function (map__55466,map__55466__$1,opts){
return (function (val){
var statearr_55472_57110 = state;
(statearr_55472_57110[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__55466,map__55466__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_55473_57114 = state;
(statearr_55473_57114[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq55459){
var G__55460 = cljs.core.first.call(null,seq55459);
var seq55459__$1 = cljs.core.next.call(null,seq55459);
var G__55461 = cljs.core.first.call(null,seq55459__$1);
var seq55459__$2 = cljs.core.next.call(null,seq55459__$1);
var G__55462 = cljs.core.first.call(null,seq55459__$2);
var seq55459__$3 = cljs.core.next.call(null,seq55459__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55460,G__55461,G__55462,seq55459__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55479 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55479 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta55480){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta55480 = meta55480;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_55481,meta55480__$1){
var self__ = this;
var _55481__$1 = this;
return (new cljs.core.async.t_cljs$core$async55479(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta55480__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_55481){
var self__ = this;
var _55481__$1 = this;
return self__.meta55480;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta55480","meta55480",2015836269,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55479.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55479.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55479";

cljs.core.async.t_cljs$core$async55479.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async55479");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55479.
 */
cljs.core.async.__GT_t_cljs$core$async55479 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async55479(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta55480){
return (new cljs.core.async.t_cljs$core$async55479(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta55480));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async55479(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__54028__auto___57143 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57143,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57143,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_55593){
var state_val_55594 = (state_55593[(1)]);
if((state_val_55594 === (7))){
var inst_55507 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
var statearr_55596_57145 = state_55593__$1;
(statearr_55596_57145[(2)] = inst_55507);

(statearr_55596_57145[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (20))){
var inst_55520 = (state_55593[(7)]);
var state_55593__$1 = state_55593;
var statearr_55597_57146 = state_55593__$1;
(statearr_55597_57146[(2)] = inst_55520);

(statearr_55597_57146[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (27))){
var state_55593__$1 = state_55593;
var statearr_55598_57147 = state_55593__$1;
(statearr_55598_57147[(2)] = null);

(statearr_55598_57147[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (1))){
var inst_55494 = (state_55593[(8)]);
var inst_55494__$1 = calc_state();
var inst_55496 = (inst_55494__$1 == null);
var inst_55497 = cljs.core.not(inst_55496);
var state_55593__$1 = (function (){var statearr_55600 = state_55593;
(statearr_55600[(8)] = inst_55494__$1);

return statearr_55600;
})();
if(inst_55497){
var statearr_55601_57148 = state_55593__$1;
(statearr_55601_57148[(1)] = (2));

} else {
var statearr_55602_57151 = state_55593__$1;
(statearr_55602_57151[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (24))){
var inst_55544 = (state_55593[(9)]);
var inst_55553 = (state_55593[(10)]);
var inst_55567 = (state_55593[(11)]);
var inst_55567__$1 = inst_55544.call(null,inst_55553);
var state_55593__$1 = (function (){var statearr_55603 = state_55593;
(statearr_55603[(11)] = inst_55567__$1);

return statearr_55603;
})();
if(cljs.core.truth_(inst_55567__$1)){
var statearr_55604_57154 = state_55593__$1;
(statearr_55604_57154[(1)] = (29));

} else {
var statearr_55607_57155 = state_55593__$1;
(statearr_55607_57155[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (4))){
var inst_55510 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
if(cljs.core.truth_(inst_55510)){
var statearr_55608_57157 = state_55593__$1;
(statearr_55608_57157[(1)] = (8));

} else {
var statearr_55609_57158 = state_55593__$1;
(statearr_55609_57158[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (15))){
var inst_55538 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
if(cljs.core.truth_(inst_55538)){
var statearr_55610_57160 = state_55593__$1;
(statearr_55610_57160[(1)] = (19));

} else {
var statearr_55613_57161 = state_55593__$1;
(statearr_55613_57161[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (21))){
var inst_55543 = (state_55593[(12)]);
var inst_55543__$1 = (state_55593[(2)]);
var inst_55544 = cljs.core.get.call(null,inst_55543__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_55545 = cljs.core.get.call(null,inst_55543__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_55546 = cljs.core.get.call(null,inst_55543__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_55593__$1 = (function (){var statearr_55614 = state_55593;
(statearr_55614[(13)] = inst_55545);

(statearr_55614[(9)] = inst_55544);

(statearr_55614[(12)] = inst_55543__$1);

return statearr_55614;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_55593__$1,(22),inst_55546);
} else {
if((state_val_55594 === (31))){
var inst_55575 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
if(cljs.core.truth_(inst_55575)){
var statearr_55615_57165 = state_55593__$1;
(statearr_55615_57165[(1)] = (32));

} else {
var statearr_55616_57166 = state_55593__$1;
(statearr_55616_57166[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (32))){
var inst_55552 = (state_55593[(14)]);
var state_55593__$1 = state_55593;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55593__$1,(35),out,inst_55552);
} else {
if((state_val_55594 === (33))){
var inst_55543 = (state_55593[(12)]);
var inst_55520 = inst_55543;
var state_55593__$1 = (function (){var statearr_55617 = state_55593;
(statearr_55617[(7)] = inst_55520);

return statearr_55617;
})();
var statearr_55618_57167 = state_55593__$1;
(statearr_55618_57167[(2)] = null);

(statearr_55618_57167[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (13))){
var inst_55520 = (state_55593[(7)]);
var inst_55527 = inst_55520.cljs$lang$protocol_mask$partition0$;
var inst_55528 = (inst_55527 & (64));
var inst_55529 = inst_55520.cljs$core$ISeq$;
var inst_55530 = (cljs.core.PROTOCOL_SENTINEL === inst_55529);
var inst_55531 = ((inst_55528) || (inst_55530));
var state_55593__$1 = state_55593;
if(cljs.core.truth_(inst_55531)){
var statearr_55619_57168 = state_55593__$1;
(statearr_55619_57168[(1)] = (16));

} else {
var statearr_55620_57169 = state_55593__$1;
(statearr_55620_57169[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (22))){
var inst_55552 = (state_55593[(14)]);
var inst_55553 = (state_55593[(10)]);
var inst_55551 = (state_55593[(2)]);
var inst_55552__$1 = cljs.core.nth.call(null,inst_55551,(0),null);
var inst_55553__$1 = cljs.core.nth.call(null,inst_55551,(1),null);
var inst_55554 = (inst_55552__$1 == null);
var inst_55555 = cljs.core._EQ_.call(null,inst_55553__$1,change);
var inst_55556 = ((inst_55554) || (inst_55555));
var state_55593__$1 = (function (){var statearr_55621 = state_55593;
(statearr_55621[(14)] = inst_55552__$1);

(statearr_55621[(10)] = inst_55553__$1);

return statearr_55621;
})();
if(cljs.core.truth_(inst_55556)){
var statearr_55622_57173 = state_55593__$1;
(statearr_55622_57173[(1)] = (23));

} else {
var statearr_55623_57174 = state_55593__$1;
(statearr_55623_57174[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (36))){
var inst_55543 = (state_55593[(12)]);
var inst_55520 = inst_55543;
var state_55593__$1 = (function (){var statearr_55624 = state_55593;
(statearr_55624[(7)] = inst_55520);

return statearr_55624;
})();
var statearr_55626_57177 = state_55593__$1;
(statearr_55626_57177[(2)] = null);

(statearr_55626_57177[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (29))){
var inst_55567 = (state_55593[(11)]);
var state_55593__$1 = state_55593;
var statearr_55627_57179 = state_55593__$1;
(statearr_55627_57179[(2)] = inst_55567);

(statearr_55627_57179[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (6))){
var state_55593__$1 = state_55593;
var statearr_55628_57181 = state_55593__$1;
(statearr_55628_57181[(2)] = false);

(statearr_55628_57181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (28))){
var inst_55563 = (state_55593[(2)]);
var inst_55564 = calc_state();
var inst_55520 = inst_55564;
var state_55593__$1 = (function (){var statearr_55629 = state_55593;
(statearr_55629[(15)] = inst_55563);

(statearr_55629[(7)] = inst_55520);

return statearr_55629;
})();
var statearr_55630_57182 = state_55593__$1;
(statearr_55630_57182[(2)] = null);

(statearr_55630_57182[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (25))){
var inst_55589 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
var statearr_55631_57183 = state_55593__$1;
(statearr_55631_57183[(2)] = inst_55589);

(statearr_55631_57183[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (34))){
var inst_55587 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
var statearr_55633_57185 = state_55593__$1;
(statearr_55633_57185[(2)] = inst_55587);

(statearr_55633_57185[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (17))){
var state_55593__$1 = state_55593;
var statearr_55634_57188 = state_55593__$1;
(statearr_55634_57188[(2)] = false);

(statearr_55634_57188[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (3))){
var state_55593__$1 = state_55593;
var statearr_55635_57190 = state_55593__$1;
(statearr_55635_57190[(2)] = false);

(statearr_55635_57190[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (12))){
var inst_55591 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55593__$1,inst_55591);
} else {
if((state_val_55594 === (2))){
var inst_55494 = (state_55593[(8)]);
var inst_55499 = inst_55494.cljs$lang$protocol_mask$partition0$;
var inst_55500 = (inst_55499 & (64));
var inst_55501 = inst_55494.cljs$core$ISeq$;
var inst_55502 = (cljs.core.PROTOCOL_SENTINEL === inst_55501);
var inst_55503 = ((inst_55500) || (inst_55502));
var state_55593__$1 = state_55593;
if(cljs.core.truth_(inst_55503)){
var statearr_55636_57193 = state_55593__$1;
(statearr_55636_57193[(1)] = (5));

} else {
var statearr_55637_57194 = state_55593__$1;
(statearr_55637_57194[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (23))){
var inst_55552 = (state_55593[(14)]);
var inst_55558 = (inst_55552 == null);
var state_55593__$1 = state_55593;
if(cljs.core.truth_(inst_55558)){
var statearr_55638_57196 = state_55593__$1;
(statearr_55638_57196[(1)] = (26));

} else {
var statearr_55639_57197 = state_55593__$1;
(statearr_55639_57197[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (35))){
var inst_55578 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
if(cljs.core.truth_(inst_55578)){
var statearr_55641_57200 = state_55593__$1;
(statearr_55641_57200[(1)] = (36));

} else {
var statearr_55642_57201 = state_55593__$1;
(statearr_55642_57201[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (19))){
var inst_55520 = (state_55593[(7)]);
var inst_55540 = cljs.core.apply.call(null,cljs.core.hash_map,inst_55520);
var state_55593__$1 = state_55593;
var statearr_55643_57203 = state_55593__$1;
(statearr_55643_57203[(2)] = inst_55540);

(statearr_55643_57203[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (11))){
var inst_55520 = (state_55593[(7)]);
var inst_55524 = (inst_55520 == null);
var inst_55525 = cljs.core.not(inst_55524);
var state_55593__$1 = state_55593;
if(inst_55525){
var statearr_55644_57204 = state_55593__$1;
(statearr_55644_57204[(1)] = (13));

} else {
var statearr_55645_57205 = state_55593__$1;
(statearr_55645_57205[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (9))){
var inst_55494 = (state_55593[(8)]);
var state_55593__$1 = state_55593;
var statearr_55646_57210 = state_55593__$1;
(statearr_55646_57210[(2)] = inst_55494);

(statearr_55646_57210[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (5))){
var state_55593__$1 = state_55593;
var statearr_55647_57211 = state_55593__$1;
(statearr_55647_57211[(2)] = true);

(statearr_55647_57211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (14))){
var state_55593__$1 = state_55593;
var statearr_55648_57219 = state_55593__$1;
(statearr_55648_57219[(2)] = false);

(statearr_55648_57219[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (26))){
var inst_55553 = (state_55593[(10)]);
var inst_55560 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_55553);
var state_55593__$1 = state_55593;
var statearr_55649_57222 = state_55593__$1;
(statearr_55649_57222[(2)] = inst_55560);

(statearr_55649_57222[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (16))){
var state_55593__$1 = state_55593;
var statearr_55650_57223 = state_55593__$1;
(statearr_55650_57223[(2)] = true);

(statearr_55650_57223[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (38))){
var inst_55583 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
var statearr_55651_57228 = state_55593__$1;
(statearr_55651_57228[(2)] = inst_55583);

(statearr_55651_57228[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (30))){
var inst_55545 = (state_55593[(13)]);
var inst_55544 = (state_55593[(9)]);
var inst_55553 = (state_55593[(10)]);
var inst_55570 = cljs.core.empty_QMARK_.call(null,inst_55544);
var inst_55571 = inst_55545.call(null,inst_55553);
var inst_55572 = cljs.core.not(inst_55571);
var inst_55573 = ((inst_55570) && (inst_55572));
var state_55593__$1 = state_55593;
var statearr_55652_57230 = state_55593__$1;
(statearr_55652_57230[(2)] = inst_55573);

(statearr_55652_57230[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (10))){
var inst_55494 = (state_55593[(8)]);
var inst_55516 = (state_55593[(2)]);
var inst_55517 = cljs.core.get.call(null,inst_55516,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_55518 = cljs.core.get.call(null,inst_55516,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_55519 = cljs.core.get.call(null,inst_55516,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_55520 = inst_55494;
var state_55593__$1 = (function (){var statearr_55653 = state_55593;
(statearr_55653[(16)] = inst_55517);

(statearr_55653[(17)] = inst_55518);

(statearr_55653[(7)] = inst_55520);

(statearr_55653[(18)] = inst_55519);

return statearr_55653;
})();
var statearr_55654_57233 = state_55593__$1;
(statearr_55654_57233[(2)] = null);

(statearr_55654_57233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (18))){
var inst_55535 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
var statearr_55655_57235 = state_55593__$1;
(statearr_55655_57235[(2)] = inst_55535);

(statearr_55655_57235[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (37))){
var state_55593__$1 = state_55593;
var statearr_55656_57236 = state_55593__$1;
(statearr_55656_57236[(2)] = null);

(statearr_55656_57236[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (8))){
var inst_55494 = (state_55593[(8)]);
var inst_55513 = cljs.core.apply.call(null,cljs.core.hash_map,inst_55494);
var state_55593__$1 = state_55593;
var statearr_55657_57237 = state_55593__$1;
(statearr_55657_57237[(2)] = inst_55513);

(statearr_55657_57237[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57143,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__53637__auto__,c__54028__auto___57143,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__53638__auto__ = null;
var cljs$core$async$mix_$_state_machine__53638__auto____0 = (function (){
var statearr_55658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55658[(0)] = cljs$core$async$mix_$_state_machine__53638__auto__);

(statearr_55658[(1)] = (1));

return statearr_55658;
});
var cljs$core$async$mix_$_state_machine__53638__auto____1 = (function (state_55593){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_55593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e55659){if((e55659 instanceof Object)){
var ex__53641__auto__ = e55659;
var statearr_55660_57243 = state_55593;
(statearr_55660_57243[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55593);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57246 = state_55593;
state_55593 = G__57246;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__53638__auto__ = function(state_55593){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__53638__auto____1.call(this,state_55593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__53638__auto____0;
cljs$core$async$mix_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__53638__auto____1;
return cljs$core$async$mix_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57143,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__54030__auto__ = (function (){var statearr_55661 = f__54029__auto__();
(statearr_55661[(6)] = c__54028__auto___57143);

return statearr_55661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57143,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__55665 = arguments.length;
switch (G__55665) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__55671 = arguments.length;
switch (G__55671) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__55666_SHARP_){
if(cljs.core.truth_(p1__55666_SHARP_.call(null,topic))){
return p1__55666_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__55666_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55673 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55673 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta55674){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta55674 = meta55674;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_55675,meta55674__$1){
var self__ = this;
var _55675__$1 = this;
return (new cljs.core.async.t_cljs$core$async55673(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta55674__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_55675){
var self__ = this;
var _55675__$1 = this;
return self__.meta55674;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta55674","meta55674",1940106358,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55673.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55673.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55673";

cljs.core.async.t_cljs$core$async55673.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async55673");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55673.
 */
cljs.core.async.__GT_t_cljs$core$async55673 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async55673(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta55674){
return (new cljs.core.async.t_cljs$core$async55673(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta55674));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async55673(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__54028__auto___57324 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57324,mults,ensure_mult,p){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57324,mults,ensure_mult,p){
return (function (state_55752){
var state_val_55753 = (state_55752[(1)]);
if((state_val_55753 === (7))){
var inst_55748 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
var statearr_55756_57327 = state_55752__$1;
(statearr_55756_57327[(2)] = inst_55748);

(statearr_55756_57327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (20))){
var state_55752__$1 = state_55752;
var statearr_55757_57333 = state_55752__$1;
(statearr_55757_57333[(2)] = null);

(statearr_55757_57333[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (1))){
var state_55752__$1 = state_55752;
var statearr_55758_57337 = state_55752__$1;
(statearr_55758_57337[(2)] = null);

(statearr_55758_57337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (24))){
var inst_55731 = (state_55752[(7)]);
var inst_55740 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_55731);
var state_55752__$1 = state_55752;
var statearr_55760_57340 = state_55752__$1;
(statearr_55760_57340[(2)] = inst_55740);

(statearr_55760_57340[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (4))){
var inst_55681 = (state_55752[(8)]);
var inst_55681__$1 = (state_55752[(2)]);
var inst_55682 = (inst_55681__$1 == null);
var state_55752__$1 = (function (){var statearr_55761 = state_55752;
(statearr_55761[(8)] = inst_55681__$1);

return statearr_55761;
})();
if(cljs.core.truth_(inst_55682)){
var statearr_55762_57349 = state_55752__$1;
(statearr_55762_57349[(1)] = (5));

} else {
var statearr_55763_57350 = state_55752__$1;
(statearr_55763_57350[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (15))){
var inst_55725 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
var statearr_55764_57351 = state_55752__$1;
(statearr_55764_57351[(2)] = inst_55725);

(statearr_55764_57351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (21))){
var inst_55745 = (state_55752[(2)]);
var state_55752__$1 = (function (){var statearr_55765 = state_55752;
(statearr_55765[(9)] = inst_55745);

return statearr_55765;
})();
var statearr_55766_57354 = state_55752__$1;
(statearr_55766_57354[(2)] = null);

(statearr_55766_57354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (13))){
var inst_55707 = (state_55752[(10)]);
var inst_55709 = cljs.core.chunked_seq_QMARK_.call(null,inst_55707);
var state_55752__$1 = state_55752;
if(inst_55709){
var statearr_55767_57356 = state_55752__$1;
(statearr_55767_57356[(1)] = (16));

} else {
var statearr_55768_57357 = state_55752__$1;
(statearr_55768_57357[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (22))){
var inst_55737 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
if(cljs.core.truth_(inst_55737)){
var statearr_55769_57358 = state_55752__$1;
(statearr_55769_57358[(1)] = (23));

} else {
var statearr_55770_57359 = state_55752__$1;
(statearr_55770_57359[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (6))){
var inst_55731 = (state_55752[(7)]);
var inst_55733 = (state_55752[(11)]);
var inst_55681 = (state_55752[(8)]);
var inst_55731__$1 = topic_fn.call(null,inst_55681);
var inst_55732 = cljs.core.deref.call(null,mults);
var inst_55733__$1 = cljs.core.get.call(null,inst_55732,inst_55731__$1);
var state_55752__$1 = (function (){var statearr_55771 = state_55752;
(statearr_55771[(7)] = inst_55731__$1);

(statearr_55771[(11)] = inst_55733__$1);

return statearr_55771;
})();
if(cljs.core.truth_(inst_55733__$1)){
var statearr_55772_57361 = state_55752__$1;
(statearr_55772_57361[(1)] = (19));

} else {
var statearr_55773_57362 = state_55752__$1;
(statearr_55773_57362[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (25))){
var inst_55742 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
var statearr_55774_57365 = state_55752__$1;
(statearr_55774_57365[(2)] = inst_55742);

(statearr_55774_57365[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (17))){
var inst_55707 = (state_55752[(10)]);
var inst_55716 = cljs.core.first.call(null,inst_55707);
var inst_55717 = cljs.core.async.muxch_STAR_(inst_55716);
var inst_55718 = cljs.core.async.close_BANG_.call(null,inst_55717);
var inst_55719 = cljs.core.next.call(null,inst_55707);
var inst_55691 = inst_55719;
var inst_55692 = null;
var inst_55693 = (0);
var inst_55694 = (0);
var state_55752__$1 = (function (){var statearr_55775 = state_55752;
(statearr_55775[(12)] = inst_55691);

(statearr_55775[(13)] = inst_55694);

(statearr_55775[(14)] = inst_55692);

(statearr_55775[(15)] = inst_55718);

(statearr_55775[(16)] = inst_55693);

return statearr_55775;
})();
var statearr_55776_57373 = state_55752__$1;
(statearr_55776_57373[(2)] = null);

(statearr_55776_57373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (3))){
var inst_55750 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55752__$1,inst_55750);
} else {
if((state_val_55753 === (12))){
var inst_55727 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
var statearr_55777_57375 = state_55752__$1;
(statearr_55777_57375[(2)] = inst_55727);

(statearr_55777_57375[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (2))){
var state_55752__$1 = state_55752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55752__$1,(4),ch);
} else {
if((state_val_55753 === (23))){
var state_55752__$1 = state_55752;
var statearr_55778_57378 = state_55752__$1;
(statearr_55778_57378[(2)] = null);

(statearr_55778_57378[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (19))){
var inst_55733 = (state_55752[(11)]);
var inst_55681 = (state_55752[(8)]);
var inst_55735 = cljs.core.async.muxch_STAR_(inst_55733);
var state_55752__$1 = state_55752;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55752__$1,(22),inst_55735,inst_55681);
} else {
if((state_val_55753 === (11))){
var inst_55707 = (state_55752[(10)]);
var inst_55691 = (state_55752[(12)]);
var inst_55707__$1 = cljs.core.seq.call(null,inst_55691);
var state_55752__$1 = (function (){var statearr_55779 = state_55752;
(statearr_55779[(10)] = inst_55707__$1);

return statearr_55779;
})();
if(inst_55707__$1){
var statearr_55780_57383 = state_55752__$1;
(statearr_55780_57383[(1)] = (13));

} else {
var statearr_55781_57384 = state_55752__$1;
(statearr_55781_57384[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (9))){
var inst_55729 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
var statearr_55782_57389 = state_55752__$1;
(statearr_55782_57389[(2)] = inst_55729);

(statearr_55782_57389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (5))){
var inst_55688 = cljs.core.deref.call(null,mults);
var inst_55689 = cljs.core.vals.call(null,inst_55688);
var inst_55690 = cljs.core.seq.call(null,inst_55689);
var inst_55691 = inst_55690;
var inst_55692 = null;
var inst_55693 = (0);
var inst_55694 = (0);
var state_55752__$1 = (function (){var statearr_55783 = state_55752;
(statearr_55783[(12)] = inst_55691);

(statearr_55783[(13)] = inst_55694);

(statearr_55783[(14)] = inst_55692);

(statearr_55783[(16)] = inst_55693);

return statearr_55783;
})();
var statearr_55784_57396 = state_55752__$1;
(statearr_55784_57396[(2)] = null);

(statearr_55784_57396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (14))){
var state_55752__$1 = state_55752;
var statearr_55788_57397 = state_55752__$1;
(statearr_55788_57397[(2)] = null);

(statearr_55788_57397[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (16))){
var inst_55707 = (state_55752[(10)]);
var inst_55711 = cljs.core.chunk_first.call(null,inst_55707);
var inst_55712 = cljs.core.chunk_rest.call(null,inst_55707);
var inst_55713 = cljs.core.count.call(null,inst_55711);
var inst_55691 = inst_55712;
var inst_55692 = inst_55711;
var inst_55693 = inst_55713;
var inst_55694 = (0);
var state_55752__$1 = (function (){var statearr_55791 = state_55752;
(statearr_55791[(12)] = inst_55691);

(statearr_55791[(13)] = inst_55694);

(statearr_55791[(14)] = inst_55692);

(statearr_55791[(16)] = inst_55693);

return statearr_55791;
})();
var statearr_55796_57403 = state_55752__$1;
(statearr_55796_57403[(2)] = null);

(statearr_55796_57403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (10))){
var inst_55691 = (state_55752[(12)]);
var inst_55694 = (state_55752[(13)]);
var inst_55692 = (state_55752[(14)]);
var inst_55693 = (state_55752[(16)]);
var inst_55700 = cljs.core._nth(inst_55692,inst_55694);
var inst_55702 = cljs.core.async.muxch_STAR_(inst_55700);
var inst_55703 = cljs.core.async.close_BANG_.call(null,inst_55702);
var inst_55704 = (inst_55694 + (1));
var tmp55785 = inst_55691;
var tmp55786 = inst_55692;
var tmp55787 = inst_55693;
var inst_55691__$1 = tmp55785;
var inst_55692__$1 = tmp55786;
var inst_55693__$1 = tmp55787;
var inst_55694__$1 = inst_55704;
var state_55752__$1 = (function (){var statearr_55798 = state_55752;
(statearr_55798[(12)] = inst_55691__$1);

(statearr_55798[(13)] = inst_55694__$1);

(statearr_55798[(17)] = inst_55703);

(statearr_55798[(14)] = inst_55692__$1);

(statearr_55798[(16)] = inst_55693__$1);

return statearr_55798;
})();
var statearr_55799_57416 = state_55752__$1;
(statearr_55799_57416[(2)] = null);

(statearr_55799_57416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (18))){
var inst_55722 = (state_55752[(2)]);
var state_55752__$1 = state_55752;
var statearr_55800_57418 = state_55752__$1;
(statearr_55800_57418[(2)] = inst_55722);

(statearr_55800_57418[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55753 === (8))){
var inst_55694 = (state_55752[(13)]);
var inst_55693 = (state_55752[(16)]);
var inst_55697 = (inst_55694 < inst_55693);
var inst_55698 = inst_55697;
var state_55752__$1 = state_55752;
if(cljs.core.truth_(inst_55698)){
var statearr_55801_57426 = state_55752__$1;
(statearr_55801_57426[(1)] = (10));

} else {
var statearr_55802_57427 = state_55752__$1;
(statearr_55802_57427[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57324,mults,ensure_mult,p))
;
return ((function (switch__53637__auto__,c__54028__auto___57324,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_55804 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55804[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_55804[(1)] = (1));

return statearr_55804;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_55752){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_55752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e55805){if((e55805 instanceof Object)){
var ex__53641__auto__ = e55805;
var statearr_55806_57436 = state_55752;
(statearr_55806_57436[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55752);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55805;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57439 = state_55752;
state_55752 = G__57439;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_55752){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_55752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57324,mults,ensure_mult,p))
})();
var state__54030__auto__ = (function (){var statearr_55811 = f__54029__auto__();
(statearr_55811[(6)] = c__54028__auto___57324);

return statearr_55811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57324,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__55813 = arguments.length;
switch (G__55813) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__55815 = arguments.length;
switch (G__55815) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__55822 = arguments.length;
switch (G__55822) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__54028__auto___57450 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57450,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57450,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_55867){
var state_val_55868 = (state_55867[(1)]);
if((state_val_55868 === (7))){
var state_55867__$1 = state_55867;
var statearr_55869_57451 = state_55867__$1;
(statearr_55869_57451[(2)] = null);

(statearr_55869_57451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (1))){
var state_55867__$1 = state_55867;
var statearr_55870_57454 = state_55867__$1;
(statearr_55870_57454[(2)] = null);

(statearr_55870_57454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (4))){
var inst_55827 = (state_55867[(7)]);
var inst_55829 = (inst_55827 < cnt);
var state_55867__$1 = state_55867;
if(cljs.core.truth_(inst_55829)){
var statearr_55871_57457 = state_55867__$1;
(statearr_55871_57457[(1)] = (6));

} else {
var statearr_55872_57458 = state_55867__$1;
(statearr_55872_57458[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (15))){
var inst_55859 = (state_55867[(2)]);
var state_55867__$1 = state_55867;
var statearr_55873_57465 = state_55867__$1;
(statearr_55873_57465[(2)] = inst_55859);

(statearr_55873_57465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (13))){
var inst_55852 = cljs.core.async.close_BANG_.call(null,out);
var state_55867__$1 = state_55867;
var statearr_55874_57466 = state_55867__$1;
(statearr_55874_57466[(2)] = inst_55852);

(statearr_55874_57466[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (6))){
var state_55867__$1 = state_55867;
var statearr_55875_57467 = state_55867__$1;
(statearr_55875_57467[(2)] = null);

(statearr_55875_57467[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (3))){
var inst_55865 = (state_55867[(2)]);
var state_55867__$1 = state_55867;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55867__$1,inst_55865);
} else {
if((state_val_55868 === (12))){
var inst_55849 = (state_55867[(8)]);
var inst_55849__$1 = (state_55867[(2)]);
var inst_55850 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_55849__$1);
var state_55867__$1 = (function (){var statearr_55879 = state_55867;
(statearr_55879[(8)] = inst_55849__$1);

return statearr_55879;
})();
if(cljs.core.truth_(inst_55850)){
var statearr_55880_57471 = state_55867__$1;
(statearr_55880_57471[(1)] = (13));

} else {
var statearr_55881_57472 = state_55867__$1;
(statearr_55881_57472[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (2))){
var inst_55826 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_55827 = (0);
var state_55867__$1 = (function (){var statearr_55882 = state_55867;
(statearr_55882[(9)] = inst_55826);

(statearr_55882[(7)] = inst_55827);

return statearr_55882;
})();
var statearr_55883_57477 = state_55867__$1;
(statearr_55883_57477[(2)] = null);

(statearr_55883_57477[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (11))){
var inst_55827 = (state_55867[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_55867,(10),Object,null,(9));
var inst_55836 = chs__$1.call(null,inst_55827);
var inst_55837 = done.call(null,inst_55827);
var inst_55838 = cljs.core.async.take_BANG_.call(null,inst_55836,inst_55837);
var state_55867__$1 = state_55867;
var statearr_55884_57483 = state_55867__$1;
(statearr_55884_57483[(2)] = inst_55838);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55867__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (9))){
var inst_55827 = (state_55867[(7)]);
var inst_55840 = (state_55867[(2)]);
var inst_55841 = (inst_55827 + (1));
var inst_55827__$1 = inst_55841;
var state_55867__$1 = (function (){var statearr_55885 = state_55867;
(statearr_55885[(10)] = inst_55840);

(statearr_55885[(7)] = inst_55827__$1);

return statearr_55885;
})();
var statearr_55886_57486 = state_55867__$1;
(statearr_55886_57486[(2)] = null);

(statearr_55886_57486[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (5))){
var inst_55847 = (state_55867[(2)]);
var state_55867__$1 = (function (){var statearr_55887 = state_55867;
(statearr_55887[(11)] = inst_55847);

return statearr_55887;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55867__$1,(12),dchan);
} else {
if((state_val_55868 === (14))){
var inst_55849 = (state_55867[(8)]);
var inst_55854 = cljs.core.apply.call(null,f,inst_55849);
var state_55867__$1 = state_55867;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55867__$1,(16),out,inst_55854);
} else {
if((state_val_55868 === (16))){
var inst_55856 = (state_55867[(2)]);
var state_55867__$1 = (function (){var statearr_55889 = state_55867;
(statearr_55889[(12)] = inst_55856);

return statearr_55889;
})();
var statearr_55890_57488 = state_55867__$1;
(statearr_55890_57488[(2)] = null);

(statearr_55890_57488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (10))){
var inst_55831 = (state_55867[(2)]);
var inst_55832 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_55867__$1 = (function (){var statearr_55891 = state_55867;
(statearr_55891[(13)] = inst_55831);

return statearr_55891;
})();
var statearr_55892_57490 = state_55867__$1;
(statearr_55892_57490[(2)] = inst_55832);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55867__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55868 === (8))){
var inst_55845 = (state_55867[(2)]);
var state_55867__$1 = state_55867;
var statearr_55893_57491 = state_55867__$1;
(statearr_55893_57491[(2)] = inst_55845);

(statearr_55893_57491[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57450,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__53637__auto__,c__54028__auto___57450,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_55894 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55894[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_55894[(1)] = (1));

return statearr_55894;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_55867){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_55867);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e55896){if((e55896 instanceof Object)){
var ex__53641__auto__ = e55896;
var statearr_55897_57495 = state_55867;
(statearr_55897_57495[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55867);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55896;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57496 = state_55867;
state_55867 = G__57496;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_55867){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_55867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57450,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__54030__auto__ = (function (){var statearr_55898 = f__54029__auto__();
(statearr_55898[(6)] = c__54028__auto___57450);

return statearr_55898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57450,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__55901 = arguments.length;
switch (G__55901) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54028__auto___57507 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57507,out){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57507,out){
return (function (state_55933){
var state_val_55934 = (state_55933[(1)]);
if((state_val_55934 === (7))){
var inst_55913 = (state_55933[(7)]);
var inst_55912 = (state_55933[(8)]);
var inst_55912__$1 = (state_55933[(2)]);
var inst_55913__$1 = cljs.core.nth.call(null,inst_55912__$1,(0),null);
var inst_55914 = cljs.core.nth.call(null,inst_55912__$1,(1),null);
var inst_55915 = (inst_55913__$1 == null);
var state_55933__$1 = (function (){var statearr_55935 = state_55933;
(statearr_55935[(7)] = inst_55913__$1);

(statearr_55935[(8)] = inst_55912__$1);

(statearr_55935[(9)] = inst_55914);

return statearr_55935;
})();
if(cljs.core.truth_(inst_55915)){
var statearr_55936_57509 = state_55933__$1;
(statearr_55936_57509[(1)] = (8));

} else {
var statearr_55937_57510 = state_55933__$1;
(statearr_55937_57510[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55934 === (1))){
var inst_55902 = cljs.core.vec.call(null,chs);
var inst_55903 = inst_55902;
var state_55933__$1 = (function (){var statearr_55938 = state_55933;
(statearr_55938[(10)] = inst_55903);

return statearr_55938;
})();
var statearr_55939_57512 = state_55933__$1;
(statearr_55939_57512[(2)] = null);

(statearr_55939_57512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55934 === (4))){
var inst_55903 = (state_55933[(10)]);
var state_55933__$1 = state_55933;
return cljs.core.async.ioc_alts_BANG_.call(null,state_55933__$1,(7),inst_55903);
} else {
if((state_val_55934 === (6))){
var inst_55929 = (state_55933[(2)]);
var state_55933__$1 = state_55933;
var statearr_55940_57514 = state_55933__$1;
(statearr_55940_57514[(2)] = inst_55929);

(statearr_55940_57514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55934 === (3))){
var inst_55931 = (state_55933[(2)]);
var state_55933__$1 = state_55933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55933__$1,inst_55931);
} else {
if((state_val_55934 === (2))){
var inst_55903 = (state_55933[(10)]);
var inst_55905 = cljs.core.count.call(null,inst_55903);
var inst_55906 = (inst_55905 > (0));
var state_55933__$1 = state_55933;
if(cljs.core.truth_(inst_55906)){
var statearr_55942_57518 = state_55933__$1;
(statearr_55942_57518[(1)] = (4));

} else {
var statearr_55943_57520 = state_55933__$1;
(statearr_55943_57520[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55934 === (11))){
var inst_55903 = (state_55933[(10)]);
var inst_55922 = (state_55933[(2)]);
var tmp55941 = inst_55903;
var inst_55903__$1 = tmp55941;
var state_55933__$1 = (function (){var statearr_55944 = state_55933;
(statearr_55944[(10)] = inst_55903__$1);

(statearr_55944[(11)] = inst_55922);

return statearr_55944;
})();
var statearr_55945_57524 = state_55933__$1;
(statearr_55945_57524[(2)] = null);

(statearr_55945_57524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55934 === (9))){
var inst_55913 = (state_55933[(7)]);
var state_55933__$1 = state_55933;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55933__$1,(11),out,inst_55913);
} else {
if((state_val_55934 === (5))){
var inst_55927 = cljs.core.async.close_BANG_.call(null,out);
var state_55933__$1 = state_55933;
var statearr_55946_57531 = state_55933__$1;
(statearr_55946_57531[(2)] = inst_55927);

(statearr_55946_57531[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55934 === (10))){
var inst_55925 = (state_55933[(2)]);
var state_55933__$1 = state_55933;
var statearr_55947_57533 = state_55933__$1;
(statearr_55947_57533[(2)] = inst_55925);

(statearr_55947_57533[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55934 === (8))){
var inst_55913 = (state_55933[(7)]);
var inst_55912 = (state_55933[(8)]);
var inst_55903 = (state_55933[(10)]);
var inst_55914 = (state_55933[(9)]);
var inst_55917 = (function (){var cs = inst_55903;
var vec__55908 = inst_55912;
var v = inst_55913;
var c = inst_55914;
return ((function (cs,vec__55908,v,c,inst_55913,inst_55912,inst_55903,inst_55914,state_val_55934,c__54028__auto___57507,out){
return (function (p1__55899_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__55899_SHARP_);
});
;})(cs,vec__55908,v,c,inst_55913,inst_55912,inst_55903,inst_55914,state_val_55934,c__54028__auto___57507,out))
})();
var inst_55918 = cljs.core.filterv.call(null,inst_55917,inst_55903);
var inst_55903__$1 = inst_55918;
var state_55933__$1 = (function (){var statearr_55948 = state_55933;
(statearr_55948[(10)] = inst_55903__$1);

return statearr_55948;
})();
var statearr_55949_57539 = state_55933__$1;
(statearr_55949_57539[(2)] = null);

(statearr_55949_57539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57507,out))
;
return ((function (switch__53637__auto__,c__54028__auto___57507,out){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_55950 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55950[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_55950[(1)] = (1));

return statearr_55950;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_55933){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_55933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e55951){if((e55951 instanceof Object)){
var ex__53641__auto__ = e55951;
var statearr_55952_57543 = state_55933;
(statearr_55952_57543[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55933);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57544 = state_55933;
state_55933 = G__57544;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_55933){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_55933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57507,out))
})();
var state__54030__auto__ = (function (){var statearr_55953 = f__54029__auto__();
(statearr_55953[(6)] = c__54028__auto___57507);

return statearr_55953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57507,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__55955 = arguments.length;
switch (G__55955) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54028__auto___57553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57553,out){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57553,out){
return (function (state_55982){
var state_val_55983 = (state_55982[(1)]);
if((state_val_55983 === (7))){
var inst_55964 = (state_55982[(7)]);
var inst_55964__$1 = (state_55982[(2)]);
var inst_55965 = (inst_55964__$1 == null);
var inst_55966 = cljs.core.not(inst_55965);
var state_55982__$1 = (function (){var statearr_55984 = state_55982;
(statearr_55984[(7)] = inst_55964__$1);

return statearr_55984;
})();
if(inst_55966){
var statearr_55985_57557 = state_55982__$1;
(statearr_55985_57557[(1)] = (8));

} else {
var statearr_55986_57558 = state_55982__$1;
(statearr_55986_57558[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (1))){
var inst_55959 = (0);
var state_55982__$1 = (function (){var statearr_55987 = state_55982;
(statearr_55987[(8)] = inst_55959);

return statearr_55987;
})();
var statearr_55988_57560 = state_55982__$1;
(statearr_55988_57560[(2)] = null);

(statearr_55988_57560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (4))){
var state_55982__$1 = state_55982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55982__$1,(7),ch);
} else {
if((state_val_55983 === (6))){
var inst_55977 = (state_55982[(2)]);
var state_55982__$1 = state_55982;
var statearr_55989_57562 = state_55982__$1;
(statearr_55989_57562[(2)] = inst_55977);

(statearr_55989_57562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (3))){
var inst_55979 = (state_55982[(2)]);
var inst_55980 = cljs.core.async.close_BANG_.call(null,out);
var state_55982__$1 = (function (){var statearr_55990 = state_55982;
(statearr_55990[(9)] = inst_55979);

return statearr_55990;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55982__$1,inst_55980);
} else {
if((state_val_55983 === (2))){
var inst_55959 = (state_55982[(8)]);
var inst_55961 = (inst_55959 < n);
var state_55982__$1 = state_55982;
if(cljs.core.truth_(inst_55961)){
var statearr_55991_57566 = state_55982__$1;
(statearr_55991_57566[(1)] = (4));

} else {
var statearr_55992_57571 = state_55982__$1;
(statearr_55992_57571[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (11))){
var inst_55959 = (state_55982[(8)]);
var inst_55969 = (state_55982[(2)]);
var inst_55970 = (inst_55959 + (1));
var inst_55959__$1 = inst_55970;
var state_55982__$1 = (function (){var statearr_55993 = state_55982;
(statearr_55993[(10)] = inst_55969);

(statearr_55993[(8)] = inst_55959__$1);

return statearr_55993;
})();
var statearr_55994_57577 = state_55982__$1;
(statearr_55994_57577[(2)] = null);

(statearr_55994_57577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (9))){
var state_55982__$1 = state_55982;
var statearr_55995_57580 = state_55982__$1;
(statearr_55995_57580[(2)] = null);

(statearr_55995_57580[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (5))){
var state_55982__$1 = state_55982;
var statearr_55996_57585 = state_55982__$1;
(statearr_55996_57585[(2)] = null);

(statearr_55996_57585[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (10))){
var inst_55974 = (state_55982[(2)]);
var state_55982__$1 = state_55982;
var statearr_55997_57587 = state_55982__$1;
(statearr_55997_57587[(2)] = inst_55974);

(statearr_55997_57587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55983 === (8))){
var inst_55964 = (state_55982[(7)]);
var state_55982__$1 = state_55982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55982__$1,(11),out,inst_55964);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57553,out))
;
return ((function (switch__53637__auto__,c__54028__auto___57553,out){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_55998 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55998[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_55998[(1)] = (1));

return statearr_55998;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_55982){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_55982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e55999){if((e55999 instanceof Object)){
var ex__53641__auto__ = e55999;
var statearr_56000_57592 = state_55982;
(statearr_56000_57592[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55999;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57595 = state_55982;
state_55982 = G__57595;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_55982){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_55982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57553,out))
})();
var state__54030__auto__ = (function (){var statearr_56001 = f__54029__auto__();
(statearr_56001[(6)] = c__54028__auto___57553);

return statearr_56001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57553,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async56005 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56005 = (function (f,ch,meta56006){
this.f = f;
this.ch = ch;
this.meta56006 = meta56006;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56007,meta56006__$1){
var self__ = this;
var _56007__$1 = this;
return (new cljs.core.async.t_cljs$core$async56005(self__.f,self__.ch,meta56006__$1));
});

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56007){
var self__ = this;
var _56007__$1 = this;
return self__.meta56006;
});

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async56014 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56014 = (function (f,ch,meta56006,_,fn1,meta56015){
this.f = f;
this.ch = ch;
this.meta56006 = meta56006;
this._ = _;
this.fn1 = fn1;
this.meta56015 = meta56015;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56014.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_56016,meta56015__$1){
var self__ = this;
var _56016__$1 = this;
return (new cljs.core.async.t_cljs$core$async56014(self__.f,self__.ch,self__.meta56006,self__._,self__.fn1,meta56015__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async56014.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_56016){
var self__ = this;
var _56016__$1 = this;
return self__.meta56015;
});})(___$1))
;

cljs.core.async.t_cljs$core$async56014.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56014.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async56014.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async56014.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__56004_SHARP_){
return f1.call(null,(((p1__56004_SHARP_ == null))?null:self__.f.call(null,p1__56004_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async56014.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56006","meta56006",-2051125391,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async56005","cljs.core.async/t_cljs$core$async56005",1638246996,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta56015","meta56015",257270898,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async56014.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56014.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56014";

cljs.core.async.t_cljs$core$async56014.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async56014");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async56014.
 */
cljs.core.async.__GT_t_cljs$core$async56014 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async56014(f__$1,ch__$1,meta56006__$1,___$2,fn1__$1,meta56015){
return (new cljs.core.async.t_cljs$core$async56014(f__$1,ch__$1,meta56006__$1,___$2,fn1__$1,meta56015));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async56014(self__.f,self__.ch,self__.meta56006,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56005.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async56005.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56006","meta56006",-2051125391,null)], null);
});

cljs.core.async.t_cljs$core$async56005.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56005.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56005";

cljs.core.async.t_cljs$core$async56005.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async56005");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async56005.
 */
cljs.core.async.__GT_t_cljs$core$async56005 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async56005(f__$1,ch__$1,meta56006){
return (new cljs.core.async.t_cljs$core$async56005(f__$1,ch__$1,meta56006));
});

}

return (new cljs.core.async.t_cljs$core$async56005(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async56022 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56022 = (function (f,ch,meta56023){
this.f = f;
this.ch = ch;
this.meta56023 = meta56023;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56024,meta56023__$1){
var self__ = this;
var _56024__$1 = this;
return (new cljs.core.async.t_cljs$core$async56022(self__.f,self__.ch,meta56023__$1));
});

cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56024){
var self__ = this;
var _56024__$1 = this;
return self__.meta56023;
});

cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56022.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async56022.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56023","meta56023",-879763558,null)], null);
});

cljs.core.async.t_cljs$core$async56022.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56022.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56022";

cljs.core.async.t_cljs$core$async56022.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async56022");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async56022.
 */
cljs.core.async.__GT_t_cljs$core$async56022 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async56022(f__$1,ch__$1,meta56023){
return (new cljs.core.async.t_cljs$core$async56022(f__$1,ch__$1,meta56023));
});

}

return (new cljs.core.async.t_cljs$core$async56022(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async56026 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56026 = (function (p,ch,meta56027){
this.p = p;
this.ch = ch;
this.meta56027 = meta56027;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56028,meta56027__$1){
var self__ = this;
var _56028__$1 = this;
return (new cljs.core.async.t_cljs$core$async56026(self__.p,self__.ch,meta56027__$1));
});

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56028){
var self__ = this;
var _56028__$1 = this;
return self__.meta56027;
});

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56026.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async56026.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56027","meta56027",-532157426,null)], null);
});

cljs.core.async.t_cljs$core$async56026.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56026.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56026";

cljs.core.async.t_cljs$core$async56026.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async56026");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async56026.
 */
cljs.core.async.__GT_t_cljs$core$async56026 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async56026(p__$1,ch__$1,meta56027){
return (new cljs.core.async.t_cljs$core$async56026(p__$1,ch__$1,meta56027));
});

}

return (new cljs.core.async.t_cljs$core$async56026(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__56036 = arguments.length;
switch (G__56036) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54028__auto___57659 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57659,out){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57659,out){
return (function (state_56058){
var state_val_56059 = (state_56058[(1)]);
if((state_val_56059 === (7))){
var inst_56054 = (state_56058[(2)]);
var state_56058__$1 = state_56058;
var statearr_56062_57668 = state_56058__$1;
(statearr_56062_57668[(2)] = inst_56054);

(statearr_56062_57668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (1))){
var state_56058__$1 = state_56058;
var statearr_56063_57673 = state_56058__$1;
(statearr_56063_57673[(2)] = null);

(statearr_56063_57673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (4))){
var inst_56039 = (state_56058[(7)]);
var inst_56039__$1 = (state_56058[(2)]);
var inst_56040 = (inst_56039__$1 == null);
var state_56058__$1 = (function (){var statearr_56065 = state_56058;
(statearr_56065[(7)] = inst_56039__$1);

return statearr_56065;
})();
if(cljs.core.truth_(inst_56040)){
var statearr_56068_57685 = state_56058__$1;
(statearr_56068_57685[(1)] = (5));

} else {
var statearr_56069_57687 = state_56058__$1;
(statearr_56069_57687[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (6))){
var inst_56039 = (state_56058[(7)]);
var inst_56044 = p.call(null,inst_56039);
var state_56058__$1 = state_56058;
if(cljs.core.truth_(inst_56044)){
var statearr_56070_57694 = state_56058__$1;
(statearr_56070_57694[(1)] = (8));

} else {
var statearr_56071_57695 = state_56058__$1;
(statearr_56071_57695[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (3))){
var inst_56056 = (state_56058[(2)]);
var state_56058__$1 = state_56058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56058__$1,inst_56056);
} else {
if((state_val_56059 === (2))){
var state_56058__$1 = state_56058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56058__$1,(4),ch);
} else {
if((state_val_56059 === (11))){
var inst_56048 = (state_56058[(2)]);
var state_56058__$1 = state_56058;
var statearr_56076_57701 = state_56058__$1;
(statearr_56076_57701[(2)] = inst_56048);

(statearr_56076_57701[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (9))){
var state_56058__$1 = state_56058;
var statearr_56078_57707 = state_56058__$1;
(statearr_56078_57707[(2)] = null);

(statearr_56078_57707[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (5))){
var inst_56042 = cljs.core.async.close_BANG_.call(null,out);
var state_56058__$1 = state_56058;
var statearr_56079_57714 = state_56058__$1;
(statearr_56079_57714[(2)] = inst_56042);

(statearr_56079_57714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (10))){
var inst_56051 = (state_56058[(2)]);
var state_56058__$1 = (function (){var statearr_56080 = state_56058;
(statearr_56080[(8)] = inst_56051);

return statearr_56080;
})();
var statearr_56081_57718 = state_56058__$1;
(statearr_56081_57718[(2)] = null);

(statearr_56081_57718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56059 === (8))){
var inst_56039 = (state_56058[(7)]);
var state_56058__$1 = state_56058;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56058__$1,(11),out,inst_56039);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57659,out))
;
return ((function (switch__53637__auto__,c__54028__auto___57659,out){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_56083 = [null,null,null,null,null,null,null,null,null];
(statearr_56083[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_56083[(1)] = (1));

return statearr_56083;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_56058){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_56058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e56084){if((e56084 instanceof Object)){
var ex__53641__auto__ = e56084;
var statearr_56086_57732 = state_56058;
(statearr_56086_57732[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56058);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56084;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57734 = state_56058;
state_56058 = G__57734;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_56058){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_56058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57659,out))
})();
var state__54030__auto__ = (function (){var statearr_56090 = f__54029__auto__();
(statearr_56090[(6)] = c__54028__auto___57659);

return statearr_56090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57659,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__56092 = arguments.length;
switch (G__56092) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__){
return (function (state_56155){
var state_val_56159 = (state_56155[(1)]);
if((state_val_56159 === (7))){
var inst_56151 = (state_56155[(2)]);
var state_56155__$1 = state_56155;
var statearr_56160_57768 = state_56155__$1;
(statearr_56160_57768[(2)] = inst_56151);

(statearr_56160_57768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (20))){
var inst_56121 = (state_56155[(7)]);
var inst_56132 = (state_56155[(2)]);
var inst_56133 = cljs.core.next.call(null,inst_56121);
var inst_56106 = inst_56133;
var inst_56107 = null;
var inst_56108 = (0);
var inst_56109 = (0);
var state_56155__$1 = (function (){var statearr_56161 = state_56155;
(statearr_56161[(8)] = inst_56107);

(statearr_56161[(9)] = inst_56106);

(statearr_56161[(10)] = inst_56132);

(statearr_56161[(11)] = inst_56109);

(statearr_56161[(12)] = inst_56108);

return statearr_56161;
})();
var statearr_56162_57771 = state_56155__$1;
(statearr_56162_57771[(2)] = null);

(statearr_56162_57771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (1))){
var state_56155__$1 = state_56155;
var statearr_56163_57773 = state_56155__$1;
(statearr_56163_57773[(2)] = null);

(statearr_56163_57773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (4))){
var inst_56095 = (state_56155[(13)]);
var inst_56095__$1 = (state_56155[(2)]);
var inst_56096 = (inst_56095__$1 == null);
var state_56155__$1 = (function (){var statearr_56165 = state_56155;
(statearr_56165[(13)] = inst_56095__$1);

return statearr_56165;
})();
if(cljs.core.truth_(inst_56096)){
var statearr_56166_57774 = state_56155__$1;
(statearr_56166_57774[(1)] = (5));

} else {
var statearr_56167_57775 = state_56155__$1;
(statearr_56167_57775[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (15))){
var state_56155__$1 = state_56155;
var statearr_56171_57777 = state_56155__$1;
(statearr_56171_57777[(2)] = null);

(statearr_56171_57777[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (21))){
var state_56155__$1 = state_56155;
var statearr_56172_57778 = state_56155__$1;
(statearr_56172_57778[(2)] = null);

(statearr_56172_57778[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (13))){
var inst_56107 = (state_56155[(8)]);
var inst_56106 = (state_56155[(9)]);
var inst_56109 = (state_56155[(11)]);
var inst_56108 = (state_56155[(12)]);
var inst_56117 = (state_56155[(2)]);
var inst_56118 = (inst_56109 + (1));
var tmp56168 = inst_56107;
var tmp56169 = inst_56106;
var tmp56170 = inst_56108;
var inst_56106__$1 = tmp56169;
var inst_56107__$1 = tmp56168;
var inst_56108__$1 = tmp56170;
var inst_56109__$1 = inst_56118;
var state_56155__$1 = (function (){var statearr_56173 = state_56155;
(statearr_56173[(8)] = inst_56107__$1);

(statearr_56173[(9)] = inst_56106__$1);

(statearr_56173[(14)] = inst_56117);

(statearr_56173[(11)] = inst_56109__$1);

(statearr_56173[(12)] = inst_56108__$1);

return statearr_56173;
})();
var statearr_56174_57791 = state_56155__$1;
(statearr_56174_57791[(2)] = null);

(statearr_56174_57791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (22))){
var state_56155__$1 = state_56155;
var statearr_56175_57792 = state_56155__$1;
(statearr_56175_57792[(2)] = null);

(statearr_56175_57792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (6))){
var inst_56095 = (state_56155[(13)]);
var inst_56104 = f.call(null,inst_56095);
var inst_56105 = cljs.core.seq.call(null,inst_56104);
var inst_56106 = inst_56105;
var inst_56107 = null;
var inst_56108 = (0);
var inst_56109 = (0);
var state_56155__$1 = (function (){var statearr_56176 = state_56155;
(statearr_56176[(8)] = inst_56107);

(statearr_56176[(9)] = inst_56106);

(statearr_56176[(11)] = inst_56109);

(statearr_56176[(12)] = inst_56108);

return statearr_56176;
})();
var statearr_56177_57794 = state_56155__$1;
(statearr_56177_57794[(2)] = null);

(statearr_56177_57794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (17))){
var inst_56121 = (state_56155[(7)]);
var inst_56125 = cljs.core.chunk_first.call(null,inst_56121);
var inst_56126 = cljs.core.chunk_rest.call(null,inst_56121);
var inst_56127 = cljs.core.count.call(null,inst_56125);
var inst_56106 = inst_56126;
var inst_56107 = inst_56125;
var inst_56108 = inst_56127;
var inst_56109 = (0);
var state_56155__$1 = (function (){var statearr_56178 = state_56155;
(statearr_56178[(8)] = inst_56107);

(statearr_56178[(9)] = inst_56106);

(statearr_56178[(11)] = inst_56109);

(statearr_56178[(12)] = inst_56108);

return statearr_56178;
})();
var statearr_56179_57796 = state_56155__$1;
(statearr_56179_57796[(2)] = null);

(statearr_56179_57796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (3))){
var inst_56153 = (state_56155[(2)]);
var state_56155__$1 = state_56155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56155__$1,inst_56153);
} else {
if((state_val_56159 === (12))){
var inst_56141 = (state_56155[(2)]);
var state_56155__$1 = state_56155;
var statearr_56180_57797 = state_56155__$1;
(statearr_56180_57797[(2)] = inst_56141);

(statearr_56180_57797[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (2))){
var state_56155__$1 = state_56155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56155__$1,(4),in$);
} else {
if((state_val_56159 === (23))){
var inst_56149 = (state_56155[(2)]);
var state_56155__$1 = state_56155;
var statearr_56181_57799 = state_56155__$1;
(statearr_56181_57799[(2)] = inst_56149);

(statearr_56181_57799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (19))){
var inst_56136 = (state_56155[(2)]);
var state_56155__$1 = state_56155;
var statearr_56182_57800 = state_56155__$1;
(statearr_56182_57800[(2)] = inst_56136);

(statearr_56182_57800[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (11))){
var inst_56106 = (state_56155[(9)]);
var inst_56121 = (state_56155[(7)]);
var inst_56121__$1 = cljs.core.seq.call(null,inst_56106);
var state_56155__$1 = (function (){var statearr_56183 = state_56155;
(statearr_56183[(7)] = inst_56121__$1);

return statearr_56183;
})();
if(inst_56121__$1){
var statearr_56184_57801 = state_56155__$1;
(statearr_56184_57801[(1)] = (14));

} else {
var statearr_56185_57802 = state_56155__$1;
(statearr_56185_57802[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (9))){
var inst_56143 = (state_56155[(2)]);
var inst_56144 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_56155__$1 = (function (){var statearr_56186 = state_56155;
(statearr_56186[(15)] = inst_56143);

return statearr_56186;
})();
if(cljs.core.truth_(inst_56144)){
var statearr_56187_57803 = state_56155__$1;
(statearr_56187_57803[(1)] = (21));

} else {
var statearr_56188_57804 = state_56155__$1;
(statearr_56188_57804[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (5))){
var inst_56098 = cljs.core.async.close_BANG_.call(null,out);
var state_56155__$1 = state_56155;
var statearr_56189_57805 = state_56155__$1;
(statearr_56189_57805[(2)] = inst_56098);

(statearr_56189_57805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (14))){
var inst_56121 = (state_56155[(7)]);
var inst_56123 = cljs.core.chunked_seq_QMARK_.call(null,inst_56121);
var state_56155__$1 = state_56155;
if(inst_56123){
var statearr_56190_57809 = state_56155__$1;
(statearr_56190_57809[(1)] = (17));

} else {
var statearr_56192_57810 = state_56155__$1;
(statearr_56192_57810[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (16))){
var inst_56139 = (state_56155[(2)]);
var state_56155__$1 = state_56155;
var statearr_56193_57815 = state_56155__$1;
(statearr_56193_57815[(2)] = inst_56139);

(statearr_56193_57815[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (10))){
var inst_56107 = (state_56155[(8)]);
var inst_56109 = (state_56155[(11)]);
var inst_56115 = cljs.core._nth(inst_56107,inst_56109);
var state_56155__$1 = state_56155;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56155__$1,(13),out,inst_56115);
} else {
if((state_val_56159 === (18))){
var inst_56121 = (state_56155[(7)]);
var inst_56130 = cljs.core.first.call(null,inst_56121);
var state_56155__$1 = state_56155;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56155__$1,(20),out,inst_56130);
} else {
if((state_val_56159 === (8))){
var inst_56109 = (state_56155[(11)]);
var inst_56108 = (state_56155[(12)]);
var inst_56111 = (inst_56109 < inst_56108);
var inst_56112 = inst_56111;
var state_56155__$1 = state_56155;
if(cljs.core.truth_(inst_56112)){
var statearr_56194_57829 = state_56155__$1;
(statearr_56194_57829[(1)] = (10));

} else {
var statearr_56195_57834 = state_56155__$1;
(statearr_56195_57834[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__))
;
return ((function (switch__53637__auto__,c__54028__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__53638__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__53638__auto____0 = (function (){
var statearr_56196 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56196[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__53638__auto__);

(statearr_56196[(1)] = (1));

return statearr_56196;
});
var cljs$core$async$mapcat_STAR__$_state_machine__53638__auto____1 = (function (state_56155){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_56155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e56197){if((e56197 instanceof Object)){
var ex__53641__auto__ = e56197;
var statearr_56198_57842 = state_56155;
(statearr_56198_57842[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56155);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56197;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57847 = state_56155;
state_56155 = G__57847;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__53638__auto__ = function(state_56155){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__53638__auto____1.call(this,state_56155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__53638__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__53638__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__))
})();
var state__54030__auto__ = (function (){var statearr_56199 = f__54029__auto__();
(statearr_56199[(6)] = c__54028__auto__);

return statearr_56199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__))
);

return c__54028__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__56202 = arguments.length;
switch (G__56202) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__56205 = arguments.length;
switch (G__56205) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__56207 = arguments.length;
switch (G__56207) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54028__auto___57876 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57876,out){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57876,out){
return (function (state_56233){
var state_val_56234 = (state_56233[(1)]);
if((state_val_56234 === (7))){
var inst_56228 = (state_56233[(2)]);
var state_56233__$1 = state_56233;
var statearr_56235_57877 = state_56233__$1;
(statearr_56235_57877[(2)] = inst_56228);

(statearr_56235_57877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56234 === (1))){
var inst_56210 = null;
var state_56233__$1 = (function (){var statearr_56236 = state_56233;
(statearr_56236[(7)] = inst_56210);

return statearr_56236;
})();
var statearr_56237_57879 = state_56233__$1;
(statearr_56237_57879[(2)] = null);

(statearr_56237_57879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56234 === (4))){
var inst_56213 = (state_56233[(8)]);
var inst_56213__$1 = (state_56233[(2)]);
var inst_56214 = (inst_56213__$1 == null);
var inst_56215 = cljs.core.not(inst_56214);
var state_56233__$1 = (function (){var statearr_56239 = state_56233;
(statearr_56239[(8)] = inst_56213__$1);

return statearr_56239;
})();
if(inst_56215){
var statearr_56240_57881 = state_56233__$1;
(statearr_56240_57881[(1)] = (5));

} else {
var statearr_56241_57886 = state_56233__$1;
(statearr_56241_57886[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56234 === (6))){
var state_56233__$1 = state_56233;
var statearr_56242_57888 = state_56233__$1;
(statearr_56242_57888[(2)] = null);

(statearr_56242_57888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56234 === (3))){
var inst_56230 = (state_56233[(2)]);
var inst_56231 = cljs.core.async.close_BANG_.call(null,out);
var state_56233__$1 = (function (){var statearr_56243 = state_56233;
(statearr_56243[(9)] = inst_56230);

return statearr_56243;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56233__$1,inst_56231);
} else {
if((state_val_56234 === (2))){
var state_56233__$1 = state_56233;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56233__$1,(4),ch);
} else {
if((state_val_56234 === (11))){
var inst_56213 = (state_56233[(8)]);
var inst_56222 = (state_56233[(2)]);
var inst_56210 = inst_56213;
var state_56233__$1 = (function (){var statearr_56244 = state_56233;
(statearr_56244[(7)] = inst_56210);

(statearr_56244[(10)] = inst_56222);

return statearr_56244;
})();
var statearr_56245_57898 = state_56233__$1;
(statearr_56245_57898[(2)] = null);

(statearr_56245_57898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56234 === (9))){
var inst_56213 = (state_56233[(8)]);
var state_56233__$1 = state_56233;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56233__$1,(11),out,inst_56213);
} else {
if((state_val_56234 === (5))){
var inst_56213 = (state_56233[(8)]);
var inst_56210 = (state_56233[(7)]);
var inst_56217 = cljs.core._EQ_.call(null,inst_56213,inst_56210);
var state_56233__$1 = state_56233;
if(inst_56217){
var statearr_56247_57901 = state_56233__$1;
(statearr_56247_57901[(1)] = (8));

} else {
var statearr_56248_57903 = state_56233__$1;
(statearr_56248_57903[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56234 === (10))){
var inst_56225 = (state_56233[(2)]);
var state_56233__$1 = state_56233;
var statearr_56249_57904 = state_56233__$1;
(statearr_56249_57904[(2)] = inst_56225);

(statearr_56249_57904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56234 === (8))){
var inst_56210 = (state_56233[(7)]);
var tmp56246 = inst_56210;
var inst_56210__$1 = tmp56246;
var state_56233__$1 = (function (){var statearr_56250 = state_56233;
(statearr_56250[(7)] = inst_56210__$1);

return statearr_56250;
})();
var statearr_56251_57906 = state_56233__$1;
(statearr_56251_57906[(2)] = null);

(statearr_56251_57906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57876,out))
;
return ((function (switch__53637__auto__,c__54028__auto___57876,out){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_56252 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_56252[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_56252[(1)] = (1));

return statearr_56252;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_56233){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_56233);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e56253){if((e56253 instanceof Object)){
var ex__53641__auto__ = e56253;
var statearr_56254_57908 = state_56233;
(statearr_56254_57908[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56233);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56253;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57909 = state_56233;
state_56233 = G__57909;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_56233){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_56233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57876,out))
})();
var state__54030__auto__ = (function (){var statearr_56255 = f__54029__auto__();
(statearr_56255[(6)] = c__54028__auto___57876);

return statearr_56255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57876,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__56257 = arguments.length;
switch (G__56257) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54028__auto___57916 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57916,out){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57916,out){
return (function (state_56295){
var state_val_56296 = (state_56295[(1)]);
if((state_val_56296 === (7))){
var inst_56291 = (state_56295[(2)]);
var state_56295__$1 = state_56295;
var statearr_56297_57923 = state_56295__$1;
(statearr_56297_57923[(2)] = inst_56291);

(statearr_56297_57923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (1))){
var inst_56258 = (new Array(n));
var inst_56259 = inst_56258;
var inst_56260 = (0);
var state_56295__$1 = (function (){var statearr_56298 = state_56295;
(statearr_56298[(7)] = inst_56259);

(statearr_56298[(8)] = inst_56260);

return statearr_56298;
})();
var statearr_56299_57926 = state_56295__$1;
(statearr_56299_57926[(2)] = null);

(statearr_56299_57926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (4))){
var inst_56263 = (state_56295[(9)]);
var inst_56263__$1 = (state_56295[(2)]);
var inst_56264 = (inst_56263__$1 == null);
var inst_56265 = cljs.core.not(inst_56264);
var state_56295__$1 = (function (){var statearr_56300 = state_56295;
(statearr_56300[(9)] = inst_56263__$1);

return statearr_56300;
})();
if(inst_56265){
var statearr_56301_57929 = state_56295__$1;
(statearr_56301_57929[(1)] = (5));

} else {
var statearr_56302_57930 = state_56295__$1;
(statearr_56302_57930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (15))){
var inst_56285 = (state_56295[(2)]);
var state_56295__$1 = state_56295;
var statearr_56303_57932 = state_56295__$1;
(statearr_56303_57932[(2)] = inst_56285);

(statearr_56303_57932[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (13))){
var state_56295__$1 = state_56295;
var statearr_56304_57934 = state_56295__$1;
(statearr_56304_57934[(2)] = null);

(statearr_56304_57934[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (6))){
var inst_56260 = (state_56295[(8)]);
var inst_56281 = (inst_56260 > (0));
var state_56295__$1 = state_56295;
if(cljs.core.truth_(inst_56281)){
var statearr_56305_57936 = state_56295__$1;
(statearr_56305_57936[(1)] = (12));

} else {
var statearr_56306_57937 = state_56295__$1;
(statearr_56306_57937[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (3))){
var inst_56293 = (state_56295[(2)]);
var state_56295__$1 = state_56295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56295__$1,inst_56293);
} else {
if((state_val_56296 === (12))){
var inst_56259 = (state_56295[(7)]);
var inst_56283 = cljs.core.vec.call(null,inst_56259);
var state_56295__$1 = state_56295;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56295__$1,(15),out,inst_56283);
} else {
if((state_val_56296 === (2))){
var state_56295__$1 = state_56295;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56295__$1,(4),ch);
} else {
if((state_val_56296 === (11))){
var inst_56275 = (state_56295[(2)]);
var inst_56276 = (new Array(n));
var inst_56259 = inst_56276;
var inst_56260 = (0);
var state_56295__$1 = (function (){var statearr_56307 = state_56295;
(statearr_56307[(7)] = inst_56259);

(statearr_56307[(10)] = inst_56275);

(statearr_56307[(8)] = inst_56260);

return statearr_56307;
})();
var statearr_56308_57938 = state_56295__$1;
(statearr_56308_57938[(2)] = null);

(statearr_56308_57938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (9))){
var inst_56259 = (state_56295[(7)]);
var inst_56273 = cljs.core.vec.call(null,inst_56259);
var state_56295__$1 = state_56295;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56295__$1,(11),out,inst_56273);
} else {
if((state_val_56296 === (5))){
var inst_56263 = (state_56295[(9)]);
var inst_56259 = (state_56295[(7)]);
var inst_56268 = (state_56295[(11)]);
var inst_56260 = (state_56295[(8)]);
var inst_56267 = (inst_56259[inst_56260] = inst_56263);
var inst_56268__$1 = (inst_56260 + (1));
var inst_56269 = (inst_56268__$1 < n);
var state_56295__$1 = (function (){var statearr_56309 = state_56295;
(statearr_56309[(12)] = inst_56267);

(statearr_56309[(11)] = inst_56268__$1);

return statearr_56309;
})();
if(cljs.core.truth_(inst_56269)){
var statearr_56310_57943 = state_56295__$1;
(statearr_56310_57943[(1)] = (8));

} else {
var statearr_56311_57944 = state_56295__$1;
(statearr_56311_57944[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (14))){
var inst_56288 = (state_56295[(2)]);
var inst_56289 = cljs.core.async.close_BANG_.call(null,out);
var state_56295__$1 = (function (){var statearr_56313 = state_56295;
(statearr_56313[(13)] = inst_56288);

return statearr_56313;
})();
var statearr_56314_57950 = state_56295__$1;
(statearr_56314_57950[(2)] = inst_56289);

(statearr_56314_57950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (10))){
var inst_56279 = (state_56295[(2)]);
var state_56295__$1 = state_56295;
var statearr_56315_57952 = state_56295__$1;
(statearr_56315_57952[(2)] = inst_56279);

(statearr_56315_57952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56296 === (8))){
var inst_56259 = (state_56295[(7)]);
var inst_56268 = (state_56295[(11)]);
var tmp56312 = inst_56259;
var inst_56259__$1 = tmp56312;
var inst_56260 = inst_56268;
var state_56295__$1 = (function (){var statearr_56316 = state_56295;
(statearr_56316[(7)] = inst_56259__$1);

(statearr_56316[(8)] = inst_56260);

return statearr_56316;
})();
var statearr_56317_57958 = state_56295__$1;
(statearr_56317_57958[(2)] = null);

(statearr_56317_57958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57916,out))
;
return ((function (switch__53637__auto__,c__54028__auto___57916,out){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_56318 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56318[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_56318[(1)] = (1));

return statearr_56318;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_56295){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_56295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e56319){if((e56319 instanceof Object)){
var ex__53641__auto__ = e56319;
var statearr_56320_57959 = state_56295;
(statearr_56320_57959[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56295);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56319;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57960 = state_56295;
state_56295 = G__57960;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_56295){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_56295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57916,out))
})();
var state__54030__auto__ = (function (){var statearr_56322 = f__54029__auto__();
(statearr_56322[(6)] = c__54028__auto___57916);

return statearr_56322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57916,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__56324 = arguments.length;
switch (G__56324) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54028__auto___57968 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___57968,out){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___57968,out){
return (function (state_56367){
var state_val_56368 = (state_56367[(1)]);
if((state_val_56368 === (7))){
var inst_56363 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
var statearr_56369_57969 = state_56367__$1;
(statearr_56369_57969[(2)] = inst_56363);

(statearr_56369_57969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (1))){
var inst_56325 = [];
var inst_56327 = inst_56325;
var inst_56328 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_56367__$1 = (function (){var statearr_56370 = state_56367;
(statearr_56370[(7)] = inst_56327);

(statearr_56370[(8)] = inst_56328);

return statearr_56370;
})();
var statearr_56371_57974 = state_56367__$1;
(statearr_56371_57974[(2)] = null);

(statearr_56371_57974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (4))){
var inst_56331 = (state_56367[(9)]);
var inst_56331__$1 = (state_56367[(2)]);
var inst_56332 = (inst_56331__$1 == null);
var inst_56333 = cljs.core.not(inst_56332);
var state_56367__$1 = (function (){var statearr_56372 = state_56367;
(statearr_56372[(9)] = inst_56331__$1);

return statearr_56372;
})();
if(inst_56333){
var statearr_56373_57975 = state_56367__$1;
(statearr_56373_57975[(1)] = (5));

} else {
var statearr_56374_57984 = state_56367__$1;
(statearr_56374_57984[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (15))){
var inst_56357 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
var statearr_56375_57992 = state_56367__$1;
(statearr_56375_57992[(2)] = inst_56357);

(statearr_56375_57992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (13))){
var state_56367__$1 = state_56367;
var statearr_56376_57993 = state_56367__$1;
(statearr_56376_57993[(2)] = null);

(statearr_56376_57993[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (6))){
var inst_56327 = (state_56367[(7)]);
var inst_56352 = inst_56327.length;
var inst_56353 = (inst_56352 > (0));
var state_56367__$1 = state_56367;
if(cljs.core.truth_(inst_56353)){
var statearr_56378_57996 = state_56367__$1;
(statearr_56378_57996[(1)] = (12));

} else {
var statearr_56379_57997 = state_56367__$1;
(statearr_56379_57997[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (3))){
var inst_56365 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56367__$1,inst_56365);
} else {
if((state_val_56368 === (12))){
var inst_56327 = (state_56367[(7)]);
var inst_56355 = cljs.core.vec.call(null,inst_56327);
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56367__$1,(15),out,inst_56355);
} else {
if((state_val_56368 === (2))){
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56367__$1,(4),ch);
} else {
if((state_val_56368 === (11))){
var inst_56335 = (state_56367[(10)]);
var inst_56331 = (state_56367[(9)]);
var inst_56345 = (state_56367[(2)]);
var inst_56346 = [];
var inst_56347 = inst_56346.push(inst_56331);
var inst_56327 = inst_56346;
var inst_56328 = inst_56335;
var state_56367__$1 = (function (){var statearr_56380 = state_56367;
(statearr_56380[(7)] = inst_56327);

(statearr_56380[(8)] = inst_56328);

(statearr_56380[(11)] = inst_56345);

(statearr_56380[(12)] = inst_56347);

return statearr_56380;
})();
var statearr_56381_58006 = state_56367__$1;
(statearr_56381_58006[(2)] = null);

(statearr_56381_58006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (9))){
var inst_56327 = (state_56367[(7)]);
var inst_56343 = cljs.core.vec.call(null,inst_56327);
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56367__$1,(11),out,inst_56343);
} else {
if((state_val_56368 === (5))){
var inst_56335 = (state_56367[(10)]);
var inst_56331 = (state_56367[(9)]);
var inst_56328 = (state_56367[(8)]);
var inst_56335__$1 = f.call(null,inst_56331);
var inst_56336 = cljs.core._EQ_.call(null,inst_56335__$1,inst_56328);
var inst_56337 = cljs.core.keyword_identical_QMARK_.call(null,inst_56328,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_56338 = ((inst_56336) || (inst_56337));
var state_56367__$1 = (function (){var statearr_56382 = state_56367;
(statearr_56382[(10)] = inst_56335__$1);

return statearr_56382;
})();
if(cljs.core.truth_(inst_56338)){
var statearr_56383_58022 = state_56367__$1;
(statearr_56383_58022[(1)] = (8));

} else {
var statearr_56384_58025 = state_56367__$1;
(statearr_56384_58025[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (14))){
var inst_56360 = (state_56367[(2)]);
var inst_56361 = cljs.core.async.close_BANG_.call(null,out);
var state_56367__$1 = (function (){var statearr_56386 = state_56367;
(statearr_56386[(13)] = inst_56360);

return statearr_56386;
})();
var statearr_56387_58030 = state_56367__$1;
(statearr_56387_58030[(2)] = inst_56361);

(statearr_56387_58030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (10))){
var inst_56350 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
var statearr_56388_58035 = state_56367__$1;
(statearr_56388_58035[(2)] = inst_56350);

(statearr_56388_58035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (8))){
var inst_56335 = (state_56367[(10)]);
var inst_56331 = (state_56367[(9)]);
var inst_56327 = (state_56367[(7)]);
var inst_56340 = inst_56327.push(inst_56331);
var tmp56385 = inst_56327;
var inst_56327__$1 = tmp56385;
var inst_56328 = inst_56335;
var state_56367__$1 = (function (){var statearr_56389 = state_56367;
(statearr_56389[(14)] = inst_56340);

(statearr_56389[(7)] = inst_56327__$1);

(statearr_56389[(8)] = inst_56328);

return statearr_56389;
})();
var statearr_56390_58046 = state_56367__$1;
(statearr_56390_58046[(2)] = null);

(statearr_56390_58046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto___57968,out))
;
return ((function (switch__53637__auto__,c__54028__auto___57968,out){
return (function() {
var cljs$core$async$state_machine__53638__auto__ = null;
var cljs$core$async$state_machine__53638__auto____0 = (function (){
var statearr_56391 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56391[(0)] = cljs$core$async$state_machine__53638__auto__);

(statearr_56391[(1)] = (1));

return statearr_56391;
});
var cljs$core$async$state_machine__53638__auto____1 = (function (state_56367){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_56367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e56393){if((e56393 instanceof Object)){
var ex__53641__auto__ = e56393;
var statearr_56394_58060 = state_56367;
(statearr_56394_58060[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56367);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58066 = state_56367;
state_56367 = G__58066;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
cljs$core$async$state_machine__53638__auto__ = function(state_56367){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__53638__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__53638__auto____1.call(this,state_56367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__53638__auto____0;
cljs$core$async$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__53638__auto____1;
return cljs$core$async$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___57968,out))
})();
var state__54030__auto__ = (function (){var statearr_56395 = f__54029__auto__();
(statearr_56395[(6)] = c__54028__auto___57968);

return statearr_56395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___57968,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
