goog.provide('com.wsscode.pathom.graphql');
goog.require('cljs.core');
goog.require('camel_snake_kebab.core');
goog.require('clojure.string');
goog.require('com.wsscode.pathom.misc');
goog.require('cljs.spec.alpha');
goog.require('com.wsscode.pathom.core');
com.wsscode.pathom.graphql._STAR_unbounded_recursion_count_STAR_ = (5);
com.wsscode.pathom.graphql.camel_case = (function com$wsscode$pathom$graphql$camel_case(s){
return camel_snake_kebab.core.__GT_camelCase.call(null,s);
});
com.wsscode.pathom.graphql.kebab_case = (function com$wsscode$pathom$graphql$kebab_case(s){
return camel_snake_kebab.core.__GT_kebab_case.call(null,s);
});
com.wsscode.pathom.graphql.pad_depth = (function com$wsscode$pathom$graphql$pad_depth(depth){
return clojure.string.join.call(null,cljs.core.repeat.call(null,depth,"  "));
});
com.wsscode.pathom.graphql.has_call_QMARK_ = (function com$wsscode$pathom$graphql$has_call_QMARK_(children){
return cljs.core.boolean$.call(null,cljs.core.first.call(null,cljs.core.filter.call(null,(function (p__82099){
var map__82100 = p__82099;
var map__82100__$1 = (((((!((map__82100 == null))))?(((((map__82100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82100.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82100):map__82100);
var type = cljs.core.get.call(null,map__82100__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"call","call",-519999866),type);
}),children)));
});
com.wsscode.pathom.graphql.find_id = (function com$wsscode$pathom$graphql$find_id(m,tempid_QMARK_){
return cljs.core.first.call(null,cljs.core.filter.call(null,(function (p__82102){
var vec__82103 = p__82102;
var _ = cljs.core.nth.call(null,vec__82103,(0),null);
var v = cljs.core.nth.call(null,vec__82103,(1),null);
return tempid_QMARK_.call(null,v);
}),m));
});
com.wsscode.pathom.graphql.stringify = (function com$wsscode$pathom$graphql$stringify(x){
return JSON.stringify((function (){var G__82106 = cljs.core.clj__GT_js.call(null,x);
if(cljs.core.uuid_QMARK_.call(null,x)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__82106);
} else {
return G__82106;
}
})());
});
com.wsscode.pathom.graphql.params__GT_graphql = (function com$wsscode$pathom$graphql$params__GT_graphql(var_args){
var G__82110 = arguments.length;
switch (G__82110) {
case 3:
return com.wsscode.pathom.graphql.params__GT_graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return com.wsscode.pathom.graphql.params__GT_graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.graphql.params__GT_graphql.cljs$core$IFn$_invoke$arity$3 = (function (x,js_name,tempid_QMARK_){
return com.wsscode.pathom.graphql.params__GT_graphql.call(null,x,js_name,tempid_QMARK_,true);
});

com.wsscode.pathom.graphql.params__GT_graphql.cljs$core$IFn$_invoke$arity$4 = (function (x,js_name,tempid_QMARK_,root_QMARK_){
if(cljs.core.map_QMARK_.call(null,x)){
var params = clojure.string.join.call(null,", ",cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.comp.call(null,cljs.core.remove.call(null,(function (p__82115){
var vec__82116 = p__82115;
var _ = cljs.core.nth.call(null,vec__82116,(0),null);
var v = cljs.core.nth.call(null,vec__82116,(1),null);
return tempid_QMARK_.call(null,v);
})),cljs.core.map.call(null,(function (p__82119){
var vec__82121 = p__82119;
var k = cljs.core.nth.call(null,vec__82121,(0),null);
var v = cljs.core.nth.call(null,vec__82121,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_name.call(null,k)),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.params__GT_graphql.call(null,v,js_name,tempid_QMARK_,false))].join('');
}))),x));
if(cljs.core.truth_(root_QMARK_)){
return ["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params),")"].join('');
} else {
return ["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params),"}"].join('');
}
} else {
if(cljs.core.sequential_QMARK_.call(null,x)){
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,", ",cljs.core.mapv.call(null,(function (p1__82107_SHARP_){
return com.wsscode.pathom.graphql.params__GT_graphql.call(null,p1__82107_SHARP_,js_name,tempid_QMARK_,false);
}),x))),"]"].join('');
} else {
if((x instanceof cljs.core.Symbol)){
return cljs.core.name.call(null,x);
} else {
return com.wsscode.pathom.graphql.stringify.call(null,x);

}
}
}
});

com.wsscode.pathom.graphql.params__GT_graphql.cljs$lang$maxFixedArity = 4;

/**
 * Convert ident like [:Contact/by-id 123] to an usable GraphQL alias (eg: _COLON_Contact_SLASH_by_id_123).
 */
com.wsscode.pathom.graphql.ident__GT_alias = (function com$wsscode$pathom$graphql$ident__GT_alias(p__82130){
var vec__82131 = p__82130;
var base = cljs.core.nth.call(null,vec__82131,(0),null);
var value = cljs.core.nth.call(null,vec__82131,(1),null);
var value__$1 = ((cljs.core.vector_QMARK_.call(null,value))?clojure.string.join.call(null,"_",value):value);
return clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(base),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value__$1)].join(''),/[^a-zA-Z0-9_]/,"_");
});
com.wsscode.pathom.graphql.ident_transform = (function com$wsscode$pathom$graphql$ident_transform(p__82134){
var vec__82135 = p__82134;
var key = cljs.core.nth.call(null,vec__82135,(0),null);
var value = cljs.core.nth.call(null,vec__82135,(1),null);
var fields = (function (){var temp__5718__auto__ = cljs.core.name.call(null,key);
if(cljs.core.truth_(temp__5718__auto__)){
var field_part = temp__5718__auto__;
return clojure.string.split.call(null,field_part,/-and-|And/);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["id"], null);
}
})();
var value__$1 = ((cljs.core.vector_QMARK_.call(null,value))?value:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [value], null));
if((!(cljs.core._EQ_.call(null,cljs.core.count.call(null,fields),cljs.core.count.call(null,value__$1))))){
throw cljs.core.ex_info.call(null,"The number of fields on value needs to match the entries",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"value","value",305978217),value__$1], null));
} else {
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.graphql","selector","com.wsscode.pathom.graphql/selector",-564918133),cljs.core.last.call(null,clojure.string.split.call(null,cljs.core.namespace.call(null,key),/\./)),new cljs.core.Keyword("com.wsscode.pathom.graphql","params","com.wsscode.pathom.graphql/params",1698880382),cljs.core.zipmap.call(null,fields,value__$1)], null);
});
com.wsscode.pathom.graphql.group_inline_unions = (function com$wsscode$pathom$graphql$group_inline_unions(children){
var map__82151 = cljs.core.group_by.call(null,(function (p1__82145_SHARP_){
return cljs.core.get_in.call(null,p1__82145_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword("com.wsscode.pathom.graphql","on","com.wsscode.pathom.graphql/on",1244976995)], null));
}),children);
var map__82151__$1 = (((((!((map__82151 == null))))?(((((map__82151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82151.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82151):map__82151);
var groups = map__82151__$1;
var general = cljs.core.get.call(null,map__82151__$1,null);
var groups__$1 = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (map__82151,map__82151__$1,groups,general){
return (function (p__82161){
var vec__82163 = p__82161;
var k = cljs.core.nth.call(null,vec__82163,(0),null);
var v = cljs.core.nth.call(null,vec__82163,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"union-entry","union-entry",223335750),new cljs.core.Keyword(null,"union-key","union-key",1529707234),k,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.mapv.call(null,((function (vec__82163,k,v,map__82151,map__82151__$1,groups,general){
return (function (p1__82146_SHARP_){
return cljs.core.update.call(null,p1__82146_SHARP_,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.dissoc,new cljs.core.Keyword("com.wsscode.pathom.graphql","on","com.wsscode.pathom.graphql/on",1244976995));
});})(vec__82163,k,v,map__82151,map__82151__$1,groups,general))
,v)], null);
});})(map__82151,map__82151__$1,groups,general))
),cljs.core.dissoc.call(null,groups,null));
return cljs.core.concat.call(null,general,groups__$1);
});
com.wsscode.pathom.graphql.special_params = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.graphql","on","com.wsscode.pathom.graphql/on",1244976995),null,new cljs.core.Keyword("com.wsscode.pathom.graphql","alias","com.wsscode.pathom.graphql/alias",-1051418195),null], null), null);
com.wsscode.pathom.graphql.node__GT_graphql = (function com$wsscode$pathom$graphql$node__GT_graphql(p__82178){
var map__82180 = p__82178;
var map__82180__$1 = (((((!((map__82180 == null))))?(((((map__82180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82180.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82180):map__82180);
var tempid_QMARK_ = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","tempid?","com.wsscode.pathom.graphql/tempid?",1423381701),cljs.core.constantly.call(null,false));
var query = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var children = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var union_key = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword(null,"union-key","union-key",1529707234));
var parent_children = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","parent-children","com.wsscode.pathom.graphql/parent-children",-986285872));
var key = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var params = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword(null,"params","params",710516235));
var type = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var js_name = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576));
var dispatch_key = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510));
var ident_transform = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546));
var depth = cljs.core.get.call(null,map__82180__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","depth","com.wsscode.pathom.graphql/depth",-1398356279),(0));
var continue$ = ((function (map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth){
return (function() {
var com$wsscode$pathom$graphql$node__GT_graphql_$_continue = null;
var com$wsscode$pathom$graphql$node__GT_graphql_$_continue__1 = (function (x){
return com$wsscode$pathom$graphql$node__GT_graphql_$_continue.call(null,x,cljs.core.inc);
});
var com$wsscode$pathom$graphql$node__GT_graphql_$_continue__2 = (function (x,depth_iterate){
return com.wsscode.pathom.graphql.node__GT_graphql.call(null,cljs.core.assoc.call(null,x,new cljs.core.Keyword("com.wsscode.pathom.graphql","depth","com.wsscode.pathom.graphql/depth",-1398356279),depth_iterate.call(null,depth),new cljs.core.Keyword("com.wsscode.pathom.graphql","parent-children","com.wsscode.pathom.graphql/parent-children",-986285872),(function (){var or__4131__auto__ = new cljs.core.Keyword("com.wsscode.pathom.graphql","parent-children","com.wsscode.pathom.graphql/parent-children",-986285872).cljs$core$IFn$_invoke$arity$1(x);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return children;
}
})(),new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576),js_name,new cljs.core.Keyword("com.wsscode.pathom.graphql","tempid?","com.wsscode.pathom.graphql/tempid?",1423381701),tempid_QMARK_,new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546),ident_transform));
});
com$wsscode$pathom$graphql$node__GT_graphql_$_continue = function(x,depth_iterate){
switch(arguments.length){
case 1:
return com$wsscode$pathom$graphql$node__GT_graphql_$_continue__1.call(this,x);
case 2:
return com$wsscode$pathom$graphql$node__GT_graphql_$_continue__2.call(this,x,depth_iterate);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$pathom$graphql$node__GT_graphql_$_continue.cljs$core$IFn$_invoke$arity$1 = com$wsscode$pathom$graphql$node__GT_graphql_$_continue__1;
com$wsscode$pathom$graphql$node__GT_graphql_$_continue.cljs$core$IFn$_invoke$arity$2 = com$wsscode$pathom$graphql$node__GT_graphql_$_continue__2;
return com$wsscode$pathom$graphql$node__GT_graphql_$_continue;
})()
;})(map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth))
;
var map__82194 = params;
var map__82194__$1 = (((((!((map__82194 == null))))?(((((map__82194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82194.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82194):map__82194);
var alias = cljs.core.get.call(null,map__82194__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","alias","com.wsscode.pathom.graphql/alias",-1051418195));
var params__$1 = cljs.core.apply.call(null,cljs.core.dissoc,params,com.wsscode.pathom.graphql.special_params);
var G__82196 = type;
var G__82196__$1 = (((G__82196 instanceof cljs.core.Keyword))?G__82196.fqn:null);
switch (G__82196__$1) {
case "root":
return [((com.wsscode.pathom.graphql.has_call_QMARK_.call(null,children))?"mutation ":"query "),"{\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,continue$,com.wsscode.pathom.graphql.group_inline_unions.call(null,children)))),"}\n"].join('');

break;
case "join":
if(cljs.core._EQ_.call(null,(0),query)){
return "";
} else {
var header = ((cljs.core.vector_QMARK_.call(null,key))?cljs.core.assoc.call(null,ident_transform.call(null,key),new cljs.core.Keyword("com.wsscode.pathom.graphql","index","com.wsscode.pathom.graphql/index",-510846884),com.wsscode.pathom.graphql.ident__GT_alias.call(null,key)):new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("com.wsscode.pathom.graphql","index","com.wsscode.pathom.graphql/index",-510846884),alias,new cljs.core.Keyword("com.wsscode.pathom.graphql","selector","com.wsscode.pathom.graphql/selector",-564918133),dispatch_key,new cljs.core.Keyword("com.wsscode.pathom.graphql","params","com.wsscode.pathom.graphql/params",1698880382),null], null));
var params__$2 = cljs.core.merge.call(null,new cljs.core.Keyword("com.wsscode.pathom.graphql","params","com.wsscode.pathom.graphql/params",1698880382).cljs$core$IFn$_invoke$arity$1(header),params__$1);
var children__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"...","...",-1926939749,null),query))?(function (){var parent = new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.core.update_child.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"children","children",-940561982),parent_children], null),key,cljs.core.assoc,new cljs.core.Keyword(null,"query","query",-1288509510),(com.wsscode.pathom.graphql._STAR_unbounded_recursion_count_STAR_ - (1))));
return cljs.core.mapv.call(null,((function (parent,header,params__$2,G__82196,G__82196__$1,map__82194,map__82194__$1,alias,params__$1,map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth){
return (function (p1__82169_SHARP_){
return cljs.core.assoc.call(null,p1__82169_SHARP_,new cljs.core.Keyword("com.wsscode.pathom.graphql","parent-children","com.wsscode.pathom.graphql/parent-children",-986285872),parent);
});})(parent,header,params__$2,G__82196,G__82196__$1,map__82194,map__82194__$1,alias,params__$1,map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth))
,parent);
})():((cljs.core.pos_int_QMARK_.call(null,query))?(function (){var parent = new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.core.update_recursive_depth.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"children","children",-940561982),parent_children], null),key,cljs.core.dec));
return cljs.core.mapv.call(null,((function (parent,header,params__$2,G__82196,G__82196__$1,map__82194,map__82194__$1,alias,params__$1,map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth){
return (function (p1__82170_SHARP_){
return cljs.core.assoc.call(null,p1__82170_SHARP_,new cljs.core.Keyword("com.wsscode.pathom.graphql","parent-children","com.wsscode.pathom.graphql/parent-children",-986285872),parent);
});})(parent,header,params__$2,G__82196,G__82196__$1,map__82194,map__82194__$1,alias,params__$1,map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth))
,parent);
})():children
));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),(cljs.core.truth_(new cljs.core.Keyword("com.wsscode.pathom.graphql","index","com.wsscode.pathom.graphql/index",-510846884).cljs$core$IFn$_invoke$arity$1(header))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("com.wsscode.pathom.graphql","index","com.wsscode.pathom.graphql/index",-510846884).cljs$core$IFn$_invoke$arity$1(header)),": "].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_name.call(null,new cljs.core.Keyword("com.wsscode.pathom.graphql","selector","com.wsscode.pathom.graphql/selector",-564918133).cljs$core$IFn$_invoke$arity$1(header))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.seq.call(null,params__$2))?com.wsscode.pathom.graphql.params__GT_graphql.call(null,params__$2,js_name,tempid_QMARK_):null))," {\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,continue$,com.wsscode.pathom.graphql.group_inline_unions.call(null,children__$1)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),"}\n"].join('');
}

break;
case "call":
var map__82207 = params__$1;
var map__82207__$1 = (((((!((map__82207 == null))))?(((((map__82207.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82207.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82207):map__82207);
var mutate_join = cljs.core.get.call(null,map__82207__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","mutate-join","com.wsscode.pathom.graphql/mutate-join",-257946587));
var children__$1 = cljs.core.remove.call(null,cljs.core.comp.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"*","*",345799209,null),null], null), null),new cljs.core.Keyword(null,"key","key",-1516042587)),(function (){var or__4131__auto__ = (function (){var G__82214 = mutate_join;
var G__82214__$1 = (((G__82214 == null))?null:com.wsscode.pathom.core.query__GT_ast.call(null,G__82214));
if((G__82214__$1 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__82214__$1);
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return children;
}
})());
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_name.call(null,dispatch_key)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.params__GT_graphql.call(null,cljs.core.dissoc.call(null,params__$1,new cljs.core.Keyword("com.wsscode.pathom.graphql","mutate-join","com.wsscode.pathom.graphql/mutate-join",-257946587)),js_name,tempid_QMARK_)),((cljs.core.seq.call(null,children__$1))?[" {\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,continue$,children__$1))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),"}\n"].join(''):(function (){var temp__5718__auto__ = com.wsscode.pathom.graphql.find_id.call(null,params__$1,tempid_QMARK_);
if(cljs.core.truth_(temp__5718__auto__)){
var vec__82222 = temp__5718__auto__;
var k = cljs.core.nth.call(null,vec__82222,(0),null);
var _ = cljs.core.nth.call(null,vec__82222,(1),null);
return [" {\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,(depth + (1)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_name.call(null,k)),"}\n"].join('');
} else {
return null;
}
})())].join('');

break;
case "union":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),"__typename\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,((function (G__82196,G__82196__$1,map__82194,map__82194__$1,alias,params__$1,map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth){
return (function (p1__82171_SHARP_){
return continue$(p1__82171_SHARP_,cljs.core.identity);
});})(G__82196,G__82196__$1,map__82194,map__82194__$1,alias,params__$1,map__82180,map__82180__$1,tempid_QMARK_,query,children,union_key,parent_children,key,params,type,js_name,dispatch_key,ident_transform,depth))
,children)))].join('');

break;
case "union-entry":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),"... on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((typeof union_key === 'string')?union_key:js_name.call(null,union_key)))," {\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,continue$,children))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),"}\n"].join('');

break;
case "prop":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom.graphql.pad_depth.call(null,depth)),(cljs.core.truth_(alias)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),": "].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_name.call(null,dispatch_key)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.seq.call(null,params__$1))?com.wsscode.pathom.graphql.params__GT_graphql.call(null,params__$1,js_name,tempid_QMARK_):null)),"\n"].join('');

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__82196__$1)].join('')));

}
});
/**
 * Convert query from EDN format to GraphQL string.
 */
com.wsscode.pathom.graphql.query__GT_graphql = (function com$wsscode$pathom$graphql$query__GT_graphql(var_args){
var G__82230 = arguments.length;
switch (G__82230) {
case 1:
return com.wsscode.pathom.graphql.query__GT_graphql.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.graphql.query__GT_graphql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.graphql.query__GT_graphql.cljs$core$IFn$_invoke$arity$1 = (function (query){
return com.wsscode.pathom.graphql.query__GT_graphql.call(null,query,cljs.core.PersistentArrayMap.EMPTY);
});

com.wsscode.pathom.graphql.query__GT_graphql.cljs$core$IFn$_invoke$arity$2 = (function (query,options){
var ast = com.wsscode.pathom.core.query__GT_ast.call(null,query);
return com.wsscode.pathom.graphql.node__GT_graphql.call(null,cljs.core.merge.call(null,ast,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576),cljs.core.name,new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546),com.wsscode.pathom.graphql.ident_transform,new cljs.core.Keyword("com.wsscode.pathom.graphql","parent-children","com.wsscode.pathom.graphql/parent-children",-986285872),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast)], null),options));
});

com.wsscode.pathom.graphql.query__GT_graphql.cljs$lang$maxFixedArity = 2;

if(com.wsscode.pathom.misc.INCLUDE_SPECS){
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.pathom.graphql","node->graphql","com.wsscode.pathom.graphql/node->graphql",1474455173,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"input","input",556931961),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546)], null)))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"input","input",556931961),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546)], null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__82236){
return cljs.core.map_QMARK_.call(null,G__82236);
}),(function (G__82236){
return cljs.core.contains_QMARK_.call(null,G__82236,new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576));
})], null),(function (G__82236){
return ((cljs.core.map_QMARK_.call(null,G__82236)) && (cljs.core.contains_QMARK_.call(null,G__82236,new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576))));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546)], null)]))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546)], null))], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"input","input",556931961),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.graphql","ident-transform","com.wsscode.pathom.graphql/ident-transform",641409546)], null))),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));
} else {
}

//# sourceMappingURL=com.wsscode.pathom.graphql.js.map
