goog.provide('shadow.cljs.devtools.client.hud');
goog.require('cljs.core');
goog.require('shadow.dom');
goog.require('shadow.xhr');
goog.require('shadow.animate');
goog.require('shadow.cljs.devtools.client.env');
goog.require('cljs.core.async');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('clojure.string');
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.hud.show_progress = goog.define("shadow.cljs.devtools.client.hud.show_progress",true);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.hud.show_warnings = goog.define("shadow.cljs.devtools.client.hud.show_warnings",true);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.hud.show_errors = goog.define("shadow.cljs.devtools.client.hud.show_errors",true);
shadow.cljs.devtools.client.hud.open_file = (function shadow$cljs$devtools$client$hud$open_file(file,line,column){
console.log("opening file",file,line,column);

var req = shadow.xhr.chan.call(null,new cljs.core.Keyword(null,"POST","POST",110456857),[shadow.cljs.devtools.client.env.get_url_base.call(null),"/api/open-file"].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",-1269645878),file,new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),column], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false,new cljs.core.Keyword(null,"body-only","body-only",-698120682),true], null));
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__,req){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__,req){
return (function (state_63209){
var state_val_63210 = (state_63209[(1)]);
if((state_val_63210 === (7))){
var state_63209__$1 = state_63209;
var statearr_63213_63497 = state_63209__$1;
(statearr_63213_63497[(2)] = false);

(statearr_63213_63497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (1))){
var state_63209__$1 = state_63209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63209__$1,(2),req);
} else {
if((state_val_63210 === (4))){
var inst_63172 = (state_63209[(7)]);
var inst_63178 = (inst_63172 == null);
var inst_63179 = cljs.core.not(inst_63178);
var state_63209__$1 = state_63209;
if(inst_63179){
var statearr_63219_63500 = state_63209__$1;
(statearr_63219_63500[(1)] = (6));

} else {
var statearr_63221_63502 = state_63209__$1;
(statearr_63221_63502[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (15))){
var state_63209__$1 = state_63209;
var statearr_63223_63508 = state_63209__$1;
(statearr_63223_63508[(2)] = null);

(statearr_63223_63508[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (13))){
var inst_63172 = (state_63209[(7)]);
var state_63209__$1 = state_63209;
var statearr_63231_63509 = state_63209__$1;
(statearr_63231_63509[(2)] = inst_63172);

(statearr_63231_63509[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (6))){
var inst_63172 = (state_63209[(7)]);
var inst_63181 = inst_63172.cljs$lang$protocol_mask$partition0$;
var inst_63182 = (inst_63181 & (64));
var inst_63183 = inst_63172.cljs$core$ISeq$;
var inst_63184 = (cljs.core.PROTOCOL_SENTINEL === inst_63183);
var inst_63185 = ((inst_63182) || (inst_63184));
var state_63209__$1 = state_63209;
if(cljs.core.truth_(inst_63185)){
var statearr_63233_63513 = state_63209__$1;
(statearr_63233_63513[(1)] = (9));

} else {
var statearr_63236_63514 = state_63209__$1;
(statearr_63236_63514[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (17))){
var inst_63205 = (state_63209[(2)]);
var state_63209__$1 = state_63209;
var statearr_63237_63515 = state_63209__$1;
(statearr_63237_63515[(2)] = inst_63205);

(statearr_63237_63515[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (3))){
var state_63209__$1 = state_63209;
var statearr_63238_63516 = state_63209__$1;
(statearr_63238_63516[(2)] = null);

(statearr_63238_63516[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (12))){
var inst_63172 = (state_63209[(7)]);
var inst_63195 = cljs.core.apply.call(null,cljs.core.hash_map,inst_63172);
var state_63209__$1 = state_63209;
var statearr_63239_63518 = state_63209__$1;
(statearr_63239_63518[(2)] = inst_63195);

(statearr_63239_63518[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (2))){
var inst_63172 = (state_63209[(7)]);
var inst_63172__$1 = (state_63209[(2)]);
var inst_63173 = (inst_63172__$1 == null);
var state_63209__$1 = (function (){var statearr_63240 = state_63209;
(statearr_63240[(7)] = inst_63172__$1);

return statearr_63240;
})();
if(cljs.core.truth_(inst_63173)){
var statearr_63241_63525 = state_63209__$1;
(statearr_63241_63525[(1)] = (3));

} else {
var statearr_63243_63528 = state_63209__$1;
(statearr_63243_63528[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (11))){
var inst_63189 = (state_63209[(2)]);
var state_63209__$1 = state_63209;
var statearr_63246_63533 = state_63209__$1;
(statearr_63246_63533[(2)] = inst_63189);

(statearr_63246_63533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (9))){
var state_63209__$1 = state_63209;
var statearr_63247_63541 = state_63209__$1;
(statearr_63247_63541[(2)] = true);

(statearr_63247_63541[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (5))){
var inst_63207 = (state_63209[(2)]);
var state_63209__$1 = state_63209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63209__$1,inst_63207);
} else {
if((state_val_63210 === (14))){
var inst_63198 = (state_63209[(8)]);
var inst_63198__$1 = (state_63209[(2)]);
var inst_63199 = cljs.core.get.call(null,inst_63198__$1,new cljs.core.Keyword(null,"exit","exit",351849638));
var inst_63200 = (inst_63199 === (0));
var state_63209__$1 = (function (){var statearr_63256 = state_63209;
(statearr_63256[(8)] = inst_63198__$1);

return statearr_63256;
})();
if(cljs.core.truth_(inst_63200)){
var statearr_63257_63544 = state_63209__$1;
(statearr_63257_63544[(1)] = (15));

} else {
var statearr_63259_63545 = state_63209__$1;
(statearr_63259_63545[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (16))){
var inst_63198 = (state_63209[(8)]);
var inst_63203 = console.warn("file open failed",inst_63198);
var state_63209__$1 = state_63209;
var statearr_63263_63546 = state_63209__$1;
(statearr_63263_63546[(2)] = inst_63203);

(statearr_63263_63546[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (10))){
var state_63209__$1 = state_63209;
var statearr_63264_63547 = state_63209__$1;
(statearr_63264_63547[(2)] = false);

(statearr_63264_63547[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63210 === (8))){
var inst_63192 = (state_63209[(2)]);
var state_63209__$1 = state_63209;
if(cljs.core.truth_(inst_63192)){
var statearr_63265_63549 = state_63209__$1;
(statearr_63265_63549[(1)] = (12));

} else {
var statearr_63266_63551 = state_63209__$1;
(statearr_63266_63551[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__,req))
;
return ((function (switch__53637__auto__,c__54028__auto__,req){
return (function() {
var shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto__ = null;
var shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto____0 = (function (){
var statearr_63271 = [null,null,null,null,null,null,null,null,null];
(statearr_63271[(0)] = shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto__);

(statearr_63271[(1)] = (1));

return statearr_63271;
});
var shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto____1 = (function (state_63209){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_63209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e63276){if((e63276 instanceof Object)){
var ex__53641__auto__ = e63276;
var statearr_63277_63556 = state_63209;
(statearr_63277_63556[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63209);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63276;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63560 = state_63209;
state_63209 = G__63560;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto__ = function(state_63209){
switch(arguments.length){
case 0:
return shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto____0.call(this);
case 1:
return shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto____1.call(this,state_63209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto____0;
shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto____1;
return shadow$cljs$devtools$client$hud$open_file_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__,req))
})();
var state__54030__auto__ = (function (){var statearr_63281 = f__54029__auto__();
(statearr_63281[(6)] = c__54028__auto__);

return statearr_63281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__,req))
);

return c__54028__auto__;
});
shadow.cljs.devtools.client.hud.dom_insert = (function shadow$cljs$devtools$client$hud$dom_insert(var_args){
var G__63286 = arguments.length;
switch (G__63286) {
case 1:
return shadow.cljs.devtools.client.hud.dom_insert.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.cljs.devtools.client.hud.dom_insert.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.cljs.devtools.client.hud.dom_insert.cljs$core$IFn$_invoke$arity$1 = (function (node){
return shadow.cljs.devtools.client.hud.dom_insert.call(null,document.body,node);
});

shadow.cljs.devtools.client.hud.dom_insert.cljs$core$IFn$_invoke$arity$2 = (function (where,node){
var el = shadow.dom.dom_node.call(null,node);
var id = el.id;
if(cljs.core.seq.call(null,id)){
} else {
throw (new Error("Assert failed: (seq id)"));
}

var temp__5724__auto___63572 = shadow.dom.by_id.call(null,id);
if((temp__5724__auto___63572 == null)){
} else {
var x_63573 = temp__5724__auto___63572;
shadow.dom.remove.call(null,x_63573);
}

return shadow.dom.append.call(null,where,el);
});

shadow.cljs.devtools.client.hud.dom_insert.cljs$lang$maxFixedArity = 2;

shadow.cljs.devtools.client.hud.hud_id = "shadow-hud-container";
shadow.cljs.devtools.client.hud.load_id = "shadow-hud-loading-container";
shadow.cljs.devtools.client.hud.logo_svg = (new cljs.core.Delay((function (){
var s_path = "M247.183941,141.416413 C247.183941,74.7839971 148.383423,78.9723529 148.383423,141.416413 C148.383423,203.860473 265.090698,171.864644 265.090698,248.900057 C265.090698,325.93547 135,325.851749 135,251.708304";
return shadow.dom.svg.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),"shadow-cljs-logo",new cljs.core.Keyword(null,"version","version",425292698),"1.1",new cljs.core.Keyword(null,"viewBox","viewBox",-469489477),"0 0 400 400",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"block"], null),new cljs.core.Keyword(null,"height","height",1025178622),"60px",new cljs.core.Keyword(null,"width","width",-384071477),"60px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"title","title",636505583),"shadow-cljs"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mask#shadow-cljs-logo-mask","mask#shadow-cljs-logo-mask",1690487509),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fill","fill",883462889),"#fff"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"circle","circle",1903212362),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"r","r",-471384190),"200",new cljs.core.Keyword(null,"cy","cy",755331060),"200",new cljs.core.Keyword(null,"cx","cx",1272694324),"200"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fill-rule","fill-rule",-1824841598),"evenodd",new cljs.core.Keyword(null,"fill","fill",883462889),"none",new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),"0",new cljs.core.Keyword(null,"stroke","stroke",1741823555),"none",new cljs.core.Keyword(null,"mask","mask",-585748447),"url(#shadow-cljs-logo-mask)"], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.circles","g.circles",374463200),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"circle.blue","circle.blue",1902916291),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"r","r",-471384190),"200",new cljs.core.Keyword(null,"cy","cy",755331060),"200",new cljs.core.Keyword(null,"cx","cx",1272694324),"200",new cljs.core.Keyword(null,"fill","fill",883462889),"#4F80DF"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"circle.light-blue","circle.light-blue",438137342),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"r","r",-471384190),"71.5",new cljs.core.Keyword(null,"cy","cy",755331060),"200",new cljs.core.Keyword(null,"cx","cx",1272694324),"370",new cljs.core.Keyword(null,"fill","fill",883462889),"#89B4FF"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"circle.dark-green","circle.dark-green",608465767),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"r","r",-471384190),"180",new cljs.core.Keyword(null,"cy","cy",755331060),"360",new cljs.core.Keyword(null,"cx","cx",1272694324),"60",new cljs.core.Keyword(null,"fill","fill",883462889),"#40B400"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"circle.light-green","circle.light-green",-1663041285),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"r","r",-471384190),"129",new cljs.core.Keyword(null,"cy","cy",755331060),"320",new cljs.core.Keyword(null,"cx","cx",1272694324),"280",new cljs.core.Keyword(null,"fill","fill",883462889),"#76E013"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"animateTransform","animateTransform",759329815),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"attributeType","attributeType",1055561918),"xml",new cljs.core.Keyword(null,"attributeName","attributeName",-400177890),"transform",new cljs.core.Keyword(null,"type","type",1174270348),"rotate",new cljs.core.Keyword(null,"from","from",1815293044),"0 200 200",new cljs.core.Keyword(null,"to","to",192099007),"360 200 200",new cljs.core.Keyword(null,"dur","dur",1464522452),"3s",new cljs.core.Keyword(null,"repeatCount","repeatCount",1447663848),"indefinite"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),"translate(10,10)"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"stroke-linecap","stroke-linecap",-1201103248),"square",new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),"16",new cljs.core.Keyword(null,"stroke","stroke",1741823555),"#aaa",new cljs.core.Keyword(null,"d","d",1972142424),s_path], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"stroke-linecap","stroke-linecap",-1201103248),"square",new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),"16",new cljs.core.Keyword(null,"stroke","stroke",1741823555),"#FFFFFF",new cljs.core.Keyword(null,"d","d",1972142424),s_path], null)], null)], null));
}),null));
shadow.cljs.devtools.client.hud.load_start = (function shadow$cljs$devtools$client$hud$load_start(){
if(shadow.cljs.devtools.client.hud.show_progress){
return shadow.cljs.devtools.client.hud.dom_insert.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),shadow.cljs.devtools.client.hud.load_id,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),"fixed",new cljs.core.Keyword(null,"pointer-events","pointer-events",-1053858853),"none",new cljs.core.Keyword(null,"left","left",-399115937),"0px",new cljs.core.Keyword(null,"bottom","bottom",-1550509018),"20px",new cljs.core.Keyword(null,"z-index","z-index",1892827090),"10000"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),"#eee",new cljs.core.Keyword(null,"border-top-right-radius","border-top-right-radius",1678770792),"40px",new cljs.core.Keyword(null,"border-bottom-right-radius","border-bottom-right-radius",414899772),"40px",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"2px 2px 10px #aaa",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),cljs.core.deref.call(null,shadow.cljs.devtools.client.hud.logo_svg)], null)], null));
} else {
return null;
}
});
shadow.cljs.devtools.client.hud.load_end_success = (function shadow$cljs$devtools$client$hud$load_end_success(){
if(shadow.cljs.devtools.client.hud.show_progress){
var temp__5724__auto__ = shadow.dom.by_id.call(null,shadow.cljs.devtools.client.hud.load_id);
if((temp__5724__auto__ == null)){
return null;
} else {
var container_el = temp__5724__auto__;
var el = container_el.firstChild;
shadow.animate.start.call(null,(500),cljs.core.PersistentArrayMap.createAsIfByAssoc([el,shadow.animate.transition.call(null,new cljs.core.Keyword(null,"background","background",-863952629),"#eee","#40B400","ease-out")]));

var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__,el,container_el,temp__5724__auto__){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__,el,container_el,temp__5724__auto__){
return (function (state_63322){
var state_val_63323 = (state_63322[(1)]);
if((state_val_63323 === (1))){
var inst_63310 = cljs.core.async.timeout.call(null,(250));
var state_63322__$1 = state_63322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63322__$1,(2),inst_63310);
} else {
if((state_val_63323 === (2))){
var inst_63312 = (state_63322[(2)]);
var inst_63313 = [el];
var inst_63314 = shadow.animate.transition.call(null,new cljs.core.Keyword(null,"opacity","opacity",397153780),"1","0","ease-in");
var inst_63315 = [inst_63314];
var inst_63316 = cljs.core.PersistentHashMap.fromArrays(inst_63313,inst_63315);
var inst_63317 = shadow.animate.start.call(null,(250),inst_63316);
var state_63322__$1 = (function (){var statearr_63328 = state_63322;
(statearr_63328[(7)] = inst_63312);

return statearr_63328;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63322__$1,(3),inst_63317);
} else {
if((state_val_63323 === (3))){
var inst_63319 = (state_63322[(2)]);
var inst_63320 = shadow.dom.remove.call(null,container_el);
var state_63322__$1 = (function (){var statearr_63334 = state_63322;
(statearr_63334[(8)] = inst_63319);

return statearr_63334;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63322__$1,inst_63320);
} else {
return null;
}
}
}
});})(c__54028__auto__,el,container_el,temp__5724__auto__))
;
return ((function (switch__53637__auto__,c__54028__auto__,el,container_el,temp__5724__auto__){
return (function() {
var shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto__ = null;
var shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto____0 = (function (){
var statearr_63341 = [null,null,null,null,null,null,null,null,null];
(statearr_63341[(0)] = shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto__);

(statearr_63341[(1)] = (1));

return statearr_63341;
});
var shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto____1 = (function (state_63322){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_63322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e63343){if((e63343 instanceof Object)){
var ex__53641__auto__ = e63343;
var statearr_63344_63618 = state_63322;
(statearr_63344_63618[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63322);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63343;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63622 = state_63322;
state_63322 = G__63622;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto__ = function(state_63322){
switch(arguments.length){
case 0:
return shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto____0.call(this);
case 1:
return shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto____1.call(this,state_63322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto____0;
shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto____1;
return shadow$cljs$devtools$client$hud$load_end_success_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__,el,container_el,temp__5724__auto__))
})();
var state__54030__auto__ = (function (){var statearr_63347 = f__54029__auto__();
(statearr_63347[(6)] = c__54028__auto__);

return statearr_63347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__,el,container_el,temp__5724__auto__))
);

return c__54028__auto__;
}
} else {
return null;
}
});
shadow.cljs.devtools.client.hud.load_end = (function shadow$cljs$devtools$client$hud$load_end(){
var temp__5724__auto__ = shadow.dom.by_id.call(null,shadow.cljs.devtools.client.hud.load_id);
if((temp__5724__auto__ == null)){
return null;
} else {
var el = temp__5724__auto__;
return shadow.dom.remove.call(null,el);
}
});
shadow.cljs.devtools.client.hud.hud_hide = (function shadow$cljs$devtools$client$hud$hud_hide(){
var temp__5724__auto__ = shadow.dom.by_id.call(null,shadow.cljs.devtools.client.hud.hud_id);
if((temp__5724__auto__ == null)){
return null;
} else {
var d = temp__5724__auto__;
return shadow.dom.remove.call(null,d);
}
});
shadow.cljs.devtools.client.hud.source_line_styles = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0",new cljs.core.Keyword(null,"margin","margin",-995903681),"0"], null);
shadow.cljs.devtools.client.hud.source_highlight_styles = cljs.core.assoc.call(null,shadow.cljs.devtools.client.hud.source_line_styles,new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold");
shadow.cljs.devtools.client.hud.source_line_html = (function shadow$cljs$devtools$client$hud$source_line_html(start_idx,lines,styles){
var iter__4523__auto__ = (function shadow$cljs$devtools$client$hud$source_line_html_$_iter__63364(s__63365){
return (new cljs.core.LazySeq(null,(function (){
var s__63365__$1 = s__63365;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__63365__$1);
if(temp__5720__auto__){
var s__63365__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__63365__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__63365__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__63367 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__63366 = (0);
while(true){
if((i__63366 < size__4522__auto__)){
var vec__63369 = cljs.core._nth(c__4521__auto__,i__63366);
var idx = cljs.core.nth.call(null,vec__63369,(0),null);
var text = cljs.core.nth.call(null,vec__63369,(1),null);
cljs.core.chunk_append.call(null,b__63367,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),styles], null),goog.string.format("%4d | %s",(((1) + idx) + start_idx),text)], null));

var G__63640 = (i__63366 + (1));
i__63366 = G__63640;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63367),shadow$cljs$devtools$client$hud$source_line_html_$_iter__63364.call(null,cljs.core.chunk_rest.call(null,s__63365__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63367),null);
}
} else {
var vec__63375 = cljs.core.first.call(null,s__63365__$2);
var idx = cljs.core.nth.call(null,vec__63375,(0),null);
var text = cljs.core.nth.call(null,vec__63375,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),styles], null),goog.string.format("%4d | %s",(((1) + idx) + start_idx),text)], null),shadow$cljs$devtools$client$hud$source_line_html_$_iter__63364.call(null,cljs.core.rest.call(null,s__63365__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(cljs.core.map_indexed.call(null,cljs.core.vector,lines));
});
shadow.cljs.devtools.client.hud.sep_length = (80);
shadow.cljs.devtools.client.hud.sep_line = (function shadow$cljs$devtools$client$hud$sep_line(var_args){
var G__63380 = arguments.length;
switch (G__63380) {
case 0:
return shadow.cljs.devtools.client.hud.sep_line.cljs$core$IFn$_invoke$arity$0();

break;
case 2:
return shadow.cljs.devtools.client.hud.sep_line.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.cljs.devtools.client.hud.sep_line.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.cljs.devtools.client.hud.sep_line.call(null,"",(0));
});

shadow.cljs.devtools.client.hud.sep_line.cljs$core$IFn$_invoke$arity$2 = (function (label,offset){
var sep_len = Math.max(shadow.cljs.devtools.client.hud.sep_length,offset);
var len = cljs.core.count.call(null,label);
var sep = ((function (sep_len,len){
return (function (c){
return clojure.string.join.call(null,"",cljs.core.repeat.call(null,c,"-"));
});})(sep_len,len))
;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep(offset)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(label),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep((sep_len - (offset + len))))].join('');
});

shadow.cljs.devtools.client.hud.sep_line.cljs$lang$maxFixedArity = 2;

shadow.cljs.devtools.client.hud.file_link = (function shadow$cljs$devtools$client$hud$file_link(p__63390){
var map__63391 = p__63390;
var map__63391__$1 = (((((!((map__63391 == null))))?(((((map__63391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63391):map__63391);
var warning = map__63391__$1;
var resource_name = cljs.core.get.call(null,map__63391__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var file = cljs.core.get.call(null,map__63391__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__63391__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__63391__$1,new cljs.core.Keyword(null,"column","column",2078222095));
if(cljs.core.not(file)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),resource_name], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"text-decoration","text-decoration",1836813207),"underline",new cljs.core.Keyword(null,"color","color",1011675173),"blue",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null),new cljs.core.Keyword(null,"on","on",173873944),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"click","click",1912301393),((function (map__63391,map__63391__$1,warning,resource_name,file,line,column){
return (function (e){
shadow.dom.ev_stop.call(null,e);

return shadow.cljs.devtools.client.hud.open_file.call(null,file,line,column);
});})(map__63391,map__63391__$1,warning,resource_name,file,line,column))
], null)], null),resource_name], null);
}
});
shadow.cljs.devtools.client.hud.html_for_warning = (function shadow$cljs$devtools$client$hud$html_for_warning(p__63398){
var map__63399 = p__63398;
var map__63399__$1 = (((((!((map__63399 == null))))?(((((map__63399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63399.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63399):map__63399);
var warning = map__63399__$1;
var resource_name = cljs.core.get.call(null,map__63399__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var msg = cljs.core.get.call(null,map__63399__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var file = cljs.core.get.call(null,map__63399__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__63399__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__63399__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var source_excerpt = cljs.core.get.call(null,map__63399__$1,new cljs.core.Keyword(null,"source-excerpt","source-excerpt",5665576));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"border","border",1444987323),"2px solid #ccc",new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"10px"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"line-height","line-height",1870784992),"16px",new cljs.core.Keyword(null,"background-color","background-color",570434026),"#fadb64",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.2em",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"WARNING in "], null),shadow.cljs.devtools.client.hud.file_link.call(null,warning)], null),(cljs.core.truth_(source_excerpt)?(function (){var map__63402 = source_excerpt;
var map__63402__$1 = (((((!((map__63402 == null))))?(((((map__63402.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63402.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63402):map__63402);
var start_idx = cljs.core.get.call(null,map__63402__$1,new cljs.core.Keyword(null,"start-idx","start-idx",-1600773745));
var before = cljs.core.get.call(null,map__63402__$1,new cljs.core.Keyword(null,"before","before",-1633692388));
var line__$1 = cljs.core.get.call(null,map__63402__$1,new cljs.core.Keyword(null,"line","line",212345235));
var after = cljs.core.get.call(null,map__63402__$1,new cljs.core.Keyword(null,"after","after",594996914));
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"padding","padding",1660304693),"10px 10px",new cljs.core.Keyword(null,"background-color","background-color",570434026),"#fff",new cljs.core.Keyword(null,"border-top","border-top",-158897573),"2px solid #ccc"], null)], null),shadow.cljs.devtools.client.hud.source_line_html.call(null,start_idx,before,shadow.cljs.devtools.client.hud.source_line_styles),shadow.cljs.devtools.client.hud.source_line_html.call(null,(start_idx + cljs.core.count.call(null,before)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line__$1], null),shadow.cljs.devtools.client.hud.source_highlight_styles),(function (){var arrow_idx = ((6) + (function (){var or__4131__auto__ = column;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})());
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),shadow.cljs.devtools.client.hud.source_highlight_styles], null),shadow.cljs.devtools.client.hud.sep_line.call(null,"^",arrow_idx)], null);
})(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.2em",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px 0"], null)], null),msg], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),shadow.cljs.devtools.client.hud.source_highlight_styles], null),shadow.cljs.devtools.client.hud.sep_line.call(null)], null),shadow.cljs.devtools.client.hud.source_line_html.call(null,((start_idx + cljs.core.count.call(null,before)) + (1)),after,shadow.cljs.devtools.client.hud.source_line_styles)], null);
})():null)], null);
});
shadow.cljs.devtools.client.hud.hud_warnings = (function shadow$cljs$devtools$client$hud$hud_warnings(p__63412){
var map__63413 = p__63412;
var map__63413__$1 = (((((!((map__63413 == null))))?(((((map__63413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63413.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63413):map__63413);
var msg = map__63413__$1;
var type = cljs.core.get.call(null,map__63413__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var info = cljs.core.get.call(null,map__63413__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var map__63418 = info;
var map__63418__$1 = (((((!((map__63418 == null))))?(((((map__63418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63418.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63418):map__63418);
var sources = cljs.core.get.call(null,map__63418__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var sources_with_warnings = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,((function (map__63418,map__63418__$1,sources,map__63413,map__63413__$1,msg,type,info){
return (function (p1__63408_SHARP_){
return cljs.core.seq.call(null,new cljs.core.Keyword(null,"warnings","warnings",-735437651).cljs$core$IFn$_invoke$arity$1(p1__63408_SHARP_));
});})(map__63418,map__63418__$1,sources,map__63413,map__63413__$1,msg,type,info))
,cljs.core.remove.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827),sources)));
if(cljs.core.seq.call(null,sources_with_warnings)){
shadow.cljs.devtools.client.hud.load_end.call(null);

if(shadow.cljs.devtools.client.hud.show_warnings){
return shadow.cljs.devtools.client.hud.dom_insert.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),shadow.cljs.devtools.client.hud.hud_id,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),new cljs.core.Keyword(null,"left","left",-399115937)],["#000","0px","12px","10000","0px","flex","fixed","monospace","column","0px"])], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"align-self","align-self",1475936794),"flex-end",new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"border","border",1444987323),"2px solid #ccc",new cljs.core.Keyword(null,"border-bottom","border-bottom",2110948415),"0px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"padding","padding",1660304693),"6px",new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"-2px",new cljs.core.Keyword(null,"z-index","z-index",1892827090),"10000"], null),new cljs.core.Keyword(null,"on","on",173873944),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"click","click",1912301393),shadow.cljs.devtools.client.hud.hud_hide], null)], null),"Close"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"border-top","border-top",-158897573),"2px solid #ccc",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"max-height","max-height",-612563804),"300px",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px 10px 0",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto"], null)], null),(function (){var iter__4523__auto__ = ((function (map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info){
return (function shadow$cljs$devtools$client$hud$hud_warnings_$_iter__63428(s__63429){
return (new cljs.core.LazySeq(null,((function (map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info){
return (function (){
var s__63429__$1 = s__63429;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__63429__$1);
if(temp__5720__auto__){
var xs__6277__auto__ = temp__5720__auto__;
var map__63444 = cljs.core.first.call(null,xs__6277__auto__);
var map__63444__$1 = (((((!((map__63444 == null))))?(((((map__63444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63444.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63444):map__63444);
var warnings = cljs.core.get.call(null,map__63444__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
var iterys__4519__auto__ = ((function (s__63429__$1,map__63444,map__63444__$1,warnings,xs__6277__auto__,temp__5720__auto__,map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info){
return (function shadow$cljs$devtools$client$hud$hud_warnings_$_iter__63428_$_iter__63430(s__63431){
return (new cljs.core.LazySeq(null,((function (s__63429__$1,map__63444,map__63444__$1,warnings,xs__6277__auto__,temp__5720__auto__,map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info){
return (function (){
var s__63431__$1 = s__63431;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__63431__$1);
if(temp__5720__auto____$1){
var s__63431__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__63431__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__63431__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__63433 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__63432 = (0);
while(true){
if((i__63432 < size__4522__auto__)){
var warning = cljs.core._nth(c__4521__auto__,i__63432);
cljs.core.chunk_append.call(null,b__63433,shadow.cljs.devtools.client.hud.html_for_warning.call(null,warning));

var G__63744 = (i__63432 + (1));
i__63432 = G__63744;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63433),shadow$cljs$devtools$client$hud$hud_warnings_$_iter__63428_$_iter__63430.call(null,cljs.core.chunk_rest.call(null,s__63431__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63433),null);
}
} else {
var warning = cljs.core.first.call(null,s__63431__$2);
return cljs.core.cons.call(null,shadow.cljs.devtools.client.hud.html_for_warning.call(null,warning),shadow$cljs$devtools$client$hud$hud_warnings_$_iter__63428_$_iter__63430.call(null,cljs.core.rest.call(null,s__63431__$2)));
}
} else {
return null;
}
break;
}
});})(s__63429__$1,map__63444,map__63444__$1,warnings,xs__6277__auto__,temp__5720__auto__,map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info))
,null,null));
});})(s__63429__$1,map__63444,map__63444__$1,warnings,xs__6277__auto__,temp__5720__auto__,map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info))
;
var fs__4520__auto__ = cljs.core.seq.call(null,iterys__4519__auto__(warnings));
if(fs__4520__auto__){
return cljs.core.concat.call(null,fs__4520__auto__,shadow$cljs$devtools$client$hud$hud_warnings_$_iter__63428.call(null,cljs.core.rest.call(null,s__63429__$1)));
} else {
var G__63747 = cljs.core.rest.call(null,s__63429__$1);
s__63429__$1 = G__63747;
continue;
}
} else {
return null;
}
break;
}
});})(map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info))
,null,null));
});})(map__63418,map__63418__$1,sources,sources_with_warnings,map__63413,map__63413__$1,msg,type,info))
;
return iter__4523__auto__(sources_with_warnings);
})()], null)], null));
} else {
return null;
}
} else {
return null;
}
});
shadow.cljs.devtools.client.hud.hud_error = (function shadow$cljs$devtools$client$hud$hud_error(p__63470){
var map__63472 = p__63470;
var map__63472__$1 = (((((!((map__63472 == null))))?(((((map__63472.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63472.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63472):map__63472);
var msg = map__63472__$1;
var report = cljs.core.get.call(null,map__63472__$1,new cljs.core.Keyword(null,"report","report",1394055010));
if(shadow.cljs.devtools.client.hud.show_errors){
return shadow.cljs.devtools.client.hud.dom_insert.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),shadow.cljs.devtools.client.hud.hud_id,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"overflow","overflow",2058931880),new cljs.core.Keyword(null,"background-color","background-color",570434026),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"left","left",-399115937)],["#000","0px","12px","0px","auto","#fff","10000","20px","0px","fixed","5px solid red","monospace","0px"])], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),"color: red; margin-bottom: 10px; font-size: 2em;"], null),"Compilation failed!"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),report], null)], null));
} else {
return null;
}
});
shadow.cljs.devtools.client.hud.connection_error_id = "shadow-connection-error";
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_ = (function shadow$cljs$devtools$client$hud$connection_error_clear_BANG_(){
var temp__5724__auto__ = shadow.dom.by_id.call(null,shadow.cljs.devtools.client.hud.connection_error_id);
if((temp__5724__auto__ == null)){
return null;
} else {
var x = temp__5724__auto__;
return shadow.dom.remove.call(null,x);
}
});
shadow.cljs.devtools.client.hud.connection_error = (function shadow$cljs$devtools$client$hud$connection_error(msg){
if(shadow.cljs.devtools.client.hud.show_errors){
return shadow.cljs.devtools.client.hud.dom_insert.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),shadow.cljs.devtools.client.hud.connection_error_id,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),"fixed",new cljs.core.Keyword(null,"pointer-events","pointer-events",-1053858853),"none",new cljs.core.Keyword(null,"left","left",-399115937),"0px",new cljs.core.Keyword(null,"bottom","bottom",-1550509018),"20px",new cljs.core.Keyword(null,"z-index","z-index",1892827090),"10000"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"border-top-right-radius","border-top-right-radius",1678770792),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"border-bottom-right-radius","border-bottom-right-radius",414899772),new cljs.core.Keyword(null,"font-family","font-family",-667419874)],["2px 2px 10px #aaa","#fff","14px","bold","40px","#c00","10px","40px","monospace"])], null),["shadow-cljs - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null)], null));
} else {
return null;
}
});
shadow.cljs.devtools.client.hud.load_failure = (function shadow$cljs$devtools$client$hud$load_failure(error,task,remaining){
shadow.cljs.devtools.client.hud.load_end.call(null);

console.error("reload-failed",error);

return shadow.cljs.devtools.client.hud.connection_error.call(null,["[reload failed] ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(error.message)].join(''));
});

//# sourceMappingURL=shadow.cljs.devtools.client.hud.js.map
