goog.provide('nubank.workspaces.ui');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('cljs.pprint');
goog.require('cognitect.transit');
goog.require('fulcro_css.css_injection');
goog.require('fulcro.client.localized_dom');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.primitives');
goog.require('goog.object');
goog.require('nubank.workspaces.data');
goog.require('nubank.workspaces.lib.local_storage');
goog.require('nubank.workspaces.model');
goog.require('nubank.workspaces.ui.core');
goog.require('nubank.workspaces.ui.events');
goog.require('nubank.workspaces.ui.grid_layout');
goog.require('nubank.workspaces.ui.spotlight');
goog.require('nubank.workspaces.ui.modal');
goog.require('nubank.workspaces.ui.highlight');
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.components_with_error !== 'undefined')){
} else {
nubank.workspaces.ui.components_with_error = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
}
nubank.workspaces.ui.default_bindings = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword("nubank.workspaces.ui","keybinding-toggle-index","nubank.workspaces.ui/keybinding-toggle-index",2077220551),"alt-shift-i",new cljs.core.Keyword("nubank.workspaces.ui","keybinding-spotlight","nubank.workspaces.ui/keybinding-spotlight",254588049),"alt-shift-a",new cljs.core.Keyword("nubank.workspaces.ui","keybinding-toggle-card-headers","nubank.workspaces.ui/keybinding-toggle-card-headers",1763073649),"alt-shift-h",new cljs.core.Keyword("nubank.workspaces.ui","keybinding-new-workspace","nubank.workspaces.ui/keybinding-new-workspace",-1840796647),"alt-shift-n",new cljs.core.Keyword("nubank.workspaces.ui","keybinding-close-workspace","nubank.workspaces.ui/keybinding-close-workspace",145944058),"alt-shift-w",new cljs.core.Keyword("nubank.workspaces.ui","keybinding-fix-sizes","nubank.workspaces.ui/keybinding-fix-sizes",1615114381),"alt-shift-s"], null);
nubank.workspaces.ui.get_keybinding = (function nubank$workspaces$ui$get_keybinding(name){
return nubank.workspaces.lib.local_storage.get.call(null,name,cljs.core.get.call(null,nubank.workspaces.ui.default_bindings,name));
});
nubank.workspaces.ui.card_title = (function nubank$workspaces$ui$card_title(card_id){
return cljs.core.name.call(null,card_id);
});
nubank.workspaces.ui.card_changed_QMARK_ = (function nubank$workspaces$ui$card_changed_QMARK_(card_id){
return cljs.core.not_EQ_.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,nubank.workspaces.data.card_definitions_snap_STAR_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [card_id,new cljs.core.Keyword("nubank.workspaces.model","card-form","nubank.workspaces.model/card-form",2147473)], null)),cljs.core.get_in.call(null,cljs.core.deref.call(null,nubank.workspaces.data.card_definitions_STAR_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [card_id,new cljs.core.Keyword("nubank.workspaces.model","card-form","nubank.workspaces.model/card-form",2147473)], null)));
});
nubank.workspaces.ui.use_card = (function nubank$workspaces$ui$use_card(card_id,node,reconciler){
var temp__5718__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,nubank.workspaces.data.active_cards_STAR_),card_id);
if(cljs.core.truth_(temp__5718__auto__)){
var active = temp__5718__auto__;
return active;
} else {
var temp__5718__auto____$1 = nubank.workspaces.data.card_definition.call(null,card_id);
if(cljs.core.truth_(temp__5718__auto____$1)){
var map__74322 = temp__5718__auto____$1;
var map__74322__$1 = (((((!((map__74322 == null))))?(((((map__74322.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74322.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74322):map__74322);
var card_def = map__74322__$1;
var init = cljs.core.get.call(null,map__74322__$1,new cljs.core.Keyword("nubank.workspaces.model","init","nubank.workspaces.model/init",-1281528358));
var card = init.call(null,cljs.core.merge.call(null,card_def,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134),node,new cljs.core.Keyword("nubank.workspaces.model","reconciler","nubank.workspaces.model/reconciler",794444150),reconciler,new cljs.core.Keyword("nubank.workspaces.model","set-card-header-style","nubank.workspaces.model/set-card-header-style",1976817478),((function (map__74322,map__74322__$1,card_def,init,temp__5718__auto____$1,temp__5718__auto__){
return (function (style){
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.client.mutations","set-props","fulcro.client.mutations/set-props",-1739323709,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.model","card-header-style","nubank.workspaces.model/card-header-style",534442797),null,(1),null)),(new cljs.core.List(null,style,null,(1),null)))))),null,(1),null)))))], null));
});})(map__74322,map__74322__$1,card_def,init,temp__5718__auto____$1,temp__5718__auto__))
], null)));
cljs.core.swap_BANG_.call(null,nubank.workspaces.data.active_cards_STAR_,cljs.core.assoc,card_id,card);

return card;
} else {
return console.warn("Card card-id",card_id,"not found");
}
}
});
nubank.workspaces.ui.dispose_card = (function nubank$workspaces$ui$dispose_card(card_id){
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,nubank.workspaces.data.active_cards_STAR_),card_id);
if(cljs.core.truth_(temp__5720__auto__)){
var map__74331 = temp__5720__auto__;
var map__74331__$1 = (((((!((map__74331 == null))))?(((((map__74331.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74331.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74331):map__74331);
var node = cljs.core.get.call(null,map__74331__$1,new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134));
var dispose = cljs.core.get.call(null,map__74331__$1,new cljs.core.Keyword("nubank.workspaces.model","dispose","nubank.workspaces.model/dispose",829517204));
if(cljs.core.truth_(dispose)){
dispose.call(null,node);
} else {
}

return cljs.core.swap_BANG_.call(null,nubank.workspaces.data.active_cards_STAR_,cljs.core.dissoc,card_id);
} else {
return null;
}
});
nubank.workspaces.ui.render_card = (function nubank$workspaces$ui$render_card(p__74334){
var map__74336 = p__74334;
var map__74336__$1 = (((((!((map__74336 == null))))?(((((map__74336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74336.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74336):map__74336);
var card_id = cljs.core.get.call(null,map__74336__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var component = cljs.core.get.call(null,map__74336__$1,new cljs.core.Keyword("nubank.workspaces.model","component","nubank.workspaces.model/component",-1201359926));
var node = cljs.core.get.call(null,map__74336__$1,new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134));
var map__74339 = nubank.workspaces.ui.use_card.call(null,card_id,node,fulcro.client.primitives.get_reconciler.call(null,component));
var map__74339__$1 = (((((!((map__74339 == null))))?(((((map__74339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74339):map__74339);
var render = cljs.core.get.call(null,map__74339__$1,new cljs.core.Keyword("nubank.workspaces.model","render","nubank.workspaces.model/render",125050774));
cljs.core.swap_BANG_.call(null,nubank.workspaces.data.active_cards_STAR_,cljs.core.update,card_id,cljs.core.assoc,new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134),node,new cljs.core.Keyword("nubank.workspaces.model","component","nubank.workspaces.model/component",-1201359926),component);

return render.call(null,node);
});
nubank.workspaces.ui.refresh_card_container = (function nubank$workspaces$ui$refresh_card_container(card_id){
var temp__5718__auto__ = cljs.core.get.call(null,nubank.workspaces.data.active_card.call(null,card_id),new cljs.core.Keyword("nubank.workspaces.model","component","nubank.workspaces.model/component",-1201359926));
if(cljs.core.truth_(temp__5718__auto__)){
var comp = temp__5718__auto__;
return comp.forceUpdate();
} else {
return null;
}
});
nubank.workspaces.ui.restart_card = (function nubank$workspaces$ui$restart_card(card_id){
var old_card = nubank.workspaces.data.active_card.call(null,card_id);
nubank.workspaces.ui.dispose_card.call(null,card_id);

nubank.workspaces.ui.render_card.call(null,cljs.core.assoc.call(null,old_card,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id));

return nubank.workspaces.ui.refresh_card_container.call(null,card_id);
});
nubank.workspaces.ui.workspace_card_ids = (function nubank$workspaces$ui$workspace_card_ids(p__74344){
var map__74345 = p__74344;
var map__74345__$1 = (((((!((map__74345 == null))))?(((((map__74345.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74345.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74345):map__74345);
var cards = cljs.core.get.call(null,map__74345__$1,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701));
var card_id = cljs.core.get.call(null,map__74345__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
if(cljs.core.truth_(cards)){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.second),cards);
} else {
return cljs.core.PersistentHashSet.createAsIfByAssoc([card_id]);
}
});
nubank.workspaces.ui.refresh_cards = (function nubank$workspaces$ui$refresh_cards(var_args){
var G__74353 = arguments.length;
switch (G__74353) {
case 1:
return nubank.workspaces.ui.refresh_cards.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nubank.workspaces.ui.refresh_cards.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

nubank.workspaces.ui.refresh_cards.cljs$core$IFn$_invoke$arity$1 = (function (cards){
return nubank.workspaces.ui.refresh_cards.call(null,cards,true);
});

nubank.workspaces.ui.refresh_cards.cljs$core$IFn$_invoke$arity$2 = (function (cards,check_changes_QMARK_){
var seq__74358_75593 = cljs.core.seq.call(null,cards);
var chunk__74359_75594 = null;
var count__74360_75595 = (0);
var i__74361_75596 = (0);
while(true){
if((i__74361_75596 < count__74360_75595)){
var vec__74383_75597 = cljs.core._nth(chunk__74359_75594,i__74361_75596);
var card_id_75598 = cljs.core.nth.call(null,vec__74383_75597,(0),null);
var map__74386_75599 = cljs.core.nth.call(null,vec__74383_75597,(1),null);
var map__74386_75600__$1 = (((((!((map__74386_75599 == null))))?(((((map__74386_75599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74386_75599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74386_75599):map__74386_75599);
var node_75601 = cljs.core.get.call(null,map__74386_75600__$1,new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134));
var refresh_75602 = cljs.core.get.call(null,map__74386_75600__$1,new cljs.core.Keyword("nubank.workspaces.model","refresh","nubank.workspaces.model/refresh",-816174567));
try{if(cljs.core.truth_((function (){var and__4120__auto__ = check_changes_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return nubank.workspaces.ui.card_changed_QMARK_.call(null,card_id_75598);
} else {
return and__4120__auto__;
}
})())){
nubank.workspaces.ui.restart_card.call(null,card_id_75598);
} else {
if(cljs.core.truth_(refresh_75602)){
refresh_75602.call(null,node_75601);
} else {
}
}
}catch (e74391){var e_75606 = e74391;
console.error("Error refreshing card",card_id_75598,e_75606);
}

var G__75607 = seq__74358_75593;
var G__75608 = chunk__74359_75594;
var G__75609 = count__74360_75595;
var G__75610 = (i__74361_75596 + (1));
seq__74358_75593 = G__75607;
chunk__74359_75594 = G__75608;
count__74360_75595 = G__75609;
i__74361_75596 = G__75610;
continue;
} else {
var temp__5720__auto___75612 = cljs.core.seq.call(null,seq__74358_75593);
if(temp__5720__auto___75612){
var seq__74358_75613__$1 = temp__5720__auto___75612;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74358_75613__$1)){
var c__4550__auto___75614 = cljs.core.chunk_first.call(null,seq__74358_75613__$1);
var G__75615 = cljs.core.chunk_rest.call(null,seq__74358_75613__$1);
var G__75616 = c__4550__auto___75614;
var G__75617 = cljs.core.count.call(null,c__4550__auto___75614);
var G__75618 = (0);
seq__74358_75593 = G__75615;
chunk__74359_75594 = G__75616;
count__74360_75595 = G__75617;
i__74361_75596 = G__75618;
continue;
} else {
var vec__74393_75619 = cljs.core.first.call(null,seq__74358_75613__$1);
var card_id_75620 = cljs.core.nth.call(null,vec__74393_75619,(0),null);
var map__74396_75621 = cljs.core.nth.call(null,vec__74393_75619,(1),null);
var map__74396_75622__$1 = (((((!((map__74396_75621 == null))))?(((((map__74396_75621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74396_75621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74396_75621):map__74396_75621);
var node_75623 = cljs.core.get.call(null,map__74396_75622__$1,new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134));
var refresh_75624 = cljs.core.get.call(null,map__74396_75622__$1,new cljs.core.Keyword("nubank.workspaces.model","refresh","nubank.workspaces.model/refresh",-816174567));
try{if(cljs.core.truth_((function (){var and__4120__auto__ = check_changes_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return nubank.workspaces.ui.card_changed_QMARK_.call(null,card_id_75620);
} else {
return and__4120__auto__;
}
})())){
nubank.workspaces.ui.restart_card.call(null,card_id_75620);
} else {
if(cljs.core.truth_(refresh_75624)){
refresh_75624.call(null,node_75623);
} else {
}
}
}catch (e74404){var e_75625 = e74404;
console.error("Error refreshing card",card_id_75620,e_75625);
}

var G__75626 = cljs.core.next.call(null,seq__74358_75613__$1);
var G__75627 = null;
var G__75628 = (0);
var G__75629 = (0);
seq__74358_75593 = G__75626;
chunk__74359_75594 = G__75627;
count__74360_75595 = G__75628;
i__74361_75596 = G__75629;
continue;
}
} else {
}
}
break;
}

var seq__74405_75630 = cljs.core.seq.call(null,cljs.core.deref.call(null,nubank.workspaces.ui.components_with_error));
var chunk__74406_75631 = null;
var count__74407_75632 = (0);
var i__74408_75633 = (0);
while(true){
if((i__74408_75633 < count__74407_75632)){
var comp_75634 = cljs.core._nth(chunk__74406_75631,i__74408_75633);
fulcro.client.primitives.set_state_BANG_.call(null,comp_75634,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944),false], null));


var G__75635 = seq__74405_75630;
var G__75636 = chunk__74406_75631;
var G__75637 = count__74407_75632;
var G__75638 = (i__74408_75633 + (1));
seq__74405_75630 = G__75635;
chunk__74406_75631 = G__75636;
count__74407_75632 = G__75637;
i__74408_75633 = G__75638;
continue;
} else {
var temp__5720__auto___75640 = cljs.core.seq.call(null,seq__74405_75630);
if(temp__5720__auto___75640){
var seq__74405_75641__$1 = temp__5720__auto___75640;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74405_75641__$1)){
var c__4550__auto___75642 = cljs.core.chunk_first.call(null,seq__74405_75641__$1);
var G__75643 = cljs.core.chunk_rest.call(null,seq__74405_75641__$1);
var G__75644 = c__4550__auto___75642;
var G__75645 = cljs.core.count.call(null,c__4550__auto___75642);
var G__75646 = (0);
seq__74405_75630 = G__75643;
chunk__74406_75631 = G__75644;
count__74407_75632 = G__75645;
i__74408_75633 = G__75646;
continue;
} else {
var comp_75647 = cljs.core.first.call(null,seq__74405_75641__$1);
fulcro.client.primitives.set_state_BANG_.call(null,comp_75647,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944),false], null));


var G__75648 = cljs.core.next.call(null,seq__74405_75641__$1);
var G__75649 = null;
var G__75650 = (0);
var G__75651 = (0);
seq__74405_75630 = G__75648;
chunk__74406_75631 = G__75649;
count__74407_75632 = G__75650;
i__74408_75633 = G__75651;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,nubank.workspaces.ui.components_with_error,cljs.core.PersistentHashSet.EMPTY);
});

nubank.workspaces.ui.refresh_cards.cljs$lang$maxFixedArity = 2;

nubank.workspaces.ui.active_workspace_cards = (function nubank$workspaces$ui$active_workspace_cards(reconciler){
var state = cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,reconciler));
var temp__5718__auto__ = cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814)], null));
if(cljs.core.truth_(temp__5718__auto__)){
var ref = temp__5718__auto__;
var card_ids = nubank.workspaces.ui.workspace_card_ids.call(null,cljs.core.get_in.call(null,state,ref));
return cljs.core.select_keys.call(null,cljs.core.deref.call(null,nubank.workspaces.data.active_cards_STAR_),card_ids);
} else {
return null;
}
});
nubank.workspaces.ui.refresh_active_workspace_cards = (function nubank$workspaces$ui$refresh_active_workspace_cards(reconciler){
return nubank.workspaces.ui.refresh_cards.call(null,nubank.workspaces.ui.active_workspace_cards.call(null,reconciler));
});
nubank.workspaces.ui.refresh_active_cards = (function nubank$workspaces$ui$refresh_active_cards(){
return nubank.workspaces.ui.refresh_cards.call(null,cljs.core.deref.call(null,nubank.workspaces.data.active_cards_STAR_));
});
nubank.workspaces.ui.lookup_ref = (function nubank$workspaces$ui$lookup_ref(state,ref){
if(cljs.core.vector_QMARK_.call(null,ref)){
return cljs.core.get_in.call(null,state,ref);
} else {
return ref;
}
});
nubank.workspaces.ui.normalize_ws_cards = (function nubank$workspaces$ui$normalize_ws_cards(state,ws){
return cljs.core.update.call(null,ws,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),(function (p1__74423_SHARP_){
return cljs.core.mapv.call(null,cljs.core.partial.call(null,nubank.workspaces.ui.lookup_ref,state),p1__74423_SHARP_);
}));
});
nubank.workspaces.ui.create_workspace_STAR_ = (function nubank$workspaces$ui$create_workspace_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75658 = arguments.length;
var i__4731__auto___75659 = (0);
while(true){
if((i__4731__auto___75659 < len__4730__auto___75658)){
args__4736__auto__.push((arguments[i__4731__auto___75659]));

var G__75660 = (i__4731__auto___75659 + (1));
i__4731__auto___75659 = G__75660;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return nubank.workspaces.ui.create_workspace_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

nubank.workspaces.ui.create_workspace_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (p__74428,ws,args){
var map__74429 = p__74428;
var map__74429__$1 = (((((!((map__74429 == null))))?(((((map__74429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74429.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74429):map__74429);
var reconciler = cljs.core.get.call(null,map__74429__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state = cljs.core.get.call(null,map__74429__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ws__$1 = fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.Workspace,ws);
cljs.core.apply.call(null,fulcro.client.primitives.merge_component_BANG_,reconciler,nubank.workspaces.ui.Workspace,nubank.workspaces.ui.normalize_ws_cards.call(null,cljs.core.deref.call(null,state),ws__$1),new cljs.core.Keyword(null,"append","append",-291298229),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450)], null),args);

return ws__$1;
});

nubank.workspaces.ui.create_workspace_STAR_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
nubank.workspaces.ui.create_workspace_STAR_.cljs$lang$applyTo = (function (seq74424){
var G__74425 = cljs.core.first.call(null,seq74424);
var seq74424__$1 = cljs.core.next.call(null,seq74424);
var G__74426 = cljs.core.first.call(null,seq74424__$1);
var seq74424__$2 = cljs.core.next.call(null,seq74424__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74425,G__74426,seq74424__$2);
});

nubank.workspaces.ui.save_local_workspace = (function nubank$workspaces$ui$save_local_workspace(p__74439){
var map__74440 = p__74439;
var map__74440__$1 = (((((!((map__74440 == null))))?(((((map__74440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74440):map__74440);
var workspace = map__74440__$1;
var workspace_id = cljs.core.get.call(null,map__74440__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
nubank.workspaces.lib.local_storage.update_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),workspace_id);

nubank.workspaces.lib.local_storage.update_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","local-workspaces","nubank.workspaces.ui/local-workspaces",-1846378387),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),workspace_id);

nubank.workspaces.lib.local_storage.tset_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id], null),cljs.core.select_keys.call(null,workspace,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716)], null)));

return workspace;
});
nubank.workspaces.ui.active_workspace_ref = (function nubank$workspaces$ui$active_workspace_ref(p__74453){
var map__74455 = p__74453;
var map__74455__$1 = (((((!((map__74455 == null))))?(((((map__74455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74455):map__74455);
var env = map__74455__$1;
var state = cljs.core.get.call(null,map__74455__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var temp__5718__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814)], null));
if(cljs.core.truth_(temp__5718__auto__)){
var ref = temp__5718__auto__;
return ref;
} else {
var ws = nubank.workspaces.ui.create_workspace_STAR_.call(null,env,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"append","append",-291298229),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447)], null),new cljs.core.Keyword(null,"replace","replace",-786587770),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814)], null));
nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(ws));

nubank.workspaces.ui.save_local_workspace.call(null,ws);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(ws)], null);
}
});
nubank.workspaces.ui.map_values = (function nubank$workspaces$ui$map_values(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__74469){
var vec__74470 = p__74469;
var k = cljs.core.nth.call(null,vec__74470,(0),null);
var v = cljs.core.nth.call(null,vec__74470,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,f.call(null,v)], null);
})),m);
});
nubank.workspaces.ui.all_referenced_cards = (function nubank$workspaces$ui$all_referenced_cards(state){
return cljs.core.reduce.call(null,(function (card_ids,ws_ref){
return cljs.core.into.call(null,card_ids,nubank.workspaces.ui.workspace_card_ids.call(null,cljs.core.get_in.call(null,state,ws_ref)));
}),cljs.core.PersistentHashSet.EMPTY,cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447)], null)));
});
nubank.workspaces.ui.disposed_unreferenced_cards = (function nubank$workspaces$ui$disposed_unreferenced_cards(state,card_ids){
var seq__74481 = cljs.core.seq.call(null,clojure.set.difference.call(null,card_ids,nubank.workspaces.ui.all_referenced_cards.call(null,state)));
var chunk__74482 = null;
var count__74483 = (0);
var i__74484 = (0);
while(true){
if((i__74484 < count__74483)){
var unreferenced_card_id = cljs.core._nth(chunk__74482,i__74484);
nubank.workspaces.ui.dispose_card.call(null,unreferenced_card_id);


var G__75669 = seq__74481;
var G__75670 = chunk__74482;
var G__75671 = count__74483;
var G__75672 = (i__74484 + (1));
seq__74481 = G__75669;
chunk__74482 = G__75670;
count__74483 = G__75671;
i__74484 = G__75672;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__74481);
if(temp__5720__auto__){
var seq__74481__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74481__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__74481__$1);
var G__75674 = cljs.core.chunk_rest.call(null,seq__74481__$1);
var G__75675 = c__4550__auto__;
var G__75676 = cljs.core.count.call(null,c__4550__auto__);
var G__75677 = (0);
seq__74481 = G__75674;
chunk__74482 = G__75675;
count__74483 = G__75676;
i__74484 = G__75677;
continue;
} else {
var unreferenced_card_id = cljs.core.first.call(null,seq__74481__$1);
nubank.workspaces.ui.dispose_card.call(null,unreferenced_card_id);


var G__75678 = cljs.core.next.call(null,seq__74481__$1);
var G__75679 = null;
var G__75680 = (0);
var G__75681 = (0);
seq__74481 = G__75678;
chunk__74482 = G__75679;
count__74483 = G__75680;
i__74484 = G__75681;
continue;
}
} else {
return null;
}
}
break;
}
});
nubank.workspaces.ui.remove_workspace_card = (function nubank$workspaces$ui$remove_workspace_card(workspace,card_id){
return cljs.core.update.call(null,cljs.core.update.call(null,workspace,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),(function (cards){
return cljs.core.filterv.call(null,(function (p1__74488_SHARP_){
return cljs.core.not_EQ_.call(null,cljs.core.second.call(null,p1__74488_SHARP_),card_id);
}),cards);
})),new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),(function (breakpoints){
return nubank.workspaces.ui.map_values.call(null,(function (layouts){
return cljs.core.filterv.call(null,(function (p1__74489_SHARP_){
return cljs.core.not_EQ_.call(null,cljs.core.get.call(null,p1__74489_SHARP_,"i"),card_id);
}),layouts);
}),breakpoints);
}));
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","remove-card-from-active-ns","nubank.workspaces.ui/remove-card-from-active-ns",-2013077344,null),(function (fulcro_incoming_env,_,p__74492){
var map__74493 = p__74492;
var map__74493__$1 = (((((!((map__74493 == null))))?(((((map__74493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74493.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74493):map__74493);
var card_id = cljs.core.get.call(null,map__74493__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
return cljs.core.merge.call(null,(function (){var map__74498 = fulcro_incoming_env;
var map__74498__$1 = (((((!((map__74498 == null))))?(((((map__74498.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74498.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74498):map__74498);
var env = map__74498__$1;
var state = cljs.core.get.call(null,map__74498__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74498,map__74498__$1,env,state,map__74493,map__74493__$1,card_id){
return (function (){
var ws_ref = nubank.workspaces.ui.active_workspace_ref.call(null,env);
var current_ws = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ws_ref);
if(cljs.core.contains_QMARK_.call(null,nubank.workspaces.ui.workspace_card_ids.call(null,current_ws),card_id)){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,ws_ref,((function (ws_ref,current_ws,map__74498,map__74498__$1,env,state,map__74493,map__74493__$1,card_id){
return (function (p1__74490_SHARP_){
return nubank.workspaces.ui.remove_workspace_card.call(null,p1__74490_SHARP_,card_id);
});})(ws_ref,current_ws,map__74498,map__74498__$1,env,state,map__74493,map__74493__$1,card_id))
);

return nubank.workspaces.ui.disposed_unreferenced_cards.call(null,cljs.core.deref.call(null,state),cljs.core.PersistentHashSet.createAsIfByAssoc([card_id]));
} else {
return null;
}
});})(map__74498,map__74498__$1,env,state,map__74493,map__74493__$1,card_id))
], null);
})(),(function (){var ___$1 = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh","refresh",1947415525),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701)], null)], null);
})());
}));
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.WorkspaceSoloCard !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.WorkspaceSoloCard = (function nubank$workspaces$ui$WorkspaceSoloCard(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.WorkspaceSoloCard.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","WorkspaceSoloCard","nubank.workspaces.ui/WorkspaceSoloCard",-185454692),nubank.workspaces.ui.WorkspaceSoloCard);

var x74547_75694 = nubank.workspaces.ui.WorkspaceSoloCard.prototype;
x74547_75694.render = ((function (x74547_75694){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__74552 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__74553 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__74554 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__74555 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__74556 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__74557 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__74558 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__74559 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__74560 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__74561 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__74557;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__74558;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__74559;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__74560;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__74561;

try{var map__74570 = fulcro.client.primitives.props.call(null,this$);
var map__74570__$1 = (((((!((map__74570 == null))))?(((((map__74570.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74570.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74570):map__74570);
var card_id = cljs.core.get.call(null,map__74570__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var map__74572 = nubank.workspaces.data.active_card.call(null,card_id);
var map__74572__$1 = (((((!((map__74572 == null))))?(((((map__74572.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74572.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74572):map__74572);
var render_toolbar = cljs.core.get.call(null,map__74572__$1,new cljs.core.Keyword("nubank.workspaces.model","render-toolbar","nubank.workspaces.model/render-toolbar",-1738138937));
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container",".container",-1441208944),(cljs.core.truth_(render_toolbar)?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".toolbar",".toolbar",968457325),render_toolbar.call(null)):fulcro.client.localized_dom.div.call(null)),(cljs.core.truth_(fulcro.client.primitives.get_state.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944)))?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".error",".error",115475668),"Error rendering card, check console for details."):null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".card",".card",1484105240),cljs.core.merge_with.call(null,cljs.core.merge,new cljs.core.Keyword("nubank.workspaces.model","node-props","nubank.workspaces.model/node-props",-69697539).cljs$core$IFn$_invoke$arity$1(nubank.workspaces.data.card_definition.call(null,card_id)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ref","ref",1289896967),((function (map__74572,map__74572__$1,render_toolbar,map__74570,map__74570__$1,card_id,_STAR_reconciler_STAR__orig_val__74552,_STAR_depth_STAR__orig_val__74553,_STAR_shared_STAR__orig_val__74554,_STAR_instrument_STAR__orig_val__74555,_STAR_parent_STAR__orig_val__74556,_STAR_reconciler_STAR__temp_val__74557,_STAR_depth_STAR__temp_val__74558,_STAR_shared_STAR__temp_val__74559,_STAR_instrument_STAR__temp_val__74560,_STAR_parent_STAR__temp_val__74561,this$,this__59535__auto__,x74547_75694){
return (function (p1__74521_SHARP_){
return goog.object.set(this$,"cardNode",p1__74521_SHARP_);
});})(map__74572,map__74572__$1,render_toolbar,map__74570,map__74570__$1,card_id,_STAR_reconciler_STAR__orig_val__74552,_STAR_depth_STAR__orig_val__74553,_STAR_shared_STAR__orig_val__74554,_STAR_instrument_STAR__orig_val__74555,_STAR_parent_STAR__orig_val__74556,_STAR_reconciler_STAR__temp_val__74557,_STAR_depth_STAR__temp_val__74558,_STAR_shared_STAR__temp_val__74559,_STAR_instrument_STAR__temp_val__74560,_STAR_parent_STAR__temp_val__74561,this$,this__59535__auto__,x74547_75694))
], null))));
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__74556;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__74555;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__74554;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__74553;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__74552;
}});})(x74547_75694))
;

x74547_75694.componentDidMount = ((function (x74547_75694){
return (function (){
var this__59519__auto__ = this;
var this$ = this__59519__auto__;
var reconciler__59520__auto__ = fulcro.client.primitives.get_reconciler.call(null,this__59519__auto__);
var lifecycle__59521__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"lifecycle","lifecycle",341496205)], null));
var indexer__59522__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
goog.object.set(this__59519__auto__,"fulcro$mounted",true);

if((indexer__59522__auto__ == null)){
} else {
fulcro.client.impl.protocols.index_component_BANG_(indexer__59522__auto__,this__59519__auto__);
}

if(cljs.core.truth_(lifecycle__59521__auto__)){
lifecycle__59521__auto__.call(null,this__59519__auto__,new cljs.core.Keyword(null,"mount","mount",-1560582470));
} else {
}

var map__74578 = fulcro.client.primitives.props.call(null,this$);
var map__74578__$1 = (((((!((map__74578 == null))))?(((((map__74578.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74578.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74578):map__74578);
var card_id = cljs.core.get.call(null,map__74578__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var node = goog.object.get(this$,"cardNode");
try{nubank.workspaces.ui.render_card.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id,new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134),node,new cljs.core.Keyword("nubank.workspaces.model","component","nubank.workspaces.model/component",-1201359926),this$], null));

return this$.forceUpdate();
}catch (e74580){var e = e74580;
cljs.core.swap_BANG_.call(null,nubank.workspaces.ui.components_with_error,cljs.core.conj,this$);

console.error("Error mounting card",card_id,e);

return fulcro.client.primitives.set_state_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944),true], null));
}});})(x74547_75694))
;


nubank.workspaces.ui.WorkspaceSoloCard.prototype.constructor = nubank.workspaces.ui.WorkspaceSoloCard;

nubank.workspaces.ui.WorkspaceSoloCard.prototype.constructor.displayName = "nubank.workspaces.ui/WorkspaceSoloCard";

nubank.workspaces.ui.WorkspaceSoloCard.prototype.fulcro$isComponent = true;

var x74581_75711 = nubank.workspaces.ui.WorkspaceSoloCard;
x74581_75711.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x74581_75711.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x74581_75711){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 4px 9px 0 rgba(0,0,0,0.02)",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),nubank.workspaces.ui.core.card_border_radius,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".toolbar",".toolbar",968457325),nubank.workspaces.ui.core.font_os12sb,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_geyser,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"flex-end",new cljs.core.Keyword(null,"padding","padding",1660304693),"6px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"5px"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".error",".error",115475668),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef0000",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card",".card",1484105240),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null)], null);
});})(x74581_75711))
;

x74581_75711.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x74581_75711){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x74581_75711))
;

x74581_75711.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x74581_75711.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x74581_75711){
return (function (this$,data){
var this$__$1 = this;
return data;
});})(x74581_75711))
;

x74581_75711.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x74581_75711.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x74581_75711){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x74581_75711))
;

x74581_75711.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x74581_75711.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x74581_75711){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)], null);
});})(x74581_75711))
;


var x74584_75744 = nubank.workspaces.ui.WorkspaceSoloCard.prototype;
x74584_75744.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x74584_75744.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x74584_75744){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 4px 9px 0 rgba(0,0,0,0.02)",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),nubank.workspaces.ui.core.card_border_radius,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".toolbar",".toolbar",968457325),nubank.workspaces.ui.core.font_os12sb,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_geyser,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"flex-end",new cljs.core.Keyword(null,"padding","padding",1660304693),"6px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"5px"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".error",".error",115475668),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef0000",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card",".card",1484105240),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null)], null);
});})(x74584_75744))
;

x74584_75744.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x74584_75744){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x74584_75744))
;

x74584_75744.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x74584_75744.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x74584_75744){
return (function (this$,data){
var this$__$1 = this;
return data;
});})(x74584_75744))
;

x74584_75744.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x74584_75744.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x74584_75744){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x74584_75744))
;

x74584_75744.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x74584_75744.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x74584_75744){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)], null);
});})(x74584_75744))
;


nubank.workspaces.ui.WorkspaceSoloCard.cljs$lang$type = true;

nubank.workspaces.ui.WorkspaceSoloCard.cljs$lang$ctorStr = "nubank.workspaces.ui/WorkspaceSoloCard";

nubank.workspaces.ui.WorkspaceSoloCard.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/WorkspaceSoloCard");
});
nubank.workspaces.ui.workspace_solo_card = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.WorkspaceSoloCard,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)], null));
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.WorkspaceCard !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.WorkspaceCard = (function nubank$workspaces$ui$WorkspaceCard(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.WorkspaceCard.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","WorkspaceCard","nubank.workspaces.ui/WorkspaceCard",1363306272),nubank.workspaces.ui.WorkspaceCard);

var x74600_75752 = nubank.workspaces.ui.WorkspaceCard.prototype;
x74600_75752.render = ((function (x74600_75752){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__74603 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__74604 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__74605 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__74606 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__74607 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__74608 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__74609 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__74610 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__74611 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__74612 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__74608;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__74609;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__74610;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__74611;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__74612;

try{var map__74614 = fulcro.client.primitives.props.call(null,this$);
var map__74614__$1 = (((((!((map__74614 == null))))?(((((map__74614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74614):map__74614);
var props = map__74614__$1;
var card_id = cljs.core.get.call(null,map__74614__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var card_header_style = cljs.core.get.call(null,map__74614__$1,new cljs.core.Keyword("nubank.workspaces.model","card-header-style","nubank.workspaces.model/card-header-style",534442797));
var show_source_QMARK_ = cljs.core.get.call(null,map__74614__$1,new cljs.core.Keyword("nubank.workspaces.ui","show-source?","nubank.workspaces.ui/show-source?",1596348105));
var map__74615 = fulcro.client.primitives.get_computed.call(null,this$);
var map__74615__$1 = (((((!((map__74615 == null))))?(((((map__74615.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74615.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74615):map__74615);
var export_size = cljs.core.get.call(null,map__74615__$1,new cljs.core.Keyword("nubank.workspaces.ui","export-size","nubank.workspaces.ui/export-size",1661946281));
var open_solo_card = cljs.core.get.call(null,map__74615__$1,new cljs.core.Keyword("nubank.workspaces.ui","open-solo-card","nubank.workspaces.ui/open-solo-card",-1371578732));
var map__74618 = nubank.workspaces.data.active_card.call(null,card_id);
var map__74618__$1 = (((((!((map__74618 == null))))?(((((map__74618.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74618.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74618):map__74618);
var render_toolbar = cljs.core.get.call(null,map__74618__$1,new cljs.core.Keyword("nubank.workspaces.model","render-toolbar","nubank.workspaces.model/render-toolbar",-1738138937));
var map__74619 = nubank.workspaces.data.card_definition.call(null,card_id);
var map__74619__$1 = (((((!((map__74619 == null))))?(((((map__74619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74619):map__74619);
var card_form = cljs.core.get.call(null,map__74619__$1,new cljs.core.Keyword("nubank.workspaces.model","card-form","nubank.workspaces.model/card-form",2147473));
var test_QMARK_ = cljs.core.get.call(null,map__74619__$1,new cljs.core.Keyword("nubank.workspaces.model","test?","nubank.workspaces.model/test?",993719827));
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container",".container",-1441208944),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".header$workspaces-cljs-card-drag-handle",".header$workspaces-cljs-card-drag-handle",1045999511),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.call(null,card_header_style,(cljs.core.truth_(cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton"], null),new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),new cljs.core.Keyword("nubank.workspaces.ui","hide-card-header?","nubank.workspaces.ui/hide-card-header?",-497463645)], null)))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"none"], null):null))], null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".header-title",".header-title",719021241),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".card-title",".card-title",1927235738),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),cljs.core.str.cljs$core$IFn$_invoke$arity$1(card_id)], null),nubank.workspaces.ui.card_title.call(null,card_id)),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".card-actions",".card-actions",-1000790231),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".more-container",".more-container",-324805920),nubank.workspaces.ui.core.more_icon.call(null,cljs.core.PersistentArrayMap.EMPTY),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".more",".more",196863026),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".more-actions",".more-actions",-54999811),(cljs.core.truth_(card_form)?nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752){
return (function (){
return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-source?","nubank.workspaces.ui/show-source?",1596348105),true);
});})(map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752))
], null),"Source"):null),nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752){
return (function (){
return open_solo_card.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id], null));
});})(map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752))
], null),"Solo"),((cljs.core.not(test_QMARK_))?nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),export_size], null),"Size"):null)))),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".close",".close",1636677024),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","remove-card-from-active-ns","nubank.workspaces.ui/remove-card-from-active-ns",-2013077344,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),null,(1),null)),(new cljs.core.List(null,card_id,null,(1),null)))))),null,(1),null)))))], null));
});})(map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752))
], null),"\u00D7"))),(cljs.core.truth_(render_toolbar)?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".toolbar",".toolbar",968457325),render_toolbar.call(null)):null)),(cljs.core.truth_(fulcro.client.primitives.get_state.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944)))?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".error",".error",115475668),"Error rendering card, check console for details."):null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".card",".card",1484105240),cljs.core.merge_with.call(null,cljs.core.merge,new cljs.core.Keyword("nubank.workspaces.model","node-props","nubank.workspaces.model/node-props",-69697539).cljs$core$IFn$_invoke$arity$1(nubank.workspaces.data.card_definition.call(null,card_id)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ref","ref",1289896967),((function (map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752){
return (function (p1__74593_SHARP_){
return goog.object.set(this$,"cardNode",p1__74593_SHARP_);
});})(map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752))
], null))),(cljs.core.truth_(show_source_QMARK_)?nubank.workspaces.ui.modal.modal.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui.modal","on-close","nubank.workspaces.ui.modal/on-close",1602537550),((function (map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752){
return (function (){
return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-source?","nubank.workspaces.ui/show-source?",1596348105),false);
});})(map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752))
], null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".source",".source",1541091664),nubank.workspaces.ui.highlight.highlight.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui.highlight","source","nubank.workspaces.ui.highlight/source",161213844),(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__74632_75853 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__74633_75854 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__74634_75855 = true;
var _STAR_print_fn_STAR__temp_val__74635_75856 = ((function (_STAR_print_newline_STAR__orig_val__74632_75853,_STAR_print_fn_STAR__orig_val__74633_75854,_STAR_print_newline_STAR__temp_val__74634_75855,sb__4661__auto__,map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__74632_75853,_STAR_print_fn_STAR__orig_val__74633_75854,_STAR_print_newline_STAR__temp_val__74634_75855,sb__4661__auto__,map__74618,map__74618__$1,render_toolbar,map__74619,map__74619__$1,card_form,test_QMARK_,map__74614,map__74614__$1,props,card_id,card_header_style,show_source_QMARK_,map__74615,map__74615__$1,export_size,open_solo_card,_STAR_reconciler_STAR__orig_val__74603,_STAR_depth_STAR__orig_val__74604,_STAR_shared_STAR__orig_val__74605,_STAR_instrument_STAR__orig_val__74606,_STAR_parent_STAR__orig_val__74607,_STAR_reconciler_STAR__temp_val__74608,_STAR_depth_STAR__temp_val__74609,_STAR_shared_STAR__temp_val__74610,_STAR_instrument_STAR__temp_val__74611,_STAR_parent_STAR__temp_val__74612,this$,this__59535__auto__,x74600_75752))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__74634_75855;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__74635_75856;

try{cljs.pprint.pprint.call(null,card_form);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__74633_75854;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__74632_75853;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})()], null)))):null));
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__74607;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__74606;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__74605;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__74604;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__74603;
}});})(x74600_75752))
;

x74600_75752.componentDidMount = ((function (x74600_75752){
return (function (){
var this__59519__auto__ = this;
var this$ = this__59519__auto__;
var reconciler__59520__auto__ = fulcro.client.primitives.get_reconciler.call(null,this__59519__auto__);
var lifecycle__59521__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"lifecycle","lifecycle",341496205)], null));
var indexer__59522__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
goog.object.set(this__59519__auto__,"fulcro$mounted",true);

if((indexer__59522__auto__ == null)){
} else {
fulcro.client.impl.protocols.index_component_BANG_(indexer__59522__auto__,this__59519__auto__);
}

if(cljs.core.truth_(lifecycle__59521__auto__)){
lifecycle__59521__auto__.call(null,this__59519__auto__,new cljs.core.Keyword(null,"mount","mount",-1560582470));
} else {
}

var map__74638 = fulcro.client.primitives.props.call(null,this$);
var map__74638__$1 = (((((!((map__74638 == null))))?(((((map__74638.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74638.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74638):map__74638);
var card_id = cljs.core.get.call(null,map__74638__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var node = goog.object.get(this$,"cardNode");
try{nubank.workspaces.ui.render_card.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id,new cljs.core.Keyword("nubank.workspaces.model","node","nubank.workspaces.model/node",-2144506134),node,new cljs.core.Keyword("nubank.workspaces.model","component","nubank.workspaces.model/component",-1201359926),this$], null));

return this$.forceUpdate();
}catch (e74640){var e = e74640;
cljs.core.swap_BANG_.call(null,nubank.workspaces.ui.components_with_error,cljs.core.conj,this$);

console.error("Error mounting card",card_id,e);

return fulcro.client.primitives.set_state_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944),true], null));
}});})(x74600_75752))
;


nubank.workspaces.ui.WorkspaceCard.prototype.constructor = nubank.workspaces.ui.WorkspaceCard;

nubank.workspaces.ui.WorkspaceCard.prototype.constructor.displayName = "nubank.workspaces.ui/WorkspaceCard";

nubank.workspaces.ui.WorkspaceCard.prototype.fulcro$isComponent = true;

var x74646_75870 = nubank.workspaces.ui.WorkspaceCard;
x74646_75870.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x74646_75870.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x74646_75870){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 4px 9px 0 rgba(0,0,0,0.02)",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),nubank.workspaces.ui.core.card_border_radius,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$cljs-workflow-static-workflow","$cljs-workflow-static-workflow",-448809644),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"default"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".error",".error",115475668),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef0000",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),nubank.workspaces.ui.core.font_os12sb,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_mystic,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),[nubank.workspaces.ui.core.card_border_radius," ",nubank.workspaces.ui.core.card_border_radius," 0 0"].join(''),new cljs.core.Keyword(null,"color","color",1011675173),nubank.workspaces.ui.core.color_limed_spruce,new cljs.core.Keyword(null,"cursor","cursor",1011937484),"grab"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-webkit-grab"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-moz-grab"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header-title",".header-title",719021241),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"padding","padding",1660304693),"6px 10px",new cljs.core.Keyword(null,"box-sizing","box-sizing",-1956090239),"border-box",new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card-title",".card-title",1927235738),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden",new cljs.core.Keyword(null,"text-overflow","text-overflow",-1022366814),"ellipsis",new cljs.core.Keyword(null,"white-space","white-space",-707351930),"nowrap"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card-actions",".card-actions",-1000790231),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"grid",new cljs.core.Keyword(null,"grid-auto-flow","grid-auto-flow",-1754873684),"column",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"grid-gap","grid-gap",1083581064),"5px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".close",".close",1636677024),nubank.workspaces.ui.core.close_icon_css], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more-container",".more-container",-324805920),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&:hover","&:hover",-852658855),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more",".more",196863026),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"block"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more",".more",196863026),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"position","position",-2011731912),"absolute",new cljs.core.Keyword(null,"display","display",242065432),"none",new cljs.core.Keyword(null,"right","right",-452581833),"0",new cljs.core.Keyword(null,"top","top",-1856271961),"100%",new cljs.core.Keyword(null,"margin-top","margin-top",392161226),"-10px",new cljs.core.Keyword(null,"padding-top","padding-top",1929675955),"10px",new cljs.core.Keyword(null,"z-index","z-index",1892827090),"999"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more-actions",".more-actions",-54999811),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"display","display",242065432),"grid",new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_mystic,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"0 0 6px 6px",new cljs.core.Keyword(null,"padding","padding",1660304693),"5px 10px 10px",new cljs.core.Keyword(null,"grid-gap","grid-gap",1083581064),"6px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".toolbar",".toolbar",968457325),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_geyser,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"flex-end",new cljs.core.Keyword(null,"padding","padding",1660304693),"6px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"5px"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$react-draggable-dragging","$react-draggable-dragging",1270042297),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"grabbing"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-webkit-grabbing"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-moz-grabbing"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$cljs-workflow-static-workflow","$cljs-workflow-static-workflow",-448809644),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".close",".close",1636677024),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"none"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card",".card",1484105240),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".source",".source",1541091664),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"80vw",new cljs.core.Keyword(null,"max-height","max-height",-612563804),"80vh",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"0 12px",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),nubank.workspaces.ui.core.card_border_radius,new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),nubank.workspaces.ui.core.box_shadow], null)], null)], null);
});})(x74646_75870))
;

x74646_75870.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x74646_75870){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nubank.workspaces.ui.highlight.Highlight,nubank.workspaces.ui.modal.Modal], null);
});})(x74646_75870))
;

x74646_75870.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x74646_75870.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x74646_75870){
return (function (this$,data){
var this$__$1 = this;
return data;
});})(x74646_75870))
;

x74646_75870.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x74646_75870.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x74646_75870){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x74646_75870))
;

x74646_75870.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x74646_75870.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x74646_75870){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-header-style","nubank.workspaces.model/card-header-style",534442797),new cljs.core.Keyword("nubank.workspaces.ui","show-source?","nubank.workspaces.ui/show-source?",1596348105),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956)], null)])], null);
});})(x74646_75870))
;


var x74655_75898 = nubank.workspaces.ui.WorkspaceCard.prototype;
x74655_75898.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x74655_75898.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x74655_75898){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 4px 9px 0 rgba(0,0,0,0.02)",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),nubank.workspaces.ui.core.card_border_radius,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$cljs-workflow-static-workflow","$cljs-workflow-static-workflow",-448809644),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"default"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".error",".error",115475668),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef0000",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),nubank.workspaces.ui.core.font_os12sb,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_mystic,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),[nubank.workspaces.ui.core.card_border_radius," ",nubank.workspaces.ui.core.card_border_radius," 0 0"].join(''),new cljs.core.Keyword(null,"color","color",1011675173),nubank.workspaces.ui.core.color_limed_spruce,new cljs.core.Keyword(null,"cursor","cursor",1011937484),"grab"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-webkit-grab"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-moz-grab"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header-title",".header-title",719021241),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"padding","padding",1660304693),"6px 10px",new cljs.core.Keyword(null,"box-sizing","box-sizing",-1956090239),"border-box",new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card-title",".card-title",1927235738),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden",new cljs.core.Keyword(null,"text-overflow","text-overflow",-1022366814),"ellipsis",new cljs.core.Keyword(null,"white-space","white-space",-707351930),"nowrap"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card-actions",".card-actions",-1000790231),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"grid",new cljs.core.Keyword(null,"grid-auto-flow","grid-auto-flow",-1754873684),"column",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"grid-gap","grid-gap",1083581064),"5px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".close",".close",1636677024),nubank.workspaces.ui.core.close_icon_css], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more-container",".more-container",-324805920),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&:hover","&:hover",-852658855),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more",".more",196863026),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"block"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more",".more",196863026),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"position","position",-2011731912),"absolute",new cljs.core.Keyword(null,"display","display",242065432),"none",new cljs.core.Keyword(null,"right","right",-452581833),"0",new cljs.core.Keyword(null,"top","top",-1856271961),"100%",new cljs.core.Keyword(null,"margin-top","margin-top",392161226),"-10px",new cljs.core.Keyword(null,"padding-top","padding-top",1929675955),"10px",new cljs.core.Keyword(null,"z-index","z-index",1892827090),"999"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".more-actions",".more-actions",-54999811),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"display","display",242065432),"grid",new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_mystic,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"0 0 6px 6px",new cljs.core.Keyword(null,"padding","padding",1660304693),"5px 10px 10px",new cljs.core.Keyword(null,"grid-gap","grid-gap",1083581064),"6px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".toolbar",".toolbar",968457325),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_geyser,new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"flex-end",new cljs.core.Keyword(null,"padding","padding",1660304693),"6px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"5px"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$react-draggable-dragging","$react-draggable-dragging",1270042297),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"grabbing"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-webkit-grabbing"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"-moz-grabbing"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$cljs-workflow-static-workflow","$cljs-workflow-static-workflow",-448809644),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".close",".close",1636677024),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"none"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".card",".card",1484105240),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".source",".source",1541091664),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"80vw",new cljs.core.Keyword(null,"max-height","max-height",-612563804),"80vh",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"0 12px",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),nubank.workspaces.ui.core.card_border_radius,new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),nubank.workspaces.ui.core.box_shadow], null)], null)], null);
});})(x74655_75898))
;

x74655_75898.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x74655_75898){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nubank.workspaces.ui.highlight.Highlight,nubank.workspaces.ui.modal.Modal], null);
});})(x74655_75898))
;

x74655_75898.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x74655_75898.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x74655_75898){
return (function (this$,data){
var this$__$1 = this;
return data;
});})(x74655_75898))
;

x74655_75898.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x74655_75898.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x74655_75898){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x74655_75898))
;

x74655_75898.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x74655_75898.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x74655_75898){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-header-style","nubank.workspaces.model/card-header-style",534442797),new cljs.core.Keyword("nubank.workspaces.ui","show-source?","nubank.workspaces.ui/show-source?",1596348105),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956)], null)])], null);
});})(x74655_75898))
;


nubank.workspaces.ui.WorkspaceCard.cljs$lang$type = true;

nubank.workspaces.ui.WorkspaceCard.cljs$lang$ctorStr = "nubank.workspaces.ui/WorkspaceCard";

nubank.workspaces.ui.WorkspaceCard.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/WorkspaceCard");
});
nubank.workspaces.ui.workspace_card = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.WorkspaceCard,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)], null));
nubank.workspaces.ui.block = (function nubank$workspaces$ui$block(w,h,x,y){
return new cljs.core.PersistentArrayMap(null, 4, ["w",w,"h",h,"x",x,"y",y], null);
});
nubank.workspaces.ui.build_grid = (function nubank$workspaces$ui$build_grid(items){
return cljs.core.reduce.call(null,(function (grid,p__74680){
var map__74681 = p__74680;
var map__74681__$1 = (((((!((map__74681 == null))))?(((((map__74681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74681.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74681):map__74681);
var item = map__74681__$1;
var w = cljs.core.get.call(null,map__74681__$1,"w");
var h = cljs.core.get.call(null,map__74681__$1,"h");
var x = cljs.core.get.call(null,map__74681__$1,"x");
var y = cljs.core.get.call(null,map__74681__$1,"y");
return cljs.core.into.call(null,grid,(function (){var iter__4523__auto__ = ((function (map__74681,map__74681__$1,item,w,h,x,y){
return (function nubank$workspaces$ui$build_grid_$_iter__74683(s__74684){
return (new cljs.core.LazySeq(null,((function (map__74681,map__74681__$1,item,w,h,x,y){
return (function (){
var s__74684__$1 = s__74684;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__74684__$1);
if(temp__5720__auto__){
var xs__6277__auto__ = temp__5720__auto__;
var x_SINGLEQUOTE_ = cljs.core.first.call(null,xs__6277__auto__);
var iterys__4519__auto__ = ((function (s__74684__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74681,map__74681__$1,item,w,h,x,y){
return (function nubank$workspaces$ui$build_grid_$_iter__74683_$_iter__74685(s__74686){
return (new cljs.core.LazySeq(null,((function (s__74684__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74681,map__74681__$1,item,w,h,x,y){
return (function (){
var s__74686__$1 = s__74686;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__74686__$1);
if(temp__5720__auto____$1){
var s__74686__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__74686__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__74686__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__74688 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__74687 = (0);
while(true){
if((i__74687 < size__4522__auto__)){
var y_SINGLEQUOTE_ = cljs.core._nth(c__4521__auto__,i__74687);
cljs.core.chunk_append.call(null,b__74688,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_SINGLEQUOTE_ + x),(y_SINGLEQUOTE_ + y)], null),item], null));

var G__76053 = (i__74687 + (1));
i__74687 = G__76053;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74688),nubank$workspaces$ui$build_grid_$_iter__74683_$_iter__74685.call(null,cljs.core.chunk_rest.call(null,s__74686__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74688),null);
}
} else {
var y_SINGLEQUOTE_ = cljs.core.first.call(null,s__74686__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_SINGLEQUOTE_ + x),(y_SINGLEQUOTE_ + y)], null),item], null),nubank$workspaces$ui$build_grid_$_iter__74683_$_iter__74685.call(null,cljs.core.rest.call(null,s__74686__$2)));
}
} else {
return null;
}
break;
}
});})(s__74684__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74681,map__74681__$1,item,w,h,x,y))
,null,null));
});})(s__74684__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74681,map__74681__$1,item,w,h,x,y))
;
var fs__4520__auto__ = cljs.core.seq.call(null,iterys__4519__auto__(cljs.core.range.call(null,h)));
if(fs__4520__auto__){
return cljs.core.concat.call(null,fs__4520__auto__,nubank$workspaces$ui$build_grid_$_iter__74683.call(null,cljs.core.rest.call(null,s__74684__$1)));
} else {
var G__76073 = cljs.core.rest.call(null,s__74684__$1);
s__74684__$1 = G__76073;
continue;
}
} else {
return null;
}
break;
}
});})(map__74681,map__74681__$1,item,w,h,x,y))
,null,null));
});})(map__74681,map__74681__$1,item,w,h,x,y))
;
return iter__4523__auto__(cljs.core.range.call(null,w));
})());
}),cljs.core.PersistentArrayMap.EMPTY,items);
});
nubank.workspaces.ui.fits_in_QMARK_ = (function nubank$workspaces$ui$fits_in_QMARK_(p__74700,grid){
var map__74702 = p__74700;
var map__74702__$1 = (((((!((map__74702 == null))))?(((((map__74702.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74702.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74702):map__74702);
var w = cljs.core.get.call(null,map__74702__$1,"w");
var h = cljs.core.get.call(null,map__74702__$1,"h");
var x = cljs.core.get.call(null,map__74702__$1,"x");
var y = cljs.core.get.call(null,map__74702__$1,"y");
var coords = (function (){var iter__4523__auto__ = ((function (map__74702,map__74702__$1,w,h,x,y){
return (function nubank$workspaces$ui$fits_in_QMARK__$_iter__74704(s__74705){
return (new cljs.core.LazySeq(null,((function (map__74702,map__74702__$1,w,h,x,y){
return (function (){
var s__74705__$1 = s__74705;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__74705__$1);
if(temp__5720__auto__){
var xs__6277__auto__ = temp__5720__auto__;
var x_SINGLEQUOTE_ = cljs.core.first.call(null,xs__6277__auto__);
var iterys__4519__auto__ = ((function (s__74705__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74702,map__74702__$1,w,h,x,y){
return (function nubank$workspaces$ui$fits_in_QMARK__$_iter__74704_$_iter__74706(s__74707){
return (new cljs.core.LazySeq(null,((function (s__74705__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74702,map__74702__$1,w,h,x,y){
return (function (){
var s__74707__$1 = s__74707;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__74707__$1);
if(temp__5720__auto____$1){
var s__74707__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__74707__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__74707__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__74709 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__74708 = (0);
while(true){
if((i__74708 < size__4522__auto__)){
var y_SINGLEQUOTE_ = cljs.core._nth(c__4521__auto__,i__74708);
cljs.core.chunk_append.call(null,b__74709,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_SINGLEQUOTE_ + x),(y_SINGLEQUOTE_ + y)], null));

var G__76178 = (i__74708 + (1));
i__74708 = G__76178;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74709),nubank$workspaces$ui$fits_in_QMARK__$_iter__74704_$_iter__74706.call(null,cljs.core.chunk_rest.call(null,s__74707__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74709),null);
}
} else {
var y_SINGLEQUOTE_ = cljs.core.first.call(null,s__74707__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_SINGLEQUOTE_ + x),(y_SINGLEQUOTE_ + y)], null),nubank$workspaces$ui$fits_in_QMARK__$_iter__74704_$_iter__74706.call(null,cljs.core.rest.call(null,s__74707__$2)));
}
} else {
return null;
}
break;
}
});})(s__74705__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74702,map__74702__$1,w,h,x,y))
,null,null));
});})(s__74705__$1,x_SINGLEQUOTE_,xs__6277__auto__,temp__5720__auto__,map__74702,map__74702__$1,w,h,x,y))
;
var fs__4520__auto__ = cljs.core.seq.call(null,iterys__4519__auto__(cljs.core.range.call(null,h)));
if(fs__4520__auto__){
return cljs.core.concat.call(null,fs__4520__auto__,nubank$workspaces$ui$fits_in_QMARK__$_iter__74704.call(null,cljs.core.rest.call(null,s__74705__$1)));
} else {
var G__76179 = cljs.core.rest.call(null,s__74705__$1);
s__74705__$1 = G__76179;
continue;
}
} else {
return null;
}
break;
}
});})(map__74702,map__74702__$1,w,h,x,y))
,null,null));
});})(map__74702,map__74702__$1,w,h,x,y))
;
return iter__4523__auto__(cljs.core.range.call(null,w));
})();
return cljs.core.every_QMARK_.call(null,((function (coords,map__74702,map__74702__$1,w,h,x,y){
return (function (p1__74698_SHARP_){
return (!(cljs.core.contains_QMARK_.call(null,grid,p1__74698_SHARP_)));
});})(coords,map__74702,map__74702__$1,w,h,x,y))
,coords);
});
nubank.workspaces.ui.smart_item_position = (function nubank$workspaces$ui$smart_item_position(columns,p__74716,items){
var map__74717 = p__74716;
var map__74717__$1 = (((((!((map__74717 == null))))?(((((map__74717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74717):map__74717);
var new_item = map__74717__$1;
var w = cljs.core.get.call(null,map__74717__$1,"w");
var h = cljs.core.get.call(null,map__74717__$1,"h");
var grid = nubank.workspaces.ui.build_grid.call(null,items);
var w__$1 = (function (){var x__4222__auto__ = w;
var y__4223__auto__ = columns;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})();
var x = (0);
var y = (0);
while(true){
if(((x + w__$1) > columns)){
var G__76186 = (0);
var G__76187 = (y + (1));
x = G__76186;
y = G__76187;
continue;
} else {
var temp__5718__auto__ = cljs.core.get.call(null,grid,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null));
if(cljs.core.truth_(temp__5718__auto__)){
var block = temp__5718__auto__;
var G__76189 = (cljs.core.get.call(null,block,"x") + cljs.core.get.call(null,block,"w"));
var G__76190 = y;
x = G__76189;
y = G__76190;
continue;
} else {
if(nubank.workspaces.ui.fits_in_QMARK_.call(null,nubank.workspaces.ui.block.call(null,w__$1,h,x,y),grid)){
return cljs.core.assoc.call(null,new_item,"x",x,"y",y,"w",w__$1);
} else {
var G__76192 = (x + (1));
var G__76193 = y;
x = G__76192;
y = G__76193;
continue;
}
}
}
break;
}
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","pick-card-to-namespace","nubank.workspaces.ui/pick-card-to-namespace",1745669749,null),(function (fulcro_incoming_env,_,p__74723){
var map__74724 = p__74723;
var map__74724__$1 = (((((!((map__74724 == null))))?(((((map__74724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74724.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74724):map__74724);
var card_id = cljs.core.get.call(null,map__74724__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
return cljs.core.merge.call(null,(function (){var map__74727 = fulcro_incoming_env;
var map__74727__$1 = (((((!((map__74727 == null))))?(((((map__74727.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74727.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74727):map__74727);
var env = map__74727__$1;
var state = cljs.core.get.call(null,map__74727__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var reconciler = cljs.core.get.call(null,map__74727__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74727,map__74727__$1,env,state,reconciler,map__74724,map__74724__$1,card_id){
return (function (){
var ws_ref = nubank.workspaces.ui.active_workspace_ref.call(null,env);
var current_ws = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ws_ref);
var card = nubank.workspaces.data.card_definition.call(null,card_id);
if(cljs.core.truth_(new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950).cljs$core$IFn$_invoke$arity$1(current_ws))){
return console.warn("Can't add card to static workspace, please duplicate the workspace to add cards.");
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cljs.core.first.call(null,ws_ref))){
return console.warn("Can't add card to solo card, please switch a local workspace.");
} else {
if(cljs.core.contains_QMARK_.call(null,nubank.workspaces.ui.workspace_card_ids.call(null,current_ws),card_id)){
return null;
} else {
fulcro.client.primitives.merge_component_BANG_.call(null,reconciler,nubank.workspaces.ui.WorkspaceCard,fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.WorkspaceCard,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id], null)),new cljs.core.Keyword(null,"append","append",-291298229),cljs.core.conj.call(null,ws_ref,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701)));

return cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,ws_ref,cljs.core.update,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),((function (ws_ref,current_ws,card,map__74727,map__74727__$1,env,state,reconciler,map__74724,map__74724__$1,card_id){
return (function (layouts){
return cljs.core.reduce.call(null,((function (ws_ref,current_ws,card,map__74727,map__74727__$1,env,state,reconciler,map__74724,map__74724__$1,card_id){
return (function (l,p__74731){
var map__74732 = p__74731;
var map__74732__$1 = (((((!((map__74732 == null))))?(((((map__74732.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74732.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74732):map__74732);
var id = cljs.core.get.call(null,map__74732__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var cols = cljs.core.get.call(null,map__74732__$1,new cljs.core.Keyword(null,"cols","cols",-1914801295));
return cljs.core.update.call(null,l,id,cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),nubank.workspaces.ui.smart_item_position.call(null,cols,new cljs.core.PersistentArrayMap(null, 6, ["i",card_id,"w",(function (){var or__4131__auto__ = new cljs.core.Keyword("nubank.workspaces.model","card-width","nubank.workspaces.model/card-width",-1929280730).cljs$core$IFn$_invoke$arity$1(card);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (2);
}
})(),"h",(function (){var or__4131__auto__ = new cljs.core.Keyword("nubank.workspaces.model","card-height","nubank.workspaces.model/card-height",1579539064).cljs$core$IFn$_invoke$arity$1(card);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (4);
}
})(),"x",(0),"y",(100),"minH",(2)], null),cljs.core.get.call(null,l,id,cljs.core.PersistentVector.EMPTY)));
});})(ws_ref,current_ws,card,map__74727,map__74727__$1,env,state,reconciler,map__74724,map__74724__$1,card_id))
,layouts,nubank.workspaces.ui.grid_layout.breakpoints);
});})(ws_ref,current_ws,card,map__74727,map__74727__$1,env,state,reconciler,map__74724,map__74724__$1,card_id))
);
}

}
}
});})(map__74727,map__74727__$1,env,state,reconciler,map__74724,map__74724__$1,card_id))
], null);
})());
}));
nubank.workspaces.ui.add_card = (function nubank$workspaces$ui$add_card(this$,card_id){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","pick-card-to-namespace","nubank.workspaces.ui/pick-card-to-namespace",1745669749,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),null,(1),null)),(new cljs.core.List(null,card_id,null,(1),null)))))),null,(1),null)))))], null));
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","open-solo-workspace","nubank.workspaces.ui/open-solo-workspace",-1902644014,null),(function (fulcro_incoming_env,_,p__74737){
var map__74738 = p__74737;
var map__74738__$1 = (((((!((map__74738 == null))))?(((((map__74738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74738.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74738):map__74738);
var card_id = cljs.core.get.call(null,map__74738__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
return cljs.core.merge.call(null,(function (){var map__74740 = fulcro_incoming_env;
var map__74740__$1 = (((((!((map__74740 == null))))?(((((map__74740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74740):map__74740);
var state = cljs.core.get.call(null,map__74740__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__74740__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74740,map__74740__$1,state,ref,map__74738,map__74738__$1,card_id){
return (function (){
var ws_ident = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id], null);
fulcro.client.primitives.integrate_ident_BANG_.call(null,state,ws_ident,new cljs.core.Keyword(null,"append","append",-291298229),cljs.core.conj.call(null,ref,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447)),new cljs.core.Keyword(null,"replace","replace",-786587770),cljs.core.conj.call(null,ref,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814)));

nubank.workspaces.lib.local_storage.update_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),ws_ident);

return nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),ws_ident);
});})(map__74740,map__74740__$1,state,ref,map__74738,map__74738__$1,card_id))
], null);
})());
}));
nubank.workspaces.ui.add_card_solo = (function nubank$workspaces$ui$add_card_solo(this$,card_id){
return fulcro.client.primitives.transact_BANG_.call(null,fulcro.client.primitives.get_reconciler.call(null,this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","open-solo-workspace","nubank.workspaces.ui/open-solo-workspace",-1902644014,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id], null),null,(1),null)))))], null));
});
nubank.workspaces.ui.normalize_layout = (function nubank$workspaces$ui$normalize_layout(layout){
return cljs.core.mapv.call(null,(function (p1__74744_SHARP_){
return cljs.core.update.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__74748){
var vec__74749 = p__74748;
var _ = cljs.core.nth.call(null,vec__74749,(0),null);
var v = cljs.core.nth.call(null,vec__74749,(1),null);
return v;
})),p1__74744_SHARP_),"i",cljs.core.symbol);
}),layout);
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","normalize-sizes","nubank.workspaces.ui/normalize-sizes",1530582337,null),(function (fulcro_incoming_env,_,___$1){
return cljs.core.merge.call(null,(function (){var map__74762 = fulcro_incoming_env;
var map__74762__$1 = (((((!((map__74762 == null))))?(((((map__74762.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74762.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74762):map__74762);
var state = cljs.core.get.call(null,map__74762__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__74762__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74762,map__74762__$1,state,ref){
return (function (){
var ws = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ref);
var items = nubank.workspaces.ui.map_values.call(null,cljs.core.first,cljs.core.group_by.call(null,((function (ws,map__74762,map__74762__$1,state,ref){
return (function (p1__74756_SHARP_){
return cljs.core.get.call(null,p1__74756_SHARP_,"i");
});})(ws,map__74762,map__74762__$1,state,ref))
,cljs.core.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716).cljs$core$IFn$_invoke$arity$1(ws),new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841).cljs$core$IFn$_invoke$arity$1(ws))));
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,ref,cljs.core.update,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),((function (ws,items,map__74762,map__74762__$1,state,ref){
return (function (breaks){
return nubank.workspaces.ui.map_values.call(null,((function (ws,items,map__74762,map__74762__$1,state,ref){
return (function (layouts){
return cljs.core.mapv.call(null,((function (ws,items,map__74762,map__74762__$1,state,ref){
return (function (p1__74758_SHARP_){
var temp__5718__auto__ = cljs.core.get.call(null,items,cljs.core.get.call(null,p1__74758_SHARP_,"i"));
if(cljs.core.truth_(temp__5718__auto__)){
var map__74764 = temp__5718__auto__;
var map__74764__$1 = (((((!((map__74764 == null))))?(((((map__74764.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74764.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74764):map__74764);
var w = cljs.core.get.call(null,map__74764__$1,"w");
var h = cljs.core.get.call(null,map__74764__$1,"h");
var x = cljs.core.get.call(null,map__74764__$1,"x");
var y = cljs.core.get.call(null,map__74764__$1,"y");
return cljs.core.assoc.call(null,p1__74758_SHARP_,"w",w,"h",h,"x",x,"y",y);
} else {
return p1__74758_SHARP_;
}
});})(ws,items,map__74762,map__74762__$1,state,ref))
,layouts);
});})(ws,items,map__74762,map__74762__$1,state,ref))
,breaks);
});})(ws,items,map__74762,map__74762__$1,state,ref))
);

return nubank.workspaces.ui.save_local_workspace.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ref));
});})(map__74762,map__74762__$1,state,ref))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","update-workspace","nubank.workspaces.ui/update-workspace",-2145331844,null),(function (fulcro_incoming_env,_,p__74768){
var map__74769 = p__74768;
var map__74769__$1 = (((((!((map__74769 == null))))?(((((map__74769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74769):map__74769);
var ws = map__74769__$1;
var workspace_id = cljs.core.get.call(null,map__74769__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_static_QMARK_ = cljs.core.get.call(null,map__74769__$1,new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950));
return cljs.core.merge.call(null,(function (){var map__74774 = fulcro_incoming_env;
var map__74774__$1 = (((((!((map__74774 == null))))?(((((map__74774.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74774.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74774):map__74774);
var state = cljs.core.get.call(null,map__74774__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74774,map__74774__$1,state,map__74769,map__74769__$1,ws,workspace_id,workspace_static_QMARK_){
return (function (){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id], null),cljs.core.merge,ws);

if(cljs.core.not(workspace_static_QMARK_)){
return nubank.workspaces.ui.save_local_workspace.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id], null)));
} else {
return null;
}
});})(map__74774,map__74774__$1,state,map__74769,map__74769__$1,ws,workspace_id,workspace_static_QMARK_))
], null);
})(),(function (){var ___$1 = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh","refresh",1947415525),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450)], null)], null);
})());
}));
nubank.workspaces.ui.ws_data__GT_ident_map = (function nubank$workspaces$ui$ws_data__GT_ident_map(x){
if(cljs.core.vector_QMARK_.call(null,x)){
return cljs.core.apply.call(null,cljs.core.hash_map,x);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),x], null);
}
});
nubank.workspaces.ui.workspace_id_QMARK_ = (function nubank$workspaces$ui$workspace_id_QMARK_(x){
return ((cljs.core.uuid_QMARK_.call(null,x)) || ((x instanceof cljs.core.Symbol)));
});
nubank.workspaces.ui.workspace_ident = (function nubank$workspaces$ui$workspace_ident(p__74780){
var map__74781 = p__74780;
var map__74781__$1 = (((((!((map__74781 == null))))?(((((map__74781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74781):map__74781);
var workspace_id = cljs.core.get.call(null,map__74781__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var card_id = cljs.core.get.call(null,map__74781__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
if(nubank.workspaces.ui.workspace_id_QMARK_.call(null,workspace_id)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id], null);
} else {
if(cljs.core.truth_(card_id)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),card_id], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"invalid","invalid",412869516),"ident"], null);

}
}
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","close-workspace","nubank.workspaces.ui/close-workspace",-1735247601,null),(function (fulcro_incoming_env,_,p__74789){
var map__74790 = p__74789;
var map__74790__$1 = (((((!((map__74790 == null))))?(((((map__74790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74790):map__74790);
var ws_data = map__74790__$1;
var workspace_id = cljs.core.get.call(null,map__74790__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
return cljs.core.merge.call(null,(function (){var map__74797 = fulcro_incoming_env;
var map__74797__$1 = (((((!((map__74797 == null))))?(((((map__74797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74797.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74797):map__74797);
var state = cljs.core.get.call(null,map__74797__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74797,map__74797__$1,state,map__74790,map__74790__$1,ws_data,workspace_id){
return (function (){
var ws_ref = nubank.workspaces.ui.workspace_ident.call(null,ws_data);
var ws = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ws_ref);
var card_ids = nubank.workspaces.ui.workspace_card_ids.call(null,ws);
var tabs_ref = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton"], null);
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,tabs_ref,cljs.core.update,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),((function (ws_ref,ws,card_ids,tabs_ref,map__74797,map__74797__$1,state,map__74790,map__74790__$1,ws_data,workspace_id){
return (function (p1__74785_SHARP_){
return cljs.core.filterv.call(null,((function (ws_ref,ws,card_ids,tabs_ref,map__74797,map__74797__$1,state,map__74790,map__74790__$1,ws_data,workspace_id){
return (function (x){
return cljs.core.not_EQ_.call(null,x,ws_ref);
});})(ws_ref,ws,card_ids,tabs_ref,map__74797,map__74797__$1,state,map__74790,map__74790__$1,ws_data,workspace_id))
,p1__74785_SHARP_);
});})(ws_ref,ws,card_ids,tabs_ref,map__74797,map__74797__$1,state,map__74790,map__74790__$1,ws_data,workspace_id))
);

if(cljs.core._EQ_.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,tabs_ref,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814))),ws_ref)){
var active_ref_76333 = cljs.core.first.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447).cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cljs.core.deref.call(null,state),tabs_ref)));
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,tabs_ref,cljs.core.assoc,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),cljs.core.first.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447).cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cljs.core.deref.call(null,state),tabs_ref))));

nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),active_ref_76333);
} else {
}

nubank.workspaces.lib.local_storage.update_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.disj,workspace_id,ws_ref);

return nubank.workspaces.ui.disposed_unreferenced_cards.call(null,cljs.core.deref.call(null,state),card_ids);
});})(map__74797,map__74797__$1,state,map__74790,map__74790__$1,ws_data,workspace_id))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","remove-workspace","nubank.workspaces.ui/remove-workspace",-1845546964,null),(function (fulcro_incoming_env,_,p__74801){
var map__74802 = p__74801;
var map__74802__$1 = (((((!((map__74802 == null))))?(((((map__74802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74802.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74802):map__74802);
var workspace_id = cljs.core.get.call(null,map__74802__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
return cljs.core.merge.call(null,(function (){var map__74805 = fulcro_incoming_env;
var map__74805__$1 = (((((!((map__74805 == null))))?(((((map__74805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74805):map__74805);
var state = cljs.core.get.call(null,map__74805__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74805,map__74805__$1,state,map__74802,map__74802__$1,workspace_id){
return (function (){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450)], null),((function (map__74805,map__74805__$1,state,map__74802,map__74802__$1,workspace_id){
return (function (p1__74800_SHARP_){
return cljs.core.filterv.call(null,((function (map__74805,map__74805__$1,state,map__74802,map__74802__$1,workspace_id){
return (function (x){
return cljs.core.not_EQ_.call(null,cljs.core.second.call(null,x),workspace_id);
});})(map__74805,map__74805__$1,state,map__74802,map__74802__$1,workspace_id))
,p1__74800_SHARP_);
});})(map__74805,map__74805__$1,state,map__74802,map__74802__$1,workspace_id))
);

cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),cljs.core.dissoc,workspace_id);

nubank.workspaces.lib.local_storage.update_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","local-workspaces","nubank.workspaces.ui/local-workspaces",-1846378387),cljs.core.disj,workspace_id);

return nubank.workspaces.lib.local_storage.remove_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id], null));
});})(map__74805,map__74805__$1,state,map__74802,map__74802__$1,workspace_id))
], null);
})(),(function (){var ___$1 = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh","refresh",1947415525),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450)], null)], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","create-workspace","nubank.workspaces.ui/create-workspace",-404659908,null),(function (fulcro_incoming_env,_,ws){
return cljs.core.merge.call(null,(function (){var map__74812 = fulcro_incoming_env;
var map__74812__$1 = (((((!((map__74812 == null))))?(((((map__74812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74812.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74812):map__74812);
var env = map__74812__$1;
var ref = cljs.core.get.call(null,map__74812__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74812,map__74812__$1,env,ref){
return (function (){
var map__74816 = nubank.workspaces.ui.save_local_workspace.call(null,nubank.workspaces.ui.create_workspace_STAR_.call(null,env,(function (){var or__4131__auto__ = ws;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"append","append",-291298229),cljs.core.conj.call(null,ref,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447)),new cljs.core.Keyword(null,"replace","replace",-786587770),cljs.core.conj.call(null,ref,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814))));
var map__74816__$1 = (((((!((map__74816 == null))))?(((((map__74816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74816.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74816):map__74816);
var workspace_id = cljs.core.get.call(null,map__74816__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
return nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),workspace_id);
});})(map__74812,map__74812__$1,env,ref))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","copy-breakpoint-layout","nubank.workspaces.ui/copy-breakpoint-layout",1066150982,null),(function (fulcro_incoming_env,_,p__74822){
var map__74823 = p__74822;
var map__74823__$1 = (((((!((map__74823 == null))))?(((((map__74823.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74823.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74823):map__74823);
var source_breakpoint = cljs.core.get.call(null,map__74823__$1,new cljs.core.Keyword("nubank.workspaces.ui","source-breakpoint","nubank.workspaces.ui/source-breakpoint",1683194315));
return cljs.core.merge.call(null,(function (){var map__74828 = fulcro_incoming_env;
var map__74828__$1 = (((((!((map__74828 == null))))?(((((map__74828.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74828.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74828):map__74828);
var state = cljs.core.get.call(null,map__74828__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__74828__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__74828,map__74828__$1,state,ref,map__74823,map__74823__$1,source_breakpoint){
return (function (){
var map__74830 = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ref);
var map__74830__$1 = (((((!((map__74830 == null))))?(((((map__74830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74830.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74830):map__74830);
var breakpoint = cljs.core.get.call(null,map__74830__$1,new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841));
var layouts = cljs.core.get.call(null,map__74830__$1,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716));
return cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,ref,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),breakpoint], null),cljs.core.get.call(null,layouts,source_breakpoint));
});})(map__74828,map__74828__$1,state,ref,map__74823,map__74823__$1,source_breakpoint))
], null);
})());
}));
nubank.workspaces.ui.export_card_size = (function nubank$workspaces$ui$export_card_size(this$,card_id){
var map__74844 = fulcro.client.primitives.props.call(null,this$);
var map__74844__$1 = (((((!((map__74844 == null))))?(((((map__74844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74844.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74844):map__74844);
var layouts = cljs.core.get.call(null,map__74844__$1,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716));
var breakpoint = cljs.core.get.call(null,map__74844__$1,new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841));
var map__74845 = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__74844,map__74844__$1,layouts,breakpoint){
return (function (p1__74835_SHARP_){
return cljs.core._EQ_.call(null,card_id,cljs.core.get.call(null,p1__74835_SHARP_,"i"));
});})(map__74844,map__74844__$1,layouts,breakpoint))
,cljs.core.get.call(null,layouts,breakpoint)));
var map__74845__$1 = (((((!((map__74845 == null))))?(((((map__74845.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74845.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74845):map__74845);
var w = cljs.core.get.call(null,map__74845__$1,"w");
var h = cljs.core.get.call(null,map__74845__$1,"h");
return console.log(["{::wsm/card-width ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(w)," ::wsm/card-height ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(h),"}"].join(''));
});
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.Workspace !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.Workspace = (function nubank$workspaces$ui$Workspace(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.Workspace.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","Workspace","nubank.workspaces.ui/Workspace",1485031084),nubank.workspaces.ui.Workspace);

var x74873_76385 = nubank.workspaces.ui.Workspace.prototype;
x74873_76385.render = ((function (x74873_76385){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__74874 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__74875 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__74876 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__74877 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__74878 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__74879 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__74880 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__74881 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__74882 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__74883 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__74879;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__74880;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__74881;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__74882;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__74883;

try{var map__74884 = fulcro.client.primitives.props.call(null,this$);
var map__74884__$1 = (((((!((map__74884 == null))))?(((((map__74884.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74884.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74884):map__74884);
var workspace_id = cljs.core.get.call(null,map__74884__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var cards = cljs.core.get.call(null,map__74884__$1,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701));
var layouts = cljs.core.get.call(null,map__74884__$1,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716));
var breakpoint = cljs.core.get.call(null,map__74884__$1,new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841));
var workspace_title = cljs.core.get.call(null,map__74884__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
var workspace_static_QMARK_ = cljs.core.get.call(null,map__74884__$1,new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950));
var map__74885 = fulcro.client.primitives.get_computed.call(null,this$);
var map__74885__$1 = (((((!((map__74885 == null))))?(((((map__74885.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74885.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74885):map__74885);
var open_solo_card = cljs.core.get.call(null,map__74885__$1,new cljs.core.Keyword("nubank.workspaces.ui","open-solo-card","nubank.workspaces.ui/open-solo-card",-1371578732));
if(cljs.core.truth_(fulcro.client.primitives.get_state.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944)))){
return fulcro.client.localized_dom.div.call(null,"Some error leaked to workspace level (ugh...), please report this and check console for details.");
} else {
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container$workspaces-workspace-container",".container$workspaces-workspace-container",-1077330955),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".tools",".tools",-438409224),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".breakpoint",".breakpoint",790298917),cljs.core.str.cljs$core$IFn$_invoke$arity$1(breakpoint)),((cljs.core.not(workspace_static_QMARK_))?fulcro.client.localized_dom.select.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),"-",new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (e){
fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","copy-breakpoint-layout","nubank.workspaces.ui/copy-breakpoint-layout",1066150982,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","source-breakpoint","nubank.workspaces.ui/source-breakpoint",1683194315),e.target.value], null),null,(1),null)))))], null));

return goog.object.set(e.target,"selectedIndex",(0));
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
], null),fulcro.client.localized_dom.option.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),"-"], null),"Copy layout"),(function (){var iter__4523__auto__ = ((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function nubank$workspaces$ui$iter__74896(s__74897){
return (new cljs.core.LazySeq(null,((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
var s__74897__$1 = s__74897;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__74897__$1);
if(temp__5720__auto__){
var s__74897__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__74897__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__74897__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__74899 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__74898 = (0);
while(true){
if((i__74898 < size__4522__auto__)){
var map__74912 = cljs.core._nth(c__4521__auto__,i__74898);
var map__74912__$1 = (((((!((map__74912 == null))))?(((((map__74912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74912.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74912):map__74912);
var id = cljs.core.get.call(null,map__74912__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
cljs.core.chunk_append.call(null,b__74899,fulcro.client.localized_dom.option.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),id,new cljs.core.Keyword(null,"value","value",305978217),id], null),id));

var G__76435 = (i__74898 + (1));
i__74898 = G__76435;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74899),nubank$workspaces$ui$iter__74896.call(null,cljs.core.chunk_rest.call(null,s__74897__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74899),null);
}
} else {
var map__74923 = cljs.core.first.call(null,s__74897__$2);
var map__74923__$1 = (((((!((map__74923 == null))))?(((((map__74923.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74923.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74923):map__74923);
var id = cljs.core.get.call(null,map__74923__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return cljs.core.cons.call(null,fulcro.client.localized_dom.option.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),id,new cljs.core.Keyword(null,"value","value",305978217),id], null),id),nubank$workspaces$ui$iter__74896.call(null,cljs.core.rest.call(null,s__74897__$2)));
}
} else {
return null;
}
break;
}
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
,null,null));
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
;
return iter__4523__auto__(nubank.workspaces.ui.grid_layout.breakpoints);
})()):null),nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
return nubank.workspaces.ui.refresh_cards.call(null,nubank.workspaces.ui.active_workspace_cards.call(null,fulcro.client.primitives.get_reconciler.call(null,this$)),false);
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
], null),"Refresh cards"),nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,fulcro.client.primitives.get_reconciler.call(null,this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","create-workspace","nubank.workspaces.ui/create-workspace",-404659908,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_title)," copy"].join(''),new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),layouts], null),null,(1),null)))))], null));
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
], null),"Duplicate"),((cljs.core.not(workspace_static_QMARK_))?nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","normalize-sizes","nubank.workspaces.ui/normalize-sizes",1530582337,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)))))], null));
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
], null),"Unify layouts"):null),((cljs.core.not(workspace_static_QMARK_))?nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
return console.log((function (){var writer = cognitect.transit.writer.call(null,new cljs.core.Keyword(null,"json","json",1279968570));
return cljs.core.pr_str.call(null,cognitect.transit.write.call(null,writer,layouts));
})());
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
], null),"Export"):null),((cljs.core.not(workspace_static_QMARK_))?nubank.workspaces.ui.core.button.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
if(cljs.core.truth_(confirm("Delete workspace?"))){
fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","close-workspace","nubank.workspaces.ui/close-workspace",-1735247601,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));

return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","remove-workspace","nubank.workspaces.ui/remove-workspace",-1845546964,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));
} else {
return null;
}
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
], null),"Delete"):null)),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".grid",".grid",1505444140),(cljs.core.truth_(fulcro.client.primitives.get_state.call(null,this$,new cljs.core.Keyword(null,"render?","render?",-1838581524)))?nubank.workspaces.ui.grid_layout.grid_layout.call(null,(function (){var G__74947 = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"className","className",-1983287057),["layout ",(cljs.core.truth_(workspace_static_QMARK_)?"cljs-workflow-static-workflow":null)].join(''),new cljs.core.Keyword(null,"rowHeight","rowHeight",1730581244),(30),new cljs.core.Keyword(null,"breakpoints","breakpoints",1018731739),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"breakpoint","breakpoint",1183378440))),nubank.workspaces.ui.grid_layout.breakpoints),new cljs.core.Keyword(null,"cols","cols",-1914801295),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"cols","cols",-1914801295))),nubank.workspaces.ui.grid_layout.breakpoints),new cljs.core.Keyword(null,"layouts","layouts",11991539),layouts,new cljs.core.Keyword(null,"draggableHandle","draggableHandle",1358445442),".workspaces-cljs-card-drag-handle",new cljs.core.Keyword(null,"onBreakpointChange","onBreakpointChange",1104296229),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (bp,_){
return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841),bp);
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
,new cljs.core.Keyword(null,"onLayoutChange","onLayoutChange",-320596147),((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (_,layouts__$1){
var layouts_SINGLEQUOTE_ = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (p__74954){
var vec__74955 = p__74954;
var k = cljs.core.nth.call(null,vec__74955,(0),null);
var v = cljs.core.nth.call(null,vec__74955,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,nubank.workspaces.ui.normalize_layout.call(null,v)], null);
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
),cljs.core.js__GT_clj.call(null,layouts__$1));
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","update-workspace","nubank.workspaces.ui/update-workspace",-2145331844,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),layouts_SINGLEQUOTE_], null),null,(1),null)))))], null));
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
], null);
if(cljs.core.truth_(workspace_static_QMARK_)){
return cljs.core.assoc.call(null,G__74947,new cljs.core.Keyword(null,"isDraggable","isDraggable",-181233715),false,new cljs.core.Keyword(null,"isResizable","isResizable",1591995984),false,new cljs.core.Keyword(null,"onLayoutChange","onLayoutChange",-320596147),((function (G__74947,map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (_,___$1){
return null;
});})(G__74947,map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
);
} else {
return G__74947;
}
})(),(function (){var iter__4523__auto__ = ((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function nubank$workspaces$ui$iter__74962(s__74963){
return (new cljs.core.LazySeq(null,((function (map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
var s__74963__$1 = s__74963;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__74963__$1);
if(temp__5720__auto__){
var s__74963__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__74963__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__74963__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__74965 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__74964 = (0);
while(true){
if((i__74964 < size__4522__auto__)){
var map__74968 = cljs.core._nth(c__4521__auto__,i__74964);
var map__74968__$1 = (((((!((map__74968 == null))))?(((((map__74968.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74968.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74968):map__74968);
var card = map__74968__$1;
var card_id = cljs.core.get.call(null,map__74968__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
if(cljs.core.truth_(card_id)){
cljs.core.chunk_append.call(null,b__74965,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(card_id)], null),nubank.workspaces.ui.workspace_card.call(null,fulcro.client.primitives.computed.call(null,card,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","export-size","nubank.workspaces.ui/export-size",1661946281),((function (i__74964,s__74963__$1,map__74968,map__74968__$1,card,card_id,c__4521__auto__,size__4522__auto__,b__74965,s__74963__$2,temp__5720__auto__,map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
return nubank.workspaces.ui.export_card_size.call(null,this$,card_id);
});})(i__74964,s__74963__$1,map__74968,map__74968__$1,card,card_id,c__4521__auto__,size__4522__auto__,b__74965,s__74963__$2,temp__5720__auto__,map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
,new cljs.core.Keyword("nubank.workspaces.ui","open-solo-card","nubank.workspaces.ui/open-solo-card",-1371578732),open_solo_card], null)))));

var G__76657 = (i__74964 + (1));
i__74964 = G__76657;
continue;
} else {
var G__76659 = (i__74964 + (1));
i__74964 = G__76659;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74965),nubank$workspaces$ui$iter__74962.call(null,cljs.core.chunk_rest.call(null,s__74963__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74965),null);
}
} else {
var map__74970 = cljs.core.first.call(null,s__74963__$2);
var map__74970__$1 = (((((!((map__74970 == null))))?(((((map__74970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74970):map__74970);
var card = map__74970__$1;
var card_id = cljs.core.get.call(null,map__74970__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
if(cljs.core.truth_(card_id)){
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(card_id)], null),nubank.workspaces.ui.workspace_card.call(null,fulcro.client.primitives.computed.call(null,card,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","export-size","nubank.workspaces.ui/export-size",1661946281),((function (s__74963__$1,map__74970,map__74970__$1,card,card_id,s__74963__$2,temp__5720__auto__,map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385){
return (function (){
return nubank.workspaces.ui.export_card_size.call(null,this$,card_id);
});})(s__74963__$1,map__74970,map__74970__$1,card,card_id,s__74963__$2,temp__5720__auto__,map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
,new cljs.core.Keyword("nubank.workspaces.ui","open-solo-card","nubank.workspaces.ui/open-solo-card",-1371578732),open_solo_card], null)))),nubank$workspaces$ui$iter__74962.call(null,cljs.core.rest.call(null,s__74963__$2)));
} else {
var G__76669 = cljs.core.rest.call(null,s__74963__$2);
s__74963__$1 = G__76669;
continue;
}
}
} else {
return null;
}
break;
}
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
,null,null));
});})(map__74884,map__74884__$1,workspace_id,cards,layouts,breakpoint,workspace_title,workspace_static_QMARK_,map__74885,map__74885__$1,open_solo_card,_STAR_reconciler_STAR__orig_val__74874,_STAR_depth_STAR__orig_val__74875,_STAR_shared_STAR__orig_val__74876,_STAR_instrument_STAR__orig_val__74877,_STAR_parent_STAR__orig_val__74878,_STAR_reconciler_STAR__temp_val__74879,_STAR_depth_STAR__temp_val__74880,_STAR_shared_STAR__temp_val__74881,_STAR_instrument_STAR__temp_val__74882,_STAR_parent_STAR__temp_val__74883,this$,this__59535__auto__,x74873_76385))
;
return iter__4523__auto__(cards);
})()):null)));
}
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__74878;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__74877;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__74876;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__74875;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__74874;
}});})(x74873_76385))
;

x74873_76385.componentDidCatch = ((function (x74873_76385){
return (function (error,info){
var this$ = this;
cljs.core.swap_BANG_.call(null,nubank.workspaces.ui.components_with_error,cljs.core.conj,this$);

return fulcro.client.primitives.set_state_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944),true], null));
});})(x74873_76385))
;

x74873_76385.componentDidMount = ((function (x74873_76385){
return (function (){
var this__59519__auto__ = this;
var this$ = this__59519__auto__;
var reconciler__59520__auto__ = fulcro.client.primitives.get_reconciler.call(null,this__59519__auto__);
var lifecycle__59521__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"lifecycle","lifecycle",341496205)], null));
var indexer__59522__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
goog.object.set(this__59519__auto__,"fulcro$mounted",true);

if((indexer__59522__auto__ == null)){
} else {
fulcro.client.impl.protocols.index_component_BANG_(indexer__59522__auto__,this__59519__auto__);
}

if(cljs.core.truth_(lifecycle__59521__auto__)){
lifecycle__59521__auto__.call(null,this__59519__auto__,new cljs.core.Keyword(null,"mount","mount",-1560582470));
} else {
}

return requestAnimationFrame(((function (this$,reconciler__59520__auto__,lifecycle__59521__auto__,indexer__59522__auto__,this__59519__auto__,x74873_76385){
return (function (){
return fulcro.client.primitives.set_state_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render?","render?",-1838581524),true], null));
});})(this$,reconciler__59520__auto__,lifecycle__59521__auto__,indexer__59522__auto__,this__59519__auto__,x74873_76385))
);
});})(x74873_76385))
;


nubank.workspaces.ui.Workspace.prototype.constructor = nubank.workspaces.ui.Workspace;

nubank.workspaces.ui.Workspace.prototype.constructor.displayName = "nubank.workspaces.ui/Workspace";

nubank.workspaces.ui.Workspace.prototype.fulcro$isComponent = true;

var x74973_76677 = nubank.workspaces.ui.Workspace;
x74973_76677.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x74973_76677.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x74973_76677){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".grid",".grid",1505444140),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"overflow-y","overflow-y",-1436589285),"scroll",new cljs.core.Keyword(null,"overflow-x","overflow-x",-26547754),"hidden"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".tools",".tools",-438409224),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"color","color",1011675173),nubank.workspaces.ui.core.color_limed_spruce,new cljs.core.Keyword(null,"padding","padding",1660304693),"5px 9px",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"5px"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".breakpoint",".breakpoint",790298917),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1"], null)], null)], null);
});})(x74973_76677))
;

x74973_76677.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x74973_76677){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [nubank.workspaces.ui.grid_layout.GridLayout], null);
});})(x74973_76677))
;

x74973_76677.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x74973_76677.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x74973_76677){
return (function (this$,p__74974){
var map__74975 = p__74974;
var map__74975__$1 = (((((!((map__74975 == null))))?(((((map__74975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74975):map__74975);
var ws = map__74975__$1;
var layouts = cljs.core.get.call(null,map__74975__$1,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716));
var workspace_title = cljs.core.get.call(null,map__74975__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
var workspace_id = cljs.core.get.call(null,map__74975__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var this$__$1 = this;
var layouts__$1 = (function (){var or__4131__auto__ = layouts;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return cljs.core.merge.call(null,ws,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),(function (){var or__4131__auto__ = workspace_id;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.random_uuid.call(null);
}
})(),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),(function (){var or__4131__auto__ = workspace_title;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "new workspace";
}
})(),new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),(function (){var or__4131__auto__ = (function (){var G__74989 = layouts__$1;
var G__74989__$1 = (((G__74989 == null))?null:cljs.core.first.call(null,G__74989));
var G__74989__$2 = (((G__74989__$1 == null))?null:cljs.core.val.call(null,G__74989__$1));
if((G__74989__$2 == null)){
return null;
} else {
return cljs.core.mapv.call(null,((function (G__74989,G__74989__$1,G__74989__$2,layouts__$1,this$__$1,map__74975,map__74975__$1,ws,layouts,workspace_title,workspace_id,x74973_76677){
return (function (p1__74861_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cljs.core.get.call(null,p1__74861_SHARP_,"i")],null));
});})(G__74989,G__74989__$1,G__74989__$2,layouts__$1,this$__$1,map__74975,map__74975__$1,ws,layouts,workspace_title,workspace_id,x74973_76677))
,G__74989__$2);
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),layouts__$1,new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841),""], null));
});})(x74973_76677))
;

x74973_76677.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x74973_76677.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x74973_76677){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x74973_76677))
;

x74973_76677.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x74973_76677.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x74973_76677){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceCard)], null)], null);
});})(x74973_76677))
;


var x74996_76695 = nubank.workspaces.ui.Workspace.prototype;
x74996_76695.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x74996_76695.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x74996_76695){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".grid",".grid",1505444140),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"overflow-y","overflow-y",-1436589285),"scroll",new cljs.core.Keyword(null,"overflow-x","overflow-x",-26547754),"hidden"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".tools",".tools",-438409224),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"color","color",1011675173),nubank.workspaces.ui.core.color_limed_spruce,new cljs.core.Keyword(null,"padding","padding",1660304693),"5px 9px",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"5px"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".breakpoint",".breakpoint",790298917),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1"], null)], null)], null);
});})(x74996_76695))
;

x74996_76695.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x74996_76695){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [nubank.workspaces.ui.grid_layout.GridLayout], null);
});})(x74996_76695))
;

x74996_76695.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x74996_76695.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x74996_76695){
return (function (this$,p__75003){
var map__75004 = p__75003;
var map__75004__$1 = (((((!((map__75004 == null))))?(((((map__75004.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75004.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75004):map__75004);
var ws = map__75004__$1;
var layouts = cljs.core.get.call(null,map__75004__$1,new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716));
var workspace_title = cljs.core.get.call(null,map__75004__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
var workspace_id = cljs.core.get.call(null,map__75004__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var this$__$1 = this;
var layouts__$1 = (function (){var or__4131__auto__ = layouts;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return cljs.core.merge.call(null,ws,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),(function (){var or__4131__auto__ = workspace_id;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.random_uuid.call(null);
}
})(),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),(function (){var or__4131__auto__ = workspace_title;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "new workspace";
}
})(),new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),(function (){var or__4131__auto__ = (function (){var G__75010 = layouts__$1;
var G__75010__$1 = (((G__75010 == null))?null:cljs.core.first.call(null,G__75010));
var G__75010__$2 = (((G__75010__$1 == null))?null:cljs.core.val.call(null,G__75010__$1));
if((G__75010__$2 == null)){
return null;
} else {
return cljs.core.mapv.call(null,((function (G__75010,G__75010__$1,G__75010__$2,layouts__$1,this$__$1,map__75004,map__75004__$1,ws,layouts,workspace_title,workspace_id,x74996_76695){
return (function (p1__74861_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cljs.core.get.call(null,p1__74861_SHARP_,"i")],null));
});})(G__75010,G__75010__$1,G__75010__$2,layouts__$1,this$__$1,map__75004,map__75004__$1,ws,layouts,workspace_title,workspace_id,x74996_76695))
,G__75010__$2);
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),layouts__$1,new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841),""], null));
});})(x74996_76695))
;

x74996_76695.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x74996_76695.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x74996_76695){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x74996_76695))
;

x74996_76695.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x74996_76695.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x74996_76695){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","layouts","nubank.workspaces.ui/layouts",1429280716),new cljs.core.Keyword("nubank.workspaces.ui","breakpoint","nubank.workspaces.ui/breakpoint",-1694045841),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceCard)], null)], null);
});})(x74996_76695))
;


nubank.workspaces.ui.Workspace.cljs$lang$type = true;

nubank.workspaces.ui.Workspace.cljs$lang$ctorStr = "nubank.workspaces.ui/Workspace";

nubank.workspaces.ui.Workspace.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/Workspace");
});
nubank.workspaces.ui.workspace = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.Workspace,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858)], null));
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.WorkspaceContainer !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.WorkspaceContainer = (function nubank$workspaces$ui$WorkspaceContainer(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.WorkspaceContainer.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","WorkspaceContainer","nubank.workspaces.ui/WorkspaceContainer",171698625),nubank.workspaces.ui.WorkspaceContainer);

var x75028_76723 = nubank.workspaces.ui.WorkspaceContainer.prototype;
x75028_76723.render = ((function (x75028_76723){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__75029 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__75030 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__75031 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__75032 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__75033 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__75034 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__75035 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__75036 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__75037 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__75038 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__75034;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__75035;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__75036;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__75037;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__75038;

try{var props = fulcro.client.primitives.props.call(null,this$);
var map__75043 = fulcro.client.primitives.get_computed.call(null,this$);
var map__75043__$1 = (((((!((map__75043 == null))))?(((((map__75043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75043.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75043):map__75043);
var open_solo_card = cljs.core.get.call(null,map__75043__$1,new cljs.core.Keyword("nubank.workspaces.ui","open-solo-card","nubank.workspaces.ui/open-solo-card",-1371578732));
if(cljs.core.truth_(fulcro.client.primitives.get_state.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944)))){
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".error",".error",115475668),"Error rendering workspace, check console for details.");
} else {
var G__75046 = cljs.core.first.call(null,fulcro.client.primitives.get_ident.call(null,this$));
var G__75046__$1 = (((G__75046 instanceof cljs.core.Keyword))?G__75046.fqn:null);
switch (G__75046__$1) {
case "nubank.workspaces.ui/workspace-id":
return nubank.workspaces.ui.workspace.call(null,fulcro.client.primitives.computed.call(null,props,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","open-solo-card","nubank.workspaces.ui/open-solo-card",-1371578732),open_solo_card], null)));

break;
case "nubank.workspaces.model/card-id":
return nubank.workspaces.ui.workspace_solo_card.call(null,props);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__75046__$1)].join('')));

}
}
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__75033;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__75032;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__75031;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__75030;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__75029;
}});})(x75028_76723))
;

x75028_76723.componentDidCatch = ((function (x75028_76723){
return (function (error,info){
var this$ = this;
cljs.core.swap_BANG_.call(null,nubank.workspaces.ui.components_with_error,cljs.core.conj,this$);

return fulcro.client.primitives.set_state_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","error-catch?","nubank.workspaces.ui/error-catch?",1438279944),true], null));
});})(x75028_76723))
;


nubank.workspaces.ui.WorkspaceContainer.prototype.constructor = nubank.workspaces.ui.WorkspaceContainer;

nubank.workspaces.ui.WorkspaceContainer.prototype.constructor.displayName = "nubank.workspaces.ui/WorkspaceContainer";

nubank.workspaces.ui.WorkspaceContainer.prototype.fulcro$isComponent = true;

var x75050_76748 = nubank.workspaces.ui.WorkspaceContainer;
x75050_76748.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75050_76748.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75050_76748){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$workspaces-workspace-container","$workspaces-workspace-container",-495417857),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),"#9fa2ab",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".error",".error",115475668),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef0000",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null)], null);
});})(x75050_76748))
;

x75050_76748.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75050_76748){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75050_76748))
;

x75050_76748.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75050_76748.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75050_76748){
return (function (this$,props){
var this$__$1 = this;
return nubank.workspaces.ui.workspace_ident.call(null,props);
});})(x75050_76748))
;

x75050_76748.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75050_76748.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75050_76748){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.Workspace),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceSoloCard)], null);
});})(x75050_76748))
;


var x75054_76754 = nubank.workspaces.ui.WorkspaceContainer.prototype;
x75054_76754.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75054_76754.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75054_76754){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"$workspaces-workspace-container","$workspaces-workspace-container",-495417857),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),"#9fa2ab",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".error",".error",115475668),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef0000",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null)], null);
});})(x75054_76754))
;

x75054_76754.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75054_76754){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75054_76754))
;

x75054_76754.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75054_76754.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75054_76754){
return (function (this$,props){
var this$__$1 = this;
return nubank.workspaces.ui.workspace_ident.call(null,props);
});})(x75054_76754))
;

x75054_76754.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75054_76754.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75054_76754){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.Workspace),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceSoloCard)], null);
});})(x75054_76754))
;


nubank.workspaces.ui.WorkspaceContainer.cljs$lang$type = true;

nubank.workspaces.ui.WorkspaceContainer.cljs$lang$ctorStr = "nubank.workspaces.ui/WorkspaceContainer";

nubank.workspaces.ui.WorkspaceContainer.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/WorkspaceContainer");
});
nubank.workspaces.ui.workspace_container = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.WorkspaceContainer,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (p1__75061_SHARP_){
var or__4131__auto__ = new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(p1__75061_SHARP_);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(p1__75061_SHARP_);
}
})], null));
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.WorkspaceTabItem !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.WorkspaceTabItem = (function nubank$workspaces$ui$WorkspaceTabItem(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.WorkspaceTabItem.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","WorkspaceTabItem","nubank.workspaces.ui/WorkspaceTabItem",1782145703),nubank.workspaces.ui.WorkspaceTabItem);

var x75075_76789 = nubank.workspaces.ui.WorkspaceTabItem.prototype;
x75075_76789.render = ((function (x75075_76789){
return (function (){
var this__59535__auto__ = this;
var _ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__75082 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__75083 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__75084 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__75085 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__75086 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__75087 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__75088 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__75089 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__75090 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__75091 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__75087;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__75088;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__75089;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__75090;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__75091;

try{var props = fulcro.client.primitives.props.call(null,_);
return null;
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__75086;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__75085;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__75084;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__75083;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__75082;
}});})(x75075_76789))
;


nubank.workspaces.ui.WorkspaceTabItem.prototype.constructor = nubank.workspaces.ui.WorkspaceTabItem;

nubank.workspaces.ui.WorkspaceTabItem.prototype.constructor.displayName = "nubank.workspaces.ui/WorkspaceTabItem";

nubank.workspaces.ui.WorkspaceTabItem.prototype.fulcro$isComponent = true;

var x75103_76822 = nubank.workspaces.ui.WorkspaceTabItem;
x75103_76822.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75103_76822.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75103_76822){
return (function (_,props){
var ___$1 = this;
return nubank.workspaces.ui.workspace_ident.call(null,props);
});})(x75103_76822))
;

x75103_76822.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75103_76822.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75103_76822){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)], null);
});})(x75103_76822))
;


var x75106_76844 = nubank.workspaces.ui.WorkspaceTabItem.prototype;
x75106_76844.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75106_76844.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75106_76844){
return (function (_,props){
var ___$1 = this;
return nubank.workspaces.ui.workspace_ident.call(null,props);
});})(x75106_76844))
;

x75106_76844.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75106_76844.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75106_76844){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)], null);
});})(x75106_76844))
;


nubank.workspaces.ui.WorkspaceTabItem.cljs$lang$type = true;

nubank.workspaces.ui.WorkspaceTabItem.cljs$lang$ctorStr = "nubank.workspaces.ui/WorkspaceTabItem";

nubank.workspaces.ui.WorkspaceTabItem.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/WorkspaceTabItem");
});
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.WorkspaceTabs !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.WorkspaceTabs = (function nubank$workspaces$ui$WorkspaceTabs(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.WorkspaceTabs.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","WorkspaceTabs","nubank.workspaces.ui/WorkspaceTabs",948705863),nubank.workspaces.ui.WorkspaceTabs);

var x75127_76853 = nubank.workspaces.ui.WorkspaceTabs.prototype;
x75127_76853.render = ((function (x75127_76853){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__75128 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__75129 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__75130 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__75131 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__75132 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__75133 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__75134 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__75135 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__75136 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__75137 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__75133;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__75134;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__75135;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__75136;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__75137;

try{var map__75140 = fulcro.client.primitives.props.call(null,this$);
var map__75140__$1 = (((((!((map__75140 == null))))?(((((map__75140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75140.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75140):map__75140);
var active_workspace = cljs.core.get.call(null,map__75140__$1,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814));
var open_workspaces = cljs.core.get.call(null,map__75140__$1,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447));
var update_title = ((function (map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (new_title,workspace_id){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","update-workspace","nubank.workspaces.ui/update-workspace",-2145331844,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new_title], null),null,(1),null)))))], null));
});})(map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
;
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container",".container",-1441208944),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-close-workspace","nubank.workspaces.ui/keybinding-close-workspace",145944058)),new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","close-workspace","nubank.workspaces.ui/close-workspace",-1735247601,null),null,(1),null)),(new cljs.core.List(null,active_workspace,null,(1),null)))))], null));
});})(update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-new-workspace","nubank.workspaces.ui/keybinding-new-workspace",-1840796647)),new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","create-workspace","nubank.workspaces.ui/create-workspace",-404659908,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)))))], null));
});})(update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null)),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".tabs",".tabs",642963783),(function (){var iter__4523__auto__ = ((function (update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function nubank$workspaces$ui$iter__75144(s__75145){
return (new cljs.core.LazySeq(null,((function (update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (){
var s__75145__$1 = s__75145;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__75145__$1);
if(temp__5720__auto__){
var s__75145__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__75145__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__75145__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__75147 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__75146 = (0);
while(true){
if((i__75146 < size__4522__auto__)){
var map__75152 = cljs.core._nth(c__4521__auto__,i__75146);
var map__75152__$1 = (((((!((map__75152 == null))))?(((((map__75152.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75152.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75152):map__75152);
var tab_ws = map__75152__$1;
var workspace_id = cljs.core.get.call(null,map__75152__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75152__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
var workspace_static_QMARK_ = cljs.core.get.call(null,map__75152__$1,new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950));
var card_id = cljs.core.get.call(null,map__75152__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var current_QMARK_ = cljs.core._EQ_.call(null,nubank.workspaces.ui.workspace_ident.call(null,tab_ws),nubank.workspaces.ui.workspace_ident.call(null,active_workspace));
cljs.core.chunk_append.call(null,b__75147,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".tab",".tab",1455359754),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"key","key",-1516042587),(function (){var or__4131__auto__ = workspace_id;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return card_id;
}
})(),new cljs.core.Keyword(null,"classes","classes",2037804510),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((current_QMARK_)?new cljs.core.Keyword(null,".active-tab",".active-tab",1387866299):null)], null),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (){
var ws_ident = nubank.workspaces.ui.workspace_ident.call(null,tab_ws);
fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),ws_ident);

return nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),ws_ident);
});})(i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null),(cljs.core.truth_((function (){var or__4131__auto__ = workspace_static_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = card_id;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (!(current_QMARK_));
}
}
})())?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace-title",".workspace-title",9128440),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = workspace_title;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return card_id;
}
})())):fulcro.client.localized_dom.input.call(null,new cljs.core.Keyword(null,".workspace-title",".workspace-title",9128440),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_title),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (_){
return null;
});})(i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (p1__75118_SHARP_){
return p1__75118_SHARP_.target.select();
});})(i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
,new cljs.core.Keyword(null,"onBlur","onBlur",229342509),((function (i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (p1__75119_SHARP_){
return update_title(p1__75119_SHARP_.target.value,workspace_id);
});})(i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
,new cljs.core.Keyword(null,"onKeyDown","onKeyDown",648902330),((function (i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (p1__75120_SHARP_){
if(cljs.core.contains_QMARK_.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.get.call(null,nubank.workspaces.ui.events.KEYS,"return"),cljs.core.get.call(null,nubank.workspaces.ui.events.KEYS,"escape")]),p1__75120_SHARP_.keyCode)){
return p1__75120_SHARP_.target.blur();
} else {
return null;
}
});})(i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null))),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace-close",".workspace-close",631096870),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (e){
e.stopPropagation();

return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","close-workspace","nubank.workspaces.ui/close-workspace",-1735247601,null),null,(1),null)),(new cljs.core.List(null,tab_ws,null,(1),null)))))], null));
});})(i__75146,current_QMARK_,map__75152,map__75152__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,c__4521__auto__,size__4522__auto__,b__75147,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null),"\u00D7")));

var G__76908 = (i__75146 + (1));
i__75146 = G__76908;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75147),nubank$workspaces$ui$iter__75144.call(null,cljs.core.chunk_rest.call(null,s__75145__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75147),null);
}
} else {
var map__75164 = cljs.core.first.call(null,s__75145__$2);
var map__75164__$1 = (((((!((map__75164 == null))))?(((((map__75164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75164):map__75164);
var tab_ws = map__75164__$1;
var workspace_id = cljs.core.get.call(null,map__75164__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75164__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
var workspace_static_QMARK_ = cljs.core.get.call(null,map__75164__$1,new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950));
var card_id = cljs.core.get.call(null,map__75164__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var current_QMARK_ = cljs.core._EQ_.call(null,nubank.workspaces.ui.workspace_ident.call(null,tab_ws),nubank.workspaces.ui.workspace_ident.call(null,active_workspace));
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".tab",".tab",1455359754),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"key","key",-1516042587),(function (){var or__4131__auto__ = workspace_id;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return card_id;
}
})(),new cljs.core.Keyword(null,"classes","classes",2037804510),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((current_QMARK_)?new cljs.core.Keyword(null,".active-tab",".active-tab",1387866299):null)], null),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (){
var ws_ident = nubank.workspaces.ui.workspace_ident.call(null,tab_ws);
fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),ws_ident);

return nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),ws_ident);
});})(current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null),(cljs.core.truth_((function (){var or__4131__auto__ = workspace_static_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = card_id;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (!(current_QMARK_));
}
}
})())?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace-title",".workspace-title",9128440),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = workspace_title;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return card_id;
}
})())):fulcro.client.localized_dom.input.call(null,new cljs.core.Keyword(null,".workspace-title",".workspace-title",9128440),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_title),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (_){
return null;
});})(current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (p1__75118_SHARP_){
return p1__75118_SHARP_.target.select();
});})(current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
,new cljs.core.Keyword(null,"onBlur","onBlur",229342509),((function (current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (p1__75119_SHARP_){
return update_title(p1__75119_SHARP_.target.value,workspace_id);
});})(current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
,new cljs.core.Keyword(null,"onKeyDown","onKeyDown",648902330),((function (current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (p1__75120_SHARP_){
if(cljs.core.contains_QMARK_.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.get.call(null,nubank.workspaces.ui.events.KEYS,"return"),cljs.core.get.call(null,nubank.workspaces.ui.events.KEYS,"escape")]),p1__75120_SHARP_.keyCode)){
return p1__75120_SHARP_.target.blur();
} else {
return null;
}
});})(current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null))),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace-close",".workspace-close",631096870),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (e){
e.stopPropagation();

return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","close-workspace","nubank.workspaces.ui/close-workspace",-1735247601,null),null,(1),null)),(new cljs.core.List(null,tab_ws,null,(1),null)))))], null));
});})(current_QMARK_,map__75164,map__75164__$1,tab_ws,workspace_id,workspace_title,workspace_static_QMARK_,card_id,s__75145__$2,temp__5720__auto__,update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null),"\u00D7")),nubank$workspaces$ui$iter__75144.call(null,cljs.core.rest.call(null,s__75145__$2)));
}
} else {
return null;
}
break;
}
});})(update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
,null,null));
});})(update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
;
return iter__4523__auto__(cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),open_workspaces));
})(),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".tab.new-tab",".tab.new-tab",1931822071),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","create-workspace","nubank.workspaces.ui/create-workspace",-404659908,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)))))], null));
});})(update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null),"+")),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".active",".active",-1779503645),(cljs.core.truth_(active_workspace)?nubank.workspaces.ui.workspace_container.call(null,fulcro.client.primitives.computed.call(null,active_workspace,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","open-solo-card","nubank.workspaces.ui/open-solo-card",-1371578732),((function (update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853){
return (function (p1__75121_SHARP_){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","open-solo-workspace","nubank.workspaces.ui/open-solo-workspace",-1902644014,null),null,(1),null)),(new cljs.core.List(null,p1__75121_SHARP_,null,(1),null)))))], null));
});})(update_title,map__75140,map__75140__$1,active_workspace,open_workspaces,_STAR_reconciler_STAR__orig_val__75128,_STAR_depth_STAR__orig_val__75129,_STAR_shared_STAR__orig_val__75130,_STAR_instrument_STAR__orig_val__75131,_STAR_parent_STAR__orig_val__75132,_STAR_reconciler_STAR__temp_val__75133,_STAR_depth_STAR__temp_val__75134,_STAR_shared_STAR__temp_val__75135,_STAR_instrument_STAR__temp_val__75136,_STAR_parent_STAR__temp_val__75137,this$,this__59535__auto__,x75127_76853))
], null))):fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".welcome",".welcome",-697886208),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".welcome-content",".welcome-content",-884469317),fulcro.client.localized_dom.p.call(null,"Welcome to workspaces!"),fulcro.client.localized_dom.p.call(null,"Use the index on the left to start navigating."),fulcro.client.localized_dom.p.call(null,"If you like more instructions please check ",fulcro.client.localized_dom.a.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"href","href",-793805698),"https://github.com/nubank/workspaces#using-workspaces",new cljs.core.Keyword(null,"target","target",253001721),"_blank"], null),"workspaces usage guide"),"."))))));
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__75132;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__75131;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__75130;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__75129;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__75128;
}});})(x75127_76853))
;


nubank.workspaces.ui.WorkspaceTabs.prototype.constructor = nubank.workspaces.ui.WorkspaceTabs;

nubank.workspaces.ui.WorkspaceTabs.prototype.constructor.displayName = "nubank.workspaces.ui/WorkspaceTabs";

nubank.workspaces.ui.WorkspaceTabs.prototype.fulcro$isComponent = true;

var x75204_76957 = nubank.workspaces.ui.WorkspaceTabs;
x75204_76957.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75204_76957.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75204_76957){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".tabs",".tabs",642963783),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"nowrap",new cljs.core.Keyword(null,"overflow-x","overflow-x",-26547754),"auto"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".tab",".tab",1455359754),nubank.workspaces.ui.core.font_os12sb,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"align-items","align-items",-267946462),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"overflow","overflow",2058931880),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"flex","flex",-1425124628),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"margin-right","margin-right",809689658),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941)],["center",nubank.workspaces.ui.core.color_limed_spruce,"hidden",nubank.workspaces.ui.core.color_iron,"pointer","0 0 auto","1","7px 12px 9px","flex","1px",["1px solid ",nubank.workspaces.ui.core.color_geyser].join(''),"6px 6px 0 0","-1px"]),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&.active-tab","&.active-tab",2033073281),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"border-bottom","border-bottom",2110948415),["1px solid ",nubank.workspaces.ui.core.color_white].join('')], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".active",".active",-1779503645),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"border","border",1444987323),["1px solid ",nubank.workspaces.ui.core.color_geyser].join(''),new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"min-height","min-height",398480837),"0"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".new-tab",".new-tab",-1096253910),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"23px",new cljs.core.Keyword(null,"line-height","line-height",1870784992),"1em"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".welcome",".welcome",-697886208),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_dark_grey,new cljs.core.Keyword(null,"color","color",1011675173),"#fff",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".welcome-content",".welcome-content",-884469317),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"color","color",1011675173),"#000",new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_open_sans,new cljs.core.Keyword(null,"padding","padding",1660304693),"0 12px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin","margin",-995903681),"12px 0"], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspace-title",".workspace-title",9128440),nubank.workspaces.ui.core.font_os12sb,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"background","background",-863952629),"transparent",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid transparent",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 0 2px 0 transparent",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"text-overflow","text-overflow",-1022366814),"ellipsis"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&:focus","&:focus",1074121139),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #0079bf",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 0 2px 0 #0284c6",new cljs.core.Keyword(null,"outline","outline",793464534),"0",new cljs.core.Keyword(null,"color","color",1011675173),"#000 !important",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"text"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspace-close",".workspace-close",631096870),nubank.workspaces.ui.core.close_icon_css,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"10px"], null)], null)], null);
});})(x75204_76957))
;

x75204_76957.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75204_76957){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75204_76957))
;

x75204_76957.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x75204_76957.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x75204_76957){
return (function (this$,_){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.mapv.call(null,nubank.workspaces.ui.ws_data__GT_ident_map,nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.PersistentVector.EMPTY)),new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),(function (){var temp__5718__auto__ = nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814));
if(cljs.core.truth_(temp__5718__auto__)){
var active = temp__5718__auto__;
return nubank.workspaces.ui.ws_data__GT_ident_map.call(null,active);
} else {
return null;
}
})()], null);
});})(x75204_76957))
;

x75204_76957.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75204_76957.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75204_76957){
return (function (this$,p__75212){
var map__75213 = p__75212;
var map__75213__$1 = (((((!((map__75213 == null))))?(((((map__75213.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75213.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75213):map__75213);
var active_workspace = cljs.core.get.call(null,map__75213__$1,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814));
var open_workspaces = cljs.core.get.call(null,map__75213__$1,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447));
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton"], null);
});})(x75204_76957))
;

x75204_76957.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75204_76957.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75204_76957){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceTabItem)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceContainer)], null)], null);
});})(x75204_76957))
;


var x75218_76993 = nubank.workspaces.ui.WorkspaceTabs.prototype;
x75218_76993.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75218_76993.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75218_76993){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".tabs",".tabs",642963783),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"nowrap",new cljs.core.Keyword(null,"overflow-x","overflow-x",-26547754),"auto"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".tab",".tab",1455359754),nubank.workspaces.ui.core.font_os12sb,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"align-items","align-items",-267946462),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"overflow","overflow",2058931880),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"flex","flex",-1425124628),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"margin-right","margin-right",809689658),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941)],["center",nubank.workspaces.ui.core.color_limed_spruce,"hidden",nubank.workspaces.ui.core.color_iron,"pointer","0 0 auto","1","7px 12px 9px","flex","1px",["1px solid ",nubank.workspaces.ui.core.color_geyser].join(''),"6px 6px 0 0","-1px"]),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&.active-tab","&.active-tab",2033073281),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_white,new cljs.core.Keyword(null,"border-bottom","border-bottom",2110948415),["1px solid ",nubank.workspaces.ui.core.color_white].join('')], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".active",".active",-1779503645),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"border","border",1444987323),["1px solid ",nubank.workspaces.ui.core.color_geyser].join(''),new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"min-height","min-height",398480837),"0"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".new-tab",".new-tab",-1096253910),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"23px",new cljs.core.Keyword(null,"line-height","line-height",1870784992),"1em"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".welcome",".welcome",-697886208),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"background","background",-863952629),nubank.workspaces.ui.core.color_dark_grey,new cljs.core.Keyword(null,"color","color",1011675173),"#fff",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".welcome-content",".welcome-content",-884469317),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"color","color",1011675173),"#000",new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_open_sans,new cljs.core.Keyword(null,"padding","padding",1660304693),"0 12px"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin","margin",-995903681),"12px 0"], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspace-title",".workspace-title",9128440),nubank.workspaces.ui.core.font_os12sb,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"background","background",-863952629),"transparent",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid transparent",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 0 2px 0 transparent",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"text-overflow","text-overflow",-1022366814),"ellipsis"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&:focus","&:focus",1074121139),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"background","background",-863952629),"#fff",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #0079bf",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 0 2px 0 #0284c6",new cljs.core.Keyword(null,"outline","outline",793464534),"0",new cljs.core.Keyword(null,"color","color",1011675173),"#000 !important",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"text"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspace-close",".workspace-close",631096870),nubank.workspaces.ui.core.close_icon_css,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"10px"], null)], null)], null);
});})(x75218_76993))
;

x75218_76993.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75218_76993){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75218_76993))
;

x75218_76993.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x75218_76993.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x75218_76993){
return (function (this$,_){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.mapv.call(null,nubank.workspaces.ui.ws_data__GT_ident_map,nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.PersistentVector.EMPTY)),new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),(function (){var temp__5718__auto__ = nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814));
if(cljs.core.truth_(temp__5718__auto__)){
var active = temp__5718__auto__;
return nubank.workspaces.ui.ws_data__GT_ident_map.call(null,active);
} else {
return null;
}
})()], null);
});})(x75218_76993))
;

x75218_76993.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75218_76993.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75218_76993){
return (function (this$,p__75234){
var map__75235 = p__75234;
var map__75235__$1 = (((((!((map__75235 == null))))?(((((map__75235.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75235.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75235):map__75235);
var active_workspace = cljs.core.get.call(null,map__75235__$1,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814));
var open_workspaces = cljs.core.get.call(null,map__75235__$1,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447));
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton"], null);
});})(x75218_76993))
;

x75218_76993.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75218_76993.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75218_76993){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceTabItem)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceContainer)], null)], null);
});})(x75218_76993))
;


nubank.workspaces.ui.WorkspaceTabs.cljs$lang$type = true;

nubank.workspaces.ui.WorkspaceTabs.cljs$lang$ctorStr = "nubank.workspaces.ui/WorkspaceTabs";

nubank.workspaces.ui.WorkspaceTabs.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/WorkspaceTabs");
});
nubank.workspaces.ui.workspace_tabs = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.WorkspaceTabs);
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.CardIndexListing !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.CardIndexListing = (function nubank$workspaces$ui$CardIndexListing(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.CardIndexListing.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","CardIndexListing","nubank.workspaces.ui/CardIndexListing",-1935958460),nubank.workspaces.ui.CardIndexListing);

var x75265_77018 = nubank.workspaces.ui.CardIndexListing.prototype;
x75265_77018.render = ((function (x75265_77018){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__75266 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__75267 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__75268 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__75269 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__75270 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__75271 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__75272 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__75273 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__75274 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__75275 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__75271;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__75272;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__75273;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__75274;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__75275;

try{var map__75279 = fulcro.client.primitives.props.call(null,this$);
var map__75279__$1 = (((((!((map__75279 == null))))?(((((map__75279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75279.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75279):map__75279);
var card_id = cljs.core.get.call(null,map__75279__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container",".container",-1441208944),fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75279,map__75279__$1,card_id,_STAR_reconciler_STAR__orig_val__75266,_STAR_depth_STAR__orig_val__75267,_STAR_shared_STAR__orig_val__75268,_STAR_instrument_STAR__orig_val__75269,_STAR_parent_STAR__orig_val__75270,_STAR_reconciler_STAR__temp_val__75271,_STAR_depth_STAR__temp_val__75272,_STAR_shared_STAR__temp_val__75273,_STAR_instrument_STAR__temp_val__75274,_STAR_parent_STAR__temp_val__75275,this$,this__59535__auto__,x75265_77018){
return (function (p1__75246_SHARP_){
if(cljs.core.truth_(p1__75246_SHARP_.altKey)){
return nubank.workspaces.ui.add_card_solo.call(null,this$,card_id);
} else {
return nubank.workspaces.ui.add_card.call(null,this$,card_id);
}
});})(map__75279,map__75279__$1,card_id,_STAR_reconciler_STAR__orig_val__75266,_STAR_depth_STAR__orig_val__75267,_STAR_shared_STAR__orig_val__75268,_STAR_instrument_STAR__orig_val__75269,_STAR_parent_STAR__orig_val__75270,_STAR_reconciler_STAR__temp_val__75271,_STAR_depth_STAR__temp_val__75272,_STAR_shared_STAR__temp_val__75273,_STAR_instrument_STAR__temp_val__75274,_STAR_parent_STAR__temp_val__75275,this$,this__59535__auto__,x75265_77018))
], null),cljs.core.name.call(null,card_id)));
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__75270;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__75269;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__75268;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__75267;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__75266;
}});})(x75265_77018))
;


nubank.workspaces.ui.CardIndexListing.prototype.constructor = nubank.workspaces.ui.CardIndexListing;

nubank.workspaces.ui.CardIndexListing.prototype.constructor.displayName = "nubank.workspaces.ui/CardIndexListing";

nubank.workspaces.ui.CardIndexListing.prototype.fulcro$isComponent = true;

var x75288_77046 = nubank.workspaces.ui.CardIndexListing;
x75288_77046.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75288_77046.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75288_77046){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null)], null);
});})(x75288_77046))
;

x75288_77046.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75288_77046){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75288_77046))
;

x75288_77046.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x75288_77046.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x75288_77046){
return (function (this$,card){
var this$__$1 = this;
return cljs.core.select_keys.call(null,card,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","test?","nubank.workspaces.model/test?",993719827),new cljs.core.Keyword("nubank.workspaces.model","card-unlisted?","nubank.workspaces.model/card-unlisted?",-302030555)], null));
});})(x75288_77046))
;

x75288_77046.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75288_77046.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75288_77046){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x75288_77046))
;

x75288_77046.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75288_77046.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75288_77046){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","test?","nubank.workspaces.model/test?",993719827),new cljs.core.Keyword("nubank.workspaces.model","card-unlisted?","nubank.workspaces.model/card-unlisted?",-302030555)], null);
});})(x75288_77046))
;


var x75292_77060 = nubank.workspaces.ui.CardIndexListing.prototype;
x75292_77060.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75292_77060.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75292_77060){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null)], null);
});})(x75292_77060))
;

x75292_77060.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75292_77060){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75292_77060))
;

x75292_77060.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x75292_77060.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x75292_77060){
return (function (this$,card){
var this$__$1 = this;
return cljs.core.select_keys.call(null,card,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","test?","nubank.workspaces.model/test?",993719827),new cljs.core.Keyword("nubank.workspaces.model","card-unlisted?","nubank.workspaces.model/card-unlisted?",-302030555)], null));
});})(x75292_77060))
;

x75292_77060.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75292_77060.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75292_77060){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x75292_77060))
;

x75292_77060.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75292_77060.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75292_77060){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),new cljs.core.Keyword("nubank.workspaces.model","test?","nubank.workspaces.model/test?",993719827),new cljs.core.Keyword("nubank.workspaces.model","card-unlisted?","nubank.workspaces.model/card-unlisted?",-302030555)], null);
});})(x75292_77060))
;


nubank.workspaces.ui.CardIndexListing.cljs$lang$type = true;

nubank.workspaces.ui.CardIndexListing.cljs$lang$ctorStr = "nubank.workspaces.ui/CardIndexListing";

nubank.workspaces.ui.CardIndexListing.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/CardIndexListing");
});
nubank.workspaces.ui.card_index_listing = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.CardIndexListing,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)], null));
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.WorkspaceIndexListing !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.WorkspaceIndexListing = (function nubank$workspaces$ui$WorkspaceIndexListing(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.WorkspaceIndexListing.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","WorkspaceIndexListing","nubank.workspaces.ui/WorkspaceIndexListing",-1301015075),nubank.workspaces.ui.WorkspaceIndexListing);

var x75301_77079 = nubank.workspaces.ui.WorkspaceIndexListing.prototype;
x75301_77079.render = ((function (x75301_77079){
return (function (){
var this__59535__auto__ = this;
var _ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__75302 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__75303 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__75304 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__75305 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__75306 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__75307 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__75308 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__75309 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__75310 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__75311 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__75307;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__75308;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__75309;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__75310;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__75311;

try{var ___$1 = fulcro.client.primitives.props.call(null,_);
return null;
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__75306;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__75305;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__75304;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__75303;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__75302;
}});})(x75301_77079))
;


nubank.workspaces.ui.WorkspaceIndexListing.prototype.constructor = nubank.workspaces.ui.WorkspaceIndexListing;

nubank.workspaces.ui.WorkspaceIndexListing.prototype.constructor.displayName = "nubank.workspaces.ui/WorkspaceIndexListing";

nubank.workspaces.ui.WorkspaceIndexListing.prototype.fulcro$isComponent = true;

var x75315_77089 = nubank.workspaces.ui.WorkspaceIndexListing;
x75315_77089.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75315_77089.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75315_77089){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x75315_77089))
;

x75315_77089.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75315_77089.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75315_77089){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950)], null);
});})(x75315_77089))
;


var x75317_77094 = nubank.workspaces.ui.WorkspaceIndexListing.prototype;
x75317_77094.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75317_77094.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75317_77094){
return (function (this$,props){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(props)], null);
});})(x75317_77094))
;

x75317_77094.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75317_77094.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75317_77094){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950)], null);
});})(x75317_77094))
;


nubank.workspaces.ui.WorkspaceIndexListing.cljs$lang$type = true;

nubank.workspaces.ui.WorkspaceIndexListing.cljs$lang$ctorStr = "nubank.workspaces.ui/WorkspaceIndexListing";

nubank.workspaces.ui.WorkspaceIndexListing.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/WorkspaceIndexListing");
});
nubank.workspaces.ui.workspace_index_listing = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.WorkspaceIndexListing,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858)], null));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","load-card","nubank.workspaces.ui/load-card",817030703,null),(function (fulcro_incoming_env,_,card){
return cljs.core.merge.call(null,(function (){var map__75320 = fulcro_incoming_env;
var map__75320__$1 = (((((!((map__75320 == null))))?(((((map__75320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75320.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75320):map__75320);
var reconciler = cljs.core.get.call(null,map__75320__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__75320,map__75320__$1,reconciler){
return (function (){
return fulcro.client.primitives.merge_component_BANG_.call(null,reconciler,nubank.workspaces.ui.CardIndexListing,fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.CardIndexListing,card),new cljs.core.Keyword(null,"append","append",-291298229),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701)], null));
});})(map__75320,map__75320__$1,reconciler))
], null);
})());
}));
nubank.workspaces.ui.initialize_static_workspaces = (function nubank$workspaces$ui$initialize_static_workspaces(){
return cljs.core.mapv.call(null,(function (p1__75326_SHARP_){
return fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.Workspace,p1__75326_SHARP_);
}),cljs.core.vals.call(null,cljs.core.deref.call(null,nubank.workspaces.data.workspace_definitions_STAR_)));
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","load-workspace","nubank.workspaces.ui/load-workspace",60048364,null),(function (fulcro_incoming_env,_,workspace){
return cljs.core.merge.call(null,(function (){var map__75329 = fulcro_incoming_env;
var map__75329__$1 = (((((!((map__75329 == null))))?(((((map__75329.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75329.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75329):map__75329);
var reconciler = cljs.core.get.call(null,map__75329__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state = cljs.core.get.call(null,map__75329__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__75329,map__75329__$1,reconciler,state){
return (function (){
return fulcro.client.primitives.merge_component_BANG_.call(null,reconciler,nubank.workspaces.ui.Workspace,nubank.workspaces.ui.normalize_ws_cards.call(null,cljs.core.deref.call(null,state),fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.Workspace,workspace)),new cljs.core.Keyword(null,"append","append",-291298229),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450)], null));
});})(map__75329,map__75329__$1,reconciler,state))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),(function (fulcro_incoming_env,_,p__75332){
var map__75333 = p__75332;
var map__75333__$1 = (((((!((map__75333 == null))))?(((((map__75333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75333.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75333):map__75333);
var workspace_id = cljs.core.get.call(null,map__75333__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
return cljs.core.merge.call(null,(function (){var map__75335 = fulcro_incoming_env;
var map__75335__$1 = (((((!((map__75335 == null))))?(((((map__75335.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75335.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75335):map__75335);
var state = cljs.core.get.call(null,map__75335__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__75335,map__75335__$1,state,map__75333,map__75333__$1,workspace_id){
return (function (){
var open_workspaces = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.second),cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447)], null)));
var ws_ref = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),workspace_id], null);
if((!(cljs.core.contains_QMARK_.call(null,open_workspaces,workspace_id)))){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447)], null),cljs.core.conj,ws_ref);
} else {
}

cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-tabs","nubank.workspaces.ui/workspace-tabs",-908048516),"singleton",new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814)], null),ws_ref);

nubank.workspaces.lib.local_storage.update_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","open-workspaces","nubank.workspaces.ui/open-workspaces",-733634447),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),workspace_id);

return nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814),workspace_id);
});})(map__75335,map__75335__$1,state,map__75333,map__75333__$1,workspace_id))
], null);
})(),(function (){var ___$1 = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh","refresh",1947415525),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","active-workspace","nubank.workspaces.ui/active-workspace",-959687814)], null)], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","toggle-ns-expansion","nubank.workspaces.ui/toggle-ns-expansion",117524570,null),(function (fulcro_incoming_env,_,p__75339){
var map__75341 = p__75339;
var map__75341__$1 = (((((!((map__75341 == null))))?(((((map__75341.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75341.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75341):map__75341);
var expand_path = cljs.core.get.call(null,map__75341__$1,new cljs.core.Keyword("nubank.workspaces.ui","expand-path","nubank.workspaces.ui/expand-path",-795465683));
return cljs.core.merge.call(null,(function (){var map__75346 = fulcro_incoming_env;
var map__75346__$1 = (((((!((map__75346 == null))))?(((((map__75346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75346):map__75346);
var state = cljs.core.get.call(null,map__75346__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__75346__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__75346,map__75346__$1,state,ref,map__75341,map__75341__$1,expand_path){
return (function (){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,ref,cljs.core.update,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),cljs.core.update_in,expand_path,cljs.core.not);

return nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,ref,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223))));
});})(map__75346,map__75346__$1,state,ref,map__75341,map__75341__$1,expand_path))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("nubank.workspaces.ui","toggle-index-view","nubank.workspaces.ui/toggle-index-view",-2043129614,null),(function (fulcro_incoming_env,_,___$1){
return cljs.core.merge.call(null,(function (){var map__75348 = fulcro_incoming_env;
var map__75348__$1 = (((((!((map__75348 == null))))?(((((map__75348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75348.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75348):map__75348);
var state = cljs.core.get.call(null,map__75348__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__75348__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__75348,map__75348__$1,state,ref){
return (function (){
var show_index_QMARK_ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,ref,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311)));
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,cljs.core.conj.call(null,ref,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311)),cljs.core.not(show_index_QMARK_));

nubank.workspaces.lib.local_storage.set_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311),cljs.core.not(show_index_QMARK_));

return setTimeout(((function (show_index_QMARK_,map__75348,map__75348__$1,state,ref){
return (function (){
return nubank.workspaces.ui.events.trigger_event.call(null,window,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui.events","event","nubank.workspaces.ui.events/event",-1162809276),"resize"], null));
});})(show_index_QMARK_,map__75348,map__75348__$1,state,ref))
,(100));
});})(map__75348,map__75348__$1,state,ref))
], null);
})());
}));
nubank.workspaces.ui.open_spotlight = (function nubank$workspaces$ui$open_spotlight(this$){
var map__75354 = fulcro.client.primitives.props.call(null,this$);
var map__75354__$1 = (((((!((map__75354 == null))))?(((((map__75354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75354.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75354):map__75354);
var spotlight = cljs.core.get.call(null,map__75354__$1,new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828));
var state = cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,fulcro.client.primitives.get_reconciler.call(null,this$)));
var options = cljs.core.into.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (map__75354,map__75354__$1,spotlight,state){
return (function (p__75357){
var vec__75358 = p__75357;
var _ = cljs.core.nth.call(null,vec__75358,(0),null);
var map__75361 = cljs.core.nth.call(null,vec__75358,(1),null);
var map__75361__$1 = (((((!((map__75361 == null))))?(((((map__75361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75361.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75361):map__75361);
var card_id = cljs.core.get.call(null,map__75361__$1,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809));
var test_QMARK_ = cljs.core.get.call(null,map__75361__$1,new cljs.core.Keyword("nubank.workspaces.model","test?","nubank.workspaces.model/test?",993719827));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.spotlight","type","nubank.workspaces.ui.spotlight/type",1675623435),(cljs.core.truth_(test_QMARK_)?new cljs.core.Keyword("nubank.workspaces.ui.spotlight","test","nubank.workspaces.ui.spotlight/test",-2118206012):new cljs.core.Keyword("nubank.workspaces.ui.spotlight","card","nubank.workspaces.ui.spotlight/card",-882323793)),new cljs.core.Keyword("nubank.workspaces.ui.spotlight","id","nubank.workspaces.ui.spotlight/id",-871569707),card_id], null);
});})(map__75354,map__75354__$1,spotlight,state))
),new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809).cljs$core$IFn$_invoke$arity$1(state)),cljs.core.map.call(null,((function (map__75354,map__75354__$1,spotlight,state){
return (function (p__75363){
var vec__75364 = p__75363;
var _ = cljs.core.nth.call(null,vec__75364,(0),null);
var map__75367 = cljs.core.nth.call(null,vec__75364,(1),null);
var map__75367__$1 = (((((!((map__75367 == null))))?(((((map__75367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75367.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75367):map__75367);
var workspace_id = cljs.core.get.call(null,map__75367__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75367__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("nubank.workspaces.ui.spotlight","type","nubank.workspaces.ui.spotlight/type",1675623435),new cljs.core.Keyword("nubank.workspaces.ui.spotlight","workspace","nubank.workspaces.ui.spotlight/workspace",-529313372),new cljs.core.Keyword("nubank.workspaces.ui.spotlight","id","nubank.workspaces.ui.spotlight/id",-871569707),workspace_id,new cljs.core.Keyword("nubank.workspaces.ui.spotlight","label","nubank.workspaces.ui.spotlight/label",1308535731),workspace_title], null);
});})(map__75354,map__75354__$1,spotlight,state))
),new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858).cljs$core$IFn$_invoke$arity$1(state));
fulcro.client.primitives.transact_BANG_.call(null,fulcro.client.primitives.get_reconciler.call(null,this$),fulcro.client.primitives.get_ident.call(null,nubank.workspaces.ui.spotlight.Spotlight,spotlight),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui.spotlight","reset","nubank.workspaces.ui.spotlight/reset",475380012,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui.spotlight","options","nubank.workspaces.ui.spotlight/options",-459165350),null,(1),null)),(new cljs.core.List(null,options,null,(1),null)))))),null,(1),null))))),null,(1),null)))))));

return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402),true);
});
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.HelpDialog !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.HelpDialog = (function nubank$workspaces$ui$HelpDialog(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.HelpDialog.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","HelpDialog","nubank.workspaces.ui/HelpDialog",-262514724),nubank.workspaces.ui.HelpDialog);

var x75373_77288 = nubank.workspaces.ui.HelpDialog.prototype;
x75373_77288.render = ((function (x75373_77288){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__75376 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__75377 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__75378 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__75379 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__75380 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__75381 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__75382 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__75383 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__75384 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__75385 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__75381;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__75382;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__75383;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__75384;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__75385;

try{var map__75390 = fulcro.client.primitives.props.call(null,this$);
var map__75390__$1 = (((((!((map__75390 == null))))?(((((map__75390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75390.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75390):map__75390);
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container",".container",-1441208944),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".header",".header",-1761691025),"Keyboard Shortcuts"),fulcro.client.localized_dom.div.call(null,fulcro.client.localized_dom.strong.call(null,nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-spotlight","nubank.workspaces.ui/keybinding-spotlight",254588049))),": Add card to current workspace (open spotlight for card picking)"),fulcro.client.localized_dom.div.call(null,fulcro.client.localized_dom.strong.call(null,nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-toggle-index","nubank.workspaces.ui/keybinding-toggle-index",2077220551))),": Toggle index view"),fulcro.client.localized_dom.div.call(null,fulcro.client.localized_dom.strong.call(null,nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-toggle-card-headers","nubank.workspaces.ui/keybinding-toggle-card-headers",1763073649))),": Toggle card headers"),fulcro.client.localized_dom.div.call(null,fulcro.client.localized_dom.strong.call(null,nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-new-workspace","nubank.workspaces.ui/keybinding-new-workspace",-1840796647))),": Create new local workspace"),fulcro.client.localized_dom.div.call(null,fulcro.client.localized_dom.strong.call(null,nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-close-workspace","nubank.workspaces.ui/keybinding-close-workspace",145944058))),": Close current workspace"),fulcro.client.localized_dom.div.call(null,fulcro.client.localized_dom.strong.call(null,"alt-shift-?"),": Toggle shorcuts modal"));
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__75380;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__75379;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__75378;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__75377;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__75376;
}});})(x75373_77288))
;


nubank.workspaces.ui.HelpDialog.prototype.constructor = nubank.workspaces.ui.HelpDialog;

nubank.workspaces.ui.HelpDialog.prototype.constructor.displayName = "nubank.workspaces.ui/HelpDialog";

nubank.workspaces.ui.HelpDialog.prototype.fulcro$isComponent = true;

var x75395_77325 = nubank.workspaces.ui.HelpDialog;
x75395_77325.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75395_77325.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75395_77325){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),"rgba(0, 0, 0, 0.8)",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"color","color",1011675173),"#fff",new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_monospace,new cljs.core.Keyword(null,"padding","padding",1660304693),"20px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_open_sans,new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"26px",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"margin","margin",-995903681),"-5px 0 20px",new cljs.core.Keyword(null,"text-align","text-align",1786091845),"center"], null)], null)], null);
});})(x75395_77325))
;

x75395_77325.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75395_77325){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75395_77325))
;


var x75396_77355 = nubank.workspaces.ui.HelpDialog.prototype;
x75396_77355.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75396_77355.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75396_77355){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),"rgba(0, 0, 0, 0.8)",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"color","color",1011675173),"#fff",new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_monospace,new cljs.core.Keyword(null,"padding","padding",1660304693),"20px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_open_sans,new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"26px",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"margin","margin",-995903681),"-5px 0 20px",new cljs.core.Keyword(null,"text-align","text-align",1786091845),"center"], null)], null)], null);
});})(x75396_77355))
;

x75396_77355.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75396_77355){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x75396_77355))
;


nubank.workspaces.ui.HelpDialog.cljs$lang$type = true;

nubank.workspaces.ui.HelpDialog.cljs$lang$ctorStr = "nubank.workspaces.ui/HelpDialog";

nubank.workspaces.ui.HelpDialog.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/HelpDialog");
});
nubank.workspaces.ui.help_dialog = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.HelpDialog);
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.WorkspacesRoot !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.WorkspacesRoot = (function nubank$workspaces$ui$WorkspacesRoot(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.WorkspacesRoot.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui","WorkspacesRoot","nubank.workspaces.ui/WorkspacesRoot",-113702147),nubank.workspaces.ui.WorkspacesRoot);

var x75413_77389 = nubank.workspaces.ui.WorkspacesRoot.prototype;
x75413_77389.render = ((function (x75413_77389){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__75414 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__75415 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__75416 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__75417 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__75418 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__75419 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__75420 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__75421 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__75422 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__75423 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__75419;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__75420;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__75421;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__75422;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__75423;

try{var map__75425 = fulcro.client.primitives.props.call(null,this$);
var map__75425__$1 = (((((!((map__75425 == null))))?(((((map__75425.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75425.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75425):map__75425);
var cards = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701));
var ws_tabs = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","ws-tabs","nubank.workspaces.ui/ws-tabs",872859899));
var workspaces = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450));
var settings = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956));
var expanded = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223));
var spotlight = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828));
var show_spotlight_QMARK_ = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402));
var show_help_modal_QMARK_ = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639));
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container",".container",-1441208944),fulcro_css.css_injection.style_element.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"component","component",1555936782),nubank.workspaces.ui.WorkspacesRoot], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-toggle-index","nubank.workspaces.ui/keybinding-toggle-index",2077220551)),new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","toggle-index-view","nubank.workspaces.ui/toggle-index-view",-2043129614,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)))))], null));
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),"alt-shift-/",new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.mutations.toggle_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639));
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-fix-sizes","nubank.workspaces.ui/keybinding-fix-sizes",1615114381)),new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return nubank.workspaces.ui.events.trigger_event.call(null,window,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui.events","event","nubank.workspaces.ui.events/event",-1162809276),"resize"], null));
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-toggle-card-headers","nubank.workspaces.ui/keybinding-toggle-card-headers",1763073649)),new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),cljs.core.update.call(null,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956).cljs$core$IFn$_invoke$arity$1(fulcro.client.primitives.props.call(null,this$)),new cljs.core.Keyword("nubank.workspaces.ui","hide-card-header?","nubank.workspaces.ui/hide-card-header?",-497463645),cljs.core.not));
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),nubank.workspaces.ui.get_keybinding.call(null,new cljs.core.Keyword("nubank.workspaces.ui","keybinding-spotlight","nubank.workspaces.ui/keybinding-spotlight",254588049)),new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),nubank.workspaces.ui.events.pd.call(null,((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return nubank.workspaces.ui.open_spotlight.call(null,this$);
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
)], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","event","nubank.workspaces.ui.events/event",-1162809276),"keydown",new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (p1__75401_SHARP_){
if(cljs.core._EQ_.call(null,p1__75401_SHARP_.keyCode,(18))){
return document.body.classList.add("cljs-workspaces-extended-views");
} else {
return null;
}
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null)),nubank.workspaces.ui.events.dom_listener.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nubank.workspaces.ui.events","event","nubank.workspaces.ui.events/event",-1162809276),"keyup",new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (p1__75402_SHARP_){
if(cljs.core._EQ_.call(null,p1__75402_SHARP_.keyCode,(18))){
return document.body.classList.remove("cljs-workspaces-extended-views");
} else {
return null;
}
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null)),(cljs.core.truth_(show_help_modal_QMARK_)?nubank.workspaces.ui.modal.modal.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui.modal","on-close","nubank.workspaces.ui.modal/on-close",1602537550),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639),false);
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),nubank.workspaces.ui.help_dialog.call(null,cljs.core.PersistentArrayMap.EMPTY)):null),(cljs.core.truth_(show_spotlight_QMARK_)?nubank.workspaces.ui.modal.modal.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui.modal","on-close","nubank.workspaces.ui.modal/on-close",1602537550),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402),false);
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),nubank.workspaces.ui.spotlight.spotlight.call(null,fulcro.client.primitives.computed.call(null,spotlight,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui.spotlight","on-select","nubank.workspaces.ui.spotlight/on-select",366623223),fulcro.client.primitives.get_state.call(null,this$,new cljs.core.Keyword(null,"spotlight-select","spotlight-select",-635934435))], null)))):null),(cljs.core.truth_(new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311).cljs$core$IFn$_invoke$arity$1(settings))?(function (){var map__75433 = cljs.core.group_by.call(null,cljs.core.comp.call(null,cljs.core.true_QMARK_,new cljs.core.Keyword("nubank.workspaces.model","test?","nubank.workspaces.model/test?",993719827)),cards);
var map__75433__$1 = (((((!((map__75433 == null))))?(((((map__75433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75433.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75433):map__75433);
var uis = cljs.core.get.call(null,map__75433__$1,false);
var tests = cljs.core.get.call(null,map__75433__$1,true);
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".menu",".menu",986259874),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".row.header",".row.header",-1769651026),fulcro.client.localized_dom.div.call(null,"Workspaces"),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".flex",".flex",-73425686)),fulcro.client.localized_dom.button.call(null,new cljs.core.Keyword(null,".index-action-button.spotlight",".index-action-button.spotlight",1590132671),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return nubank.workspaces.ui.open_spotlight.call(null,this$);
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),"\uD83D\uDD0D"),fulcro.client.localized_dom.button.call(null,new cljs.core.Keyword(null,".index-action-button.help",".index-action-button.help",-1460269596),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.mutations.toggle_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639));
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),"?"),fulcro.client.localized_dom.button.call(null,new cljs.core.Keyword(null,".index-action-button",".index-action-button",859695279),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","toggle-index-view","nubank.workspaces.ui/toggle-index-view",-2043129614,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)))))], null));
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),"\u00AB")),(function (){var map__75437 = cljs.core.group_by.call(null,cljs.core.comp.call(null,cljs.core.boolean$,new cljs.core.Keyword("nubank.workspaces.model","workspace-static?","nubank.workspaces.model/workspace-static?",1744769950)),workspaces);
var map__75437__$1 = (((((!((map__75437 == null))))?(((((map__75437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75437):map__75437);
var statics = cljs.core.get.call(null,map__75437__$1,true);
var locals = cljs.core.get.call(null,map__75437__$1,false);
return fulcro.client.localized_dom.div.call(null,fulcro.client.localized_dom.div.call(null,"Local workspaces",fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".nest-group-small",".nest-group-small",-1151011320),(function (){var iter__4523__auto__ = ((function (map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function nubank$workspaces$ui$iter__75439(s__75440){
return (new cljs.core.LazySeq(null,((function (map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
var s__75440__$1 = s__75440;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__75440__$1);
if(temp__5720__auto__){
var s__75440__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__75440__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__75440__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__75442 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__75441 = (0);
while(true){
if((i__75441 < size__4522__auto__)){
var map__75443 = cljs.core._nth(c__4521__auto__,i__75441);
var map__75443__$1 = (((((!((map__75443 == null))))?(((((map__75443.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75443.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75443):map__75443);
var workspace_id = cljs.core.get.call(null,map__75443__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75443__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
cljs.core.chunk_append.call(null,b__75442,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_id),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75441,map__75443,map__75443__$1,workspace_id,workspace_title,c__4521__auto__,size__4522__auto__,b__75442,s__75440__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));
});})(i__75441,map__75443,map__75443__$1,workspace_id,workspace_title,c__4521__auto__,size__4522__auto__,b__75442,s__75440__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_title)));

var G__77677 = (i__75441 + (1));
i__75441 = G__77677;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75442),nubank$workspaces$ui$iter__75439.call(null,cljs.core.chunk_rest.call(null,s__75440__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75442),null);
}
} else {
var map__75448 = cljs.core.first.call(null,s__75440__$2);
var map__75448__$1 = (((((!((map__75448 == null))))?(((((map__75448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75448):map__75448);
var workspace_id = cljs.core.get.call(null,map__75448__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75448__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_id),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75448,map__75448__$1,workspace_id,workspace_title,s__75440__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));
});})(map__75448,map__75448__$1,workspace_id,workspace_title,s__75440__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_title)),nubank$workspaces$ui$iter__75439.call(null,cljs.core.rest.call(null,s__75440__$2)));
}
} else {
return null;
}
break;
}
});})(map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
,null,null));
});})(map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
;
return iter__4523__auto__(cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),locals));
})())),fulcro.client.localized_dom.br.call(null),(function (){var iter__4523__auto__ = ((function (map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function nubank$workspaces$ui$iter__75452(s__75453){
return (new cljs.core.LazySeq(null,((function (map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
var s__75453__$1 = s__75453;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__75453__$1);
if(temp__5720__auto__){
var s__75453__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__75453__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__75453__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__75455 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__75454 = (0);
while(true){
if((i__75454 < size__4522__auto__)){
var vec__75458 = cljs.core._nth(c__4521__auto__,i__75454);
var ns = cljs.core.nth.call(null,vec__75458,(0),null);
var workspaces__$1 = cljs.core.nth.call(null,vec__75458,(1),null);
cljs.core.chunk_append.call(null,b__75455,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".nest-group-small",".nest-group-small",-1151011320),(function (){var iter__4523__auto__ = ((function (i__75454,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function nubank$workspaces$ui$iter__75452_$_iter__75461(s__75462){
return (new cljs.core.LazySeq(null,((function (i__75454,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
var s__75462__$1 = s__75462;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__75462__$1);
if(temp__5720__auto____$1){
var s__75462__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__75462__$2)){
var c__4521__auto____$1 = cljs.core.chunk_first.call(null,s__75462__$2);
var size__4522__auto____$1 = cljs.core.count.call(null,c__4521__auto____$1);
var b__75464 = cljs.core.chunk_buffer.call(null,size__4522__auto____$1);
if((function (){var i__75463 = (0);
while(true){
if((i__75463 < size__4522__auto____$1)){
var map__75465 = cljs.core._nth(c__4521__auto____$1,i__75463);
var map__75465__$1 = (((((!((map__75465 == null))))?(((((map__75465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75465.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75465):map__75465);
var workspace_id = cljs.core.get.call(null,map__75465__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75465__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
cljs.core.chunk_append.call(null,b__75464,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_id),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75463,i__75454,map__75465,map__75465__$1,workspace_id,workspace_title,c__4521__auto____$1,size__4522__auto____$1,b__75464,s__75462__$2,temp__5720__auto____$1,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));
});})(i__75463,i__75454,map__75465,map__75465__$1,workspace_id,workspace_title,c__4521__auto____$1,size__4522__auto____$1,b__75464,s__75462__$2,temp__5720__auto____$1,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),cljs.core.name.call(null,cljs.core.symbol.call(null,workspace_title))));

var G__77731 = (i__75463 + (1));
i__75463 = G__77731;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75464),nubank$workspaces$ui$iter__75452_$_iter__75461.call(null,cljs.core.chunk_rest.call(null,s__75462__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75464),null);
}
} else {
var map__75469 = cljs.core.first.call(null,s__75462__$2);
var map__75469__$1 = (((((!((map__75469 == null))))?(((((map__75469.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75469.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75469):map__75469);
var workspace_id = cljs.core.get.call(null,map__75469__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75469__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_id),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75454,map__75469,map__75469__$1,workspace_id,workspace_title,s__75462__$2,temp__5720__auto____$1,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));
});})(i__75454,map__75469,map__75469__$1,workspace_id,workspace_title,s__75462__$2,temp__5720__auto____$1,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),cljs.core.name.call(null,cljs.core.symbol.call(null,workspace_title))),nubank$workspaces$ui$iter__75452_$_iter__75461.call(null,cljs.core.rest.call(null,s__75462__$2)));
}
} else {
return null;
}
break;
}
});})(i__75454,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
,null,null));
});})(i__75454,vec__75458,ns,workspaces__$1,c__4521__auto__,size__4522__auto__,b__75455,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
;
return iter__4523__auto__(cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),workspaces__$1));
})())));

var G__77752 = (i__75454 + (1));
i__75454 = G__77752;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75455),nubank$workspaces$ui$iter__75452.call(null,cljs.core.chunk_rest.call(null,s__75453__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75455),null);
}
} else {
var vec__75473 = cljs.core.first.call(null,s__75453__$2);
var ns = cljs.core.nth.call(null,vec__75473,(0),null);
var workspaces__$1 = cljs.core.nth.call(null,vec__75473,(1),null);
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".nest-group-small",".nest-group-small",-1151011320),(function (){var iter__4523__auto__ = ((function (vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function nubank$workspaces$ui$iter__75452_$_iter__75476(s__75477){
return (new cljs.core.LazySeq(null,((function (vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
var s__75477__$1 = s__75477;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__75477__$1);
if(temp__5720__auto____$1){
var s__75477__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__75477__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__75477__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__75479 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__75478 = (0);
while(true){
if((i__75478 < size__4522__auto__)){
var map__75482 = cljs.core._nth(c__4521__auto__,i__75478);
var map__75482__$1 = (((((!((map__75482 == null))))?(((((map__75482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75482.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75482):map__75482);
var workspace_id = cljs.core.get.call(null,map__75482__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75482__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
cljs.core.chunk_append.call(null,b__75479,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_id),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75478,map__75482,map__75482__$1,workspace_id,workspace_title,c__4521__auto__,size__4522__auto__,b__75479,s__75477__$2,temp__5720__auto____$1,vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));
});})(i__75478,map__75482,map__75482__$1,workspace_id,workspace_title,c__4521__auto__,size__4522__auto__,b__75479,s__75477__$2,temp__5720__auto____$1,vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),cljs.core.name.call(null,cljs.core.symbol.call(null,workspace_title))));

var G__77772 = (i__75478 + (1));
i__75478 = G__77772;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75479),nubank$workspaces$ui$iter__75452_$_iter__75476.call(null,cljs.core.chunk_rest.call(null,s__75477__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75479),null);
}
} else {
var map__75486 = cljs.core.first.call(null,s__75477__$2);
var map__75486__$1 = (((((!((map__75486 == null))))?(((((map__75486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75486):map__75486);
var workspace_id = cljs.core.get.call(null,map__75486__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858));
var workspace_title = cljs.core.get.call(null,map__75486__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263));
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(workspace_id),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75486,map__75486__$1,workspace_id,workspace_title,s__75477__$2,temp__5720__auto____$1,vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,workspace_id,null,(1),null)))))),null,(1),null)))))], null));
});})(map__75486,map__75486__$1,workspace_id,workspace_title,s__75477__$2,temp__5720__auto____$1,vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),cljs.core.name.call(null,cljs.core.symbol.call(null,workspace_title))),nubank$workspaces$ui$iter__75452_$_iter__75476.call(null,cljs.core.rest.call(null,s__75477__$2)));
}
} else {
return null;
}
break;
}
});})(vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
,null,null));
});})(vec__75473,ns,workspaces__$1,s__75453__$2,temp__5720__auto__,map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
;
return iter__4523__auto__(cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-title","nubank.workspaces.ui/workspace-title",-373163263),workspaces__$1));
})())),nubank$workspaces$ui$iter__75452.call(null,cljs.core.rest.call(null,s__75453__$2)));
}
} else {
return null;
}
break;
}
});})(map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
,null,null));
});})(map__75437,map__75437__$1,statics,locals,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
;
return iter__4523__auto__(cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.comp.call(null,cljs.core.namespace,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858)),statics)));
})());
})(),fulcro.client.localized_dom.br.call(null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".header",".header",-1761691025),"Cards"),(function (){var iter__4523__auto__ = ((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function nubank$workspaces$ui$iter__75494(s__75495){
return (new cljs.core.LazySeq(null,((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
var s__75495__$1 = s__75495;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__75495__$1);
if(temp__5720__auto__){
var s__75495__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__75495__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__75495__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__75497 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__75496 = (0);
while(true){
if((i__75496 < size__4522__auto__)){
var vec__75499 = cljs.core._nth(c__4521__auto__,i__75496);
var ns = cljs.core.nth.call(null,vec__75499,(0),null);
var cards__$1 = cljs.core.nth.call(null,vec__75499,(1),null);
cljs.core.chunk_append.call(null,b__75497,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)], null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".ns-header",".ns-header",60233442),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".expand-arrow",".expand-arrow",489938474),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75496,vec__75499,ns,cards__$1,c__4521__auto__,size__4522__auto__,b__75497,s__75495__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","toggle-ns-expansion","nubank.workspaces.ui/toggle-ns-expansion",117524570,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","expand-path","nubank.workspaces.ui/expand-path",-795465683),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"card-ns","card-ns",-470859449),ns], null),null,(1),null)))))),null,(1),null)))))], null));
});})(i__75496,vec__75499,ns,cards__$1,c__4521__auto__,size__4522__auto__,b__75497,s__75495__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"card-ns","card-ns",-470859449),ns], null)))?nubank.workspaces.ui.core.arrow_down:nubank.workspaces.ui.core.arrow_right)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"card-ns","card-ns",-470859449),ns], null)))?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".nest-group",".nest-group",-588503719),cljs.core.mapv.call(null,nubank.workspaces.ui.card_index_listing,cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cards__$1))):null)));

var G__77797 = (i__75496 + (1));
i__75496 = G__77797;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75497),nubank$workspaces$ui$iter__75494.call(null,cljs.core.chunk_rest.call(null,s__75495__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75497),null);
}
} else {
var vec__75506 = cljs.core.first.call(null,s__75495__$2);
var ns = cljs.core.nth.call(null,vec__75506,(0),null);
var cards__$1 = cljs.core.nth.call(null,vec__75506,(1),null);
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)], null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".ns-header",".ns-header",60233442),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".expand-arrow",".expand-arrow",489938474),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (vec__75506,ns,cards__$1,s__75495__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","toggle-ns-expansion","nubank.workspaces.ui/toggle-ns-expansion",117524570,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","expand-path","nubank.workspaces.ui/expand-path",-795465683),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"card-ns","card-ns",-470859449),ns], null),null,(1),null)))))),null,(1),null)))))], null));
});})(vec__75506,ns,cards__$1,s__75495__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"card-ns","card-ns",-470859449),ns], null)))?nubank.workspaces.ui.core.arrow_down:nubank.workspaces.ui.core.arrow_right)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"card-ns","card-ns",-470859449),ns], null)))?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".nest-group",".nest-group",-588503719),cljs.core.mapv.call(null,nubank.workspaces.ui.card_index_listing,cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cards__$1))):null)),nubank$workspaces$ui$iter__75494.call(null,cljs.core.rest.call(null,s__75495__$2)));
}
} else {
return null;
}
break;
}
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
,null,null));
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
;
return iter__4523__auto__(cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.comp.call(null,cljs.core.namespace,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)),uis)));
})(),fulcro.client.localized_dom.br.call(null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".pointer.header",".pointer.header",-301986551),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return nubank.workspaces.ui.add_card.call(null,this$,new cljs.core.Symbol("nubank.workspaces.card-types.test","test-all","nubank.workspaces.card-types.test/test-all",-1512776685,null));
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),"Tests"),(function (){var iter__4523__auto__ = ((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function nubank$workspaces$ui$iter__75513(s__75514){
return (new cljs.core.LazySeq(null,((function (map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
var s__75514__$1 = s__75514;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__75514__$1);
if(temp__5720__auto__){
var s__75514__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__75514__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__75514__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__75516 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__75515 = (0);
while(true){
if((i__75515 < size__4522__auto__)){
var vec__75519 = cljs.core._nth(c__4521__auto__,i__75515);
var ns = cljs.core.nth.call(null,vec__75519,(0),null);
var cards__$1 = cljs.core.nth.call(null,vec__75519,(1),null);
cljs.core.chunk_append.call(null,b__75516,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)], null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".ns-header",".ns-header",60233442),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".expand-arrow",".expand-arrow",489938474),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (i__75515,vec__75519,ns,cards__$1,c__4521__auto__,size__4522__auto__,b__75516,s__75514__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","toggle-ns-expansion","nubank.workspaces.ui/toggle-ns-expansion",117524570,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","expand-path","nubank.workspaces.ui/expand-path",-795465683),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test-ns","test-ns",332567313),ns], null),null,(1),null)))))),null,(1),null)))))], null));
});})(i__75515,vec__75519,ns,cards__$1,c__4521__auto__,size__4522__auto__,b__75516,s__75514__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test-ns","test-ns",332567313),ns], null)))?nubank.workspaces.ui.core.arrow_down:nubank.workspaces.ui.core.arrow_right)),nubank.workspaces.ui.card_index_listing.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cljs.core.symbol.call(null,ns)], null))),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test-ns","test-ns",332567313),ns], null)))?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".nest-group",".nest-group",-588503719),cljs.core.mapv.call(null,nubank.workspaces.ui.card_index_listing,cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cards__$1))):null)));

var G__77828 = (i__75515 + (1));
i__75515 = G__77828;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75516),nubank$workspaces$ui$iter__75513.call(null,cljs.core.chunk_rest.call(null,s__75514__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__75516),null);
}
} else {
var vec__75526 = cljs.core.first.call(null,s__75514__$2);
var ns = cljs.core.nth.call(null,vec__75526,(0),null);
var cards__$1 = cljs.core.nth.call(null,vec__75526,(1),null);
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)], null),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".ns-header",".ns-header",60233442),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".expand-arrow",".expand-arrow",489938474),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (vec__75526,ns,cards__$1,s__75514__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","toggle-ns-expansion","nubank.workspaces.ui/toggle-ns-expansion",117524570,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","expand-path","nubank.workspaces.ui/expand-path",-795465683),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test-ns","test-ns",332567313),ns], null),null,(1),null)))))),null,(1),null)))))], null));
});})(vec__75526,ns,cards__$1,s__75514__$2,temp__5720__auto__,map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test-ns","test-ns",332567313),ns], null)))?nubank.workspaces.ui.core.arrow_down:nubank.workspaces.ui.core.arrow_right)),nubank.workspaces.ui.card_index_listing.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cljs.core.symbol.call(null,ns)], null))),(cljs.core.truth_(cljs.core.get_in.call(null,expanded,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test-ns","test-ns",332567313),ns], null)))?fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".nest-group",".nest-group",-588503719),cljs.core.mapv.call(null,nubank.workspaces.ui.card_index_listing,cljs.core.sort_by.call(null,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809),cards__$1))):null)),nubank$workspaces$ui$iter__75513.call(null,cljs.core.rest.call(null,s__75514__$2)));
}
} else {
return null;
}
break;
}
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
,null,null));
});})(map__75433,map__75433__$1,uis,tests,map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
;
return iter__4523__auto__(cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.comp.call(null,cljs.core.namespace,new cljs.core.Keyword("nubank.workspaces.model","card-id","nubank.workspaces.model/card-id",605424809)),cljs.core.remove.call(null,new cljs.core.Keyword("nubank.workspaces.model","card-unlisted?","nubank.workspaces.model/card-unlisted?",-302030555),tests))));
})());
})():fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".menu-show",".menu-show",-330773335),fulcro.client.localized_dom.button.call(null,new cljs.core.Keyword(null,".index-action-button",".index-action-button",859695279),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","toggle-index-view","nubank.workspaces.ui/toggle-index-view",-2043129614,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)))))], null));
});})(map__75425,map__75425__$1,cards,ws_tabs,workspaces,settings,expanded,spotlight,show_spotlight_QMARK_,show_help_modal_QMARK_,_STAR_reconciler_STAR__orig_val__75414,_STAR_depth_STAR__orig_val__75415,_STAR_shared_STAR__orig_val__75416,_STAR_instrument_STAR__orig_val__75417,_STAR_parent_STAR__orig_val__75418,_STAR_reconciler_STAR__temp_val__75419,_STAR_depth_STAR__temp_val__75420,_STAR_shared_STAR__temp_val__75421,_STAR_instrument_STAR__temp_val__75422,_STAR_parent_STAR__temp_val__75423,this$,this__59535__auto__,x75413_77389))
], null),"\u00BB"))),fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".workspaces",".workspaces",317220476),nubank.workspaces.ui.workspace_tabs.call(null,ws_tabs)));
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__75418;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__75417;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__75416;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__75415;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__75414;
}});})(x75413_77389))
;

x75413_77389.initLocalState = ((function (x75413_77389){
return (function (){
var this$ = this;
var ret__59510__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"spotlight-select","spotlight-select",-635934435),((function (this$,x75413_77389){
return (function (p__75531,solo_QMARK_){
var map__75532 = p__75531;
var map__75532__$1 = (((((!((map__75532 == null))))?(((((map__75532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75532):map__75532);
var id = cljs.core.get.call(null,map__75532__$1,new cljs.core.Keyword("nubank.workspaces.ui.spotlight","id","nubank.workspaces.ui.spotlight/id",-871569707));
var type = cljs.core.get.call(null,map__75532__$1,new cljs.core.Keyword("nubank.workspaces.ui.spotlight","type","nubank.workspaces.ui.spotlight/type",1675623435));
if(cljs.core.truth_(id)){
if(cljs.core._EQ_.call(null,type,new cljs.core.Keyword("nubank.workspaces.ui.spotlight","workspace","nubank.workspaces.ui.spotlight/workspace",-529313372))){
fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("nubank.workspaces.ui","select-workspace","nubank.workspaces.ui/select-workspace",558971453,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),null,(1),null)),(new cljs.core.List(null,id,null,(1),null)))))),null,(1),null)))))], null));
} else {
if(cljs.core.truth_(solo_QMARK_)){
nubank.workspaces.ui.add_card_solo.call(null,this$,id);
} else {
nubank.workspaces.ui.add_card.call(null,this$,id);

}
}
} else {
}

return fulcro.client.mutations.set_value_BANG_.call(null,this$,new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402),false);
});})(this$,x75413_77389))
], null);
var obj75539 = ({"fulcro$state":ret__59510__auto__});
return obj75539;
});})(x75413_77389))
;


nubank.workspaces.ui.WorkspacesRoot.prototype.constructor = nubank.workspaces.ui.WorkspacesRoot;

nubank.workspaces.ui.WorkspacesRoot.prototype.constructor.displayName = "nubank.workspaces.ui/WorkspacesRoot";

nubank.workspaces.ui.WorkspacesRoot.prototype.fulcro$isComponent = true;

var x75540_77885 = nubank.workspaces.ui.WorkspacesRoot;
x75540_77885.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75540_77885.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75540_77885){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0),new cljs.core.Keyword(null,"background","background",-863952629),"#f7f7f7",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"box-sizing","box-sizing",-1956090239),"border-box",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"width","width",-384071477),"100vw",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".menu",".menu",986259874),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"padding-right","padding-right",-1250249681),"10px",new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_open_sans,new cljs.core.Keyword(null,"flex-shrink","flex-shrink",1481146383),"0",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"min-width","min-width",1926193728),"300px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspaces",".workspaces",317220476),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"max-height","max-height",-612563804),"100vh",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".index-action-button",".index-action-button",859695279),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"margin-top","margin-top",392161226),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"outline","outline",793464534),new cljs.core.Keyword(null,"margin-right","margin-right",809689658),new cljs.core.Keyword(null,"border","border",1444987323)],["23px","bold","-4px","transparent","pointer","0","none","5px","none"]),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&.spotlight","&.spotlight",1243372633),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"color","color",1011675173),"transparent",new cljs.core.Keyword(null,"text-shadow","text-shadow",116733623),"0 0 #ffffff",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"14px",new cljs.core.Keyword(null,"margin","margin",-995903681),"-2px 10px 0 0"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&.help","&.help",-256627561),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"17px",new cljs.core.Keyword(null,"margin","margin",-995903681),"-2px 10px 0 0"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"background","background",-863952629),"#404040",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"color","color",1011675173),"#fff",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"3px 7px",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24)",new cljs.core.Keyword(null,"margin","margin",-995903681),"1px 1px 6px",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#fff"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".row",".row",-368374508),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"flex"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".pointer",".pointer",614214252),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".flex",".flex",-73425686),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspaces-solo",".workspaces-solo",-85217111),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".nest-group",".nest-group",-588503719),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"32px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".nest-group-small",".nest-group-small",-1151011320),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"18px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".ns-header",".ns-header",60233442),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".expand-arrow",".expand-arrow",489938474),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin-right","margin-right",809689658),"5px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"14px"], null)], null)], null);
});})(x75540_77885))
;

x75540_77885.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75540_77885){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nubank.workspaces.ui.core.CSS,nubank.workspaces.ui.HelpDialog], null);
});})(x75540_77885))
;

x75540_77885.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x75540_77885.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x75540_77885){
return (function (this$,card_definitions){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),cljs.core.mapv.call(null,((function (this$__$1,x75540_77885){
return (function (p1__75399_SHARP_){
return fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.CardIndexListing,p1__75399_SHARP_);
});})(this$__$1,x75540_77885))
,cljs.core.vals.call(null,card_definitions)),new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450),cljs.core.into.call(null,nubank.workspaces.ui.initialize_static_workspaces.call(null),cljs.core.mapv.call(null,((function (this$__$1,x75540_77885){
return (function (p1__75400_SHARP_){
return fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.Workspace,nubank.workspaces.lib.local_storage.tget.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),p1__75400_SHARP_], null)));
});})(this$__$1,x75540_77885))
,nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","local-workspaces","nubank.workspaces.ui/local-workspaces",-1846378387),cljs.core.PersistentVector.EMPTY))),new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword("nubank.workspaces.ui","ws-tabs","nubank.workspaces.ui/ws-tabs",872859899),fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.WorkspaceTabs,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828),fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.spotlight.Spotlight,cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402),false,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639),false,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311),nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311),true)], null)], null);
});})(x75540_77885))
;

x75540_77885.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75540_77885.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75540_77885){
return (function (this$,p__75541){
var map__75542 = p__75541;
var map__75542__$1 = (((((!((map__75542 == null))))?(((((map__75542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75542):map__75542);
var cards = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701));
var ws_tabs = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","ws-tabs","nubank.workspaces.ui/ws-tabs",872859899));
var workspaces = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450));
var settings = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956));
var expanded = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223));
var spotlight = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828));
var show_spotlight_QMARK_ = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402));
var show_help_modal_QMARK_ = cljs.core.get.call(null,map__75542__$1,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639));
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton"], null);
});})(x75540_77885))
;

x75540_77885.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75540_77885.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75540_77885){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402),new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.CardIndexListing)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceIndexListing)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","ws-tabs","nubank.workspaces.ui/ws-tabs",872859899),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceTabs)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.spotlight.Spotlight)], null)], null);
});})(x75540_77885))
;


var x75547_77955 = nubank.workspaces.ui.WorkspacesRoot.prototype;
x75547_77955.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x75547_77955.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x75547_77955){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0),new cljs.core.Keyword(null,"background","background",-863952629),"#f7f7f7",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"box-sizing","box-sizing",-1956090239),"border-box",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"width","width",-384071477),"100vw",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"padding","padding",1660304693),"10px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".menu",".menu",986259874),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"padding-right","padding-right",-1250249681),"10px",new cljs.core.Keyword(null,"font-family","font-family",-667419874),nubank.workspaces.ui.core.font_open_sans,new cljs.core.Keyword(null,"flex-shrink","flex-shrink",1481146383),"0",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"min-width","min-width",1926193728),"300px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspaces",".workspaces",317220476),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"max-height","max-height",-612563804),"100vh",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".index-action-button",".index-action-button",859695279),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"margin-top","margin-top",392161226),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"outline","outline",793464534),new cljs.core.Keyword(null,"margin-right","margin-right",809689658),new cljs.core.Keyword(null,"border","border",1444987323)],["23px","bold","-4px","transparent","pointer","0","none","5px","none"]),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&.spotlight","&.spotlight",1243372633),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"color","color",1011675173),"transparent",new cljs.core.Keyword(null,"text-shadow","text-shadow",116733623),"0 0 #ffffff",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"14px",new cljs.core.Keyword(null,"margin","margin",-995903681),"-2px 10px 0 0"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"&.help","&.help",-256627561),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"17px",new cljs.core.Keyword(null,"margin","margin",-995903681),"-2px 10px 0 0"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".header",".header",-1761691025),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"background","background",-863952629),"#404040",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"color","color",1011675173),"#fff",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"padding","padding",1660304693),"3px 7px",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24)",new cljs.core.Keyword(null,"margin","margin",-995903681),"1px 1px 6px",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#fff"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".row",".row",-368374508),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"flex"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".pointer",".pointer",614214252),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".flex",".flex",-73425686),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspaces-solo",".workspaces-solo",-85217111),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"100%"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".workspace",".workspace",1526137578),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".nest-group",".nest-group",-588503719),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"32px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".nest-group-small",".nest-group-small",-1151011320),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"18px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".ns-header",".ns-header",60233442),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".expand-arrow",".expand-arrow",489938474),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin-right","margin-right",809689658),"5px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"14px"], null)], null)], null);
});})(x75547_77955))
;

x75547_77955.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x75547_77955){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nubank.workspaces.ui.core.CSS,nubank.workspaces.ui.HelpDialog], null);
});})(x75547_77955))
;

x75547_77955.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x75547_77955.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x75547_77955){
return (function (this$,card_definitions){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),cljs.core.mapv.call(null,((function (this$__$1,x75547_77955){
return (function (p1__75399_SHARP_){
return fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.CardIndexListing,p1__75399_SHARP_);
});})(this$__$1,x75547_77955))
,cljs.core.vals.call(null,card_definitions)),new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450),cljs.core.into.call(null,nubank.workspaces.ui.initialize_static_workspaces.call(null),cljs.core.mapv.call(null,((function (this$__$1,x75547_77955){
return (function (p1__75400_SHARP_){
return fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.Workspace,nubank.workspaces.lib.local_storage.tget.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-id","nubank.workspaces.ui/workspace-id",-1045831858),p1__75400_SHARP_], null)));
});})(this$__$1,x75547_77955))
,nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","local-workspaces","nubank.workspaces.ui/local-workspaces",-1846378387),cljs.core.PersistentVector.EMPTY))),new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword("nubank.workspaces.ui","ws-tabs","nubank.workspaces.ui/ws-tabs",872859899),fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.WorkspaceTabs,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828),fulcro.client.primitives.get_initial_state.call(null,nubank.workspaces.ui.spotlight.Spotlight,cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402),false,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639),false,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311),nubank.workspaces.lib.local_storage.get.call(null,new cljs.core.Keyword("nubank.workspaces.ui","show-index?","nubank.workspaces.ui/show-index?",580921311),true)], null)], null);
});})(x75547_77955))
;

x75547_77955.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x75547_77955.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x75547_77955){
return (function (this$,p__75552){
var map__75553 = p__75552;
var map__75553__$1 = (((((!((map__75553 == null))))?(((((map__75553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75553.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75553):map__75553);
var cards = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701));
var ws_tabs = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","ws-tabs","nubank.workspaces.ui/ws-tabs",872859899));
var workspaces = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450));
var settings = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956));
var expanded = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223));
var spotlight = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828));
var show_spotlight_QMARK_ = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402));
var show_help_modal_QMARK_ = cljs.core.get.call(null,map__75553__$1,new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639));
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","workspace-root","nubank.workspaces.ui/workspace-root",695328612),"singleton"], null);
});})(x75547_77955))
;

x75547_77955.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x75547_77955.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x75547_77955){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nubank.workspaces.ui","settings","nubank.workspaces.ui/settings",139105956),new cljs.core.Keyword("nubank.workspaces.ui","expanded","nubank.workspaces.ui/expanded",-751310223),new cljs.core.Keyword("nubank.workspaces.ui","show-spotlight?","nubank.workspaces.ui/show-spotlight?",1825873402),new cljs.core.Keyword("nubank.workspaces.ui","show-help-modal?","nubank.workspaces.ui/show-help-modal?",827473639),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","cards","nubank.workspaces.ui/cards",-577802701),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.CardIndexListing)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","workspaces","nubank.workspaces.ui/workspaces",1165878450),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceIndexListing)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","ws-tabs","nubank.workspaces.ui/ws-tabs",872859899),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.WorkspaceTabs)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nubank.workspaces.ui","spotlight","nubank.workspaces.ui/spotlight",1269025828),fulcro.client.primitives.get_query.call(null,nubank.workspaces.ui.spotlight.Spotlight)], null)], null);
});})(x75547_77955))
;


nubank.workspaces.ui.WorkspacesRoot.cljs$lang$type = true;

nubank.workspaces.ui.WorkspacesRoot.cljs$lang$ctorStr = "nubank.workspaces.ui/WorkspacesRoot";

nubank.workspaces.ui.WorkspacesRoot.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui/WorkspacesRoot");
});
nubank.workspaces.ui.workspaces_root = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.WorkspacesRoot);

//# sourceMappingURL=nubank.workspaces.ui.js.map
