goog.provide('com.wsscode.pathom.sugar');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('com.fulcrologic.guardrails.core');
goog.require('com.wsscode.pathom.connect');
goog.require('com.wsscode.pathom.connect.foreign');
goog.require('com.wsscode.pathom.core');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom.sugar","connect-reader","com.wsscode.pathom.sugar/connect-reader",608342722),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null),cljs.core.fn_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom.sugar","plugins","com.wsscode.pathom.sugar/plugins",747752371),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null),cljs.core.fn_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom.sugar","foreign-parsers","com.wsscode.pathom.sugar/foreign-parsers",-1167863678),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"fn?","fn?",1820990818,null),cljs.core.fn_QMARK_,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__88854){
return cljs.core.coll_QMARK_.call(null,G__88854);
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null))], null),null));
/**
 * Create a standard connect parser using the serial parser.
 * 
 *   This parser recommended for handling small and simple queries, like
 *   resolvers to process missing configuration options.
 */
com.wsscode.pathom.sugar.connect_serial_parser = (function com$wsscode$pathom$sugar$connect_serial_parser(var_args){
var G__88866 = arguments.length;
switch (G__88866) {
case 1:
return com.wsscode.pathom.sugar.connect_serial_parser.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.sugar.connect_serial_parser.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.sugar.connect_serial_parser.cljs$core$IFn$_invoke$arity$1 = (function (register){
return com.wsscode.pathom.sugar.connect_serial_parser.call(null,cljs.core.PersistentArrayMap.EMPTY,register);
});

com.wsscode.pathom.sugar.connect_serial_parser.cljs$core$IFn$_invoke$arity$2 = (function (p__88879,register){
var map__88880 = p__88879;
var map__88880__$1 = (((((!((map__88880 == null))))?(((((map__88880.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88880.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88880):map__88880);
var connect_reader = cljs.core.get.call(null,map__88880__$1,new cljs.core.Keyword("com.wsscode.pathom.sugar","connect-reader","com.wsscode.pathom.sugar/connect-reader",608342722));
var foreign_parsers = cljs.core.get.call(null,map__88880__$1,new cljs.core.Keyword("com.wsscode.pathom.sugar","foreign-parsers","com.wsscode.pathom.sugar/foreign-parsers",-1167863678));
var plugins = cljs.core.get.call(null,map__88880__$1,new cljs.core.Keyword("com.wsscode.pathom.sugar","plugins","com.wsscode.pathom.sugar/plugins",747752371));
return com.wsscode.pathom.core.parser.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("com.wsscode.pathom.core","env","com.wsscode.pathom.core/env",602275378),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.core","reader","com.wsscode.pathom.core/reader",1510046410),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.pathom.core.map_reader,(function (){var or__4131__auto__ = connect_reader;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return com.wsscode.pathom.connect.reader2;
}
})(),com.wsscode.pathom.connect.open_ident_reader,com.wsscode.pathom.core.env_placeholder_reader], null),new cljs.core.Keyword("com.wsscode.pathom.core","placeholder-prefixes","com.wsscode.pathom.core/placeholder-prefixes",-1362240644),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [">",null], null), null)], null),new cljs.core.Keyword("com.wsscode.pathom.core","mutate","com.wsscode.pathom.core/mutate",-2086097173),com.wsscode.pathom.connect.mutate,new cljs.core.Keyword("com.wsscode.pathom.core","plugins","com.wsscode.pathom.core/plugins",-2128476796),(function (){var G__88901 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.pathom.connect.connect_plugin.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.connect","register","com.wsscode.pathom.connect/register",-386283650),register], null)),(cljs.core.truth_(foreign_parsers)?com.wsscode.pathom.connect.foreign.foreign_parser_plugin.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.connect.foreign","parsers","com.wsscode.pathom.connect.foreign/parsers",-1415592655),foreign_parsers], null)):cljs.core.PersistentArrayMap.EMPTY),com.wsscode.pathom.core.error_handler_plugin,com.wsscode.pathom.core.trace_plugin], null);
if(cljs.core.truth_(plugins)){
return plugins.call(null,G__88901);
} else {
return G__88901;
}
})()], null));
});

com.wsscode.pathom.sugar.connect_serial_parser.cljs$lang$maxFixedArity = 2;

/**
 * Create a standard connect parser using the async parser.
 * 
 *   Just like the serial parser, but supports waiting for core.async channels
 *   in responses. The most common usage of this one is in ClojureScript land, where
 *   most of the IO needs to be async.
 */
com.wsscode.pathom.sugar.connect_async_parser = (function com$wsscode$pathom$sugar$connect_async_parser(var_args){
var G__88911 = arguments.length;
switch (G__88911) {
case 1:
return com.wsscode.pathom.sugar.connect_async_parser.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.sugar.connect_async_parser.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.sugar.connect_async_parser.cljs$core$IFn$_invoke$arity$1 = (function (register){
return com.wsscode.pathom.sugar.connect_async_parser.call(null,cljs.core.PersistentArrayMap.EMPTY,register);
});

com.wsscode.pathom.sugar.connect_async_parser.cljs$core$IFn$_invoke$arity$2 = (function (p__88923,register){
var map__88925 = p__88923;
var map__88925__$1 = (((((!((map__88925 == null))))?(((((map__88925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88925.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88925):map__88925);
var connect_reader = cljs.core.get.call(null,map__88925__$1,new cljs.core.Keyword("com.wsscode.pathom.sugar","connect-reader","com.wsscode.pathom.sugar/connect-reader",608342722));
var foreign_parsers = cljs.core.get.call(null,map__88925__$1,new cljs.core.Keyword("com.wsscode.pathom.sugar","foreign-parsers","com.wsscode.pathom.sugar/foreign-parsers",-1167863678));
var plugins = cljs.core.get.call(null,map__88925__$1,new cljs.core.Keyword("com.wsscode.pathom.sugar","plugins","com.wsscode.pathom.sugar/plugins",747752371));
return com.wsscode.pathom.core.async_parser.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("com.wsscode.pathom.core","env","com.wsscode.pathom.core/env",602275378),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.core","reader","com.wsscode.pathom.core/reader",1510046410),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.pathom.core.map_reader,(function (){var or__4131__auto__ = connect_reader;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return com.wsscode.pathom.connect.async_reader2;
}
})(),com.wsscode.pathom.connect.open_ident_reader,com.wsscode.pathom.core.env_placeholder_reader], null),new cljs.core.Keyword("com.wsscode.pathom.core","placeholder-prefixes","com.wsscode.pathom.core/placeholder-prefixes",-1362240644),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [">",null], null), null)], null),new cljs.core.Keyword("com.wsscode.pathom.core","mutate","com.wsscode.pathom.core/mutate",-2086097173),com.wsscode.pathom.connect.mutate_async,new cljs.core.Keyword("com.wsscode.pathom.core","plugins","com.wsscode.pathom.core/plugins",-2128476796),(function (){var G__88935 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.pathom.connect.connect_plugin.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.connect","register","com.wsscode.pathom.connect/register",-386283650),register], null)),(cljs.core.truth_(foreign_parsers)?com.wsscode.pathom.connect.foreign.foreign_parser_plugin.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.connect.foreign","parsers","com.wsscode.pathom.connect.foreign/parsers",-1415592655),foreign_parsers], null)):cljs.core.PersistentArrayMap.EMPTY),com.wsscode.pathom.core.error_handler_plugin,com.wsscode.pathom.core.trace_plugin], null);
if(cljs.core.truth_(plugins)){
return plugins.call(null,G__88935);
} else {
return G__88935;
}
})()], null));
});

com.wsscode.pathom.sugar.connect_async_parser.cljs$lang$maxFixedArity = 2;

/**
 * Create a standard connect parser using the parallel parser.
 * 
 *   This is recommended if you have a lot of different information sources that
 *   are IO bound. This parser can handle things in parallel, but adds extra overhead
 *   to processing, use it in case your system has good parallelism opportunities.
 */
com.wsscode.pathom.sugar.connect_parallel_parser = (function com$wsscode$pathom$sugar$connect_parallel_parser(var_args){
var G__88954 = arguments.length;
switch (G__88954) {
case 1:
return com.wsscode.pathom.sugar.connect_parallel_parser.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.sugar.connect_parallel_parser.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.sugar.connect_parallel_parser.cljs$core$IFn$_invoke$arity$1 = (function (register){
return com.wsscode.pathom.sugar.connect_parallel_parser.call(null,cljs.core.PersistentArrayMap.EMPTY,register);
});

com.wsscode.pathom.sugar.connect_parallel_parser.cljs$core$IFn$_invoke$arity$2 = (function (p__88966,register){
var map__88967 = p__88966;
var map__88967__$1 = (((((!((map__88967 == null))))?(((((map__88967.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88967.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88967):map__88967);
var connect_reader = cljs.core.get.call(null,map__88967__$1,new cljs.core.Keyword("com.wsscode.pathom.sugar","connect-reader","com.wsscode.pathom.sugar/connect-reader",608342722));
return com.wsscode.pathom.core.parallel_parser.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("com.wsscode.pathom.core","env","com.wsscode.pathom.core/env",602275378),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.core","reader","com.wsscode.pathom.core/reader",1510046410),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.pathom.core.map_reader,(function (){var or__4131__auto__ = connect_reader;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return com.wsscode.pathom.connect.parallel_reader;
}
})(),com.wsscode.pathom.connect.open_ident_reader,com.wsscode.pathom.core.env_placeholder_reader], null),new cljs.core.Keyword("com.wsscode.pathom.core","placeholder-prefixes","com.wsscode.pathom.core/placeholder-prefixes",-1362240644),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [">",null], null), null)], null),new cljs.core.Keyword("com.wsscode.pathom.core","mutate","com.wsscode.pathom.core/mutate",-2086097173),com.wsscode.pathom.connect.mutate_async,new cljs.core.Keyword("com.wsscode.pathom.core","plugins","com.wsscode.pathom.core/plugins",-2128476796),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.pathom.connect.connect_plugin.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.connect","register","com.wsscode.pathom.connect/register",-386283650),register], null)),com.wsscode.pathom.core.error_handler_plugin,com.wsscode.pathom.core.trace_plugin], null)], null));
});

com.wsscode.pathom.sugar.connect_parallel_parser.cljs$lang$maxFixedArity = 2;

/**
 * Transforms the signature of a regular parser to one that takes
 *   some initial context to run the query. This returns a fn with
 *   the following arities:
 * 
 *   [context query] => runs query using context as initial data.
 *   [env context query] => same as before but accepts initial environment.
 */
com.wsscode.pathom.sugar.context_parser = (function com$wsscode$pathom$sugar$context_parser(parser){
return (function() {
var com$wsscode$pathom$sugar$context_parser_$_context_parser_internal = null;
var com$wsscode$pathom$sugar$context_parser_$_context_parser_internal__2 = (function (context,query){
return parser.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.core","entity","com.wsscode.pathom.core/entity",884706031),cljs.core.atom.call(null,context)], null),query);
});
var com$wsscode$pathom$sugar$context_parser_$_context_parser_internal__3 = (function (env,context,query){
return parser.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword("com.wsscode.pathom.core","entity","com.wsscode.pathom.core/entity",884706031),cljs.core.atom.call(null,context)),query);
});
com$wsscode$pathom$sugar$context_parser_$_context_parser_internal = function(env,context,query){
switch(arguments.length){
case 2:
return com$wsscode$pathom$sugar$context_parser_$_context_parser_internal__2.call(this,env,context);
case 3:
return com$wsscode$pathom$sugar$context_parser_$_context_parser_internal__3.call(this,env,context,query);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$pathom$sugar$context_parser_$_context_parser_internal.cljs$core$IFn$_invoke$arity$2 = com$wsscode$pathom$sugar$context_parser_$_context_parser_internal__2;
com$wsscode$pathom$sugar$context_parser_$_context_parser_internal.cljs$core$IFn$_invoke$arity$3 = com$wsscode$pathom$sugar$context_parser_$_context_parser_internal__3;
return com$wsscode$pathom$sugar$context_parser_$_context_parser_internal;
})()
});

//# sourceMappingURL=com.wsscode.pathom.sugar.js.map
