goog.provide('fulcro.client.impl.data_targeting');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fulcro.util');
fulcro.client.impl.data_targeting.multiple_targets = (function fulcro$client$impl$data_targeting$multiple_targets(var_args){
var args__4736__auto__ = [];
var len__4730__auto___54982 = arguments.length;
var i__4731__auto___54987 = (0);
while(true){
if((i__4731__auto___54987 < len__4730__auto___54982)){
args__4736__auto__.push((arguments[i__4731__auto___54987]));

var G__54990 = (i__4731__auto___54987 + (1));
i__4731__auto___54987 = G__54990;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.impl.data_targeting.multiple_targets.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.impl.data_targeting.multiple_targets.cljs$core$IFn$_invoke$arity$variadic = (function (targets){
return cljs.core.with_meta.call(null,cljs.core.vec.call(null,targets),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.client.impl.data-targeting","multiple-targets","fulcro.client.impl.data-targeting/multiple-targets",-1232076818),true], null));
});

fulcro.client.impl.data_targeting.multiple_targets.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.impl.data_targeting.multiple_targets.cljs$lang$applyTo = (function (seq54874){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq54874));
});

fulcro.client.impl.data_targeting.prepend_to = (function fulcro$client$impl$data_targeting$prepend_to(target){
return cljs.core.with_meta.call(null,target,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.client.impl.data-targeting","prepend-target","fulcro.client.impl.data-targeting/prepend-target",1888238952),true], null));
});
fulcro.client.impl.data_targeting.append_to = (function fulcro$client$impl$data_targeting$append_to(target){
return cljs.core.with_meta.call(null,target,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.client.impl.data-targeting","append-target","fulcro.client.impl.data-targeting/append-target",-1598475575),true], null));
});
fulcro.client.impl.data_targeting.replace_at = (function fulcro$client$impl$data_targeting$replace_at(target){
return cljs.core.with_meta.call(null,target,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.client.impl.data-targeting","replace-target","fulcro.client.impl.data-targeting/replace-target",-252896082),true], null));
});
fulcro.client.impl.data_targeting.replacement_target_QMARK_ = (function fulcro$client$impl$data_targeting$replacement_target_QMARK_(t){
return cljs.core.boolean$.call(null,new cljs.core.Keyword("fulcro.client.impl.data-targeting","replace-target","fulcro.client.impl.data-targeting/replace-target",-252896082).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,t)));
});
fulcro.client.impl.data_targeting.prepend_target_QMARK_ = (function fulcro$client$impl$data_targeting$prepend_target_QMARK_(t){
return cljs.core.boolean$.call(null,new cljs.core.Keyword("fulcro.client.impl.data-targeting","prepend-target","fulcro.client.impl.data-targeting/prepend-target",1888238952).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,t)));
});
fulcro.client.impl.data_targeting.append_target_QMARK_ = (function fulcro$client$impl$data_targeting$append_target_QMARK_(t){
return cljs.core.boolean$.call(null,new cljs.core.Keyword("fulcro.client.impl.data-targeting","append-target","fulcro.client.impl.data-targeting/append-target",-1598475575).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,t)));
});
fulcro.client.impl.data_targeting.multiple_targets_QMARK_ = (function fulcro$client$impl$data_targeting$multiple_targets_QMARK_(t){
return cljs.core.boolean$.call(null,new cljs.core.Keyword("fulcro.client.impl.data-targeting","multiple-targets","fulcro.client.impl.data-targeting/multiple-targets",-1232076818).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,t)));
});
fulcro.client.impl.data_targeting.special_target_QMARK_ = (function fulcro$client$impl$data_targeting$special_target_QMARK_(target){
return cljs.core.boolean$.call(null,cljs.core.seq.call(null,clojure.set.intersection.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.meta.call(null,target))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fulcro.client.impl.data-targeting","prepend-target","fulcro.client.impl.data-targeting/prepend-target",1888238952),null,new cljs.core.Keyword("fulcro.client.impl.data-targeting","append-target","fulcro.client.impl.data-targeting/append-target",-1598475575),null,new cljs.core.Keyword("fulcro.client.impl.data-targeting","replace-target","fulcro.client.impl.data-targeting/replace-target",-252896082),null,new cljs.core.Keyword("fulcro.client.impl.data-targeting","multiple-targets","fulcro.client.impl.data-targeting/multiple-targets",-1232076818),null], null), null))));
});
/**
 * Integrate an ident into any number of places in the app state. This function is safe to use within mutation
 *   implementations as a general helper function.
 * 
 *   The named parameters can be specified any number of times. They are:
 * 
 *   - append:  A vector (path) to a list in your app state where this new object's ident should be appended. Will not append
 *   the ident if that ident is already in the list.
 *   - prepend: A vector (path) to a list in your app state where this new object's ident should be prepended. Will not append
 *   the ident if that ident is already in the list.
 *   - replace: A vector (path) to a specific location in app-state where this object's ident should be placed. Can target a to-one or to-many.
 * If the target is a vector element then that element must already exist in the vector.
 */
fulcro.client.impl.data_targeting.integrate_ident = (function fulcro$client$impl$data_targeting$integrate_ident(var_args){
var args__4736__auto__ = [];
var len__4730__auto___55024 = arguments.length;
var i__4731__auto___55025 = (0);
while(true){
if((i__4731__auto___55025 < len__4730__auto___55024)){
args__4736__auto__.push((arguments[i__4731__auto___55025]));

var G__55030 = (i__4731__auto___55025 + (1));
i__4731__auto___55025 = G__55030;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.client.impl.data_targeting.integrate_ident.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.client.impl.data_targeting.integrate_ident.cljs$core$IFn$_invoke$arity$variadic = (function (state,ident,named_parameters){
if(cljs.core.map_QMARK_.call(null,state)){
} else {
throw (new Error("Assert failed: (map? state)"));
}

var actions = cljs.core.partition.call(null,(2),named_parameters);
return cljs.core.reduce.call(null,((function (actions){
return (function (state__$1,p__54930){
var vec__54931 = p__54930;
var command = cljs.core.nth.call(null,vec__54931,(0),null);
var data_path = cljs.core.nth.call(null,vec__54931,(1),null);
var already_has_ident_at_path_QMARK_ = ((function (vec__54931,command,data_path,actions){
return (function (data_path__$1){
return cljs.core.some.call(null,((function (vec__54931,command,data_path,actions){
return (function (p1__54918_SHARP_){
return cljs.core._EQ_.call(null,p1__54918_SHARP_,ident);
});})(vec__54931,command,data_path,actions))
,cljs.core.get_in.call(null,state__$1,data_path__$1));
});})(vec__54931,command,data_path,actions))
;
var G__54934 = command;
var G__54934__$1 = (((G__54934 instanceof cljs.core.Keyword))?G__54934.fqn:null);
switch (G__54934__$1) {
case "prepend":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_(data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for prepend must target an app-state vector."].join(''),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,((function (G__54934,G__54934__$1,already_has_ident_at_path_QMARK_,vec__54931,command,data_path,actions){
return (function (p1__54920_SHARP_){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ident], null),p1__54920_SHARP_);
});})(G__54934,G__54934__$1,already_has_ident_at_path_QMARK_,vec__54931,command,data_path,actions))
);
}

break;
case "append":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_(data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for append must target an app-state vector."].join(''),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,cljs.core.conj,ident);
}

break;
case "replace":
var path_to_vector = cljs.core.butlast.call(null,data_path);
var to_many_QMARK_ = ((cljs.core.seq.call(null,path_to_vector)) && (cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,path_to_vector))));
var index = cljs.core.last.call(null,data_path);
var vector = cljs.core.get_in.call(null,state__$1,path_to_vector);
if(cljs.core.vector_QMARK_.call(null,data_path)){
} else {
throw (new Error(["Assert failed: ",["Replacement path must be a vector. You passed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)].join(''),"\n","(vector? data-path)"].join('')));
}

if(to_many_QMARK_){
if(cljs.core.vector_QMARK_.call(null,vector)){
} else {
throw (new Error(["Assert failed: ","Path for replacement must be a vector","\n","(vector? vector)"].join('')));
}

if(typeof index === 'number'){
} else {
throw (new Error(["Assert failed: ","Path for replacement must end in a vector index","\n","(number? index)"].join('')));
}

if(cljs.core.contains_QMARK_.call(null,vector,index)){
} else {
throw (new Error(["Assert failed: ",["Target vector for replacement does not have an item at index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index)].join(''),"\n","(contains? vector index)"].join('')));
}
} else {
}

return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
default:
throw cljs.core.ex_info.call(null,"Unknown post-op to merge-state!: ",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),command,new cljs.core.Keyword(null,"arg","arg",-1747261837),data_path], null));

}
});})(actions))
,state,actions);
});

fulcro.client.impl.data_targeting.integrate_ident.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.client.impl.data_targeting.integrate_ident.cljs$lang$applyTo = (function (seq54923){
var G__54924 = cljs.core.first.call(null,seq54923);
var seq54923__$1 = cljs.core.next.call(null,seq54923);
var G__54925 = cljs.core.first.call(null,seq54923__$1);
var seq54923__$2 = cljs.core.next.call(null,seq54923__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54924,G__54925,seq54923__$2);
});

fulcro.client.impl.data_targeting.process_target = (function fulcro$client$impl$data_targeting$process_target(var_args){
var G__54950 = arguments.length;
switch (G__54950) {
case 3:
return fulcro.client.impl.data_targeting.process_target.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fulcro.client.impl.data_targeting.process_target.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_targeting.process_target.cljs$core$IFn$_invoke$arity$3 = (function (state,source_path,target){
return fulcro.client.impl.data_targeting.process_target.call(null,state,source_path,target,true);
});

fulcro.client.impl.data_targeting.process_target.cljs$core$IFn$_invoke$arity$4 = (function (state,source_path,target,remove_ok_QMARK_){
if(cljs.core.vector_QMARK_.call(null,target)){
} else {
throw (new Error("Assert failed: (vector? target)"));
}

var item_to_place = ((fulcro.util.ident_QMARK_.call(null,source_path))?source_path:(((source_path instanceof cljs.core.Keyword))?cljs.core.get.call(null,state,source_path):cljs.core.get_in.call(null,state,source_path)
));
var many_idents_QMARK_ = ((cljs.core.vector_QMARK_.call(null,item_to_place)) && (cljs.core.every_QMARK_.call(null,fulcro.util.ident_QMARK_,item_to_place)));
if(((fulcro.util.ident_QMARK_.call(null,source_path)) && ((!(fulcro.client.impl.data_targeting.special_target_QMARK_.call(null,target)))))){
return cljs.core.assoc_in.call(null,state,target,item_to_place);
} else {
if((!(fulcro.client.impl.data_targeting.special_target_QMARK_.call(null,target)))){
var G__54969 = cljs.core.assoc_in.call(null,state,target,item_to_place);
if(cljs.core.truth_(remove_ok_QMARK_)){
return cljs.core.dissoc.call(null,G__54969,source_path);
} else {
return G__54969;
}
} else {
if(fulcro.client.impl.data_targeting.multiple_targets_QMARK_.call(null,target)){
var G__54970 = cljs.core.reduce.call(null,((function (item_to_place,many_idents_QMARK_){
return (function (s,t){
return fulcro.client.impl.data_targeting.process_target.call(null,s,source_path,t,false);
});})(item_to_place,many_idents_QMARK_))
,state,target);
if(cljs.core.truth_((function (){var and__4120__auto__ = (!(fulcro.util.ident_QMARK_.call(null,source_path)));
if(and__4120__auto__){
return remove_ok_QMARK_;
} else {
return and__4120__auto__;
}
})())){
return cljs.core.dissoc.call(null,G__54970,source_path);
} else {
return G__54970;
}
} else {
if(((many_idents_QMARK_) && (fulcro.client.impl.data_targeting.special_target_QMARK_.call(null,target)))){
var state__$1 = (cljs.core.truth_(remove_ok_QMARK_)?cljs.core.dissoc.call(null,state,source_path):state);
var target_has_many_QMARK_ = cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,target));
if(target_has_many_QMARK_){
if(fulcro.client.impl.data_targeting.prepend_target_QMARK_.call(null,target)){
return cljs.core.update_in.call(null,state__$1,target,((function (state__$1,target_has_many_QMARK_,item_to_place,many_idents_QMARK_){
return (function (v){
return cljs.core.vec.call(null,cljs.core.concat.call(null,item_to_place,v));
});})(state__$1,target_has_many_QMARK_,item_to_place,many_idents_QMARK_))
);
} else {
if(fulcro.client.impl.data_targeting.append_target_QMARK_.call(null,target)){
return cljs.core.update_in.call(null,state__$1,target,((function (state__$1,target_has_many_QMARK_,item_to_place,many_idents_QMARK_){
return (function (v){
return cljs.core.vec.call(null,cljs.core.concat.call(null,v,item_to_place));
});})(state__$1,target_has_many_QMARK_,item_to_place,many_idents_QMARK_))
);
} else {
return state__$1;

}
}
} else {
return cljs.core.assoc_in.call(null,state__$1,target,item_to_place);
}
} else {
if(fulcro.client.impl.data_targeting.special_target_QMARK_.call(null,target)){
var G__54973 = state;
var G__54973__$1 = (cljs.core.truth_(remove_ok_QMARK_)?cljs.core.dissoc.call(null,G__54973,source_path):G__54973);
var G__54973__$2 = ((fulcro.client.impl.data_targeting.prepend_target_QMARK_.call(null,target))?fulcro.client.impl.data_targeting.integrate_ident.call(null,G__54973__$1,item_to_place,new cljs.core.Keyword(null,"prepend","prepend",342616040),target):G__54973__$1);
var G__54973__$3 = ((fulcro.client.impl.data_targeting.append_target_QMARK_.call(null,target))?fulcro.client.impl.data_targeting.integrate_ident.call(null,G__54973__$2,item_to_place,new cljs.core.Keyword(null,"append","append",-291298229),target):G__54973__$2);
if(fulcro.client.impl.data_targeting.replacement_target_QMARK_.call(null,target)){
return fulcro.client.impl.data_targeting.integrate_ident.call(null,G__54973__$3,item_to_place,new cljs.core.Keyword(null,"replace","replace",-786587770),target);
} else {
return G__54973__$3;
}
} else {
return state;

}
}
}
}
}
});

fulcro.client.impl.data_targeting.process_target.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=fulcro.client.impl.data_targeting.js.map
