goog.provide('fulcro.incubator.pessimistic_mutations');
goog.require('cljs.core');
goog.require('fulcro.incubator.db_helpers');
goog.require('fulcro.incubator.mutation_interface');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.primitives');
goog.require('fulcro.client.impl.data_targeting');
goog.require('fulcro.logging');
goog.require('cljs.spec.alpha');
goog.require('fulcro.client.data_fetch');
goog.require('clojure.set');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.client.data-fetch","target","fulcro.client.data-fetch/target",-970395030),new cljs.core.Keyword("fulcro.client.data-fetch","target","fulcro.client.data-fetch/target",-970395030));
fulcro.incubator.pessimistic_mutations.error_states = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"network-error","network-error",-1095989517),null,new cljs.core.Keyword(null,"api-error","api-error",1506636439),null], null), null);
/**
 * You must call this function in the remote of mutations that are used with `pmutate!`.
 * 
 *   (defmutation x [_]
 *  (remote [env] (pessimistic-remote env)))
 * 
 *   NOTES: You *must not* compose this with Fulcro's `returning` or `with-target`.
 *   You should instead use the special keys of `pmutate`'s params.
 *   
 */
fulcro.incubator.pessimistic_mutations.pessimistic_mutation = (function fulcro$incubator$pessimistic_mutations$pessimistic_mutation(p__71593){
var map__71594 = p__71593;
var map__71594__$1 = (((((!((map__71594 == null))))?(((((map__71594.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71594.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71594):map__71594);
var ast = cljs.core.get.call(null,map__71594__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var ref = cljs.core.get.call(null,map__71594__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
if(cljs.core.truth_(new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(ast))){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),34], null),new cljs.core.Keyword(null,"error","error",-978969032),"You should not use mutation joins (returning) with `pmutate!`. Use the params of `pmutate!` instead.");
}catch (e71600){if((e71600 instanceof Error)){
var e__54502__auto___71938 = e71600;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),34], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___71938);
} else {
throw e71600;

}
}} else {
}

var G__71601 = ast;
var G__71601__$1 = (((G__71601 == null))?null:cljs.core.update.call(null,G__71601,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.dissoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751)));
var G__71601__$2 = (((G__71601__$1 == null))?null:(function (){var G__71612 = G__71601__$1;
if(cljs.core.truth_(new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.core.update.call(null,G__71612,new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.vary_meta,cljs.core.dissoc,new cljs.core.Keyword(null,"component","component",1555936782));
} else {
return G__71612;
}
})());
var G__71601__$3 = (((G__71601__$2 == null))?null:fulcro.client.mutations.with_target.call(null,G__71601__$2,cljs.core.conj.call(null,ref,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response-swap","fulcro.incubator.pessimistic-mutations/mutation-response-swap",1253597395))));
if((G__71601__$3 == null)){
return null;
} else {
return cljs.core.vary_meta.call(null,G__71601__$3,cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","pessimistic-mutation","fulcro.incubator.pessimistic-mutations/pessimistic-mutation",-1513404197),true);
}
});
fulcro.incubator.pessimistic_mutations.pessimistic_mutation_QMARK_ = (function fulcro$incubator$pessimistic_mutations$pessimistic_mutation_QMARK_(ast){
return new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","pessimistic-mutation","fulcro.incubator.pessimistic-mutations/pessimistic-mutation",-1513404197).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,ast));
});
/**
 * Retrieves the mutation response from `this-or-props` (a component or props).  Can also be used against the state-map with an ident.
 */
fulcro.incubator.pessimistic_mutations.mutation_response = (function fulcro$incubator$pessimistic_mutations$mutation_response(var_args){
var G__71619 = arguments.length;
switch (G__71619) {
case 1:
return fulcro.incubator.pessimistic_mutations.mutation_response.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.incubator.pessimistic_mutations.mutation_response.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.pessimistic_mutations.mutation_response.cljs$core$IFn$_invoke$arity$1 = (function (this_or_props){
if(fulcro.client.primitives.component_QMARK_.call(null,this_or_props)){
return fulcro.incubator.pessimistic_mutations.mutation_response.call(null,cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,fulcro.client.primitives.get_reconciler.call(null,this_or_props))),fulcro.client.primitives.props.call(null,this_or_props));
} else {
return new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855).cljs$core$IFn$_invoke$arity$1(this_or_props);
}
});

fulcro.incubator.pessimistic_mutations.mutation_response.cljs$core$IFn$_invoke$arity$2 = (function (state,props){
var response = new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855).cljs$core$IFn$_invoke$arity$1(props);
if(fulcro.util.ident_QMARK_.call(null,response)){
return cljs.core.get_in.call(null,state,response);
} else {
return response;
}
});

fulcro.incubator.pessimistic_mutations.mutation_response.cljs$lang$maxFixedArity = 2;

fulcro.incubator.pessimistic_mutations.mutation_status = (function fulcro$incubator$pessimistic_mutations$mutation_status(var_args){
var G__71653 = arguments.length;
switch (G__71653) {
case 2:
return fulcro.incubator.pessimistic_mutations.mutation_status.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return fulcro.incubator.pessimistic_mutations.mutation_status.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.pessimistic_mutations.mutation_status.cljs$core$IFn$_invoke$arity$2 = (function (state,props){
var response = fulcro.incubator.pessimistic_mutations.mutation_response.call(null,state,props);
return new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","status","fulcro.incubator.pessimistic-mutations/status",2061120387).cljs$core$IFn$_invoke$arity$1(response);
});

fulcro.incubator.pessimistic_mutations.mutation_status.cljs$core$IFn$_invoke$arity$1 = (function (this$){
return new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","status","fulcro.incubator.pessimistic-mutations/status",2061120387).cljs$core$IFn$_invoke$arity$1(fulcro.incubator.pessimistic_mutations.mutation_response.call(null,this$));
});

fulcro.incubator.pessimistic_mutations.mutation_status.cljs$lang$maxFixedArity = 2;

/**
 * Checks this props of `this` component to see if a mutation is in progress.
 */
fulcro.incubator.pessimistic_mutations.mutation_loading_QMARK_ = (function fulcro$incubator$pessimistic_mutations$mutation_loading_QMARK_(this$){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"loading","loading",-737050189),fulcro.incubator.pessimistic_mutations.mutation_status.call(null,this$));
});
/**
 * Is the mutation in error. This is detected by looking for ::mutation-errors in the ::mutation-response (map) returned by the mutation.
 */
fulcro.incubator.pessimistic_mutations.mutation_error_QMARK_ = (function fulcro$incubator$pessimistic_mutations$mutation_error_QMARK_(var_args){
var G__71682 = arguments.length;
switch (G__71682) {
case 1:
return fulcro.incubator.pessimistic_mutations.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.incubator.pessimistic_mutations.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.pessimistic_mutations.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (this$){
return cljs.core.contains_QMARK_.call(null,fulcro.incubator.pessimistic_mutations.error_states,fulcro.incubator.pessimistic_mutations.mutation_status.call(null,this$));
});

fulcro.incubator.pessimistic_mutations.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (state,props){
return cljs.core.contains_QMARK_.call(null,fulcro.incubator.pessimistic_mutations.error_states,fulcro.incubator.pessimistic_mutations.mutation_status.call(null,state,props));
});

fulcro.incubator.pessimistic_mutations.mutation_error_QMARK_.cljs$lang$maxFixedArity = 2;

/**
 * Runs the side-effect-free multimethod for the given (client) mutation and returns a map describing the mutation:
 * 
 *   {:action (fn [env] ...)
 * :remote ...}
 */
fulcro.incubator.pessimistic_mutations.get_mutation = (function fulcro$incubator$pessimistic_mutations$get_mutation(env,k,p){
try{var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.methods$.call(null,fulcro.client.mutations.mutate),k);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return m.call(null,env,k,p);
} else {
return null;
}
}catch (e71703){var e = e71703;
try{return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),84], null),new cljs.core.Keyword(null,"error","error",-978969032),"Unable to read mutation. Some features of pmutate! may fail.  You should check your remote(s) to make sure they tolerate an empty env.",e);
}catch (e71704){if((e71704 instanceof Error)){
var e__54502__auto__ = e71704;
return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),84], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto__);
} else {
throw e71704;

}
}}});
/**
 * Call a Fulcro client mutation action (defined on the multimethod fulcro.client.mutations/mutate). This
 *   runs the `action` (or `custom-action`) section of the mutation and returns its value.
 */
fulcro.incubator.pessimistic_mutations.call_mutation_action = (function fulcro$incubator$pessimistic_mutations$call_mutation_action(var_args){
var G__71728 = arguments.length;
switch (G__71728) {
case 4:
return fulcro.incubator.pessimistic_mutations.call_mutation_action.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return fulcro.incubator.pessimistic_mutations.call_mutation_action.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.pessimistic_mutations.call_mutation_action.cljs$core$IFn$_invoke$arity$4 = (function (custom_action,env,k,p){
var temp__5720__auto__ = cljs.core.get.call(null,fulcro.incubator.pessimistic_mutations.get_mutation.call(null,env,k,p),cljs.core.keyword.call(null,cljs.core.name.call(null,custom_action)));
if(cljs.core.truth_(temp__5720__auto__)){
var h = temp__5720__auto__;
return h.call(null);
} else {
return null;
}
});

fulcro.incubator.pessimistic_mutations.call_mutation_action.cljs$core$IFn$_invoke$arity$3 = (function (env,k,p){
return fulcro.incubator.pessimistic_mutations.call_mutation_action.call(null,new cljs.core.Keyword(null,"action","action",-811238024),env,k,p);
});

fulcro.incubator.pessimistic_mutations.call_mutation_action.cljs$lang$maxFixedArity = 4;

cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.pessimistic-mutations","mutation-network-error","fulcro.incubator.pessimistic-mutations/mutation-network-error",-2147006442,null),(function (fulcro_incoming_env,_,p__71751){
var map__71752 = p__71751;
var map__71752__$1 = (((((!((map__71752 == null))))?(((((map__71752.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71752.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71752):map__71752);
var p = map__71752__$1;
var error = cljs.core.get.call(null,map__71752__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var params = cljs.core.get.call(null,map__71752__$1,new cljs.core.Keyword(null,"params","params",710516235));
var ref = cljs.core.get.call(null,map__71752__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","ref","fulcro.incubator.pessimistic-mutations/ref",49312471));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__71752,map__71752__$1,p,error,params,ref){
return (function (){
var low_level_error_71975 = (function (){var G__71762 = error;
var G__71762__$1 = (((G__71762 == null))?null:cljs.core.first.call(null,G__71762));
var G__71762__$2 = (((G__71762__$1 == null))?null:cljs.core.second.call(null,G__71762__$1));
if((G__71762__$2 == null)){
return null;
} else {
return new cljs.core.Keyword("fulcro.client.primitives","error","fulcro.client.primitives/error",1510344092).cljs$core$IFn$_invoke$arity$1(G__71762__$2);
}
})();
var map__71761_71976 = params;
var map__71761_71977__$1 = (((((!((map__71761_71976 == null))))?(((((map__71761_71976.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71761_71976.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71761_71976):map__71761_71976);
var key_71978 = cljs.core.get.call(null,map__71761_71977__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571));
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"ref","ref",1289896967),ref),cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response-swap","fulcro.incubator.pessimistic-mutations/mutation-response-swap",1253597395),(function (){var G__71764 = cljs.core.dissoc.call(null,p,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","ref","fulcro.incubator.pessimistic-mutations/ref",49312471),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"params","params",710516235));
var G__71764__$1 = cljs.core.assoc.call(null,G__71764,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","status","fulcro.incubator.pessimistic-mutations/status",2061120387),new cljs.core.Keyword(null,"hard-error","hard-error",-2137644877))
;
var G__71764__$2 = (cljs.core.truth_(key_71978)?cljs.core.assoc.call(null,G__71764__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571),key_71978):G__71764__$1);
if(cljs.core.truth_(low_level_error_71975)){
return cljs.core.assoc.call(null,G__71764__$2,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","low-level-error","fulcro.incubator.pessimistic-mutations/low-level-error",-26278495),low_level_error_71975);
} else {
return G__71764__$2;
}
})());

return null;
});})(env,map__71752,map__71752__$1,p,error,params,ref))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.pessimistic-mutations","start-pmutation","fulcro.incubator.pessimistic-mutations/start-pmutation",-1741192983,null),(function (fulcro_incoming_env,_,p__71770){
var map__71771 = p__71770;
var map__71771__$1 = (((((!((map__71771 == null))))?(((((map__71771.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71771.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71771):map__71771);
var key = cljs.core.get.call(null,map__71771__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571));
var target = cljs.core.get.call(null,map__71771__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751));
return cljs.core.merge.call(null,(function (){var map__71775 = fulcro_incoming_env;
var map__71775__$1 = (((((!((map__71775 == null))))?(((((map__71775.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71775.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71775):map__71775);
var env = map__71775__$1;
var state = cljs.core.get.call(null,map__71775__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__71775,map__71775__$1,env,state,map__71771,map__71771__$1,key,target){
return (function (){
var loading_marker_72003 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","status","fulcro.incubator.pessimistic-mutations/status",2061120387),new cljs.core.Keyword(null,"loading","loading",-737050189),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571),key], null);
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","status","fulcro.incubator.pessimistic-mutations/status",2061120387),new cljs.core.Keyword(null,"loading","loading",-737050189),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571),key], null));

if((((!(fulcro.client.impl.data_targeting.multiple_targets_QMARK_.call(null,target)))) && (cljs.core.vector_QMARK_.call(null,target)) && (cljs.core.map_QMARK_.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,state),target))))){
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,cljs.core.conj.call(null,target,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855)),loading_marker_72003);
} else {
}

return null;
});})(map__71775,map__71775__$1,env,state,map__71771,map__71771__$1,key,target))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.pessimistic-mutations","finish-pmutation","fulcro.incubator.pessimistic-mutations/finish-pmutation",-1925945313,null),(function (fulcro_incoming_env,_,p__71801){
var map__71803 = p__71801;
var map__71803__$1 = (((((!((map__71803 == null))))?(((((map__71803.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71803.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71803):map__71803);
var mutation = cljs.core.get.call(null,map__71803__$1,new cljs.core.Keyword(null,"mutation","mutation",-285823378));
var params = cljs.core.get.call(null,map__71803__$1,new cljs.core.Keyword(null,"params","params",710516235));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__71803,map__71803__$1,mutation,params){
return (function (){
var map__71807 = env;
var map__71807__$1 = (((((!((map__71807 == null))))?(((((map__71807.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71807.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71807):map__71807);
var state = cljs.core.get.call(null,map__71807__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71807__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var reconciler = cljs.core.get.call(null,map__71807__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var map__71808 = params;
var map__71808__$1 = (((((!((map__71808 == null))))?(((((map__71808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71808.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71808):map__71808);
var key = cljs.core.get.call(null,map__71808__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571));
var target = cljs.core.get.call(null,map__71808__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751));
var returning = cljs.core.get.call(null,map__71808__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109));
var map__71809 = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ref);
var map__71809__$1 = (((((!((map__71809 == null))))?(((((map__71809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71809):map__71809);
var mutation_response_swap = cljs.core.get.call(null,map__71809__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response-swap","fulcro.incubator.pessimistic-mutations/mutation-response-swap",1253597395));
var map__71810 = mutation_response_swap;
var map__71810__$1 = (((((!((map__71810 == null))))?(((((map__71810.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71810.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71810):map__71810);
var status = cljs.core.get.call(null,map__71810__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","status","fulcro.incubator.pessimistic-mutations/status",2061120387));
var hard_error_QMARK_ = cljs.core._EQ_.call(null,status,new cljs.core.Keyword(null,"hard-error","hard-error",-2137644877));
var api_error_QMARK_ = cljs.core.contains_QMARK_.call(null,mutation_response_swap,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-errors","fulcro.incubator.pessimistic-mutations/mutation-errors",1134577147));
var had_error_QMARK_ = ((hard_error_QMARK_) || (api_error_QMARK_));
if(had_error_QMARK_){
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","status","fulcro.incubator.pessimistic-mutations/status",2061120387),new cljs.core.Keyword(null,"api-error","api-error",1506636439)], null),mutation_response_swap,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571),key], null)));

fulcro.incubator.pessimistic_mutations.call_mutation_action.call(null,new cljs.core.Keyword(null,"error-action","error-action",-1147840498),env,mutation,params);
} else {
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,((function (map__71807,map__71807__$1,state,ref,reconciler,map__71808,map__71808__$1,key,target,returning,map__71809,map__71809__$1,mutation_response_swap,map__71810,map__71810__$1,status,hard_error_QMARK_,api_error_QMARK_,had_error_QMARK_,env,map__71803,map__71803__$1,mutation,params){
return (function (s){
return cljs.core.assoc.call(null,cljs.core.dissoc.call(null,s,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response-swap","fulcro.incubator.pessimistic-mutations/mutation-response-swap",1253597395)),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855),cljs.core.merge.call(null,mutation_response_swap,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","key","fulcro.incubator.pessimistic-mutations/key",-72526571),key], null)));
});})(map__71807,map__71807__$1,state,ref,reconciler,map__71808,map__71808__$1,key,target,returning,map__71809,map__71809__$1,mutation_response_swap,map__71810,map__71810__$1,status,hard_error_QMARK_,api_error_QMARK_,had_error_QMARK_,env,map__71803,map__71803__$1,mutation,params))
);

if(cljs.core.truth_(returning)){
fulcro.client.primitives.merge_component_BANG_.call(null,reconciler,returning,mutation_response_swap);
} else {
}

if(cljs.core.truth_(target)){
var temp__5718__auto___72040 = (function (){var and__4120__auto__ = target;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = returning;
if(cljs.core.truth_(and__4120__auto____$1)){
return fulcro.client.primitives.get_ident.call(null,returning,mutation_response_swap);
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5718__auto___72040)){
var return_value_ident_72041 = temp__5718__auto___72040;
if((cljs.core.second.call(null,return_value_ident_72041) == null)){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),148], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Targeted value of type ",returning," did not generate a valid ident from the server return value: ",mutation_response_swap);
}catch (e71839){if((e71839 instanceof Error)){
var e__54502__auto___72042 = e71839;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),148], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto___72042);
} else {
throw e71839;

}
}} else {
}

cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env),fulcro.client.impl.data_targeting.process_target,return_value_ident_72041,target,false);
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env),fulcro.client.impl.data_targeting.process_target,cljs.core.conj.call(null,ref,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response-swap","fulcro.incubator.pessimistic-mutations/mutation-response-swap",1253597395)),target,false);
}

if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,target,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855))))){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,target,cljs.core.dissoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855));
} else {
}
} else {
}

fulcro.incubator.pessimistic_mutations.call_mutation_action.call(null,new cljs.core.Keyword(null,"ok-action","ok-action",1253795573),env,mutation,params);

fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.dissoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855));
}

return fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.dissoc,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response-swap","fulcro.incubator.pessimistic-mutations/mutation-response-swap",1253597395));
});})(env,map__71803,map__71803__$1,mutation,params))
], null);
})());
}));
fulcro.incubator.pessimistic_mutations.fake_env = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"parser","parser",-1543495310),cljs.core.constantly.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"ast","ast",-860334068),fulcro.client.primitives.query__GT_ast1.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"noop","noop",966800269,null))], null))], null);
fulcro.incubator.pessimistic_mutations.get_ident = (function fulcro$incubator$pessimistic_mutations$get_ident(c){
return fulcro.client.primitives.get_ident.call(null,c);
});
fulcro.incubator.pessimistic_mutations.pmutation__GT_ptransaction = (function fulcro$incubator$pessimistic_mutations$pmutation__GT_ptransaction(this$,mutation,params){
var mutation__$1 = fulcro.incubator.mutation_interface.mutation_symbol.call(null,mutation,params);
var declared_refresh = new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(fulcro.incubator.pessimistic_mutations.get_mutation.call(null,fulcro.incubator.pessimistic_mutations.fake_env,mutation__$1,params));
var base_tx = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.incubator.pessimistic-mutations","start-pmutation","fulcro.incubator.pessimistic-mutations/start-pmutation",-1741192983,null),null,(1),null)),(new cljs.core.List(null,params,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,(new cljs.core.List(null,mutation__$1,(new cljs.core.List(null,params,null,(1),null)),(2),null)),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.client.data-fetch","fallback","fulcro.client.data-fetch/fallback",1556791555,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"action","action",-811238024),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fulcro.incubator.pessimistic-mutations","mutation-network-error","fulcro.incubator.pessimistic-mutations/mutation-network-error",-2147006442,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"params","params",710516235),null,(1),null)),(new cljs.core.List(null,params,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","ref","fulcro.incubator.pessimistic-mutations/ref",49312471),null,(1),null)),(new cljs.core.List(null,fulcro.incubator.pessimistic_mutations.get_ident.call(null,this$),null,(1),null)))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.incubator.pessimistic-mutations","finish-pmutation","fulcro.incubator.pessimistic-mutations/finish-pmutation",-1925945313,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mutation","mutation",-285823378),mutation__$1,new cljs.core.Keyword(null,"params","params",710516235),params], null),null,(1),null))))),null,(1),null))))));
var tx = (function (){var G__71884 = base_tx;
if(cljs.core.vector_QMARK_.call(null,declared_refresh)){
return cljs.core.into.call(null,G__71884,declared_refresh);
} else {
return G__71884;
}
})();
return tx;
});
/**
 * Run a pmutation defined by `defpmutation`.
 * 
 *   this - The component whose ident will be used for status reporting on the progress of the mutation.
 *   mutation - The symbol of the mutation you want to run OR the mutation declaration name (using mutation-interface).
 *   params - The parameter map for the mutation.
 * 
 *   The following special keys can be included in `params` to augment how it works:
 * 
 *   - `::pm/key any-value` -
 *  This k/v pair will be in included in the ::mutation-response at all times. This allows you to distinguish
 *  among components that share an ident (e.g. one component causes a mutation error, but all with that ident update).
 *   - `::pm/target - The target for the mutation response (identical to `data-fetch/load`'s target parameter, including support
 *   for multiple).
 *   - `::pm/returning` - The component class of the return type, for normalization. If not specified then target will
 *   not be honored and no merge of the response will remain (only detect loading/errors of mutation).
 *   
 */
fulcro.incubator.pessimistic_mutations.pmutate_BANG_ = (function fulcro$incubator$pessimistic_mutations$pmutate_BANG_(this$,mutation,params){
var tx = fulcro.incubator.pessimistic_mutations.pmutation__GT_ptransaction.call(null,this$,mutation,params);
return fulcro.client.primitives.ptransact_BANG_.call(null,this$,tx);
});
/**
 * Returns true if the given mutation (symbol or mutation declaration) has a signature that looks like a pmutation. That
 *   is to say it has an `ok-action` or `error-action` or returns `pessimistic-mutation` from one of its remotes. This function
 *   will issue a warning if the given mutation uses extended actions, but *fails* to return the proper `pessimistic-mutation`
 *   as well.
 */
fulcro.incubator.pessimistic_mutations.pmutation_QMARK_ = (function fulcro$incubator$pessimistic_mutations$pmutation_QMARK_(legal_remotes,mutation,params){
var mutation__$1 = fulcro.incubator.mutation_interface.mutation_symbol.call(null,mutation,params);
var special_actions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error-action","error-action",-1147840498),null,new cljs.core.Keyword(null,"ok-action","ok-action",1253795573),null], null), null);
var mutation_map = fulcro.incubator.pessimistic_mutations.get_mutation.call(null,fulcro.incubator.pessimistic_mutations.fake_env,mutation__$1,params);
var pactions_QMARK_ = clojure.set.subset_QMARK_.call(null,cljs.core.keys.call(null,mutation_map),special_actions);
var premote_QMARK_ = cljs.core.boolean$.call(null,cljs.core.some.call(null,((function (mutation__$1,special_actions,mutation_map,pactions_QMARK_){
return (function (remote){
return fulcro.incubator.pessimistic_mutations.pessimistic_mutation_QMARK_.call(null,cljs.core.get.call(null,mutation_map,remote));
});})(mutation__$1,special_actions,mutation_map,pactions_QMARK_))
,legal_remotes));
if(((pactions_QMARK_) && ((!(premote_QMARK_))))){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),210], null),new cljs.core.Keyword(null,"error","error",-978969032),["ERROR: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(mutation__$1),"has an ok-action or error-action, but does *not* use `pessimistic-mutation` on any remote."].join(''));
}catch (e71900){if((e71900 instanceof Error)){
var e__54502__auto___72081 = e71900;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.pessimistic-mutations",new cljs.core.Keyword(null,"line","line",212345235),210], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___72081);
} else {
throw e71900;

}
}} else {
}

return premote_QMARK_;
});
/**
 * Convert a tx that is a mix of normal mutations and pmutations into a tx that can be safely run with fulcro.primitives/ptransact!
 */
fulcro.incubator.pessimistic_mutations.mixed_tx__GT_ptransaction = (function fulcro$incubator$pessimistic_mutations$mixed_tx__GT_ptransaction(this$,tx){
var reconciler = fulcro.client.primitives.get_reconciler.call(null,this$);
var legal_remotes = (function (){var G__71910 = reconciler;
var G__71910__$1 = (((G__71910 == null))?null:new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__71910));
var G__71910__$2 = (((G__71910__$1 == null))?null:new cljs.core.Keyword(null,"remotes","remotes",1132366312).cljs$core$IFn$_invoke$arity$1(G__71910__$1));
if((G__71910__$2 == null)){
return null;
} else {
return cljs.core.set.call(null,G__71910__$2);
}
})();
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.mapcat.call(null,((function (reconciler,legal_remotes){
return (function (element){
var vec__71913 = ((cljs.core.list_QMARK_.call(null,element))?element:null);
var msym = cljs.core.nth.call(null,vec__71913,(0),null);
var params = cljs.core.nth.call(null,vec__71913,(1),null);
if(fulcro.incubator.pessimistic_mutations.pmutation_QMARK_.call(null,legal_remotes,msym,params)){
return fulcro.incubator.pessimistic_mutations.pmutation__GT_ptransaction.call(null,this$,msym,params);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [element], null);
}
});})(reconciler,legal_remotes))
),tx);
});
/**
 * Just like Fulcro `ptransact!`, except it auto-detects `pmutate!` mutations and expands them to the proper form, allowing
 *   you to compose any kind of mutation together into a single, functioning transaction:
 * 
 *   ```
 *   (pi/ptransact! this `[(local-mutation) (normal-remote-mutation) (pmutate-mutation) (local-mutation)])
 *   ```
 *   
 */
fulcro.incubator.pessimistic_mutations.ptransact_BANG_ = (function fulcro$incubator$pessimistic_mutations$ptransact_BANG_(var_args){
var G__71921 = arguments.length;
switch (G__71921) {
case 3:
return fulcro.incubator.pessimistic_mutations.ptransact_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return fulcro.incubator.pessimistic_mutations.ptransact_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.pessimistic_mutations.ptransact_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,ref,tx){
return fulcro.client.primitives.ptransact_BANG_.call(null,this$,ref,fulcro.incubator.pessimistic_mutations.mixed_tx__GT_ptransaction.call(null,this$,tx));
});

fulcro.incubator.pessimistic_mutations.ptransact_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,tx){
return fulcro.client.primitives.ptransact_BANG_.call(null,this$,fulcro.incubator.pessimistic_mutations.mixed_tx__GT_ptransaction.call(null,this$,tx));
});

fulcro.incubator.pessimistic_mutations.ptransact_BANG_.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=fulcro.incubator.pessimistic_mutations.js.map
