goog.provide('nubank.workspaces.ui.cursor');
goog.require('cljs.core');
goog.require('fulcro.client.primitives');
goog.require('fulcro.client.localized_dom');
goog.require('nubank.workspaces.ui.events');
goog.require('goog.object');
nubank.workspaces.ui.cursor.get_nth = (function nubank$workspaces$ui$cursor$get_nth(i,s){
return cljs.core.first.call(null,cljs.core.drop.call(null,i,s));
});
nubank.workspaces.ui.cursor.seq_prev = (function nubank$workspaces$ui$cursor$seq_prev(current,items){
var index = items.indexOf(current);
if(cljs.core._EQ_.call(null,(-1),index)){
return cljs.core.first.call(null,items);
} else {
var item_count = cljs.core.count.call(null,items);
var next_index = cljs.core.mod.call(null,((cljs.core._EQ_.call(null,(0),index))?(item_count - (1)):(index - (1))),item_count);
return nubank.workspaces.ui.cursor.get_nth.call(null,next_index,items);
}
});
nubank.workspaces.ui.cursor.seq_next = (function nubank$workspaces$ui$cursor$seq_next(current,items){
var selected_index = items.indexOf(current);
if(cljs.core._EQ_.call(null,(-1),selected_index)){
return cljs.core.first.call(null,items);
} else {
var item_count = cljs.core.count.call(null,items);
var next_index = cljs.core.mod.call(null,((cljs.core._EQ_.call(null,selected_index,(item_count - (1))))?(0):(selected_index + (1))),item_count);
return nubank.workspaces.ui.cursor.get_nth.call(null,next_index,items);
}
});
nubank.workspaces.ui.cursor.scroll_up = (function nubank$workspaces$ui$cursor$scroll_up(options,container,item){
if(cljs.core.truth_(item)){
if((!((((goog.object.get(container,"scrollTop") <= goog.object.get(item,"offsetTop"))) && ((goog.object.get(item,"offsetTop") <= (goog.object.get(container,"scrollTop") + goog.object.get(container,"offsetHeight")))))))){
if(cljs.core._EQ_.call(null,cljs.core.last.call(null,options),cljs.core.next)){
return goog.object.set(container,"scrollTop",goog.object.get(container,"scrollHeight"));
} else {
return goog.object.set(container,"scrollTop",goog.object.get(item,"offsetTop"));
}
} else {
return null;
}
} else {
return null;
}
});
nubank.workspaces.ui.cursor.scroll_down = (function nubank$workspaces$ui$cursor$scroll_down(options,container,item){
if(cljs.core.truth_(item)){
var item_bottom = (goog.object.get(item,"offsetTop") + goog.object.get(item,"scrollHeight"));
if((!((((goog.object.get(container,"scrollTop") <= item_bottom)) && ((item_bottom <= (goog.object.get(container,"scrollTop") + goog.object.get(container,"offsetHeight")))))))){
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,options),cljs.core.next)){
return goog.object.set(container,"scrollTop",(0));
} else {
return goog.object.set(container,"scrollTop",(item_bottom - goog.object.get(container,"offsetHeight")));
}
} else {
return null;
}
} else {
return null;
}
});
nubank.workspaces.ui.cursor.dom_props = (function nubank$workspaces$ui$cursor$dom_props(props){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.call(null,cljs.core.comp.call(null,cljs.core.namespace,cljs.core.first)),props);
});
if((typeof nubank !== 'undefined') && (typeof nubank.workspaces !== 'undefined') && (typeof nubank.workspaces.ui !== 'undefined') && (typeof nubank.workspaces.ui.cursor !== 'undefined') && (typeof nubank.workspaces.ui.cursor.VerticalCursor !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
nubank.workspaces.ui.cursor.VerticalCursor = (function nubank$workspaces$ui$cursor$VerticalCursor(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(nubank.workspaces.ui.cursor.VerticalCursor.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("nubank.workspaces.ui.cursor","VerticalCursor","nubank.workspaces.ui.cursor/VerticalCursor",-730196582),nubank.workspaces.ui.cursor.VerticalCursor);

var x71676_71843 = nubank.workspaces.ui.cursor.VerticalCursor.prototype;
x71676_71843.render = ((function (x71676_71843){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__71683 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__71684 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__71685 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__71686 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__71687 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__71688 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__71689 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__71690 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__71691 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__71692 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__71688;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__71689;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__71690;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__71691;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__71692;

try{var map__71696 = fulcro.client.primitives.props.call(null,this$);
var map__71696__$1 = (((((!((map__71696 == null))))?(((((map__71696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71696.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71696):map__71696);
var props = map__71696__$1;
var options = cljs.core.get.call(null,map__71696__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","options","nubank.workspaces.ui.cursor/options",-450932746));
var factory = cljs.core.get.call(null,map__71696__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","factory","nubank.workspaces.ui.cursor/factory",-385580505));
var on_change = cljs.core.get.call(null,map__71696__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","on-change","nubank.workspaces.ui.cursor/on-change",-265764398));
var on_select = cljs.core.get.call(null,map__71696__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","on-select","nubank.workspaces.ui.cursor/on-select",360128875));
var value__GT_key = cljs.core.get.call(null,map__71696__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","value->key","nubank.workspaces.ui.cursor/value->key",-977103990),cljs.core.pr_str);
return fulcro.client.localized_dom.div.call(null,new cljs.core.Keyword(null,".container",".container",-1441208944),nubank.workspaces.ui.cursor.dom_props.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"ref","ref",1289896967),((function (map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (p1__71652_SHARP_){
return goog.object.set(this$,"container",p1__71652_SHARP_);
});})(map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
)),nubank.workspaces.ui.events.dom_listener.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),"up",new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (e){
e.preventDefault();

var map__71713 = fulcro.client.primitives.props.call(null,this$);
var map__71713__$1 = (((((!((map__71713 == null))))?(((((map__71713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71713):map__71713);
var value = cljs.core.get.call(null,map__71713__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","value","nubank.workspaces.ui.cursor/value",-199258490));
var options__$1 = cljs.core.get.call(null,map__71713__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","options","nubank.workspaces.ui.cursor/options",-450932746));
var next = nubank.workspaces.ui.cursor.seq_prev.call(null,value,options__$1);
var container = goog.object.get(this$,"container");
var item = goog.object.get(this$,["item-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value__GT_key.call(null,next))].join(''));
if(cljs.core.truth_((function (){var and__4120__auto__ = container;
if(cljs.core.truth_(and__4120__auto__)){
return item;
} else {
return and__4120__auto__;
}
})())){
nubank.workspaces.ui.cursor.scroll_up.call(null,options__$1,container,item);

return on_change.call(null,next,e);
} else {
return null;
}
});})(map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
)),nubank.workspaces.ui.events.dom_listener.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),"down",new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (e){
e.preventDefault();

var map__71740 = fulcro.client.primitives.props.call(null,this$);
var map__71740__$1 = (((((!((map__71740 == null))))?(((((map__71740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71740):map__71740);
var value = cljs.core.get.call(null,map__71740__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","value","nubank.workspaces.ui.cursor/value",-199258490));
var options__$1 = cljs.core.get.call(null,map__71740__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","options","nubank.workspaces.ui.cursor/options",-450932746));
var next = nubank.workspaces.ui.cursor.seq_next.call(null,value,options__$1);
var container = goog.object.get(this$,"container");
var item = goog.object.get(this$,["item-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value__GT_key.call(null,next))].join(''));
if(cljs.core.truth_((function (){var and__4120__auto__ = container;
if(cljs.core.truth_(and__4120__auto__)){
return item;
} else {
return and__4120__auto__;
}
})())){
nubank.workspaces.ui.cursor.scroll_down.call(null,options__$1,container,item);

return on_change.call(null,next,e);
} else {
return null;
}
});})(map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
)),nubank.workspaces.ui.events.dom_listener.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),"return",new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (p1__71664_SHARP_){
return on_select.call(null,new cljs.core.Keyword("nubank.workspaces.ui.cursor","value","nubank.workspaces.ui.cursor/value",-199258490).cljs$core$IFn$_invoke$arity$1(fulcro.client.primitives.props.call(null,this$)),p1__71664_SHARP_);
});})(map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
)),nubank.workspaces.ui.events.dom_listener.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword("nubank.workspaces.ui.events","keystroke","nubank.workspaces.ui.events/keystroke",1034732647),"escape",new cljs.core.Keyword("nubank.workspaces.ui.events","action","nubank.workspaces.ui.events/action",-891512282),((function (map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (p1__71665_SHARP_){
return on_select.call(null,null,p1__71665_SHARP_);
});})(map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
)),(function (){var iter__4523__auto__ = ((function (map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function nubank$workspaces$ui$cursor$iter__71753(s__71754){
return (new cljs.core.LazySeq(null,((function (map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (){
var s__71754__$1 = s__71754;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__71754__$1);
if(temp__5720__auto__){
var s__71754__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__71754__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__71754__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__71756 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__71755 = (0);
while(true){
if((i__71755 < size__4522__auto__)){
var x = cljs.core._nth(c__4521__auto__,i__71755);
cljs.core.chunk_append.call(null,b__71756,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),value__GT_key.call(null,x),new cljs.core.Keyword(null,"ref","ref",1289896967),((function (i__71755,x,c__4521__auto__,size__4522__auto__,b__71756,s__71754__$2,temp__5720__auto__,map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (p1__71666_SHARP_){
return goog.object.set(this$,["item-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value__GT_key.call(null,x))].join(''),p1__71666_SHARP_);
});})(i__71755,x,c__4521__auto__,size__4522__auto__,b__71756,s__71754__$2,temp__5720__auto__,map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
], null),factory.call(null,x)));

var G__71908 = (i__71755 + (1));
i__71755 = G__71908;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__71756),nubank$workspaces$ui$cursor$iter__71753.call(null,cljs.core.chunk_rest.call(null,s__71754__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__71756),null);
}
} else {
var x = cljs.core.first.call(null,s__71754__$2);
return cljs.core.cons.call(null,fulcro.client.localized_dom.div.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),value__GT_key.call(null,x),new cljs.core.Keyword(null,"ref","ref",1289896967),((function (x,s__71754__$2,temp__5720__auto__,map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843){
return (function (p1__71666_SHARP_){
return goog.object.set(this$,["item-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value__GT_key.call(null,x))].join(''),p1__71666_SHARP_);
});})(x,s__71754__$2,temp__5720__auto__,map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
], null),factory.call(null,x)),nubank$workspaces$ui$cursor$iter__71753.call(null,cljs.core.rest.call(null,s__71754__$2)));
}
} else {
return null;
}
break;
}
});})(map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
,null,null));
});})(map__71696,map__71696__$1,props,options,factory,on_change,on_select,value__GT_key,_STAR_reconciler_STAR__orig_val__71683,_STAR_depth_STAR__orig_val__71684,_STAR_shared_STAR__orig_val__71685,_STAR_instrument_STAR__orig_val__71686,_STAR_parent_STAR__orig_val__71687,_STAR_reconciler_STAR__temp_val__71688,_STAR_depth_STAR__temp_val__71689,_STAR_shared_STAR__temp_val__71690,_STAR_instrument_STAR__temp_val__71691,_STAR_parent_STAR__temp_val__71692,this$,this__59535__auto__,x71676_71843))
;
return iter__4523__auto__(options);
})());
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__71687;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__71686;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__71685;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__71684;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__71683;
}});})(x71676_71843))
;

x71676_71843.componentDidMount = ((function (x71676_71843){
return (function (){
var this__59519__auto__ = this;
var this$ = this__59519__auto__;
var reconciler__59520__auto__ = fulcro.client.primitives.get_reconciler.call(null,this__59519__auto__);
var lifecycle__59521__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"lifecycle","lifecycle",341496205)], null));
var indexer__59522__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
goog.object.set(this__59519__auto__,"fulcro$mounted",true);

if((indexer__59522__auto__ == null)){
} else {
fulcro.client.impl.protocols.index_component_BANG_(indexer__59522__auto__,this__59519__auto__);
}

if(cljs.core.truth_(lifecycle__59521__auto__)){
lifecycle__59521__auto__.call(null,this__59519__auto__,new cljs.core.Keyword(null,"mount","mount",-1560582470));
} else {
}

var map__71774 = fulcro.client.primitives.props.call(null,this$);
var map__71774__$1 = (((((!((map__71774 == null))))?(((((map__71774.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71774.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71774):map__71774);
var options = cljs.core.get.call(null,map__71774__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","options","nubank.workspaces.ui.cursor/options",-450932746));
var value = cljs.core.get.call(null,map__71774__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","value","nubank.workspaces.ui.cursor/value",-199258490));
var value__GT_key = cljs.core.get.call(null,map__71774__$1,new cljs.core.Keyword("nubank.workspaces.ui.cursor","value->key","nubank.workspaces.ui.cursor/value->key",-977103990));
return nubank.workspaces.ui.cursor.scroll_down.call(null,options,goog.object.get(this$,"container"),goog.object.get(this$,["item-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value__GT_key.call(null,value))].join('')));
});})(x71676_71843))
;


nubank.workspaces.ui.cursor.VerticalCursor.prototype.constructor = nubank.workspaces.ui.cursor.VerticalCursor;

nubank.workspaces.ui.cursor.VerticalCursor.prototype.constructor.displayName = "nubank.workspaces.ui.cursor/VerticalCursor";

nubank.workspaces.ui.cursor.VerticalCursor.prototype.fulcro$isComponent = true;

var x71794_71925 = nubank.workspaces.ui.cursor.VerticalCursor;
x71794_71925.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x71794_71925.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x71794_71925){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null)], null)], null);
});})(x71794_71925))
;

x71794_71925.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x71794_71925){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x71794_71925))
;


var x71800_71931 = nubank.workspaces.ui.cursor.VerticalCursor.prototype;
x71800_71931.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x71800_71931.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x71800_71931){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,".container",".container",-1441208944),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null)], null)], null);
});})(x71800_71931))
;

x71800_71931.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x71800_71931){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x71800_71931))
;


nubank.workspaces.ui.cursor.VerticalCursor.cljs$lang$type = true;

nubank.workspaces.ui.cursor.VerticalCursor.cljs$lang$ctorStr = "nubank.workspaces.ui.cursor/VerticalCursor";

nubank.workspaces.ui.cursor.VerticalCursor.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"nubank.workspaces.ui.cursor/VerticalCursor");
});
nubank.workspaces.ui.cursor.vertical_cursor = fulcro.client.primitives.factory.call(null,nubank.workspaces.ui.cursor.VerticalCursor);

//# sourceMappingURL=nubank.workspaces.ui.cursor.js.map
