(ns com.wsscode.demos.meta
  (:require [com.fulcrologic.guardrails.core :refer [<- => >def >defn >fdef ? |]]
            [com.wsscode.pathom.core :as p]
            [com.wsscode.pathom.connect :as pc]))

(>def :repl.runtime/namespace symbol?)
(>def :repl.runtime/ns-aliases map?)
(>def :repl.runtime/ns-interns map?)

(>def :repl.runtime.sexp.symbol/alias-ns string?)
(>def :repl.runtime.sexp.symbol/name string?)
(>def :repl.runtime.sexp.symbol/fq-ns symbol?)
(>def :repl.runtime.sexp.symbol/symbol symbol?)
(>def :repl.runtime.sexp.symbol/fq-symbol symbol?)
(>def :repl.runtime.sexp.symbol/ns-interns symbol?)
(>def :repl.runtime.sexp.symbol/var var?)
(>def :repl.runtime.sexp.symbol/var-meta map?)
(>def :repl.runtime.sexp.symbol/meta-filename string?)

(pc/defresolver ns-aliases-resolver [{:repl.runtime/keys [namespace]}]
  {:repl.runtime/ns-aliases (ns-aliases namespace)})

(pc/defresolver ns-interns-resolver [{:repl.runtime/keys [namespace]}]
  {:repl.runtime/ns-interns (ns-interns namespace)})

(pc/defresolver sexp-symbol-alias-ns [{:repl.runtime.sexp.symbol/keys [symbol]}]
  {:repl.runtime.sexp.symbol/alias-ns (namespace symbol)})

(pc/defresolver sexp-symbol-name [{:repl.runtime.sexp.symbol/keys [symbol]}]
  {:repl.runtime.sexp.symbol/name (name symbol)})

(pc/defresolver sexp-symbol-namespace
  [{:repl.runtime.sexp.symbol/keys [alias-ns]
    :repl.runtime/keys             [ns-aliases]}]
  {:repl.runtime.sexp.symbol/fq-ns (symbol (str (get ns-aliases (symbol alias-ns))))})

(pc/defresolver sexp-ns-interns-resolver [{:repl.runtime.sexp.symbol/keys [fq-ns]}]
  {:repl.runtime.sexp.symbol/ns-interns (ns-interns fq-ns)})

(pc/defresolver sexp-fq-symbol [{:repl.runtime.sexp.symbol/keys [fq-ns name]}]
  {:repl.runtime.sexp.symbol/fq-symbol (symbol (str fq-ns) name)})

(pc/defresolver sexp-var-from-symbol [{:repl.runtime.sexp.symbol/keys [name ns-interns]}]
  {:repl.runtime.sexp.symbol/var (get ns-interns (symbol name))})

(pc/defresolver sexp-var-meta [{:repl.runtime.sexp.symbol/keys [var]}]
  {:repl.runtime.sexp.symbol/var-meta (meta var)})

(pc/defresolver meta-filename [{:repl.runtime.sexp.symbol/keys [var-meta]}]
  {:repl.runtime.sexp.symbol/meta-filename var-meta})

(def registry
  [ns-aliases-resolver
   ns-interns-resolver
   sexp-symbol-alias-ns
   sexp-symbol-name
   sexp-symbol-namespace
   sexp-ns-interns-resolver
   sexp-fq-symbol
   sexp-var-meta
   sexp-var-from-symbol
   meta-filename])

(def parser
  (p/parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/reader2
                                            pc/open-ident-reader
                                            p/env-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}}
     ::p/mutate  pc/mutate
     ::p/plugins [(pc/connect-plugin {::pc/register registry})
                  p/error-handler-plugin
                  p/trace-plugin]}))

(comment
  (parser {::p/entity (atom {:repl.runtime/namespace          'com.wsscode.demos.meta
                             :repl.runtime.sexp.symbol/symbol 'p/parser})}
    [:repl.runtime.sexp.symbol/var]))

