goog.provide('fulcro.history');
goog.require('cljs.core');
goog.require('fulcro.logging');
goog.require('fulcro.util');
goog.require('clojure.set');
goog.require('cljs.spec.alpha');
fulcro.history.is_timestamp_QMARK_ = (function fulcro$history$is_timestamp_QMARK_(t){
return (t instanceof Date);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),cljs.core.pos_int_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","client-time","fulcro.history/client-time",1879420278),new cljs.core.Symbol("fulcro.history","is-timestamp?","fulcro.history/is-timestamp?",-1658694055,null),fulcro.history.is_timestamp_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.vector_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),cljs.core.int_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","tx-result","fulcro.history/tx-result",-266551429),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"map","map",1371690461)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","network-sends","fulcro.history/network-sends",-234790789),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"vector?","vector?",-61367869,null)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.core.vector_QMARK_], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__54886){
return cljs.core.map_QMARK_.call(null,G__54886);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361),new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993),new cljs.core.Keyword("fulcro.history","tx-result","fulcro.history/tx-result",-266551429),new cljs.core.Keyword("fulcro.client.impl.data-fetch","network-result","fulcro.client.impl.data-fetch/network-result",183682473),new cljs.core.Keyword("fulcro.history","network-sends","fulcro.history/network-sends",-234790789),new cljs.core.Keyword("fulcro.history","client-time","fulcro.history/client-time",1879420278)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__54895){
return cljs.core.map_QMARK_.call(null,G__54895);
}),(function (G__54895){
return cljs.core.contains_QMARK_.call(null,G__54895,new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361));
}),(function (G__54895){
return cljs.core.contains_QMARK_.call(null,G__54895,new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365));
})], null),(function (G__54895){
return ((cljs.core.map_QMARK_.call(null,G__54895)) && (cljs.core.contains_QMARK_.call(null,G__54895,new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361))) && (cljs.core.contains_QMARK_.call(null,G__54895,new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365))));
}),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993),new cljs.core.Keyword("fulcro.history","tx-result","fulcro.history/tx-result",-266551429),new cljs.core.Keyword("fulcro.client.impl.data-fetch","network-result","fulcro.client.impl.data-fetch/network-result",183682473),new cljs.core.Keyword("fulcro.history","network-sends","fulcro.history/network-sends",-234790789),new cljs.core.Keyword("fulcro.history","client-time","fulcro.history/client-time",1879420278)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361),new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361),new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361),new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993),new cljs.core.Keyword("fulcro.history","tx-result","fulcro.history/tx-result",-266551429),new cljs.core.Keyword("fulcro.client.impl.data-fetch","network-result","fulcro.client.impl.data-fetch/network-result",183682473),new cljs.core.Keyword("fulcro.history","network-sends","fulcro.history/network-sends",-234790789),new cljs.core.Keyword("fulcro.history","client-time","fulcro.history/client-time",1879420278)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365)))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993),new cljs.core.Keyword("fulcro.history","tx-result","fulcro.history/tx-result",-266551429),new cljs.core.Keyword("fulcro.client.impl.data-fetch","network-result","fulcro.client.impl.data-fetch/network-result",183682473),new cljs.core.Keyword("fulcro.history","network-sends","fulcro.history/network-sends",-234790789),new cljs.core.Keyword("fulcro.history","client-time","fulcro.history/client-time",1879420278)], null)])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"int?","int?",1799729645,null),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.int_QMARK_,new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__54937){
return cljs.core.map_QMARK_.call(null,G__54937);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null))),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),cljs.core.list(new cljs.core.Symbol("s","map-of","s/map-of",-1464752791,null),new cljs.core.Symbol(null,"pos-int?","pos-int?",-1205815015,null),new cljs.core.Symbol(null,"pos-int?","pos-int?",-1205815015,null))),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"pos-int?","pos-int?",-1205815015,null),new cljs.core.Symbol(null,"pos-int?","pos-int?",-1205815015,null)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.pos_int_QMARK_,cljs.core.pos_int_QMARK_], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__54945){
return cljs.core.map_QMARK_.call(null,G__54945);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null))], null),null)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__54940){
return cljs.core.map_QMARK_.call(null,G__54940);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711)], null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187),new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__54959){
return cljs.core.map_QMARK_.call(null,G__54959);
}),(function (G__54959){
return cljs.core.contains_QMARK_.call(null,G__54959,new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187));
}),(function (G__54959){
return cljs.core.contains_QMARK_.call(null,G__54959,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620));
})], null),(function (G__54959){
return ((cljs.core.map_QMARK_.call(null,G__54959)) && (cljs.core.contains_QMARK_.call(null,G__54959,new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187))) && (cljs.core.contains_QMARK_.call(null,G__54959,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620))));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187),new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187),new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187),new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711)], null)])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.history","history-atom","fulcro.history/history-atom",-1250797564),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__55013#","p1__55013#",382619467,null)], null),cljs.core.list(new cljs.core.Symbol("fulcro.util","atom?","fulcro.util/atom?",-1021006071,null),new cljs.core.Symbol(null,"p1__55013#","p1__55013#",382619467,null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__55014#","p1__55014#",951312808,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","valid?","cljs.spec.alpha/valid?",-142132235,null),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.core.list(new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),new cljs.core.Symbol(null,"p1__55014#","p1__55014#",951312808,null))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("fulcro.util","atom?","fulcro.util/atom?",-1021006071,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","valid?","cljs.spec.alpha/valid?",-142132235,null),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.core.list(new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),new cljs.core.Symbol(null,"%","%",-950237169,null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p1__55013_SHARP_){
return fulcro.util.atom_QMARK_.call(null,p1__55013_SHARP_);
}),(function (p1__55014_SHARP_){
return cljs.spec.alpha.valid_QMARK_.call(null,new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.core.deref.call(null,p1__55014_SHARP_));
})], null),null));
fulcro.history.max_tx_time = (9200000000000000000);
fulcro.history.decrement_or_remove = (function fulcro$history$decrement_or_remove(m,k){
if(cljs.core._EQ_.call(null,(1),cljs.core.get.call(null,m,k,(1)))){
return cljs.core.dissoc.call(null,m,k);
} else {
return cljs.core.update.call(null,m,k,cljs.core.dec);
}
});
fulcro.history.add_or_increment = (function fulcro$history$add_or_increment(m,k){
return cljs.core.update.call(null,m,k,cljs.core.fnil.call(null,cljs.core.inc,(0)));
});
/**
 * Record that remote activity started for the given remote at the given tx-time. Returns a new history.
 */
fulcro.history.remote_activity_started = (function fulcro$history$remote_activity_started(history,remote,tx_time){
if(cljs.core.truth_((function (){var and__4120__auto__ = remote;
if(cljs.core.truth_(and__4120__auto__)){
return tx_time;
} else {
return and__4120__auto__;
}
})())){
return cljs.core.update_in.call(null,history,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711),remote], null),fulcro.history.add_or_increment,tx_time);
} else {
return history;
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","remote-activity-started","fulcro.history/remote-activity-started",2010207540,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"remote","remote",-1593576576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"remote","remote",-1593576576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"time","time",1385887882)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Keyword(null,"remote","remote",-1593576576)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,cljs.core.keyword_QMARK_], null),null),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"remote","remote",-1593576576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null,null));
/**
 * Record that remote activity finished for the given remote at the given tx-time. Returns a new history.
 */
fulcro.history.remote_activity_finished = (function fulcro$history$remote_activity_finished(history,remote,tx_time){
if(cljs.core.truth_((function (){var and__4120__auto__ = remote;
if(cljs.core.truth_(and__4120__auto__)){
return tx_time;
} else {
return and__4120__auto__;
}
})())){
return cljs.core.update_in.call(null,history,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711),remote], null),fulcro.history.decrement_or_remove,tx_time);
} else {
return history;
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","remote-activity-finished","fulcro.history/remote-activity-finished",-1247982384,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"remote","remote",-1593576576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"remote","remote",-1593576576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"time","time",1385887882)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Keyword(null,"remote","remote",-1593576576)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,cljs.core.keyword_QMARK_], null),null),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"remote","remote",-1593576576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null,null));
/**
 * Returns the tx time for the oldest in-flight send that is active. Returns Long/MAX_VALUE if none are active.
 */
fulcro.history.oldest_active_network_request = (function fulcro$history$oldest_active_network_request(p__55157){
var map__55158 = p__55157;
var map__55158__$1 = (((((!((map__55158 == null))))?(((((map__55158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55158.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55158):map__55158);
var history = map__55158__$1;
var active_remotes = cljs.core.get.call(null,map__55158__$1,new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711));
return cljs.core.reduce.call(null,cljs.core.min,fulcro.history.max_tx_time,cljs.core.apply.call(null,cljs.core.concat,(function (){var G__55166 = active_remotes;
var G__55166__$1 = (((G__55166 == null))?null:cljs.core.vals.call(null,G__55166));
if((G__55166__$1 == null)){
return null;
} else {
return cljs.core.map.call(null,cljs.core.keys,G__55166__$1);
}
})()));
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","oldest-active-network-request","fulcro.history/oldest-active-network-request",-1353768021,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),cljs.core.int_QMARK_,null,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),null,null,null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","oldest-active-network-request","fulcro.history/oldest-active-network-request",-1353768021,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));
/**
 * Returns a new history that has been reduced in size to target levels.
 */
fulcro.history.gc_history = (function fulcro$history$gc_history(p__55202){
var map__55204 = p__55202;
var map__55204__$1 = (((((!((map__55204 == null))))?(((((map__55204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55204.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55204):map__55204);
var history = map__55204__$1;
var max_size = cljs.core.get.call(null,map__55204__$1,new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187));
var history_steps = cljs.core.get.call(null,map__55204__$1,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620));
if(((cljs.core.pos_int_QMARK_.call(null,max_size)) && ((cljs.core.count.call(null,history_steps) > max_size)))){
var oldest_required_history_step = fulcro.history.oldest_active_network_request.call(null,history);
var current_size = cljs.core.count.call(null,history_steps);
var overage = (current_size - max_size);
var ordered_step_keys = cljs.core.sort.call(null,cljs.core.keys.call(null,history_steps));
var proposed_keeper_keys = cljs.core.drop.call(null,overage,ordered_step_keys);
var real_keeper_keys = (((cljs.core.first.call(null,proposed_keeper_keys) > oldest_required_history_step))?(function (){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.history",new cljs.core.Keyword(null,"line","line",212345235),82], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"History has grown beyond max size due to network congestion.");
}catch (e55217){if((e55217 instanceof Error)){
var e__54502__auto___55599 = e55217;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.history",new cljs.core.Keyword(null,"line","line",212345235),82], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto___55599);
} else {
throw e55217;

}
}
return cljs.core.drop_while.call(null,((function (oldest_required_history_step,current_size,overage,ordered_step_keys,proposed_keeper_keys,map__55204,map__55204__$1,history,max_size,history_steps){
return (function (t){
return (t < oldest_required_history_step);
});})(oldest_required_history_step,current_size,overage,ordered_step_keys,proposed_keeper_keys,map__55204,map__55204__$1,history,max_size,history_steps))
,ordered_step_keys);
})()
:proposed_keeper_keys);
return cljs.core.update.call(null,history,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620),cljs.core.select_keys,real_keeper_keys);
} else {
return history;
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","gc-history","fulcro.history/gc-history",1853772558,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));
fulcro.history.compressible_tx = (function fulcro$history$compressible_tx(tx){
return cljs.core.vary_meta.call(null,tx,cljs.core.assoc,new cljs.core.Keyword("fulcro.history","compressible?","fulcro.history/compressible?",1366178661),true);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","compressible-tx","fulcro.history/compressible-tx",-1033554138,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"tx","tx",466630418),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"tx","tx",466630418),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tx","tx",466630418)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Keyword(null,"tx","tx",466630418)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,cljs.core.vector_QMARK_], null),null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"tx","tx",466630418),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Keyword(null,"tx","tx",466630418)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,cljs.core.vector_QMARK_], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),null,null,null));
/**
 * Returns true if the given transaction is marked as compressible.
 */
fulcro.history.compressible_tx_QMARK_ = (function fulcro$history$compressible_tx_QMARK_(tx){
return cljs.core.boolean$.call(null,(function (){var G__55275 = tx;
var G__55275__$1 = (((G__55275 == null))?null:cljs.core.meta.call(null,G__55275));
if((G__55275__$1 == null)){
return null;
} else {
return new cljs.core.Keyword("fulcro.history","compressible?","fulcro.history/compressible?",1366178661).cljs$core$IFn$_invoke$arity$1(G__55275__$1);
}
})());
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","compressible-tx?","fulcro.history/compressible-tx?",836197026,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"tx","tx",466630418),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"tx","tx",466630418),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tx","tx",466630418)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Keyword(null,"tx","tx",466630418)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,cljs.core.vector_QMARK_], null),null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"tx","tx",466630418),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"missing","missing",362507769),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_,null,null),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),null,null,null));
/**
 * Returns the most recent transition edge time recorded in the given history.
 */
fulcro.history.last_tx_time = (function fulcro$history$last_tx_time(p__55298){
var map__55300 = p__55298;
var map__55300__$1 = (((((!((map__55300 == null))))?(((((map__55300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55300.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55300):map__55300);
var history = map__55300__$1;
var history_steps = cljs.core.get.call(null,map__55300__$1,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620));
return cljs.core.reduce.call(null,cljs.core.max,(0),cljs.core.keys.call(null,history_steps));
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","last-tx-time","fulcro.history/last-tx-time",-814635825,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),cljs.core.int_QMARK_,null,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),null,null,null));
/**
 * Record a history step in the reconciler. 
 */
fulcro.history.record_history_step = (function fulcro$history$record_history_step(p__55333,tx_time,p__55334){
var map__55335 = p__55333;
var map__55335__$1 = (((((!((map__55335 == null))))?(((((map__55335.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55335.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55335):map__55335);
var history = map__55335__$1;
var history_steps = cljs.core.get.call(null,map__55335__$1,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620));
var active_remotes = cljs.core.get.call(null,map__55335__$1,new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711));
var map__55336 = p__55334;
var map__55336__$1 = (((((!((map__55336 == null))))?(((((map__55336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55336.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55336):map__55336);
var step = map__55336__$1;
var tx = cljs.core.get.call(null,map__55336__$1,new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993));
var last_time = fulcro.history.last_tx_time.call(null,history);
var gc_QMARK_ = cljs.core._EQ_.call(null,(0),cljs.core.mod.call(null,tx_time,(10)));
var last_tx = cljs.core.get_in.call(null,history_steps,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [last_time,new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993)], null),cljs.core.PersistentVector.EMPTY);
var all_active_steps = cljs.core.reduce.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY,(function (){var G__55345 = active_remotes;
var G__55345__$1 = (((G__55345 == null))?null:cljs.core.vals.call(null,G__55345));
if((G__55345__$1 == null)){
return null;
} else {
return cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.set,cljs.core.keys),G__55345__$1);
}
})());
var compressible_QMARK_ = ((fulcro.history.compressible_tx_QMARK_.call(null,tx)) && (fulcro.history.compressible_tx_QMARK_.call(null,last_tx)) && ((!(cljs.core.contains_QMARK_.call(null,all_active_steps,last_time)))));
var new_history = (function (){var G__55350 = cljs.core.assoc_in.call(null,history,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620),tx_time], null),step);
if(compressible_QMARK_){
return cljs.core.update.call(null,G__55350,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620),cljs.core.dissoc,last_time);
} else {
return G__55350;
}
})();
if(gc_QMARK_){
return fulcro.history.gc_history.call(null,new_history);
} else {
return new_history;
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","record-history-step","fulcro.history/record-history-step",929203105,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"step","step",1288888124)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null,null));
fulcro.history.new_history = (function fulcro$history$new_history(size){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.history","max-size","fulcro.history/max-size",338795187),size,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("fulcro.history","active-remotes","fulcro.history/active-remotes",-1858379711),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","new-history","fulcro.history/new-history",-1295571323,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"size","size",1098693007)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),null,null,null));
/**
 * Returns the current valid sequence of step times in the given history as a sorted vector.
 */
fulcro.history.ordered_steps = (function fulcro$history$ordered_steps(history){
var G__55372 = history;
var G__55372__$1 = (((G__55372 == null))?null:new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620).cljs$core$IFn$_invoke$arity$1(G__55372));
var G__55372__$2 = (((G__55372__$1 == null))?null:cljs.core.keys.call(null,G__55372__$1));
var G__55372__$3 = (((G__55372__$2 == null))?null:cljs.core.sort.call(null,G__55372__$2));
if((G__55372__$3 == null)){
return null;
} else {
return cljs.core.vec.call(null,G__55372__$3);
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","ordered-steps","fulcro.history/ordered-steps",341796067,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"v","v",21465059),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","every","cljs.spec.alpha/every",123912744,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),new cljs.core.Keyword(null,"nothing","nothing",-1022703296),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549)),cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"v","v",21465059),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","every","cljs.spec.alpha/every",123912744,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),new cljs.core.Keyword(null,"nothing","nothing",-1022703296),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"v","v",21465059),new cljs.core.Keyword(null,"nothing","nothing",-1022703296)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","every","cljs.spec.alpha/every",123912744,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"int?","int?",1799729645,null),cljs.core.int_QMARK_,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__55399){
return cljs.core.vector_QMARK_.call(null,G__55399);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.vector_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","every","cljs.spec.alpha/every",123912744,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null),cljs.core.nil_QMARK_], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"v","v",21465059),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","every","cljs.spec.alpha/every",123912744,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),new cljs.core.Keyword(null,"nothing","nothing",-1022703296),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null)),null,null,null));
/**
 * Returns a step from the given history that has the given tx-time. If tx-time specifies a spot where there is a gap in the history
 *   (there are steps before and after), then it will return the earlier step, unless the latter was compressible, in which case
 *   it will return the step into which the desired spot was compressed. 
 */
fulcro.history.get_step = (function fulcro$history$get_step(p__55407,tx_time){
var map__55410 = p__55407;
var map__55410__$1 = (((((!((map__55410 == null))))?(((((map__55410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55410.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55410):map__55410);
var history = map__55410__$1;
var history_steps = cljs.core.get.call(null,map__55410__$1,new cljs.core.Keyword("fulcro.history","history-steps","fulcro.history/history-steps",1960379620));
var temp__5718__auto__ = cljs.core.get.call(null,history_steps,tx_time);
if(cljs.core.truth_(temp__5718__auto__)){
var exact_step = temp__5718__auto__;
return exact_step;
} else {
var timeline = fulcro.history.ordered_steps.call(null,history);
var vec__55414 = cljs.core.split_with.call(null,((function (timeline,temp__5718__auto__,map__55410,map__55410__$1,history,history_steps){
return (function (p1__55404_SHARP_){
return (tx_time > p1__55404_SHARP_);
});})(timeline,temp__5718__auto__,map__55410,map__55410__$1,history,history_steps))
,timeline);
var before = cljs.core.nth.call(null,vec__55414,(0),null);
var after = cljs.core.nth.call(null,vec__55414,(1),null);
var step_before = cljs.core.get.call(null,history_steps,cljs.core.last.call(null,before));
var step_after = cljs.core.get.call(null,history_steps,cljs.core.first.call(null,after));
if(cljs.core.truth_((function (){var and__4120__auto__ = step_before;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = step_after;
if(cljs.core.truth_(and__4120__auto____$1)){
return fulcro.history.compressible_tx_QMARK_.call(null,new cljs.core.Keyword("fulcro.history","tx","fulcro.history/tx",1485693993).cljs$core$IFn$_invoke$arity$1(step_after));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
return step_after;
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = step_before;
if(cljs.core.truth_(and__4120__auto__)){
return step_after;
} else {
return and__4120__auto__;
}
})())){
return step_before;
} else {
return null;

}
}
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.history","get-step","fulcro.history/get-step",489831412,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nothing","nothing",-1022703296),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword(null,"time","time",1385887882)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"hist","hist",-1294086168),new cljs.core.Keyword("fulcro.history","history","fulcro.history/history",-913869549),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456)),cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nothing","nothing",-1022703296),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nothing","nothing",-1022703296),new cljs.core.Keyword(null,"step","step",1288888124)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nothing","nothing",-1022703296),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.Keyword("fulcro.history","history-step","fulcro.history/history-step",-880117884)),null,null,null));
/**
 * Returns a navigator of history. Use focus-next, focus-previous, and current-step.
 */
fulcro.history.history_navigator = (function fulcro$history$history_navigator(history){
var steps = fulcro.history.ordered_steps.call(null,history);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"legal-steps","legal-steps",-577830084),steps,new cljs.core.Keyword(null,"history","history",-247395220),history,new cljs.core.Keyword(null,"index","index",-1531685915),(cljs.core.count.call(null,steps) - (1))], null);
});
/**
 * Gives back navigation position as a pair [current-index count-of-steps]
 */
fulcro.history.nav_position = (function fulcro$history$nav_position(history_nav){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(history_nav),cljs.core.count.call(null,new cljs.core.Keyword(null,"legal-steps","legal-steps",-577830084).cljs$core$IFn$_invoke$arity$1(history_nav))], null);
});
/**
 * Returns a new history navigation with the focus on the next step (or the last if already there). See history-navigator
 */
fulcro.history.focus_next = (function fulcro$history$focus_next(history_nav){
var map__55436 = history_nav;
var map__55436__$1 = (((((!((map__55436 == null))))?(((((map__55436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55436):map__55436);
var index = cljs.core.get.call(null,map__55436__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var history = cljs.core.get.call(null,map__55436__$1,new cljs.core.Keyword(null,"history","history",-247395220));
var legal_steps = cljs.core.get.call(null,map__55436__$1,new cljs.core.Keyword(null,"legal-steps","legal-steps",-577830084));
var last_legal_idx = (cljs.core.count.call(null,legal_steps) - (1));
return cljs.core.update.call(null,history_nav,new cljs.core.Keyword(null,"index","index",-1531685915),((function (map__55436,map__55436__$1,index,history,legal_steps,last_legal_idx){
return (function (i){
if((i < last_legal_idx)){
return (i + (1));
} else {
return i;
}
});})(map__55436,map__55436__$1,index,history,legal_steps,last_legal_idx))
);
});
/**
 * Returns a new history navigation with the focus on the prior step (or the first if already there). See history-navigator
 */
fulcro.history.focus_previous = (function fulcro$history$focus_previous(history_nav){
var map__55441 = history_nav;
var map__55441__$1 = (((((!((map__55441 == null))))?(((((map__55441.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55441.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55441):map__55441);
var index = cljs.core.get.call(null,map__55441__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var history = cljs.core.get.call(null,map__55441__$1,new cljs.core.Keyword(null,"history","history",-247395220));
var legal_steps = cljs.core.get.call(null,map__55441__$1,new cljs.core.Keyword(null,"legal-steps","legal-steps",-577830084));
return cljs.core.update.call(null,history_nav,new cljs.core.Keyword(null,"index","index",-1531685915),((function (map__55441,map__55441__$1,index,history,legal_steps){
return (function (i){
if((i === (0))){
return (0);
} else {
return (i - (1));
}
});})(map__55441,map__55441__$1,index,history,legal_steps))
);
});
/**
 * Returns a new history navigation with the focus on the prior step (or the first if already there). See history-navigator
 */
fulcro.history.focus_start = (function fulcro$history$focus_start(history_nav){
var map__55446 = history_nav;
var map__55446__$1 = (((((!((map__55446 == null))))?(((((map__55446.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55446.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55446):map__55446);
var index = cljs.core.get.call(null,map__55446__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var history = cljs.core.get.call(null,map__55446__$1,new cljs.core.Keyword(null,"history","history",-247395220));
var legal_steps = cljs.core.get.call(null,map__55446__$1,new cljs.core.Keyword(null,"legal-steps","legal-steps",-577830084));
return cljs.core.assoc.call(null,history_nav,new cljs.core.Keyword(null,"index","index",-1531685915),(0));
});
/**
 * Returns a new history navigation with the focus on the prior step (or the first if already there). See history-navigator
 */
fulcro.history.focus_end = (function fulcro$history$focus_end(history_nav){
var map__55452 = history_nav;
var map__55452__$1 = (((((!((map__55452 == null))))?(((((map__55452.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55452.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55452):map__55452);
var index = cljs.core.get.call(null,map__55452__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var history = cljs.core.get.call(null,map__55452__$1,new cljs.core.Keyword(null,"history","history",-247395220));
var legal_steps = cljs.core.get.call(null,map__55452__$1,new cljs.core.Keyword(null,"legal-steps","legal-steps",-577830084));
return cljs.core.assoc.call(null,history_nav,new cljs.core.Keyword(null,"index","index",-1531685915),(cljs.core.count.call(null,legal_steps) - (1)));
});
/**
 * Get the current history step from the history-nav. See history-navigator.
 */
fulcro.history.current_step = (function fulcro$history$current_step(history_nav){
var map__55456 = history_nav;
var map__55456__$1 = (((((!((map__55456 == null))))?(((((map__55456.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55456.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55456):map__55456);
var index = cljs.core.get.call(null,map__55456__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var history = cljs.core.get.call(null,map__55456__$1,new cljs.core.Keyword(null,"history","history",-247395220));
var legal_steps = cljs.core.get.call(null,map__55456__$1,new cljs.core.Keyword(null,"legal-steps","legal-steps",-577830084));
var history_step_tx_time = cljs.core.get.call(null,legal_steps,index);
var history_step = fulcro.history.get_step.call(null,history,history_step_tx_time);
return history_step;
});

//# sourceMappingURL=fulcro.history.js.map
