goog.provide('shadow.cljs.devtools.client.env');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('cljs.tools.reader');
goog.require('cljs.pprint');
goog.require('clojure.set');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.active_modules_ref = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
}
shadow.cljs.devtools.client.env.module_loaded = (function shadow$cljs$devtools$client$env$module_loaded(name){
return cljs.core._vreset_BANG_(shadow.cljs.devtools.client.env.active_modules_ref,cljs.core.conj.call(null,cljs.core._deref(shadow.cljs.devtools.client.env.active_modules_ref),cljs.core.keyword.call(null,name)));
});
shadow.cljs.devtools.client.env.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$env$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.env.active_modules_ref),module);
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.runtime_id !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.runtime_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
}
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.enabled = goog.define("shadow.cljs.devtools.client.env.enabled",false);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.autoload = goog.define("shadow.cljs.devtools.client.env.autoload",true);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.module_format = goog.define("shadow.cljs.devtools.client.env.module_format","goog");
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.reload_with_state = goog.define("shadow.cljs.devtools.client.env.reload_with_state",false);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.build_id = goog.define("shadow.cljs.devtools.client.env.build_id","");
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.proc_id = goog.define("shadow.cljs.devtools.client.env.proc_id","");
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.server_host = goog.define("shadow.cljs.devtools.client.env.server_host","");
/**
 * @define {number}
 */
shadow.cljs.devtools.client.env.server_port = goog.define("shadow.cljs.devtools.client.env.server_port",(8200));
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.repl_pprint = goog.define("shadow.cljs.devtools.client.env.repl_pprint",false);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.use_document_host = goog.define("shadow.cljs.devtools.client.env.use_document_host",true);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.devtools_url = goog.define("shadow.cljs.devtools.client.env.devtools_url","");
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.reload_strategy = goog.define("shadow.cljs.devtools.client.env.reload_strategy","optimized");
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.ssl = goog.define("shadow.cljs.devtools.client.env.ssl",false);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.ignore_warnings = goog.define("shadow.cljs.devtools.client.env.ignore_warnings",false);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.log_style = goog.define("shadow.cljs.devtools.client.env.log_style","font-weight: bold;");
shadow.cljs.devtools.client.env.devtools_info = (function shadow$cljs$devtools$client$env$devtools_info(){
return ({"server-port": shadow.cljs.devtools.client.env.server_port, "server-host": shadow.cljs.devtools.client.env.server_host, "build-id": shadow.cljs.devtools.client.env.build_id, "proc-id": shadow.cljs.devtools.client.env.proc_id, "runtime-id": shadow.cljs.devtools.client.env.runtime_id});
});
shadow.cljs.devtools.client.env.get_server_host = (function shadow$cljs$devtools$client$env$get_server_host(){
if(cljs.core.truth_((function (){var and__4120__auto__ = shadow.cljs.devtools.client.env.use_document_host;
if(and__4120__auto__){
var and__4120__auto____$1 = goog.global.document;
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = goog.global.document.location;
if(cljs.core.truth_(and__4120__auto____$2)){
return cljs.core.seq.call(null,goog.global.document.location.hostname);
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
return document.location.hostname;
} else {
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.server_host)){
return shadow.cljs.devtools.client.env.server_host;
} else {
return "localhost";

}
}
});
shadow.cljs.devtools.client.env.get_url_base = (function shadow$cljs$devtools$client$env$get_url_base(){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.devtools_url)){
return shadow.cljs.devtools.client.env.devtools_url;
} else {
return ["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_server_host.call(null)),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port)].join('');
}
});
shadow.cljs.devtools.client.env.get_ws_url_base = (function shadow$cljs$devtools$client$env$get_ws_url_base(){
return clojure.string.replace.call(null,shadow.cljs.devtools.client.env.get_url_base.call(null),/^http/,"ws");
});
shadow.cljs.devtools.client.env.ws_url = (function shadow$cljs$devtools$client$env$ws_url(runtime_type){
if((runtime_type instanceof cljs.core.Keyword)){
} else {
throw (new Error("Assert failed: (keyword? runtime-type)"));
}

return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_ws_url_base.call(null)),"/ws/worker/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/",shadow.cljs.devtools.client.env.runtime_id,"/",cljs.core.name.call(null,runtime_type)].join('');
});
shadow.cljs.devtools.client.env.ws_listener_url = (function shadow$cljs$devtools$client$env$ws_listener_url(client_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_ws_url_base.call(null)),"/ws/listener/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/",shadow.cljs.devtools.client.env.runtime_id].join('');
});
shadow.cljs.devtools.client.env.files_url = (function shadow$cljs$devtools$client$env$files_url(){
return [shadow.cljs.devtools.client.env.get_url_base.call(null),"/worker/files/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/",shadow.cljs.devtools.client.env.runtime_id].join('');
});
shadow.cljs.devtools.client.env.repl_print_fn = (((!(shadow.cljs.devtools.client.env.repl_pprint)))?cljs.core.pr_str:(function shadow$cljs$devtools$client$env$repl_pprint(obj){
var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__53687_53931 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__53688_53932 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__53689_53933 = true;
var _STAR_print_fn_STAR__temp_val__53690_53934 = ((function (_STAR_print_newline_STAR__orig_val__53687_53931,_STAR_print_fn_STAR__orig_val__53688_53932,_STAR_print_newline_STAR__temp_val__53689_53933,sb__4661__auto__){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__53687_53931,_STAR_print_fn_STAR__orig_val__53688_53932,_STAR_print_newline_STAR__temp_val__53689_53933,sb__4661__auto__))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__53689_53933;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__53690_53934;

try{cljs.pprint.pprint.call(null,obj);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__53688_53932;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__53687_53931;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
}));
shadow.cljs.devtools.client.env.repl_error = (function shadow$cljs$devtools$client$env$repl_error(e){
var G__53693 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","invoke-error","repl/invoke-error",839951858),new cljs.core.Keyword(null,"error","error",-978969032),e.message], null);
if(cljs.core.truth_(e.hasOwnProperty("stack"))){
return cljs.core.assoc.call(null,G__53693,new cljs.core.Keyword(null,"stack","stack",-793405930),e.stack);
} else {
return G__53693;
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.repl_results_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.repl_results_ref = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
shadow.cljs.devtools.client.env.repl_call = (function shadow$cljs$devtools$client$env$repl_call(repl_expr,repl_error){
try{var result_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var result = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","result","repl/result",1421065572),new cljs.core.Keyword(null,"result-id","result-id",-2004530966),result_id], null);
var start = Date.now();
var ret = repl_expr.call(null);
var runtime = (Date.now() - start);
cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.repl_results_ref,cljs.core.assoc,result_id,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timestamp","timestamp",579478971),Date.now(),new cljs.core.Keyword(null,"result","result",1415092211),ret], null));

cljs.core._STAR_3 = cljs.core._STAR_2;

cljs.core._STAR_2 = cljs.core._STAR_1;

cljs.core._STAR_1 = ret;

try{var printed = shadow.cljs.devtools.client.env.repl_print_fn.call(null,ret);
cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.repl_results_ref,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result_id,new cljs.core.Keyword(null,"printed","printed",1871492381)], null),printed);

return cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"value","value",305978217),printed,new cljs.core.Keyword(null,"ms","ms",-1152709733),runtime);
}catch (e53701){var e = e53701;
console.log("encoding of result failed",e,ret);

return cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"error","error",-978969032),"ENCODING FAILED, check host console");
}}catch (e53694){var e = e53694;
cljs.core._STAR_e = e;

return repl_error.call(null,e);
}});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.reset_print_fn_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.reset_print_fn_ref = cljs.core.atom.call(null,null);
}
shadow.cljs.devtools.client.env.set_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$set_print_fns_BANG_(msg_fn){
var original_print_fn = cljs.core._STAR_print_fn_STAR_;
var original_print_err_fn = cljs.core._STAR_print_err_fn_STAR_;
cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,((function (original_print_fn,original_print_err_fn){
return (function shadow$cljs$devtools$client$env$set_print_fns_BANG__$_reset_print_fns_BANG_(){
cljs.core.set_print_fn_BANG_.call(null,original_print_fn);

return cljs.core.set_print_err_fn_BANG_.call(null,original_print_err_fn);
});})(original_print_fn,original_print_err_fn))
);

cljs.core.set_print_fn_BANG_.call(null,((function (original_print_fn,original_print_err_fn){
return (function() { 
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate = function (args){
msg_fn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","out","repl/out",-905715102),new cljs.core.Keyword(null,"text","text",-1790561697),clojure.string.join.call(null,"",args)], null));

if(cljs.core.truth_(original_print_fn)){
return cljs.core.apply.call(null,original_print_fn,args);
} else {
return null;
}
};
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__53950__i = 0, G__53950__a = new Array(arguments.length -  0);
while (G__53950__i < G__53950__a.length) {G__53950__a[G__53950__i] = arguments[G__53950__i + 0]; ++G__53950__i;}
  args = new cljs.core.IndexedSeq(G__53950__a,0,null);
} 
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate.call(this,args);};
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$lang$maxFixedArity = 0;
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$lang$applyTo = (function (arglist__53951){
var args = cljs.core.seq(arglist__53951);
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate(args);
});
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$core$IFn$_invoke$arity$variadic = shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate;
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn;
})()
;})(original_print_fn,original_print_err_fn))
);

return cljs.core.set_print_err_fn_BANG_.call(null,((function (original_print_fn,original_print_err_fn){
return (function() { 
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate = function (args){
msg_fn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","err","repl/err",-2086562244),new cljs.core.Keyword(null,"text","text",-1790561697),clojure.string.join.call(null,"",args)], null));

if(cljs.core.truth_(original_print_err_fn)){
return cljs.core.apply.call(null,original_print_err_fn,args);
} else {
return null;
}
};
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__53952__i = 0, G__53952__a = new Array(arguments.length -  0);
while (G__53952__i < G__53952__a.length) {G__53952__a[G__53952__i] = arguments[G__53952__i + 0]; ++G__53952__i;}
  args = new cljs.core.IndexedSeq(G__53952__a,0,null);
} 
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate.call(this,args);};
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$lang$maxFixedArity = 0;
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$lang$applyTo = (function (arglist__53953){
var args = cljs.core.seq(arglist__53953);
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate(args);
});
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$core$IFn$_invoke$arity$variadic = shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate;
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn;
})()
;})(original_print_fn,original_print_err_fn))
);
});
shadow.cljs.devtools.client.env.reset_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$reset_print_fns_BANG_(){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var x = temp__5720__auto__;
x.call(null);

return cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,null);
} else {
return null;
}
});
shadow.cljs.devtools.client.env.async_ops = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("repl","session-start","repl/session-start",-1824978454),null,new cljs.core.Keyword("repl","init","repl/init",-1883779019),null,new cljs.core.Keyword("repl","require","repl/require",-497010086),null], null), null);
shadow.cljs.devtools.client.env.repl_queue_ref = cljs.core.atom.call(null,false);
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.repl_queue_arr !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.repl_queue_arr = [];
}
shadow.cljs.devtools.client.env.process_next_BANG_ = (function shadow$cljs$devtools$client$env$process_next_BANG_(){
if(cljs.core.truth_(cljs.core.deref.call(null,shadow.cljs.devtools.client.env.repl_queue_ref))){
return null;
} else {
var temp__5724__auto__ = shadow.cljs.devtools.client.env.repl_queue_arr.shift();
if((temp__5724__auto__ == null)){
return null;
} else {
var task = temp__5724__auto__;
cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.repl_queue_ref,true);

return task.call(null);
}
}
});
shadow.cljs.devtools.client.env.done_BANG_ = (function shadow$cljs$devtools$client$env$done_BANG_(){
cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.repl_queue_ref,false);

return shadow.cljs.devtools.client.env.process_next_BANG_.call(null);
});
shadow.cljs.devtools.client.env.process_ws_msg = (function shadow$cljs$devtools$client$env$process_ws_msg(text,handler){
var _STAR_default_data_reader_fn_STAR__orig_val__53713 = cljs.tools.reader._STAR_default_data_reader_fn_STAR_;
var _STAR_default_data_reader_fn_STAR__temp_val__53714 = ((function (_STAR_default_data_reader_fn_STAR__orig_val__53713){
return (function (tag,value){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tagged-literal","tagged-literal",1758013066),tag,value], null);
});})(_STAR_default_data_reader_fn_STAR__orig_val__53713))
;
cljs.tools.reader._STAR_default_data_reader_fn_STAR_ = _STAR_default_data_reader_fn_STAR__temp_val__53714;

try{try{var msg_53958 = cljs.tools.reader.read_string.call(null,text);
shadow.cljs.devtools.client.env.repl_queue_arr.push(((function (msg_53958,_STAR_default_data_reader_fn_STAR__orig_val__53713,_STAR_default_data_reader_fn_STAR__temp_val__53714){
return (function (){
return handler.call(null,msg_53958,shadow.cljs.devtools.client.env.done_BANG_);
});})(msg_53958,_STAR_default_data_reader_fn_STAR__orig_val__53713,_STAR_default_data_reader_fn_STAR__temp_val__53714))
);

return shadow.cljs.devtools.client.env.process_next_BANG_.call(null);
}catch (e53715){var e = e53715;
console.warn("failed to parse websocket message",text,e);

throw e;
}}finally {cljs.tools.reader._STAR_default_data_reader_fn_STAR_ = _STAR_default_data_reader_fn_STAR__orig_val__53713;
}});
shadow.cljs.devtools.client.env.make_task_fn = (function shadow$cljs$devtools$client$env$make_task_fn(p__53716,p__53717){
var map__53718 = p__53716;
var map__53718__$1 = (((((!((map__53718 == null))))?(((((map__53718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53718):map__53718);
var log_missing_fn = cljs.core.get.call(null,map__53718__$1,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765));
var log_call_async = cljs.core.get.call(null,map__53718__$1,new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192));
var log_call = cljs.core.get.call(null,map__53718__$1,new cljs.core.Keyword(null,"log-call","log-call",412404391));
var map__53719 = p__53717;
var map__53719__$1 = (((((!((map__53719 == null))))?(((((map__53719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53719.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53719):map__53719);
var fn_sym = cljs.core.get.call(null,map__53719__$1,new cljs.core.Keyword(null,"fn-sym","fn-sym",1423988510));
var fn_str = cljs.core.get.call(null,map__53719__$1,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402));
var async = cljs.core.get.call(null,map__53719__$1,new cljs.core.Keyword(null,"async","async",1050769601));
return ((function (map__53718,map__53718__$1,log_missing_fn,log_call_async,log_call,map__53719,map__53719__$1,fn_sym,fn_str,async){
return (function (next){
try{var fn_obj = goog.getObjectByName(fn_str,$CLJS);
if((fn_obj == null)){
if(cljs.core.truth_(log_missing_fn)){
log_missing_fn.call(null,fn_sym);
} else {
}

return next.call(null);
} else {
if(cljs.core.truth_(async)){
if(cljs.core.truth_(log_call_async)){
log_call_async.call(null,fn_sym);
} else {
}

return fn_obj(next);
} else {
if(cljs.core.truth_(log_call)){
log_call.call(null,fn_sym);
} else {
}

fn_obj();

return next.call(null);

}
}
}catch (e53729){var ex = e53729;
console.warn("error when calling lifecycle function",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym),ex);

return next.call(null);
}});
;})(map__53718,map__53718__$1,log_missing_fn,log_call_async,log_call,map__53719,map__53719__$1,fn_sym,fn_str,async))
});
shadow.cljs.devtools.client.env.do_js_reload_STAR_ = (function shadow$cljs$devtools$client$env$do_js_reload_STAR_(failure_fn,p__53734){
var vec__53735 = p__53734;
var seq__53736 = cljs.core.seq.call(null,vec__53735);
var first__53737 = cljs.core.first.call(null,seq__53736);
var seq__53736__$1 = cljs.core.next.call(null,seq__53736);
var task = first__53737;
var remaining_tasks = seq__53736__$1;
if(cljs.core.truth_(task)){
try{return task.call(null,((function (vec__53735,seq__53736,first__53737,seq__53736__$1,task,remaining_tasks){
return (function (){
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,remaining_tasks);
});})(vec__53735,seq__53736,first__53737,seq__53736__$1,task,remaining_tasks))
);
}catch (e53738){var e = e53738;
return failure_fn.call(null,e,task,remaining_tasks);
}} else {
return null;
}
});
/**
 * should pass the :build-complete message and an additional callback
 * which performs the actual loading of the code (sync)
 * will call all before/after callbacks in order
 */
shadow.cljs.devtools.client.env.do_js_reload = (function shadow$cljs$devtools$client$env$do_js_reload(var_args){
var G__53743 = arguments.length;
switch (G__53743) {
case 2:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2 = (function (msg,load_code_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,(function (){
return null;
}));
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3 = (function (msg,load_code_fn,complete_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,complete_fn,(function (error,task,remaining){
return console.warn("JS reload failed",error);
}));
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4 = (function (p__53745,load_code_fn,complete_fn,failure_fn){
var map__53746 = p__53745;
var map__53746__$1 = (((((!((map__53746 == null))))?(((((map__53746.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53746.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53746):map__53746);
var msg = map__53746__$1;
var reload_info = cljs.core.get.call(null,map__53746__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var load_tasks = cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.reverse.call(null,cljs.core.map.call(null,((function (map__53746,map__53746__$1,msg,reload_info){
return (function (p1__53739_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__53739_SHARP_);
});})(map__53746,map__53746__$1,msg,reload_info))
,new cljs.core.Keyword(null,"before-load","before-load",-2060117064).cljs$core$IFn$_invoke$arity$1(reload_info)))),((function (map__53746,map__53746__$1,msg,reload_info){
return (function (next){
load_code_fn.call(null);

return next.call(null);
});})(map__53746,map__53746__$1,msg,reload_info))
),cljs.core.map.call(null,((function (map__53746,map__53746__$1,msg,reload_info){
return (function (p1__53740_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__53740_SHARP_);
});})(map__53746,map__53746__$1,msg,reload_info))
),new cljs.core.Keyword(null,"after-load","after-load",-1278503285).cljs$core$IFn$_invoke$arity$1(reload_info)),((function (map__53746,map__53746__$1,msg,reload_info){
return (function (next){
complete_fn.call(null);

return next.call(null);
});})(map__53746,map__53746__$1,msg,reload_info))
);
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,load_tasks);
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$lang$maxFixedArity = 4;

shadow.cljs.devtools.client.env.before_load_src = (function shadow$cljs$devtools$client$env$before_load_src(p__53753){
var map__53754 = p__53753;
var map__53754__$1 = (((((!((map__53754 == null))))?(((((map__53754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53754):map__53754);
var src = map__53754__$1;
var type = cljs.core.get.call(null,map__53754__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var ns = cljs.core.get.call(null,map__53754__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"cljs","cljs",1492417629),type)){
var seq__53758 = cljs.core.seq.call(null,goog.global.SHADOW_NS_RESET);
var chunk__53759 = null;
var count__53760 = (0);
var i__53761 = (0);
while(true){
if((i__53761 < count__53760)){
var x = cljs.core._nth(chunk__53759,i__53761);
x.call(null,ns);


var G__53986 = seq__53758;
var G__53987 = chunk__53759;
var G__53988 = count__53760;
var G__53989 = (i__53761 + (1));
seq__53758 = G__53986;
chunk__53759 = G__53987;
count__53760 = G__53988;
i__53761 = G__53989;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__53758);
if(temp__5720__auto__){
var seq__53758__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__53758__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__53758__$1);
var G__53990 = cljs.core.chunk_rest.call(null,seq__53758__$1);
var G__53991 = c__4550__auto__;
var G__53992 = cljs.core.count.call(null,c__4550__auto__);
var G__53993 = (0);
seq__53758 = G__53990;
chunk__53759 = G__53991;
count__53760 = G__53992;
i__53761 = G__53993;
continue;
} else {
var x = cljs.core.first.call(null,seq__53758__$1);
x.call(null,ns);


var G__53999 = cljs.core.next.call(null,seq__53758__$1);
var G__54000 = null;
var G__54001 = (0);
var G__54002 = (0);
seq__53758 = G__53999;
chunk__53759 = G__54000;
count__53760 = G__54001;
i__53761 = G__54002;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.custom_msg_subscribers_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.custom_msg_subscribers_ref = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
shadow.cljs.devtools.client.env.subscribe_BANG_ = (function shadow$cljs$devtools$client$env$subscribe_BANG_(sub_id,callback){
return cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.custom_msg_subscribers_ref,cljs.core.assoc,sub_id,callback);
});
shadow.cljs.devtools.client.env.publish_BANG_ = (function shadow$cljs$devtools$client$env$publish_BANG_(msg){
var seq__53769 = cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.env.custom_msg_subscribers_ref));
var chunk__53770 = null;
var count__53771 = (0);
var i__53772 = (0);
while(true){
if((i__53772 < count__53771)){
var vec__53785 = cljs.core._nth(chunk__53770,i__53772);
var id = cljs.core.nth.call(null,vec__53785,(0),null);
var callback = cljs.core.nth.call(null,vec__53785,(1),null);
try{callback.call(null,msg);
}catch (e53789){var e_54016 = e53789;
console.warn("failed to handle custom msg",id,msg);
}

var G__54017 = seq__53769;
var G__54018 = chunk__53770;
var G__54019 = count__53771;
var G__54020 = (i__53772 + (1));
seq__53769 = G__54017;
chunk__53770 = G__54018;
count__53771 = G__54019;
i__53772 = G__54020;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__53769);
if(temp__5720__auto__){
var seq__53769__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__53769__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__53769__$1);
var G__54024 = cljs.core.chunk_rest.call(null,seq__53769__$1);
var G__54025 = c__4550__auto__;
var G__54026 = cljs.core.count.call(null,c__4550__auto__);
var G__54027 = (0);
seq__53769 = G__54024;
chunk__53770 = G__54025;
count__53771 = G__54026;
i__53772 = G__54027;
continue;
} else {
var vec__53791 = cljs.core.first.call(null,seq__53769__$1);
var id = cljs.core.nth.call(null,vec__53791,(0),null);
var callback = cljs.core.nth.call(null,vec__53791,(1),null);
try{callback.call(null,msg);
}catch (e53794){var e_54031 = e53794;
console.warn("failed to handle custom msg",id,msg);
}

var G__54032 = cljs.core.next.call(null,seq__53769__$1);
var G__54033 = null;
var G__54034 = (0);
var G__54035 = (0);
seq__53769 = G__54032;
chunk__53770 = G__54033;
count__53771 = G__54034;
i__53772 = G__54035;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.env.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$env$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.env.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.env.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$env$src_is_loaded_QMARK_(p__53797){
var map__53798 = p__53797;
var map__53798__$1 = (((((!((map__53798 == null))))?(((((map__53798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53798):map__53798);
var src = map__53798__$1;
var resource_id = cljs.core.get.call(null,map__53798__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__53798__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__4131__auto__ = cljs.core._EQ_.call(null,shadow.cljs.devtools.client.env.goog_base_rc,resource_id);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return shadow.cljs.devtools.client.env.goog_is_loaded_QMARK_.call(null,output_name);
}
});
shadow.cljs.devtools.client.env.prefilter_sources = (function shadow$cljs$devtools$client$env$prefilter_sources(reload_info,sources){
return cljs.core.remove.call(null,(function (p__53801){
var map__53803 = p__53801;
var map__53803__$1 = (((((!((map__53803 == null))))?(((((map__53803.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53803.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53803):map__53803);
var ns = cljs.core.get.call(null,map__53803__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
}),cljs.core.filter.call(null,(function (p__53806){
var map__53807 = p__53806;
var map__53807__$1 = (((((!((map__53807 == null))))?(((((map__53807.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53807.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53807):map__53807);
var rc = map__53807__$1;
var module = cljs.core.get.call(null,map__53807__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.call(null,"js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.env.module_is_active_QMARK_.call(null,module)));
}),sources));
});
shadow.cljs.devtools.client.env.filter_sources_to_get_optimized = (function shadow$cljs$devtools$client$env$filter_sources_to_get_optimized(p__53814,reload_info){
var map__53816 = p__53814;
var map__53816__$1 = (((((!((map__53816 == null))))?(((((map__53816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53816.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53816):map__53816);
var info = map__53816__$1;
var sources = cljs.core.get.call(null,map__53816__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__53816__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,((function (map__53816,map__53816__$1,info,sources,compiled){
return (function (p__53820){
var map__53821 = p__53820;
var map__53821__$1 = (((((!((map__53821 == null))))?(((((map__53821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53821.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53821):map__53821);
var src = map__53821__$1;
var ns = cljs.core.get.call(null,map__53821__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__53821__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_.call(null,src))) || (((cljs.core.contains_QMARK_.call(null,compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__53816,map__53816__$1,info,sources,compiled))
,shadow.cljs.devtools.client.env.prefilter_sources.call(null,reload_info,sources)));
});
shadow.cljs.devtools.client.env.filter_sources_to_get_full = (function shadow$cljs$devtools$client$env$filter_sources_to_get_full(p__53826,reload_info){
var map__53827 = p__53826;
var map__53827__$1 = (((((!((map__53827 == null))))?(((((map__53827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53827):map__53827);
var info = map__53827__$1;
var sources = cljs.core.get.call(null,map__53827__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__53827__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var affected = cljs.core.PersistentHashSet.EMPTY;
var sources_to_get = cljs.core.PersistentVector.EMPTY;
var G__53834 = shadow.cljs.devtools.client.env.prefilter_sources.call(null,reload_info,sources);
var vec__53835 = G__53834;
var seq__53836 = cljs.core.seq.call(null,vec__53835);
var first__53837 = cljs.core.first.call(null,seq__53836);
var seq__53836__$1 = cljs.core.next.call(null,seq__53836);
var src = first__53837;
var more = seq__53836__$1;
var affected__$1 = affected;
var sources_to_get__$1 = sources_to_get;
var G__53834__$1 = G__53834;
while(true){
var affected__$2 = affected__$1;
var sources_to_get__$2 = sources_to_get__$1;
var vec__53878 = G__53834__$1;
var seq__53879 = cljs.core.seq.call(null,vec__53878);
var first__53880 = cljs.core.first.call(null,seq__53879);
var seq__53879__$1 = cljs.core.next.call(null,seq__53879);
var src__$1 = first__53880;
var more__$1 = seq__53879__$1;
if(cljs.core.not(src__$1)){
return sources_to_get__$2;
} else {
var map__53881 = src__$1;
var map__53881__$1 = (((((!((map__53881 == null))))?(((((map__53881.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53881.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53881):map__53881);
var ns = cljs.core.get.call(null,map__53881__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__53881__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var deps = cljs.core.get.call(null,map__53881__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var provides = cljs.core.get.call(null,map__53881__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var should_reload_QMARK_ = (function (){var or__4131__auto__ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = cljs.core.not(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_.call(null,src__$1));
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
var and__4120__auto__ = (function (){var or__4131__auto____$2 = cljs.core.contains_QMARK_.call(null,compiled,resource_id);
if(or__4131__auto____$2){
return or__4131__auto____$2;
} else {
return cljs.core.some.call(null,affected__$2,deps);
}
})();
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src__$1));
} else {
return and__4120__auto__;
}
}
}
})();
if(cljs.core.not(should_reload_QMARK_)){
var G__54130 = affected__$2;
var G__54131 = sources_to_get__$2;
var G__54132 = more__$1;
affected__$1 = G__54130;
sources_to_get__$1 = G__54131;
G__53834__$1 = G__54132;
continue;
} else {
var G__54133 = clojure.set.union.call(null,affected__$2,provides);
var G__54134 = cljs.core.conj.call(null,sources_to_get__$2,src__$1);
var G__54135 = more__$1;
affected__$1 = G__54133;
sources_to_get__$1 = G__54134;
G__53834__$1 = G__54135;
continue;
}
}
break;
}
});
shadow.cljs.devtools.client.env.filter_reload_sources = (function shadow$cljs$devtools$client$env$filter_reload_sources(info,reload_info){
if(cljs.core._EQ_.call(null,"full",shadow.cljs.devtools.client.env.reload_strategy)){
return shadow.cljs.devtools.client.env.filter_sources_to_get_full.call(null,info,reload_info);
} else {
return shadow.cljs.devtools.client.env.filter_sources_to_get_optimized.call(null,info,reload_info);
}
});

//# sourceMappingURL=shadow.cljs.devtools.client.env.js.map
