goog.provide('shadow.xhr');
goog.require('cljs.core');
goog.require('goog.result');
goog.require('goog.result.SimpleResult');
goog.require('goog.labs.net.xhr');
goog.require('cljs.reader');
goog.require('goog.uri.utils');
goog.require('goog.json');
goog.require('shadow.object');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('shadow.util');
shadow.xhr.result_chain = (function shadow$xhr$result_chain(res,handler){
return goog.result.chain(res,handler);
});
shadow.xhr.result_combine = (function shadow$xhr$result_combine(var_args){
var args__4736__auto__ = [];
var len__4730__auto___62308 = arguments.length;
var i__4731__auto___62309 = (0);
while(true){
if((i__4731__auto___62309 < len__4730__auto___62308)){
args__4736__auto__.push((arguments[i__4731__auto___62309]));

var G__62316 = (i__4731__auto___62309 + (1));
i__4731__auto___62309 = G__62316;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic = (function (results){
return cljs.core.apply.call(null,goog.result.combine,results);
});

shadow.xhr.result_combine.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.xhr.result_combine.cljs$lang$applyTo = (function (seq61897){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq61897));
});

shadow.xhr.result_wait_on_success = (function shadow$xhr$result_wait_on_success(res,callback){
return goog.result.waitOnSuccess(res,callback);
});
shadow.xhr.result_success_QMARK_ = (function shadow$xhr$result_success_QMARK_(res){
return cljs.core._EQ_.call(null,goog.result.Result.State.SUCCESS,res.getState());
});
shadow.xhr.result_value = (function shadow$xhr$result_value(res){
return res.getValue();
});
shadow.xhr.result_immediate = (function shadow$xhr$result_immediate(value){
return goog.result.successfulResult(value);
});
shadow.xhr.result_error = (function shadow$xhr$result_error(res,callback){
return goog.result.waitOnError(res,callback);
});
shadow.xhr.edn_transform = (function shadow$xhr$edn_transform(body){
return cljs.reader.read_string.call(null,body);
});
shadow.xhr.json_transform = (function shadow$xhr$json_transform(body){
return cljs.core.js__GT_clj.call(null,JSON.parse(body));
});
shadow.xhr.goog_keys = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"timeout","timeout",-318625318),"timeoutMs",new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),"withCredentials",new cljs.core.Keyword(null,"headers","headers",-835030129),"headers",new cljs.core.Keyword(null,"mime-type","mime-type",1058646439),"mimeType"], null);
shadow.xhr.make_request_options = (function shadow$xhr$make_request_options(options){
var obj = ({});
var seq__61932_62332 = cljs.core.seq.call(null,options);
var chunk__61933_62333 = null;
var count__61934_62334 = (0);
var i__61935_62335 = (0);
while(true){
if((i__61935_62335 < count__61934_62334)){
var vec__61972_62337 = cljs.core._nth(chunk__61933_62333,i__61935_62335);
var k_62338 = cljs.core.nth.call(null,vec__61972_62337,(0),null);
var v_62339 = cljs.core.nth.call(null,vec__61972_62337,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_62338)] = cljs.core.clj__GT_js.call(null,v_62339));


var G__62341 = seq__61932_62332;
var G__62342 = chunk__61933_62333;
var G__62343 = count__61934_62334;
var G__62344 = (i__61935_62335 + (1));
seq__61932_62332 = G__62341;
chunk__61933_62333 = G__62342;
count__61934_62334 = G__62343;
i__61935_62335 = G__62344;
continue;
} else {
var temp__5720__auto___62349 = cljs.core.seq.call(null,seq__61932_62332);
if(temp__5720__auto___62349){
var seq__61932_62353__$1 = temp__5720__auto___62349;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61932_62353__$1)){
var c__4550__auto___62354 = cljs.core.chunk_first.call(null,seq__61932_62353__$1);
var G__62355 = cljs.core.chunk_rest.call(null,seq__61932_62353__$1);
var G__62356 = c__4550__auto___62354;
var G__62357 = cljs.core.count.call(null,c__4550__auto___62354);
var G__62358 = (0);
seq__61932_62332 = G__62355;
chunk__61933_62333 = G__62356;
count__61934_62334 = G__62357;
i__61935_62335 = G__62358;
continue;
} else {
var vec__61991_62359 = cljs.core.first.call(null,seq__61932_62353__$1);
var k_62360 = cljs.core.nth.call(null,vec__61991_62359,(0),null);
var v_62361 = cljs.core.nth.call(null,vec__61991_62359,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_62360)] = cljs.core.clj__GT_js.call(null,v_62361));


var G__62364 = cljs.core.next.call(null,seq__61932_62353__$1);
var G__62365 = null;
var G__62366 = (0);
var G__62367 = (0);
seq__61932_62332 = G__62364;
chunk__61933_62333 = G__62365;
count__61934_62334 = G__62366;
i__61935_62335 = G__62367;
continue;
}
} else {
}
}
break;
}

return obj;
});
shadow.xhr.content_transforms = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 5, ["text/edn",shadow.xhr.edn_transform,"application/edn",shadow.xhr.edn_transform,"application/json",shadow.xhr.json_transform,"text/html",cljs.core.identity,"text/plain",cljs.core.identity], null));
shadow.xhr.register_transform = (function shadow$xhr$register_transform(content_type,transform_fn){
return cljs.core.swap_BANG_.call(null,shadow.xhr.content_transforms,cljs.core.assoc,content_type,transform_fn);
});
shadow.xhr.auto_transform = (function shadow$xhr$auto_transform(req){
var content_type = (function (){var ct = clojure.string.lower_case.call(null,req.getResponseHeader("Content-Type"));
var sep = ct.indexOf(";");
if(cljs.core.not_EQ_.call(null,(-1),sep)){
return ct.substring((0),sep);
} else {
return ct;
}
})();
var transform_fn = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.xhr.content_transforms),content_type);
if((transform_fn == null)){
throw cljs.core.ex_info.call(null,"unsupported content-type",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"req","req",-326448303),req,new cljs.core.Keyword(null,"content-type","content-type",-508222634),content_type], null));
} else {
return transform_fn.call(null,req.responseText);
}
});
shadow.xhr.make_url = (function shadow$xhr$make_url(url,params){
return goog.uri.utils.appendParamsFromMap(url,cljs.core.clj__GT_js.call(null,params));
});
shadow.xhr.transform_request_body = (function shadow$xhr$transform_request_body(data){
if(typeof data === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/plain; charset=utf-8",data], null);
} else {
if((((!((data == null))))?(((((data.cljs$lang$protocol_mask$partition0$ & (2147483648))) || ((cljs.core.PROTOCOL_SENTINEL === data.cljs$core$IPrintWithWriter$))))?true:(((!data.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/edn; charset=utf-8",cljs.core.pr_str.call(null,data)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["application/octet-stream",data], null);

}
}
});
shadow.xhr.as_url = (function shadow$xhr$as_url(input){
if(typeof input === 'string'){
return input;
} else {
if(((cljs.core.vector_QMARK_.call(null,input)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,input))) && (typeof cljs.core.first.call(null,input) === 'string') && (cljs.core.map_QMARK_.call(null,cljs.core.second.call(null,input))))){
var vec__62044 = input;
var url = cljs.core.nth.call(null,vec__62044,(0),null);
var params = cljs.core.nth.call(null,vec__62044,(1),null);
return shadow.xhr.make_url.call(null,url,params);
} else {
throw cljs.core.ex_info.call(null,"doesnt look like an url",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),input], null));

}
}
});
shadow.xhr.e__GT_data = (function shadow$xhr$e__GT_data(e){
return e;
});
shadow.xhr.event_handler = (function shadow$xhr$event_handler(req,events,event_type){
return (function (e){
if(cljs.core.map_QMARK_.call(null,events)){
var temp__5720__auto__ = cljs.core.get.call(null,events,event_type);
if(cljs.core.truth_(temp__5720__auto__)){
var c = temp__5720__auto__;
return cljs.core.async.put_BANG_.call(null,c,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;
}
} else {
if((!((events == null)))){
return cljs.core.async.put_BANG_.call(null,events,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;

}
}
});
});
shadow.xhr.request_ok_QMARK_ = (function shadow$xhr$request_ok_QMARK_(status){
return cljs.core._EQ_.call(null,(200),status);
});
shadow.xhr.request_error_QMARK_ = (function shadow$xhr$request_error_QMARK_(status){
return (status >= (400));
});
/**
 * creates a channel and performs xhr request like (chan :GET "/something")
 * 
 * accepts url as string or [url params]
 * 
 * this channel will receive one message [status body req] on load
 * loadend will close the result channel, so you will get nil results on request errors/timeouts
 * 
 * use options hash to pass in extra channels
 * 
 * (chan :POST "/something" some-data {:events chan-or-map
 *                                       :upload chan-or-map})
 * 
 * when given a chan that channels receives messages in form of [event-type event-data req]
 * when given a map a channel is expected for each eventtype and will receive [event-data req]
 * {:timeout some-chan}, if no channel for a given event is present, no message is sent
 * 
 * event types are :loadstart :progress :abort :error :timeout :loadend :load (see xhr spec)
 * only exception is that status >= 500 does not return a result and produces an error event instead
 */
shadow.xhr.chan = (function shadow$xhr$chan(var_args){
var G__62114 = arguments.length;
switch (G__62114) {
case 2:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.chan.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.chan.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,p__62144){
var map__62147 = p__62144;
var map__62147__$1 = (((((!((map__62147 == null))))?(((((map__62147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62147.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62147):map__62147);
var options = map__62147__$1;
var events = cljs.core.get.call(null,map__62147__$1,new cljs.core.Keyword(null,"events","events",1792552201));
var upload = cljs.core.get.call(null,map__62147__$1,new cljs.core.Keyword(null,"upload","upload",-255769218));
var body_only = cljs.core.get.call(null,map__62147__$1,new cljs.core.Keyword(null,"body-only","body-only",-698120682));
var req = (new XMLHttpRequest());
var body_QMARK_ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method);
var vec__62166 = ((body_QMARK_)?shadow.xhr.transform_request_body.call(null,data):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null));
var content_type = cljs.core.nth.call(null,vec__62166,(0),null);
var body = cljs.core.nth.call(null,vec__62166,(1),null);
var result_chan = cljs.core.async.chan.call(null,(1));
if(cljs.core.truth_((function (){var and__4120__auto__ = body_QMARK_;
if(and__4120__auto__){
return upload;
} else {
return and__4120__auto__;
}
})())){
shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"error","error",-978969032),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"error","error",-978969032)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"load","load",-1318641184),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));
} else {
}

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadend","loadend",1430560564),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadend","loadend",1430560564));
return ((function (callback,req,body_QMARK_,vec__62166,content_type,body,result_chan,map__62147,map__62147__$1,options,events,upload,body_only){
return (function (e){
callback(e);

return cljs.core.async.close_BANG_.call(null,result_chan);
});
;})(callback,req,body_QMARK_,vec__62166,content_type,body,result_chan,map__62147,map__62147__$1,options,events,upload,body_only))
})());

var error_handler_62397 = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"error","error",-978969032));
shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"error","error",-978969032),error_handler_62397);

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"load","load",-1318641184),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"load","load",-1318641184));
return ((function (callback,error_handler_62397,req,body_QMARK_,vec__62166,content_type,body,result_chan,map__62147,map__62147__$1,options,events,upload,body_only){
return (function (e){
var status = req.status;
var body__$1 = (function (){var temp__5718__auto__ = new cljs.core.Keyword(null,"transform","transform",1381301764).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(temp__5718__auto__)){
var transform = temp__5718__auto__;
return transform.call(null,req.responseText,req);
} else {
return shadow.xhr.auto_transform.call(null,req);
}
})();
if(shadow.xhr.request_error_QMARK_.call(null,status)){
return error_handler_62397(e);
} else {
callback(e);

if(cljs.core.truth_(body_only)){
return cljs.core.async.put_BANG_.call(null,result_chan,body__$1);
} else {
return cljs.core.async.put_BANG_.call(null,result_chan,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,body__$1,req], null));
}
}
});
;})(callback,error_handler_62397,req,body_QMARK_,vec__62166,content_type,body,result_chan,map__62147,map__62147__$1,options,events,upload,body_only))
})());

req.open(cljs.core.name.call(null,method),shadow.xhr.as_url.call(null,url),true);

req.responseType = "text";

req.withCredentials = (!(new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235).cljs$core$IFn$_invoke$arity$1(options) === false));

if(body_QMARK_){
req.setRequestHeader("Content-Type",content_type);
} else {
}

if(body_QMARK_){
req.send(body);
} else {
req.send();
}

return result_chan;
});

shadow.xhr.chan.cljs$lang$maxFixedArity = 4;

shadow.xhr.request = (function shadow$xhr$request(var_args){
var G__62232 = arguments.length;
switch (G__62232) {
case 2:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.xhr.request.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.request.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.request.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.request.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.request.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,options){
if((((!(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"DELETE","DELETE",1688673772),null,new cljs.core.Keyword(null,"GET","GET",1736591026),null], null), null),method)))) && ((data == null)))){
throw cljs.core.ex_info.call(null,"request needs data",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),method,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"options","options",99638489),options], null));
} else {
}

var body_QMARK_ = (!(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method)) || ((data == null)))));
var vec__62237 = shadow.xhr.transform_request_body.call(null,data);
var content_type = cljs.core.nth.call(null,vec__62237,(0),null);
var body = cljs.core.nth.call(null,vec__62237,(1),null);
var req = goog.labs.net.xhr.send(cljs.core.name.call(null,method),(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method);
if(and__4120__auto__){
return data;
} else {
return and__4120__auto__;
}
})())?shadow.xhr.make_url.call(null,url,data):url),((body_QMARK_)?body:null),shadow.xhr.make_request_options.call(null,((body_QMARK_)?cljs.core.assoc_in.call(null,options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Content-Type"], null),content_type):options)));
var req__$1 = goog.result.SimpleResult.fromPromise(req);
return goog.result.transform(req__$1,shadow.xhr.auto_transform);
});

shadow.xhr.request.cljs$lang$maxFixedArity = 4;

shadow.xhr.upload = (function shadow$xhr$upload(var_args){
var args__4736__auto__ = [];
var len__4730__auto___62420 = arguments.length;
var i__4731__auto___62421 = (0);
while(true){
if((i__4731__auto___62421 < len__4730__auto___62420)){
args__4736__auto__.push((arguments[i__4731__auto___62421]));

var G__62422 = (i__4731__auto___62421 + (1));
i__4731__auto___62421 = G__62422;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic = (function (url,file,events){
var xhr = (new XMLHttpRequest());
var seq__62249_62423 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),events));
var chunk__62252_62424 = null;
var count__62253_62425 = (0);
var i__62254_62426 = (0);
while(true){
if((i__62254_62426 < count__62253_62425)){
var vec__62280_62428 = cljs.core._nth(chunk__62252_62424,i__62254_62426);
var ev_id_62429 = cljs.core.nth.call(null,vec__62280_62428,(0),null);
var ev_handler_62430 = cljs.core.nth.call(null,vec__62280_62428,(1),null);
var target_62434 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_62429))?(xhr["upload"]):xhr);
target_62434.addEventListener(cljs.core.name.call(null,ev_id_62429),ev_handler_62430);


var G__62436 = seq__62249_62423;
var G__62437 = chunk__62252_62424;
var G__62438 = count__62253_62425;
var G__62439 = (i__62254_62426 + (1));
seq__62249_62423 = G__62436;
chunk__62252_62424 = G__62437;
count__62253_62425 = G__62438;
i__62254_62426 = G__62439;
continue;
} else {
var temp__5720__auto___62440 = cljs.core.seq.call(null,seq__62249_62423);
if(temp__5720__auto___62440){
var seq__62249_62441__$1 = temp__5720__auto___62440;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62249_62441__$1)){
var c__4550__auto___62442 = cljs.core.chunk_first.call(null,seq__62249_62441__$1);
var G__62443 = cljs.core.chunk_rest.call(null,seq__62249_62441__$1);
var G__62444 = c__4550__auto___62442;
var G__62445 = cljs.core.count.call(null,c__4550__auto___62442);
var G__62446 = (0);
seq__62249_62423 = G__62443;
chunk__62252_62424 = G__62444;
count__62253_62425 = G__62445;
i__62254_62426 = G__62446;
continue;
} else {
var vec__62290_62447 = cljs.core.first.call(null,seq__62249_62441__$1);
var ev_id_62448 = cljs.core.nth.call(null,vec__62290_62447,(0),null);
var ev_handler_62449 = cljs.core.nth.call(null,vec__62290_62447,(1),null);
var target_62450 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_62448))?(xhr["upload"]):xhr);
target_62450.addEventListener(cljs.core.name.call(null,ev_id_62448),ev_handler_62449);


var G__62451 = cljs.core.next.call(null,seq__62249_62441__$1);
var G__62452 = null;
var G__62453 = (0);
var G__62454 = (0);
seq__62249_62423 = G__62451;
chunk__62252_62424 = G__62452;
count__62253_62425 = G__62453;
i__62254_62426 = G__62454;
continue;
}
} else {
}
}
break;
}

var G__62296 = xhr;
G__62296.open("PUT",url);

G__62296.send(file);

return G__62296;
});

shadow.xhr.upload.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.xhr.upload.cljs$lang$applyTo = (function (seq62243){
var G__62244 = cljs.core.first.call(null,seq62243);
var seq62243__$1 = cljs.core.next.call(null,seq62243);
var G__62245 = cljs.core.first.call(null,seq62243__$1);
var seq62243__$2 = cljs.core.next.call(null,seq62243__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62244,G__62245,seq62243__$2);
});


//# sourceMappingURL=shadow.xhr.js.map
