(ns ferreira.parser.core
  (:require [com.wsscode.pathom.core :as p]
            [com.wsscode.pathom.connect :as pc]
            [com.wsscode.pathom.sugar :as ps]
            [edn-query-language.core :as eql]
            [com.fulcrologic.guardrails.core :refer [>def >defn >fdef => | <- ?]]
            [schema.core :as s]))

(defmacro my-spec-def [attr docstring spec]
  `(s/def ~attr ~spec))

(comment
  (my-spec-def ))

(pc/defresolver foo [env {:keys []}]
  {::pc/output [:foo]}
  {:foo "test"})

(pc/defresolver foo2 [env {:keys [foo]}]
  {::pc/input  #{:foo}
   ::pc/output [:foo2]}
  (let [params (-> env :ast :params)]
    {:foo2 (str foo " - mais coisa - " (:bla params))}))

(def registry
  [foo
   foo2])

(>def do-something [eql]
  [::eql/query])

(def parser
  (p/parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/reader3
                                            pc/open-ident-reader
                                            p/env-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}}
     ::p/plugins [(pc/connect-plugin {::pc/register registry})
                  p/error-handler-plugin
                  p/trace-plugin]}))

(def cparser (ps/context-parser parser))

(comment


  (select-keys {:foo "bar" :x 42} [:foo])
  (-> (parser {} [::pc/indexes])
      ::pc/indexes
      ::pc/index-oir)

  (parser {} [:foo2])

  (cparser {:foo "IIIII"} '[(:foo2 {:bla "meh"})]))
