(ns rodolfo.parser.core
  (:require [edn-query-language.core :as eql]
            [com.wsscode.pathom.core :as p]
            [com.wsscode.pathom.connect :as pc]))

(defn my-reader [env]
  (+ 1 2)
  ::p/continue)

(def my-parser
  (p/parser {::p/env {::p/reader [my-reader p/map-reader]}}))

(defn make-parser [{:keys [read]}]
  (fn parser [env query]
    (let [ast (eql/query->ast query)
          env (assoc env :parser parser)]
      (reduce
        (fn [out {:keys [key] :as node}]
          (let [env (assoc env :ast node)]
            (assoc out key (read env))))
        {}
        (:children ast)))))

(def domain
  {:math/pi Math/PI})

(comment
  (pc/register {}
    [(pc/resolver 'foo {::pc/output [:a]} (fn [_ _]))
     (pc/resolver 'foo2 {::pc/input  #{:a}
                         ::pc/output [:b]} (fn [_ _]))
     (pc/resolver 'b2 {::pc/output [:b]} (fn [_ _]))])

  (pc/compute-paths )

  p/entity
  (my-parser {::p/entity (atom {:foo {:a 1 :b 2}
                                :bar [{:a 3 :b 4}
                                      {:a 44 :b 44}]})}
    [{:foo [:a]}
     {:bar [:b]}])

  (eql/query->ast [:math/eee {:today [:day]}])

  (let [parser (make-parser {:read (comp domain :key :ast)})]
    (parser {} [:math/pi {:today [:day]} {}]))

  (let [parser (make-parser {:read (fn [{:keys [ast parser] :as env}]
                                     (if (and (:children ast) (= :today (:key ast)))
                                       (parser env (:query ast))
                                       (domain (:key ast))))})]
    (parser {} [:today]))

  (eql/query->ast ^:aaaaa [{(list :needle/search-results {:needle/search-term "nuconta"}) [:needle/items]}]))
