goog.provide('fulcro.client.impl.application');
goog.require('cljs.core');
goog.require('fulcro.logging');
goog.require('fulcro.client.primitives');
goog.require('fulcro.client.mutations');
goog.require('fulcro.history');
goog.require('clojure.set');
goog.require('fulcro.client.impl.data_fetch');
goog.require('fulcro.util');
goog.require('fulcro.client.util');
goog.require('cljs.spec.alpha');
goog.require('cljs.core.async');
goog.require('fulcro.client.network');
goog.require('fulcro.client.impl.protocols');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming transaction, which is in turn used by the error-handling logic of the plumbing.
 */
fulcro.client.impl.application.fallback_handler = (function fulcro$client$impl$application$fallback_handler(p__66003,query){
var map__66004 = p__66003;
var map__66004__$1 = (((((!((map__66004 == null))))?(((((map__66004.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66004.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66004):map__66004);
var reconciler = cljs.core.get.call(null,map__66004__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__66004,map__66004__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,fulcro.client.primitives.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("fulcro","server-error","fulcro/server-error",-1254037316),error);

var temp__5718__auto__ = fulcro.client.primitives.fallback_tx.call(null,query,error);
if(cljs.core.truth_(temp__5718__auto__)){
var q = temp__5718__auto__;
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),25], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Transaction failed. Running fallback.",q);
}catch (e66008){if((e66008 instanceof Error)){
var e__54502__auto___66843 = e66008;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),25], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto___66843);
} else {
throw e66008;

}
}
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,q);
} else {
try{return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),27], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Fallback triggered, but no fallbacks were defined.");
}catch (e66009){if((e66009 instanceof Error)){
var e__54502__auto__ = e66009;
return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),27], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto__);
} else {
throw e66009;

}
}}
});
;})(map__66004,map__66004__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
fulcro.client.impl.application._enqueue = (function fulcro$client$impl$application$_enqueue(reconciler,remote,q,v){
fulcro.client.primitives.add_pending_request.call(null,reconciler,remote,v);

var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__){
return (function (state_66014){
var state_val_66015 = (state_66014[(1)]);
if((state_val_66015 === (1))){
var state_66014__$1 = state_66014;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_66014__$1,(2),q,v);
} else {
if((state_val_66015 === (2))){
var inst_66012 = (state_66014[(2)]);
var state_66014__$1 = state_66014;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66014__$1,inst_66012);
} else {
return null;
}
}
});})(c__54028__auto__))
;
return ((function (switch__53637__auto__,c__54028__auto__){
return (function() {
var fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto__ = null;
var fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto____0 = (function (){
var statearr_66018 = [null,null,null,null,null,null,null];
(statearr_66018[(0)] = fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto__);

(statearr_66018[(1)] = (1));

return statearr_66018;
});
var fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto____1 = (function (state_66014){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_66014);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e66019){if((e66019 instanceof Object)){
var ex__53641__auto__ = e66019;
var statearr_66020_66845 = state_66014;
(statearr_66020_66845[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66014);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66019;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66848 = state_66014;
state_66014 = G__66848;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto__ = function(state_66014){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto____0.call(this);
case 1:
return fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto____1.call(this,state_66014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto____0;
fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto____1;
return fulcro$client$impl$application$_enqueue_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__))
})();
var state__54030__auto__ = (function (){var statearr_66022 = f__54029__auto__();
(statearr_66022[(6)] = c__54028__auto__);

return statearr_66022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__))
);

return c__54028__auto__;
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.client.impl.application","-enqueue","fulcro.client.impl.application/-enqueue",-1535560443,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"any?","any?",-1959531460),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"queue","queue",1455835879),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"payload","payload",-383036092),new cljs.core.Keyword("fulcro.client.impl.data-fetch","payload","fulcro.client.impl.data-fetch/payload",1553254295))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"any?","any?",-1959531460),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"queue","queue",1455835879),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"payload","payload",-383036092),new cljs.core.Keyword("fulcro.client.impl.data-fetch","payload","fulcro.client.impl.data-fetch/payload",1553254295)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"queue","queue",1455835879),new cljs.core.Keyword(null,"payload","payload",-383036092)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"any?","any?",-1959531460),cljs.core.keyword_QMARK_,cljs.core.any_QMARK_,new cljs.core.Keyword("fulcro.client.impl.data-fetch","payload","fulcro.client.impl.data-fetch/payload",1553254295)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"any?","any?",-1959531460),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword("fulcro.client.impl.data-fetch","payload","fulcro.client.impl.data-fetch/payload",1553254295)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"any?","any?",-1959531460),new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"queue","queue",1455835879),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"payload","payload",-383036092),new cljs.core.Keyword("fulcro.client.impl.data-fetch","payload","fulcro.client.impl.data-fetch/payload",1553254295)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response. DEPRECATED: If
 *   you're doing something really low-level with networking, use send-with-history-tracking.
 */
fulcro.client.impl.application.real_send = (function fulcro$client$impl$application$real_send(var_args){
var G__66028 = arguments.length;
switch (G__66028) {
case 2:
return fulcro.client.impl.application.real_send.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 5:
return fulcro.client.impl.application.real_send.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.application.real_send.cljs$core$IFn$_invoke$arity$2 = (function (net,p__66030){
var map__66032 = p__66030;
var map__66032__$1 = (((((!((map__66032 == null))))?(((((map__66032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66032.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66032):map__66032);
var reconciler = cljs.core.get.call(null,map__66032__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var tx = cljs.core.get.call(null,map__66032__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var on_done = cljs.core.get.call(null,map__66032__$1,new cljs.core.Keyword(null,"on-done","on-done",-699252077));
var on_error = cljs.core.get.call(null,map__66032__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var on_load = cljs.core.get.call(null,map__66032__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var abort_id = cljs.core.get.call(null,map__66032__$1,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819));
var progress_tx = ((function (map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id){
return (function (p1__66025_SHARP_){
return fulcro.client.mutations.progressive_update_transaction.call(null,tx,p1__66025_SHARP_);
});})(map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id))
;
var tx__$1 = fulcro.client.primitives.strip_ui.call(null,tx);
if((((!((net == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === net.fulcro$client$network$ProgressiveTransfer$))))?true:false):false)){
return fulcro.client.network.updating_send(net,tx__$1,on_done,on_error,on_load);
} else {
if((((!((net == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === net.fulcro$client$network$FulcroNetwork$))))?true:false):false)){
return fulcro.client.network.send(net,tx__$1,on_done,on_error);
} else {
if((((!((net == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === net.fulcro$client$network$FulcroRemoteI$))))?true:false):false)){
var on_done__$1 = ((function (progress_tx,tx__$1,map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id){
return (function (p__66040){
var map__66041 = p__66040;
var map__66041__$1 = (((((!((map__66041 == null))))?(((((map__66041.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66041.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66041):map__66041);
var body = cljs.core.get.call(null,map__66041__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var transaction = cljs.core.get.call(null,map__66041__$1,new cljs.core.Keyword(null,"transaction","transaction",1777321997));
return on_done.call(null,body,transaction);
});})(progress_tx,tx__$1,map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id))
;
var on_error__$1 = ((function (on_done__$1,progress_tx,tx__$1,map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id){
return (function (p__66045){
var map__66046 = p__66045;
var map__66046__$1 = (((((!((map__66046 == null))))?(((((map__66046.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66046.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66046):map__66046);
var body = cljs.core.get.call(null,map__66046__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
return on_error.call(null,body);
});})(on_done__$1,progress_tx,tx__$1,map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id))
;
var on_load__$1 = ((function (on_done__$1,on_error__$1,progress_tx,tx__$1,map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id){
return (function (progress){
if(cljs.core.truth_(reconciler)){
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,progress_tx(progress));
} else {
return null;
}
});})(on_done__$1,on_error__$1,progress_tx,tx__$1,map__66032,map__66032__$1,reconciler,tx,on_done,on_error,on_load,abort_id))
;
return fulcro.client.network.transmit(net,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957),tx__$1,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267),abort_id,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727),on_done__$1,new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226),on_error__$1,new cljs.core.Keyword("fulcro.client.network","progress-handler","fulcro.client.network/progress-handler",1886593355),on_load__$1], null));
} else {
return null;
}
}
}
});

fulcro.client.impl.application.real_send.cljs$core$IFn$_invoke$arity$5 = (function (net,tx,on_done,on_error,on_load){
return fulcro.client.impl.application.real_send.call(null,net,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_done,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error,new cljs.core.Keyword(null,"on-load","on-load",1415151594),on_load], null));
});

fulcro.client.impl.application.real_send.cljs$lang$maxFixedArity = 5;

/**
 * Does a real send but includes history activity tracking to prevent the gc of history that is related to active
 *   network requests. If you're doing something really low level in the networking, you want this over real-send.
 */
fulcro.client.impl.application.send_with_history_tracking = (function fulcro$client$impl$application$send_with_history_tracking(var_args){
var G__66053 = arguments.length;
switch (G__66053) {
case 2:
return fulcro.client.impl.application.send_with_history_tracking.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fulcro.client.impl.application.send_with_history_tracking.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.application.send_with_history_tracking.cljs$core$IFn$_invoke$arity$2 = (function (net,p__66059){
var map__66060 = p__66059;
var map__66060__$1 = (((((!((map__66060 == null))))?(((((map__66060.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66060.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66060):map__66060);
var reconciler = cljs.core.get.call(null,map__66060__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var payload = cljs.core.get.call(null,map__66060__$1,new cljs.core.Keyword(null,"payload","payload",-383036092));
var tx = cljs.core.get.call(null,map__66060__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var on_done = cljs.core.get.call(null,map__66060__$1,new cljs.core.Keyword(null,"on-done","on-done",-699252077));
var on_error = cljs.core.get.call(null,map__66060__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var on_load = cljs.core.get.call(null,map__66060__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var map__66065 = payload;
var map__66065__$1 = (((((!((map__66065 == null))))?(((((map__66065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66065.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66065):map__66065);
var history_atom = cljs.core.get.call(null,map__66065__$1,new cljs.core.Keyword("fulcro.history","history-atom","fulcro.history/history-atom",-1250797564));
var tx_time = cljs.core.get.call(null,map__66065__$1,new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456));
var remote = cljs.core.get.call(null,map__66065__$1,new cljs.core.Keyword("fulcro.client.primitives","remote","fulcro.client.primitives/remote",82057012));
var abort_id = cljs.core.get.call(null,map__66065__$1,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267));
var uuid = fulcro.util.unique_key.call(null);
var network_activity = fulcro.client.primitives.get_network_activity.call(null,reconciler);
var with_network_activity_tracking = ((function (map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load){
return (function (handler){
return ((function (map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load){
return (function (resp,items_or_tx){
cljs.core.swap_BANG_.call(null,network_activity,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [remote,new cljs.core.Keyword(null,"active-requests","active-requests",1354177961)], null),((function (map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load){
return (function (p1__66049_SHARP_){
return cljs.core.dissoc.call(null,p1__66049_SHARP_,uuid);
});})(map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load))
);

setTimeout(((function (map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"active-requests","active-requests",1354177961).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,cljs.core.deref.call(null,network_activity),remote))),(0))){
cljs.core.swap_BANG_.call(null,fulcro.client.primitives.app_state.call(null,reconciler),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.network","status","fulcro.client.network/status",570358457),remote], null),new cljs.core.Keyword(null,"idle","idle",-2007156861));

cljs.core.swap_BANG_.call(null,network_activity,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [remote,new cljs.core.Keyword(null,"status","status",-1997798413)], null),new cljs.core.Keyword(null,"idle","idle",-2007156861));

return fulcro.client.impl.protocols.queue_BANG_(reconciler,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.network","status","fulcro.client.network/status",570358457)], null));
} else {
return null;
}
});})(map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load))
,(0));

return handler.call(null,resp,items_or_tx);
});
;})(map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load))
});})(map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load))
;
var with_history_recording = ((function (map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,with_network_activity_tracking,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load){
return (function (handler){
return ((function (map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,with_network_activity_tracking,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load){
return (function (resp,items_or_tx){
if(cljs.core.truth_((function (){var and__4120__auto__ = history_atom;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = remote;
if(cljs.core.truth_(and__4120__auto____$1)){
return tx_time;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,history_atom,fulcro.history.remote_activity_finished,remote,tx_time);
} else {
}

return handler.call(null,resp,items_or_tx);
});
;})(map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,with_network_activity_tracking,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load))
});})(map__66065,map__66065__$1,history_atom,tx_time,remote,abort_id,uuid,network_activity,with_network_activity_tracking,map__66060,map__66060__$1,reconciler,payload,tx,on_done,on_error,on_load))
;
var on_done__$1 = with_network_activity_tracking(with_history_recording(on_done));
var on_error__$1 = with_network_activity_tracking(with_history_recording(on_error));
if(cljs.core.truth_((function (){var and__4120__auto__ = history_atom;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = tx_time;
if(cljs.core.truth_(and__4120__auto____$1)){
return remote;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,history_atom,fulcro.history.remote_activity_started,remote,tx_time);
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),89], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Payload had no history details.");
}catch (e66081){if((e66081 instanceof Error)){
var e__54502__auto___66875 = e66081;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),89], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto___66875);
} else {
throw e66081;

}
}}

cljs.core.swap_BANG_.call(null,network_activity,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [remote,new cljs.core.Keyword(null,"active-requests","active-requests",1354177961)], null),cljs.core.assoc,uuid,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758).cljs$core$IFn$_invoke$arity$1(payload),new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267).cljs$core$IFn$_invoke$arity$1(payload)], null));

return fulcro.client.impl.application.real_send.call(null,net,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_done__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594),on_load,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),abort_id], null));
});

fulcro.client.impl.application.send_with_history_tracking.cljs$core$IFn$_invoke$arity$6 = (function (payload,net,tx,on_done,on_error,on_load){
return fulcro.client.impl.application.send_with_history_tracking.call(null,net,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"payload","payload",-383036092),payload,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_done,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error,new cljs.core.Keyword(null,"on-load","on-load",1415151594),on_load], null));
});

fulcro.client.impl.application.send_with_history_tracking.cljs$lang$maxFixedArity = 6;

/**
 * Split a tx that contains mutations.
 * 
 * Examples:
 * [(f) (g)] => [[(f) (g)]]
 * [(f) (g) (f) (k)] => [[(f) (g)] [(f) (k)]]
 * [(f) (g) (f) (k) (g)] => [[(f) (g)] [(f) (k) (g)]]
 * 
 * This function splits any mutation that uses the same dispatch symbol more than once (since returns from server go
 * into a map, and that is the only way to get return values from both), and also when the mutations do not share abort
 * IDs (so that mutations do not get grouped into a transaction that could cause them to get cancelled incorrectly).
 * 
 * Returns a sequence that contains one or more transactions.
 */
fulcro.client.impl.application.split_mutations = (function fulcro$client$impl$application$split_mutations(tx){
if((!(((cljs.core.vector_QMARK_.call(null,tx)) && (cljs.core.every_QMARK_.call(null,(function (t){
return ((fulcro.util.mutation_join_QMARK_.call(null,t)) || (((cljs.core.list_QMARK_.call(null,t)) && ((cljs.core.first.call(null,t) instanceof cljs.core.Symbol)))));
}),tx)))))){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),112], null),new cljs.core.Keyword(null,"error","error",-978969032),"INTERNAL ERROR: split-mutations was asked to split a tx that contained things other than mutations.",tx);
}catch (e66087){if((e66087 instanceof Error)){
var e__54502__auto___66885 = e66087;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),112], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___66885);
} else {
throw e66087;

}
}
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tx], null);
} else {
if(cljs.core.empty_QMARK_.call(null,tx)){
return cljs.core.PersistentVector.EMPTY;
} else {
var dispatch_symbols = (function (tx__$1){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"key","key",-1516042587)),cljs.core.filter.call(null,cljs.core.symbol_QMARK_)),(function (){var G__66090 = tx__$1;
var G__66090__$1 = (((G__66090 == null))?null:fulcro.client.primitives.query__GT_ast.call(null,G__66090));
if((G__66090__$1 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__66090__$1);
}
})());
});
var compatible_abort_QMARK_ = ((function (dispatch_symbols){
return (function (tx1,tx2){
var a1 = fulcro.client.mutations.abort_ids.call(null,tx1);
var a2 = fulcro.client.mutations.abort_ids.call(null,tx2);
return ((((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,a1))) && (cljs.core._EQ_.call(null,a1,a2)))) || (((cljs.core.empty_QMARK_.call(null,a1)) && (cljs.core.empty_QMARK_.call(null,a2)))));
});})(dispatch_symbols))
;
var can_be_included_QMARK_ = ((function (dispatch_symbols,compatible_abort_QMARK_){
return (function (tx__$1,expr){
return ((cljs.core.empty_QMARK_.call(null,tx__$1)) || (((compatible_abort_QMARK_(tx__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [expr], null))) && (cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,dispatch_symbols(tx__$1),dispatch_symbols(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [expr], null))))))));
});})(dispatch_symbols,compatible_abort_QMARK_))
;
var map__66089 = cljs.core.reduce.call(null,((function (dispatch_symbols,compatible_abort_QMARK_,can_be_included_QMARK_){
return (function (p__66095,expr){
var map__66096 = p__66095;
var map__66096__$1 = (((((!((map__66096 == null))))?(((((map__66096.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66096.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66096):map__66096);
var acc = map__66096__$1;
var current = cljs.core.get.call(null,map__66096__$1,new cljs.core.Keyword(null,"current","current",-1088038603));
if(can_be_included_QMARK_(current,expr)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"current","current",-1088038603),cljs.core.conj,expr);
} else {
return cljs.core.assoc.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"transactions","transactions",-1425846118),cljs.core.conj,current),new cljs.core.Keyword(null,"current","current",-1088038603),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [expr], null));
}
});})(dispatch_symbols,compatible_abort_QMARK_,can_be_included_QMARK_))
,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"transactions","transactions",-1425846118),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"current","current",-1088038603),cljs.core.PersistentVector.EMPTY], null),tx);
var map__66089__$1 = (((((!((map__66089 == null))))?(((((map__66089.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66089.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66089):map__66089);
var transactions = cljs.core.get.call(null,map__66089__$1,new cljs.core.Keyword(null,"transactions","transactions",-1425846118));
var current = cljs.core.get.call(null,map__66089__$1,new cljs.core.Keyword(null,"current","current",-1088038603));
if(cljs.core.empty_QMARK_.call(null,current)){
return transactions;
} else {
return cljs.core.conj.call(null,transactions,current);
}
}
}
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue. If duplicate mutation names
 * appear, then they will be separated into separate network requests.
 * 
 * NOTE: If the mutation in the tx has duplicates, then the same fallback will be used for the
 * resulting split tx. See `split-mutations` (which is used by this function to split dupes out of txes).
 */
fulcro.client.impl.application.enqueue_mutations = (function fulcro$client$impl$application$enqueue_mutations(p__66104,remote_tx_map,cb){
var map__66105 = p__66104;
var map__66105__$1 = (((((!((map__66105 == null))))?(((((map__66105.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66105.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66105):map__66105);
var app = map__66105__$1;
var reconciler = cljs.core.get.call(null,map__66105__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__66105__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var history = fulcro.client.primitives.get_history.call(null,reconciler);
var seq__66107 = cljs.core.seq.call(null,cljs.core.keys.call(null,remote_tx_map));
var chunk__66108 = null;
var count__66109 = (0);
var i__66110 = (0);
while(true){
if((i__66110 < count__66109)){
var remote = cljs.core._nth(chunk__66108,i__66110);
var queue_66901 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_66902 = cljs.core.get.call(null,remote_tx_map,remote);
var refresh_set_66903 = (function (){var or__4131__auto__ = (function (){var G__66150 = full_remote_transaction_66902;
var G__66150__$1 = (((G__66150 == null))?null:cljs.core.meta.call(null,G__66150));
var G__66150__$2 = (((G__66150__$1 == null))?null:new cljs.core.Keyword("fulcro.client.primitives","refresh","fulcro.client.primitives/refresh",481513561).cljs$core$IFn$_invoke$arity$1(G__66150__$1));
if((G__66150__$2 == null)){
return null;
} else {
return cljs.core.vec.call(null,G__66150__$2);
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
var tx_time_66904 = (function (){var G__66154 = full_remote_transaction_66902;
var G__66154__$1 = (((G__66154 == null))?null:cljs.core.meta.call(null,G__66154));
if((G__66154__$1 == null)){
return null;
} else {
return new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456).cljs$core$IFn$_invoke$arity$1(G__66154__$1);
}
})();
var fallback_66905 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_66902);
var desired_remote_mutations_66906 = fulcro.client.primitives.remove_loads_and_fallbacks.call(null,full_remote_transaction_66902);
var tx_list_66907 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_66906);
var has_mutations_QMARK__66908 = ((function (seq__66107,chunk__66108,count__66109,i__66110,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__66107,chunk__66108,count__66109,i__66110,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues))
;
var payload_66909 = ((function (seq__66107,chunk__66108,count__66109,i__66110,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,has_mutations_QMARK__66908,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (tx){
var abort_id = (function (){var G__66158 = tx;
var G__66158__$1 = (((G__66158 == null))?null:fulcro.client.mutations.abort_ids.call(null,G__66158));
if((G__66158__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__66158__$1);
}
})();
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758),tx,new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),tx_time_66904,new cljs.core.Keyword("fulcro.history","history-atom","fulcro.history/history-atom",-1250797564),history,new cljs.core.Keyword("fulcro.client.primitives","remote","fulcro.client.primitives/remote",82057012),remote,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267),abort_id,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-load","fulcro.client.impl.data-fetch/on-load",-1170993603),((function (seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,has_mutations_QMARK__66908,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (result,mtx){
return cb.call(null,result,(function (){var or__4131__auto__ = mtx;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return tx;
}
})(),remote);
});})(seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,has_mutations_QMARK__66908,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues))
,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-error","fulcro.client.impl.data-fetch/on-error",867419629),((function (seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,has_mutations_QMARK__66908,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (result){
return fallback_66905(result);
});})(seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,has_mutations_QMARK__66908,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues))
], null);
});})(seq__66107,chunk__66108,count__66109,i__66110,queue_66901,full_remote_transaction_66902,refresh_set_66903,tx_time_66904,fallback_66905,desired_remote_mutations_66906,tx_list_66907,has_mutations_QMARK__66908,remote,history,map__66105,map__66105__$1,app,reconciler,send_queues))
;
var seq__66163_66921 = cljs.core.seq.call(null,tx_list_66907);
var chunk__66164_66922 = null;
var count__66165_66923 = (0);
var i__66166_66924 = (0);
while(true){
if((i__66166_66924 < count__66165_66923)){
var tx_66926 = cljs.core._nth(chunk__66164_66922,i__66166_66924);
if(has_mutations_QMARK__66908(tx_66926)){
fulcro.client.impl.application._enqueue.call(null,reconciler,remote,queue_66901,payload_66909(tx_66926));
} else {
}


var G__66930 = seq__66163_66921;
var G__66931 = chunk__66164_66922;
var G__66932 = count__66165_66923;
var G__66933 = (i__66166_66924 + (1));
seq__66163_66921 = G__66930;
chunk__66164_66922 = G__66931;
count__66165_66923 = G__66932;
i__66166_66924 = G__66933;
continue;
} else {
var temp__5720__auto___66934 = cljs.core.seq.call(null,seq__66163_66921);
if(temp__5720__auto___66934){
var seq__66163_66935__$1 = temp__5720__auto___66934;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66163_66935__$1)){
var c__4550__auto___66937 = cljs.core.chunk_first.call(null,seq__66163_66935__$1);
var G__66939 = cljs.core.chunk_rest.call(null,seq__66163_66935__$1);
var G__66940 = c__4550__auto___66937;
var G__66941 = cljs.core.count.call(null,c__4550__auto___66937);
var G__66942 = (0);
seq__66163_66921 = G__66939;
chunk__66164_66922 = G__66940;
count__66165_66923 = G__66941;
i__66166_66924 = G__66942;
continue;
} else {
var tx_66944 = cljs.core.first.call(null,seq__66163_66935__$1);
if(has_mutations_QMARK__66908(tx_66944)){
fulcro.client.impl.application._enqueue.call(null,reconciler,remote,queue_66901,payload_66909(tx_66944));
} else {
}


var G__66945 = cljs.core.next.call(null,seq__66163_66935__$1);
var G__66946 = null;
var G__66947 = (0);
var G__66948 = (0);
seq__66163_66921 = G__66945;
chunk__66164_66922 = G__66946;
count__66165_66923 = G__66947;
i__66166_66924 = G__66948;
continue;
}
} else {
}
}
break;
}


var G__66949 = seq__66107;
var G__66950 = chunk__66108;
var G__66951 = count__66109;
var G__66952 = (i__66110 + (1));
seq__66107 = G__66949;
chunk__66108 = G__66950;
count__66109 = G__66951;
i__66110 = G__66952;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__66107);
if(temp__5720__auto__){
var seq__66107__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66107__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__66107__$1);
var G__66956 = cljs.core.chunk_rest.call(null,seq__66107__$1);
var G__66957 = c__4550__auto__;
var G__66958 = cljs.core.count.call(null,c__4550__auto__);
var G__66959 = (0);
seq__66107 = G__66956;
chunk__66108 = G__66957;
count__66109 = G__66958;
i__66110 = G__66959;
continue;
} else {
var remote = cljs.core.first.call(null,seq__66107__$1);
var queue_66960 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_66961 = cljs.core.get.call(null,remote_tx_map,remote);
var refresh_set_66962 = (function (){var or__4131__auto__ = (function (){var G__66185 = full_remote_transaction_66961;
var G__66185__$1 = (((G__66185 == null))?null:cljs.core.meta.call(null,G__66185));
var G__66185__$2 = (((G__66185__$1 == null))?null:new cljs.core.Keyword("fulcro.client.primitives","refresh","fulcro.client.primitives/refresh",481513561).cljs$core$IFn$_invoke$arity$1(G__66185__$1));
if((G__66185__$2 == null)){
return null;
} else {
return cljs.core.vec.call(null,G__66185__$2);
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
var tx_time_66963 = (function (){var G__66189 = full_remote_transaction_66961;
var G__66189__$1 = (((G__66189 == null))?null:cljs.core.meta.call(null,G__66189));
if((G__66189__$1 == null)){
return null;
} else {
return new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456).cljs$core$IFn$_invoke$arity$1(G__66189__$1);
}
})();
var fallback_66964 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_66961);
var desired_remote_mutations_66965 = fulcro.client.primitives.remove_loads_and_fallbacks.call(null,full_remote_transaction_66961);
var tx_list_66966 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_66965);
var has_mutations_QMARK__66967 = ((function (seq__66107,chunk__66108,count__66109,i__66110,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__66107,chunk__66108,count__66109,i__66110,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues))
;
var payload_66968 = ((function (seq__66107,chunk__66108,count__66109,i__66110,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,has_mutations_QMARK__66967,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (tx){
var abort_id = (function (){var G__66190 = tx;
var G__66190__$1 = (((G__66190 == null))?null:fulcro.client.mutations.abort_ids.call(null,G__66190));
if((G__66190__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__66190__$1);
}
})();
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758),tx,new cljs.core.Keyword("fulcro.history","tx-time","fulcro.history/tx-time",816348456),tx_time_66963,new cljs.core.Keyword("fulcro.history","history-atom","fulcro.history/history-atom",-1250797564),history,new cljs.core.Keyword("fulcro.client.primitives","remote","fulcro.client.primitives/remote",82057012),remote,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267),abort_id,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-load","fulcro.client.impl.data-fetch/on-load",-1170993603),((function (seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,has_mutations_QMARK__66967,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (result,mtx){
return cb.call(null,result,(function (){var or__4131__auto__ = mtx;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return tx;
}
})(),remote);
});})(seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,has_mutations_QMARK__66967,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues))
,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-error","fulcro.client.impl.data-fetch/on-error",867419629),((function (seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,has_mutations_QMARK__66967,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues){
return (function (result){
return fallback_66964(result);
});})(seq__66107,chunk__66108,count__66109,i__66110,abort_id,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,has_mutations_QMARK__66967,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues))
], null);
});})(seq__66107,chunk__66108,count__66109,i__66110,queue_66960,full_remote_transaction_66961,refresh_set_66962,tx_time_66963,fallback_66964,desired_remote_mutations_66965,tx_list_66966,has_mutations_QMARK__66967,remote,seq__66107__$1,temp__5720__auto__,history,map__66105,map__66105__$1,app,reconciler,send_queues))
;
var seq__66197_66990 = cljs.core.seq.call(null,tx_list_66966);
var chunk__66198_66991 = null;
var count__66199_66992 = (0);
var i__66200_66993 = (0);
while(true){
if((i__66200_66993 < count__66199_66992)){
var tx_66994 = cljs.core._nth(chunk__66198_66991,i__66200_66993);
if(has_mutations_QMARK__66967(tx_66994)){
fulcro.client.impl.application._enqueue.call(null,reconciler,remote,queue_66960,payload_66968(tx_66994));
} else {
}


var G__66995 = seq__66197_66990;
var G__66996 = chunk__66198_66991;
var G__66997 = count__66199_66992;
var G__66998 = (i__66200_66993 + (1));
seq__66197_66990 = G__66995;
chunk__66198_66991 = G__66996;
count__66199_66992 = G__66997;
i__66200_66993 = G__66998;
continue;
} else {
var temp__5720__auto___66999__$1 = cljs.core.seq.call(null,seq__66197_66990);
if(temp__5720__auto___66999__$1){
var seq__66197_67000__$1 = temp__5720__auto___66999__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66197_67000__$1)){
var c__4550__auto___67001 = cljs.core.chunk_first.call(null,seq__66197_67000__$1);
var G__67002 = cljs.core.chunk_rest.call(null,seq__66197_67000__$1);
var G__67003 = c__4550__auto___67001;
var G__67004 = cljs.core.count.call(null,c__4550__auto___67001);
var G__67005 = (0);
seq__66197_66990 = G__67002;
chunk__66198_66991 = G__67003;
count__66199_66992 = G__67004;
i__66200_66993 = G__67005;
continue;
} else {
var tx_67006 = cljs.core.first.call(null,seq__66197_67000__$1);
if(has_mutations_QMARK__66967(tx_67006)){
fulcro.client.impl.application._enqueue.call(null,reconciler,remote,queue_66960,payload_66968(tx_67006));
} else {
}


var G__67007 = cljs.core.next.call(null,seq__66197_67000__$1);
var G__67008 = null;
var G__67009 = (0);
var G__67010 = (0);
seq__66197_66990 = G__67007;
chunk__66198_66991 = G__67008;
count__66199_66992 = G__67009;
i__66200_66993 = G__67010;
continue;
}
} else {
}
}
break;
}


var G__67013 = cljs.core.next.call(null,seq__66107__$1);
var G__67014 = null;
var G__67015 = (0);
var G__67016 = (0);
seq__66107 = G__67013;
chunk__66108 = G__67014;
count__66109 = G__67015;
i__66110 = G__67016;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
fulcro.client.impl.application.enqueue_reads = (function fulcro$client$impl$application$enqueue_reads(p__66226){
var map__66231 = p__66226;
var map__66231__$1 = (((((!((map__66231 == null))))?(((((map__66231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66231.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66231):map__66231);
var send_queues = cljs.core.get.call(null,map__66231__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var reconciler = cljs.core.get.call(null,map__66231__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__66231__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var seq__66239 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__66240 = null;
var count__66241 = (0);
var i__66242 = (0);
while(true){
if((i__66242 < count__66241)){
var remote = cljs.core._nth(chunk__66240,i__66242);
var queue_67020 = cljs.core.get.call(null,send_queues,remote);
var network_67021 = cljs.core.get.call(null,networking,remote);
var parallel_payload_67022 = fulcro.client.impl.data_fetch.mark_parallel_loading_BANG_.call(null,remote,reconciler);
var seq__66402_67024 = cljs.core.seq.call(null,parallel_payload_67022);
var chunk__66403_67025 = null;
var count__66404_67026 = (0);
var i__66405_67027 = (0);
while(true){
if((i__66405_67027 < count__66404_67026)){
var map__66424_67031 = cljs.core._nth(chunk__66403_67025,i__66405_67027);
var map__66424_67032__$1 = (((((!((map__66424_67031 == null))))?(((((map__66424_67031.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66424_67031.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66424_67031):map__66424_67031);
var payload_67033 = map__66424_67032__$1;
var query_67034 = cljs.core.get.call(null,map__66424_67032__$1,new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758));
var on_load_67035 = cljs.core.get.call(null,map__66424_67032__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-load","fulcro.client.impl.data-fetch/on-load",-1170993603));
var on_error_67036 = cljs.core.get.call(null,map__66424_67032__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-error","fulcro.client.impl.data-fetch/on-error",867419629));
var load_descriptors_67037 = cljs.core.get.call(null,map__66424_67032__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","load-descriptors","fulcro.client.impl.data-fetch/load-descriptors",1275690424));
var abort_id_67038 = cljs.core.get.call(null,map__66424_67032__$1,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267));
var on_load_SINGLEQUOTE__67041 = ((function (seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,map__66424_67031,map__66424_67032__$1,payload_67033,query_67034,on_load_67035,on_error_67036,load_descriptors_67037,abort_id_67038,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66223_SHARP_){
return on_load_67035.call(null,p1__66223_SHARP_,load_descriptors_67037);
});})(seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,map__66424_67031,map__66424_67032__$1,payload_67033,query_67034,on_load_67035,on_error_67036,load_descriptors_67037,abort_id_67038,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__67042 = ((function (seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67041,map__66424_67031,map__66424_67032__$1,payload_67033,query_67034,on_load_67035,on_error_67036,load_descriptors_67037,abort_id_67038,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66224_SHARP_){
return on_error_67036.call(null,p1__66224_SHARP_,load_descriptors_67037);
});})(seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67041,map__66424_67031,map__66424_67032__$1,payload_67033,query_67034,on_load_67035,on_error_67036,load_descriptors_67037,abort_id_67038,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.send_with_history_tracking.call(null,network_67021,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"payload","payload",-383036092),payload_67033,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler,new cljs.core.Keyword(null,"tx","tx",466630418),query_67034,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_load_SINGLEQUOTE__67041,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error_SINGLEQUOTE__67042,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),abort_id_67038], null));


var G__67052 = seq__66402_67024;
var G__67053 = chunk__66403_67025;
var G__67054 = count__66404_67026;
var G__67055 = (i__66405_67027 + (1));
seq__66402_67024 = G__67052;
chunk__66403_67025 = G__67053;
count__66404_67026 = G__67054;
i__66405_67027 = G__67055;
continue;
} else {
var temp__5720__auto___67056 = cljs.core.seq.call(null,seq__66402_67024);
if(temp__5720__auto___67056){
var seq__66402_67057__$1 = temp__5720__auto___67056;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66402_67057__$1)){
var c__4550__auto___67059 = cljs.core.chunk_first.call(null,seq__66402_67057__$1);
var G__67061 = cljs.core.chunk_rest.call(null,seq__66402_67057__$1);
var G__67062 = c__4550__auto___67059;
var G__67063 = cljs.core.count.call(null,c__4550__auto___67059);
var G__67064 = (0);
seq__66402_67024 = G__67061;
chunk__66403_67025 = G__67062;
count__66404_67026 = G__67063;
i__66405_67027 = G__67064;
continue;
} else {
var map__66431_67066 = cljs.core.first.call(null,seq__66402_67057__$1);
var map__66431_67067__$1 = (((((!((map__66431_67066 == null))))?(((((map__66431_67066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66431_67066.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66431_67066):map__66431_67066);
var payload_67068 = map__66431_67067__$1;
var query_67069 = cljs.core.get.call(null,map__66431_67067__$1,new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758));
var on_load_67070 = cljs.core.get.call(null,map__66431_67067__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-load","fulcro.client.impl.data-fetch/on-load",-1170993603));
var on_error_67071 = cljs.core.get.call(null,map__66431_67067__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-error","fulcro.client.impl.data-fetch/on-error",867419629));
var load_descriptors_67072 = cljs.core.get.call(null,map__66431_67067__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","load-descriptors","fulcro.client.impl.data-fetch/load-descriptors",1275690424));
var abort_id_67073 = cljs.core.get.call(null,map__66431_67067__$1,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267));
var on_load_SINGLEQUOTE__67075 = ((function (seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,map__66431_67066,map__66431_67067__$1,payload_67068,query_67069,on_load_67070,on_error_67071,load_descriptors_67072,abort_id_67073,seq__66402_67057__$1,temp__5720__auto___67056,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66223_SHARP_){
return on_load_67070.call(null,p1__66223_SHARP_,load_descriptors_67072);
});})(seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,map__66431_67066,map__66431_67067__$1,payload_67068,query_67069,on_load_67070,on_error_67071,load_descriptors_67072,abort_id_67073,seq__66402_67057__$1,temp__5720__auto___67056,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__67076 = ((function (seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67075,map__66431_67066,map__66431_67067__$1,payload_67068,query_67069,on_load_67070,on_error_67071,load_descriptors_67072,abort_id_67073,seq__66402_67057__$1,temp__5720__auto___67056,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66224_SHARP_){
return on_error_67071.call(null,p1__66224_SHARP_,load_descriptors_67072);
});})(seq__66402_67024,chunk__66403_67025,count__66404_67026,i__66405_67027,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67075,map__66431_67066,map__66431_67067__$1,payload_67068,query_67069,on_load_67070,on_error_67071,load_descriptors_67072,abort_id_67073,seq__66402_67057__$1,temp__5720__auto___67056,queue_67020,network_67021,parallel_payload_67022,remote,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.send_with_history_tracking.call(null,network_67021,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"payload","payload",-383036092),payload_67068,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler,new cljs.core.Keyword(null,"tx","tx",466630418),query_67069,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_load_SINGLEQUOTE__67075,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error_SINGLEQUOTE__67076,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),abort_id_67073], null));


var G__67085 = cljs.core.next.call(null,seq__66402_67057__$1);
var G__67086 = null;
var G__67087 = (0);
var G__67088 = (0);
seq__66402_67024 = G__67085;
chunk__66403_67025 = G__67086;
count__66404_67026 = G__67087;
i__66405_67027 = G__67088;
continue;
}
} else {
}
}
break;
}

var fetch_payload_67090 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_67090)){
fulcro.client.impl.application._enqueue.call(null,reconciler,remote,queue_67020,cljs.core.assoc.call(null,fetch_payload_67090,new cljs.core.Keyword(null,"networking","networking",586110628),network_67021));

var G__67091 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_67090 = G__67091;
continue;
} else {
}
break;
}


var G__67092 = seq__66239;
var G__67093 = chunk__66240;
var G__67094 = count__66241;
var G__67095 = (i__66242 + (1));
seq__66239 = G__67092;
chunk__66240 = G__67093;
count__66241 = G__67094;
i__66242 = G__67095;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__66239);
if(temp__5720__auto__){
var seq__66239__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66239__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__66239__$1);
var G__67099 = cljs.core.chunk_rest.call(null,seq__66239__$1);
var G__67100 = c__4550__auto__;
var G__67101 = cljs.core.count.call(null,c__4550__auto__);
var G__67102 = (0);
seq__66239 = G__67099;
chunk__66240 = G__67100;
count__66241 = G__67101;
i__66242 = G__67102;
continue;
} else {
var remote = cljs.core.first.call(null,seq__66239__$1);
var queue_67104 = cljs.core.get.call(null,send_queues,remote);
var network_67105 = cljs.core.get.call(null,networking,remote);
var parallel_payload_67106 = fulcro.client.impl.data_fetch.mark_parallel_loading_BANG_.call(null,remote,reconciler);
var seq__66441_67107 = cljs.core.seq.call(null,parallel_payload_67106);
var chunk__66442_67108 = null;
var count__66443_67109 = (0);
var i__66444_67110 = (0);
while(true){
if((i__66444_67110 < count__66443_67109)){
var map__66461_67112 = cljs.core._nth(chunk__66442_67108,i__66444_67110);
var map__66461_67113__$1 = (((((!((map__66461_67112 == null))))?(((((map__66461_67112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66461_67112.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66461_67112):map__66461_67112);
var payload_67114 = map__66461_67113__$1;
var query_67115 = cljs.core.get.call(null,map__66461_67113__$1,new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758));
var on_load_67116 = cljs.core.get.call(null,map__66461_67113__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-load","fulcro.client.impl.data-fetch/on-load",-1170993603));
var on_error_67117 = cljs.core.get.call(null,map__66461_67113__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-error","fulcro.client.impl.data-fetch/on-error",867419629));
var load_descriptors_67118 = cljs.core.get.call(null,map__66461_67113__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","load-descriptors","fulcro.client.impl.data-fetch/load-descriptors",1275690424));
var abort_id_67119 = cljs.core.get.call(null,map__66461_67113__$1,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267));
var on_load_SINGLEQUOTE__67123 = ((function (seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,map__66461_67112,map__66461_67113__$1,payload_67114,query_67115,on_load_67116,on_error_67117,load_descriptors_67118,abort_id_67119,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66223_SHARP_){
return on_load_67116.call(null,p1__66223_SHARP_,load_descriptors_67118);
});})(seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,map__66461_67112,map__66461_67113__$1,payload_67114,query_67115,on_load_67116,on_error_67117,load_descriptors_67118,abort_id_67119,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__67124 = ((function (seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67123,map__66461_67112,map__66461_67113__$1,payload_67114,query_67115,on_load_67116,on_error_67117,load_descriptors_67118,abort_id_67119,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66224_SHARP_){
return on_error_67117.call(null,p1__66224_SHARP_,load_descriptors_67118);
});})(seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67123,map__66461_67112,map__66461_67113__$1,payload_67114,query_67115,on_load_67116,on_error_67117,load_descriptors_67118,abort_id_67119,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.send_with_history_tracking.call(null,network_67105,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"payload","payload",-383036092),payload_67114,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler,new cljs.core.Keyword(null,"tx","tx",466630418),query_67115,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_load_SINGLEQUOTE__67123,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error_SINGLEQUOTE__67124,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),abort_id_67119], null));


var G__67126 = seq__66441_67107;
var G__67127 = chunk__66442_67108;
var G__67128 = count__66443_67109;
var G__67129 = (i__66444_67110 + (1));
seq__66441_67107 = G__67126;
chunk__66442_67108 = G__67127;
count__66443_67109 = G__67128;
i__66444_67110 = G__67129;
continue;
} else {
var temp__5720__auto___67130__$1 = cljs.core.seq.call(null,seq__66441_67107);
if(temp__5720__auto___67130__$1){
var seq__66441_67132__$1 = temp__5720__auto___67130__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66441_67132__$1)){
var c__4550__auto___67134 = cljs.core.chunk_first.call(null,seq__66441_67132__$1);
var G__67135 = cljs.core.chunk_rest.call(null,seq__66441_67132__$1);
var G__67136 = c__4550__auto___67134;
var G__67137 = cljs.core.count.call(null,c__4550__auto___67134);
var G__67138 = (0);
seq__66441_67107 = G__67135;
chunk__66442_67108 = G__67136;
count__66443_67109 = G__67137;
i__66444_67110 = G__67138;
continue;
} else {
var map__66469_67139 = cljs.core.first.call(null,seq__66441_67132__$1);
var map__66469_67140__$1 = (((((!((map__66469_67139 == null))))?(((((map__66469_67139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66469_67139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66469_67139):map__66469_67139);
var payload_67141 = map__66469_67140__$1;
var query_67142 = cljs.core.get.call(null,map__66469_67140__$1,new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758));
var on_load_67143 = cljs.core.get.call(null,map__66469_67140__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-load","fulcro.client.impl.data-fetch/on-load",-1170993603));
var on_error_67144 = cljs.core.get.call(null,map__66469_67140__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-error","fulcro.client.impl.data-fetch/on-error",867419629));
var load_descriptors_67145 = cljs.core.get.call(null,map__66469_67140__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","load-descriptors","fulcro.client.impl.data-fetch/load-descriptors",1275690424));
var abort_id_67146 = cljs.core.get.call(null,map__66469_67140__$1,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267));
var on_load_SINGLEQUOTE__67147 = ((function (seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,map__66469_67139,map__66469_67140__$1,payload_67141,query_67142,on_load_67143,on_error_67144,load_descriptors_67145,abort_id_67146,seq__66441_67132__$1,temp__5720__auto___67130__$1,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66223_SHARP_){
return on_load_67143.call(null,p1__66223_SHARP_,load_descriptors_67145);
});})(seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,map__66469_67139,map__66469_67140__$1,payload_67141,query_67142,on_load_67143,on_error_67144,load_descriptors_67145,abort_id_67146,seq__66441_67132__$1,temp__5720__auto___67130__$1,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__67148 = ((function (seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67147,map__66469_67139,map__66469_67140__$1,payload_67141,query_67142,on_load_67143,on_error_67144,load_descriptors_67145,abort_id_67146,seq__66441_67132__$1,temp__5720__auto___67130__$1,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking){
return (function (p1__66224_SHARP_){
return on_error_67144.call(null,p1__66224_SHARP_,load_descriptors_67145);
});})(seq__66441_67107,chunk__66442_67108,count__66443_67109,i__66444_67110,seq__66239,chunk__66240,count__66241,i__66242,on_load_SINGLEQUOTE__67147,map__66469_67139,map__66469_67140__$1,payload_67141,query_67142,on_load_67143,on_error_67144,load_descriptors_67145,abort_id_67146,seq__66441_67132__$1,temp__5720__auto___67130__$1,queue_67104,network_67105,parallel_payload_67106,remote,seq__66239__$1,temp__5720__auto__,map__66231,map__66231__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.send_with_history_tracking.call(null,network_67105,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"payload","payload",-383036092),payload_67141,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler,new cljs.core.Keyword(null,"tx","tx",466630418),query_67142,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_load_SINGLEQUOTE__67147,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error_SINGLEQUOTE__67148,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),abort_id_67146], null));


var G__67153 = cljs.core.next.call(null,seq__66441_67132__$1);
var G__67154 = null;
var G__67155 = (0);
var G__67156 = (0);
seq__66441_67107 = G__67153;
chunk__66442_67108 = G__67154;
count__66443_67109 = G__67155;
i__66444_67110 = G__67156;
continue;
}
} else {
}
}
break;
}

var fetch_payload_67157 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_67157)){
fulcro.client.impl.application._enqueue.call(null,reconciler,remote,queue_67104,cljs.core.assoc.call(null,fetch_payload_67157,new cljs.core.Keyword(null,"networking","networking",586110628),network_67105));

var G__67158 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_67157 = G__67158;
continue;
} else {
}
break;
}


var G__67159 = cljs.core.next.call(null,seq__66239__$1);
var G__67160 = null;
var G__67161 = (0);
var G__67162 = (0);
seq__66239 = G__67159;
chunk__66240 = G__67160;
count__66241 = G__67161;
i__66242 = G__67162;
continue;
}
} else {
return null;
}
}
break;
}
});
fulcro.client.impl.application.detect_errant_remotes = (function fulcro$client$impl$application$detect_errant_remotes(p__66481){
var map__66484 = p__66481;
var map__66484__$1 = (((((!((map__66484 == null))))?(((((map__66484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66484):map__66484);
var app = map__66484__$1;
var reconciler = cljs.core.get.call(null,map__66484__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__66484__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var state = fulcro.client.primitives.app_state.call(null,reconciler);
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var item_remotes = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.data_remote),all_items);
var all_remotes = cljs.core.set.call(null,cljs.core.keys.call(null,send_queues));
var invalid_remotes = clojure.set.difference.call(null,item_remotes,all_remotes);
if(cljs.core.truth_(cljs.core.not_empty.call(null,invalid_remotes))){
try{return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),217], null),new cljs.core.Keyword(null,"error","error",-978969032),"Use of invalid remote(s) detected! ",invalid_remotes);
}catch (e66488){if((e66488 instanceof Error)){
var e__54502__auto__ = e66488;
return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),217], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto__);
} else {
throw e66488;

}
}} else {
return null;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
fulcro.client.impl.application.server_send = (function fulcro$client$impl$application$server_send(app,remote_tx_map,merge_result_callback){
fulcro.client.impl.application.detect_errant_remotes.call(null,app);

fulcro.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,merge_result_callback);

return fulcro.client.impl.application.enqueue_reads.call(null,app);
});
fulcro.client.impl.application.is_sequential_QMARK_ = (function fulcro$client$impl$application$is_sequential_QMARK_(network){
if((((!((network == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === network.fulcro$client$network$NetworkBehavior$))))?true:(((!network.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,fulcro.client.network.NetworkBehavior,network):false)):cljs.core.native_satisfies_QMARK_.call(null,fulcro.client.network.NetworkBehavior,network))){
return fulcro.client.network.serialize_requests_QMARK_(network);
} else {
return true;
}
});
/**
 * Sends a network payload. There are two kinds of payloads in Fulcro. The first is
 *   for reads, which are tracked by load descriptors in the app state. These load descriptors
 *   tell the plumbing how to handle the response, and expect to only be merged in once. Mutations
 *   do not have a payload, and can technically receive progress updates from the network. The built-in
 *   networking does not (currently) give progress events, but plugin networking can. It is currently not
 *   supported to give an update on a load, so this function is careful to detect that a payload is a send
 *   and turns all but the last update into a no-op. The send-complete function comes from the
 *   network sequential processing loop, and when called unblocks the network processing to allow the
 *   next request to go. Be very careful with this code, as bugs will cause applications to stop responding
 *   to remote requests.
 */
fulcro.client.impl.application._send_payload = (function fulcro$client$impl$application$_send_payload(network,reconciler,payload,send_complete){
var map__66501 = payload;
var map__66501__$1 = (((((!((map__66501 == null))))?(((((map__66501.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66501.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66501):map__66501);
var query = cljs.core.get.call(null,map__66501__$1,new cljs.core.Keyword("fulcro.client.primitives","query","fulcro.client.primitives/query",261276758));
var on_load = cljs.core.get.call(null,map__66501__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-load","fulcro.client.impl.data-fetch/on-load",-1170993603));
var on_error = cljs.core.get.call(null,map__66501__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","on-error","fulcro.client.impl.data-fetch/on-error",867419629));
var load_descriptors = cljs.core.get.call(null,map__66501__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","load-descriptors","fulcro.client.impl.data-fetch/load-descriptors",1275690424));
var abort_id = cljs.core.get.call(null,map__66501__$1,new cljs.core.Keyword("fulcro.client.network","abort-id","fulcro.client.network/abort-id",-22430267));
var merge_data = (cljs.core.truth_(load_descriptors)?((function (map__66501,map__66501__$1,query,on_load,on_error,load_descriptors,abort_id){
return (function (p1__66497_SHARP_){
return on_load.call(null,p1__66497_SHARP_,load_descriptors);
});})(map__66501,map__66501__$1,query,on_load,on_error,load_descriptors,abort_id))
:((function (map__66501,map__66501__$1,query,on_load,on_error,load_descriptors,abort_id){
return (function (p1__66498_SHARP_,p2__66499_SHARP_){
return on_load.call(null,p1__66498_SHARP_,p2__66499_SHARP_);
});})(map__66501,map__66501__$1,query,on_load,on_error,load_descriptors,abort_id))
);
var on_update = (cljs.core.truth_(load_descriptors)?cljs.core.identity:merge_data);
var on_error__$1 = (cljs.core.truth_(load_descriptors)?((function (map__66501,map__66501__$1,query,on_load,on_error,load_descriptors,abort_id,merge_data,on_update){
return (function (p1__66500_SHARP_){
return on_error.call(null,p1__66500_SHARP_,load_descriptors);
});})(map__66501,map__66501__$1,query,on_load,on_error,load_descriptors,abort_id,merge_data,on_update))
:on_error);
var on_error__$2 = cljs.core.comp.call(null,send_complete,on_error__$1);
var on_done = cljs.core.comp.call(null,send_complete,merge_data);
if(fulcro.client.impl.data_fetch.is_deferred_transaction_QMARK_.call(null,query)){
on_done(cljs.core.PersistentArrayMap.EMPTY);

if(cljs.core.truth_(fulcro.client.impl.application.is_sequential_QMARK_.call(null,network))){
return null;
} else {
try{return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),256], null),new cljs.core.Keyword(null,"error","error",-978969032),"Attempt to defer a transaction on a non-sequential remote. `ptransact!` will fail to work correctly with `serial? false` remotes.");
}catch (e66504){if((e66504 instanceof Error)){
var e__54502__auto__ = e66504;
return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),256], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto__);
} else {
throw e66504;

}
}}
} else {
return fulcro.client.impl.application.send_with_history_tracking.call(null,network,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"payload","payload",-383036092),payload,new cljs.core.Keyword(null,"tx","tx",466630418),query,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler,new cljs.core.Keyword(null,"on-done","on-done",-699252077),on_done,new cljs.core.Keyword(null,"on-error","on-error",1728533530),on_error__$2,new cljs.core.Keyword(null,"on-load","on-load",1415151594),on_update,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),abort_id], null));
}
});
/**
 * Starts a async go loop that sends network requests on networking object's request queue.
 * Gives the appearance of a separate networking 'thread' using core async.
 */
fulcro.client.impl.application.start_network_sequential_processing = (function fulcro$client$impl$application$start_network_sequential_processing(p__66507){
var map__66508 = p__66507;
var map__66508__$1 = (((((!((map__66508 == null))))?(((((map__66508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66508.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66508):map__66508);
var app = map__66508__$1;
var networking = cljs.core.get.call(null,map__66508__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var reconciler = cljs.core.get.call(null,map__66508__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__66508__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var response_channels = cljs.core.get.call(null,map__66508__$1,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128));
var seq__66511 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__66512 = null;
var count__66513 = (0);
var i__66514 = (0);
while(true){
if((i__66514 < count__66513)){
var remote = cljs.core._nth(chunk__66512,i__66514);
var queue_67179 = cljs.core.get.call(null,send_queues,remote);
var network_67180 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__67181 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_67180);
var response_channel_67182 = cljs.core.get.call(null,response_channels,remote);
var send_complete_67183 = (cljs.core.truth_(sequential_QMARK__67181)?((function (seq__66511,chunk__66512,count__66513,i__66514,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (state_66649){
var state_val_66650 = (state_66649[(1)]);
if((state_val_66650 === (1))){
var state_66649__$1 = state_66649;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_66649__$1,(2),response_channel_67182,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_66650 === (2))){
var inst_66647 = (state_66649[(2)]);
var state_66649__$1 = state_66649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66649__$1,inst_66647);
} else {
return null;
}
}
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
;
return ((function (seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto__,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0 = (function (){
var statearr_66655 = [null,null,null,null,null,null,null];
(statearr_66655[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__);

(statearr_66655[(1)] = (1));

return statearr_66655;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1 = (function (state_66649){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_66649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e66656){if((e66656 instanceof Object)){
var ex__53641__auto__ = e66656;
var statearr_66657_67194 = state_66649;
(statearr_66657_67194[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66649);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67195 = state_66649;
state_66649 = G__67195;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = function(state_66649){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1.call(this,state_66649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__;
})()
;})(seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto__,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
})();
var state__54030__auto__ = (function (){var statearr_66661 = f__54029__auto__();
(statearr_66661[(6)] = c__54028__auto__);

return statearr_66661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
);

return c__54028__auto__;
});})(seq__66511,chunk__66512,count__66513,i__66514,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
:cljs.core.identity);
var c__54028__auto___67196 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67196,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,send_complete_67183,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67196,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,send_complete_67183,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (state_66680){
var state_val_66681 = (state_66680[(1)]);
if((state_val_66681 === (7))){
var inst_66673 = (state_66680[(2)]);
var state_66680__$1 = (function (){var statearr_66686 = state_66680;
(statearr_66686[(7)] = inst_66673);

return statearr_66686;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66680__$1,(9),queue_67179);
} else {
if((state_val_66681 === (1))){
var state_66680__$1 = state_66680;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66680__$1,(2),queue_67179);
} else {
if((state_val_66681 === (4))){
var inst_66678 = (state_66680[(2)]);
var state_66680__$1 = state_66680;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66680__$1,inst_66678);
} else {
if((state_val_66681 === (6))){
var state_66680__$1 = state_66680;
var statearr_66687_67200 = state_66680__$1;
(statearr_66687_67200[(2)] = null);

(statearr_66687_67200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66681 === (3))){
var inst_66664 = (state_66680[(8)]);
var inst_66666 = fulcro.client.impl.application._send_payload.call(null,network_67180,reconciler,inst_66664,send_complete_67183);
var inst_66667 = fulcro.client.primitives.pop_pending_request.call(null,reconciler,remote);
var state_66680__$1 = (function (){var statearr_66689 = state_66680;
(statearr_66689[(9)] = inst_66666);

(statearr_66689[(10)] = inst_66667);

return statearr_66689;
})();
if(cljs.core.truth_(sequential_QMARK__67181)){
var statearr_66690_67204 = state_66680__$1;
(statearr_66690_67204[(1)] = (5));

} else {
var statearr_66691_67205 = state_66680__$1;
(statearr_66691_67205[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66681 === (2))){
var inst_66663 = (state_66680[(2)]);
var inst_66664 = inst_66663;
var state_66680__$1 = (function (){var statearr_66694 = state_66680;
(statearr_66694[(8)] = inst_66664);

return statearr_66694;
})();
var statearr_66695_67206 = state_66680__$1;
(statearr_66695_67206[(2)] = null);

(statearr_66695_67206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66681 === (9))){
var inst_66675 = (state_66680[(2)]);
var inst_66664 = inst_66675;
var state_66680__$1 = (function (){var statearr_66696 = state_66680;
(statearr_66696[(8)] = inst_66664);

return statearr_66696;
})();
var statearr_66697_67209 = state_66680__$1;
(statearr_66697_67209[(2)] = null);

(statearr_66697_67209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66681 === (5))){
var state_66680__$1 = state_66680;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66680__$1,(8),response_channel_67182);
} else {
if((state_val_66681 === (8))){
var inst_66670 = (state_66680[(2)]);
var state_66680__$1 = state_66680;
var statearr_66700_67210 = state_66680__$1;
(statearr_66700_67210[(2)] = inst_66670);

(statearr_66700_67210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67196,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,send_complete_67183,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
;
return ((function (seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto___67196,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,send_complete_67183,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0 = (function (){
var statearr_66701 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_66701[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__);

(statearr_66701[(1)] = (1));

return statearr_66701;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1 = (function (state_66680){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_66680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e66704){if((e66704 instanceof Object)){
var ex__53641__auto__ = e66704;
var statearr_66705_67212 = state_66680;
(statearr_66705_67212[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66680);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66704;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67213 = state_66680;
state_66680 = G__67213;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = function(state_66680){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1.call(this,state_66680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__;
})()
;})(seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto___67196,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,send_complete_67183,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
})();
var state__54030__auto__ = (function (){var statearr_66707 = f__54029__auto__();
(statearr_66707[(6)] = c__54028__auto___67196);

return statearr_66707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67196,queue_67179,network_67180,sequential_QMARK__67181,response_channel_67182,send_complete_67183,remote,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
);



var G__67215 = seq__66511;
var G__67216 = chunk__66512;
var G__67217 = count__66513;
var G__67218 = (i__66514 + (1));
seq__66511 = G__67215;
chunk__66512 = G__67216;
count__66513 = G__67217;
i__66514 = G__67218;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__66511);
if(temp__5720__auto__){
var seq__66511__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66511__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__66511__$1);
var G__67221 = cljs.core.chunk_rest.call(null,seq__66511__$1);
var G__67222 = c__4550__auto__;
var G__67223 = cljs.core.count.call(null,c__4550__auto__);
var G__67224 = (0);
seq__66511 = G__67221;
chunk__66512 = G__67222;
count__66513 = G__67223;
i__66514 = G__67224;
continue;
} else {
var remote = cljs.core.first.call(null,seq__66511__$1);
var queue_67225 = cljs.core.get.call(null,send_queues,remote);
var network_67226 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__67227 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_67226);
var response_channel_67228 = cljs.core.get.call(null,response_channels,remote);
var send_complete_67229 = (cljs.core.truth_(sequential_QMARK__67227)?((function (seq__66511,chunk__66512,count__66513,i__66514,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (state_66715){
var state_val_66716 = (state_66715[(1)]);
if((state_val_66716 === (1))){
var state_66715__$1 = state_66715;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_66715__$1,(2),response_channel_67228,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_66716 === (2))){
var inst_66713 = (state_66715[(2)]);
var state_66715__$1 = state_66715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66715__$1,inst_66713);
} else {
return null;
}
}
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
;
return ((function (seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto__,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0 = (function (){
var statearr_66720 = [null,null,null,null,null,null,null];
(statearr_66720[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__);

(statearr_66720[(1)] = (1));

return statearr_66720;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1 = (function (state_66715){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_66715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e66721){if((e66721 instanceof Object)){
var ex__53641__auto__ = e66721;
var statearr_66722_67238 = state_66715;
(statearr_66722_67238[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66715);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66721;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67239 = state_66715;
state_66715 = G__67239;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = function(state_66715){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1.call(this,state_66715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__;
})()
;})(seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto__,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
})();
var state__54030__auto__ = (function (){var statearr_66725 = f__54029__auto__();
(statearr_66725[(6)] = c__54028__auto__);

return statearr_66725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto__,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
);

return c__54028__auto__;
});})(seq__66511,chunk__66512,count__66513,i__66514,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
:cljs.core.identity);
var c__54028__auto___67240 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67240,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,send_complete_67229,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67240,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,send_complete_67229,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function (state_66746){
var state_val_66747 = (state_66746[(1)]);
if((state_val_66747 === (7))){
var inst_66739 = (state_66746[(2)]);
var state_66746__$1 = (function (){var statearr_66749 = state_66746;
(statearr_66749[(7)] = inst_66739);

return statearr_66749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66746__$1,(9),queue_67225);
} else {
if((state_val_66747 === (1))){
var state_66746__$1 = state_66746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66746__$1,(2),queue_67225);
} else {
if((state_val_66747 === (4))){
var inst_66744 = (state_66746[(2)]);
var state_66746__$1 = state_66746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66746__$1,inst_66744);
} else {
if((state_val_66747 === (6))){
var state_66746__$1 = state_66746;
var statearr_66753_67247 = state_66746__$1;
(statearr_66753_67247[(2)] = null);

(statearr_66753_67247[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66747 === (3))){
var inst_66730 = (state_66746[(8)]);
var inst_66732 = fulcro.client.impl.application._send_payload.call(null,network_67226,reconciler,inst_66730,send_complete_67229);
var inst_66733 = fulcro.client.primitives.pop_pending_request.call(null,reconciler,remote);
var state_66746__$1 = (function (){var statearr_66755 = state_66746;
(statearr_66755[(9)] = inst_66732);

(statearr_66755[(10)] = inst_66733);

return statearr_66755;
})();
if(cljs.core.truth_(sequential_QMARK__67227)){
var statearr_66756_67251 = state_66746__$1;
(statearr_66756_67251[(1)] = (5));

} else {
var statearr_66757_67252 = state_66746__$1;
(statearr_66757_67252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66747 === (2))){
var inst_66729 = (state_66746[(2)]);
var inst_66730 = inst_66729;
var state_66746__$1 = (function (){var statearr_66758 = state_66746;
(statearr_66758[(8)] = inst_66730);

return statearr_66758;
})();
var statearr_66759_67253 = state_66746__$1;
(statearr_66759_67253[(2)] = null);

(statearr_66759_67253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66747 === (9))){
var inst_66741 = (state_66746[(2)]);
var inst_66730 = inst_66741;
var state_66746__$1 = (function (){var statearr_66763 = state_66746;
(statearr_66763[(8)] = inst_66730);

return statearr_66763;
})();
var statearr_66764_67257 = state_66746__$1;
(statearr_66764_67257[(2)] = null);

(statearr_66764_67257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66747 === (5))){
var state_66746__$1 = state_66746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66746__$1,(8),response_channel_67228);
} else {
if((state_val_66747 === (8))){
var inst_66736 = (state_66746[(2)]);
var state_66746__$1 = state_66746;
var statearr_66765_67259 = state_66746__$1;
(statearr_66765_67259[(2)] = inst_66736);

(statearr_66765_67259[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67240,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,send_complete_67229,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
;
return ((function (seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto___67240,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,send_complete_67229,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0 = (function (){
var statearr_66766 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_66766[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__);

(statearr_66766[(1)] = (1));

return statearr_66766;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1 = (function (state_66746){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_66746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e66771){if((e66771 instanceof Object)){
var ex__53641__auto__ = e66771;
var statearr_66772_67263 = state_66746;
(statearr_66772_67263[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66746);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67264 = state_66746;
state_66746 = G__67264;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__ = function(state_66746){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1.call(this,state_66746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__53638__auto__;
})()
;})(seq__66511,chunk__66512,count__66513,i__66514,switch__53637__auto__,c__54028__auto___67240,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,send_complete_67229,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
})();
var state__54030__auto__ = (function (){var statearr_66773 = f__54029__auto__();
(statearr_66773[(6)] = c__54028__auto___67240);

return statearr_66773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(seq__66511,chunk__66512,count__66513,i__66514,c__54028__auto___67240,queue_67225,network_67226,sequential_QMARK__67227,response_channel_67228,send_complete_67229,remote,seq__66511__$1,temp__5720__auto__,map__66508,map__66508__$1,app,networking,reconciler,send_queues,response_channels))
);



var G__67267 = cljs.core.next.call(null,seq__66511__$1);
var G__67268 = null;
var G__67269 = (0);
var G__67270 = (0);
seq__66511 = G__67267;
chunk__66512 = G__67268;
count__66513 = G__67269;
i__66514 = G__67270;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * The reconciler's send method calls FulcroApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
fulcro.client.impl.application.generate_reconciler = (function fulcro$client$impl$application$generate_reconciler(p__66777,initial_state,parser,p__66778){
var map__66779 = p__66777;
var map__66779__$1 = (((((!((map__66779 == null))))?(((((map__66779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66779):map__66779);
var app = map__66779__$1;
var send_queues = cljs.core.get.call(null,map__66779__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var mutation_merge = cljs.core.get.call(null,map__66779__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__66780 = p__66778;
var map__66780__$1 = (((((!((map__66780 == null))))?(((((map__66780.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66780.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66780):map__66780);
var reconciler_options = map__66780__$1;
var migrate = cljs.core.get.call(null,map__66780__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743));
var rec_atom = cljs.core.atom.call(null,null);
var remotes = cljs.core.keys.call(null,send_queues);
var tempid_migrate = ((function (rec_atom,remotes,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate){
return (function (pure,_,tempids){
var seq__66788_67273 = cljs.core.seq.call(null,cljs.core.vals.call(null,send_queues));
var chunk__66789_67274 = null;
var count__66790_67275 = (0);
var i__66791_67276 = (0);
while(true){
if((i__66791_67276 < count__66790_67275)){
var queue_67279 = cljs.core._nth(chunk__66789_67274,i__66791_67276);
fulcro.client.primitives.rewrite_tempids_in_request_queue.call(null,queue_67279,tempids);


var G__67280 = seq__66788_67273;
var G__67281 = chunk__66789_67274;
var G__67282 = count__66790_67275;
var G__67283 = (i__66791_67276 + (1));
seq__66788_67273 = G__67280;
chunk__66789_67274 = G__67281;
count__66790_67275 = G__67282;
i__66791_67276 = G__67283;
continue;
} else {
var temp__5720__auto___67284 = cljs.core.seq.call(null,seq__66788_67273);
if(temp__5720__auto___67284){
var seq__66788_67285__$1 = temp__5720__auto___67284;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66788_67285__$1)){
var c__4550__auto___67286 = cljs.core.chunk_first.call(null,seq__66788_67285__$1);
var G__67287 = cljs.core.chunk_rest.call(null,seq__66788_67285__$1);
var G__67289 = c__4550__auto___67286;
var G__67291 = cljs.core.count.call(null,c__4550__auto___67286);
var G__67292 = (0);
seq__66788_67273 = G__67287;
chunk__66789_67274 = G__67289;
count__66790_67275 = G__67291;
i__66791_67276 = G__67292;
continue;
} else {
var queue_67295 = cljs.core.first.call(null,seq__66788_67285__$1);
fulcro.client.primitives.rewrite_tempids_in_request_queue.call(null,queue_67295,tempids);


var G__67296 = cljs.core.next.call(null,seq__66788_67285__$1);
var G__67297 = null;
var G__67298 = (0);
var G__67299 = (0);
seq__66788_67273 = G__67296;
chunk__66789_67274 = G__67297;
count__66790_67275 = G__67298;
i__66791_67276 = G__67299;
continue;
}
} else {
}
}
break;
}

var state_migrate = (function (){var or__4131__auto__ = migrate;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fulcro.client.primitives.resolve_tempids;
}
})();
return state_migrate.call(null,pure,tempids);
});})(rec_atom,remotes,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate))
;
var complete_initial_state = (function (){var set_default_locale = ((function (rec_atom,remotes,tempid_migrate,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate){
return (function (s){
return cljs.core.update.call(null,s,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),cljs.core.fnil.call(null,cljs.core.identity,new cljs.core.Keyword(null,"en","en",88457073)));
});})(rec_atom,remotes,tempid_migrate,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate))
;
var set_network_markers = ((function (set_default_locale,rec_atom,remotes,tempid_migrate,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate){
return (function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("fulcro.client.network","status","fulcro.client.network/status",570358457),cljs.core.zipmap.call(null,remotes,cljs.core.repeat.call(null,new cljs.core.Keyword(null,"idle","idle",-2007156861))));
});})(set_default_locale,rec_atom,remotes,tempid_migrate,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate))
;
var is_atom_QMARK_ = fulcro.util.atom_QMARK_.call(null,initial_state);
if(is_atom_QMARK_){
cljs.core.swap_BANG_.call(null,initial_state,set_default_locale);

cljs.core.swap_BANG_.call(null,initial_state,set_network_markers);

return initial_state;
} else {
return set_network_markers(set_default_locale(initial_state));
}
})();
var config = cljs.core.merge.call(null,cljs.core.PersistentArrayMap.EMPTY,reconciler_options,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"migrate","migrate",-207110743),tempid_migrate,new cljs.core.Keyword(null,"state","state",-1988618099),complete_initial_state,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,remotes,tempid_migrate,complete_initial_state,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate){
return (function (sends_keyed_by_remote,result_merge_callback){
return fulcro.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),sends_keyed_by_remote,result_merge_callback);
});})(rec_atom,remotes,tempid_migrate,complete_initial_state,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"remotes","remotes",1132366312),remotes,new cljs.core.Keyword(null,"merge-ident","merge-ident",1040841862),((function (rec_atom,remotes,tempid_migrate,complete_initial_state,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate){
return (function (reconciler,app_state,ident,props){
return cljs.core.update_in.call(null,app_state,ident,cljs.core.comp.call(null,fulcro.client.primitives.sweep_one,cljs.core.merge),props);
});})(rec_atom,remotes,tempid_migrate,complete_initial_state,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,remotes,tempid_migrate,complete_initial_state,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate){
return (function (target,source){
return fulcro.client.primitives.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,remotes,tempid_migrate,complete_initial_state,map__66779,map__66779__$1,app,send_queues,mutation_merge,map__66780,map__66780__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser], null));
var rec = fulcro.client.primitives.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
fulcro.client.impl.application.initialize_global_error_callbacks = (function fulcro$client$impl$application$initialize_global_error_callbacks(app){
var seq__66804 = cljs.core.seq.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(app)));
var chunk__66805 = null;
var count__66806 = (0);
var i__66807 = (0);
while(true){
if((i__66807 < count__66806)){
var remote = cljs.core._nth(chunk__66805,i__66807);
var cb_atom_67312 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(fulcro.util.atom_QMARK_.call(null,cb_atom_67312)){
cljs.core.swap_BANG_.call(null,cb_atom_67312,((function (seq__66804,chunk__66805,count__66806,i__66807,cb_atom_67312,remote){
return (function (p1__66803_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__66803_SHARP_)){
return cljs.core.partial.call(null,p1__66803_SHARP_,fulcro.client.primitives.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__66804,chunk__66805,count__66806,i__66807,cb_atom_67312,remote))
);
} else {
}


var G__67313 = seq__66804;
var G__67314 = chunk__66805;
var G__67315 = count__66806;
var G__67316 = (i__66807 + (1));
seq__66804 = G__67313;
chunk__66805 = G__67314;
count__66806 = G__67315;
i__66807 = G__67316;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__66804);
if(temp__5720__auto__){
var seq__66804__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66804__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__66804__$1);
var G__67317 = cljs.core.chunk_rest.call(null,seq__66804__$1);
var G__67318 = c__4550__auto__;
var G__67319 = cljs.core.count.call(null,c__4550__auto__);
var G__67320 = (0);
seq__66804 = G__67317;
chunk__66805 = G__67318;
count__66806 = G__67319;
i__66807 = G__67320;
continue;
} else {
var remote = cljs.core.first.call(null,seq__66804__$1);
var cb_atom_67321 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(fulcro.util.atom_QMARK_.call(null,cb_atom_67321)){
cljs.core.swap_BANG_.call(null,cb_atom_67321,((function (seq__66804,chunk__66805,count__66806,i__66807,cb_atom_67321,remote,seq__66804__$1,temp__5720__auto__){
return (function (p1__66803_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__66803_SHARP_)){
return cljs.core.partial.call(null,p1__66803_SHARP_,fulcro.client.primitives.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__66804,chunk__66805,count__66806,i__66807,cb_atom_67321,remote,seq__66804__$1,temp__5720__auto__))
);
} else {
}


var G__67323 = cljs.core.next.call(null,seq__66804__$1);
var G__67324 = null;
var G__67325 = (0);
var G__67326 = (0);
seq__66804 = G__67323;
chunk__66805 = G__67324;
count__66806 = G__67325;
i__66807 = G__67326;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Read function for the built-in parser.
 * 
 *   *** NOTE: This function only runs when it is called without a target -- it is not triggered for remote reads. To
 *   trigger a remote read, use the `fulcro/data-fetch` namespace. ***
 * 
 *   If a user-read is supplied, *it will be allowed* to trigger remote reads. This is not recommended, as you
 *   will probably have to augment the networking layer to get it to do what you mean. Use `load` instead. You have
 *   been warned. Triggering remote reads is allowed, but discouraged and unsupported.
 * 
 *   Returns the current locale when reading the :ui/locale keyword. Otherwise pulls data out of the app-state.
 *   
 */
fulcro.client.impl.application.read_local = (function fulcro$client$impl$application$read_local(user_read,p__66818,dkey,params){
var map__66819 = p__66818;
var map__66819__$1 = (((((!((map__66819 == null))))?(((((map__66819.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66819.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66819):map__66819);
var env = map__66819__$1;
var query = cljs.core.get.call(null,map__66819__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var target = cljs.core.get.call(null,map__66819__$1,new cljs.core.Keyword(null,"target","target",253001721));
var state = cljs.core.get.call(null,map__66819__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ast = cljs.core.get.call(null,map__66819__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var temp__5718__auto__ = user_read.call(null,env,dkey,params);
if(cljs.core.truth_(temp__5718__auto__)){
var custom_result = temp__5718__auto__;
return custom_result;
} else {
if(cljs.core.not(target)){
var top_level_prop = (query == null);
var key = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return dkey;
}
})();
var by_ident_QMARK_ = fulcro.util.ident_QMARK_.call(null,key);
var union_QMARK_ = cljs.core.map_QMARK_.call(null,query);
var data = ((by_ident_QMARK_)?cljs.core.get_in.call(null,cljs.core.deref.call(null,state),key):cljs.core.get.call(null,cljs.core.deref.call(null,state),key));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),((union_QMARK_)?cljs.core.get.call(null,fulcro.client.primitives.db__GT_tree.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([key,query])], null),cljs.core.deref.call(null,state),cljs.core.deref.call(null,state)),key):((top_level_prop)?data:fulcro.client.primitives.db__GT_tree.call(null,query,data,cljs.core.deref.call(null,state))
))], null);
} else {
return null;
}
}
});
/**
 * This is the entry point for writes. In general this is simply a call to the multi-method
 *   defined by Fulcro (mutate); however, Fulcro supports the concept of a global `post-mutate`
 *   function that will be called anytime the general mutate has an action that is desired. This
 *   can be useful, for example, in cases where you have some post-processing that needs
 *   to happen for a given (sub)set of mutations (that perhaps you did not define).
 */
fulcro.client.impl.application.write_entry_point = (function fulcro$client$impl$application$write_entry_point(env,k,params){
var rv = (function (){try{return fulcro.client.mutations.mutate.call(null,env,k,params);
}catch (e66824){var e = e66824;
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),372], null),new cljs.core.Keyword(null,"error","error",-978969032),"Mutation ",k," failed with exception",e);
}catch (e66825){if((e66825 instanceof Error)){
var e__54502__auto___67330 = e66825;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),372], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___67330);
} else {
throw e66825;

}
}
return null;
}})();
var action = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(rv);
if(cljs.core.truth_(action)){
return cljs.core.assoc.call(null,rv,new cljs.core.Keyword(null,"action","action",-811238024),((function (rv,action){
return (function (){
try{var action_result = action.call(null,env,k,params);
try{fulcro.client.mutations.post_mutate.call(null,env,k,params);
}catch (e66834){var e_67332 = e66834;
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),381], null),new cljs.core.Keyword(null,"error","error",-978969032),"Post mutate failed on dispatch to ",k);
}catch (e66836){if((e66836 instanceof Error)){
var e__54502__auto___67334 = e66836;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),381], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___67334);
} else {
throw e66836;

}
}}
return action_result;
}catch (e66828){var e = e66828;
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),384], null),new cljs.core.Keyword(null,"error","error",-978969032),"Mutation ",k," failed with exception");
}catch (e66830){if((e66830 instanceof Error)){
var e__54502__auto___67335 = e66830;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.impl.application",new cljs.core.Keyword(null,"line","line",212345235),384], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___67335);
} else {
throw e66830;

}
}
if(cljs.core.truth_(goog.DEBUG)){
console.error(e);
} else {
}

throw e;
}});})(rv,action))
);
} else {
return rv;
}
});

//# sourceMappingURL=fulcro.client.impl.application.js.map
