(ns com.wsscode.demos.multiple-inputs
  (:require [com.wsscode.pathom.core :as p]
            [com.wsscode.pathom.connect :as pc]))

(def users-db
  {1 {:user/first-name "Sam"
      :user/last-name  "Rock"}})

(pc/defresolver user-by-id [env {:keys [user/id]}]
  {::pc/input  #{:user/id}
   ::pc/output [:user/first-name :user/last-name]}
  (get users-db id))

(pc/defresolver full-name [env {:user/keys [first-name last-name]}]
  {::pc/input  #{:user/first-name :user/last-name}
   ::pc/output [:user/full-name]}
  {:user/full-name (str first-name " " last-name)})

(pc/defresolver user-session [env {user-id :user/id game-id :game/id}]
  {::pc/input  #{:user/id :game/id}
   ::pc/output [:session/id]}
  (let [res (fake-sql (str "select session_id from sessions where user_id=" user-id " and game_id = " game-id))]
    {:session/id (:session_id res)}))

(pc/defresolver games-from-user [env {:keys [user/id]}]
  {::pc/input  #{:user/id}
   ::pc/output [{:user/games [:user/id :game/id]}]}
  ; assume this returns a list of game ids
  (let [res (find-games-from-user env id)]
    {:user/games (mapv #(hash-map :user/id id :game/id %) res)}))

(def registry
  [user-by-id full-name])

(def parser
  (p/parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/reader2
                                            pc/open-ident-reader
                                            p/env-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}}
     ::p/mutate  pc/mutate
     ::p/plugins [(pc/connect-plugin {::pc/register registry})
                  p/error-handler-plugin
                  p/trace-plugin]}))

(comment
  ; just use the ident, pull name from resolver
  (parser {} '[{[:user/id 1] [:user/full-name]}])

  ; provide data, note we use an id that dont even exist
  (parser {} '[{([:user/id 3] {:pathom/context {:user/first-name "Foo" :user/last-name "Bar"}})
                [:user/full-name]}])

  ; to show the ident doesn't matter, changing it for anything else
  (parser {} '[{([:whatever-we-want "bla"] {:pathom/context {:user/first-name "Foo" :user/last-name "Bar"}})
                [:user/full-name]}])

  (parser {::p/entity (atom {:user/first-name "Foo" :user/last-name "Bar"})}
    '[[:user/full-name]]))
