(ns com.wsscode.demos.perf
  (:require [com.wsscode.pathom.connect :as pc]
            [criterium.core :as c]
            [com.wsscode.pathom.core :as p]))

(pc/defresolver items-10 [env _]
  {::pc/output [{:items-10 [:id]}]}
  {:items-10 (mapv #(hash-map :id %) (range 10))})

(pc/defresolver items-1000 [env _]
  {::pc/output [{:items-1000 [:id]}]}
  {:items-1000 (mapv #(hash-map :id %) (range 1000))})

(pc/defresolver items-10000 [env _]
  {::pc/output [{:items-10000 [:id]}]}
  {:items-10000 (mapv #(hash-map :id %) (range 10000))})

(pc/defresolver x [env {:keys [id]}]
  {::pc/input  #{:id}
   ::pc/output [:x]}
  {:x (* 10 id)})

(pc/defresolver y [env {:keys [id]}]
  {::pc/input  #{:id}
   ::pc/output [:y]}
  {:y (* 10 id)})

(pc/defresolver x-batch [env {:keys [id]}]
  {::pc/input  #{:id}
   ::pc/output [:x]}
  {:x (* 10 id)})

(def registry [items-10 items-1000 items-10000 x y])

(def parser
  (p/parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/reader2
                                            pc/open-ident-reader
                                            p/env-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}}
     ::p/mutate  pc/mutate
     ::p/plugins [(pc/connect-plugin {::pc/register registry})
                  p/error-handler-plugin
                  p/trace-plugin]}))

(comment
  (time (parser {} [{:items [:x]}]))

  (c/with-progress-reporting
    (c/quick-bench
      (parser {}
        [{:items-10000 [:x]}])))

  (c/with-progress-reporting
    (c/quick-bench
      (parser {}
        [{:items-1000
          [:x
           {:items-10
            [:y]}]}])))

  (c/with-progress-reporting
    (c/quick-bench
      (parser {}
        [{:items-10
          [:x
           {:items-1000
            [:y]}]}]))))

; results
{[{:items-10000 [:x]}]
 {"2.2" 1.188888
  "2.3" 1.189224
  "3.0" 0.177210}

 ; items at 1000
 [{:items-1000
   [:x
    {:items-10
     [:y]}]}]
 {"2.2" 0.900505
  "2.3" nil
  "3.0" 0.192105}

 ; items at 1000
 [{:items-10
   [:x
    {:items-1000
     [:y]}]}]
 {"2.2" 0.711962
  "2.3" nil}}
