(ns com.wsscode.demos.placeholder-params
  (:require [com.wsscode.pathom.core :as p]
            [com.wsscode.pathom.connect :as pc]))

(defn params-placeholder-reader
  "Produces a reader that will respond to any keyword whose namespace
  is in the set `(::placeholder-prefixes env)`. The join node logical
  level stays the same as the parent where the placeholder node is
  requested."
  [{::p/keys [placeholder-prefixes] :as env}]
  (assert placeholder-prefixes "To use env-placeholder-reader please add ::p/placeholder-prefixes to your environment.")
  (if (p/placeholder-key? env (-> env :ast :dispatch-key))
    (let [params  (-> env :ast :params)
          new-ent (merge (p/entity env) params)]
      (p/join (assoc env ::p/entity (atom new-ent))))
    ::continue))

(pc/defresolver all-items []
  {:items/all
   [{:item/id 1}
    {:item/id 2}]})

(pc/defresolver inventory [{item-id  :item/id
                            store-id :store/id}]
  {:store-item/inventory (str item-id " - " store-id)})

(def registry
  [all-items
   inventory])

(def parser
  (p/parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/reader2
                                            pc/open-ident-reader
                                            ; here I replaced the placeholder reader
                                            params-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}}
     ::p/mutate  pc/mutate
     ::p/plugins [(pc/connect-plugin {::pc/register registry})
                  p/error-handler-plugin
                  p/trace-plugin]}))

(comment
  (parser {}
    '[{:items/all
       [:item/id
        {(:>/foo-store {:store/id "foo"})
         [:store-item/inventory]}
        {(:>/bar-store {:store/id "bar"})
         [:store-item/inventory]}]}]))
