/*
 * Decompiled with CFR 0.152.
 */
package com.xorlev.gatekeeper;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringListProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.DynamicURLConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppConfig {
    protected static final Logger log = LoggerFactory.getLogger(AppConfig.class);
    protected static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initializeConfiguration(String configFile) throws IOException {
        log.info("Initializing config with file=[{}]", (Object)configFile);
        if (initialized) return;
        Class<AppConfig> clazz = AppConfig.class;
        synchronized (AppConfig.class) {
            initialized = true;
            File config = new File(configFile);
            if (!config.exists()) {
                throw new IllegalArgumentException("Could not find configuration file! " + config.getAbsolutePath());
            }
            ConfigurationManager.loadPropertiesFromConfiguration((AbstractConfiguration)new DynamicURLConfiguration(0, 10000, false, new String[]{config.toURI().toString()}));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Integer getInt(String property) {
        DynamicIntProperty intProperty = DynamicPropertyFactory.getInstance().getIntProperty(property, 0);
        return intProperty.get();
    }

    public static Long getLong(String property) {
        DynamicLongProperty longProperty = DynamicPropertyFactory.getInstance().getLongProperty(property, 0L);
        return longProperty.get();
    }

    public static Boolean getBoolean(String property) {
        DynamicBooleanProperty booleanProperty = DynamicPropertyFactory.getInstance().getBooleanProperty(property, false);
        return booleanProperty.get();
    }

    public static Double getDouble(String property) {
        DynamicDoubleProperty doubleProperty = DynamicPropertyFactory.getInstance().getDoubleProperty(property, 0.0);
        return doubleProperty.get();
    }

    public static String getString(String property) {
        DynamicStringProperty stringProperty = DynamicPropertyFactory.getInstance().getStringProperty(property, "");
        return stringProperty.get();
    }

    public static List<String> getStringList(String property) {
        DynamicStringListProperty listProperty = new DynamicStringListProperty(property, "");
        return listProperty.get();
    }

    public static void addCallback(String property, Runnable callback) {
        DynamicProperty dynamicProperty = DynamicProperty.getInstance((String)property);
        dynamicProperty.addCallback(callback);
    }
}

