/*
 * Decompiled with CFR 0.152.
 */
package com.xorlev.gatekeeper.providers.discovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractIdleService;
import com.xorlev.gatekeeper.data.Cluster;
import com.xorlev.gatekeeper.providers.discovery.ClustersUpdatedEvent;
import com.xorlev.gatekeeper.providers.output.ClusterHandler;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClusterDiscovery
extends AbstractIdleService {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected List<ClusterHandler> clusterHandlers = Lists.newArrayList();
    protected List<Cluster> previousClusterList = Collections.emptyList();

    public void registerHandler(ClusterHandler clusterHandler) {
        this.clusterHandlers.add(clusterHandler);
    }

    public abstract void startUp() throws Exception;

    public abstract void shutDown() throws Exception;

    public void updateInstances() {
        List<Cluster> clusterList = this.clusters();
        if (this.previousClusterList != clusterList) {
            for (ClusterHandler clusterHandler : this.clusterHandlers) {
                clusterHandler.processClusters(new ClustersUpdatedEvent(clusterList));
            }
        }
    }

    public abstract List<Cluster> clusters();

    public List<ClusterHandler> handlers() {
        return ImmutableList.copyOf(this.clusterHandlers);
    }
}

