/*
 * Decompiled with CFR 0.152.
 */
package com.xorlev.gatekeeper.providers.discovery;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.CuratorFrameworkFactory;
import com.netflix.curator.framework.imps.CuratorFrameworkState;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.retry.RetryNTimes;
import com.netflix.curator.x.discovery.ServiceCache;
import com.netflix.curator.x.discovery.ServiceDiscovery;
import com.netflix.curator.x.discovery.ServiceDiscoveryBuilder;
import com.netflix.curator.x.discovery.ServiceInstance;
import com.netflix.curator.x.discovery.details.ServiceCacheListener;
import com.xorlev.gatekeeper.AppConfig;
import com.xorlev.gatekeeper.data.Cluster;
import com.xorlev.gatekeeper.data.Server;
import com.xorlev.gatekeeper.providers.discovery.AbstractClusterDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZookeeperClusterDiscovery
extends AbstractClusterDiscovery {
    private CuratorFramework zk;
    private ServiceDiscovery<Void> dsc;
    private List<ServiceCache<Void>> serviceCacheList = Lists.newArrayList();
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public void startUp() throws Exception {
        this.setupZookeeper();
        this.setupServiceDiscovery();
        this.updateInstances();
    }

    public void shutDown() throws Exception {
        this.log.info("Shutting down...");
        this.executorService.shutdown();
        if (this.dsc != null) {
            this.dsc.close();
        }
        if (this.zk != null) {
            this.zk.close();
        }
    }

    private void setupZookeeper() {
        String quorum = AppConfig.getString((String)"zookeeper.quorum");
        String namespace = AppConfig.getString((String)"zookeeper.namespace");
        this.log.info("Starting Zookeeper with connectString={}", (Object)quorum);
        this.zk = CuratorFrameworkFactory.builder().connectString(quorum).connectionTimeoutMs(2000).retryPolicy((RetryPolicy)new RetryNTimes(6, 1000)).namespace(namespace.isEmpty() ? null : namespace).build();
        this.zk.start();
    }

    private void setupServiceDiscovery() throws Exception {
        if (this.zk != null && this.zk.getState() == CuratorFrameworkState.STARTED) {
            this.dsc = ServiceDiscoveryBuilder.builder(Void.class).basePath(AppConfig.getString((String)"zookeeper.discoveryPath")).client(this.zk).build();
            this.dsc.start();
            this.initializeServiceCaches();
        }
    }

    private void initializeServiceCaches() throws Exception {
        for (ServiceCache<Void> cache : this.serviceCacheList) {
            cache.close();
        }
        this.serviceCacheList = Lists.newArrayList();
        for (final String c : AppConfig.getStringList((String)"clusters")) {
            ServiceCache cache = this.dsc.serviceCacheBuilder().name(c).build();
            cache.addListener((Object)new ServiceCacheListener(){

                public void cacheChanged() {
                    ZookeeperClusterDiscovery.this.log.info("Service {} modified, rewriting config", (Object)c);
                    ZookeeperClusterDiscovery.this.updateInstances();
                }

                public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
                }
            }, (Executor)this.executorService);
            cache.start();
            this.serviceCacheList.add((ServiceCache<Void>)cache);
            AppConfig.addCallback((String)("cluster." + c + ".context"), (Runnable)new Runnable(){

                public void run() {
                    try {
                        ZookeeperClusterDiscovery.this.updateInstances();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        AppConfig.addCallback((String)"clusters", (Runnable)new Runnable(){

            public void run() {
                try {
                    ZookeeperClusterDiscovery.this.initializeServiceCaches();
                    ZookeeperClusterDiscovery.this.updateInstances();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public List<Cluster> clusters() {
        ArrayList clusterList = Lists.newArrayListWithExpectedSize((int)this.serviceCacheList.size());
        for (ServiceCache<Void> cache : this.serviceCacheList) {
            if (cache.getInstances().isEmpty()) continue;
            Cluster cluster = this.clusterFromInstance((ServiceInstance<Void>)((ServiceInstance)cache.getInstances().get(0)));
            for (ServiceInstance instance : cache.getInstances()) {
                cluster.getServers().add(this.convertInstance((ServiceInstance<Void>)instance));
            }
            this.log.info("Discovery: cluster=[{}] has {} instances, {}...", new Object[]{cluster.getClusterName(), cluster.getServers().size(), Iterables.limit((Iterable)cluster.getServers(), (int)5)});
            clusterList.add(cluster);
        }
        return clusterList;
    }

    private Cluster clusterFromInstance(ServiceInstance<Void> instance) {
        Cluster cluster = new Cluster(instance.getName());
        if (instance.getSslPort() != null) {
            cluster.setProtocol("https");
        }
        return cluster;
    }

    protected Server convertInstance(ServiceInstance<Void> instance) {
        Integer port = instance.getSslPort() != null ? instance.getSslPort() : instance.getPort();
        return new Server(instance.getAddress(), port);
    }
}

