/*
 * Decompiled with CFR 0.152.
 */
package com.rapportive.storm.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rapportive.storm.amqp.HAPolicy;
import com.rapportive.storm.amqp.QueueDeclaration;
import java.io.IOException;

public class SharedQueueWithBinding
implements QueueDeclaration {
    private static final long serialVersionUID = 2364833412534518859L;
    private final String queueName;
    private final String exchange;
    private final String routingKey;
    private HAPolicy haPolicy;

    public SharedQueueWithBinding(String queueName, String exchange, String routingKey) {
        this(queueName, exchange, routingKey, null);
    }

    public SharedQueueWithBinding(String queueName, String exchange, String routingKey, HAPolicy policy) {
        this.queueName = queueName;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.haPolicy = policy;
    }

    public AMQP.Queue.DeclareOk declare(Channel channel) throws IOException {
        channel.exchangeDeclarePassive(this.exchange);
        AMQP.Queue.DeclareOk queue = channel.queueDeclare(this.queueName, true, false, false, this.haPolicy == null ? null : this.haPolicy.asQueueProperies());
        channel.queueBind(queue.getQueue(), this.exchange, this.routingKey);
        return queue;
    }

    public boolean isParallelConsumable() {
        return true;
    }
}

