(ns com.yolodata.riemann.blypr
  "Forwards events to Blypr."
  (:require [clj-http.client :as client]
            [cheshire.core :as json]))

(def ^:private base-url "http://blypr.com:3000/")

(defn- url [company] (str base-url company))

(defn- status [state]
  (= state "ok"))

(defn- format-blyp [{:keys [host service metric state] :as event}]
  {:prefix (str host)
   :blyps [{:title service
            :type (if metric "numeric" "status")
            :data (or metric (status state))
            :event event}]})

(defn- post-blyps [blyps company user key]
  (client/post (url company)
    {:basic-auth [user key]
     :body (json/generate-string blyps)
     :socket-timeout 5000
     :conn-timeout 5000
     :content-type :json
     :accept :json}))

(defn blypr
  [{:keys [company user secret_key]}]
  (fn [event]
    (-> event format-blyp (post-blyps company user secret_key))))
