/*
This file is part of the Zenos Solutions GUI Table Results Library (ZGTR).

ZGTR is free software: you can redistribute it and/or modify it under the
terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

ZGTR is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
ZGTR.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.zensols.gui.tabres;

import java.awt.Dimension;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

import com.zensols.gui.pref.ConfigPrefFrame;
import com.zensols.gui.pref.PrefSupport;

public class ResultsFrame extends ConfigPrefFrame {
    public final static int HEIGHT_FUDGE = 25;
    public final static int WIDTH_FUDGE = 5;

    private int widthFudge = HEIGHT_FUDGE;
    private int heightFudge = WIDTH_FUDGE;

    public ResultsFrame(Class packageOwner, String prefix) {
	super(packageOwner, prefix);
    }

    public ResultsFrame(String prefix) {
	this(ResultsFrame.class, prefix);
    }

    public ResultsFrame(PrefSupport prefSupport, String prefix) {
	super(prefSupport, prefix);
    }

    public void displayResults(List<List> data) {
	displayResults(data, null);
    }

    public int getWidthFudge() {
	return widthFudge;
    }

    public void setWidthFudge(int widthFudge) {
	this.widthFudge = widthFudge;
    }

    public int getHeightFudge() {
	return heightFudge;
    }

    public void setHeightFudge(int heightFudge) {
	this.heightFudge = heightFudge;
    }

    public void displayResults(List<List> data, List<String> columns) {
	TableModel model = new BestGuessPresTableModel
	    (new CachedTableModel(data, columns));
	final PackingColumnWidthJTable table = new PackingColumnWidthJTable();
	JScrollPane scrollPane = new JScrollPane(table) {
		public Dimension getPreferredSize() {
		    Dimension dim = table.getPreferredSize();
		    dim.width += widthFudge;
		    dim.height += heightFudge;
		    return dim;
		}};
	table.setModel(model);
	setContentPane(scrollPane);
    }
}
