(ns conceit.commons.restart)

(def ^{:dynamic true :private true} *restart-handlers* ())
(def ^{:dynamic true :private true} 

(defmacro with-restart-handlers [[& handlers] & body]
  `(binding [*restart-handlers* (concat [~@(map (fn [[throwable-class [& bindings] & body]]
                                                  `[~throwable-class (memoize (fn [~@bindings] ~@body))])
                                                handlers)]
                                        *restart-handlers*)]
     ~@body))

(defmacro restartable [[& restarts] & body]
  `(try (do ~@body)
        (catch Throwable throwable#
          (if-let [handler# (some (fn [[throwable-class# handler#]]
                                    (when (instance? throwable-class# throwable#) (handler# throwable#)))
                                  *restart-handlers*)]
            
            (throw throwable#)))))
