(ns leiningen.new.connect
  (:require [clojure.string :as string]
            [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "connect"))

(def sources ["README.md"
              "project.clj"
              ".gitignore"
              "src/cljs/{{path}}/core.cljs"
              "src/clojure/{{path}}/bitbucket.clj"
              "src/clojure/{{path}}/core.clj"
              "src/clojure/{{path}}/handler.clj"
              "src/clojure/{{path}}/storage.clj"
              "resources/AP-externs.js"
              "resources/public/css/addon.css"
              "resources/public/img/100px-clojure.png"
              "resources/public/js/addon.js"
              "resources/views/atlassian-connect.json.selmer"
              "resources/views/connect-example.selmer"])

(defn connect [name]

  (let [data {:name name
              :path (name-to-path name)}]

    (main/info "Generating fresh 'lein new' connect project.")
    (apply (partial ->files data)
           (map #(vector % (render (string/replace % "{{path}}" "ns") data)) sources))))
