(ns common_foxeriot.integrant.http-server
  (:require
   [aleph.http :as http]
   [integrant.core :as ig]
   [taoensso.timbre :as log])
  (:import java.net.InetSocketAddress))

(defmethod ig/init-key :http/server [_ {:keys [port hostname] :as opts}]
  (log/infof "Starting HTTP server at http://%s:%d/" hostname port)
  (let [handler        (atom (delay (:handler opts)))
        socket-address (InetSocketAddress. hostname port)]
    {:handler handler
     :server  (http/start-server (fn [request] (@@handler request)) {:socket-address socket-address})}))

(defmethod ig/halt-key! :http/server [_ {:keys [server]}]
  (when server
    (log/info "Stopping HTTP server")
    (.close ^java.io.Closeable server)))

(defmethod ig/suspend-key! :http/server [_ {:keys [handler]}]
  (log/info "Suspending HTTP server")
  (when handler
    (reset! handler (promise))))

(defmethod ig/resume-key :http/server [_ opts old-opts old-impl]
  (if (= (dissoc opts :handler) (dissoc old-opts :handler))
    (do
      (log/info "Resuming HTTP server")
      (deliver @(:handler old-impl) (:handler opts))
      old-impl)
    (do
      (ig/halt-key! :http/server old-impl)
      (ig/init-key :http/server opts))))
