(ns common_foxeriot.timbre
  (:require [clojure.string :as string]
            [taoensso.timbre :as log]))

;; Derived from <https://github.com/ptaoussanis/timbre/blob/v4.10.0/src/taoensso/timbre.cljx#L35>
;; This is the same as the original except that it does not include the hostname in the log.
(defn output-fn
  ([data]
   (let [{:keys [level ?err msg_ ?ns-str ?file hostname_
                 timestamp_ ?line]} data]
     (str
      (force timestamp_) " "
      (string/upper-case (name level))  " "
      "[" (or ?ns-str ?file "?") ":" (or ?line "?") "] - "
      (force msg_)
      (when-let [err ?err]
        (str "\n" (log/stacktrace err)))))))

(log/merge-config!
 {:timestamp-opts {:pattern "yyyy-MM-dd HH:mm:ss ZZZ"
                   :timezone (java.util.TimeZone/getTimeZone "Europe/Helsinki")}
  :output-fn output-fn})
