// Compiled by ClojureScript 1.9.494 {}
goog.provide('conwip.modules');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.module.ModuleManager');
goog.require('goog.module.ModuleLoader');
goog.require('goog.Timer');

/** @define {boolean} */
goog.define("conwip.modules.PRODUCTION",false);
conwip.modules.manager = goog.module.ModuleManager.getInstance();
conwip.modules.loader = (new goog.module.ModuleLoader());
conwip.modules.manager.setLoader(conwip.modules.loader);
conwip.modules.manager.setAllModuleInfo((function (){var obj8313 = {"extra":[],"dev":[]};
return obj8313;
})());
conwip.modules.manager.setModuleUris((function (){var obj8315 = {"extra":"js/extra.js","dev":"js/dev.js"};
return obj8315;
})());
/**
 * Get the module information for a module
 *   Returns a goog.modules.ModuleInfo object
 */
conwip.modules.get_module_info = (function conwip$modules$get_module_info(id){
return conwip.modules.manager.getModuleInfo(id);
});
conwip.modules.loaded_QMARK_ = (function conwip$modules$loaded_QMARK_(id){

var temp__6751__auto__ = conwip.modules.manager.getModuleInfo(id);
if(cljs.core.truth_(temp__6751__auto__)){
var module = temp__6751__auto__;
return module.isLoaded();
} else {
return false;
}
});
/**
 * Loads a module then fires a callback. The callback function takes no arguements
 * 
 *   In development (:none optimizations) modules are automatically loaded so we fire off
 *   a timer that checks every 100 milliseconds if the module has been loaded.
 * 
 *   (load-module-dev "extra" (fn [] (.log js/console "The extra module has loaded")))
 */
conwip.modules.load_module_dev = (function conwip$modules$load_module_dev(id,callback){
var interval = (new goog.Timer((100)));
var tick_fn = ((function (interval){
return (function (_){
if(conwip.modules.loaded_QMARK_.call(null,id)){
interval.stop();

goog.events.removeAll(interval);

return callback.call(null);
} else {
return null;
}
});})(interval))
;
goog.events.listen(interval,"tick",tick_fn);

return interval.start();
});
/**
 * Loads a module then fires a callback. The callback function takes no arguements
 * 
 *   This is for production (:simple or :advanced optimizations) module loading
 * 
 *   (load-module-dev "extra" (fn [] (.log js/console "The extra module has loaded")))
 */
conwip.modules.load_module_prod = (function conwip$modules$load_module_prod(id,callback){
return conwip.modules.manager.execOnLoad(id,callback);
});
/**
 * Loads a module then fires a callback. The callback function
 *   takes no arguements
 * 
 *   (load-module "extra" (fn [] (.log js/console "The extra module has loaded")))
 */
conwip.modules.load_module = ((conwip.modules.PRODUCTION)?conwip.modules.load_module_prod:conwip.modules.load_module_dev);
/**
 * Tells goog.module.Manager that a module has loaded. set-loaded! needs to
 *   be called in a namespace in a module.
 * 
 *   For example say we have a extra moudle
 * 
 *   :modules {:extra {:output-to "path/to/extra.js"
 *                  :entries #{"my.app.extra"
 *                             "my.app.bouns"}}}
 * 
 *   The we would need to call set-loaded! in the my.app.extra namsspace
 * 
 *   (ns my.app.extra
 *  (:require [conwip.modules :as bm]))
 * 
 *   (bm/set-loaded! "extra")
 * 
 *   or my.app.bonus namespaces.
 * 
 *   (ns my.app.bonus
 *  (:require [conwip.modules :as bm]))
 * 
 *   (bm/set-loaded! "extra")
 * 
 *   set-loaded! only needs to be called for one namesapace in the module
 */
conwip.modules.set_loaded_BANG_ = (function conwip$modules$set_loaded_BANG_(id){
return goog.module.ModuleManager.getInstance().setLoaded(id);
});

//# sourceMappingURL=modules.js.map