// Compiled by ClojureScript 1.9.494 {:static-fns true, :optimize-constants true}
goog.provide('bendyworks.modules');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.events');
goog.require('goog.module.ModuleManager');
goog.require('goog.module.ModuleLoader');
goog.require('goog.Timer');

/** @define {boolean} */
goog.define("bendyworks.modules.PRODUCTION",false);
bendyworks.modules.manager = goog.module.ModuleManager.getInstance();
bendyworks.modules.loader = (new goog.module.ModuleLoader());
bendyworks.modules.manager.setLoader(bendyworks.modules.loader);
bendyworks.modules.manager.setAllModuleInfo((function (){var obj12032 = {"extra":[],"dev":[]};
return obj12032;
})());
bendyworks.modules.manager.setModuleUris((function (){var obj12034 = {"extra":"js/extra.js","dev":"js/dev.js"};
return obj12034;
})());
/**
 * Get the module information for a module
 *   Returns a goog.modules.ModuleInfo object
 */
bendyworks.modules.get_module_info = (function bendyworks$modules$get_module_info(id){
return bendyworks.modules.manager.getModuleInfo(id);
});
bendyworks.modules.loaded_QMARK_ = (function bendyworks$modules$loaded_QMARK_(id){

var temp__6751__auto__ = bendyworks.modules.manager.getModuleInfo(id);
if(cljs.core.truth_(temp__6751__auto__)){
var module = temp__6751__auto__;
return module.isLoaded();
} else {
return false;
}
});
/**
 * Loads a module then fires a callback. The callback function takes no arguements
 * 
 *   In development (:none optimizations) modules are automatically loaded so we fire off
 *   a timer that checks every 100 milliseconds if the module has been loaded.
 * 
 *   (load-module-dev "extra" (fn [] (.log js/console "The extra module has loaded")))
 */
bendyworks.modules.load_module_dev = (function bendyworks$modules$load_module_dev(id,callback){
var interval = (new goog.Timer((100)));
var tick_fn = ((function (interval){
return (function (_){
if(bendyworks.modules.loaded_QMARK_(id)){
interval.stop();

goog.events.removeAll(interval);

return (callback.cljs$core$IFn$_invoke$arity$0 ? callback.cljs$core$IFn$_invoke$arity$0() : callback.call(null));
} else {
return null;
}
});})(interval))
;
goog.events.listen(interval,"tick",tick_fn);

return interval.start();
});
/**
 * Loads a module then fires a callback. The callback function takes no arguements
 * 
 *   This is for production (:simple or :advanced optimizations) module loading
 * 
 *   (load-module-dev "extra" (fn [] (.log js/console "The extra module has loaded")))
 */
bendyworks.modules.load_module_prod = (function bendyworks$modules$load_module_prod(id,callback){
return bendyworks.modules.manager.execOnLoad(id,callback);
});
/**
 * Loads a module then fires a callback. The callback function
 *   takes no arguements
 * 
 *   (load-module "extra" (fn [] (.log js/console "The extra module has loaded")))
 */
bendyworks.modules.load_module = ((bendyworks.modules.PRODUCTION)?bendyworks.modules.load_module_prod:bendyworks.modules.load_module_dev);
/**
 * Tells goog.module.Manager that a module has loaded. set-loaded! needs to
 *   be called in a namespace in a module.
 * 
 *   For example say we have a extra moudle
 * 
 *   :modules {:extra {:output-to "path/to/extra.js"
 *                  :entries #{"my.app.extra"
 *                             "my.app.bouns"}}}
 * 
 *   The we would need to call set-loaded! in the my.app.extra namsspace
 * 
 *   (ns my.app.extra
 *  (:require [bendyworks.modules :as bm]))
 * 
 *   (bm/set-loaded! "extra")
 * 
 *   or my.app.bonus namespaces.
 * 
 *   (ns my.app.bonus
 *  (:require [bendyworks.modules :as bm]))
 * 
 *   (bm/set-loaded! "extra")
 * 
 *   set-loaded! only needs to be called for one namesapace in the module
 */
bendyworks.modules.set_loaded_BANG_ = (function bendyworks$modules$set_loaded_BANG_(id){
return goog.module.ModuleManager.getInstance().setLoaded(id);
});
