;
;     This file is part of defenv.
;
;     defenv is free software: you can redistribute it and/or modify
;     it under the terms of the GNU General Public License as published by
;     the Free Software Foundation, either version 3 of the License, or
;     (at your option) any later version.
;
;     defenv is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;     GNU General Public License for more details.
;
;     You should have received a copy of the GNU General Public License
;     along with defenv.  If not, see <http://www.gnu.org/licenses/>.
;

(ns defenv.integration
  (:require [defenv.core :refer :all]))

(defenv defenv-testing "DEFENV_TESTING" :default "A Sensible Default™"
        :doc "An environment variable with a default value.")

(defenv something-missing "DEFENV_MISSING"
        :doc "Shows you what happens when something is missing.")

(defenv some-keyword "DEFENV_KEYWORD" :default "test" :tfn keyword
        :doc "Shows how values can be converted to keywords.")

(defn -main [& args]
  (println (make-usage-string "Environment Variables")))