;
;     This file is part of defenv.
;
;     defenv is free software: you can redistribute it and/or modify
;     it under the terms of the GNU General Public License as published by
;     the Free Software Foundation, either version 3 of the License, or
;     (at your option) any later version.
;
;     defenv is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;     GNU General Public License for more details.
;
;     You should have received a copy of the GNU General Public License
;     along with defenv.  If not, see <http://www.gnu.org/licenses/>.
;

;; # Usage example

(ns defenv.usage
  (:require [defenv.core :refer :all])
  (:gen-class))

;; ## Environment variables

(defenv defenv-testing
        "An environment variable with a default value."
        "DEFENV_TESTING"
        :default "A Sensible Default™")

(defenv something-missing
        "Shows you what happens when something is missing."
        "DEFENV_MISSING")

(defenv some-keyword
        "Shows how values can be converted to keywords."
        "DEFENV_KEYWORD"
        :default "test"
        :tfn keyword)

(defn -main
  "A very simple example of how to use the library."
  [& _]
  (println (make-usage-string "Environment Variables"))
  (printf "testing: %s%n" @defenv-testing))