# dcljs-lib

A Clojure library designed to use [dc.js][1], [d3.js][2] and [crossfilter][3] in clojurescript.



## Rationale

The main goal of dcjs-lib is to simplify the writing of [crossfilter][3] group's reduce function in ClojureScript. This function requires three arguments "add", "remove" and "initial". Very often, several fields from the input dataset are additive and will end up being summarized/aggregated as a sum. Hence "add" and "remove" functions are trivially symmetric. Having to code both of them plus initialization is a source of error.

[dcjs-lib][4] defines a minimal language to specify :

- the input dataset
- fields which are additive (so as to automatically generate init/add/remove)
- fields to be counted
- calculated fields (e.g. ratios)


From that "dataset" and "group" specification, [dcjs-lib][4] will create :

- a parsing function which can be directly fed to d3 csv methods.
- a triplet (add, remove, init) meant for crossfilter's reduce function.

For efficiency reasons, the functions created by [dcjs-lib][4] are generated by macros so that they are compiled to very simple javascript.


## Usage


The library provides a set of macros to :

- easily parse datasets (i.e. cast/coerce to the right type)
- calculate new fields from the dataset.
- automatically create grouping functions (add, remove, initial)



## References

[1]: http://dc-js.github.io/dc.js/ "dc.js"
[2]: http://d3js.org "d3.js"
[3]: http://square.github.io/crossfilter/ "crossfilter"
[4]: http://dcjs-lib.boc.al "dcjs-lib"

## License

Copyright © 2014 cotarmanach
Distributed under the Q Public License either version 1.0.
