(ns {{namespace}}-test
  (:require [clojure.test :refer :all]
            [com.stuartsierra.component :as component]
            [{{ns-prefix}}.system :as system]
            [clj-http.client :as http]
            [cheshire.core :as json]))

(def ^:dynamic *scheme* "http")
(def ^:dynamic *host*)
(def ^:dynamic *port*)

(defn add-domain [request-path]
  (str *scheme* "://" *host* ":" *port* request-path))

(defn with-system [f]
  (let [system (system/new-system {:env :test})]
    (binding [*host* (-> system :http :pedestal :specs :io.pedestal.http/host)
              *port* (-> system :http :pedestal :specs :io.pedestal.http/port)]
      (component/start system)
      (f)
      (component/stop system))))

(use-fixtures :once with-system)

(deftest hello-world-test
  (testing "FIXME, I fail."
    (let [response (http/get (add-domain "/"))]
      (is (= 200 (:status response)))
      (is (= (:body response)
             nil)))))
