(ns {{namespace}}
  (:require [io.pedestal.http.route.definition :refer [expand-routes]]            
            [pedestal-api.core :as api]
            [pedestal-api.helpers :as api.h]
            [schema.core :as s]))

(def hello-world
  (api.h/handler
   ::hello-world
   {:responses  {200 {:body s/Str}}}
   (fn [request]
     {:status 200
      :body "Hello World"})))

(defn service-{{name}} [component]
  (s/with-fn-validation
    (expand-routes
     `[[["/" ^:interceptors [(api/negotiate-response)]
         {:get hello-world}]]])))
