{{=<< >>=}}
(ns dev
  (:refer-clojure :exclude [test])
  (:require [clojure.repl :refer :all]
            [clojure.pprint :as pp]
            [clojure.tools.namespace.repl :refer [refresh]]
            [reloaded.repl :refer [system init start stop go reset]]
            [eftest.runner :as eftest]
            [com.stuartsierra.component :as component]            
            [io.pedestal.http :as server]
            [crafty.generate :as gen]
            [<<namespace>>.system :as system]))

(gen/set-ns-prefix '<<namespace>>)

(defn test []
  (eftest/run-tests (eftest/find-tests "test") {:multithread? false}))

(def dev-config
  {:env :dev
   :pedestal
   {:specs {:io.pedestal.http/allowed-origins 
            {:creds true
             :allowed-origins (constantly true)}}
    :interceptors [server/default-interceptors
                   server/dev-interceptors]}})

(defn new-system []
  (into (system/new-system dev-config)
        {}))

(reloaded.repl/set-init! new-system)
