(ns {{namespace}}.service.example-test
  (:require [clojure.test :refer :all]
            [com.stuartsierra.component :as component]
            [{{namespace}}.system :as system]
            [clj-http.client :as http]
            [cheshire.core :as json]))

(def ^:dynamic *scheme* "http")
(def ^:dynamic *host*)
(def ^:dynamic *port*)

(defn add-domain [request-path]
  (str *scheme* "://" *host* ":" *port* request-path))

(defn with-system [f]
  (let [system (system/new-system {:env :test})]
    (binding [*host* (-> system :http :pedestal :specs :io.pedestal.http/host)
              *port* (-> system :http :pedestal :specs :io.pedestal.http/port)]
      (component/start system)
      (f)
      (component/stop system))))

(use-fixtures :once with-system)

(deftest plus-test
  (testing "plus normal behavior"
    (let [response (http/get (add-domain "/api/plus?x=1&y=2"))]
      (is (= 200 (:status response)))
      (is (= (json/parse-string (:body response) true)
             {:res 3})))))

(deftest pizza-test
  (testing "echo normal behavior"
      (let [pizza (json/generate-string
                   {:name "La Speciale du Chef"
                    :size :L
                    :origin {:country :FI
                             :city "Tokyo"}})
            response (http/post (add-domain "/api/echo")
                                {:body pizza
                                 :headers {"Content-Type" "application/json"}})]
        (is (= 200 (:status response)))
        (is (= (:body response)
               pizza)))))
