{{=<< >>=}}
(ns <<namespace>>.service.example
  (:require [io.pedestal.http.route.definition :refer [expand-routes]]            
            [pedestal-api.core :as api]
            [pedestal-api.helpers :as api.h]
            [schema.core :as s]))

(s/defschema Pizza
  {:name s/Str
   (s/optional-key :description) s/Str
   :size (s/enum :L :M :S)
   :origin {:country (s/enum :IT :FR :UK)
            :city s/Str}})

(def echo
  (api.h/handler
   ::echo
   {:summary "echoes a pizza"
    :parameters {:body-params Pizza}
    :responses {200 {:body Pizza}}
    :operationId :echo}
   (fn [request]
     (let [pizza (:body-params request)]
       {:status 200
        :body pizza}))))

(def plus 
  (api.h/handler
   ::plus
   {:summary "add two numbers"
    :parameters {:query-params {:x s/Num, :y s/Num}}
    :responses  {200 {:body {:res s/Num}}}
    :operationId :plus}
   (fn [request]
     (let [{{x :x, y :y} :query-params} request]
       {:status 200
        :body {:res (+ x y)}}))))

(defn service-example [component]
  (s/with-fn-validation
    (expand-routes
     `[[["/" ^:interceptors [(api/negotiate-response)
                             api/error-responses
                             (api/body-params)
                             api/common-body
                             (api/coerce-request)
                             (api/validate-response)]           
         ["/api" ^:interceptors [(api/doc {:tags ["api"]})]
          ["/plus" {:get plus}]
          ["/echo" {:post echo}]]
         ]]])))
