{{=<< >>=}}
(ns <<namespace>>.system
  (:require [com.stuartsierra.component :as component]
            [crafty.component.service :refer [service-component]]
            [crafty.component.pedestal :refer [pedestal-server]]
            [cprop.core :refer [load-config]]
            [cprop.source :refer [from-file from-env]]<<#example?>>
            [<<namespace>>.service.example :refer [service-example]]<</example?>>))

(defn merge-configs [conf-from-app]
  (let [env (name (or (:env conf-from-app)
                      (throw (IllegalArgumentException. ":env is missing"))))]
    (load-config :file "config/defaults.edn"
                 :merge [conf-from-app
                         (from-file (str "config/" env ".edn"))
                         (from-env)])))

<<#example?>>
(defn add-swagger-doc [config]
  (assoc-in 
   config
   [:pedestal :swagger :swagger-doc]
   {:swagger "2.0"
    :info {:title "Simple demo"
           :version "0.1.0"
           :description "Crafty API example"}
    :tags [{:name "api" :description "Some apis"}]}))<</example?>>

(defn new-system [config]
  (let [config (-> config merge-configs <<#example?>>add-swagger-doc<</example?>>)]
    (-> (component/system-map
         :http (pedestal-server (:pedestal config))<<#example?>>
         :example (service-component service-example)<</example?>>)
        (component/system-using
         {:http [<<#example?>>:example<</example?>>]<<#example?>>
          :example []<</example?>>}))))
