# {{name}}

FIXME: description

## Deploying

Build an uberjar:

```sh
lein uberjar
```

Configure and run:

```sh
export ENV=pro
nohup java -jar target/uberjar/{{name}}-{{version}}-standalone.jar &>2 /dev/null &
```

Note that `ENV` will specify the configuration file `config/${ENV}.edn`

## Developing

### Environment

To begin developing, start with a REPL.

```sh
lein repl
```

Then load the development environment.

```clojure
user=> (dev)
:loaded
```

Run `go` to initiate and start the system.

```clojure
dev=> (go)
:started
```

By default this creates a web server at <http://localhost:3000> as 
defined in `config/dev.edn`.

When you make changes to your source files, use `reset` to reload any
modified files and reset the server.

```clojure
dev=> (reset)
:reloading (...)
:resumed
```

### Testing

By defaults **services** tests will use a fixture to instantiate
local **systems**, including a webserver at <http://localhost:3001>.
You can change this in `config/test.edn`.

Testing is fastest through the REPL, as you avoid environment startup
time.

```clojure
dev=> (test)
...
```

But you can also run tests through Leiningen.

```sh
lein test
```

### Generators

This project has generator functions to help you create files.

To create a new component:

```clojure
dev=> (gen/component "baz")
Creating file src/foo/component/baz.clj
Creating file test/foo/component/baz_test.clj
nil
```

To create a new service:

```clojure
dev=> (gen/service "bar")
Creating file src/foo/service/bar.clj
Creating file test/foo/service/bar_test.clj
nil
```

### Swagger

**Services** use annotated handlers to generate swagger documentation.
More details can be found at [Pedestal API][pedestal-api].

Moreover `swagger-json` and `swagger-ui` routes can be customized in the
configuration files. If not defined they won't be available.  

[pedestal-api]: https://github.com/oliyh/pedestal-api

## Legal

Copyright © {{year}} FIXME
