(ns {{namespace}}.main
  (:gen-class)
  (:require
   [com.stuartsierra.component :as component]
   [io.pedestal.http :as server]
   [clojure.tools.logging :as log]
   [crafty.util.runtime :refer [add-shutdown-hook]]
   [{{namespace}}.system :refer [new-system]]))

(def prod-config
  {:{{name}}-env :pro
   :pedestal
   {:interceptors [server/default-interceptors]}})

(defn -main [& args]
  (let [system (new-system prod-config)]
    (log/info "Starting HTTP server on port"
              (-> system :http :pedestal :specs ::server/port))
    (add-shutdown-hook ::stop-system #(component/stop system))
    (component/start system)))
