{{=<< >>=}}
(ns <<namespace>>.service.example
  (:require
   [io.pedestal.http.route :refer [expand-routes]]            
   [pedestal-api.core :as api]
   [pedestal-api.helpers :as api.h]
   [schema.core :as s]))

(s/defschema Pizza
  {:name s/Str
   (s/optional-key :description) s/Str
   :size (s/enum :L :M :S)
   :origin {:country (s/enum :IT :FR :UK)
            :city s/Str}})

(defn h-echo [component]
  (api.h/handler
   ::h-echo
   {:summary "echoes a pizza"
    :parameters {:body-params Pizza}
    :responses {200 {:body Pizza}}
    :operationId :echo}
   (fn [request]
     (let [pizza (:body-params request)]
       {:status 200
        :body pizza}))))

(defn h-plus [component] 
  (api.h/handler
   ::h-plus
   {:summary "add two numbers"
    :parameters {:query-params {:x s/Num, :y s/Num}}
    :responses  {200 {:body {:res s/Num}}}
    :operationId :plus}
   (fn [request]
     (let [{{x :x, y :y} :query-params} request]
       {:status 200
        :body {:res (+ x y)}}))))

(defn service-example [component]
  (let [handler-echo (h-echo component)
        handler-plus (h-plus component)]
    (s/with-fn-validation
      (expand-routes
       `[[["/" ^:interceptors [(api/negotiate-response)
                               api/error-responses
                               (api/body-params)
                               api/common-body
                               (api/coerce-request)
                               (api/validate-response)]           
           ["/api" ^:interceptors [(api/doc {:tags ["api"]})]
            ["/plus" {:get  ~handler-plus}]
            ["/echo" {:post ~handler-echo}]]
           ]]]))))
