(ns leiningen.crane
  "deploy."
  (:use [leiningen.compile :only [eval-in-project]]
        [leiningen.classpath :only [make-path get-classpath]])
  (:import java.io.File))

(defn crane-path [project]
  (str (:root project) File/separator "crane"))

(defn crane [project & args]
  (let [updated-classpath (-> (get-classpath project)
                              (conj (crane-path project)))
        crane-on-classpath (fn [java]
                             (.setClasspath java
                                            (apply make-path updated-classpath)))]
    (eval-in-project project
                     `(do
                        (let [deploy-ns# "deploy"]
                          (require 'deploy)
                          (dorun (map
                                  (fn [x#] ((ns-resolve (symbol deploy-ns#) (symbol x#))))
                                  [~@args]))))
                     crane-on-classpath)))